/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.File;
import java.io.Serializable;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.jdbc.HttpBasicAuthInterceptor;
import org.apache.hive.service.Service;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.ServerMode$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.util.Utils$;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005}ba\u0002\n\u0014!\u0003\r\t\u0001\t\u0005\u0006W\u0001!\t\u0001\f\u0005\ng\u0001\u0001\r\u00111A\u0005\nQB\u0011\"\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001e\t\u000fu\u0002\u0001\u0019!C\u0005}!9!\t\u0001a\u0001\n\u0013\u0019\u0005bB#\u0001\u0005\u0004%\tB\u0012\u0005\u0006\u001f\u00021\t\u0001\u0015\u0005\u00063\u0002!\t\u0005\f\u0005\u00065\u0002!\t\u0005\f\u0005\u00067\u0002!\t\u0002\u0018\u0005\u0006Q\u0002!\t\u0002\u0018\u0005\u0006S\u0002!\tB\u001b\u0005\u0006q\u0002!\t\"\u001f\u0005\n\u0003/\u0001\u0011\u0013!C\t\u00033Aq!a\f\u0001\t\u0013\t\t\u0004C\u0007\u00028\u0001\u0001\n1!A\u0001\n\u0013a\u0013\u0011\b\u0005\u000e\u0003w\u0001\u0001\u0013aA\u0001\u0002\u0013%A&!\u0010\u0003%MC\u0017M]3e)\"\u0014\u0018N\u001a;TKJ4XM\u001d\u0006\u0003)U\tA\u0002\u001e5sS\u001a$8/\u001a:wKJT!AF\f\u0002\t!Lg/\u001a\u0006\u00031e\t1a]9m\u0015\tQ2$A\u0003ta\u0006\u00148N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0005*\u0003C\u0001\u0012$\u001b\u0005I\u0012B\u0001\u0013\u001a\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011a%K\u0007\u0002O)\u0011\u0001fF\u0001\u0005i\u0016\u001cH/\u0003\u0002+O\t\u00112\u000b[1sK\u0012\u001c\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019!\u0013N\\5uIQ\tQ\u0006\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0003V]&$\u0018a\u00035jm\u0016\u001cVM\u001d<feJ*\u0012!\u000e\t\u0003m]j\u0011aE\u0005\u0003qM\u0011\u0011\u0003S5wKRC'/\u001b4u'\u0016\u0014h/\u001a:3\u0003=A\u0017N^3TKJ4XM\u001d\u001a`I\u0015\fHCA\u0017<\u0011\u001da4!!AA\u0002U\n1\u0001\u001f\u00132\u0003)\u0019XM\u001d<feB{'\u000f^\u000b\u0002\u007fA\u0011a\u0006Q\u0005\u0003\u0003>\u00121!\u00138u\u00039\u0019XM\u001d<feB{'\u000f^0%KF$\"!\f#\t\u000fq*\u0011\u0011!a\u0001\u007f\u0005qA/Z7q'\u000e\u0014\u0018\r^2i\t&\u0014X#A$\u0011\u0005!kU\"A%\u000b\u0005)[\u0015AA5p\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT%\u0003\t\u0019KG.Z\u0001\u0005[>$W-F\u0001R!\t\u0011VK\u0004\u00027'&\u0011AkE\u0001\u000b'\u0016\u0014h/\u001a:N_\u0012,\u0017B\u0001,X\u0005\u00151\u0016\r\\;f\u0013\tAvFA\u0006F]VlWM]1uS>t\u0017!\u00032fM>\u0014X-\u00117m\u0003!\tg\r^3s\u00032d\u0017a\u00026eE\u000e,&/[\u000b\u0002;B\u0011a,\u001a\b\u0003?\u000e\u0004\"\u0001Y\u0018\u000e\u0003\u0005T!AY\u0010\u0002\rq\u0012xn\u001c;?\u0013\t!w&\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u0014aa\u0015;sS:<'B\u000130\u0003\u0011)8/\u001a:\u0002#]LG\u000f\u001b&eE\u000e\u001cF/\u0019;f[\u0016tG\u000f\u0006\u0002.W\")A\u000e\u0004a\u0001[\u0006\u0011am\u001d\t\u0004]9\u0004\u0018BA80\u0005)a$/\u001a9fCR,GM\u0010\t\u0005]E\u001cX&\u0003\u0002s_\tIa)\u001e8di&|g.\r\t\u0003iZl\u0011!\u001e\u0006\u00031-K!a^;\u0003\u0013M#\u0018\r^3nK:$\u0018\u0001F<ji\"\u001cE*S*feZL7-Z\"mS\u0016tG\u000fF\u0002{\u0003'!\"!L>\t\u000bql\u0001\u0019A?\u0002\u0003\u0019\u0004BAL9\u007f[A\u0019q0a\u0004\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\ta\u0001\u001e5sS\u001a$(\u0002BA\u0004\u0003\u0013\t1a\u00197j\u0015\u0011\tY!!\u0004\u0002\u000fM,'O^5dK*\u0011acG\u0005\u0005\u0003#\t\tA\u0001\fUQJLg\r^\"M\u0013N+'O^5dK\u000ec\u0017.\u001a8u\u0011!\t)\"\u0004I\u0001\u0002\u0004i\u0016\u0001C;tKJt\u0017-\\3\u0002=]LG\u000f[\"M\u0013N+'O^5dK\u000ec\u0017.\u001a8uI\u0011,g-Y;mi\u0012\nTCAA\u000eU\ri\u0016QD\u0016\u0003\u0003?\u0001B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011F\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002.\u0005\r\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\t2\u000f^1siRC'/\u001b4u'\u0016\u0014h/\u001a:\u0015\u00075\n\u0019\u0004\u0003\u0004\u00026=\u0001\raP\u0001\bCR$X-\u001c9u\u0003=\u0019X\u000f]3sI\t,gm\u001c:f\u00032d\u0017BA-*\u00039\u0019X\u000f]3sI\u00054G/\u001a:BY2L!AW\u0015")
public interface SharedThriftServer
extends SharedSparkSession {
    public void org$apache$spark$sql$hive$thriftserver$SharedThriftServer$_setter_$tempScratchDir_$eq(File var1);

    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$super$beforeAll();

    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$super$afterAll();

    public HiveThriftServer2 org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$hiveServer2();

    public void org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$hiveServer2_$eq(HiveThriftServer2 var1);

    public int org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$serverPort();

    public void org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$serverPort_$eq(int var1);

    public File tempScratchDir();

    public Enumeration.Value mode();

    public static /* synthetic */ void beforeAll$(SharedThriftServer $this) {
        $this.beforeAll();
    }

    default public void beforeAll() {
        this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$super$beforeAll();
        ((Try)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).foldLeft((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.startThriftServer(0)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> SharedThriftServer.$anonfun$beforeAll$2(this, x0$1, BoxesRunTime.unboxToInt((Object)x1$1)))).recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    throw A12;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable != null;
            }
        }).get();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> "HiveThriftServer2 started successfully");
    }

    public static /* synthetic */ void afterAll$(SharedThriftServer $this) {
        $this.afterAll();
    }

    default public void afterAll() {
        try {
            if (this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$hiveServer2() != null) {
                this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$hiveServer2().stop();
            }
        }
        finally {
            this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$super$afterAll();
            SessionState.detachSession();
            Hive.closeCurrent();
        }
    }

    public static /* synthetic */ String jdbcUri$(SharedThriftServer $this) {
        return $this.jdbcUri();
    }

    default public String jdbcUri() {
        Enumeration.Value value = this.mode();
        Enumeration.Value value2 = ServerMode$.MODULE$.http();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            return new StringBuilder(70).append("jdbc:hive2://localhost:").append(this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$serverPort()).append("/default;transportMode=http;httpPath=cliservice").toString();
        }
        return new StringBuilder(24).append("jdbc:hive2://localhost:").append(this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$serverPort()).append("/").toString();
    }

    public static /* synthetic */ String user$(SharedThriftServer $this) {
        return $this.user();
    }

    default public String user() {
        return System.getProperty("user.name");
    }

    public static /* synthetic */ void withJdbcStatement$(SharedThriftServer $this, Seq fs) {
        $this.withJdbcStatement((Seq<Function1<Statement, BoxedUnit>>)fs);
    }

    default public void withJdbcStatement(Seq<Function1<Statement, BoxedUnit>> fs) {
        Predef$.MODULE$.require(this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$serverPort() != 0, (Function0 & Serializable & scala.Serializable)() -> "Failed to bind an actual port for HiveThriftServer2");
        Seq connections = (Seq)fs.map((Function1 & Serializable & scala.Serializable)x$1 -> DriverManager.getConnection(this.jdbcUri(), this.user(), ""), Seq$.MODULE$.canBuildFrom());
        Seq statements = (Seq)connections.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.createStatement(), Seq$.MODULE$.canBuildFrom());
        try {
            ((IterableLike)statements.zip(fs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                SharedThriftServer.$anonfun$withJdbcStatement$4(x0$1);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            statements.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.close();
                return BoxedUnit.UNIT;
            });
            connections.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.close();
                return BoxedUnit.UNIT;
            });
        }
    }

    public static /* synthetic */ void withCLIServiceClient$(SharedThriftServer $this, String username, Function1 f) {
        $this.withCLIServiceClient(username, (Function1<ThriftCLIServiceClient, BoxedUnit>)f);
    }

    default public void withCLIServiceClient(String username, Function1<ThriftCLIServiceClient, BoxedUnit> f) {
        TTransport tTransport;
        Predef$.MODULE$.require(this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$serverPort() != 0, (Function0 & Serializable & scala.Serializable)() -> "Failed to bind an actual port for HiveThriftServer2");
        Enumeration.Value value = this.mode();
        Enumeration.Value value2 = ServerMode$.MODULE$.binary();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            TSocket rawTransport = new TSocket("localhost", this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$serverPort());
            tTransport = PlainSaslHelper.getPlainTransport((String)username, (String)"anonymous", (TTransport)rawTransport);
        } else {
            Enumeration.Value value4 = ServerMode$.MODULE$.http();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                HttpBasicAuthInterceptor interceptor = new HttpBasicAuthInterceptor(username, "anonymous", null, null, true, new HashMap());
                tTransport = new THttpClient(new StringBuilder(28).append("http://localhost:").append(this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$serverPort()).append("/cliservice").toString(), (HttpClient)HttpClientBuilder.create().addInterceptorFirst((HttpRequestInterceptor)interceptor).build());
            } else {
                throw new MatchError((Object)value);
            }
        }
        TTransport transport = tTransport;
        TBinaryProtocol protocol = new TBinaryProtocol(transport);
        ThriftCLIServiceClient client = new ThriftCLIServiceClient((TCLIService.Iface)new TCLIService.Client((TProtocol)protocol));
        transport.open();
        try {
            f.apply((Object)client);
        }
        finally {
            transport.close();
        }
    }

    public static /* synthetic */ String withCLIServiceClient$default$1$(SharedThriftServer $this) {
        return $this.withCLIServiceClient$default$1();
    }

    default public String withCLIServiceClient$default$1() {
        return this.user();
    }

    private void startThriftServer(int attempt) {
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Trying to start HiveThriftServer2: mode=").append(this.mode()).append(", attempt=").append(attempt).toString());
        SQLContext sqlContext = this.spark().newSession().sqlContext();
        sqlContext.setConf(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT.varname, "0");
        sqlContext.setConf(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT.varname, "0");
        sqlContext.setConf(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE.varname, this.mode().toString());
        sqlContext.setConf(HiveConf.ConfVars.SCRATCHDIR.varname, this.tempScratchDir().getAbsolutePath());
        sqlContext.setConf(HiveConf.ConfVars.HIVE_START_CLEANUP_SCRATCHDIR.varname, "true");
        try {
            this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$hiveServer2_$eq(HiveThriftServer2$.MODULE$.startWithContext(sqlContext));
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$hiveServer2().getServices()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                SharedThriftServer.$anonfun$startThriftServer$2(this, attempt, x0$1);
                return BoxedUnit.UNIT;
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.tempScratchDir().exists(), "SharedThriftServer.this.tempScratchDir.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SharedThriftServer.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds())), this.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<Function1<Statement, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.execute("SELECT 1");
                return BoxedUnit.UNIT;
            }})), Retrying$.MODULE$.retryingNatureOfT(), new Position("SharedThriftServer.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        }
        catch (Exception e) {
            this.logError((Function0 & Serializable & scala.Serializable)() -> "Error start hive server with Context ", e);
            if (this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$hiveServer2() != null) {
                this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$hiveServer2().stop();
                this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$hiveServer2_$eq(null);
            }
            SessionState.detachSession();
            Hive.closeCurrent();
            throw e;
        }
    }

    public static /* synthetic */ Try $anonfun$beforeAll$2(SharedThriftServer $this, Try x0$1, int x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToInteger((int)x1$1));
        if (tuple2 != null) {
            Try started = (Try)tuple2._1();
            int attempt = tuple2._2$mcI$sp();
            return started.orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.startThriftServer(attempt)));
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ void $anonfun$withJdbcStatement$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Statement s = (Statement)tuple2._1();
            Function1 f = (Function1)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)f.apply((Object)s);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ void $anonfun$startThriftServer$2(SharedThriftServer $this, int attempt$2, Service x0$1) {
        Service service = x0$1;
        if (service instanceof ThriftCLIService) {
            ThriftCLIService thriftCLIService = (ThriftCLIService)service;
            $this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$serverPort_$eq(thriftCLIService.getPortNumber());
            $this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Started HiveThriftServer2: mode=").append($this.mode()).append(", port=").append($this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$serverPort()).append(", attempt=").append(attempt$2).toString());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void $init$(SharedThriftServer $this) {
        void var1_1;
        $this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$$serverPort_$eq(0);
        File dir = Utils$.MODULE$.createTempDir();
        dir.setWritable(true, false);
        Utils$.MODULE$.createTempDir(dir.getAbsolutePath(), Utils$.MODULE$.createTempDir$default$2());
        $this.org$apache$spark$sql$hive$thriftserver$SharedThriftServer$_setter_$tempScratchDir_$eq((File)var1_1);
    }
}

