/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.AddResourceProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.DeleteResourceProcessor;
import org.apache.hadoop.hive.ql.processors.ListResourceProcessor;
import org.apache.hadoop.hive.ql.processors.ResetProcessor;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.apache.spark.ErrorMessageFormat$;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkThrowableHelper$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.apache.spark.util.SparkExitCode$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@ScalaSignature(bytes="\u0006\u0001\u0005EwA\u0002\u0014(\u0011\u0003I3G\u0002\u00046O!\u0005\u0011F\u000e\u0005\u0006\u0007\u0006!\t!\u0012\u0005\b\r\u0006\u0011\r\u0011\"\u0003H\u0011\u0019\u0001\u0016\u0001)A\u0005\u0011\"9\u0011+\u0001b\u0001\n\u0013\u0011\u0006BB/\u0002A\u0003%1\u000bC\u0005_\u0003\u0001\u0007\t\u0019!C\u0005?\"Iq-\u0001a\u0001\u0002\u0004%I\u0001\u001b\u0005\n]\u0006\u0001\r\u0011!Q!\n\u0001Dqa\\\u0001C\u0002\u00135\u0001\u000f\u0003\u0004u\u0003\u0001\u0006i!\u001d\u0005\bk\u0006\u0001\r\u0011\"\u0003w\u0011\u001dQ\u0018\u00011A\u0005\nmDa!`\u0001!B\u00139\b\"\u0002@\u0002\t\u0003y\bbBA\u0001\u0003\u0011\u0005\u00111\u0001\u0005\b\u0003\u0013\tA\u0011AA\u0006\u0011\u001d\t9\"\u0001C\u0001\u00033Aa!a\u000e\u0002\t\u0003y\bbBA\u001d\u0003\u0011%\u00111\b\u0004\u0007k\u001d\u0002\u0011&a\u0014\t\r\r+B\u0011AA,\u0011%\tY&\u0006b\u0001\n\u0013\ti\u0006\u0003\u0005\u0002`U\u0001\u000b\u0011BA\u0013\u0011%\t\t'\u0006b\u0001\n\u0013\t\u0019\u0007\u0003\u0005\u0002rU\u0001\u000b\u0011BA3\u0011%\t\u0019(\u0006b\u0001\n\u0013\t)\b\u0003\u0005\u0002\u0006V\u0001\u000b\u0011BA<\u0011%\t9\"\u0006b\u0001\n\u0013\t9\t\u0003\u0005\u0002\nV\u0001\u000b\u0011BA\u000e\u0011%\tY)\u0006b\u0001\n\u0013\ti\t\u0003\u0005\u0002\u001aV\u0001\u000b\u0011BAH\u0011\u001d\tY*\u0006C!\u0003;Ca!a,\u0016\t\u0003y\bbBAY+\u0011\u0005\u00131\u0017\u0005\b\u0003s+B\u0011IA^\u0011!\t)-\u0006C\u0001S\u0005\u001d\u0017!E*qCJ\\7+\u0015'D\u0019&#%/\u001b<fe*\u0011\u0001&K\u0001\ri\"\u0014\u0018N\u001a;tKJ4XM\u001d\u0006\u0003U-\nA\u0001[5wK*\u0011A&L\u0001\u0004gFd'B\u0001\u00180\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\u0011\u0005Q\nQ\"A\u0014\u0003#M\u0003\u0018M]6T#2\u001bE*\u0013#sSZ,'oE\u0002\u0002ou\u0002\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012a!\u00118z%\u00164\u0007C\u0001 B\u001b\u0005y$B\u0001!.\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\"@\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002g\u00051\u0001O]8naR,\u0012\u0001\u0013\t\u0003\u0013:k\u0011A\u0013\u0006\u0003\u00172\u000bA\u0001\\1oO*\tQ*\u0001\u0003kCZ\f\u0017BA(K\u0005\u0019\u0019FO]5oO\u00069\u0001O]8naR\u0004\u0013aD2p]RLg.^3e!J|W\u000e\u001d;\u0016\u0003M\u0003\"\u0001V.\u000f\u0005UK\u0006C\u0001,:\u001b\u00059&B\u0001-E\u0003\u0019a$o\\8u}%\u0011!,O\u0001\u0007!J,G-\u001a4\n\u0005=c&B\u0001.:\u0003A\u0019wN\u001c;j]V,G\r\u0015:p[B$\b%A\u0005ue\u0006t7\u000f]8siV\t\u0001\r\u0005\u0002bK6\t!M\u0003\u0002_G*\u0011AmL\u0001\u0007i\"\u0014\u0018N\u001a;\n\u0005\u0019\u0014'a\u0002+T_\u000e\\W\r^\u0001\u000eiJ\fgn\u001d9peR|F%Z9\u0015\u0005%d\u0007C\u0001\u001dk\u0013\tY\u0017H\u0001\u0003V]&$\bbB7\t\u0003\u0003\u0005\r\u0001Y\u0001\u0004q\u0012\n\u0014A\u0003;sC:\u001c\bo\u001c:uA\u0005A2\u000bU!S\u0017~C\u0015\tR(P!~\u0003&k\u0014)`!J+e)\u0013-\u0016\u0003E|\u0011A]\u0011\u0002g\u0006i1\u000f]1sW:B\u0017\rZ8pa:\n\u0011d\u0015)B%.{\u0006*\u0011#P\u001fB{\u0006KU(Q?B\u0013VIR%YA\u0005AQ\r_5u\u0007>$W-F\u0001x!\tA\u00040\u0003\u0002zs\t\u0019\u0011J\u001c;\u0002\u0019\u0015D\u0018\u000e^\"pI\u0016|F%Z9\u0015\u0005%d\bbB7\u000e\u0003\u0003\u0005\ra^\u0001\nKbLGoQ8eK\u0002\nA#\u001b8ti\u0006dGnU5h]\u0006d\u0007*\u00198eY\u0016\u0014H#A5\u0002\t\u0015D\u0018\u000e\u001e\u000b\u0004S\u0006\u0015\u0001BBA\u0004!\u0001\u0007q/\u0001\u0003d_\u0012,\u0017\u0001B7bS:$2![A\u0007\u0011\u001d\ty!\u0005a\u0001\u0003#\tA!\u0019:hgB!\u0001(a\u0005T\u0013\r\t)\"\u000f\u0002\u0006\u0003J\u0014\u0018-_\u0001\rSN\u0014V-\\8uK6{G-\u001a\u000b\u0005\u00037\t\t\u0003E\u00029\u0003;I1!a\b:\u0005\u001d\u0011un\u001c7fC:Dq!a\t\u0013\u0001\u0004\t)#A\u0003ti\u0006$X\r\u0005\u0003\u0002(\u0005MRBAA\u0015\u0015\u0011\tY#!\f\u0002\u0007\rd\u0017NC\u0002+\u0003_Q1!!\r0\u0003\u0019A\u0017\rZ8pa&!\u0011QGA\u0015\u0005=\u0019E.[*fgNLwN\\*uCR,\u0017A\u00039sS:$Xk]1hK\u0006q2\r\\8tK\"Kg/Z*fgNLwN\\*uCR,\u0017JZ*uCJ$X\r\u001a\u000b\u0004S\u0006u\u0002bBA\u0012)\u0001\u0007\u0011q\b\t\u0005\u0003\u0003\nY%\u0004\u0002\u0002D)!\u0011QIA$\u0003\u001d\u0019Xm]:j_:TA!!\u0013\u0002.\u0005\u0011\u0011\u000f\\\u0005\u0005\u0003\u001b\n\u0019E\u0001\u0007TKN\u001c\u0018n\u001c8Ti\u0006$Xm\u0005\u0003\u0016\u0003#j\u0004\u0003BA\u0014\u0003'JA!!\u0016\u0002*\tI1\t\\5Ee&4XM\u001d\u000b\u0003\u00033\u0002\"\u0001N\u000b\u0002\u0019M,7o]5p]N#\u0018\r^3\u0016\u0005\u0005\u0015\u0012!D:fgNLwN\\*uCR,\u0007%A\u0002M\u001f\u001e+\"!!\u001a\u0011\t\u0005\u001d\u0014QN\u0007\u0003\u0003SR1!a\u001b2\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\ty'!\u001b\u0003\r1{wmZ3s\u0003\u0011auj\u0012\u0011\u0002\u000f\r|gn]8mKV\u0011\u0011q\u000f\t\u0005\u0003s\nyH\u0004\u0003\u0002B\u0005m\u0014\u0002BA?\u0003\u0007\nAbU3tg&|gn\u0015;bi\u0016LA!!!\u0002\u0004\nIAj\\4IK2\u0004XM\u001d\u0006\u0005\u0003{\n\u0019%\u0001\u0005d_:\u001cx\u000e\\3!+\t\tY\"A\u0007jgJ+Wn\u001c;f\u001b>$W\rI\u0001\u0005G>tg-\u0006\u0002\u0002\u0010B!\u0011\u0011SAK\u001b\t\t\u0019J\u0003\u0003\u0002\f\u0006=\u0012\u0002BAL\u0003'\u0013QbQ8oM&<WO]1uS>t\u0017!B2p]\u001a\u0004\u0013\u0001E:fi\"Kg/\u001a,be&\f'\r\\3t)\rI\u0017q\u0014\u0005\b\u0003C\u000b\u0003\u0019AAR\u00035A\u0017N^3WCJL\u0017M\u00197fgB1\u0011QUAV'Nk!!a*\u000b\u0007\u0005%F*\u0001\u0003vi&d\u0017\u0002BAW\u0003O\u00131!T1q\u0003M\u0001(/\u001b8u\u001b\u0006\u001cH/\u001a:B]\u0012\f\u0005\u000f]%e\u0003)\u0001(o\\2fgN\u001cU\u000e\u001a\u000b\u0004o\u0006U\u0006BBA\\G\u0001\u00071+A\u0002d[\u0012\f1\u0002\u001d:pG\u0016\u001c8\u000fT5oKR)q/!0\u0002B\"1\u0011q\u0018\u0013A\u0002M\u000bA\u0001\\5oK\"9\u00111\u0019\u0013A\u0002\u0005m\u0011!E1mY><\u0018J\u001c;feJ,\b\u000f^5oO\u0006q1\u000f\u001d7jiN+W.[\"pY>tG\u0003BAe\u0003\u001f\u0004R!!*\u0002LNKA!!4\u0002(\n!A*[:u\u0011\u0019\ty,\na\u0001'\u0002")
public class SparkSQLCLIDriver
extends CliDriver
implements Logging {
    private final CliSessionState sessionState;
    private final Logger LOG;
    private final SessionState.LogHelper org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console;
    private final boolean isRemoteMode;
    private final Configuration conf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void printUsage() {
        SparkSQLCLIDriver$.MODULE$.printUsage();
    }

    public static void main(String[] stringArray) {
        SparkSQLCLIDriver$.MODULE$.main(stringArray);
    }

    public static void exit(int n) {
        SparkSQLCLIDriver$.MODULE$.exit(n);
    }

    public static void installSignalHandler() {
        SparkSQLCLIDriver$.MODULE$.installSignalHandler();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private CliSessionState sessionState() {
        return this.sessionState;
    }

    private Logger LOG() {
        return this.LOG;
    }

    public SessionState.LogHelper org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console() {
        return this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console;
    }

    private boolean isRemoteMode() {
        return this.isRemoteMode;
    }

    private Configuration conf() {
        return this.conf;
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(hiveVariables).asScala()).foreach((Function1 & Serializable & scala.Serializable)kv -> {
            SparkSQLCLIDriver.$anonfun$setHiveVariables$1(kv);
            return BoxedUnit.UNIT;
        });
    }

    public void printMasterAndAppId() {
        String master = SparkSQLEnv$.MODULE$.sparkContext().master();
        String appId = SparkSQLEnv$.MODULE$.sparkContext().applicationId();
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(new StringBuilder(32).append("Spark master: ").append(master).append(", Application Id: ").append(appId).toString());
    }

    public int processCmd(String cmd) {
        int ret;
        block17: {
            String cmd_trimmed = cmd.trim();
            String cmd_lower = cmd_trimmed.toLowerCase(Locale.ROOT);
            String[] tokens = cmd_trimmed.split("\\s+");
            String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
            if (cmd_lower.equals("quit") || cmd_lower.equals("exit")) {
                SparkSQLCLIDriver$.MODULE$.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$closeHiveSessionStateIfStarted((SessionState)this.sessionState());
                SparkSQLCLIDriver$.MODULE$.exit(SparkExitCode$.MODULE$.EXIT_SUCCESS());
            }
            if (tokens[0].toLowerCase(Locale.ROOT).equals("source") || cmd_trimmed.startsWith("!") || this.isRemoteMode()) {
                long startTimeNs = System.nanoTime();
                super.processCmd(cmd);
                long endTimeNs = System.nanoTime();
                double timeTaken = (double)TimeUnit.NANOSECONDS.toMillis(endTimeNs - startTimeNs) / 1000.0;
                this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(new StringBuilder(20).append("Time taken: ").append(timeTaken).append(" seconds").toString());
                return 0;
            }
            ret = 0;
            HiveConf hconf = (HiveConf)this.conf();
            CommandProcessor proc = CommandProcessorFactory.get((String[])tokens, (HiveConf)hconf);
            if (proc == null) break block17;
            if (proc instanceof Driver || proc instanceof SetProcessor || proc instanceof AddResourceProcessor || proc instanceof ListResourceProcessor || proc instanceof DeleteResourceProcessor || proc instanceof ResetProcessor) {
                SparkSQLDriver driver = new SparkSQLDriver(SparkSQLDriver$.MODULE$.$lessinit$greater$default$1());
                driver.init();
                PrintStream out = this.sessionState().out;
                PrintStream err = this.sessionState().err;
                long startTimeNs = System.nanoTime();
                if (this.sessionState().getIsVerbose()) {
                    out.println(cmd);
                }
                CommandProcessorResponse rc = driver.run(cmd);
                long endTimeNs = System.nanoTime();
                double timeTaken = (double)TimeUnit.NANOSECONDS.toMillis(endTimeNs - startTimeNs) / 1000.0;
                ret = rc.getResponseCode();
                if (ret != 0) {
                    String string;
                    Enumeration.Value format = SparkSQLEnv$.MODULE$.sqlContext().conf().errorMessageFormat();
                    Throwable e = rc.getException();
                    Throwable throwable = e;
                    if (throwable instanceof SparkThrowable) {
                        Throwable throwable2 = throwable;
                        string = SparkThrowableHelper$.MODULE$.getMessage(throwable2, format);
                    } else {
                        string = e.getMessage();
                    }
                    String msg = string;
                    err.println(msg);
                    Enumeration.Value value = format;
                    Enumeration.Value value2 = ErrorMessageFormat$.MODULE$.PRETTY();
                    if (!(value != null ? !value.equals(value2) : value2 != null)) {
                        if (!(this.sessionState().getIsSilent() || e instanceof AnalysisException && e.getCause() == null)) {
                            e.printStackTrace(err);
                        }
                    }
                    driver.close();
                    return ret;
                }
                ArrayList res = new ArrayList();
                if (HiveConf.getBoolVar((Configuration)this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_HEADER) || SparkSQLEnv$.MODULE$.sqlContext().conf().cliPrintHeader()) {
                    Option$.MODULE$.apply((Object)driver.getSchema().getFieldSchemas()).foreach((Function1 & Serializable & scala.Serializable)fields -> {
                        out.println(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), Buffer$.MODULE$.canBuildFrom())).mkString("\t"));
                        return BoxedUnit.UNIT;
                    });
                }
                IntRef counter = IntRef.create((int)0);
                try {
                    while (!out.checkError() && driver.getResults(res)) {
                        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res).asScala()).foreach((Function1 & Serializable & scala.Serializable)l -> {
                            SparkSQLCLIDriver.$anonfun$processCmd$3(counter, out, l);
                            return BoxedUnit.UNIT;
                        });
                        res.clear();
                    }
                }
                catch (IOException e) {
                    this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printError(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("Failed with exception ").append(e.getClass().getName()).append(": ").append(e.getMessage()).append("\n                   |").append(StringUtils.stringifyException((Throwable)e)).append("\n                 ").toString())).stripMargin());
                    ret = 1;
                }
                int cret = driver.close();
                if (ret == 0) {
                    ret = cret;
                }
                String responseMsg = new StringBuilder(20).append("Time taken: ").append(timeTaken).append(" seconds").toString();
                if (counter.elem != 0) {
                    responseMsg = new StringBuilder(17).append(responseMsg).append(", Fetched ").append(counter.elem).append(" row(s)").toString();
                }
                this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(responseMsg, null);
                driver.destroy();
            } else {
                if (this.sessionState().getIsVerbose()) {
                    this.sessionState().out.println(new StringBuilder(1).append(tokens[0]).append(" ").append(cmd_1).toString());
                }
                ret = proc.run(cmd_1).getResponseCode();
            }
        }
        return ret;
    }

    public int processLine(String line, boolean allowInterrupting) {
        int n;
        Object object = new Object();
        try {
            SignalHandler oldSignal = null;
            Signal interruptSignal = null;
            if (allowInterrupting) {
                interruptSignal = new Signal("INT");
                oldSignal = Signal.handle(interruptSignal, new SignalHandler(this){
                    private boolean interruptRequested;
                    private final /* synthetic */ SparkSQLCLIDriver $outer;

                    private boolean interruptRequested() {
                        return this.interruptRequested;
                    }

                    private void interruptRequested_$eq(boolean x$1) {
                        this.interruptRequested = x$1;
                    }

                    public void handle(Signal signal) {
                        boolean initialRequest = !this.interruptRequested();
                        this.interruptRequested_$eq(true);
                        if (!initialRequest) {
                            this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Exiting the JVM");
                            SparkSQLCLIDriver$.MODULE$.exit(SparkExitCode$.MODULE$.ERROR_COMMAND_NOT_FOUND());
                        }
                        this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Interrupting... Be patient, this might take some time.");
                        this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Press Ctrl+C again to kill JVM");
                        HiveInterruptUtils.interrupt();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.interruptRequested = false;
                    }
                });
            }
            try {
                IntRef lastRet = IntRef.create((int)0);
                Buffer commands = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.splitSemiColon(line)).asScala();
                ObjectRef command = ObjectRef.create((Object)"");
                commands.foreach((Function1 & Serializable & scala.Serializable)oneCmd -> {
                    SparkSQLCLIDriver.$anonfun$processLine$1(this, command, lastRet, object, oneCmd);
                    return BoxedUnit.UNIT;
                });
                CommandProcessorFactory.clean((HiveConf)((HiveConf)this.conf()));
                n = lastRet.elem;
            }
            catch (Throwable throwable) {
                if (oldSignal != null && interruptSignal != null) {
                    Signal.handle(interruptSignal, oldSignal);
                }
                throw throwable;
            }
            if (oldSignal != null && interruptSignal != null) {
                Signal.handle(interruptSignal, oldSignal);
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                n = ex.value$mcI$sp();
            }
            throw ex;
        }
        return n;
    }

    public List<String> splitSemiColon(String line) {
        BooleanRef insideSingleQuote = BooleanRef.create((boolean)false);
        BooleanRef insideDoubleQuote = BooleanRef.create((boolean)false);
        BooleanRef insideSimpleComment = BooleanRef.create((boolean)false);
        IntRef bracketedCommentLevel = IntRef.create((int)0);
        BooleanRef escape = BooleanRef.create((boolean)false);
        IntRef beginIndex = IntRef.create((int)0);
        BooleanRef leavingBracketedComment = BooleanRef.create((boolean)false);
        BooleanRef isStatement = BooleanRef.create((boolean)false);
        ArrayList<String> ret = new ArrayList<String>();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), line.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            if (leavingBracketedComment$1.elem) {
                --bracketedCommentLevel$1.elem;
                leavingBracketedComment$1.elem = false;
            }
            if (line.charAt(index) == '\'' && !SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel)) {
                if (!escape$1.elem && !insideDoubleQuote$1.elem) {
                    insideSingleQuote$1.elem = !insideSingleQuote$1.elem;
                }
            } else if (line.charAt(index) == '\"' && !SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel)) {
                if (!escape$1.elem && !insideSingleQuote$1.elem) {
                    insideDoubleQuote$1.elem = !insideDoubleQuote$1.elem;
                }
            } else if (line.charAt(index) == '-') {
                boolean hasNext;
                boolean bl = hasNext = index + 1 < line.length();
                if (!insideDoubleQuote$1.elem && !insideSingleQuote$1.elem && !SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel) && hasNext && line.charAt(index + 1) == '-') {
                    insideSimpleComment$1.elem = true;
                }
            } else if (line.charAt(index) == ';') {
                if (!(insideSingleQuote$1.elem || insideDoubleQuote$1.elem || SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel))) {
                    Object object = isStatement$1.elem ? BoxesRunTime.boxToBoolean((boolean)ret.add(line.substring(beginIndex$1.elem, index))) : BoxedUnit.UNIT;
                    beginIndex$1.elem = index + 1;
                    isStatement$1.elem = false;
                }
            } else if (line.charAt(index) == '\n') {
                if (!escape$1.elem) {
                    insideSimpleComment$1.elem = false;
                }
            } else if (line.charAt(index) == '/' && !insideSimpleComment$1.elem) {
                boolean hasNext;
                boolean bl = hasNext = index + 1 < line.length();
                if (!insideSingleQuote$1.elem && !insideDoubleQuote$1.elem) {
                    if (SparkSQLCLIDriver.insideBracketedComment$1(bracketedCommentLevel) && line.charAt(index - 1) == '*') {
                        leavingBracketedComment$1.elem = true;
                    } else if (hasNext && line.charAt(index + 1) == '*') {
                        ++bracketedCommentLevel$1.elem;
                    }
                }
            }
            if (escape$1.elem) {
                escape$1.elem = false;
            } else if (line.charAt(index) == '\\') {
                escape$1.elem = true;
            }
            isStatement$1.elem = SparkSQLCLIDriver.statementInProgress$1(index, isStatement, beginIndex, line, insideSimpleComment, bracketedCommentLevel);
        });
        boolean endOfBracketedComment = leavingBracketedComment.elem && bracketedCommentLevel.elem == 1;
        Object object = !endOfBracketedComment && (isStatement.elem || SparkSQLCLIDriver.insideBracketedComment$1(bracketedCommentLevel)) ? BoxesRunTime.boxToBoolean((boolean)ret.add(line.substring(beginIndex.elem))) : BoxedUnit.UNIT;
        return ret;
    }

    public static final /* synthetic */ void $anonfun$setHiveVariables$1(Tuple2 kv) {
        SparkSQLEnv$.MODULE$.sqlContext().conf().setConfString((String)kv._1(), (String)kv._2());
    }

    public static final /* synthetic */ void $anonfun$processCmd$3(IntRef counter$1, PrintStream out$1, String l) {
        ++counter$1.elem;
        out$1.println(l);
    }

    public static final /* synthetic */ void $anonfun$processLine$1(SparkSQLCLIDriver $this, ObjectRef command$1, IntRef lastRet$1, Object nonLocalReturnKey1$1, String oneCmd) {
        if (org.apache.commons.lang3.StringUtils.endsWith((CharSequence)oneCmd, (CharSequence)"\\")) {
            command$1.elem = new StringBuilder(1).append((String)command$1.elem).append(org.apache.commons.lang3.StringUtils.chop((String)oneCmd)).append(";").toString();
            return;
        }
        command$1.elem = new StringBuilder(0).append((String)command$1.elem).append(oneCmd).toString();
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)command$1.elem))) {
            int ret = $this.processCmd((String)command$1.elem);
            command$1.elem = "";
            lastRet$1.elem = ret;
            boolean ignoreErrors = HiveConf.getBoolVar((Configuration)$this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.CLIIGNOREERRORS);
            if (ret != 0 && !ignoreErrors) {
                CommandProcessorFactory.clean((HiveConf)((HiveConf)$this.conf()));
                throw new NonLocalReturnControl.mcI.sp(nonLocalReturnKey1$1, ret);
            }
            return;
        }
    }

    private static final boolean insideBracketedComment$1(IntRef bracketedCommentLevel$1) {
        return bracketedCommentLevel$1.elem > 0;
    }

    private static final boolean insideComment$1(BooleanRef insideSimpleComment$1, IntRef bracketedCommentLevel$1) {
        return insideSimpleComment$1.elem || SparkSQLCLIDriver.insideBracketedComment$1(bracketedCommentLevel$1);
    }

    private static final boolean statementInProgress$1(int index, BooleanRef isStatement$1, IntRef beginIndex$1, String line$1, BooleanRef insideSimpleComment$1, IntRef bracketedCommentLevel$1) {
        return isStatement$1.elem || !SparkSQLCLIDriver.insideComment$1(insideSimpleComment$1, bracketedCommentLevel$1) && index > beginIndex$1.elem && !String.valueOf(BoxesRunTime.boxToCharacter((char)line$1.charAt(index))).trim().isEmpty();
    }

    public SparkSQLCLIDriver() {
        Logging.$init$((Logging)this);
        this.sessionState = (CliSessionState)SessionState.get();
        this.LOG = LoggerFactory.getLogger(SparkSQLCLIDriver.class);
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console = new SessionState.LogHelper(this.LOG());
        this.isRemoteMode = SparkSQLCLIDriver$.MODULE$.isRemoteMode(this.sessionState());
        Object object = this.conf = this.sessionState() != null ? this.sessionState().getConf() : new Configuration();
        if (!this.isRemoteMode()) {
            SparkSQLEnv$.MODULE$.init();
            if (this.sessionState().getIsSilent()) {
                SparkSQLEnv$.MODULE$.sparkContext().setLogLevel("warn");
            }
        } else {
            throw QueryExecutionErrors$.MODULE$.remoteOperationsUnsupportedError();
        }
    }
}

