/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.spark.ErrorMessageFormat$;
import org.apache.spark.ProcessTestUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.sql.execution.datasources.v2.jdbc.JDBCTableCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClientImpl$;
import org.apache.spark.sql.hive.test.HiveTestJars$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\n\u0015\u0001\u0005BQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00045\u0001\u0001\u0006I\u0001\f\u0005\bk\u0001\u0011\r\u0011\"\u0001,\u0011\u00191\u0004\u0001)A\u0005Y!9q\u0007\u0001b\u0001\n\u0003Y\u0003B\u0002\u001d\u0001A\u0003%A\u0006C\u0004:\u0001\t\u0007I\u0011A\u0016\t\ri\u0002\u0001\u0015!\u0003-\u0011\u0015Y\u0004\u0001\"\u0011=\u0011\u0015\u0019\u0005\u0001\"\u0011=\u0011\u0015!\u0005\u0001\"\u0001F\u0011!y\b!%A\u0005\u0002\u0005\u0005\u0001\"CA\f\u0001E\u0005I\u0011AA\u0001\u0011%\tI\u0002AI\u0001\n\u0003\tY\u0002C\u0005\u0002 \u0001\t\n\u0011\"\u0001\u0002\"!I\u0011Q\u0005\u0001\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003W\u0001\u0011\u0013!C\u0001\u0003[\u0011\u0001b\u00117j'VLG/\u001a\u0006\u0003+Y\tA\u0002\u001e5sS\u001a$8/\u001a:wKJT!a\u0006\r\u0002\t!Lg/\u001a\u0006\u00033i\t1a]9m\u0015\tYB$A\u0003ta\u0006\u00148N\u0003\u0002\u001e=\u00051\u0011\r]1dQ\u0016T\u0011aH\u0001\u0004_J<7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0013\u000e\u0003iI!!\n\u000e\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002*\u00015\tA#A\u0007xCJ,\u0007n\\;tKB\u000bG\u000f[\u000b\u0002YA\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\u0003S>T\u0011!M\u0001\u0005U\u00064\u0018-\u0003\u00024]\t!a)\u001b7f\u000399\u0018M]3i_V\u001cX\rU1uQ\u0002\nQ\"\\3uCN$xN]3QCRD\u0017AD7fi\u0006\u001cHo\u001c:f!\u0006$\b\u000eI\u0001\u000fg\u000e\u0014\u0018\r^2i\t&\u0014\b+\u0019;i\u0003=\u00198M]1uG\"$\u0015N\u001d)bi\"\u0004\u0013!E:qCJ\\w+\u0019:f\u0011>,8/\u001a#je\u0006\u00112\u000f]1sW^\u000b'/\u001a%pkN,G)\u001b:!\u0003%\u0011WMZ8sK\u0006cG\u000eF\u0001>!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0011)f.\u001b;\u0002\u0011\u00054G/\u001a:BY2\fAB];o\u00072Lw+\u001b;iS:$\u0002B\u0012.e_F480 \u000b\u0003{\u001dCQ\u0001\u0013\u0007A\u0002%\u000b\u0011$];fe&,7/\u00118e\u000bb\u0004Xm\u0019;fI\u0006s7o^3sgB\u0019aH\u0013'\n\u0005-{$A\u0003\u001fsKB,\u0017\r^3e}A!a(T(P\u0013\tquH\u0001\u0004UkBdWM\r\t\u0003!^s!!U+\u0011\u0005I{T\"A*\u000b\u0005Q\u0003\u0013A\u0002\u001fs_>$h(\u0003\u0002W\u007f\u00051\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t1v\bC\u0003\\\u0019\u0001\u0007A,A\u0004uS6,w.\u001e;\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005\u0005|\u0014AC2p]\u000e,(O]3oi&\u00111M\u0018\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0011\u001d)G\u0002%AA\u0002\u0019\f\u0011\"\u001a=ue\u0006\f%oZ:\u0011\u0007\u001ddwJ\u0004\u0002iU:\u0011!+[\u0005\u0002\u0001&\u00111nP\u0001\ba\u0006\u001c7.Y4f\u0013\tigNA\u0002TKFT!a[ \t\u000fAd\u0001\u0013!a\u0001M\u0006qQM\u001d:peJ+7\u000f]8og\u0016\u001c\bb\u0002:\r!\u0003\u0005\ra]\u0001\u000f[\u0006L(-Z,be\u0016Dw.^:f!\rqD\u000fL\u0005\u0003k~\u0012aa\u00149uS>t\u0007bB<\r!\u0003\u0005\r\u0001_\u0001\u0014kN,W\t\u001f;fe:\fG\u000eS5wK\u001aKG.\u001a\t\u0003}eL!A_ \u0003\u000f\t{w\u000e\\3b]\"9A\u0010\u0004I\u0001\u0002\u0004a\u0013!C7fi\u0006\u001cHo\u001c:f\u0011\u001dqH\u0002%AA\u0002=\u000ba\u0001\u001d:p[B$\u0018A\u0006:v]\u000ec\u0017nV5uQ&tG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\r!f\u00014\u0002\u0006-\u0012\u0011q\u0001\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0012}\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)\"a\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\fsk:\u001cE.[,ji\"Lg\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0003Y\u0011XO\\\"mS^KG\u000f[5oI\u0011,g-Y;mi\u0012\"TCAA\u000fU\r\u0019\u0018QA\u0001\u0017eVt7\t\\5XSRD\u0017N\u001c\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u00111\u0005\u0016\u0004q\u0006\u0015\u0011A\u0006:v]\u000ec\u0017nV5uQ&tG\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005%\"f\u0001\u0017\u0002\u0006\u00051\"/\u001e8DY&<\u0016\u000e\u001e5j]\u0012\"WMZ1vYR$s'\u0006\u0002\u00020)\u001aq*!\u0002")
public class CliSuite
extends SparkFunSuite {
    private final File warehousePath = Utils$.MODULE$.createTempDir();
    private final File metastorePath = Utils$.MODULE$.createTempDir();
    private final File scratchDirPath = Utils$.MODULE$.createTempDir();
    private final File sparkWareHouseDir = Utils$.MODULE$.createTempDir();

    public File warehousePath() {
        return this.warehousePath;
    }

    public File metastorePath() {
        return this.metastorePath;
    }

    public File scratchDirPath() {
        return this.scratchDirPath;
    }

    public File sparkWareHouseDir() {
        return this.sparkWareHouseDir;
    }

    public void beforeAll() {
        super.beforeAll();
        this.warehousePath().delete();
        this.metastorePath().delete();
        this.scratchDirPath().delete();
    }

    public void afterAll() {
        try {
            Utils$.MODULE$.deleteRecursively(this.warehousePath());
            Utils$.MODULE$.deleteRecursively(this.metastorePath());
            Utils$.MODULE$.deleteRecursively(this.scratchDirPath());
        }
        finally {
            super.afterAll();
        }
    }

    public void runCliWithin(FiniteDuration timeout, Seq<String> extraArgs, Seq<String> errorResponses, Option<File> maybeWarehouse, boolean useExternalHiveFile, File metastore, String prompt, Seq<Tuple2<String, String>> queriesAndExpectedAnswers) {
        String queriesString = ((TraversableOnce)queriesAndExpectedAnswers.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append((String)x$1._1()).append("\n").toString(), Seq$.MODULE$.canBuildFrom())).mkString();
        Seq expectedAnswers = (Seq)queriesAndExpectedAnswers.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String query = (String)tuple2._1();
                String answer = (String)tuple2._2();
                String string = query;
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return (Seq)new .colon.colon((Object)answer, (List)Nil$.MODULE$);
                }
                List xs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])query.split("\n"))).toList();
                String string3 = new StringBuilder(1).append(prompt).append(" ").append(xs.head()).toString();
                List queryEcho = ((List)((List)xs.tail()).map((Function1 & Serializable & scala.Serializable)l -> new StringBuilder(11).append("         > ").append((String)l).toString(), List$.MODULE$.canBuildFrom())).$colon$colon((Object)string3);
                return (Seq)((SeqLike)queryEcho.map((Function1 & Serializable & scala.Serializable)x$3 -> (String)new StringOps(Predef$.MODULE$.augmentString(x$3)).take(60), List$.MODULE$.canBuildFrom())).$colon$plus((Object)answer, List$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        String extraHive = useExternalHiveFile ? new StringBuilder(41).append("--driver-class-path ").append(System.getProperty("user.dir")).append("/src/test/noclasspath").toString() : "";
        String warehouseConf = (String)maybeWarehouse.map((Function1 & Serializable & scala.Serializable)dir -> new StringBuilder(12).append("--hiveconf ").append(HiveConf.ConfVars.METASTOREWAREHOUSE).append("=").append(dir).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String cliScript = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])"../../bin/spark-sql".split("/"))).mkString(File.separator);
        String jdbcUrl = new StringBuilder(37).append("jdbc:derby:;databaseName=").append(metastore).append(";create=true").toString();
        Seq command = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(312).append(cliScript).append("\n         |  --master local\n         |  --driver-java-options -Dderby.system.durability=test\n         |  ").append(extraHive).append("\n         |  --conf spark.ui.enabled=false\n         |  --conf ").append(SQLConf$.MODULE$.LEGACY_EMPTY_CURRENT_DB_IN_CLI().key()).append("=true\n         |  --hiveconf ").append(HiveConf.ConfVars.METASTORECONNECTURLKEY).append("=").append(jdbcUrl).append("\n         |  --hiveconf ").append(HiveConf.ConfVars.SCRATCHDIR).append("=").append(this.scratchDirPath()).append("\n         |  --hiveconf conf1=conftest\n         |  --hiveconf conf2=1\n         |  ").append(warehouseConf).append("\n       ").toString())).stripMargin().split("\\s+"))).toSeq().$plus$plus(extraArgs, Seq$.MODULE$.canBuildFrom());
        IntRef next = IntRef.create((int)0);
        Promise foundMasterAndApplicationIdMessage = Promise$.MODULE$.apply();
        Promise foundAllExpectedAnswers = Promise$.MODULE$.apply();
        ArrayBuffer buffer = new ArrayBuffer();
        Object lock = new Object();
        Process process = new ProcessBuilder((String[])command.toArray(ClassTag$.MODULE$.apply(String.class))).start();
        OutputStreamWriter stdinWriter = new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8);
        stdinWriter.write(queriesString);
        stdinWriter.flush();
        stdinWriter.close();
        new ProcessTestUtils.ProcessOutputCapturer(process.getInputStream(), (Function1 & Serializable & scala.Serializable)line -> {
            this.captureOutput$1("stdout", line, lock, buffer, foundMasterAndApplicationIdMessage, next, expectedAnswers, foundAllExpectedAnswers, errorResponses);
            return BoxedUnit.UNIT;
        }).start();
        new ProcessTestUtils.ProcessOutputCapturer(process.getErrorStream(), (Function1 & Serializable & scala.Serializable)line -> {
            this.captureOutput$1("stderr", line, lock, buffer, foundMasterAndApplicationIdMessage, next, expectedAnswers, foundAllExpectedAnswers, errorResponses);
            return BoxedUnit.UNIT;
        }).start();
        try {
            try {
                FiniteDuration finiteDuration;
                if (!extraArgs.contains((Object)"-e")) {
                    ThreadUtils$.MODULE$.awaitResult((Awaitable)foundMasterAndApplicationIdMessage.future(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(2)).minutes());
                    this.log().info("Cli driver is booted. Waiting for expected answers.");
                    finiteDuration = timeout;
                } else {
                    finiteDuration = new package.DurationInt(package$.MODULE$.DurationInt(2)).minutes().$plus(timeout);
                }
                FiniteDuration timeoutForQuery = finiteDuration;
                ThreadUtils$.MODULE$.awaitResult((Awaitable)foundAllExpectedAnswers.future(), (Duration)timeoutForQuery);
                this.log().info("Found all expected output.");
            }
            catch (Throwable cause) {
                String string;
                Object object = lock;
                synchronized (object) {
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(392).append("\n           |=======================\n           |CliSuite failure output\n           |=======================\n           |Spark SQL CLI command line: ").append(command.mkString(" ")).append("\n           |Exception: ").append(cause).append("\n           |Failed to capture next expected output \"").append(expectedAnswers.apply(next.elem)).append("\" within ").append(timeout).append(".\n           |\n           |").append(buffer.mkString("\n")).append("\n           |===========================\n           |End CliSuite failure output\n           |===========================\n         ").toString())).stripMargin();
                }
                String message = string;
                this.logError((Function0 & Serializable & scala.Serializable)() -> message, cause);
                throw this.fail(message, cause, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            }
        }
        finally {
            if (!process.waitFor(1L, TimeUnit.MINUTES)) {
                try {
                    this.log().warn("spark-sql did not exit gracefully.");
                }
                finally {
                    process.destroy();
                }
            }
        }
    }

    public Seq<String> runCliWithin$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    public Seq<String> runCliWithin$default$3() {
        return (Seq)new .colon.colon((Object)"Error:", (List)Nil$.MODULE$);
    }

    public Option<File> runCliWithin$default$4() {
        return new Some((Object)this.warehousePath());
    }

    public boolean runCliWithin$default$5() {
        return false;
    }

    public File runCliWithin$default$6() {
        return this.metastorePath();
    }

    public String runCliWithin$default$7() {
        return "spark-sql>";
    }

    private final void captureOutput$1(String source, String line, Object lock$1, ArrayBuffer buffer$1, Promise foundMasterAndApplicationIdMessage$1, IntRef next$1, Seq expectedAnswers$1, Promise foundAllExpectedAnswers$1, Seq errorResponses$1) {
        Object object = lock$1;
        synchronized (object) {
            Object object2;
            String newLine = new StringBuilder(5).append(new Timestamp(new Date().getTime())).append(" - ").append(source).append("> ").append(line).toString();
            this.log().info(newLine);
            buffer$1.$plus$eq((Object)newLine);
            Object object3 = line.startsWith("Spark master: ") && line.contains("Application Id: ") ? BoxesRunTime.boxToBoolean((boolean)foundMasterAndApplicationIdMessage$1.trySuccess((Object)BoxedUnit.UNIT)) : BoxedUnit.UNIT;
            if (next$1.elem < expectedAnswers$1.size() && line.contains((CharSequence)expectedAnswers$1.apply(next$1.elem))) {
                this.log().info(new StringBuilder(33).append(source).append("> found expected output line ").append(next$1.elem).append(": '").append(expectedAnswers$1.apply(next$1.elem)).append("'").toString());
                ++next$1.elem;
                object2 = next$1.elem == expectedAnswers$1.size() ? BoxesRunTime.boxToBoolean((boolean)foundAllExpectedAnswers$1.trySuccess((Object)BoxedUnit.UNIT)) : BoxedUnit.UNIT;
            } else {
                errorResponses$1.foreach((Function1 & Serializable & scala.Serializable)r -> {
                    if (line.contains((CharSequence)r)) {
                        return BoxesRunTime.boxToBoolean((boolean)foundAllExpectedAnswers$1.tryFailure((Throwable)new RuntimeException(new StringBuilder(25).append("Failed with error line '").append(line).append("'").toString())));
                    }
                    return BoxedUnit.UNIT;
                });
                object2 = BoxedUnit.UNIT;
            }
        }
    }

    private final Thread t$1(Seq extraConf$1, CountDownLatch cd$1) {
        return new Thread(this, extraConf$1, cd$1){
            private final /* synthetic */ CliSuite $outer;
            private final Seq extraConf$1;
            private final CountDownLatch cd$1;

            public void run() {
                this.$outer.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), (Seq<String>)this.extraConf$1, this.$outer.runCliWithin$default$3(), this.$outer.runCliWithin$default$4(), this.$outer.runCliWithin$default$5(), this.$outer.runCliWithin$default$6(), this.$outer.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create table src(key int) using hive;"), (Object)"Hive support is required to CREATE Hive TABLE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create table src(key int) using parquet;"), (Object)"")}));
                this.cd$1.countDown();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.extraConf$1 = extraConf$1;
                this.cd$1 = cd$1;
            }
        };
    }

    private final void check$1(Enumeration.Value format, String errorMessage, boolean silent) {
        Tuple2[] expected = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])errorMessage.split(System.lineSeparator()))).map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), x$4), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--conf", new StringBuilder(26).append("spark.hive.session.silent=").append(silent).toString(), "--conf", new StringBuilder(1).append(SQLConf$.MODULE$.ERROR_MESSAGE_FORMAT().key()).append("=").append(format).toString(), "--conf", new StringBuilder(5).append(SQLConf$.MODULE$.ANSI_ENABLED().key()).append("=true").toString(), "-e", "select 1 / 0"}))), (Seq<String>)((Seq)new .colon.colon((Object)"DIVIDE_BY_ZERO", (List)Nil$.MODULE$)), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])expected));
    }

    public static final /* synthetic */ void $anonfun$new$41(CliSuite $this, boolean silent) {
        $this.check$1(ErrorMessageFormat$.MODULE$.MINIMAL(), new StringOps(Predef$.MODULE$.augmentString("{\n            |  \"errorClass\" : \"DIVIDE_BY_ZERO\",\n            |  \"sqlState\" : \"22012\",\n            |  \"messageParameters\" : {\n            |    \"config\" : \"\\\"spark.sql.ansi.enabled\\\"\"\n            |  },\n            |  \"queryContext\" : [ {\n            |    \"objectType\" : \"\",\n            |    \"objectName\" : \"\",\n            |    \"startIndex\" : 8,\n            |    \"stopIndex\" : 12,\n            |    \"fragment\" : \"1 / 0\"\n            |  } ]\n            |}")).stripMargin(), silent);
        $this.check$1(ErrorMessageFormat$.MODULE$.STANDARD(), new StringOps(Predef$.MODULE$.augmentString("{\n            |  \"errorClass\" : \"DIVIDE_BY_ZERO\",\n            |  \"messageTemplate\" : \"Division by zero. Use `try_divide` to tolerate divisor being 0 and return NULL instead. If necessary set <config> to \\\"false\\\" to bypass this error.\",\n            |  \"sqlState\" : \"22012\",\n            |  \"messageParameters\" : {\n            |    \"config\" : \"\\\"spark.sql.ansi.enabled\\\"\"\n            |  },\n            |  \"queryContext\" : [ {\n            |    \"objectType\" : \"\",\n            |    \"objectName\" : \"\",\n            |    \"startIndex\" : 8,\n            |    \"stopIndex\" : 12,\n            |    \"fragment\" : \"1 / 0\"\n            |  } ]\n            |}")).stripMargin(), silent);
    }

    public CliSuite() {
        this.test("load warehouse dir from hive-site.xml", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            File metastore = Utils$.MODULE$.createTempDir();
            metastore.delete();
            try {
                FiniteDuration x$1 = new package.DurationInt(package$.MODULE$.DurationInt(1)).minute();
                None$ x$2 = None$.MODULE$;
                boolean x$3 = true;
                File x$4 = metastore;
                Seq<String> x$5 = this.runCliWithin$default$2();
                Seq<String> x$6 = this.runCliWithin$default$3();
                String x$7 = this.runCliWithin$default$7();
                Tuple2 x$8 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database default;"), (Object)"hive_one");
                Tuple2 x$9 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"set spark.sql.warehouse.dir;"), (Object)"hive_one");
                this.runCliWithin(x$1, x$5, x$6, (Option<File>)x$2, x$3, x$4, x$7, (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{x$8, x$9}));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                Utils$.MODULE$.deleteRecursively(metastore);
            }
            return boxedUnit;
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        this.test("load warehouse dir from --hiveconf", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FiniteDuration x$10 = new package.DurationInt(package$.MODULE$.DurationInt(2)).minute();
            boolean x$11 = true;
            Seq<String> x$12 = this.runCliWithin$default$2();
            Seq<String> x$13 = this.runCliWithin$default$3();
            Option<File> x$14 = this.runCliWithin$default$4();
            File x$15 = this.runCliWithin$default$6();
            String x$16 = this.runCliWithin$default$7();
            Tuple2 x$17 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database default;"), (Object)this.warehousePath().getAbsolutePath());
            Tuple2 x$18 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create database cliTestDb;"), (Object)"");
            Tuple2 x$19 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database cliTestDb;"), (Object)this.warehousePath().getAbsolutePath());
            Tuple2 x$20 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"set spark.sql.warehouse.dir;"), (Object)this.warehousePath().getAbsolutePath());
            this.runCliWithin(x$10, x$12, x$13, x$14, x$11, x$15, x$16, (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{x$17, x$18, x$19, x$20}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        this.test("load warehouse dir from --conf spark(.hadoop).hive.*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            File metastore = Utils$.MODULE$.createTempDir();
            metastore.delete();
            try {
                FiniteDuration x$21 = new package.DurationInt(package$.MODULE$.DurationInt(2)).minute();
                Seq x$22 = (Seq)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)new StringBuilder(14).append("spark.hadoop.").append(HiveConf.ConfVars.METASTOREWAREHOUSE).append("=").append(this.sparkWareHouseDir()).toString(), (List)Nil$.MODULE$));
                None$ x$23 = None$.MODULE$;
                boolean x$24 = true;
                File x$25 = metastore;
                Seq<String> x$26 = this.runCliWithin$default$3();
                String x$27 = this.runCliWithin$default$7();
                Tuple2 x$28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database default;"), (Object)this.sparkWareHouseDir().getAbsolutePath());
                Tuple2 x$29 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create database cliTestDb;"), (Object)"");
                Tuple2 x$30 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database cliTestDb;"), (Object)this.sparkWareHouseDir().getAbsolutePath());
                Tuple2 x$31 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"set spark.sql.warehouse.dir;"), (Object)this.sparkWareHouseDir().getAbsolutePath());
                this.runCliWithin(x$21, (Seq<String>)x$22, x$26, (Option<File>)x$23, x$24, x$25, x$27, (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{x$28, x$29, x$30, x$31}));
                FiniteDuration x$32 = new package.DurationInt(package$.MODULE$.DurationInt(2)).minute();
                Seq x$33 = (Seq)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)new StringBuilder(7).append("spark.").append(HiveConf.ConfVars.METASTOREWAREHOUSE).append("=").append(this.sparkWareHouseDir()).toString(), (List)Nil$.MODULE$));
                File x$34 = metastore;
                Seq<String> x$35 = this.runCliWithin$default$3();
                Option<File> x$36 = this.runCliWithin$default$4();
                boolean x$37 = this.runCliWithin$default$5();
                String x$38 = this.runCliWithin$default$7();
                Tuple2 x$39 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database default;"), (Object)this.sparkWareHouseDir().getAbsolutePath());
                Tuple2 x$40 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create database cliTestDb;"), (Object)"");
                Tuple2 x$41 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database cliTestDb;"), (Object)this.sparkWareHouseDir().getAbsolutePath());
                Tuple2 x$42 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"set spark.sql.warehouse.dir;"), (Object)this.sparkWareHouseDir().getAbsolutePath());
                this.runCliWithin(x$32, (Seq<String>)x$33, x$35, x$36, x$37, x$34, x$38, (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{x$39, x$40, x$41, x$42}));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                Utils$.MODULE$.deleteRecursively(metastore);
            }
            return boxedUnit;
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        this.test("load warehouse dir from spark.sql.warehouse.dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            File metastore = Utils$.MODULE$.createTempDir();
            metastore.delete();
            try {
                FiniteDuration x$43 = new package.DurationInt(package$.MODULE$.DurationInt(2)).minute();
                Seq x$44 = (Seq)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)new StringBuilder(2).append(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key()).append("=").append(this.sparkWareHouseDir()).append("1").toString(), (List)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)new StringBuilder(15).append("spark.hadoop.").append(HiveConf.ConfVars.METASTOREWAREHOUSE).append("=").append(this.sparkWareHouseDir()).append("2").toString(), (List)Nil$.MODULE$))));
                File x$45 = metastore;
                Seq<String> x$46 = this.runCliWithin$default$3();
                Option<File> x$47 = this.runCliWithin$default$4();
                boolean x$48 = this.runCliWithin$default$5();
                String x$49 = this.runCliWithin$default$7();
                Seq x$50 = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database default;"), (Object)this.sparkWareHouseDir().getAbsolutePath().concat("1")), (List)Nil$.MODULE$);
                this.runCliWithin(x$43, (Seq<String>)x$44, x$46, x$47, x$48, x$45, x$49, (Seq<Tuple2<String, String>>)x$50);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                Utils$.MODULE$.deleteRecursively(metastore);
            }
            return boxedUnit;
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        this.test("Simple commands", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL dataFilePath = Thread.currentThread().getContextClassLoader().getResource("data/files/small_kv.txt");
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(3)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TABLE hive_test(key INT, val STRING) USING hive;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SHOW TABLES;"), (Object)"hive_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(67).append("LOAD DATA LOCAL INPATH '").append(dataFilePath).append("'\n         |OVERWRITE INTO TABLE hive_test;").toString())).stripMargin()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CACHE TABLE hive_test;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT COUNT(*) FROM hive_test;"), (Object)"5"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DROP TABLE hive_test;"), (Object)"")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        this.test("Single command with -e", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)new .colon.colon((Object)"-e", (List)new .colon.colon((Object)"SHOW DATABASES;", (List)Nil$.MODULE$))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        this.test("Single command with --database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE DATABASE hive_db_test;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"USE hive_db_test;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TABLE hive_table_test(key INT, val STRING);"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SHOW TABLES;"), (Object)"hive_table_test")}));
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)new .colon.colon((Object)"--database", (List)new .colon.colon((Object)"hive_db_test", (List)new .colon.colon((Object)"-e", (List)new .colon.colon((Object)"SHOW TABLES;", (List)Nil$.MODULE$))))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"hive_table_test")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        this.test("Commands using SerDe provided in --jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarFile = HiveTestJars$.MODULE$.getHiveHcatalogCoreJar(HiveTestJars$.MODULE$.getHiveHcatalogCoreJar$default$1()).getCanonicalPath();
            URL dataFilePath = Thread.currentThread().getContextClassLoader().getResource("data/files/small_kv.txt");
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(3)).minute(), (Seq<String>)((Seq)new .colon.colon((Object)"--jars", (List)new .colon.colon((Object)String.valueOf(jarFile), (List)Nil$.MODULE$))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE t1(key string, val string)\n        |ROW FORMAT SERDE 'org.apache.hive.hcatalog.data.JsonSerDe';")).stripMargin()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TABLE sourceTable (key INT, val STRING) USING hive;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("LOAD DATA LOCAL INPATH '").append(dataFilePath).append("'\n         |OVERWRITE INTO TABLE sourceTable;").toString())).stripMargin()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INSERT INTO TABLE t1 SELECT key, val FROM sourceTable;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT collect_list(array(val)) FROM t1;"), (Object)"[[\"val_238\"],[\"val_86\"],[\"val_311\"],[\"val_27\"],[\"val_165\"]]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DROP TABLE t1;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DROP TABLE sourceTable;"), (Object)"")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        this.test("SPARK-29022: Commands using SerDe provided in --hive.aux.jars.path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL dataFilePath = Thread.currentThread().getContextClassLoader().getResource("data/files/small_kv.txt");
            String hiveContribJar = HiveTestJars$.MODULE$.getHiveHcatalogCoreJar(HiveTestJars$.MODULE$.getHiveHcatalogCoreJar$default$1()).getCanonicalPath();
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(3)).minute(), (Seq<String>)((Seq)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)new StringBuilder(14).append("spark.hadoop.").append(HiveConf.ConfVars.HIVEAUXJARS).append("=").append(hiveContribJar).toString(), (List)Nil$.MODULE$))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE addJarWithHiveAux(key string, val string)\n        |ROW FORMAT SERDE 'org.apache.hive.hcatalog.data.JsonSerDe';")).stripMargin()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TABLE sourceTableForWithHiveAux (key INT, val STRING) USING hive;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(83).append("LOAD DATA LOCAL INPATH '").append(dataFilePath).append("'\n         |OVERWRITE INTO TABLE sourceTableForWithHiveAux;").toString())).stripMargin()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INSERT INTO TABLE addJarWithHiveAux SELECT key, val FROM sourceTableForWithHiveAux;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT collect_list(array(val)) FROM addJarWithHiveAux;"), (Object)"[[\"val_238\"],[\"val_86\"],[\"val_311\"],[\"val_27\"],[\"val_165\"]]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DROP TABLE addJarWithHiveAux;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DROP TABLE sourceTableForWithHiveAux;"), (Object)"")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        this.testRetry("SPARK-11188 Analysis error reporting", this.testRetry$default$2(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FiniteDuration x$51 = new package.DurationInt(package$.MODULE$.DurationInt(2)).minute();
            Seq x$52 = (Seq)new .colon.colon((Object)"AnalysisException", (List)Nil$.MODULE$);
            Seq<String> x$53 = this.runCliWithin$default$2();
            Option<File> x$54 = this.runCliWithin$default$4();
            boolean x$55 = this.runCliWithin$default$5();
            File x$56 = this.runCliWithin$default$6();
            String x$57 = this.runCliWithin$default$7();
            Seq x$58 = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"select * from nonexistent_table;"), (Object)"nonexistent_table"), (List)Nil$.MODULE$);
            this.runCliWithin(x$51, x$53, (Seq<String>)x$52, x$54, x$55, x$56, x$57, (Seq<Tuple2<String, String>>)x$58);
        });
        this.test("SPARK-11624 Spark SQL CLI should set sessionState only once", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)new .colon.colon((Object)"-e", (List)new .colon.colon((Object)"!echo \"This is a test for Spark-11624\";", (List)Nil$.MODULE$))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"This is a test for Spark-11624")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
        this.test("list jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL jarFile = Thread.currentThread().getContextClassLoader().getResource("TestUDTF.jar");
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(9).append("ADD JAR ").append(jarFile).append(";").toString()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LIST JARS;"), (Object)"TestUDTF.jar")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
        this.test("list jar <jarfile>", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL jarFile = Thread.currentThread().getContextClassLoader().getResource("TestUDTF.jar");
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(9).append("ADD JAR ").append(jarFile).append(";").toString()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(10).append("List JAR ").append(jarFile).append(";").toString()), (Object)"TestUDTF.jar")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
        this.test("list files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL dataFilePath = Thread.currentThread().getContextClassLoader().getResource("data/files/small_kv.txt");
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(10).append("ADD FILE ").append(dataFilePath).append(";").toString()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LIST FILES;"), (Object)"small_kv.txt")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        this.test("list file <filepath>", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL dataFilePath = Thread.currentThread().getContextClassLoader().getResource("data/files/small_kv.txt");
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(10).append("ADD FILE ").append(dataFilePath).append(";").toString()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(11).append("LIST FILE ").append(dataFilePath).append(";").toString()), (Object)"small_kv.txt")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
        this.test("apply hiveconf from cli command", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SET conf1;"), (Object)"conftest"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SET conf2;"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SET conf3=${hiveconf:conf1};"), (Object)"conftest"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SET conf3;"), (Object)"conftest")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        this.test("Support hive.aux.jars.path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String hiveContribJar = HiveTestJars$.MODULE$.getHiveContribJar(HiveTestJars$.MODULE$.getHiveContribJar$default$1()).getCanonicalPath();
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), (Seq<String>)((Seq)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)new StringBuilder(14).append("spark.hadoop.").append(HiveConf.ConfVars.HIVEAUXJARS).append("=").append(hiveContribJar).toString(), (List)Nil$.MODULE$))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TEMPORARY FUNCTION example_format AS 'org.apache.hadoop.hive.contrib.udf.example.UDFExampleFormat';"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT example_format('%o', 93);"), (Object)"135")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
        this.test("SPARK-28840 test --jars command", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarFile = new File("../../sql/hive/src/test/resources/SPARK-21101-1.0.jar").getCanonicalPath();
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), (Seq<String>)((Seq)new .colon.colon((Object)"--jars", (List)new .colon.colon((Object)String.valueOf(jarFile), (List)Nil$.MODULE$))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TEMPORARY FUNCTION testjar AS 'org.apache.spark.sql.hive.execution.UDTFStack';"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT testjar(1,'TEST-SPARK-TEST-jar', 28840);"), (Object)"TEST-SPARK-TEST-jar\t28840")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
        this.test("SPARK-28840 test --jars and hive.aux.jars.path command", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarFile = new File("../../sql/hive/src/test/resources/SPARK-21101-1.0.jar").getCanonicalPath();
            String hiveContribJar = HiveTestJars$.MODULE$.getHiveContribJar(HiveTestJars$.MODULE$.getHiveContribJar$default$1()).getCanonicalPath();
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minutes(), (Seq<String>)((Seq)new .colon.colon((Object)"--jars", (List)new .colon.colon((Object)String.valueOf(jarFile), (List)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)new StringBuilder(14).append("spark.hadoop.").append(HiveConf.ConfVars.HIVEAUXJARS).append("=").append(hiveContribJar).toString(), (List)Nil$.MODULE$))))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TEMPORARY FUNCTION testjar AS 'org.apache.spark.sql.hive.execution.UDTFStack';"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT testjar(1,'TEST-SPARK-TEST-jar', 28840);"), (Object)"TEST-SPARK-TEST-jar\t28840"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TEMPORARY FUNCTION example_max AS 'org.apache.hadoop.hive.contrib.udaf.example.UDAFExampleMax';"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT concat_ws(',', 'First', example_max(1234321), 'Third');"), (Object)"First,1234321,Third")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
        this.test("SPARK-29022 Commands using SerDe provided in ADD JAR sql", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL dataFilePath = Thread.currentThread().getContextClassLoader().getResource("data/files/small_kv.txt");
            String hiveContribJar = HiveTestJars$.MODULE$.getHiveHcatalogCoreJar(HiveTestJars$.MODULE$.getHiveHcatalogCoreJar$default$1()).getCanonicalPath();
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(3)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(9).append("ADD JAR ").append(hiveContribJar).append(";").toString()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE addJarWithSQL(key string, val string)\n        |ROW FORMAT SERDE 'org.apache.hive.hcatalog.data.JsonSerDe';")).stripMargin()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TABLE sourceTableForWithSQL(key INT, val STRING) USING hive;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("LOAD DATA LOCAL INPATH '").append(dataFilePath).append("'\n         |OVERWRITE INTO TABLE sourceTableForWithSQL;").toString())).stripMargin()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INSERT INTO TABLE addJarWithSQL SELECT key, val FROM sourceTableForWithSQL;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT collect_list(array(val)) FROM addJarWithSQL;"), (Object)"[[\"val_238\"],[\"val_86\"],[\"val_311\"],[\"val_27\"],[\"val_165\"]]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DROP TABLE addJarWithSQL;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DROP TABLE sourceTableForWithSQL;"), (Object)"")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
        this.test("SPARK-26321 Should not split semicolon within quoted string literals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(3)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"select 'Test1', \"^;^\";"), (Object)"Test1\t^;^"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"select 'Test2', \"\\\";\";"), (Object)"Test2\t\";"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"select 'Test3', \"\\';\";"), (Object)"Test3\t';"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"select concat('Test4', ';');"), (Object)"Test4;")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
        this.test("Pad Decimal numbers with trailing zeros to the scale of the column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT CAST(1 AS DECIMAL(38, 18));"), (Object)"1.000000000000000000")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
        this.test("SPARK-30049 Should not complain for quotes in commented lines", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("SELECT concat('test', 'comment') -- someone's comment here\n        |;")).stripMargin()), (Object)"testcomment")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527));
        this.test("SPARK-31102 spark-sql fails to parse when contains comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("SELECT concat('test', 'comment'),\n        |    -- someone's comment here\n        | 2;")).stripMargin()), (Object)"testcomment")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
        this.test("SPARK-30049 Should not complain for quotes in commented with multi-lines", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("SELECT concat('test', 'comment') -- someone's comment here \\\n        | comment continues here with single ' quote \\\n        | extra ' \\\n        |;")).stripMargin()), (Object)"testcomment")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
        this.test("SPARK-31595 Should allow unescaped quote mark in quoted string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("SELECT '\"legal string a';select 1 + 234;")).stripMargin()), (Object)"235")}));
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("SELECT \"legal 'string b\";select 22222 + 1;")).stripMargin()), (Object)"22223")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
        this.testRetry("SparkException with root cause will be printStacktrace", this.testRetry$default$2(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), (Seq<String>)((Seq)new .colon.colon((Object)"--hiveconf", (List)new .colon.colon((Object)"hive.session.silent=false", (List)new .colon.colon((Object)"-e", (List)new .colon.colon((Object)"select from_json('a', 'a INT', map('mode', 'FAILFAST'));", (List)Nil$.MODULE$))))), (Seq<String>)((Seq)new .colon.colon((Object)"JsonParseException", (List)Nil$.MODULE$)), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)"SparkException: [MALFORMED_RECORD_IN_PARSING]"), new Tuple2((Object)"", (Object)"JsonParseException: Unrecognized token 'a'")}));
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), (Seq<String>)((Seq)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)"spark.hive.session.silent=true", (List)new .colon.colon((Object)"-e", (List)new .colon.colon((Object)"select from_json('a', 'a INT', map('mode', 'FAILFAST'));", (List)Nil$.MODULE$))))), (Seq<String>)((Seq)new .colon.colon((Object)"SparkException", (List)Nil$.MODULE$)), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)"SparkException: [MALFORMED_RECORD_IN_PARSING]")}));
        });
        this.test("SPARK-30808: use Java 8 time API in Thrift SQL CLI by default", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT MAKE_DATE(-44, 3, 15);"), (Object)"-0044-03-15")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
        this.testRetry("SPARK-33100: Ignore a semicolon inside a bracketed comment in spark-sql", this.testRetry$default$2(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/* SELECT 'test';*/ SELECT 'test';"), (Object)"test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)";;/* SELECT 'test';*/ SELECT 'test';"), (Object)"test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/* SELECT 'test';*/;; SELECT 'test';"), (Object)"test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT 'test'; -- SELECT 'test';"), (Object)"test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT 'test'; /* SELECT 'test';*/;"), (Object)"test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/*$meta chars{^\\;}*/ SELECT 'test';"), (Object)"test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/*\nmulti-line\n*/ SELECT 'test';"), (Object)"test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/*/* multi-level bracketed*/ SELECT 'test';"), (Object)"test")})));
        this.test("SPARK-33100: test sql statements with hint in bracketed comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TEMPORARY VIEW t1 AS SELECT * FROM VALUES(1, 2) AS t1(k, v);"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TEMPORARY VIEW t2 AS SELECT * FROM VALUES(2, 1) AS t2(k, v);"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EXPLAIN SELECT /*+ MERGEJOIN(t1) */ t1.* FROM t1 JOIN t2 ON t1.k = t2.v;"), (Object)"SortMergeJoin"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EXPLAIN SELECT /* + MERGEJOIN(t1) */ t1.* FROM t1 JOIN t2 ON t1.k = t2.v;"), (Object)"BroadcastHashJoin")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
        this.test("SPARK-35086: --verbose should be passed to Spark SQL CLI", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)new .colon.colon((Object)"--verbose", (List)Nil$.MODULE$)), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT 'SPARK-35086' AS c1, '--verbose' AS c2;"), (Object)"SELECT 'SPARK-35086' AS c1, '--verbose' AS c2")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
        this.test("SPARK-35102: Make spark.sql.hive.version meaningful and not deprecated", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), (Seq<String>)((Seq)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)"spark.sql.hive.version=0.1", (List)Nil$.MODULE$))), (Seq<String>)((Seq)new .colon.colon((Object)new StringBuilder(11).append("please use ").append(HiveUtils$.MODULE$.HIVE_METASTORE_VERSION().key()).toString(), (List)Nil$.MODULE$)), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"")}));
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)new StringBuilder(1).append(HiveUtils$.MODULE$.BUILTIN_HIVE_VERSION().key()).append("=").append(HiveUtils$.MODULE$.builtinHiveVersion()).toString(), (List)Nil$.MODULE$))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(5).append("set ").append(HiveUtils$.MODULE$.BUILTIN_HIVE_VERSION().key()).append(";").toString()), (Object)HiveUtils$.MODULE$.builtinHiveVersion()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SET -v;"), (Object)HiveUtils$.MODULE$.builtinHiveVersion())}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
        this.test("SPARK-37471: spark-sql support nested bracketed comment ", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |/* SELECT /*+ HINT() */ 4; */\n        |SELECT 1;\n        |")).stripMargin()), (Object)"SELECT 1")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 623));
        this.testRetry("SPARK-37555: spark-sql should pass last unclosed comment to backend", this.testRetry$default$2(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("/* SELECT /*+ HINT() 4; */;")).stripMargin()), (Object)"Syntax error at or near ';'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("/* SELECT /*+ HINT() 4; */ SELECT 1;")).stripMargin()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/* Here is a unclosed bracketed comment SELECT 1;"), (Object)"Found an unclosed bracketed comment. Please, append */ at the end of the comment."), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("/* SELECT /*+ HINT() */ 4; */;")).stripMargin()), (Object)"")})));
        this.testRetry("SPARK-37694: delete [jar|file|archive] shall use spark sql processor", this.testRetry$default$2(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FiniteDuration x$59 = new package.DurationInt(package$.MODULE$.DurationInt(2)).minute();
            Seq x$60 = (Seq)new .colon.colon((Object)"ParseException", (List)Nil$.MODULE$);
            Seq<String> x$61 = this.runCliWithin$default$2();
            Option<File> x$62 = this.runCliWithin$default$4();
            boolean x$63 = this.runCliWithin$default$5();
            File x$64 = this.runCliWithin$default$6();
            String x$65 = this.runCliWithin$default$7();
            Seq x$66 = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete jar dummy.jar;"), (Object)"Syntax error at or near 'jar': missing 'FROM'.(line 1, pos 7)"), (List)Nil$.MODULE$);
            this.runCliWithin(x$59, x$61, (Seq<String>)x$60, x$62, x$63, x$64, x$65, (Seq<Tuple2<String, String>>)x$66);
        });
        this.test("SPARK-37906: Spark SQL CLI should not pass final comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf(true).setMaster("local-cluster[1,1,1024]").setAppName("SPARK-37906");
            SparkContext sparkContext = new SparkContext(sparkConf);
            SparkSQLEnv$.MODULE$.sparkContext_$eq(sparkContext);
            Configuration hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(sparkConf);
            Map extraConfigs = HiveUtils$.MODULE$.formatTimeVarsForHiveClient(hadoopConf);
            HiveConf cliConf = HiveClientImpl$.MODULE$.newHiveConf(sparkConf, (Iterable)hadoopConf, extraConfigs, HiveClientImpl$.MODULE$.newHiveConf$default$4());
            CliSessionState sessionState = new CliSessionState(cliConf);
            SessionState.setCurrentSessionState((SessionState)sessionState);
            SparkSQLCLIDriver cli = new SparkSQLCLIDriver();
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT 1; --comment"), (Object)new .colon.colon((Object)"SELECT 1", (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT 1; /* comment */"), (Object)new .colon.colon((Object)"SELECT 1", (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT 1; /* comment"), (Object)new .colon.colon((Object)"SELECT 1", (List)new .colon.colon((Object)" /* comment", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT 1; /* comment select 1;"), (Object)new .colon.colon((Object)"SELECT 1", (List)new .colon.colon((Object)" /* comment select 1;", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/* This is a comment without end symbol SELECT 1;"), (Object)new .colon.colon((Object)"/* This is a comment without end symbol SELECT 1;", (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT 1; --comment\n"), (Object)new .colon.colon((Object)"SELECT 1", (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT 1; /* comment */\n"), (Object)new .colon.colon((Object)"SELECT 1", (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT 1; /* comment\n"), (Object)new .colon.colon((Object)"SELECT 1", (List)new .colon.colon((Object)" /* comment\n", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT 1; /* comment select 1;\n"), (Object)new .colon.colon((Object)"SELECT 1", (List)new .colon.colon((Object)" /* comment select 1;\n", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/* This is a comment without end symbol SELECT 1;\n"), (Object)new .colon.colon((Object)"/* This is a comment without end symbol SELECT 1;\n", (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/* comment */ SELECT 1;"), (Object)new .colon.colon((Object)"/* comment */ SELECT 1", (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT /* comment */  1;"), (Object)new .colon.colon((Object)"SELECT /* comment */  1", (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-- comment "), (Object)Nil$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-- comment \nSELECT 1"), (Object)new .colon.colon((Object)"-- comment \nSELECT 1", (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/*  comment */  "), (Object)Nil$.MODULE$)}))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String query = (String)tuple2._1();
                    Seq ret = (Seq)tuple2._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(cli.splitSemiColon(query)).asScala());
                    Seq $org_scalatest_assert_macro_right = ret;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 681));
                }
                throw new MatchError((Object)tuple2);
            });
            sessionState.close();
            SparkSQLEnv$.MODULE$.stop(SparkSQLEnv$.MODULE$.stop$default$1());
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 651));
        this.testRetry("SPARK-39068: support in-memory catalog and running concurrently", this.testRetry$default$2(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq extraConf = (Seq)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)new StringBuilder(10).append(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION().key()).append("=in-memory").toString(), (List)Nil$.MODULE$));
            CountDownLatch cd = new CountDownLatch(2);
            this.t$1(extraConf, cd).start();
            this.t$1(extraConf, cd).start();
            cd.await();
        });
        this.testRetry("formats of error messages", this.testRetry$default$2(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$1(ErrorMessageFormat$.MODULE$.PRETTY(), new StringOps(Predef$.MODULE$.augmentString("[DIVIDE_BY_ZERO] Division by zero. Use `try_divide` to tolerate divisor being 0 and return NULL instead. If necessary set \"spark.sql.ansi.enabled\" to \"false\" to bypass this error.\n          |== SQL(line 1, position 8) ==\n          |select 1 / 0\n          |       ^^^^^\n          |")).stripMargin(), true);
            this.check$1(ErrorMessageFormat$.MODULE$.PRETTY(), new StringOps(Predef$.MODULE$.augmentString("[DIVIDE_BY_ZERO] Division by zero. Use `try_divide` to tolerate divisor being 0 and return NULL instead. If necessary set \"spark.sql.ansi.enabled\" to \"false\" to bypass this error.\n          |== SQL(line 1, position 8) ==\n          |select 1 / 0\n          |       ^^^^^\n          |\n          |org.apache.spark.SparkArithmeticException: [DIVIDE_BY_ZERO] Division by zero. Use `try_divide` to tolerate divisor being 0 and return NULL instead. If necessary set \"spark.sql.ansi.enabled\" to \"false\" to bypass this error.\n          |")).stripMargin(), false);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)silent -> {
                CliSuite.$anonfun$new$41(this, BoxesRunTime.unboxToBoolean((Object)silent));
                return BoxedUnit.UNIT;
            });
        });
        this.test("SPARK-35242: Support change catalog default database for spark", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)new StringBuilder(1).append(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key()).append("=").append(this.sparkWareHouseDir()).toString(), (List)Nil$.MODULE$))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create database spark_35242;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"use spark_35242;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TABLE spark_test(key INT, val STRING);"), (Object)"")}));
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)new StringBuilder(1).append(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key()).append("=").append(this.sparkWareHouseDir()).toString(), (List)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)new StringBuilder(12).append(StaticSQLConf$.MODULE$.CATALOG_DEFAULT_DATABASE().key()).append("=spark_35242").toString(), (List)Nil$.MODULE$))))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"show tables;"), (Object)"spark_test")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 781));
        this.test("SPARK-42448: Print correct database in prompt", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FiniteDuration x$67 = new package.DurationInt(package$.MODULE$.DurationInt(2)).minute();
            Seq x$68 = (Seq)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)new StringBuilder(6).append(SQLConf$.MODULE$.LEGACY_EMPTY_CURRENT_DB_IN_CLI().key()).append("=false").toString(), (List)Nil$.MODULE$));
            String x$69 = "spark-sql (default)>";
            Seq<String> x$70 = this.runCliWithin$default$3();
            Option<File> x$71 = this.runCliWithin$default$4();
            boolean x$72 = this.runCliWithin$default$5();
            File x$73 = this.runCliWithin$default$6();
            Tuple2 x$74 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"set abc;"), (Object)"abc\t<undefined>");
            Tuple2 x$75 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create database spark_42448;"), (Object)"");
            this.runCliWithin(x$67, (Seq<String>)x$68, x$70, x$71, x$72, x$73, x$69, (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{x$74, x$75}));
            FiniteDuration x$76 = new package.DurationInt(package$.MODULE$.DurationInt(2)).minute();
            Seq x$77 = (Seq)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)new StringBuilder(6).append(SQLConf$.MODULE$.LEGACY_EMPTY_CURRENT_DB_IN_CLI().key()).append("=false").toString(), (List)new .colon.colon((Object)"--database", (List)new .colon.colon((Object)"spark_42448", (List)Nil$.MODULE$))));
            String x$78 = "spark-sql (spark_42448)>";
            Seq<String> x$79 = this.runCliWithin$default$3();
            Option<File> x$80 = this.runCliWithin$default$4();
            boolean x$81 = this.runCliWithin$default$5();
            File x$82 = this.runCliWithin$default$6();
            Seq x$83 = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"select current_database();"), (Object)"spark_42448"), (List)Nil$.MODULE$);
            this.runCliWithin(x$76, (Seq<String>)x$77, x$79, x$80, x$81, x$82, x$78, (Seq<Tuple2<String, String>>)x$83);
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 796));
        this.test("SPARK-42823: multipart identifier support for specify database by --database option", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String catalogName = "testcat";
            String catalogImpl = new StringBuilder(19).append("spark.sql.catalog.").append(catalogName).append("=").append(JDBCTableCatalog.class.getName()).toString();
            String catalogUrl = new StringBuilder(53).append("spark.sql.catalog.").append(catalogName).append(".url=jdbc:derby:memory:").append(catalogName).append(";create=true").toString();
            String catalogDriver = new StringBuilder(64).append("spark.sql.catalog.").append(catalogName).append(".driver=org.apache.derby.jdbc.AutoloadedDriver").toString();
            Seq catalogConfigs = (Seq)((TraversableLike)new .colon.colon((Object)catalogImpl, (List)new .colon.colon((Object)catalogDriver, (List)new .colon.colon((Object)catalogUrl, (List)new .colon.colon((Object)"spark.sql.catalogImplementation=in-memory", (List)Nil$.MODULE$))))).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> (Seq)new .colon.colon((Object)"--conf", (List)new .colon.colon(x$5, (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom());
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)catalogConfigs.$plus$plus((GenTraversableOnce)new .colon.colon((Object)"--database", (List)new .colon.colon((Object)new StringBuilder(4).append(catalogName).append(".SYS").toString(), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT CURRENT_CATALOG();"), (Object)catalogName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT CURRENT_SCHEMA();"), (Object)"SYS")}));
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)catalogConfigs.$plus$plus((GenTraversableOnce)new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)new StringBuilder(25).append("spark.sql.defaultCatalog=").append(catalogName).toString(), (List)new .colon.colon((Object)"--database", (List)new .colon.colon((Object)"SYS", (List)Nil$.MODULE$)))), Seq$.MODULE$.canBuildFrom())), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), this.runCliWithin$default$7(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT CURRENT_CATALOG();"), (Object)catalogName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT CURRENT_SCHEMA();"), (Object)"SYS")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
    }
}

