/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import com.google.common.io.Files;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Locale;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.jdbc.HiveDriver;
import org.apache.spark.ProcessTestUtils;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.ServerMode$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tEd!\u0002\"D\u0003\u0003\u0001\u0006\"B1\u0001\t\u0003\u0011\u0007\"B3\u0001\r\u00031\u0007bB9\u0001\u0005\u0004%IA\u001d\u0005\u0007w\u0002\u0001\u000b\u0011B:\t\u000fq\u0004!\u0019!C\u0005{\"9\u0011\u0011\u0003\u0001!\u0002\u0013q\b\u0002CA\n\u0001\t\u0007I\u0011C?\t\u000f\u0005U\u0001\u0001)A\u0005}\"A\u0011q\u0003\u0001C\u0002\u0013EQ\u0010C\u0004\u0002\u001a\u0001\u0001\u000b\u0011\u0002@\t\u0011\u0005m\u0001A1A\u0005\u0002uDq!!\b\u0001A\u0003%a\u0010C\u0006\u0002 \u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0002bCA\u0016\u0001\u0001\u0007\t\u0019!C\u0005\u0003[A1\"!\u000f\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002$!9\u00111\b\u0001\u0005\u0012\u0005\u0005\u0002\u0002CA\u001f\u0001\t\u0007I\u0011\u0003:\t\u000f\u0005}\u0002\u0001)A\u0005g\"A\u0011\u0011\t\u0001C\u0002\u0013E!\u000fC\u0004\u0002D\u0001\u0001\u000b\u0011B:\t\r\u0005\u0015\u0003\u0001\"\u0005s\u0011-\t9\u0005\u0001a\u0001\u0002\u0004%\t\"!\u0013\t\u0017\u0005]\u0003\u00011AA\u0002\u0013E\u0011\u0011\f\u0005\f\u0003;\u0002\u0001\u0019!A!B\u0013\tY\u0005C\u0006\u0002`\u0001\u0001\r\u00111A\u0005\u0012\u0005%\u0003bCA1\u0001\u0001\u0007\t\u0019!C\t\u0003GB1\"a\u001a\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002L!1\u0011\u0011\u000e\u0001\u0005\u0012uD\u0011\"a\u001b\u0001\u0005\u0004%I!!\u0013\t\u0011\u00055\u0004\u0001)A\u0005\u0003\u0017B1\"a\u001c\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002J!Y\u0011\u0011\u000f\u0001A\u0002\u0003\u0007I\u0011CA:\u0011-\t9\b\u0001a\u0001\u0002\u0003\u0006K!a\u0013\t\u0017\u0005e\u0004\u00011AA\u0002\u0013E\u0011\u0011\n\u0005\f\u0003w\u0002\u0001\u0019!a\u0001\n#\ti\bC\u0006\u0002\u0002\u0002\u0001\r\u0011!Q!\n\u0005-\u0003bCAB\u0001\u0001\u0007\t\u0019!C\t\u0003\u0013B1\"!\"\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002\b\"Y\u00111\u0012\u0001A\u0002\u0003\u0005\u000b\u0015BA&\u0011-\ti\t\u0001a\u0001\u0002\u0004%I!a$\t\u0017\u0005]\u0005\u00011AA\u0002\u0013%\u0011\u0011\u0014\u0005\f\u0003;\u0003\u0001\u0019!A!B\u0013\t\t\nC\u0005\u0002 \u0002\u0001\r\u0011\"\u0003\u0002\"\"I\u00111\u0017\u0001A\u0002\u0013%\u0011Q\u0017\u0005\t\u0003s\u0003\u0001\u0015)\u0003\u0002$\"9\u00111\u0018\u0001\u0005\u0012\u0005u\u0006bBAi\u0001\u0011E\u00111\u001b\u0005\t\u0003+\u0004!\u0019!C\u0001e\"9\u0011q\u001b\u0001!\u0002\u0013\u0019\b\u0002CAm\u0001\t\u0007I\u0011\u0001:\t\u000f\u0005m\u0007\u0001)A\u0005g\"I\u0011Q\u001c\u0001C\u0002\u0013\u0005\u0011q\u001c\u0005\t\u0003c\u0004\u0001\u0015!\u0003\u0002b\"9\u00111\u001f\u0001\u0005\n\u0005U\bbBA~\u0001\u0011%\u0011Q \u0005\b\u0003\u007f\u0004A\u0011BA\u007f\u0011\u001d\u0011\t\u0001\u0001C!\u0003{DqAa\u0001\u0001\t#\ni\u0010C\u0004\u0003\u0006\u0001!\t&!@\t\u000f\t\u001d\u0001\u0001\"\u0005\u0003\n!I!q\u0002\u0001\u0012\u0002\u0013E!\u0011\u0003\u0005\b\u0005O\u0001A\u0011\u0002B\u0015\u0011\u001d\u0011)\u0004\u0001C\u0001\u0005oAqAa\u0017\u0001\t\u0003\u0011i\u0006C\u0004\u0003h\u0001!\tA!\u001b\u00033!Kg/\u001a+ie&4GoU3sm\u0016\u0014(\u0007V3ti\n\u000b7/\u001a\u0006\u0003\t\u0016\u000bA\u0002\u001e5sS\u001a$8/\u001a:wKJT!AR$\u0002\t!Lg/\u001a\u0006\u0003\u0011&\u000b1a]9m\u0015\tQ5*A\u0003ta\u0006\u00148N\u0003\u0002M\u001b\u00061\u0011\r]1dQ\u0016T\u0011AT\u0001\u0004_J<7\u0001A\n\u0005\u0001E+6\f\u0005\u0002S'6\t\u0011*\u0003\u0002U\u0013\ni1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"AV-\u000e\u0003]S!\u0001W'\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018B\u0001.X\u0005E\u0011UMZ8sK\u0006sG-\u00114uKJ\fE\u000e\u001c\t\u00039~k\u0011!\u0018\u0006\u0003=&\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003Av\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002GB\u0011A\rA\u0007\u0002\u0007\u0006!Qn\u001c3f+\u00059\u0007C\u00015l\u001d\t!\u0017.\u0003\u0002k\u0007\u0006Q1+\u001a:wKJlu\u000eZ3\n\u00051l'!\u0002,bYV,\u0017B\u00018p\u0005-)e.^7fe\u0006$\u0018n\u001c8\u000b\u0003A\fQa]2bY\u0006\f!b\u0011'B'N{f*Q'F+\u0005\u0019\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003\u0011a\u0017M\\4\u000b\u0003a\fAA[1wC&\u0011!0\u001e\u0002\u0007'R\u0014\u0018N\\4\u0002\u0017\rc\u0015iU*`\u001d\u0006kU\tI\u0001\u000e\u0019>;uLR%M\u000b~k\u0015IU&\u0016\u0003y\u00042a`A\u0007\u001d\u0011\t\t!!\u0003\u0011\u0007\u0005\rq.\u0004\u0002\u0002\u0006)\u0019\u0011qA(\u0002\rq\u0012xn\u001c;?\u0013\r\tYa\\\u0001\u0007!J,G-\u001a4\n\u0007i\fyAC\u0002\u0002\f=\fa\u0002T(H?\u001aKE*R0N\u0003J[\u0005%A\u0006ti\u0006\u0014HoU2sSB$\u0018\u0001D:uCJ$8k\u0019:jaR\u0004\u0013AC:u_B\u001c6M]5qi\u0006Y1\u000f^8q'\u000e\u0014\u0018\u000e\u001d;!\u0003%awnY1mQ>\u001cH/\u0001\u0006m_\u000e\fG\u000e[8ti\u0002\nQ\u0002\\5ti\u0016t\u0017N\\4Q_J$XCAA\u0012!\u0011\t)#a\n\u000e\u0003=L1!!\u000bp\u0005\rIe\u000e^\u0001\u0012Y&\u001cH/\u001a8j]\u001e\u0004vN\u001d;`I\u0015\fH\u0003BA\u0018\u0003k\u0001B!!\n\u00022%\u0019\u00111G8\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003oq\u0011\u0011!a\u0001\u0003G\t1\u0001\u001f\u00132\u00039a\u0017n\u001d;f]&tw\rU8si\u0002\n!b]3sm\u0016\u0014\bk\u001c:u\u00031A\u0017N^3D_:4G*[:u\u00035A\u0017N^3D_:4G*[:uA\u0005Y\u0001.\u001b<f-\u0006\u0014H*[:u\u00031A\u0017N^3WCJd\u0015n\u001d;!\u0003\u0011)8/\u001a:\u0002\u001b]\f'/\u001a5pkN,\u0007+\u0019;i+\t\tY\u0005\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\tf^\u0001\u0003S>LA!!\u0016\u0002P\t!a)\u001b7f\u0003E9\u0018M]3i_V\u001cX\rU1uQ~#S-\u001d\u000b\u0005\u0003_\tY\u0006C\u0005\u00028]\t\t\u00111\u0001\u0002L\u0005qq/\u0019:fQ>,8/\u001a)bi\"\u0004\u0013!D7fi\u0006\u001cHo\u001c:f!\u0006$\b.A\tnKR\f7\u000f^8sKB\u000bG\u000f[0%KF$B!a\f\u0002f!I\u0011q\u0007\u000e\u0002\u0002\u0003\u0007\u00111J\u0001\u000f[\u0016$\u0018m\u001d;pe\u0016\u0004\u0016\r\u001e5!\u0003AiW\r^1ti>\u0014XM\u00133cGV\u0013\u0018.\u0001\u0004qS\u0012$\u0015N]\u0001\ba&$G)\u001b:!\u0003\u001dawn\u001a)bi\"\f1\u0002\\8h!\u0006$\bn\u0018\u0013fcR!\u0011qFA;\u0011%\t9\u0004IA\u0001\u0002\u0004\tY%\u0001\u0005m_\u001e\u0004\u0016\r\u001e5!\u0003Ay\u0007/\u001a:bi&|g\u000eT8h!\u0006$\b.\u0001\u000bpa\u0016\u0014\u0018\r^5p]2{w\rU1uQ~#S-\u001d\u000b\u0005\u0003_\ty\bC\u0005\u00028\r\n\t\u00111\u0001\u0002L\u0005\tr\u000e]3sCRLwN\u001c'pOB\u000bG\u000f\u001b\u0011\u0002\u00171\u001c6M]1uG\"$\u0015N]\u0001\u0010YN\u001b'/\u0019;dQ\u0012K'o\u0018\u0013fcR!\u0011qFAE\u0011%\t9DJA\u0001\u0002\u0004\tY%\u0001\u0007m'\u000e\u0014\u0018\r^2i\t&\u0014\b%A\tm_\u001e$\u0016-\u001b7j]\u001e\u0004&o\\2fgN,\"!!%\u0011\u0007Q\f\u0019*C\u0002\u0002\u0016V\u0014q\u0001\u0015:pG\u0016\u001c8/A\u000bm_\u001e$\u0016-\u001b7j]\u001e\u0004&o\\2fgN|F%Z9\u0015\t\u0005=\u00121\u0014\u0005\n\u0003oI\u0013\u0011!a\u0001\u0003#\u000b!\u0003\\8h)\u0006LG.\u001b8h!J|7-Z:tA\u0005yA-[1h]>\u001c\u0018n\u001d\"vM\u001a,'/\u0006\u0002\u0002$B)\u0011QUAX}6\u0011\u0011q\u0015\u0006\u0005\u0003S\u000bY+A\u0004nkR\f'\r\\3\u000b\u0007\u00055v.\u0001\u0006d_2dWm\u0019;j_:LA!!-\u0002(\nY\u0011I\u001d:bs\n+hMZ3s\u0003M!\u0017.Y4o_NL7OQ;gM\u0016\u0014x\fJ3r)\u0011\ty#a.\t\u0013\u0005]B&!AA\u0002\u0005\r\u0016\u0001\u00053jC\u001etwn]5t\u0005V4g-\u001a:!\u0003%)\u0007\u0010\u001e:b\u0007>tg-\u0006\u0002\u0002@B)\u0011\u0011YAf}:!\u00111YAd\u001d\u0011\t\u0019!!2\n\u0003AL1!!3p\u0003\u001d\u0001\u0018mY6bO\u0016LA!!4\u0002P\n\u00191+Z9\u000b\u0007\u0005%w.\u0001\ntKJ4XM]*uCJ$8i\\7nC:$GCAA`\u0003i!\u0006JU%G)~\u0013\u0015JT!S3~\u001bVI\u0015,J\u0007\u0016{F*\u0013,F\u0003m!\u0006JU%G)~\u0013\u0015JT!S3~\u001bVI\u0015,J\u0007\u0016{F*\u0013,FA\u0005AB\u000b\u0013*J\rR{\u0006\n\u0016+Q?N+%KV%D\u000b~c\u0015JV#\u00023QC%+\u0013$U?\"#F\u000bU0T\u000bJ3\u0016jQ#`\u0019&3V\tI\u0001\u0017'\u0016\u0013f+\u0012*`'R\u000b%\u000bV+Q?RKU*R(V)V\u0011\u0011\u0011\u001d\t\u0005\u0003G\fi/\u0004\u0002\u0002f*!\u0011q]Au\u0003!!WO]1uS>t'bAAv_\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005=\u0018Q\u001d\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003]\u0019VI\u0015,F%~\u001bF+\u0011*U+B{F+S'F\u001fV#\u0006%A\tti\u0006\u0014H\u000f\u00165sS\u001a$8+\u001a:wKJ$B!a\f\u0002x\"9\u0011\u0011 \u001cA\u0002\u0005\r\u0012aB1ui\u0016l\u0007\u000f^\u0001\u0011gR|\u0007\u000f\u00165sS\u001a$8+\u001a:wKJ$\"!a\f\u0002\u0011\u0011,X\u000e\u001d'pON\f!BY3g_J,W)Y2i\u0003%\u0011WMZ8sK\u0006cG.\u0001\u0005bMR,'/\u00117m\u0003\u001dQGMY2Ve&$2A B\u0006\u0011!\u0011i\u0001\u0010I\u0001\u0002\u0004q\u0018\u0001\u00033bi\u0006\u0014\u0017m]3\u0002#)$'mY+sS\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0014)\u001aaP!\u0006,\u0005\t]\u0001\u0003\u0002B\r\u0005Gi!Aa\u0007\u000b\t\tu!qD\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\tp\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005K\u0011YBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001\u0003\u001e:z\u0007\u0006\u0004H/\u001e:f'f\u001cHj\\4\u0015\t\u0005=\"1\u0006\u0005\t\u0005[qD\u00111\u0001\u00030\u0005\ta\r\u0005\u0004\u0002&\tE\u0012qF\u0005\u0004\u0005gy'\u0001\u0003\u001fcs:\fW.\u001a \u0002G]LG\u000f['vYRL\u0007\u000f\\3D_:tWm\u0019;j_:TEMY2Ti\u0006$X-\\3oiR!!\u0011\bB+)\u0011\tyCa\u000f\t\u000f\tur\b1\u0001\u0003@\u0005\u0011am\u001d\t\u0007\u0003K\u0011\tE!\u0012\n\u0007\t\rsN\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002\u0002\"!\n\u0003H\t-\u0013qF\u0005\u0004\u0005\u0013z'!\u0003$v]\u000e$\u0018n\u001c82!\u0011\u0011iE!\u0015\u000e\u0005\t=#B\u0001%x\u0013\u0011\u0011\u0019Fa\u0014\u0003\u0013M#\u0018\r^3nK:$\bb\u0002B,\u007f\u0001\u0007!\u0011L\u0001\u000bi\u0006\u0014G.\u001a(b[\u0016\u001c\b#BA\u0013\u0005\u0003r\u0018\u0001D<ji\"$\u0015\r^1cCN,G\u0003\u0002B0\u0005G\"B!a\f\u0003b!9!Q\b!A\u0002\t}\u0002b\u0002B3\u0001\u0002\u0007!\u0011L\u0001\bI\nt\u0015-\\3t\u0003E9\u0018\u000e\u001e5KI\n\u001c7\u000b^1uK6,g\u000e\u001e\u000b\u0005\u0005W\u0012y\u0007\u0006\u0003\u00020\t5\u0004b\u0002B\u0017\u0003\u0002\u0007!Q\t\u0005\b\u0005/\n\u0005\u0019\u0001B-\u0001")
public abstract class HiveThriftServer2TestBase
extends SparkFunSuite {
    private final String CLASS_NAME = new StringOps(Predef$.MODULE$.augmentString(HiveThriftServer2$.MODULE$.getClass().getCanonicalName())).stripSuffix("$");
    private final String org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$LOG_FILE_MARK = new StringBuilder(22).append("starting ").append(this.CLASS_NAME()).append(", logging to ").toString();
    private final String startScript = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])"../../sbin/start-thriftserver.sh".split("/"))).mkString(File.separator);
    private final String stopScript = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])"../../sbin/stop-thriftserver.sh".split("/"))).mkString(File.separator);
    private final String localhost = Utils$.MODULE$.localCanonicalHostName();
    private int listeningPort;
    private final String hiveConfList;
    private final String hiveVarList;
    private File warehousePath;
    private File metastorePath;
    private final File pidDir;
    private File logPath;
    private File operationLogPath;
    private File lScratchDir;
    private Process logTailingProcess;
    private ArrayBuffer<String> diagnosisBuffer;
    private final String THRIFT_BINARY_SERVICE_LIVE;
    private final String THRIFT_HTTP_SERVICE_LIVE;
    private final FiniteDuration SERVER_STARTUP_TIMEOUT;

    public abstract Enumeration.Value mode();

    private String CLASS_NAME() {
        return this.CLASS_NAME;
    }

    public String org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$LOG_FILE_MARK() {
        return this.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$LOG_FILE_MARK;
    }

    public String startScript() {
        return this.startScript;
    }

    public String stopScript() {
        return this.stopScript;
    }

    public String localhost() {
        return this.localhost;
    }

    private int listeningPort() {
        return this.listeningPort;
    }

    private void listeningPort_$eq(int x$1) {
        this.listeningPort = x$1;
    }

    public int serverPort() {
        return this.listeningPort();
    }

    public String hiveConfList() {
        return this.hiveConfList;
    }

    public String hiveVarList() {
        return this.hiveVarList;
    }

    public String user() {
        return System.getProperty("user.name");
    }

    public File warehousePath() {
        return this.warehousePath;
    }

    public void warehousePath_$eq(File x$1) {
        this.warehousePath = x$1;
    }

    public File metastorePath() {
        return this.metastorePath;
    }

    public void metastorePath_$eq(File x$1) {
        this.metastorePath = x$1;
    }

    public String metastoreJdbcUri() {
        return new StringBuilder(37).append("jdbc:derby:;databaseName=").append(this.metastorePath()).append(";create=true").toString();
    }

    private File pidDir() {
        return this.pidDir;
    }

    public File logPath() {
        return this.logPath;
    }

    public void logPath_$eq(File x$1) {
        this.logPath = x$1;
    }

    public File operationLogPath() {
        return this.operationLogPath;
    }

    public void operationLogPath_$eq(File x$1) {
        this.operationLogPath = x$1;
    }

    public File lScratchDir() {
        return this.lScratchDir;
    }

    public void lScratchDir_$eq(File x$1) {
        this.lScratchDir = x$1;
    }

    private Process logTailingProcess() {
        return this.logTailingProcess;
    }

    private void logTailingProcess_$eq(Process x$1) {
        this.logTailingProcess = x$1;
    }

    private ArrayBuffer<String> diagnosisBuffer() {
        return this.diagnosisBuffer;
    }

    private void diagnosisBuffer_$eq(ArrayBuffer<String> x$1) {
        this.diagnosisBuffer = x$1;
    }

    public Seq<String> extraConf() {
        return Nil$.MODULE$;
    }

    public Seq<String> serverStartCommand() {
        Enumeration.Value value = this.mode();
        Enumeration.Value value2 = ServerMode$.MODULE$.binary();
        HiveConf.ConfVars portConf = !(value != null ? !value.equals(value2) : value2 != null) ? HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT : HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT;
        String tempLog4jConf = Utils$.MODULE$.createTempDir().getCanonicalPath();
        Files.write((CharSequence)new StringOps(Predef$.MODULE$.augmentString("rootLogger.level = info\n          |rootLogger.appenderRef.stdout.ref = console\n          |appender.console.type = Console\n          |appender.console.name = console\n          |appender.console.target = SYSTEM_ERR\n          |appender.console.layout.type = PatternLayout\n          |appender.console.layout.pattern = %d{HH:mm:ss.SSS} %p %c: %maxLen{%m}{512}%n%ex{8}%n\n        ")).stripMargin(), (File)new File(new StringBuilder(18).append(tempLog4jConf).append("/log4j2.properties").toString()), (Charset)StandardCharsets.UTF_8);
        String driverClassPath = tempLog4jConf;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(322).append(this.startScript()).append("\n       |  --master local\n       |  --hiveconf ").append(HiveConf.ConfVars.METASTORECONNECTURLKEY).append("=").append(this.metastoreJdbcUri()).append("\n       |  --hiveconf ").append(HiveConf.ConfVars.METASTOREWAREHOUSE).append("=").append(this.warehousePath()).append("\n       |  --hiveconf ").append(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST).append("=").append(this.localhost()).append("\n       |  --hiveconf ").append(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE).append("=").append(this.mode()).append("\n       |  --hiveconf ").append(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LOG_LOCATION).append("=").append(this.operationLogPath()).append("\n       |  --hiveconf ").append(HiveConf.ConfVars.LOCALSCRATCHDIR).append("=").append(this.lScratchDir()).append("\n       |  --hiveconf ").append(portConf).append("=0\n       |  --driver-class-path ").append(driverClassPath).append("\n       |  --driver-java-options -Dlog4j2.debug\n       |  --conf spark.ui.enabled=false\n       |  ").append(this.extraConf().mkString("\n")).append("\n     ").toString())).stripMargin().split("\\s+"))).toSeq();
    }

    public String THRIFT_BINARY_SERVICE_LIVE() {
        return this.THRIFT_BINARY_SERVICE_LIVE;
    }

    public String THRIFT_HTTP_SERVICE_LIVE() {
        return this.THRIFT_HTTP_SERVICE_LIVE;
    }

    public FiniteDuration SERVER_STARTUP_TIMEOUT() {
        return this.SERVER_STARTUP_TIMEOUT;
    }

    private void startThriftServer(int attempt) {
        this.warehousePath_$eq(Utils$.MODULE$.createTempDir());
        this.warehousePath().delete();
        this.metastorePath_$eq(Utils$.MODULE$.createTempDir());
        this.metastorePath().delete();
        this.operationLogPath_$eq(Utils$.MODULE$.createTempDir());
        this.operationLogPath().delete();
        this.lScratchDir_$eq(Utils$.MODULE$.createTempDir());
        this.lScratchDir().delete();
        this.logPath_$eq(null);
        this.logTailingProcess_$eq(null);
        Seq<String> command = this.serverStartCommand();
        this.diagnosisBuffer().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(130).append("\n         |### Attempt ").append(attempt).append(" ###\n         |HiveThriftServer2 command line: ").append(command).append("\n         |Listening port: 0\n         |System user: ").append(this.user()).append("\n       ").toString())).stripMargin().split("\n"))));
        Seq<String> x$1 = command;
        scala.collection.immutable.Map x$2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_TESTING"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_SQL_TESTING"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_PID_DIR"), (Object)this.pidDir().getCanonicalPath())}));
        boolean x$3 = true;
        File x$4 = Utils$.MODULE$.executeAndGetOutput$default$2();
        String lines = Utils$.MODULE$.executeAndGetOutput(x$1, x$4, (Map)x$2, x$3);
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("COMMAND: ").append(command).toString());
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("OUTPUT: ").append(lines).toString());
        this.logPath_$eq((File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines.split("\n"))).collectFirst((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HiveThriftServer2TestBase $outer;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.contains(this.$outer.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$LOG_FILE_MARK())) {
                    return (B1)new File((String)new StringOps(Predef$.MODULE$.augmentString(A1)).drop(this.$outer.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$LOG_FILE_MARK().length()));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                return string.contains(this.$outer.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$LOG_FILE_MARK());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Failed to find HiveThriftServer2 log file.");
        }));
        Promise serverStarted = Promise$.MODULE$.apply();
        this.logPath().createNewFile();
        Enumeration.Value value = this.mode();
        Enumeration.Value value2 = ServerMode$.MODULE$.http();
        String successLine = !(value != null ? !value.equals(value2) : value2 != null) ? this.THRIFT_HTTP_SERVICE_LIVE() : this.THRIFT_BINARY_SERVICE_LIVE();
        String[] command2 = new StringBuilder(27).append("/usr/bin/env tail -n +0 -f ").append(this.logPath().getCanonicalPath()).toString().split(" ");
        ProcessBuilder builder = new ProcessBuilder(command2);
        Function1 & Serializable & scala.Serializable captureOutput = (Function1 & Serializable & scala.Serializable)line -> {
            HiveThriftServer2TestBase.$anonfun$startThriftServer$5(this, successLine, attempt, serverStarted, line);
            return BoxedUnit.UNIT;
        };
        Process process = builder.start();
        new ProcessTestUtils.ProcessOutputCapturer(process.getInputStream(), (Function1)captureOutput).start();
        new ProcessTestUtils.ProcessOutputCapturer(process.getErrorStream(), (Function1)captureOutput).start();
        this.logTailingProcess_$eq(process);
        ShutdownHookManager$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.stopThriftServer());
        ThreadUtils$.MODULE$.awaitResult((Awaitable)serverStarted.future(), (Duration)this.SERVER_STARTUP_TIMEOUT());
    }

    private void stopThriftServer() {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.pidDir().list())).nonEmpty()) {
            Seq x$1 = (Seq)new .colon.colon((Object)this.stopScript(), (List)Nil$.MODULE$);
            scala.collection.immutable.Map x$2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_PID_DIR"), (Object)this.pidDir().getCanonicalPath())}));
            File x$3 = Utils$.MODULE$.executeAndGetOutput$default$2();
            boolean x$4 = Utils$.MODULE$.executeAndGetOutput$default$4();
            Utils$.MODULE$.executeAndGetOutput(x$1, x$3, (Map)x$2, x$4);
            Thread.sleep(new package.DurationInt(package$.MODULE$.DurationInt(3)).seconds().toMillis());
            this.warehousePath().delete();
            this.warehousePath_$eq(null);
            this.metastorePath().delete();
            this.metastorePath_$eq(null);
            this.operationLogPath().delete();
            this.operationLogPath_$eq(null);
            this.lScratchDir().delete();
            this.lScratchDir_$eq(null);
            Option$.MODULE$.apply((Object)this.logPath()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.delete()));
            this.logPath_$eq(null);
            Option$.MODULE$.apply((Object)this.logTailingProcess()).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.destroy();
                return BoxedUnit.UNIT;
            });
            this.logTailingProcess_$eq(null);
            return;
        }
    }

    public void org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$dumpLogs() {
        this.logError((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(319).append("\n         |=====================================\n         |HiveThriftServer2Suite failure output\n         |=====================================\n         |").append(this.diagnosisBuffer().mkString("\n")).append("\n         |=========================================\n         |End HiveThriftServer2Suite failure output\n         |=========================================\n       ").toString())).stripMargin());
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        System.gc();
    }

    public void beforeAll() {
        super.beforeAll();
        this.diagnosisBuffer().clear();
        ((Try)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).foldLeft((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.startThriftServer(0)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> HiveThriftServer2TestBase.$anonfun$beforeAll$2(this, x0$1, BoxesRunTime.unboxToInt((Object)x1$1)))).recover((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HiveThriftServer2TestBase $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    this.$outer.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$dumpLogs();
                    throw A12;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable != null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> "HiveThriftServer2 started successfully");
    }

    public void afterAll() {
        try {
            this.stopThriftServer();
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> "HiveThriftServer2 stopped");
        }
        finally {
            super.afterAll();
        }
    }

    public String jdbcUri(String database) {
        Enumeration.Value value = this.mode();
        Enumeration.Value value2 = ServerMode$.MODULE$.http();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(133).append("jdbc:hive2://").append(this.localhost()).append(":").append(this.serverPort()).append("/\n       |").append(database).append("?\n       |hive.server2.transport.mode=http;\n       |hive.server2.thrift.http.path=cliservice;\n       |").append(this.hiveConfList()).append("#").append(this.hiveVarList()).append("\n     ").toString())).stripMargin().split("\n"))).mkString().trim();
        }
        return new StringBuilder(17).append("jdbc:hive2://").append(this.localhost()).append(":").append(this.serverPort()).append("/").append(database).append("?").append(this.hiveConfList()).append("#").append(this.hiveVarList()).toString();
    }

    public String jdbcUri$default$1() {
        return "default";
    }

    private void tryCaptureSysLog(Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Exception e) {
            this.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$dumpLogs();
            throw e;
        }
    }

    public void withMultipleConnectionJdbcStatement(Seq<String> tableNames, Seq<Function1<Statement, BoxedUnit>> fs) {
        this.tryCaptureSysLog((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String user = System.getProperty("user.name");
            Seq connections = (Seq)fs.map((Function1 & Serializable & scala.Serializable)x$9 -> DriverManager.getConnection(this.jdbcUri(this.jdbcUri$default$1()), user, ""), Seq$.MODULE$.canBuildFrom());
            Seq statements = (Seq)connections.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.createStatement(), Seq$.MODULE$.canBuildFrom());
            try {
                ((IterableLike)statements.zip((GenIterable)fs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    HiveThriftServer2TestBase.$anonfun$withMultipleConnectionJdbcStatement$4(x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            finally {
                tableNames.foreach((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2TestBase.$anonfun$withMultipleConnectionJdbcStatement$5(statements, name)));
                statements.foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                    x$11.close();
                    return BoxedUnit.UNIT;
                });
                connections.foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
                    x$12.close();
                    return BoxedUnit.UNIT;
                });
            }
        });
    }

    public void withDatabase(Seq<String> dbNames, Seq<Function1<Statement, BoxedUnit>> fs) {
        this.tryCaptureSysLog((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String user = System.getProperty("user.name");
            Seq connections = (Seq)fs.map((Function1 & Serializable & scala.Serializable)x$13 -> DriverManager.getConnection(this.jdbcUri(this.jdbcUri$default$1()), user, ""), Seq$.MODULE$.canBuildFrom());
            Seq statements = (Seq)connections.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.createStatement(), Seq$.MODULE$.canBuildFrom());
            try {
                ((IterableLike)statements.zip((GenIterable)fs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    HiveThriftServer2TestBase.$anonfun$withDatabase$4(x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            finally {
                dbNames.foreach((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2TestBase.$anonfun$withDatabase$5(statements, name)));
                statements.foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
                    x$15.close();
                    return BoxedUnit.UNIT;
                });
                connections.foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
                    x$16.close();
                    return BoxedUnit.UNIT;
                });
            }
        });
    }

    public void withJdbcStatement(Seq<String> tableNames, Function1<Statement, BoxedUnit> f) {
        this.withMultipleConnectionJdbcStatement(tableNames, (Seq<Function1<Statement, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{f}));
    }

    public static final /* synthetic */ void $anonfun$startThriftServer$5(HiveThriftServer2TestBase $this, String successLine$1, int attempt$1, Promise serverStarted$1, String line) {
        ArrayBuffer<String> arrayBuffer = $this.diagnosisBuffer();
        synchronized (arrayBuffer) {
            $this.diagnosisBuffer().$plus$eq((Object)line);
            if (line.contains(successLine$1)) {
                $this.listeningPort_$eq(new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(line.split(" on port ")[1])).split(' '))).head())).toInt());
                $this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Started HiveThriftServer2: port=").append($this.listeningPort()).append(", mode=").append($this.mode()).append(", attempt=").append(attempt$1).toString());
                serverStarted$1.trySuccess((Object)BoxedUnit.UNIT);
            }
        }
    }

    public static final /* synthetic */ Try $anonfun$beforeAll$2(HiveThriftServer2TestBase $this, Try x0$1, int x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToInteger((int)x1$1));
        if (tuple2 != null) {
            Try started = (Try)tuple2._1();
            int attempt = tuple2._2$mcI$sp();
            return started.orElse((Function0 & Serializable & scala.Serializable)() -> {
                $this.stopThriftServer();
                return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.startThriftServer(attempt);
                    Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withJdbcStatement((Seq<String>)Nil$.MODULE$, (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$8 -> {
                        x$8.execute("SELECT 1");
                        return BoxedUnit.UNIT;
                    }), Retrying$.MODULE$.retryingNatureOfT(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1406));
                });
            });
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$withMultipleConnectionJdbcStatement$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Statement s = (Statement)tuple2._1();
            Function1 f = (Function1)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)f.apply((Object)s);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$withMultipleConnectionJdbcStatement$5(Seq statements$1, String name) {
        if (name.toUpperCase(Locale.ROOT).startsWith("VIEW")) {
            return ((Statement)statements$1.apply(0)).execute(new StringBuilder(20).append("DROP VIEW IF EXISTS ").append(name).toString());
        }
        return ((Statement)statements$1.apply(0)).execute(new StringBuilder(21).append("DROP TABLE IF EXISTS ").append(name).toString());
    }

    public static final /* synthetic */ void $anonfun$withDatabase$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Statement s = (Statement)tuple2._1();
            Function1 f = (Function1)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)f.apply((Object)s);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$withDatabase$5(Seq statements$2, String name) {
        return ((Statement)statements$2.apply(0)).execute(new StringBuilder(24).append("DROP DATABASE IF EXISTS ").append(name).toString());
    }

    public HiveThriftServer2TestBase() {
        this.hiveConfList = "a=avalue;b=bvalue";
        this.hiveVarList = "c=cvalue;d=dvalue";
        String x$1 = "thriftserver-pid";
        String x$2 = Utils$.MODULE$.createTempDir$default$1();
        this.pidDir = Utils$.MODULE$.createTempDir(x$2, x$1);
        this.diagnosisBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.THRIFT_BINARY_SERVICE_LIVE = "Starting ThriftBinaryCLIService on port";
        this.THRIFT_HTTP_SERVICE_LIVE = "Started ThriftHttpCLIService in http";
        this.SERVER_STARTUP_TIMEOUT = new package.DurationInt(package$.MODULE$.DurationInt(3)).minutes();
        Utils$.MODULE$.classForName(HiveDriver.class.getCanonicalName(), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
    }
}

