/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkConf;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.hive.orc.OrcFileFormat;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class OrcReadBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static OrcReadBenchmark$ MODULE$;
    private final String NATIVE_ORC_FORMAT;
    private final String HIVE_ORC_FORMAT;
    private final SparkSession spark;
    private String sparkHome;
    private volatile boolean bitmap$0;

    static {
        new OrcReadBenchmark$();
    }

    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$((SqlBasedBenchmark)this, (String)name, (long)cardinality, f);
    }

    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$((SqlBasedBenchmark)this, ds);
    }

    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$((SqlBasedBenchmark)this, (Benchmark)benchmark);
    }

    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$((SqlBasedBenchmark)this, (String)path, (int)rowsNum, (int)numCols);
    }

    public void afterAll() {
        SqlBasedBenchmark.afterAll$((SqlBasedBenchmark)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private String sparkHome$lzycompute() {
        OrcReadBenchmark$ orcReadBenchmark$ = this;
        synchronized (orcReadBenchmark$) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public SparkSession getSparkSession() {
        SparkConf conf = new SparkConf();
        conf.set("orc.compression", "snappy");
        SparkSession sparkSession = SparkSession$.MODULE$.builder().master("local[1]").appName("OrcReadBenchmark").config(conf).getOrCreate();
        sparkSession.conf().set(SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key(), "true");
        return sparkSession;
    }

    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            tableNames.foreach((Function1 & Serializable & scala.Serializable)viewName -> BoxesRunTime.boxToBoolean((boolean)OrcReadBenchmark$.$anonfun$withTempTable$1(viewName)));
        }
    }

    private String NATIVE_ORC_FORMAT() {
        return this.NATIVE_ORC_FORMAT;
    }

    private String HIVE_ORC_FORMAT() {
        return this.HIVE_ORC_FORMAT;
    }

    private void prepareTable(File dir, Dataset<Row> df, Option<String> partition) {
        String dirORC = dir.getCanonicalPath();
        if (partition.isDefined()) {
            df.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)partition.get()})).orc(dirORC);
        } else {
            df.write().orc(dirORC);
        }
        this.spark().read().format(this.NATIVE_ORC_FORMAT()).load(dirORC).createOrReplaceTempView("nativeOrcTable");
        this.spark().read().format(this.HIVE_ORC_FORMAT()).load(dirORC).createOrReplaceTempView("hiveOrcTable");
    }

    private Option<String> prepareTable$default$3() {
        return None$.MODULE$;
    }

    public void numericScanBenchmark(int values, DataType dataType) {
        String x$1 = new StringBuilder(23).append("SQL Single ").append(dataType.sql()).append(" Column Scan").toString();
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OrcReadBenchmark$.MODULE$.spark().range((long)values$1).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql(new StringBuilder(33).append("SELECT CAST(value as ").append(dataType$1.sql()).append(") id FROM t1").toString()), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$1.addCase("Hive built-in ORC", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM hiveOrcTable")).noop());
                benchmark$1.addCase("Native ORC MR", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM nativeOrcTable")).noop()));
                benchmark$1.addCase("Native ORC Vectorized", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM nativeOrcTable")).noop());
                benchmark$1.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void intStringScanBenchmark(int values) {
        String x$1 = "Int and String Scan";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OrcReadBenchmark$.MODULE$.spark().range((long)values$2).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT CAST(value AS INT) AS c1, CAST(value as STRING) AS c2 FROM t1"), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$2.addCase("Hive built-in ORC", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM hiveOrcTable")).noop());
                benchmark$2.addCase("Native ORC MR", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$7 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM nativeOrcTable")).noop()));
                benchmark$2.addCase("Native ORC Vectorized", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$8 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM nativeOrcTable")).noop());
                benchmark$2.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void partitionTableScanBenchmark(int values) {
        String x$1 = "Partitioned Table";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OrcReadBenchmark$.MODULE$.spark().range((long)values$3).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT value % 2 AS p, value AS id FROM t1"), (Option<String>)new Some((Object)"p"));
                benchmark$3.addCase("Data column - Hive built-in ORC", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$10 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM hiveOrcTable")).noop());
                benchmark$3.addCase("Data column - Native ORC MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$11 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM nativeOrcTable")).noop()));
                benchmark$3.addCase("Data column - Native ORC Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$12 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM nativeOrcTable")).noop());
                benchmark$3.addCase("Partition column - Hive built-in ORC", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$13 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM hiveOrcTable")).noop());
                benchmark$3.addCase("Partition column - Native ORC MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$14 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM nativeOrcTable")).noop()));
                benchmark$3.addCase("Partition column - Native ORC Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$15 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM nativeOrcTable")).noop());
                benchmark$3.addCase("Both columns - Hive built-in ORC", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$16 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM hiveOrcTable")).noop());
                benchmark$3.addCase("Both columns - Native ORC MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$17 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM nativeOrcTable")).noop()));
                benchmark$3.addCase("Both columns - Native ORC Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$18 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM nativeOrcTable")).noop());
                benchmark$3.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void repeatedStringScanBenchmark(int values) {
        String x$1 = "Repeated String";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OrcReadBenchmark$.MODULE$.spark().range((long)values$4).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT CAST((id % 200) + 10000 as STRING) AS c1 FROM t1"), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$4.addCase("Hive built-in ORC", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$19 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(length(c1)) FROM hiveOrcTable")).noop());
                benchmark$4.addCase("Native ORC MR", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$20 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(length(c1)) FROM nativeOrcTable")).noop()));
                benchmark$4.addCase("Native ORC Vectorized", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$21 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(length(c1)) FROM nativeOrcTable")).noop());
                benchmark$4.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void stringWithNullsScanBenchmark(int values, double fractionOfNulls) {
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OrcReadBenchmark$.MODULE$.spark().range((long)values$5).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql(new StringBuilder(109).append("SELECT IF(RAND(1) < ").append(fractionOfNulls$1).append(", NULL, CAST(id as STRING)) AS c1, ").append("IF(RAND(2) < ").append(fractionOfNulls$1).append(", NULL, CAST(id as STRING)) AS c2 FROM t1").toString()), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                double percentageOfNulls = fractionOfNulls$1 * (double)100;
                String x$1 = new StringBuilder(26).append("String with Nulls Scan (").append(percentageOfNulls).append("%)").toString();
                long x$2 = values$5;
                Option x$3 = OrcReadBenchmark$.MODULE$.output();
                int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
                FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
                FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
                boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
                Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
                benchmark.addCase("Hive built-in ORC", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$22 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM hiveOrcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL")).noop());
                benchmark.addCase("Native ORC MR", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$23 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM nativeOrcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL")).noop()));
                benchmark.addCase("Native ORC Vectorized", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$24 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM nativeOrcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL")).noop());
                benchmark.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void columnsBenchmark(int values, int width) {
        String x$1 = new StringBuilder(32).append("Single Column Scan from ").append(width).append(" columns").toString();
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                int middle = width$1 / 2;
                IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width$1).map((Function1 & Serializable & scala.Serializable)i -> OrcReadBenchmark$.$anonfun$columnsBenchmark$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                OrcReadBenchmark$.MODULE$.spark().range((long)values$6).map((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).toDF().selectExpr((Seq)selectExpr).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM t1"), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$5.addCase("Hive built-in ORC", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$26 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql(new StringBuilder(31).append("SELECT sum(c").append(middle).append(") FROM hiveOrcTable").toString())).noop());
                benchmark$5.addCase("Native ORC MR", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$27 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql(new StringBuilder(33).append("SELECT sum(c").append(middle).append(") FROM nativeOrcTable").toString())).noop()));
                benchmark$5.addCase("Native ORC Vectorized", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$28 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql(new StringBuilder(33).append("SELECT sum(c").append(middle).append(") FROM nativeOrcTable").toString())).noop());
                benchmark$5.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void structBenchmark(int values, int width) {
        String x$1 = new StringBuilder(38).append("Single Struct Column Scan with ").append(width).append(" Fields").toString();
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String selectExprCore = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width$2).map((Function1 & Serializable & scala.Serializable)i -> OrcReadBenchmark$.$anonfun$structBenchmark$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",");
                Seq selectExpr = (Seq)new .colon.colon((Object)new StringBuilder(20).append("named_struct(").append(selectExprCore).append(") as c1").toString(), (List)Nil$.MODULE$);
                OrcReadBenchmark$.MODULE$.spark().range((long)values$7).map((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).toDF().selectExpr(selectExpr).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM t1"), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$6.addCase("Hive built-in ORC", benchmark$6.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$30 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM hiveOrcTable")).noop());
                benchmark$6.addCase("Native ORC MR", benchmark$6.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$31 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM nativeOrcTable")).noop()));
                benchmark$6.addCase("Native ORC Vectorized", benchmark$6.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$32 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM nativeOrcTable")).noop()));
                benchmark$6.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void nestedStructBenchmark(int values, int elementCount, int structWidth) {
        String x$1 = new StringBuilder(42).append("Nested Struct Scan with ").append(elementCount).append(" Elements, ").append(structWidth).append(" Fields").toString();
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String structExprFields = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), structWidth$1).map((Function1 & Serializable & scala.Serializable)i -> OrcReadBenchmark$.$anonfun$nestedStructBenchmark$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",");
                String structExpr = new StringBuilder(14).append("named_struct(").append(structExprFields).append(")").toString();
                String arrayExprElements = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), elementCount$1).map((Function1 & Serializable & scala.Serializable)x$33 -> OrcReadBenchmark$.$anonfun$nestedStructBenchmark$4(structExpr, BoxesRunTime.unboxToInt((Object)x$33)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",");
                Seq selectExpr = (Seq)new .colon.colon((Object)new StringBuilder(13).append("array(").append(arrayExprElements).append(") as c1").toString(), (List)Nil$.MODULE$);
                Predef$.MODULE$.print((Object)new StringBuilder(22).append("select expression is ").append(selectExpr).append("\n").toString());
                OrcReadBenchmark$.MODULE$.spark().range((long)values$8).map((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).toDF().selectExpr(selectExpr).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM t1"), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$7.addCase("Hive built-in ORC", benchmark$7.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$35 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM hiveOrcTable")).noop());
                benchmark$7.addCase("Native ORC MR", benchmark$7.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$36 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM nativeOrcTable")).noop()));
                benchmark$7.addCase("Native ORC Vectorized", benchmark$7.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$37 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM nativeOrcTable")).noop()));
                benchmark$7.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("SQL Single Numeric Column Scan", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)ByteType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)LongType$.MODULE$, (List)new .colon.colon((Object)FloatType$.MODULE$, (List)new .colon.colon((Object)DoubleType$.MODULE$, (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable & scala.Serializable)dataType -> {
            OrcReadBenchmark$.MODULE$.numericScanBenchmark(0xF00000, (DataType)dataType);
            return BoxedUnit.UNIT;
        }));
        this.runBenchmark("Int and String Scan", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.intStringScanBenchmark(0xA00000));
        this.runBenchmark("Partitioned Table Scan", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.partitionTableScanBenchmark(0xF00000));
        this.runBenchmark("Repeated String Scan", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.repeatedStringScanBenchmark(0xA00000));
        this.runBenchmark("String with Nulls Scan", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5, 0.95})).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)fractionOfNulls -> MODULE$.stringWithNullsScanBenchmark(0xA00000, fractionOfNulls)));
        this.runBenchmark("Single Column Scan From Wide Columns", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.columnsBenchmark(0x100000, 100);
            MODULE$.columnsBenchmark(0x100000, 200);
            MODULE$.columnsBenchmark(0x100000, 300);
        });
        this.runBenchmark("Struct scan", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.structBenchmark(0x100000, 10);
            MODULE$.structBenchmark(0x100000, 100);
            MODULE$.structBenchmark(0x100000, 300);
            MODULE$.structBenchmark(0x100000, 600);
        });
        this.runBenchmark("Nested Struct scan", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.nestedStructBenchmark(0x100000, 10, 10);
            MODULE$.nestedStructBenchmark(0x100000, 30, 10);
            MODULE$.nestedStructBenchmark(0x100000, 10, 30);
        });
    }

    public static final /* synthetic */ boolean $anonfun$withTempTable$1(String viewName) {
        return MODULE$.spark().catalog().dropTempView(viewName);
    }

    public static final /* synthetic */ String $anonfun$columnsBenchmark$3(int i) {
        return new StringBuilder(10).append("value as c").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$structBenchmark$3(int i) {
        return new StringBuilder(10).append("'f").append(i).append("', value").toString();
    }

    public static final /* synthetic */ String $anonfun$nestedStructBenchmark$3(int i) {
        return new StringBuilder(10).append("'f").append(i).append("', value").toString();
    }

    public static final /* synthetic */ String $anonfun$nestedStructBenchmark$4(String structExpr$1, int x$33) {
        return String.valueOf(structExpr$1);
    }

    private OrcReadBenchmark$() {
        MODULE$ = this;
        SQLHelper.$init$((SQLHelper)this);
        SqlBasedBenchmark.$init$((SqlBasedBenchmark)this);
        this.NATIVE_ORC_FORMAT = org.apache.spark.sql.execution.datasources.orc.OrcFileFormat.class.getCanonicalName();
        this.HIVE_ORC_FORMAT = OrcFileFormat.class.getCanonicalName();
    }
}

