/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.Classifier;
import org.apache.spark.ml.classification.ClassifierSuite$;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\r\u001b\u0001\u0015BQA\r\u0001\u0005\u0002MBQA\u000e\u0001\u0005\n]:Q\u0001\u0018\u000e\t\u0002u3Q!\u0007\u000e\t\u0002yCQA\r\u0003\u0005\u0002\u0015DqA\u001a\u0003C\u0002\u0013\u0005q\r\u0003\u0004w\t\u0001\u0006I\u0001\u001b\u0004\u0005o\u0012\u0001\u0001\u0010\u0003\u0006\u0002\u0016!\u0011)\u0019!C!\u0003/A\u0011\"!\u0007\t\u0005\u0003\u0005\u000b\u0011\u00029\t\rIBA\u0011AA$\u0011\u0019\u0011\u0004\u0002\"\u0001\u0002L!9\u0011\u0011\u0006\u0005\u0005B\u00055\u0003bBA)\u0011\u0011\u0005\u00131\u000b\u0005\b\u0003gBA\u0011AA;\r\u0019\tY\u0001\u0002\u0001\u0002\u000e!Q\u0011Q\u0003\t\u0003\u0006\u0004%\t%a\u0006\t\u0013\u0005e\u0001C!A!\u0002\u0013\u0001\bB\u0002\u001a\u0011\t\u0003\tY\u0002\u0003\u00043!\u0011\u0005\u0011q\u0004\u0005\b\u0003C\u0001B\u0011AA\u0012\u0011\u001d\tI\u0003\u0005C!\u0003WAq!!\u0010\u0011\t\u0003\ny\u0004C\u0005\u0002\u0004\u0012\t\t\u0011\"\u0003\u0002\u0006\ny1\t\\1tg&4\u0017.\u001a:Tk&$XM\u0003\u0002\u001c9\u0005q1\r\\1tg&4\u0017nY1uS>t'BA\u000f\u001f\u0003\tiGN\u0003\u0002 A\u0005)1\u000f]1sW*\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0014+!\t9\u0003&D\u0001\u001f\u0013\tIcDA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\nA!\u001e;jY*\u0011qFH\u0001\u0006[2d\u0017NY\u0005\u0003c1\u0012Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0002iA\u0011Q\u0007A\u0007\u00025\u0005Yq-\u001a;UKN$H)\u0019;b)\tAD\n\u0005\u0002:\u0013:\u0011!H\u0012\b\u0003w\u0011s!\u0001P\"\u000f\u0005u\u0012eB\u0001 B\u001b\u0005y$B\u0001!%\u0003\u0019a$o\\8u}%\t1%\u0003\u0002\"E%\u0011q\u0004I\u0005\u0003\u000bz\t1a]9m\u0013\t9\u0005*A\u0004qC\u000e\\\u0017mZ3\u000b\u0005\u0015s\u0012B\u0001&L\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002H\u0011\")QJ\u0001a\u0001\u001d\u00061A.\u00192fYN\u00042aT+Y\u001d\t\u00016K\u0004\u0002?#&\t!+A\u0003tG\u0006d\u0017-\u0003\u0002H)*\t!+\u0003\u0002W/\n\u00191+Z9\u000b\u0005\u001d#\u0006CA-[\u001b\u0005!\u0016BA.U\u0005\u0019!u.\u001e2mK\u0006y1\t\\1tg&4\u0017.\u001a:Tk&$X\r\u0005\u00026\tM\u0019Aa\u00182\u0011\u0005e\u0003\u0017BA1U\u0005\u0019\te.\u001f*fMB\u0011\u0011lY\u0005\u0003IR\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\u0012!X\u0001\u0011C2d\u0007+\u0019:b[N+G\u000f^5oON,\u0012\u0001\u001b\t\u0005S6\u00048O\u0004\u0002kWB\u0011a\bV\u0005\u0003YR\u000ba\u0001\u0015:fI\u00164\u0017B\u00018p\u0005\ri\u0015\r\u001d\u0006\u0003YR\u0003\"![9\n\u0005I|'AB*ue&tw\r\u0005\u0002Zi&\u0011Q\u000f\u0016\u0002\u0004\u0003:L\u0018!E1mYB\u000b'/Y7TKR$\u0018N\\4tA\tqQj\\2l\u00072\f7o]5gS\u0016\u00148C\u0001\u0005z!\u001d)$\u0010`A\u0003\u0003\u0013I!a\u001f\u000e\u0003\u0015\rc\u0017m]:jM&,'\u000fE\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007fr\ta\u0001\\5oC2<\u0017bAA\u0002}\n1a+Z2u_J\u00042!a\u0002\t\u001b\u0005!\u0001cAA\u0004!\t9Rj\\2l\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\\\n\u0004!\u0005=\u0001CB\u001b\u0002\u0012q\fI!C\u0002\u0002\u0014i\u00111c\u00117bgNLg-[2bi&|g.T8eK2\f1!^5e+\u0005\u0001\u0018\u0001B;jI\u0002\"B!!\u0003\u0002\u001e!1\u0011QC\nA\u0002A$\"!!\u0003\u0002\u0015A\u0014X\rZ5diJ\u000bw\u000fF\u0002}\u0003KAa!a\n\u0016\u0001\u0004a\u0018\u0001\u00034fCR,(/Z:\u0002\t\r|\u0007/\u001f\u000b\u0005\u0003\u0013\ti\u0003C\u0004\u00020Y\u0001\r!!\r\u0002\u000b\u0015DHO]1\u0011\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000e\u001d\u0003\u0015\u0001\u0018M]1n\u0013\u0011\tY$!\u000e\u0003\u0011A\u000b'/Y7NCB\f!B\\;n\u00072\f7o]3t+\t\t\t\u0005E\u0002Z\u0003\u0007J1!!\u0012U\u0005\rIe\u000e\u001e\u000b\u0005\u0003\u000b\tI\u0005\u0003\u0004\u0002\u0016-\u0001\r\u0001\u001d\u000b\u0003\u0003\u000b!B!!\u0002\u0002P!9\u0011qF\u0007A\u0002\u0005E\u0012!\u0002;sC&tG\u0003BA\u0005\u0003+Bq!a\u0016\u000f\u0001\u0004\tI&A\u0004eCR\f7/\u001a;1\t\u0005m\u0013q\r\t\u0007\u0003;\ny&a\u0019\u000e\u0003!K1!!\u0019I\u0005\u001d!\u0015\r^1tKR\u0004B!!\u001a\u0002h1\u0001A\u0001DA5\u0003+\n\t\u0011!A\u0003\u0002\u0005-$aA0%cE\u0019\u0011QN:\u0011\u0007e\u000by'C\u0002\u0002rQ\u0013qAT8uQ&tw-A\u0007hKRtU/\\\"mCN\u001cXm\u001d\u000b\u0005\u0003\u0003\n9\bC\u0004\u0002X=\u0001\r!!\u001f1\t\u0005m\u0014q\u0010\t\u0007\u0003;\ny&! \u0011\t\u0005\u0015\u0014q\u0010\u0003\r\u0003\u0003\u000b9(!A\u0001\u0002\u000b\u0005\u00111\u000e\u0002\u0004?\u0012\u0012\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\"\u0011\t\u0005%\u00151S\u0007\u0003\u0003\u0017SA!!$\u0002\u0010\u0006!A.\u00198h\u0015\t\t\t*\u0001\u0003kCZ\f\u0017\u0002BAK\u0003\u0017\u0013aa\u00142kK\u000e$\b")
public class ClassifierSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Map<String, Object> allParamSettings() {
        return ClassifierSuite$.MODULE$.allParamSettings();
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private Dataset<Row> getTestData(Seq<Object> labels) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ClassifierSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_ClassifierSuite$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.feature.LabeledPoint").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_classification_ClassifierSuite$$typecreator6$1(ClassifierSuite $outer) {
            }
        }
        return this.testImplicits().localSeqToDatasetHolder((Seq)labels.map((Function1 & Serializable & scala.Serializable)label -> ClassifierSuite.$anonfun$getTestData$1(BoxesRunTime.unboxToDouble((Object)label)), Seq$.MODULE$.canBuildFrom()), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ClassifierSuite$$typecreator6$1(null)))).toDF();
    }

    private final void testImplicits$lzycompute$1() {
        ClassifierSuite classifierSuite = this;
        synchronized (classifierSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ LabeledPoint $anonfun$getTestData$1(double label) {
        return new LabeledPoint(label, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])));
    }

    public ClassifierSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("getNumClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MockClassifier c = new MockClassifier();
            Dataset<Row> df0 = this.getTestData((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0, 1.0, 5.0}))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)c.getNumClasses(df0)));
            int $org_scalatest_assert_macro_right = 6;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            Dataset<Row> df1 = this.getTestData((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0, 1.0, 5.1}))));
            this.withClue("getNumClasses should fail if label is max label not an integer", (Function0 & Serializable & scala.Serializable)() -> {
                Exception e = (Exception)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> c.getNumClasses(df1), ClassTag$.MODULE$.apply(Exception.class), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "Labels MUST be Integers";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            });
            Dataset<Row> df2 = this.getTestData((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0, 1.0, Integer.MAX_VALUE}))));
            this.withClue("getNumClasses should fail if label is max label is >= Int.MaxValue", (Function0 & Serializable & scala.Serializable)() -> {
                Exception e = (Exception)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> c.getNumClasses(df2), ClassTag$.MODULE$.apply(Exception.class), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "Labels MUST be in [0";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            });
            Dataset<Row> df3 = this.getTestData((Seq<Object>)((Seq)Nil$.MODULE$));
            return (Assertion)this.withClue("getNumClasses should fail if dataset is empty", (Function0 & Serializable & scala.Serializable)() -> {
                SparkException e = (SparkException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> c.getNumClasses(df3), ClassTag$.MODULE$.apply(SparkException.class), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "ML algorithm was given empty dataset.";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            });
        }, new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
    }

    public static class MockClassificationModel
    extends ClassificationModel<Vector, MockClassificationModel> {
        private final String uid;

        public String uid() {
            return this.uid;
        }

        public Vector predictRaw(Vector features) {
            throw new UnsupportedOperationException();
        }

        public MockClassificationModel copy(ParamMap extra) {
            throw new UnsupportedOperationException();
        }

        public int numClasses() {
            throw new UnsupportedOperationException();
        }

        public MockClassificationModel(String uid) {
            this.uid = uid;
        }

        public MockClassificationModel() {
            this(Identifiable$.MODULE$.randomUID("mockclassificationmodel"));
        }
    }

    public static class MockClassifier
    extends Classifier<Vector, MockClassifier, MockClassificationModel> {
        private final String uid;

        public String uid() {
            return this.uid;
        }

        public MockClassifier copy(ParamMap extra) {
            throw new UnsupportedOperationException();
        }

        public MockClassificationModel train(Dataset<?> dataset) {
            throw new UnsupportedOperationException();
        }

        public int getNumClasses(Dataset<?> dataset) {
            return DatasetUtils$.MODULE$.getNumClasses(dataset, (String)this.$(this.labelCol()), DatasetUtils$.MODULE$.getNumClasses$default$3());
        }

        public MockClassifier(String uid) {
            this.uid = uid;
        }

        public MockClassifier() {
            this(Identifiable$.MODULE$.randomUID("mockclassifier"));
        }
    }
}

