/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.evaluation.ClusteringEvaluator;
import org.apache.spark.ml.evaluation.ClusteringEvaluatorSuite$;
import org.apache.spark.ml.evaluation.ClusteringMetrics;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001)4Aa\u0004\t\u00017!)Q\u0006\u0001C\u0001]!I\u0011\u0007\u0001a\u0001\u0002\u0004%\tA\r\u0005\n\u000f\u0002\u0001\r\u00111A\u0005\u0002!C\u0011\"\u0015\u0001A\u0002\u0003\u0005\u000b\u0015B\u001a\t\u0013Y\u0003\u0001\u0019!a\u0001\n\u0003\u0011\u0004\"C,\u0001\u0001\u0004\u0005\r\u0011\"\u0001Y\u0011%Q\u0006\u00011A\u0001B\u0003&1\u0007C\u0005]\u0001\u0001\u0007\t\u0019!C\u0001e!IQ\f\u0001a\u0001\u0002\u0004%\tA\u0018\u0005\nA\u0002\u0001\r\u0011!Q!\nMB\u0011B\u0019\u0001A\u0002\u0003\u0007I\u0011\u0001\u001a\t\u0013\r\u0004\u0001\u0019!a\u0001\n\u0003!\u0007\"\u00034\u0001\u0001\u0004\u0005\t\u0015)\u00034\u0011\u0015A\u0007\u0001\"\u0011j\u0005a\u0019E.^:uKJLgnZ#wC2,\u0018\r^8s'VLG/\u001a\u0006\u0003#I\t!\"\u001a<bYV\fG/[8o\u0015\t\u0019B#\u0001\u0002nY*\u0011QCF\u0001\u0006gB\f'o\u001b\u0006\u0003/a\ta!\u00199bG\",'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001a\u0002\u0005\u000b\t\u0003;yi\u0011\u0001F\u0005\u0003?Q\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011)H/\u001b7\u000b\u0005\u0015\"\u0012!B7mY&\u0014\u0017BA\u0014#\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\u0004\"!K\u0016\u000e\u0003)R!a\t\n\n\u00051R#\u0001\u0006#fM\u0006,H\u000e\u001e*fC\u0012<&/\u001b;f)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002_A\u0011\u0001\u0007A\u0007\u0002!\u0005Y\u0011N]5t\t\u0006$\u0018m]3u+\u0005\u0019\u0004C\u0001\u001bE\u001d\t)\u0014I\u0004\u00027\u007f9\u0011qG\u0010\b\u0003qur!!\u000f\u001f\u000e\u0003iR!a\u000f\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012BA\f\u0019\u0013\t)b#\u0003\u0002A)\u0005\u00191/\u001d7\n\u0005\t\u001b\u0015a\u00029bG.\fw-\u001a\u0006\u0003\u0001RI!!\u0012$\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u0001\"D\u0003=I'/[:ECR\f7/\u001a;`I\u0015\fHCA%P!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\u0011)f.\u001b;\t\u000fA\u001b\u0011\u0011!a\u0001g\u0005\u0019\u0001\u0010J\u0019\u0002\u0019%\u0014\u0018n\u001d#bi\u0006\u001cX\r\u001e\u0011)\u0005\u0011\u0019\u0006C\u0001&U\u0013\t)6JA\u0005ue\u0006t7/[3oi\u0006qa.Z<Je&\u001cH)\u0019;bg\u0016$\u0018A\u00058fo&\u0013\u0018n\u001d#bi\u0006\u001cX\r^0%KF$\"!S-\t\u000fA3\u0011\u0011!a\u0001g\u0005ya.Z<Je&\u001cH)\u0019;bg\u0016$\b\u0005\u000b\u0002\b'\u0006ya.Z<Je&\u001cH)\u0019;bg\u0016$H)A\noK^L%/[:ECR\f7/\u001a;E?\u0012*\u0017\u000f\u0006\u0002J?\"9\u0001+CA\u0001\u0002\u0004\u0019\u0014\u0001\u00058fo&\u0013\u0018n\u001d#bi\u0006\u001cX\r\u001e#!Q\tQ1+A\boK^L%/[:ECR\f7/\u001a;G\u0003MqWm^%sSN$\u0015\r^1tKR4u\fJ3r)\tIU\rC\u0004Q\u0019\u0005\u0005\t\u0019A\u001a\u0002!9,w/\u0013:jg\u0012\u000bG/Y:fi\u001a\u0003\u0003FA\u0007T\u0003%\u0011WMZ8sK\u0006cG\u000eF\u0001J\u0001")
public class ClusteringEvaluatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient Dataset<Row> irisDataset;
    private transient Dataset<Row> newIrisDataset;
    private transient Dataset<Row> newIrisDatasetD;
    private transient Dataset<Row> newIrisDatasetF;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest.testDefaultReadWrite$(this, instance, testParams);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest.testDefaultReadWrite$default$2$(this);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testEstimatorParams, Map<String, Object> testModelParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest.testEstimatorAndModelReadWrite$(this, estimator, dataset, testEstimatorParams, testModelParams, checkModelData);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Dataset<Row> irisDataset() {
        return this.irisDataset;
    }

    public void irisDataset_$eq(Dataset<Row> x$1) {
        this.irisDataset = x$1;
    }

    public Dataset<Row> newIrisDataset() {
        return this.newIrisDataset;
    }

    public void newIrisDataset_$eq(Dataset<Row> x$1) {
        this.newIrisDataset = x$1;
    }

    public Dataset<Row> newIrisDatasetD() {
        return this.newIrisDatasetD;
    }

    public void newIrisDatasetD_$eq(Dataset<Row> x$1) {
        this.newIrisDatasetD = x$1;
    }

    public Dataset<Row> newIrisDatasetF() {
        return this.newIrisDatasetF;
    }

    public void newIrisDatasetF_$eq(Dataset<Row> x$1) {
        this.newIrisDatasetF = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.irisDataset_$eq((Dataset<Row>)this.spark().read().format("libsvm").load(this.getTestResourcePath("iris_libsvm.txt")));
        Tuple3<Dataset<Row>, Dataset<Row>, Dataset<Row>> datasets = MLTestingUtils$.MODULE$.generateArrayFeatureDataset(this.irisDataset(), MLTestingUtils$.MODULE$.generateArrayFeatureDataset$default$2());
        this.newIrisDataset_$eq((Dataset<Row>)((Dataset)datasets._1()));
        this.newIrisDatasetD_$eq((Dataset<Row>)((Dataset)datasets._2()));
        this.newIrisDatasetF_$eq((Dataset<Row>)((Dataset)datasets._3()));
    }

    private final void testImplicits$lzycompute$1() {
        ClusteringEvaluatorSuite clusteringEvaluatorSuite = this;
        synchronized (clusteringEvaluatorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ Assertion $anonfun$new$15(ClusteringEvaluatorSuite $this, ClusteringEvaluator evaluator1$1, ClusteringEvaluator evaluator2$1, double w) {
        double score1 = evaluator1$1.evaluate($this.irisDataset());
        double score2 = evaluator2$1.evaluate($this.irisDataset().withColumn("weight", functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)w))));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(score1).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(score2).relTol(1.0E-6)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(score1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(score2).relTol(1.0E-6))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        score1 = evaluator1$1.evaluate($this.newIrisDataset());
        score2 = evaluator2$1.evaluate($this.newIrisDataset().withColumn("weight", functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)w))));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(score1).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(score2).relTol(1.0E-6)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(score1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(score2).relTol(1.0E-6))", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
    }

    public static final /* synthetic */ void $anonfun$new$14(ClusteringEvaluatorSuite $this, String distanceMeasure) {
        ClusteringEvaluator evaluator1 = new ClusteringEvaluator().setFeaturesCol("features").setPredictionCol("label").setDistanceMeasure(distanceMeasure);
        ClusteringEvaluator evaluator2 = new ClusteringEvaluator().setFeaturesCol("features").setPredictionCol("label").setDistanceMeasure(distanceMeasure).setWeightCol("weight");
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.25, 1.0, 10.0, 99.99}))).foreach((Function1 & Serializable & scala.Serializable)w -> ClusteringEvaluatorSuite.$anonfun$new$15($this, evaluator1, evaluator2, BoxesRunTime.unboxToDouble((Object)w)));
    }

    public ClusteringEvaluatorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        DefaultReadWriteTest.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ParamsSuite$.MODULE$.checkParams((Params)new ClusteringEvaluator()), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ClusteringEvaluator evaluator = new ClusteringEvaluator().setPredictionCol("myPrediction").setFeaturesCol("myLabel");
            return this.testDefaultReadWrite(evaluator, this.testDefaultReadWrite$default$2());
        }, new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("squared euclidean Silhouette", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ClusteringEvaluator evaluator = new ClusteringEvaluator().setFeaturesCol("features").setPredictionCol("label");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.irisDataset())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.irisDataset)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.newIrisDataset())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.newIrisDataset)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.newIrisDatasetD())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.newIrisDatasetD)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.newIrisDatasetF())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.newIrisDatasetF)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        }, new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("cosine Silhouette", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ClusteringEvaluator evaluator = new ClusteringEvaluator().setFeaturesCol("features").setPredictionCol("label").setDistanceMeasure("cosine");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.irisDataset())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.irisDataset)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.newIrisDataset())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.newIrisDataset)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.newIrisDatasetD())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.newIrisDatasetD)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.newIrisDatasetF())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.newIrisDatasetF)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        }, new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("number of clusters must be greater than one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset singleClusterDataset = this.irisDataset().where(this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)0.0)));
            ((IterableLike)new .colon.colon((Object)"squaredEuclidean", (List)new .colon.colon((Object)"cosine", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)distanceMeasure -> {
                ClusteringEvaluator evaluator = new ClusteringEvaluator().setFeaturesCol("features").setPredictionCol("label").setDistanceMeasure(distanceMeasure);
                AssertionError e = (AssertionError)this.intercept((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> evaluator.evaluate(singleClusterDataset), ClassTag$.MODULE$.apply(AssertionError.class), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
                String $org_scalatest_assert_macro_left = ((Throwable)((Object)e)).getMessage();
                String $org_scalatest_assert_macro_right = "Number of clusters must be greater than one";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            });
        }, new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("SPARK-23568: we should use metadata to determine features number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int attributesNum = ((Vector)((Row)this.irisDataset().select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().first()).getAs(0)).size();
            AttributeGroup attrGroup = new AttributeGroup("features", attributesNum);
            Dataset df = this.irisDataset().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features"}))).$((Seq)Nil$.MODULE$).as("features", attrGroup.toMetadata()), this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}))).$((Seq)Nil$.MODULE$)}));
            Predef$.MODULE$.require(AttributeGroup$.MODULE$.fromStructField(df.schema().apply("features")).numAttributes().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "numAttributes metadata should be defined");
            ClusteringEvaluator evaluator = new ClusteringEvaluator().setFeaturesCol("features").setPredictionCol("label");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(df)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(df)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            AttributeGroup wrongAttrGroup = new AttributeGroup("features", attributesNum + 1);
            Dataset dfWrong = this.irisDataset().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features"}))).$((Seq)Nil$.MODULE$).as("features", wrongAttrGroup.toMetadata()), this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}))).$((Seq)Nil$.MODULE$)}));
            return (SparkException)this.intercept((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> evaluator.evaluate(dfWrong), ClassTag$.MODULE$.apply(SparkException.class), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        }, new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("SPARK-27896: single-element clusters should have silhouette score of 0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset twoSingleItemClusters = this.irisDataset().where(this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)0.0))).limit(1).union(this.irisDataset().where(this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)1.0))).limit(1));
            ClusteringEvaluator evaluator = new ClusteringEvaluator().setFeaturesCol("features").setPredictionCol("label");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)evaluator.evaluate(twoSingleItemClusters)));
            double $org_scalatest_assert_macro_right = 0.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        }, new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        this.test("getMetrics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ClusteringEvaluator evaluator = new ClusteringEvaluator().setFeaturesCol("features").setPredictionCol("label");
            ClusteringMetrics metrics1 = evaluator.getMetrics(this.irisDataset());
            double silhouetteScoreEuclidean = metrics1.silhouette();
            double $org_scalatest_assert_macro_left = evaluator.evaluate(this.irisDataset());
            double $org_scalatest_assert_macro_right = silhouetteScoreEuclidean;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            evaluator.setDistanceMeasure("cosine");
            ClusteringMetrics metrics2 = evaluator.getMetrics(this.irisDataset());
            double silhouetteScoreCosin = metrics2.silhouette();
            double $org_scalatest_assert_macro_left2 = evaluator.evaluate(this.irisDataset());
            double $org_scalatest_assert_macro_right2 = silhouetteScoreCosin;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        }, new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("test weight support", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"squaredEuclidean", (List)new .colon.colon((Object)"cosine", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)distanceMeasure -> {
            ClusteringEvaluatorSuite.$anonfun$new$14(this, distanceMeasure);
            return BoxedUnit.UNIT;
        }), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        this.test("single-element clusters with weight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkContext qual$1 = this.spark().sparkContext();
            Seq x$1 = (Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)Vectors$.MODULE$.dense(5.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.5, 1.4, 0.2})), (Object)BoxesRunTime.boxToDouble((double)6.0)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)Vectors$.MODULE$.dense(7.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.2, 4.7, 1.4})), (Object)BoxesRunTime.boxToDouble((double)0.25)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)Vectors$.MODULE$.dense(6.3, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.3, 6.0, 2.5})), (Object)BoxesRunTime.boxToDouble((double)9.99)), (List)Nil$.MODULE$)));
            int x$2 = qual$1.parallelize$default$2();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ClusteringEvaluatorSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_evaluation_ClusteringEvaluatorSuite$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_ml_evaluation_ClusteringEvaluatorSuite$$typecreator1$1(ClusteringEvaluatorSuite $outer) {
                }
            }
            Dataset singleItemClusters = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Tuple3.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_evaluation_ClusteringEvaluatorSuite$$typecreator1$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "features", "weight"}));
            ((IterableLike)new .colon.colon((Object)"squaredEuclidean", (List)new .colon.colon((Object)"cosine", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)distanceMeasure -> {
                ClusteringEvaluator evaluator = new ClusteringEvaluator().setFeaturesCol("features").setPredictionCol("label").setDistanceMeasure(distanceMeasure).setWeightCol("weight");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)evaluator.evaluate(singleItemClusters)));
                double $org_scalatest_assert_macro_right = 0.0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            });
        }, new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
    }
}

