/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.ml.feature.Bucketizer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.Assert;
import org.junit.Test;

public class JavaBucketizerSuite
extends SharedSparkSession {
    @Test
    public void bucketizerTest() {
        double[] splits = new double[]{-0.5, 0.0, 0.5};
        StructType schema = new StructType(new StructField[]{new StructField("feature", DataTypes.DoubleType, false, Metadata.empty())});
        Dataset dataset = this.spark.createDataFrame(Arrays.asList(RowFactory.create((Object[])new Object[]{-0.5}), RowFactory.create((Object[])new Object[]{-0.3}), RowFactory.create((Object[])new Object[]{0.0}), RowFactory.create((Object[])new Object[]{0.2})), schema);
        Bucketizer bucketizer = new Bucketizer().setInputCol("feature").setOutputCol("result").setSplits(splits);
        List result = bucketizer.transform(dataset).select("result", new String[0]).collectAsList();
        for (Row r : result) {
            double index = r.getDouble(0);
            Assert.assertTrue((index >= 0.0 && index <= 1.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void bucketizerMultipleColumnsTest() {
        double[][] splitsArray = new double[][]{{-0.5, 0.0, 0.5}, {-0.5, 0.0, 0.2, 0.5}};
        StructType schema = new StructType(new StructField[]{new StructField("feature1", DataTypes.DoubleType, false, Metadata.empty()), new StructField("feature2", DataTypes.DoubleType, false, Metadata.empty())});
        Dataset dataset = this.spark.createDataFrame(Arrays.asList(RowFactory.create((Object[])new Object[]{-0.5, -0.5}), RowFactory.create((Object[])new Object[]{-0.3, -0.3}), RowFactory.create((Object[])new Object[]{0.0, 0.0}), RowFactory.create((Object[])new Object[]{0.2, 0.3})), schema);
        Bucketizer bucketizer = new Bucketizer().setInputCols(new String[]{"feature1", "feature2"}).setOutputCols(new String[]{"result1", "result2"}).setSplitsArray((double[][])splitsArray);
        List result = bucketizer.transform(dataset).select("result1", new String[]{"result2"}).collectAsList();
        for (Row r : result) {
            double index1 = r.getDouble(0);
            Assert.assertTrue((index1 >= 0.0 && index1 <= 1.0 ? 1 : 0) != 0);
            double index2 = r.getDouble(1);
            Assert.assertTrue((index2 >= 0.0 && index2 <= 2.0 ? 1 : 0) != 0);
        }
    }
}

