/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.Assert;
import org.junit.Test;

public class JavaStringIndexerSuite
extends SharedSparkSession {
    @Test
    public void testStringIndexer() {
        StructType schema = DataTypes.createStructType((StructField[])new StructField[]{DataTypes.createStructField((String)"id", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"label", (DataType)DataTypes.StringType, (boolean)false)});
        List<Row> data = Arrays.asList(this.cr(0, "a"), this.cr(1, "b"), this.cr(2, "c"), this.cr(3, "a"), this.cr(4, "a"), this.cr(5, "c"));
        Dataset dataset = this.spark.createDataFrame(data, schema);
        StringIndexer indexer = new StringIndexer().setInputCol("label").setOutputCol("labelIndex");
        Dataset output = indexer.fit(dataset).transform(dataset);
        Assert.assertEquals(Arrays.asList(this.cr(0, 0.0), this.cr(1, 2.0), this.cr(2, 1.0), this.cr(3, 0.0), this.cr(4, 0.0), this.cr(5, 1.0)), (Object)output.orderBy("id", new String[0]).select("id", new String[]{"labelIndex"}).collectAsList());
    }

    private Row cr(Object ... values) {
        return RowFactory.create((Object[])values);
    }
}

