/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.RFormulaParser$;
import org.apache.spark.ml.feature.ResolvedRFormula;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001E3A\u0001B\u0003\u0001!!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00055!9Q\tAI\u0001\n\u00131%a\u0005*G_JlW\u000f\\1QCJ\u001cXM]*vSR,'B\u0001\u0004\b\u0003\u001d1W-\u0019;ve\u0016T!\u0001C\u0005\u0002\u00055d'B\u0001\u0006\f\u0003\u0015\u0019\b/\u0019:l\u0015\taQ\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Mi\u0011!C\u0005\u0003)%\u0011Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0006\u0003)\u0019\u0007.Z2l!\u0006\u00148/\u001a\u000b\u00067\u0005r\u0003g\u000f\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0005+:LG\u000fC\u0003#\u0005\u0001\u00071%A\u0004g_JlW\u000f\\1\u0011\u0005\u0011ZcBA\u0013*!\t1S$D\u0001(\u0015\tAs\"\u0001\u0004=e>|GOP\u0005\u0003Uu\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\u0019\u0019FO]5oO*\u0011!&\b\u0005\u0006_\t\u0001\raI\u0001\u0006Y\u0006\u0014W\r\u001c\u0005\u0006c\t\u0001\rAM\u0001\u0006i\u0016\u0014Xn\u001d\t\u0004ga\u001acB\u0001\u001b7\u001d\t1S'C\u0001\u001f\u0013\t9T$A\u0004qC\u000e\\\u0017mZ3\n\u0005eR$aA*fc*\u0011q'\b\u0005\by\t\u0001\n\u00111\u0001>\u0003\u0019\u00198\r[3nCB\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0006if\u0004Xm\u001d\u0006\u0003\u0005&\t1a]9m\u0013\t!uH\u0001\u0006TiJ,8\r\u001e+za\u0016\fAc\u00195fG.\u0004\u0016M]:fI\u0011,g-Y;mi\u0012\"T#A$+\u0005uB5&A%\u0011\u0005){U\"A&\u000b\u00051k\u0015!C;oG\",7m[3e\u0015\tqU$\u0001\u0006b]:|G/\u0019;j_:L!\u0001U&\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class RFormulaParserSuite
extends SparkFunSuite {
    private void checkParse(String formula, String label, Seq<String> terms, StructType schema) {
        ResolvedRFormula resolved = RFormulaParser$.MODULE$.parse(formula).resolve(schema);
        String $org_scalatest_assert_macro_left = resolved.label();
        String $org_scalatest_assert_macro_right = label;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        Seq simpleTerms = (Seq)terms.map((Function1 & Serializable & scala.Serializable)t -> {
            if (t.contains(":")) {
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])t.split(":"))).toSeq();
            }
            return (Seq)new .colon.colon(t, (List)Nil$.MODULE$);
        }, Seq$.MODULE$.canBuildFrom());
        Seq $org_scalatest_assert_macro_left2 = resolved.terms();
        Seq $org_scalatest_assert_macro_right2 = simpleTerms;
        Seq seq = $org_scalatest_assert_macro_left2;
        Seq seq2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
    }

    private StructType checkParse$default$4() {
        return new StructType();
    }

    public RFormulaParserSuite() {
        this.test("parse simple formulas", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkParse("y ~ x", "y", (Seq<String>)((Seq)new .colon.colon((Object)"x", (List)Nil$.MODULE$)), this.checkParse$default$4());
            this.checkParse("y ~ x + x", "y", (Seq<String>)((Seq)new .colon.colon((Object)"x", (List)Nil$.MODULE$)), this.checkParse$default$4());
            this.checkParse("y~x+z", "y", (Seq<String>)((Seq)new .colon.colon((Object)"x", (List)new .colon.colon((Object)"z", (List)Nil$.MODULE$))), this.checkParse$default$4());
            this.checkParse("y ~   ._fo..o  ", "y", (Seq<String>)((Seq)new .colon.colon((Object)"._fo..o", (List)Nil$.MODULE$)), this.checkParse$default$4());
            this.checkParse("resp ~ A_VAR + B + c123", "resp", (Seq<String>)((Seq)new .colon.colon((Object)"A_VAR", (List)new .colon.colon((Object)"B", (List)new .colon.colon((Object)"c123", (List)Nil$.MODULE$)))), this.checkParse$default$4());
        }, new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("parse dot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = new StructType().add("a", "int", true).add("b", "long", false).add("c", "string", true);
            this.checkParse("a ~ .", "a", (Seq<String>)((Seq)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), schema);
        }, new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("parse deletion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = new StructType().add("a", "int", true).add("b", "long", false).add("c", "string", true);
            this.checkParse("a ~ c - b", "a", (Seq<String>)((Seq)new .colon.colon((Object)"c", (List)Nil$.MODULE$)), schema);
        }, new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.test("parse additions and deletions in order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = new StructType().add("a", "int", true).add("b", "long", false).add("c", "string", true);
            this.checkParse("a ~ . - b + . - c", "a", (Seq<String>)((Seq)new .colon.colon((Object)"b", (List)Nil$.MODULE$)), schema);
        }, new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("dot ignores complex column types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = new StructType().add("a", "int", true).add("b", "tinyint", false).add("c", "map<string, string>", true);
            this.checkParse("a ~ .", "a", (Seq<String>)((Seq)new .colon.colon((Object)"b", (List)Nil$.MODULE$)), schema);
        }, new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("parse intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(RFormulaParser$.MODULE$.parse("a ~ b").hasIntercept(), "RFormulaParser.parse(\"a ~ b\").hasIntercept", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(RFormulaParser$.MODULE$.parse("a ~ b + 1").hasIntercept(), "RFormulaParser.parse(\"a ~ b + 1\").hasIntercept", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(RFormulaParser$.MODULE$.parse("a ~ b - 0").hasIntercept(), "RFormulaParser.parse(\"a ~ b - 0\").hasIntercept", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(RFormulaParser$.MODULE$.parse("a ~ b - 1 + 1").hasIntercept(), "RFormulaParser.parse(\"a ~ b - 1 + 1\").hasIntercept", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(RFormulaParser$.MODULE$.parse("a ~ b + 0").hasIntercept(), "RFormulaParser.parse(\"a ~ b + 0\").hasIntercept", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(RFormulaParser$.MODULE$.parse("a ~ b - 1").hasIntercept(), "RFormulaParser.parse(\"a ~ b - 1\").hasIntercept", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(RFormulaParser$.MODULE$.parse("a ~ b + 1 - 1").hasIntercept(), "RFormulaParser.parse(\"a ~ b + 1 - 1\").hasIntercept", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        }, new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("parse interactions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkParse("y ~ a:b", "y", (Seq<String>)((Seq)new .colon.colon((Object)"a:b", (List)Nil$.MODULE$)), this.checkParse$default$4());
            this.checkParse("y ~ a:b + b:a", "y", (Seq<String>)((Seq)new .colon.colon((Object)"a:b", (List)Nil$.MODULE$)), this.checkParse$default$4());
            this.checkParse("y ~ ._a:._x", "y", (Seq<String>)((Seq)new .colon.colon((Object)"._a:._x", (List)Nil$.MODULE$)), this.checkParse$default$4());
            this.checkParse("y ~ foo:bar", "y", (Seq<String>)((Seq)new .colon.colon((Object)"foo:bar", (List)Nil$.MODULE$)), this.checkParse$default$4());
            this.checkParse("y ~ a : b : c", "y", (Seq<String>)((Seq)new .colon.colon((Object)"a:b:c", (List)Nil$.MODULE$)), this.checkParse$default$4());
            this.checkParse("y ~ q + a:b:c + b:c + c:d + z", "y", (Seq<String>)((Seq)new .colon.colon((Object)"q", (List)new .colon.colon((Object)"a:b:c", (List)new .colon.colon((Object)"b:c", (List)new .colon.colon((Object)"c:d", (List)new .colon.colon((Object)"z", (List)Nil$.MODULE$)))))), this.checkParse$default$4());
        }, new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("parse factor cross", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkParse("y ~ a*b", "y", (Seq<String>)((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"a:b", (List)Nil$.MODULE$)))), this.checkParse$default$4());
            this.checkParse("y ~ a*b + b*a", "y", (Seq<String>)((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"a:b", (List)Nil$.MODULE$)))), this.checkParse$default$4());
            this.checkParse("y ~ ._a*._x", "y", (Seq<String>)((Seq)new .colon.colon((Object)"._a", (List)new .colon.colon((Object)"._x", (List)new .colon.colon((Object)"._a:._x", (List)Nil$.MODULE$)))), this.checkParse$default$4());
            this.checkParse("y ~ foo*bar", "y", (Seq<String>)((Seq)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"bar", (List)new .colon.colon((Object)"foo:bar", (List)Nil$.MODULE$)))), this.checkParse$default$4());
            this.checkParse("y ~ a * b * c", "y", (Seq<String>)((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"a:b", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"a:c", (List)new .colon.colon((Object)"b:c", (List)new .colon.colon((Object)"a:b:c", (List)Nil$.MODULE$)))))))), this.checkParse$default$4());
        }, new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("interaction distributive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkParse("y ~ (a + b):c", "y", (Seq<String>)((Seq)new .colon.colon((Object)"a:c", (List)new .colon.colon((Object)"b:c", (List)Nil$.MODULE$))), this.checkParse$default$4());
            this.checkParse("y ~ c:(a + b)", "y", (Seq<String>)((Seq)new .colon.colon((Object)"c:a", (List)new .colon.colon((Object)"c:b", (List)Nil$.MODULE$))), this.checkParse$default$4());
        }, new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test("factor cross distributive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkParse("y ~ (a + b)*c", "y", (Seq<String>)((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"a:c", (List)new .colon.colon((Object)"b:c", (List)Nil$.MODULE$)))))), this.checkParse$default$4());
            this.checkParse("y ~ c*(a + b)", "y", (Seq<String>)((Seq)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c:a", (List)new .colon.colon((Object)"c:b", (List)Nil$.MODULE$)))))), this.checkParse$default$4());
        }, new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("parse power", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = new StructType().add("a", "int", true).add("b", "long", false).add("c", "string", true).add("d", "string", true);
            this.checkParse("a ~ (a + b)^2", "a", (Seq<String>)((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"a:b", (List)Nil$.MODULE$)))), this.checkParse$default$4());
            this.checkParse("a ~ .^2", "a", (Seq<String>)((Seq)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"d", (List)new .colon.colon((Object)"b:c", (List)new .colon.colon((Object)"b:d", (List)new .colon.colon((Object)"c:d", (List)Nil$.MODULE$))))))), schema);
            this.checkParse("a ~ .^3", "a", (Seq<String>)((Seq)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"d", (List)new .colon.colon((Object)"b:c", (List)new .colon.colon((Object)"b:d", (List)new .colon.colon((Object)"c:d", (List)new .colon.colon((Object)"b:c:d", (List)Nil$.MODULE$)))))))), schema);
            this.checkParse("a ~ .^3-.", "a", (Seq<String>)((Seq)new .colon.colon((Object)"b:c", (List)new .colon.colon((Object)"b:d", (List)new .colon.colon((Object)"c:d", (List)new .colon.colon((Object)"b:c:d", (List)Nil$.MODULE$))))), schema);
        }, new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("operator precedence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkParse("y ~ a*b:c", "y", (Seq<String>)((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b:c", (List)new .colon.colon((Object)"a:b:c", (List)Nil$.MODULE$)))), this.checkParse$default$4());
            this.checkParse("y ~ (a*b):c", "y", (Seq<String>)((Seq)new .colon.colon((Object)"a:c", (List)new .colon.colon((Object)"b:c", (List)new .colon.colon((Object)"a:b:c", (List)Nil$.MODULE$)))), this.checkParse$default$4());
        }, new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("parse basic interactions with dot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = new StructType().add("a", "int", true).add("b", "long", false).add("c", "string", true).add("d", "string", true);
            this.checkParse("a ~ .:b", "a", (Seq<String>)((Seq)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c:b", (List)new .colon.colon((Object)"d:b", (List)Nil$.MODULE$)))), schema);
            this.checkParse("a ~ b:.", "a", (Seq<String>)((Seq)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"b:c", (List)new .colon.colon((Object)"b:d", (List)Nil$.MODULE$)))), schema);
            this.checkParse("a ~ .:b:.:.:c:d:.", "a", (Seq<String>)((Seq)new .colon.colon((Object)"b:c:d", (List)Nil$.MODULE$)), schema);
        }, new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        this.test("parse all to all iris interactions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = new StructType().add("Sepal.Length", "double", true).add("Sepal.Width", "double", true).add("Petal.Length", "double", true).add("Petal.Width", "double", true).add("Species", "string", true);
            this.checkParse("y ~ .:.", "y", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width", "Species", "Sepal.Length:Sepal.Width", "Sepal.Length:Petal.Length", "Sepal.Length:Petal.Width", "Sepal.Length:Species", "Sepal.Width:Petal.Length", "Sepal.Width:Petal.Width", "Sepal.Width:Species", "Petal.Length:Petal.Width", "Petal.Length:Species", "Petal.Width:Species"}))), schema);
        }, new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("parse interaction negation with iris", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = new StructType().add("Sepal.Length", "double", true).add("Sepal.Width", "double", true).add("Petal.Length", "double", true).add("Petal.Width", "double", true).add("Species", "string", true);
            this.checkParse("y ~ .:. - .:.", "y", (Seq<String>)Nil$.MODULE$, schema);
            this.checkParse("y ~ .:. - Species:.", "y", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width", "Sepal.Length:Sepal.Width", "Sepal.Length:Petal.Length", "Sepal.Length:Petal.Width", "Sepal.Width:Petal.Length", "Sepal.Width:Petal.Width", "Petal.Length:Petal.Width"}))), schema);
        }, new Position("RFormulaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
    }
}

