/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.SingularMatrixException;
import org.apache.spark.ml.optim.WeightedLeastSquares;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.ml.util.OptionalInstrumentation;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001y3AAE\n\u0001=!)1\u0006\u0001C\u0001Y!Iq\u0006\u0001a\u0001\u0002\u0004%I\u0001\r\u0005\n{\u0001\u0001\r\u00111A\u0005\nyB\u0011b\u0012\u0001A\u0002\u0003\u0005\u000b\u0015B\u0019\t\u0013!\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0004\"C%\u0001\u0001\u0004\u0005\r\u0011\"\u0003K\u0011%a\u0005\u00011A\u0001B\u0003&\u0011\u0007C\u0005N\u0001\u0001\u0007\t\u0019!C\u0005a!Ia\n\u0001a\u0001\u0002\u0004%Ia\u0014\u0005\n#\u0002\u0001\r\u0011!Q!\nEB\u0011B\u0015\u0001A\u0002\u0003\u0007I\u0011\u0002\u0019\t\u0013M\u0003\u0001\u0019!a\u0001\n\u0013!\u0006\"\u0003,\u0001\u0001\u0004\u0005\t\u0015)\u00032\u0011%9\u0006\u00011AA\u0002\u0013%\u0001\u0007C\u0005Y\u0001\u0001\u0007\t\u0019!C\u00053\"I1\f\u0001a\u0001\u0002\u0003\u0006K!\r\u0005\u00069\u0002!\t%\u0018\u0002\u001a/\u0016Lw\r\u001b;fI2+\u0017m\u001d;TcV\f'/Z:Tk&$XM\u0003\u0002\u0015+\u0005)q\u000e\u001d;j[*\u0011acF\u0001\u0003[2T!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\r\u0001qd\t\t\u0003A\u0005j\u0011aF\u0005\u0003E]\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\u0011)H/\u001b7\u000b\u0005!:\u0012!B7mY&\u0014\u0017B\u0001\u0016&\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\fa\u0001P5oSRtD#A\u0017\u0011\u00059\u0002Q\"A\n\u0002\u0013%t7\u000f^1oG\u0016\u001cX#A\u0019\u0011\u0007I*t'D\u00014\u0015\t!t#A\u0002sI\u0012L!AN\u001a\u0003\u0007I#E\t\u0005\u00029w5\t\u0011H\u0003\u0002;+\u00059a-Z1ukJ,\u0017B\u0001\u001f:\u0005!Ien\u001d;b]\u000e,\u0017!D5ogR\fgnY3t?\u0012*\u0017\u000f\u0006\u0002@\u000bB\u0011\u0001iQ\u0007\u0002\u0003*\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\n!QK\\5u\u0011\u001d15!!AA\u0002E\n1\u0001\u001f\u00132\u0003)Ign\u001d;b]\u000e,7\u000fI\u0001\u0014S:\u001cH/\u00198dKN\u001cuN\\:u\u0019\u0006\u0014W\r\\\u0001\u0018S:\u001cH/\u00198dKN\u001cuN\\:u\u0019\u0006\u0014W\r\\0%KF$\"aP&\t\u000f\u00193\u0011\u0011!a\u0001c\u0005!\u0012N\\:uC:\u001cWm]\"p]N$H*\u00192fY\u0002\nq#\u001b8ti\u0006t7-Z:D_:\u001cHOW3s_2\u000b'-\u001a7\u00027%t7\u000f^1oG\u0016\u001c8i\u001c8tij+'o\u001c'bE\u0016dw\fJ3r)\ty\u0004\u000bC\u0004G\u0013\u0005\u0005\t\u0019A\u0019\u00021%t7\u000f^1oG\u0016\u001c8i\u001c8tij+'o\u001c'bE\u0016d\u0007%\u0001\nd_2d\u0017N\\3be&s7\u000f^1oG\u0016\u001c\u0018AF2pY2Lg.Z1s\u0013:\u001cH/\u00198dKN|F%Z9\u0015\u0005}*\u0006b\u0002$\r\u0003\u0003\u0005\r!M\u0001\u0014G>dG.\u001b8fCJLen\u001d;b]\u000e,7\u000fI\u0001\u001aG>t7\u000f^1oi\u001a+\u0017\r^;sKNLen\u001d;b]\u000e,7/A\u000fd_:\u001cH/\u00198u\r\u0016\fG/\u001e:fg&s7\u000f^1oG\u0016\u001cx\fJ3r)\ty$\fC\u0004G\u001f\u0005\u0005\t\u0019A\u0019\u00025\r|gn\u001d;b]R4U-\u0019;ve\u0016\u001c\u0018J\\:uC:\u001cWm\u001d\u0011\u0002\u0013\t,gm\u001c:f\u00032dG#A ")
public class WeightedLeastSquaresSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private RDD<Instance> instances;
    private RDD<Instance> instancesConstLabel;
    private RDD<Instance> instancesConstZeroLabel;
    private RDD<Instance> collinearInstances;
    private RDD<Instance> constantFeaturesInstances;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private RDD<Instance> instances() {
        return this.instances;
    }

    private void instances_$eq(RDD<Instance> x$1) {
        this.instances = x$1;
    }

    private RDD<Instance> instancesConstLabel() {
        return this.instancesConstLabel;
    }

    private void instancesConstLabel_$eq(RDD<Instance> x$1) {
        this.instancesConstLabel = x$1;
    }

    private RDD<Instance> instancesConstZeroLabel() {
        return this.instancesConstZeroLabel;
    }

    private void instancesConstZeroLabel_$eq(RDD<Instance> x$1) {
        this.instancesConstZeroLabel = x$1;
    }

    private RDD<Instance> collinearInstances() {
        return this.collinearInstances;
    }

    private void collinearInstances_$eq(RDD<Instance> x$1) {
        this.collinearInstances = x$1;
    }

    private RDD<Instance> constantFeaturesInstances() {
        return this.constantFeaturesInstances;
    }

    private void constantFeaturesInstances_$eq(RDD<Instance> x$1) {
        this.constantFeaturesInstances = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.instances_$eq((RDD<Instance>)this.sc().parallelize((Seq)new .colon.colon((Object)new Instance(17.0, 1.0, (Vector)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0})).toSparse()), (List)new .colon.colon((Object)new Instance(19.0, 2.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0}))), (List)new .colon.colon((Object)new Instance(23.0, 3.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{11.0}))), (List)new .colon.colon((Object)new Instance(29.0, 4.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{13.0}))), (List)Nil$.MODULE$)))), 2, ClassTag$.MODULE$.apply(Instance.class)));
        this.instancesConstLabel_$eq((RDD<Instance>)this.sc().parallelize((Seq)new .colon.colon((Object)new Instance(17.0, 1.0, (Vector)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0})).toSparse()), (List)new .colon.colon((Object)new Instance(17.0, 2.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0}))), (List)new .colon.colon((Object)new Instance(17.0, 3.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{11.0}))), (List)new .colon.colon((Object)new Instance(17.0, 4.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{13.0}))), (List)Nil$.MODULE$)))), 2, ClassTag$.MODULE$.apply(Instance.class)));
        this.collinearInstances_$eq((RDD<Instance>)this.sc().parallelize((Seq)new .colon.colon((Object)new Instance(1.0, 1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), (List)new .colon.colon((Object)new Instance(2.0, 1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0}))), (List)new .colon.colon((Object)new Instance(3.0, 1.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{6.0}))), (List)new .colon.colon((Object)new Instance(4.0, 1.0, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{8.0}))), (List)Nil$.MODULE$)))), 2, ClassTag$.MODULE$.apply(Instance.class)));
        this.instancesConstZeroLabel_$eq((RDD<Instance>)this.sc().parallelize((Seq)new .colon.colon((Object)new Instance(0.0, 1.0, (Vector)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0})).toSparse()), (List)new .colon.colon((Object)new Instance(0.0, 2.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0}))), (List)new .colon.colon((Object)new Instance(0.0, 3.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{11.0}))), (List)new .colon.colon((Object)new Instance(0.0, 4.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{13.0}))), (List)Nil$.MODULE$)))), 2, ClassTag$.MODULE$.apply(Instance.class)));
        this.constantFeaturesInstances_$eq((RDD<Instance>)this.sc().parallelize((Seq)new .colon.colon((Object)new Instance(17.0, 1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0}))), (List)new .colon.colon((Object)new Instance(19.0, 2.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0}))), (List)new .colon.colon((Object)new Instance(23.0, 3.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{11.0}))), (List)new .colon.colon((Object)new Instance(29.0, 4.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{13.0}))), (List)Nil$.MODULE$)))), 2, ClassTag$.MODULE$.apply(Instance.class)));
    }

    private final void testImplicits$lzycompute$1() {
        WeightedLeastSquaresSuite weightedLeastSquaresSuite = this;
        synchronized (weightedLeastSquaresSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$8(WeightedLeastSquaresSuite $this, boolean fitIntercept$1, boolean standardization$1, Product solver) {
        boolean x$15 = fitIntercept$1;
        double x$16 = 0.0;
        double x$17 = 0.0;
        boolean x$18 = standardization$1;
        boolean x$19 = standardization$1;
        Product x$20 = solver;
        double x$21 = 1.0E-14;
        int x$22 = 100000;
        WeightedLeastSquares qual$3 = new WeightedLeastSquares(x$15, x$16, x$17, x$18, x$19, (WeightedLeastSquares.Solver)x$20, x$22, x$21);
        RDD<Instance> x$23 = $this.collinearInstances();
        OptionalInstrumentation x$24 = qual$3.fit$default$2();
        int x$25 = qual$3.fit$default$3();
        WeightedLeastSquaresModel singularModel = qual$3.fit(x$23, x$24, x$25);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.collinearInstances().collect())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Instance instance = x0$2;
            if (instance != null) {
                double l = instance.label();
                Vector f = instance.features();
                double pred = BLAS$.MODULE$.dot((Vector)singularModel.coefficients(), f) + singularModel.intercept();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(pred).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(l).absTol(1.0E-6)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(pred).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(l).absTol(1.0E-6))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            }
            throw new MatchError((Object)instance);
        });
    }

    public static final /* synthetic */ void $anonfun$new$7(WeightedLeastSquaresSuite $this, boolean fitIntercept$1, boolean standardization) {
        ((IterableLike)new .colon.colon((Object)WeightedLeastSquares.Auto$.MODULE$, (List)new .colon.colon((Object)WeightedLeastSquares.QuasiNewton$.MODULE$, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)solver -> {
            WeightedLeastSquaresSuite.$anonfun$new$8($this, fitIntercept$1, standardization, solver);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$6(WeightedLeastSquaresSuite $this, boolean fitIntercept) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)standardization -> {
            WeightedLeastSquaresSuite.$anonfun$new$7($this, fitIntercept, BoxesRunTime.unboxToBoolean((Object)standardization));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$12(WeightedLeastSquaresSuite $this, boolean fitIntercept$2, Seq expected$1, IntRef idx$1, boolean standardization) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])WeightedLeastSquares$.MODULE$.supportedSolvers())).foreach((Function1 & Serializable & scala.Serializable)solver -> {
            boolean x$26 = fitIntercept$2;
            double x$27 = 0.0;
            double x$28 = 0.0;
            boolean x$29 = standardization;
            boolean x$30 = standardization;
            double x$31 = 1.0E-14;
            int x$32 = 100000;
            Product x$33 = solver;
            WeightedLeastSquares qual$4 = new WeightedLeastSquares(x$26, x$27, x$28, x$29, x$30, (WeightedLeastSquares.Solver)x$33, x$32, x$31);
            RDD<Instance> x$34 = $this.instances();
            OptionalInstrumentation x$35 = qual$4.fit$default$2();
            int x$36 = qual$4.fit$default$3();
            WeightedLeastSquaresModel wls = qual$4.fit(x$34, x$35, x$36);
            Vector actual = Vectors$.MODULE$.dense(wls.intercept(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{wls.coefficients().apply(0), wls.coefficients().apply(1)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(actual).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected$1.apply(idx$1.elem)).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(actual).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected.apply(idx)).absTol(1.0E-4))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        });
    }

    public static final /* synthetic */ void $anonfun$new$11(WeightedLeastSquaresSuite $this, Seq expected$1, IntRef idx$1, boolean fitIntercept) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)standardization -> {
            WeightedLeastSquaresSuite.$anonfun$new$12($this, fitIntercept, expected$1, idx$1, BoxesRunTime.unboxToBoolean((Object)standardization));
            return BoxedUnit.UNIT;
        });
        ++idx$1.elem;
    }

    public static final /* synthetic */ void $anonfun$new$16(WeightedLeastSquaresSuite $this, boolean fitIntercept$3, Seq expected$2, IntRef idx$2, boolean standardization) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])WeightedLeastSquares$.MODULE$.supportedSolvers())).foreach((Function1 & Serializable & scala.Serializable)solver -> {
            WeightedLeastSquares qual$5 = new WeightedLeastSquares(fitIntercept$3, 0.0, 0.0, standardization, standardization, (WeightedLeastSquares.Solver)solver, WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8());
            RDD<Instance> x$37 = $this.instancesConstLabel();
            OptionalInstrumentation x$38 = qual$5.fit$default$2();
            int x$39 = qual$5.fit$default$3();
            WeightedLeastSquaresModel wls = qual$5.fit(x$37, x$38, x$39);
            Vector actual = Vectors$.MODULE$.dense(wls.intercept(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{wls.coefficients().apply(0), wls.coefficients().apply(1)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(actual).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected$2.apply(idx$2.elem)).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(actual).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected.apply(idx)).absTol(1.0E-4))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        });
    }

    public static final /* synthetic */ void $anonfun$new$15(WeightedLeastSquaresSuite $this, Seq expected$2, IntRef idx$2, boolean fitIntercept) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)standardization -> {
            WeightedLeastSquaresSuite.$anonfun$new$16($this, fitIntercept, expected$2, idx$2, BoxesRunTime.unboxToBoolean((Object)standardization));
            return BoxedUnit.UNIT;
        });
        ++idx$2.elem;
    }

    public static final /* synthetic */ SingularMatrixException $anonfun$new$24(WeightedLeastSquaresSuite $this, boolean fitIntercept$4, boolean standardization) {
        WeightedLeastSquares wls = new WeightedLeastSquares(fitIntercept$4, 0.0, 0.0, standardization, standardization, (WeightedLeastSquares.Solver)WeightedLeastSquares.Cholesky$.MODULE$, WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8());
        return (SingularMatrixException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> wls.fit($this.constantFeaturesInstances(), wls.fit$default$2(), wls.fit$default$3()), ClassTag$.MODULE$.apply(SingularMatrixException.class), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
    }

    public static final /* synthetic */ void $anonfun$new$23(WeightedLeastSquaresSuite $this, boolean fitIntercept) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)standardization -> WeightedLeastSquaresSuite.$anonfun$new$24($this, fitIntercept, BoxesRunTime.unboxToBoolean((Object)standardization)));
    }

    public static final /* synthetic */ void $anonfun$new$27(WeightedLeastSquaresSuite $this, Seq expectedCholesky$1, IntRef idx$3, boolean fitIntercept) {
        boolean x$43 = fitIntercept;
        double x$44 = 0.5;
        double x$45 = 0.0;
        boolean x$46 = true;
        boolean x$47 = true;
        WeightedLeastSquares.Cholesky$ x$48 = WeightedLeastSquares.Cholesky$.MODULE$;
        double x$49 = 1.0E-14;
        int x$50 = 100000;
        WeightedLeastSquares qual$7 = new WeightedLeastSquares(x$43, x$44, x$45, x$46, x$47, (WeightedLeastSquares.Solver)x$48, x$50, x$49);
        RDD<Instance> x$51 = $this.constantFeaturesInstances();
        OptionalInstrumentation x$52 = qual$7.fit$default$2();
        int x$53 = qual$7.fit$default$3();
        WeightedLeastSquaresModel wls = qual$7.fit(x$51, x$52, x$53);
        Vector actual = Vectors$.MODULE$.dense(wls.intercept(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{wls.coefficients().apply(0), wls.coefficients().apply(1)}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(actual).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expectedCholesky$1.apply(idx$3.elem)).absTol(1.0E-6)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(actual).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expectedCholesky.apply(idx)).absTol(1.0E-6))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        ++idx$3.elem;
    }

    public static final /* synthetic */ boolean $anonfun$new$30(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$new$31(WeightedLeastSquaresSuite $this, boolean fitIntercept$5, boolean standardization$4, Seq expectedQuasiNewton$1, IntRef idx$3, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            double lambda = tuple2._1$mcD$sp();
            double alpha = tuple2._2$mcD$sp();
            boolean x$54 = fitIntercept$5;
            double x$55 = lambda;
            double x$56 = alpha;
            boolean x$57 = standardization$4;
            boolean x$58 = true;
            WeightedLeastSquares.QuasiNewton$ x$59 = WeightedLeastSquares.QuasiNewton$.MODULE$;
            double x$60 = 1.0E-14;
            int x$61 = 100000;
            WeightedLeastSquares wls = new WeightedLeastSquares(x$54, x$55, x$56, x$57, x$58, (WeightedLeastSquares.Solver)x$59, x$61, x$60);
            WeightedLeastSquaresModel model = wls.fit($this.constantFeaturesInstances(), wls.fit$default$2(), wls.fit$default$3());
            Vector actual = Vectors$.MODULE$.dense(model.intercept(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{model.coefficients().apply(0), model.coefficients().apply(1)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(actual).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expectedQuasiNewton$1.apply(idx$3.elem)).absTol(1.0E-6)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(actual).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expectedQuasiNewton.apply(idx)).absTol(1.0E-6))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
            ++idx$3.elem;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$29(WeightedLeastSquaresSuite $this, boolean fitIntercept$5, Seq expectedQuasiNewton$1, IntRef idx$3, boolean standardization) {
        ((TraversableLike)new .colon.colon((Object)new Tuple2.mcDD.sp(0.0, 0.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(0.5, 0.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(0.5, 0.5), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(0.5, 1.0), (List)Nil$.MODULE$))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)WeightedLeastSquaresSuite.$anonfun$new$30(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            WeightedLeastSquaresSuite.$anonfun$new$31($this, fitIntercept$5, standardization, expectedQuasiNewton$1, idx$3, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$28(WeightedLeastSquaresSuite $this, Seq expectedQuasiNewton$1, IntRef idx$3, boolean fitIntercept) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)standardization -> {
            WeightedLeastSquaresSuite.$anonfun$new$29($this, fitIntercept, expectedQuasiNewton$1, idx$3, BoxesRunTime.unboxToBoolean((Object)standardization));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$35(WeightedLeastSquaresSuite $this, boolean fitIntercept$6, double regParam$1, Seq expected$3, IntRef idx$4, boolean standardization) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1, 0.5, 1.0}))).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)elasticNetParam -> {
            boolean x$62 = fitIntercept$6;
            double x$63 = regParam$1;
            double x$64 = elasticNetParam;
            boolean x$65 = standardization;
            boolean x$66 = true;
            WeightedLeastSquares.Auto$ x$67 = WeightedLeastSquares.Auto$.MODULE$;
            double x$68 = 1.0E-14;
            int x$69 = 100000;
            WeightedLeastSquares qual$8 = new WeightedLeastSquares(x$62, x$63, x$64, x$65, x$66, (WeightedLeastSquares.Solver)x$67, x$69, x$68);
            RDD<Instance> x$70 = $this.instances();
            OptionalInstrumentation x$71 = qual$8.fit$default$2();
            int x$72 = qual$8.fit$default$3();
            WeightedLeastSquaresModel wls = qual$8.fit(x$70, x$71, x$72);
            Vector actual = Vectors$.MODULE$.dense(wls.intercept(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{wls.coefficients().apply(0), wls.coefficients().apply(1)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(actual).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected$3.apply(idx$4.elem)).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(actual).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected.apply(idx)).absTol(1.0E-4))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
            ++idx$4.elem;
        });
    }

    public static final /* synthetic */ void $anonfun$new$33(WeightedLeastSquaresSuite $this, Seq expected$3, IntRef idx$4, boolean fitIntercept) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1, 0.5, 1.0}))).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)regParam -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)standardization -> {
            WeightedLeastSquaresSuite.$anonfun$new$35($this, fitIntercept, regParam, expected$3, idx$4, BoxesRunTime.unboxToBoolean((Object)standardization));
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ void $anonfun$new$40(WeightedLeastSquaresSuite $this, boolean fitIntercept$7, double regParam$2, Seq expected$4, IntRef idx$5, boolean standardization) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])WeightedLeastSquares$.MODULE$.supportedSolvers())).foreach((Function1 & Serializable & scala.Serializable)solver -> {
            boolean x$73 = fitIntercept$7;
            double x$74 = regParam$2;
            double x$75 = 0.0;
            boolean x$76 = standardization;
            boolean x$77 = true;
            Product x$78 = solver;
            double x$79 = 1.0E-14;
            int x$80 = 100000;
            WeightedLeastSquares qual$9 = new WeightedLeastSquares(x$73, x$74, x$75, x$76, x$77, (WeightedLeastSquares.Solver)x$78, x$80, x$79);
            RDD<Instance> x$81 = $this.instances();
            OptionalInstrumentation x$82 = qual$9.fit$default$2();
            int x$83 = qual$9.fit$default$3();
            WeightedLeastSquaresModel wls = qual$9.fit(x$81, x$82, x$83);
            Vector actual = Vectors$.MODULE$.dense(wls.intercept(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{wls.coefficients().apply(0), wls.coefficients().apply(1)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(actual).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected$4.apply(idx$5.elem)).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(actual).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected.apply(idx)).absTol(1.0E-4))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 541));
        });
        ++idx$5.elem;
    }

    public static final /* synthetic */ void $anonfun$new$38(WeightedLeastSquaresSuite $this, Seq expected$4, IntRef idx$5, boolean fitIntercept) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.1, 1.0}))).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)regParam -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)standardization -> {
            WeightedLeastSquaresSuite.$anonfun$new$40($this, fitIntercept, regParam, expected$4, idx$5, BoxesRunTime.unboxToBoolean((Object)standardization));
            return BoxedUnit.UNIT;
        }));
    }

    public WeightedLeastSquaresSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("WLS with strong L1 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 bAgg = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances().collect())).foldLeft((Object)new Tuple2.mcDD.sp(0.0, 0.0), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Instance instance = (Instance)tuple2._2();
                    if (tuple22 != null) {
                        double sum = tuple22._1$mcD$sp();
                        double weightSum = tuple22._2$mcD$sp();
                        if (instance != null) {
                            double l = instance.label();
                            double w = instance.weight();
                            return new Tuple2.mcDD.sp(sum + w * l, weightSum + w);
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            double bBar = bAgg._1$mcD$sp() / bAgg._2$mcD$sp();
            WeightedLeastSquares wls = new WeightedLeastSquares(true, 10.0, 1.0, true, true, WeightedLeastSquares$.MODULE$.$lessinit$greater$default$6(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8());
            WeightedLeastSquaresModel model = wls.fit(this.instances(), wls.fit$default$2(), wls.fit$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(bBar).relTol(1.0E-6)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(bBar).relTol(1.0E-6))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        }, new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("diagonal inverse of AtWA", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector expectedWithIntercept = Vectors$.MODULE$.dense(4.02, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5, 12.02}));
            Vector expected = Vectors$.MODULE$.dense(0.48336106, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.02079867}));
            WeightedLeastSquares wlsWithIntercept = new WeightedLeastSquares(true, 0.0, 0.0, true, true, (WeightedLeastSquares.Solver)WeightedLeastSquares.Cholesky$.MODULE$, WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8());
            WeightedLeastSquaresModel wlsModelWithIntercept = wlsWithIntercept.fit(this.instances(), wlsWithIntercept.fit$default$2(), wlsWithIntercept.fit$default$3());
            boolean x$1 = false;
            double x$2 = 0.0;
            double x$3 = 0.0;
            boolean x$4 = true;
            boolean x$5 = true;
            WeightedLeastSquares.Cholesky$ x$6 = WeightedLeastSquares.Cholesky$.MODULE$;
            double x$7 = 1.0E-14;
            int x$8 = 100000;
            WeightedLeastSquares wls = new WeightedLeastSquares(x$1, x$2, x$3, x$4, x$5, (WeightedLeastSquares.Solver)x$6, x$8, x$7);
            WeightedLeastSquaresModel wlsModel = wls.fit(this.instances(), wls.fit$default$2(), wls.fit$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(expectedWithIntercept).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)wlsModelWithIntercept.diagInvAtWA()).relTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expectedWithIntercept).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(wlsModelWithIntercept.diagInvAtWA).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(expected).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)wlsModel.diagInvAtWA()).relTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(wlsModel.diagInvAtWA).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        }, new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("two collinear features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                WeightedLeastSquares qual$1 = new WeightedLeastSquares(false, 0.0, 0.0, false, false, (WeightedLeastSquares.Solver)WeightedLeastSquares.Cholesky$.MODULE$, WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8());
                RDD<Instance> x$9 = this.collinearInstances();
                OptionalInstrumentation x$10 = qual$1.fit$default$2();
                int x$11 = qual$1.fit$default$3();
                return qual$1.fit(x$9, x$10, x$11);
            }, ClassTag$.MODULE$.apply(SingularMatrixException.class), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            WeightedLeastSquares qual$2 = new WeightedLeastSquares(false, 1.0, 0.0, false, false, (WeightedLeastSquares.Solver)WeightedLeastSquares.Cholesky$.MODULE$, WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8());
            RDD<Instance> x$12 = this.collinearInstances();
            OptionalInstrumentation x$13 = qual$2.fit$default$2();
            int x$14 = qual$2.fit$default$3();
            qual$2.fit(x$12, x$13, x$14);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)fitIntercept -> {
                WeightedLeastSquaresSuite.$anonfun$new$6(this, BoxesRunTime.unboxToBoolean((Object)fitIntercept));
                return BoxedUnit.UNIT;
            });
        }, new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("WLS against lm", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq expected = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-3.727121, 3.009983})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(18.08, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{6.08, -0.6})), (List)Nil$.MODULE$));
            IntRef idx = IntRef.create((int)0);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)fitIntercept -> {
                WeightedLeastSquaresSuite.$anonfun$new$11(this, expected, idx, BoxesRunTime.unboxToBoolean((Object)fitIntercept));
                return BoxedUnit.UNIT;
            });
        }, new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        this.test("WLS against lm when label is constant and no regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq expected = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-9.221298, 3.394343})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(17.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0})), (List)Nil$.MODULE$));
            IntRef idx = IntRef.create((int)0);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)fitIntercept -> {
                WeightedLeastSquaresSuite.$anonfun$new$15(this, expected, idx, BoxesRunTime.unboxToBoolean((Object)fitIntercept));
                return BoxedUnit.UNIT;
            });
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])WeightedLeastSquares$.MODULE$.supportedSolvers())).foreach((Function1 & Serializable & scala.Serializable)solver -> {
                WeightedLeastSquares qual$6 = new WeightedLeastSquares(false, 0.0, 0.0, true, true, (WeightedLeastSquares.Solver)solver, WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8());
                RDD<Instance> x$40 = this.instancesConstZeroLabel();
                OptionalInstrumentation x$41 = qual$6.fit$default$2();
                int x$42 = qual$6.fit$default$3();
                WeightedLeastSquaresModel wls = qual$6.fit(x$40, x$41, x$42);
                Vector actual = Vectors$.MODULE$.dense(wls.intercept(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{wls.coefficients().apply(0), wls.coefficients().apply(1)}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
                Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(wls.objectiveHistory());
                double[] $org_scalatest_assert_macro_right2 = new double[]{0.0};
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            });
        }, new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        this.test("WLS with regularization when label is constant", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])WeightedLeastSquares$.MODULE$.supportedSolvers())).foreach((Function1 & Serializable & scala.Serializable)solver -> {
            WeightedLeastSquares wls = new WeightedLeastSquares(false, 0.1, 0.0, true, true, (WeightedLeastSquares.Solver)solver, WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8());
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> wls.fit(this.instancesConstLabel(), wls.fit$default$2(), wls.fit$default$3()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        }), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("WLS against glmnet with constant features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)fitIntercept -> {
                WeightedLeastSquaresSuite.$anonfun$new$23(this, BoxesRunTime.unboxToBoolean((Object)fitIntercept));
                return BoxedUnit.UNIT;
            });
            WeightedLeastSquares wls = new WeightedLeastSquares(true, 0.5, 0.0, false, false, (WeightedLeastSquares.Solver)WeightedLeastSquares.Cholesky$.MODULE$, WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8());
            this.intercept((Function0 & Serializable & scala.Serializable)() -> wls.fit(this.constantFeaturesInstances(), wls.fit$default$2(), wls.fit$default$3()), ClassTag$.MODULE$.apply(SingularMatrixException.class), new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
            Seq expectedCholesky = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.235802})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(9.798771, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.365503})), (List)Nil$.MODULE$));
            IntRef idx = IntRef.create((int)0);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)fitIntercept -> {
                WeightedLeastSquaresSuite.$anonfun$new$27(this, expectedCholesky, idx, BoxesRunTime.unboxToBoolean((Object)fitIntercept));
                return BoxedUnit.UNIT;
            });
            Seq expectedQuasiNewton = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.253012})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.250857})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.249784})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.248709})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.253012})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.235802})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.238297})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.240811})), Vectors$.MODULE$.dense(8.218905, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.517413})), Vectors$.MODULE$.dense(8.434286, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.496703})), Vectors$.MODULE$.dense(8.648497, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.476106})), Vectors$.MODULE$.dense(8.865672, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.455224})), Vectors$.MODULE$.dense(8.218905, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.517413})), Vectors$.MODULE$.dense(9.798771, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.365503})), Vectors$.MODULE$.dense(9.919095, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.353933})), Vectors$.MODULE$.dense(10.052804, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.341077}))}));
            idx.elem = 0;
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)fitIntercept -> {
                WeightedLeastSquaresSuite.$anonfun$new$28(this, expectedQuasiNewton, idx, BoxesRunTime.unboxToBoolean((Object)fitIntercept));
                return BoxedUnit.UNIT;
            });
        }, new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        this.test("WLS against glmnet with L1/ElasticNet regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-3.2928206726474, 2.92118822588649})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-3.23085414359003, 2.90848366035008})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-3.14558628299477, 2.89101408157209})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-2.91924558816421, 2.84172398097327})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-2.93832343383477, 2.84636891947663})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-2.96539689593024, 2.85283836322185})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-2.13785756976542, 2.68446351346705})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-1.68009377560774, 2.59084422793154})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.819463123385533, 2.41514053108346})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.960837488151064, 2.43010130999756})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.618792151647599, 2.36349074148962})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.24081114726441})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-1.34657309253953, 2.52129296638512})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.368045602821844, 2.32123616258871})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.24440619621343})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.21981559944924})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.22369447413621})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.22861024633605})), Vectors$.MODULE$.dense(13.5631591827557, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.28115132060568, 0.372551747695477})), Vectors$.MODULE$.dense(13.6953934007661, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.3336271417751, 0.349745414969587})), Vectors$.MODULE$.dense(13.960027608754, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.46001702257532, 0.29999407173994})), Vectors$.MODULE$.dense(14.2389889013085, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.65899196445023, 0.234906458633754})), Vectors$.MODULE$.dense(15.2374079667397, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.21196428071551, 0.0325637953681963})), Vectors$.MODULE$.dense(15.4, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.3, 0.0})), Vectors$.MODULE$.dense(10.4423647474653, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.24606545153166, 1.06399080283378})), Vectors$.MODULE$.dense(8.95807177856822, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.193847088148233, 1.4090609658784})), Vectors$.MODULE$.dense(8.86567164179104, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.45522388059702})), Vectors$.MODULE$.dense(13.0430927453034, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.49271514356687, 0.574180477650271})), Vectors$.MODULE$.dense(13.8144287399675, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.72202744354555, 0.455915035859752})), Vectors$.MODULE$.dense(16.2, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.9, 0.0})), Vectors$.MODULE$.dense(9.89047681835741, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.757469417613661, 1.21101772561685})), Vectors$.MODULE$.dense(9.07222551185964, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.43536293155196})), Vectors$.MODULE$.dense(9.51243781094527, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.39303482587065})), Vectors$.MODULE$.dense(13.3677796362763, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.17212164262107, 0.604613180623227})), Vectors$.MODULE$.dense(14.2554457236073, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.22851848830683, 0.508415124978748})), Vectors$.MODULE$.dense(17.2, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.4, 0.0}))}));
            IntRef idx = IntRef.create((int)0);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)fitIntercept -> {
                WeightedLeastSquaresSuite.$anonfun$new$33(this, expected, idx, BoxesRunTime.unboxToBoolean((Object)fitIntercept));
                return BoxedUnit.UNIT;
            });
        }, new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
        this.test("WLS against glmnet with L2 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-3.727117, 3.009982})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-3.727117, 3.009982})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-3.307532, 2.924206})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-2.91479, 2.840627})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-1.526575, 2.558158})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.06984238, 2.20488344})), Vectors$.MODULE$.dense(18.0799727, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{6.0799832, -0.5999941})), Vectors$.MODULE$.dense(18.0799727, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{6.0799832, -0.5999941})), Vectors$.MODULE$.dense(13.5356178, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.2714044, 0.3770744})), Vectors$.MODULE$.dense(14.064629, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.565802, 0.269593})), Vectors$.MODULE$.dense(10.1238013, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.9708569, 1.1475466})), Vectors$.MODULE$.dense(13.1860638, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.1761382, 0.6213134}))}));
            IntRef idx = IntRef.create((int)0);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)fitIntercept -> {
                WeightedLeastSquaresSuite.$anonfun$new$38(this, expected, idx, BoxesRunTime.unboxToBoolean((Object)fitIntercept));
                return BoxedUnit.UNIT;
            });
        }, new Position("WeightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
    }
}

