/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.source.image;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.image.ImageSchema$;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0002\u0004\u0001'!)\u0001\u0005\u0001C\u0001C!AA\u0005\u0001EC\u0002\u0013%Q\u0005C\u00044\u0001\t\u0007I\u0011\u0002\u001b\t\rI\u0003\u0001\u0015!\u00036\u0005QIU.Y4f\r&dWMR8s[\u0006$8+^5uK*\u0011q\u0001C\u0001\u0006S6\fw-\u001a\u0006\u0003\u0013)\taa]8ve\u000e,'BA\u0006\r\u0003\tiGN\u0003\u0002\u000e\u001d\u0005)1\u000f]1sW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u000b\u0019!\t)b#D\u0001\r\u0013\t9BBA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u00033yi\u0011A\u0007\u0006\u00037q\tA!\u001e;jY*\u0011Q\u0004D\u0001\u0006[2d\u0017NY\u0005\u0003?i\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002\r\u0005I\u0011.\\1hKB\u000bG\u000f[\u000b\u0002MA\u0011q\u0005\r\b\u0003Q9\u0002\"!\u000b\u0017\u000e\u0003)R!a\u000b\n\u0002\rq\u0012xn\u001c;?\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011G\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=b\u0013aF3ya\u0016\u001cG/\u001a3GSJ\u001cHOQ=uKN\u0014\u0004gU3u+\u0005)\u0004c\u0001\u001c<{5\tqG\u0003\u00029s\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003u1\n!bY8mY\u0016\u001cG/[8o\u0013\tatGA\u0002TKR\u0004BAP B\u00116\tA&\u0003\u0002AY\t1A+\u001e9mKJ\u0002\"AQ$\u000e\u0003\rS!\u0001R#\u0002\t1\fgn\u001a\u0006\u0002\r\u0006!!.\u0019<b\u0013\t\t4\t\u0005\u0003?\u007f%c\u0005C\u0001 K\u0013\tYEFA\u0002J]R\u00042AN'P\u0013\tquG\u0001\u0003MSN$\bC\u0001 Q\u0013\t\tFF\u0001\u0003CsR,\u0017\u0001G3ya\u0016\u001cG/\u001a3GSJ\u001cHOQ=uKN\u0014\u0004gU3uA\u0001")
public class ImageFileFormatSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private String imagePath;
    private final Set<Tuple2<String, Tuple2<Object, List<Object>>>> expectedFirstBytes20Set;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private String imagePath$lzycompute() {
        ImageFileFormatSuite imageFileFormatSuite = this;
        synchronized (imageFileFormatSuite) {
            if (!this.bitmap$0) {
                this.imagePath = this.getTestResourcePath("images/partitioned");
                this.bitmap$0 = true;
            }
        }
        return this.imagePath;
    }

    private String imagePath() {
        if (!this.bitmap$0) {
            return this.imagePath$lzycompute();
        }
        return this.imagePath;
    }

    private Set<Tuple2<String, Tuple2<Object, List<Object>>>> expectedFirstBytes20Set() {
        return this.expectedFirstBytes20Set;
    }

    private final void testImplicits$lzycompute$1() {
        ImageFileFormatSuite imageFileFormatSuite = this;
        synchronized (imageFileFormatSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public ImageFileFormatSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("Smoke test: create basic ImageSchema dataframe", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String origin = "path";
            int width = 1;
            int height = 1;
            int nChannels = 3;
            byte[] data = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0}), ClassTag$.MODULE$.Byte());
            int mode = BoxesRunTime.unboxToInt((Object)ImageSchema$.MODULE$.ocvTypes().apply((Object)"CV_8UC3"));
            Seq rows = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{origin, BoxesRunTime.boxToInteger((int)height), BoxesRunTime.boxToInteger((int)width), BoxesRunTime.boxToInteger((int)nChannels), BoxesRunTime.boxToInteger((int)mode), data}))})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)height), BoxesRunTime.boxToInteger((int)width), BoxesRunTime.boxToInteger((int)nChannels), BoxesRunTime.boxToInteger((int)mode), data}))})), (List)Nil$.MODULE$));
            SparkContext qual$1 = this.sc();
            Seq x$1 = rows;
            int x$2 = qual$1.makeRDD$default$2();
            RDD rdd = qual$1.makeRDD(x$1, x$2, ClassTag$.MODULE$.apply(Row.class));
            Dataset df = this.spark().createDataFrame(rdd, ImageSchema$.MODULE$.imageSchema());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"incorrect image count", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            DataType $org_scalatest_assert_macro_left2 = df.schema().apply("image").dataType();
            StructType $org_scalatest_assert_macro_right2 = ImageSchema$.MODULE$.columnSchema();
            DataType dataType = $org_scalatest_assert_macro_left2;
            StructType structType = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(structType) : structType != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"data do not fit ImageSchema", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        }, new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.ignore("image datasource count test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df1 = this.spark().read().format("image").load(this.imagePath());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df1.count()));
            int $org_scalatest_assert_macro_right = 9;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            Dataset df2 = this.spark().read().format("image").option("dropInvalid", true).load(this.imagePath());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df2.count()));
            int $org_scalatest_assert_macro_right2 = 8;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        }, new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("image datasource test: read jpg image", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().read().format("image").load(new StringBuilder(38).append(this.imagePath()).append("/cls=kittens/date=2018-02/DP153539.jpg").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        }, new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("image datasource test: read png image", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().read().format("image").load(new StringBuilder(39).append(this.imagePath()).append("/cls=multichannel/date=2018-01/BGRA.png").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("image datasource test: read non image", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String filePath = new StringBuilder(39).append(this.imagePath()).append("/cls=kittens/date=2018-01/not-image.txt").toString();
            Dataset df = this.spark().read().format("image").option("dropInvalid", true).load(filePath);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            Dataset df2 = this.spark().read().format("image").option("dropInvalid", false).load(filePath);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df2.count()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            Row result = (Row)df2.head();
            String resultOrigin = result.getStruct(0).getString(0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new URI(resultOrigin));
            URI $org_scalatest_assert_macro_right3 = Paths.get(filePath, new String[0]).toAbsolutePath().normalize().toUri();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(result);
            Row $org_scalatest_assert_macro_right4 = ImageSchema$.MODULE$.invalidImageRow(resultOrigin);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        }, new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.ignore("image datasource partition test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] result = (Row[])this.spark().read().format("image").option("dropInvalid", true).load(this.imagePath()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.substring_index(functions$.MODULE$.col("image.origin"), "/", -1).as("origin"), functions$.MODULE$.col("cls"), functions$.MODULE$.col("date")})).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])result)));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"29.5.a_b_EGDP022204.jpg", "kittens", "2018-01"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"54893.jpg", "kittens", "2018-02"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"DP153539.jpg", "kittens", "2018-02"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"DP802813.jpg", "kittens", "2018-02"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"BGRA.png", "multichannel", "2018-01"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"BGRA_alpha_60.png", "multichannel", "2018-01"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"chr30.4.184.jpg", "multichannel", "2018-02"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"grayscale.jpg", "multichannel", "2018-02"}))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        }, new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.ignore("readImages pixel values test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] images = (Row[])this.spark().read().format("image").option("dropInvalid", true).load(new StringBuilder(18).append(this.imagePath()).append("/cls=multichannel/").toString()).collect();
            Set firstBytes20Set = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])images)).map((Function1 & Serializable & scala.Serializable)rrow -> {
                Row row = (Row)rrow.getAs("image");
                String filename = ((Object)Paths.get(ImageSchema$.MODULE$.getOrigin(row), new String[0]).getFileName()).toString();
                int mode = ImageSchema$.MODULE$.getMode(row);
                List bytes20 = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(ImageSchema$.MODULE$.getData(row))).slice(0, 20))).toList();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)filename), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)mode), (Object)bytes20));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(firstBytes20Set);
            Set<Tuple2<String, Tuple2<Object, List<Object>>>> $org_scalatest_assert_macro_right = this.expectedFirstBytes20Set();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        }, new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.expectedFirstBytes20Set = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"grayscale.jpg"), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{-2, -33, -61, -60, -59, -59, -64, -59, -66, -67, -73, -73, -62, -57, -60, -63, -53, -49, -55, -69})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"chr30.4.184.jpg"), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)16), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{-9, -3, -1, -43, -32, -28, -75, -60, -57, -78, -59, -56, -74, -59, -57, -71, -58, -56, -73, -64})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BGRA.png"), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)24), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{-128, -128, -8, -1, -128, -128, -8, -1, -128, -128, -8, -1, 127, 127, -9, -1, 127, 127, -9, -1})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BGRA_alpha_60.png"), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)24), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{-128, -128, -8, 60, -128, -128, -8, 60, -128, -128, -8, 60, 127, 127, -9, 60, 127, 127, -9, 60}))))}));
    }
}

