/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.GradientBoostedTreesSuite$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.loss.AbsoluteError$;
import org.apache.spark.mllib.tree.loss.LogLoss$;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.loss.SquaredError$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00052AAA\u0002\u0001!!)Q\u0004\u0001C\u0001=\tIrI]1eS\u0016tGOQ8pgR,G\r\u0016:fKN\u001cV/\u001b;f\u0015\t!Q!\u0001\u0003j[Bd'B\u0001\u0004\b\u0003\u0011!(/Z3\u000b\u0005!I\u0011AA7m\u0015\tQ1\"A\u0003ta\u0006\u00148N\u0003\u0002\r\u001b\u00051\u0011\r]1dQ\u0016T\u0011AD\u0001\u0004_J<7\u0001A\n\u0004\u0001E)\u0002C\u0001\n\u0014\u001b\u0005I\u0011B\u0001\u000b\n\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011acG\u0007\u0002/)\u0011\u0001$G\u0001\u0005kRLGN\u0003\u0002\u001b\u0013\u0005)Q\u000e\u001c7jE&\u0011Ad\u0006\u0002\u0016\u001b2c\u0017N\u0019+fgR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t1\u0001")
public class GradientBoostedTreesSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        GradientBoostedTreesSuite gradientBoostedTreesSuite = this;
        synchronized (gradientBoostedTreesSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$4(GradientBoostedTreesSuite $this, int numIterations$1, RDD trainRdd$1, RDD validateRdd$1, int seed$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double errorWithValidation;
            Tuple2.mcDD.sp sp2;
            Tuple2.mcDD.sp sp3;
            Strategy treeStrategy;
            Enumeration.Value algo = (Enumeration.Value)tuple2._1();
            Loss loss = (Loss)tuple2._2();
            Enumeration.Value x$1 = algo;
            Variance$ x$2 = Variance$.MODULE$;
            int x$3 = 2;
            Map x$4 = Predef$.MODULE$.Map().empty();
            int x$5 = Strategy$.MODULE$.$lessinit$greater$default$4();
            int x$6 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$7 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$8 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$9 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$10 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$11 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$12 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$13 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$14 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$15 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy x$16 = treeStrategy = new Strategy(x$1, (Impurity)x$2, x$3, x$5, x$6, x$7, x$4, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
            Loss x$17 = loss;
            int x$18 = numIterations$1;
            double x$19 = 0.0;
            double x$20 = BoostingStrategy$.MODULE$.$lessinit$greater$default$4();
            BoostingStrategy boostingStrategy = new BoostingStrategy(x$16, x$17, x$18, x$20, x$19);
            Tuple2 tuple22 = GradientBoostedTrees$.MODULE$.runWithValidation(trainRdd$1, validateRdd$1, boostingStrategy, (long)seed$1, "all", GradientBoostedTrees$.MODULE$.runWithValidation$default$6());
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            DecisionTreeRegressionModel[] validateTrees = (DecisionTreeRegressionModel[])tuple22._1();
            double[] validateTreeWeights = (double[])tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)validateTrees, (Object)validateTreeWeights);
            DecisionTreeRegressionModel[] validateTrees2 = (DecisionTreeRegressionModel[])tuple23._1();
            double[] validateTreeWeights2 = (double[])tuple23._2();
            int numTrees = validateTrees2.length;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numTrees));
            int $org_scalatest_assert_macro_right = numIterations$1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$bang$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            Tuple2 tuple24 = GradientBoostedTrees$.MODULE$.run(trainRdd$1, boostingStrategy, (long)seed$1, "all", GradientBoostedTrees$.MODULE$.run$default$5());
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])tuple24._1();
            double[] treeWeights = (double[])tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)trees, (Object)treeWeights);
            DecisionTreeRegressionModel[] trees2 = (DecisionTreeRegressionModel[])tuple25._1();
            double[] treeWeights2 = (double[])tuple25._2();
            Enumeration.Value value = algo;
            Enumeration.Value value2 = Algo$.MODULE$.Classification();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                RDD remappedRdd = validateRdd$1.map((Function1 & Serializable & scala.Serializable)x -> new Instance((double)2 * x.label() - 1.0, x.weight(), x.features()), ClassTag$.MODULE$.apply(Instance.class));
                sp3 = new Tuple2.mcDD.sp(GradientBoostedTrees$.MODULE$.computeWeightedError(remappedRdd, trees2, treeWeights2, loss), GradientBoostedTrees$.MODULE$.computeWeightedError(remappedRdd, validateTrees2, validateTreeWeights2, loss));
            } else {
                sp3 = sp2 = new Tuple2.mcDD.sp(GradientBoostedTrees$.MODULE$.computeWeightedError(validateRdd$1, trees2, treeWeights2, loss), GradientBoostedTrees$.MODULE$.computeWeightedError(validateRdd$1, validateTrees2, validateTreeWeights2, loss));
            }
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            double errorWithoutValidation = sp2._1$mcD$sp();
            double errorWithValidation2 = sp2._2$mcD$sp();
            Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(errorWithoutValidation, errorWithValidation2);
            double errorWithoutValidation2 = sp4._1$mcD$sp();
            double $org_scalatest_assert_macro_left2 = errorWithValidation = sp4._2$mcD$sp();
            double $org_scalatest_assert_macro_right2 = errorWithoutValidation2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            double[] evaluationArray = GradientBoostedTrees$.MODULE$.evaluateEachIteration(validateRdd$1, trees2, treeWeights2, loss, algo);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)evaluationArray.length));
            int $org_scalatest_assert_macro_right3 = numIterations$1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            double $org_scalatest_assert_macro_left4 = evaluationArray[numTrees];
            double $org_scalatest_assert_macro_right4 = evaluationArray[numTrees - 1];
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            for (int i = 1; i < numTrees; ++i) {
                double $org_scalatest_assert_macro_left5 = evaluationArray[i];
                double $org_scalatest_assert_macro_right5 = evaluationArray[i - 1];
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 <= $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public GradientBoostedTreesSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("runWithValidation stops early and performs better on a validation dataset", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int numIterations = 20;
            RDD trainRdd = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.trainData()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asML().toInstance(), ClassTag$.MODULE$.apply(Instance.class));
            RDD validateRdd = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.validateData()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.asML().toInstance(), ClassTag$.MODULE$.apply(Instance.class));
            int seed = 42;
            Enumeration.Value[] algos = (Enumeration.Value[])((Object[])new Enumeration.Value[]{Algo$.MODULE$.Regression(), Algo$.MODULE$.Regression(), Algo$.MODULE$.Classification()});
            Loss[] losses = (Loss[])((Object[])new Loss[]{SquaredError$.MODULE$, AbsoluteError$.MODULE$, LogLoss$.MODULE$});
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])algos)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])losses), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                GradientBoostedTreesSuite.$anonfun$new$4(this, numIterations, trainRdd, validateRdd, seed, x0$1);
                return BoxedUnit.UNIT;
            });
        }, new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
    }
}

