/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.util.Arrays;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.clustering.BisectingKMeans;
import org.apache.spark.mllib.clustering.BisectingKMeansModel;
import org.apache.spark.mllib.clustering.ClusteringTreeNode;
import org.apache.spark.mllib.linalg.Vectors;
import org.junit.Assert;
import org.junit.Test;

public class JavaBisectingKMeansSuite
extends SharedSparkSession {
    @Test
    public void twoDimensionalData() {
        JavaRDD points = this.jsc.parallelize(Arrays.asList(Vectors.dense((double)4.0, (double[])new double[]{-1.0}), Vectors.dense((double)4.0, (double[])new double[]{1.0}), Vectors.sparse((int)2, (int[])new int[]{0}, (double[])new double[]{1.0})), 2);
        BisectingKMeans bkm = new BisectingKMeans().setK(4).setMaxIterations(2).setSeed(1L);
        BisectingKMeansModel model = bkm.run(points);
        Assert.assertEquals((long)3L, (long)model.k());
        Assert.assertArrayEquals((double[])new double[]{3.0, 0.0}, (double[])model.root().center().toArray(), (double)1.0E-12);
        for (ClusteringTreeNode child : model.root().children()) {
            double[] center = child.center().toArray();
            if (center[0] > 2.0) {
                Assert.assertEquals((long)2L, (long)child.size());
                Assert.assertArrayEquals((double[])new double[]{4.0, 0.0}, (double[])center, (double)1.0E-12);
                continue;
            }
            Assert.assertEquals((long)1L, (long)child.size());
            Assert.assertArrayEquals((double[])new double[]{1.0, 0.0}, (double[])center, (double)1.0E-12);
        }
    }
}

