/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.clustering.PowerIterationClustering;
import org.apache.spark.mllib.clustering.PowerIterationClustering$;
import org.apache.spark.mllib.clustering.PowerIterationClusteringModel;
import org.apache.spark.mllib.clustering.PowerIterationClusteringModel$;
import org.apache.spark.mllib.clustering.PowerIterationClusteringSuite$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00154AAC\u0006\u0001-!)\u0011\u0005\u0001C\u0001E!)Q\u0005\u0001C\u0005M!)!\b\u0001C\u0005w\u001d)\u0001i\u0003E\u0001\u0003\u001a)!b\u0003E\u0001\u0005\")\u0011%\u0002C\u0001\u0007\")A)\u0002C\u0001\u000b\")!+\u0002C\u0001'\"91,BA\u0001\n\u0013a&!\b)po\u0016\u0014\u0018\n^3sCRLwN\\\"mkN$XM]5oON+\u0018\u000e^3\u000b\u00051i\u0011AC2mkN$XM]5oO*\u0011abD\u0001\u0006[2d\u0017N\u0019\u0006\u0003!E\tQa\u001d9be.T!AE\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0012aA8sO\u000e\u00011c\u0001\u0001\u00187A\u0011\u0001$G\u0007\u0002\u001f%\u0011!d\u0004\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005qyR\"A\u000f\u000b\u0005yi\u0011\u0001B;uS2L!\u0001I\u000f\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"\u0012a\t\t\u0003I\u0001i\u0011aC\u0001\nO\u0016t7)\u001b:dY\u0016$2aJ\u001a6!\rA3&L\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t)\u0011I\u001d:bsB!\u0001F\f\u00191\u0013\ty\u0013F\u0001\u0004UkBdWM\r\t\u0003QEJ!AM\u0015\u0003\r\u0011{WO\u00197f\u0011\u0015!$\u00011\u00011\u0003\u0005\u0011\b\"\u0002\u001c\u0003\u0001\u00049\u0014!\u00018\u0011\u0005!B\u0014BA\u001d*\u0005\rIe\u000e^\u0001\u0004g&lGc\u0001\u0019=}!)Qh\u0001a\u0001[\u0005\t\u0001\u0010C\u0003@\u0007\u0001\u0007Q&A\u0001z\u0003u\u0001vn^3s\u0013R,'/\u0019;j_:\u001cE.^:uKJLgnZ*vSR,\u0007C\u0001\u0013\u0006'\t)q\u0003F\u0001B\u0003-\u0019'/Z1uK6{G-\u001a7\u0015\t\u0019Ke\n\u0015\t\u0003I\u001dK!\u0001S\u0006\u0003;A{w/\u001a:Ji\u0016\u0014\u0018\r^5p]\u000ecWo\u001d;fe&tw-T8eK2DQAS\u0004A\u0002-\u000b!a]2\u0011\u0005aa\u0015BA'\u0010\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0015yu\u00011\u00018\u0003\u0005Y\u0007\"B)\b\u0001\u00049\u0014a\u00028Q_&tGo]\u0001\u000bG\",7m[#rk\u0006dGc\u0001+X3B\u0011\u0001&V\u0005\u0003-&\u0012A!\u00168ji\")\u0001\f\u0003a\u0001\r\u0006\t\u0011\rC\u0003[\u0011\u0001\u0007a)A\u0001c\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003u\u0003\"AX2\u000e\u0003}S!\u0001Y1\u0002\t1\fgn\u001a\u0006\u0002E\u0006!!.\u0019<b\u0013\t!wL\u0001\u0004PE*,7\r\u001e")
public class PowerIterationClusteringSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static void checkEqual(PowerIterationClusteringModel powerIterationClusteringModel, PowerIterationClusteringModel powerIterationClusteringModel2) {
        PowerIterationClusteringSuite$.MODULE$.checkEqual(powerIterationClusteringModel, powerIterationClusteringModel2);
    }

    public static PowerIterationClusteringModel createModel(SparkContext sparkContext, int n, int n2) {
        return PowerIterationClusteringSuite$.MODULE$.createModel(sparkContext, n, n2);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private Tuple2<Object, Object>[] genCircle(double r, int n) {
        return (Tuple2[])Array$.MODULE$.tabulate(n, (Function1 & Serializable & scala.Serializable)i -> PowerIterationClusteringSuite.$anonfun$genCircle$1(n, r, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private double sim(Tuple2<Object, Object> x, Tuple2<Object, Object> y) {
        double dist2 = (x._1$mcD$sp() - y._1$mcD$sp()) * (x._1$mcD$sp() - y._1$mcD$sp()) + (x._2$mcD$sp() - y._2$mcD$sp()) * (x._2$mcD$sp() - y._2$mcD$sp());
        return package$.MODULE$.exp(-dist2 / 2.0);
    }

    private final void testImplicits$lzycompute$1() {
        PowerIterationClusteringSuite powerIterationClusteringSuite = this;
        synchronized (powerIterationClusteringSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$genCircle$1(int n$1, double r$1, int i) {
        double theta = Math.PI * 2 * (double)i / (double)n$1;
        return new Tuple2.mcDD.sp(r$1 * package$.MODULE$.cos(theta), r$1 * package$.MODULE$.sin(theta));
    }

    public static final /* synthetic */ Tuple3 $anonfun$new$3(PowerIterationClusteringSuite $this, int i$1, Tuple2[] points$1, int j) {
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)i$1), (Object)BoxesRunTime.boxToLong((long)j), (Object)BoxesRunTime.boxToDouble((double)$this.sim((Tuple2<Object, Object>)points$1[i$1], (Tuple2<Object, Object>)points$1[j])));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$new$2(PowerIterationClusteringSuite $this, Tuple2[] points$1, int i) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), i).map((Function1 & Serializable & scala.Serializable)j -> PowerIterationClusteringSuite.$anonfun$new$3($this, i, points$1, BoxesRunTime.unboxToInt((Object)j)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Tuple3 $anonfun$new$10(PowerIterationClusteringSuite $this, int i$2, Tuple2[] points$2, int j) {
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)i$2), (Object)BoxesRunTime.boxToLong((long)j), (Object)BoxesRunTime.boxToDouble((double)$this.sim((Tuple2<Object, Object>)points$2[i$2], (Tuple2<Object, Object>)points$2[j])));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$new$9(PowerIterationClusteringSuite $this, Tuple2[] points$2, int i) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), i).map((Function1 & Serializable & scala.Serializable)j -> PowerIterationClusteringSuite.$anonfun$new$10($this, i, points$2, BoxesRunTime.unboxToInt((Object)j)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public PowerIterationClusteringSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("power iteration clustering", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double r1 = 1.0;
            int n1 = 80;
            double r2 = 4.0;
            int n2 = 80;
            int n = n1 + n2;
            Tuple2[] points = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.genCircle(r1, n1))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.genCircle(r2, n2))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            IndexedSeq similarities = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), n).flatMap((Function1 & Serializable & scala.Serializable)i -> PowerIterationClusteringSuite.$anonfun$new$2(this, points, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            PowerIterationClusteringModel model = new PowerIterationClustering().setK(2).setMaxIterations(40).run(this.sc().parallelize((Seq)similarities, 2, ClassTag$.MODULE$.apply(Tuple3.class)));
            Set[] predictions = (Set[])Array$.MODULE$.fill(2, (Function0 & Serializable & scala.Serializable)() -> Set$.MODULE$.empty(), ClassTag$.MODULE$.apply(Set.class));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.assignments().collect())).foreach((Function1 & Serializable & scala.Serializable)a -> (Set)predictions[a.cluster()].$plus$eq((Object)BoxesRunTime.boxToLong((long)a.id())));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predictions)).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n1).toSet(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(n1), n).toSet()}));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            PowerIterationClusteringModel model2 = new PowerIterationClustering().setK(2).setMaxIterations(10).setInitializationMode("degree").run(this.sc().parallelize((Seq)similarities, 2, ClassTag$.MODULE$.apply(Tuple3.class)));
            Set[] predictions2 = (Set[])Array$.MODULE$.fill(2, (Function0 & Serializable & scala.Serializable)() -> Set$.MODULE$.empty(), ClassTag$.MODULE$.apply(Set.class));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model2.assignments().collect())).foreach((Function1 & Serializable & scala.Serializable)a -> (Set)predictions2[a.cluster()].$plus$eq((Object)BoxesRunTime.boxToLong((long)a.id())));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predictions2)).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n1).toSet(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(n1), n).toSet()}));
            scala.collection.immutable.Set set3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        }, new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("power iteration clustering on graph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double r1 = 1.0;
            int n1 = 80;
            double r2 = 4.0;
            int n2 = 80;
            int n = n1 + n2;
            Tuple2[] points = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.genCircle(r1, n1))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.genCircle(r2, n2))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            IndexedSeq similarities = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), n).flatMap((Function1 & Serializable & scala.Serializable)i -> PowerIterationClusteringSuite.$anonfun$new$9(this, points, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            IndexedSeq edges = (IndexedSeq)similarities.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple3 tuple3 = x0$1;
                if (tuple3 != null) {
                    long i = BoxesRunTime.unboxToLong((Object)tuple3._1());
                    long j = BoxesRunTime.unboxToLong((Object)tuple3._2());
                    double s = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                    return (Seq)new .colon.colon((Object)new Edge.mcD.sp(i, j, s), (List)new .colon.colon((Object)new Edge.mcD.sp(j, i, s), (List)Nil$.MODULE$));
                }
                throw new MatchError((Object)tuple3);
            }, IndexedSeq$.MODULE$.canBuildFrom());
            Graph graph = Graph$.MODULE$.fromEdges(this.sc().parallelize((Seq)edges, 2, ClassTag$.MODULE$.apply(Edge.class)), (Object)BoxesRunTime.boxToDouble((double)0.0), Graph$.MODULE$.fromEdges$default$3(), Graph$.MODULE$.fromEdges$default$4(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
            PowerIterationClusteringModel model = new PowerIterationClustering().setK(2).setMaxIterations(40).run(graph);
            Set[] predictions = (Set[])Array$.MODULE$.fill(2, (Function0 & Serializable & scala.Serializable)() -> Set$.MODULE$.empty(), ClassTag$.MODULE$.apply(Set.class));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.assignments().collect())).foreach((Function1 & Serializable & scala.Serializable)a -> (Set)predictions[a.cluster()].$plus$eq((Object)BoxesRunTime.boxToLong((long)a.id())));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predictions)).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n1).toSet(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(n1), n).toSet()}));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            PowerIterationClusteringModel model2 = new PowerIterationClustering().setK(2).setMaxIterations(10).setInitializationMode("degree").run(this.sc().parallelize((Seq)similarities, 2, ClassTag$.MODULE$.apply(Tuple3.class)));
            Set[] predictions2 = (Set[])Array$.MODULE$.fill(2, (Function0 & Serializable & scala.Serializable)() -> Set$.MODULE$.empty(), ClassTag$.MODULE$.apply(Set.class));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model2.assignments().collect())).foreach((Function1 & Serializable & scala.Serializable)a -> (Set)predictions2[a.cluster()].$plus$eq((Object)BoxesRunTime.boxToLong((long)a.id())));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predictions2)).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n1).toSet(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(n1), n).toSet()}));
            scala.collection.immutable.Set set3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        }, new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("normalize and powerIter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq similarities = (Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToDouble((double)1.0)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToDouble((double)1.0)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToDouble((double)1.0)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToDouble((double)1.0)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToDouble((double)1.0)), (List)Nil$.MODULE$)))));
            double[][] expected = (double[][])((Object[])new double[][]{{0.0, 0.3333333333333333, 0.3333333333333333, 0.3333333333333333}, {0.5, 0.0, 0.5, 0.0}, {0.3333333333333333, 0.3333333333333333, 0.0, 0.3333333333333333}, {0.5, 0.0, 0.5, 0.0}});
            Graph w = PowerIterationClustering$.MODULE$.normalize(this.sc().parallelize(similarities, 2, ClassTag$.MODULE$.apply(Tuple3.class)));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])w.edges().collect())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Edge edge = x0$2;
                if (edge != null) {
                    long i = edge.srcId();
                    long j = edge.dstId();
                    double x = edge.attr$mcD$sp();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(expected[(int)i][(int)j]).absTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(expected.apply(i.toInt).apply(j.toInt)).absTol(1.0E-14))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
                }
                throw new MatchError((Object)edge);
            });
            RDD v0 = this.sc().parallelize((Seq)new .colon.colon((Object)new Tuple2.mcJD.sp(0L, 0.1), (List)new .colon.colon((Object)new Tuple2.mcJD.sp(1L, 0.2), (List)new .colon.colon((Object)new Tuple2.mcJD.sp(2L, 0.3), (List)new .colon.colon((Object)new Tuple2.mcJD.sp(3L, 0.4), (List)Nil$.MODULE$)))), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            Graph w0 = Graph$.MODULE$.apply(v0, (RDD)w.edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
            Tuple2[] v1 = (Tuple2[])PowerIterationClustering$.MODULE$.powerIter(w0, 1).collect();
            double[] u = new double[]{0.3, 0.2, 0.2333333333333333, 0.2};
            double norm = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(u)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double[] u1 = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(u)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x / norm, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])v1)).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    long i = tuple2._1$mcJ$sp();
                    double x = tuple2._2$mcD$sp();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(u1[(int)i]).absTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(u1.apply(i.toInt)).absTol(1.0E-14))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            File tempDir = Utils$.MODULE$.createTempDir();
            String path = tempDir.toURI().toString();
            PowerIterationClusteringModel model = PowerIterationClusteringSuite$.MODULE$.createModel(this.sc(), 3, 10);
            try {
                model.save(this.sc(), path);
                PowerIterationClusteringModel sameModel = PowerIterationClusteringModel$.MODULE$.load(this.sc(), path);
                PowerIterationClusteringSuite$.MODULE$.checkEqual(model, sameModel);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return boxedUnit;
        }, new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
    }
}

