/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.operators.HasOps$;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.clustering.StreamingKMeans;
import org.apache.spark.mllib.clustering.StreamingKMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.LocalStreamingContext;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.random.XORShiftRandom;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.concurrent.PatienceConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0002\u0004\u0001#!)q\u0004\u0001C\u0001A!)1\u0005\u0001C!I!)1\u0006\u0001C\u0001Y!9q\u000bAI\u0001\n\u0003A&\u0001F*ue\u0016\fW.\u001b8h\u00176+\u0017M\\:Tk&$XM\u0003\u0002\b\u0011\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005%Q\u0011!B7mY&\u0014'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0005\f\u001d!\t\u0019B#D\u0001\u000b\u0013\t)\"BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00033)\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\u0005mA\"!\u0006'pG\u0006d7\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010\u001e\t\u0003/uI!A\b\r\u0003\u001bQ+7\u000f^*vSR,')Y:f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\ta!A\tnCb<\u0016-\u001b;US6,W*\u001b7mSN,\u0012!\n\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0004\u0013:$\u0018\u0001H*ue\u0016\fW.\u001b8h\u00176+\u0017M\\:ECR\fw)\u001a8fe\u0006$xN\u001d\u000b\t[\u0019C%\n\u0014(T+B!aE\f\u0019D\u0013\tysE\u0001\u0004UkBdWM\r\t\u0004cebdB\u0001\u001a8\u001d\t\u0019d'D\u00015\u0015\t)\u0004#\u0001\u0004=e>|GOP\u0005\u0002Q%\u0011\u0001hJ\u0001\ba\u0006\u001c7.Y4f\u0013\tQ4H\u0001\u0006J]\u0012,\u00070\u001a3TKFT!\u0001O\u0014\u0011\u0007EJT\b\u0005\u0002?\u00036\tqH\u0003\u0002A\u0011\u00051A.\u001b8bY\u001eL!AQ \u0003\rY+7\r^8s!\r1C)P\u0005\u0003\u000b\u001e\u0012Q!\u0011:sCfDQaR\u0002A\u0002\u0015\n\u0011B\\;n!>Lg\u000e^:\t\u000b%\u001b\u0001\u0019A\u0013\u0002\u00159,XNQ1uG\",7\u000fC\u0003L\u0007\u0001\u0007Q%A\u0001l\u0011\u0015i5\u00011\u0001&\u0003\u0005!\u0007\"B(\u0004\u0001\u0004\u0001\u0016!\u0001:\u0011\u0005\u0019\n\u0016B\u0001*(\u0005\u0019!u.\u001e2mK\")Ak\u0001a\u0001K\u0005!1/Z3e\u0011\u001d16\u0001%AA\u0002\r\u000b1\"\u001b8ji\u000e+g\u000e^3sg\u000613\u000b\u001e:fC6LgnZ&NK\u0006t7\u000fR1uC\u001e+g.\u001a:bi>\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0003eS#a\u0011.,\u0003m\u0003\"\u0001X1\u000e\u0003uS!AX0\u0002\u0013Ut7\r[3dW\u0016$'B\u00011(\u0003)\tgN\\8uCRLwN\\\u0005\u0003Ev\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class StreamingKMeansSuite
extends SparkFunSuite
implements LocalStreamingContext,
TestSuiteBase {
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private transient StreamingContext ssc;
    private final transient boolean stopSparkContext;
    private volatile boolean bitmap$0;

    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$afterEach() {
        LocalStreamingContext.afterEach$((LocalStreamingContext)this);
    }

    public String framework() {
        return TestSuiteBase.framework$((TestSuiteBase)this);
    }

    public String master() {
        return TestSuiteBase.master$((TestSuiteBase)this);
    }

    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$((TestSuiteBase)this);
    }

    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$((TestSuiteBase)this);
    }

    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$((TestSuiteBase)this);
    }

    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$((TestSuiteBase)this);
    }

    public void beforeFunction() {
        TestSuiteBase.beforeFunction$((TestSuiteBase)this);
    }

    public void afterFunction() {
        TestSuiteBase.afterFunction$((TestSuiteBase)this);
    }

    public void beforeEach() {
        TestSuiteBase.beforeEach$((TestSuiteBase)this);
    }

    public void afterEach() {
        TestSuiteBase.afterEach$((TestSuiteBase)this);
    }

    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$((TestSuiteBase)this, (StreamingContext)ssc, block);
    }

    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$((TestSuiteBase)this, (TestServer)testServer, block);
    }

    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input, operation, (int)numPartitions, evidence$4, evidence$5);
    }

    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$((TestSuiteBase)this);
    }

    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$9);
    }

    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$((TestSuiteBase)this);
    }

    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$10);
    }

    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$((TestSuiteBase)this);
    }

    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$((TestSuiteBase)this, output, expectedOutput, (boolean)useSet, evidence$11);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (boolean)useSet, evidence$12, evidence$13);
    }

    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$((TestSuiteBase)this);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$14, evidence$15);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (boolean)useSet, evidence$16, evidence$17, evidence$18);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$19, evidence$20, evidence$21);
    }

    public /* synthetic */ void org$apache$spark$streaming$LocalStreamingContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public void resetStreamingContext() {
        LocalStreamingContext.resetStreamingContext$((LocalStreamingContext)this);
    }

    private String checkpointDir$lzycompute() {
        StreamingKMeansSuite streamingKMeansSuite = this;
        synchronized (streamingKMeansSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$((TestSuiteBase)this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    public String checkpointDir() {
        if (!this.bitmap$0) {
            return this.checkpointDir$lzycompute();
        }
        return this.checkpointDir;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    public StreamingContext ssc() {
        return this.ssc;
    }

    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    public boolean stopSparkContext() {
        return this.stopSparkContext;
    }

    public void org$apache$spark$streaming$LocalStreamingContext$_setter_$stopSparkContext_$eq(boolean x$1) {
        this.stopSparkContext = x$1;
    }

    public int maxWaitTimeMillis() {
        return 100000;
    }

    public Tuple2<IndexedSeq<IndexedSeq<Vector>>, Vector[]> StreamingKMeansDataGenerator(int numPoints, int numBatches, int k, int d, double r, int seed, Vector[] initCenters) {
        XORShiftRandom rand = new XORShiftRandom((long)seed);
        Vector[] vectorArray = initCenters;
        Vector[] centers = vectorArray == null ? (Vector[])Array$.MODULE$.fill(k, (Function0 & Serializable & scala.Serializable)() -> Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(d, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rand.nextGaussian(), ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(Vector.class)) : initCenters;
        scala.collection.immutable.IndexedSeq data = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1 & Serializable & scala.Serializable)i -> StreamingKMeansSuite.$anonfun$StreamingKMeansDataGenerator$3(numPoints, centers, k, d, rand, r, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)data, (Object)centers);
    }

    public Vector[] StreamingKMeansDataGenerator$default$7() {
        return null;
    }

    public static final /* synthetic */ Vector $anonfun$StreamingKMeansDataGenerator$4(Vector[] centers$1, int k$1, int d$1, XORShiftRandom rand$1, double r$1, int idx) {
        Vector center = centers$1[idx % k$1];
        return Vectors$.MODULE$.dense((double[])Array$.MODULE$.tabulate(d$1, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x -> center.apply(x) + rand$1.nextGaussian() * r$1, ClassTag$.MODULE$.Double()));
    }

    public static final /* synthetic */ scala.collection.immutable.IndexedSeq $anonfun$StreamingKMeansDataGenerator$3(int numPoints$1, Vector[] centers$1, int k$1, int d$1, XORShiftRandom rand$1, double r$1, int i) {
        return (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPoints$1).map((Function1 & Serializable & scala.Serializable)idx -> StreamingKMeansSuite.$anonfun$StreamingKMeansDataGenerator$4(centers$1, k$1, d$1, rand$1, r$1, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public StreamingKMeansSuite() {
        LocalStreamingContext.$init$((LocalStreamingContext)this);
        TestSuiteBase.$init$((TestSuiteBase)this);
        this.test("accuracy for single center and equivalence to grand average", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int numBatches = 10;
            int numPoints = 50;
            int k = 1;
            int d = 5;
            double r = 0.1;
            StreamingKMeans model = new StreamingKMeans().setK(1).setDecayFactor(1.0).setInitialCenters((Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0}))}), new double[]{0.0});
            Tuple2<IndexedSeq<IndexedSeq<Vector>>, Vector[]> tuple2 = this.StreamingKMeansDataGenerator(numPoints, numBatches, k, d, r, 42, this.StreamingKMeansDataGenerator$default$7());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            IndexedSeq input = (IndexedSeq)tuple2._1();
            Vector[] centers = (Vector[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)input, (Object)centers);
            IndexedSeq input2 = (IndexedSeq)tuple22._1();
            Vector[] centers2 = (Vector[])tuple22._2();
            this.ssc_$eq(this.setupStreams((Seq)input2, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> {
                model.trainOn(inputDStream);
                return inputDStream.count();
            }, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(Vector.class), (ClassTag)ClassTag$.MODULE$.Long()));
            this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(centers2[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.latestModel().clusterCenters()[0]).absTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(centers.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.latestModel().clusterCenters.apply(0)).absTol(0.1))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            breeze.linalg.Vector grandMean = (breeze.linalg.Vector)((ImmutableNumericOps)((TraversableOnce)((TraversableLike)input2.flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)x -> x.asBreeze(), scala.collection.IndexedSeq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> (breeze.linalg.Vector)x$2.$plus(x$3, (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_V_eq_V_idempotent_Double_OpAdd()))).$div((Object)BoxesRunTime.boxToDouble((double)(numBatches * numPoints)), (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpDiv());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.latestModel().clusterCenters()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(grandMean.toArray$mcD$sp(ClassTag$.MODULE$.Double()))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.latestModel().clusterCenters.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(grandMean.toArray((ClassTag.Double: scala.reflect.ClassTag[Double])))).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("accuracy for two centers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2;
            int numBatches = 10;
            int numPoints = 5;
            int k = 2;
            int d = 5;
            double r = 0.1;
            int seed = 987654321;
            StreamingKMeans kMeans = new StreamingKMeans().setK(2).setHalfLife(2.0, "batches").setInitialCenters((Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(-0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1, -0.2, -0.3, -0.1})), Vectors$.MODULE$.dense(0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.2, 0.0, 0.2, 0.1}))}), new double[]{5.0, 5.0});
            Tuple2<IndexedSeq<IndexedSeq<Vector>>, Vector[]> tuple22 = this.StreamingKMeansDataGenerator(numPoints, numBatches, k, d, r, seed, this.StreamingKMeansDataGenerator$default$7());
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            IndexedSeq input = (IndexedSeq)tuple22._1();
            Vector[] centers = (Vector[])tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)input, (Object)centers);
            IndexedSeq input2 = (IndexedSeq)tuple23._1();
            Vector[] centers2 = (Vector[])tuple23._2();
            this.ssc_$eq(this.setupStreams((Seq)input2, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> {
                kMeans.trainOn(inputDStream);
                return inputDStream.count();
            }, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(Vector.class), (ClassTag)ClassTag$.MODULE$.Long()));
            this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            double d0 = Vectors$.MODULE$.sqdist(kMeans.latestModel().clusterCenters()[0], centers2[0]);
            double d1 = Vectors$.MODULE$.sqdist(kMeans.latestModel().clusterCenters()[0], centers2[1]);
            Tuple2 tuple24 = tuple2 = d0 < d1 ? new Tuple2((Object)centers2[0], (Object)centers2[1]) : new Tuple2((Object)centers2[1], (Object)centers2[0]);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector c0 = (Vector)tuple2._1();
            Vector c1 = (Vector)tuple2._2();
            Tuple2 tuple25 = new Tuple2((Object)c0, (Object)c1);
            Vector c02 = (Vector)tuple25._1();
            Vector c12 = (Vector)tuple25._2();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(c02).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(kMeans.latestModel().clusterCenters()[0]).absTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(c0).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(kMeans.latestModel().clusterCenters.apply(0)).absTol(0.1))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(c12).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(kMeans.latestModel().clusterCenters()[1]).absTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(c1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(kMeans.latestModel().clusterCenters.apply(1)).absTol(0.1))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        }, new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("detecting dying clusters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int numBatches = 10;
            int numPoints = 5;
            int k = 1;
            int d = 1;
            double r = 1.0;
            StreamingKMeans kMeans = new StreamingKMeans().setK(2).setHalfLife(0.5, "points").setInitialCenters((Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(1000.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))}), new double[]{1.0, 1.0});
            Tuple2<IndexedSeq<IndexedSeq<Vector>>, Vector[]> tuple2 = this.StreamingKMeansDataGenerator(numPoints, numBatches, k, d, r, 42, (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))}));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            IndexedSeq input = (IndexedSeq)tuple2._1();
            IndexedSeq input2 = input;
            this.ssc_$eq(this.setupStreams((Seq)input2, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> {
                kMeans.trainOn(inputDStream);
                return inputDStream.count();
            }, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(Vector.class), (ClassTag)ClassTag$.MODULE$.Long()));
            this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            StreamingKMeansModel model = kMeans.latestModel();
            double c0 = model.clusterCenters()[0].apply(0);
            double c1 = model.clusterCenters()[1].apply(0);
            double $org_scalatest_assert_macro_left = c0 * c1;
            double $org_scalatest_assert_macro_right = 0.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"should have one positive center and one negative center", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(package$.MODULE$.abs(c0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.8).absTol(0.6)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.abs(c0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.8).absTol(0.6))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(package$.MODULE$.abs(c1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.8).absTol(0.6)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.abs(c1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.8).absTol(0.6))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        }, new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("SPARK-7946 setDecayFactor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StreamingKMeans kMeans = new StreamingKMeans();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)kMeans.decayFactor()));
            double $org_scalatest_assert_macro_right = 1.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            kMeans.setDecayFactor(2.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)kMeans.decayFactor()));
            double $org_scalatest_assert_macro_right2 = 2.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        }, new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
    }
}

