/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.generic.UFunc;
import breeze.linalg.CSCMatrix;
import breeze.linalg.operators.HasOps$;
import breeze.storage.Zero$;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.Kryo$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseMatrix$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.MatrixImplicits$;
import org.apache.spark.mllib.linalg.MatrixUDT;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.SparseMatrix$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.SerializerInstance;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatestplus.mockito.MockitoSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001]1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\tiQ*\u0019;sS\u000e,7oU;ji\u0016T!\u0001B\u0003\u0002\r1Lg.\u00197h\u0015\t1q!A\u0003nY2L'M\u0003\u0002\t\u0013\u0005)1\u000f]1sW*\u0011!bC\u0001\u0007CB\f7\r[3\u000b\u00031\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\b\u0011\u0005A\tR\"A\u0004\n\u0005I9!!D*qCJ\\g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0007\u0001")
public class MatricesSuite
extends SparkFunSuite {
    private final void check$1(Object t, ClassTag evidence$1, SerializerInstance ser$1) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(ser$1.deserialize(ser$1.serialize(t, evidence$1), evidence$1));
        Object $org_scalatest_assert_macro_right = t;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
    }

    public static final /* synthetic */ boolean $anonfun$new$48(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).size() <= 50;
    }

    public static final /* synthetic */ boolean $anonfun$new$50(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).size() <= 100;
    }

    private final void compare$1(Matrix oldM, org.apache.spark.ml.linalg.Matrix newM) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(oldM.toArray());
        double[] $org_scalatest_assert_macro_right = newM.toArray();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)oldM.numCols()));
        int $org_scalatest_assert_macro_right2 = newM.numCols();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)oldM.numRows()));
        int $org_scalatest_assert_macro_right3 = newM.numRows();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 585));
    }

    private static final Tuple3 mllibMatrixToTriple$1(Matrix m) {
        return new Tuple3((Object)m.toArray(), (Object)BoxesRunTime.boxToInteger((int)m.numCols()), (Object)BoxesRunTime.boxToInteger((int)m.numRows()));
    }

    private static final Tuple3 mllibDenseMatrixToTriple$1(DenseMatrix m) {
        return new Tuple3((Object)m.toArray(), (Object)BoxesRunTime.boxToInteger((int)m.numCols()), (Object)BoxesRunTime.boxToInteger((int)m.numRows()));
    }

    private static final Tuple3 mllibSparseMatrixToTriple$1(SparseMatrix m) {
        return new Tuple3((Object)m.toArray(), (Object)BoxesRunTime.boxToInteger((int)m.numCols()), (Object)BoxesRunTime.boxToInteger((int)m.numRows()));
    }

    private static final Tuple3 mlMatrixToTriple$1(org.apache.spark.ml.linalg.Matrix m) {
        return new Tuple3((Object)m.toArray(), (Object)BoxesRunTime.boxToInteger((int)m.numCols()), (Object)BoxesRunTime.boxToInteger((int)m.numRows()));
    }

    private static final Tuple3 mlDenseMatrixToTriple$1(org.apache.spark.ml.linalg.DenseMatrix m) {
        return new Tuple3((Object)m.toArray(), (Object)BoxesRunTime.boxToInteger((int)m.numCols()), (Object)BoxesRunTime.boxToInteger((int)m.numRows()));
    }

    private static final Tuple3 mlSparseMatrixToTriple$1(org.apache.spark.ml.linalg.SparseMatrix m) {
        return new Tuple3((Object)m.toArray(), (Object)BoxesRunTime.boxToInteger((int)m.numCols()), (Object)BoxesRunTime.boxToInteger((int)m.numRows()));
    }

    private final void compare$2(Tuple3 m1, Tuple3 m2) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(m1._1());
        double[] $org_scalatest_assert_macro_right = (double[])m2._1();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(m1._2());
        int $org_scalatest_assert_macro_right2 = BoxesRunTime.unboxToInt((Object)m2._2());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(m1._3());
        int $org_scalatest_assert_macro_right3 = BoxesRunTime.unboxToInt((Object)m2._3());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
    }

    public MatricesSuite() {
        this.test("kryo class register", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf(false);
            conf.set(Kryo$.MODULE$.KRYO_REGISTRATION_REQUIRED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            SerializerInstance ser = new KryoSerializer(conf).newInstance();
            int m = 3;
            int n = 2;
            double[] denseValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
            DenseMatrix denseMat = (DenseMatrix)Matrices$.MODULE$.dense(m, n, denseValues);
            double[] sparseValues = new double[]{1.0, 2.0, 4.0, 5.0};
            int[] colPtrs = new int[]{0, 2, 4};
            int[] rowIndices = new int[]{1, 2, 1, 2};
            SparseMatrix sparseMat = (SparseMatrix)Matrices$.MODULE$.sparse(m, n, colPtrs, rowIndices, sparseValues);
            this.check$1(denseMat, ClassTag$.MODULE$.apply(DenseMatrix.class), ser);
            this.check$1(sparseMat, ClassTag$.MODULE$.apply(SparseMatrix.class), ser);
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("dense matrix construction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int m = 3;
            int n = 2;
            double[] values = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
            DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.dense(m, n, values);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = m;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = n;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            double[] $org_scalatest_assert_macro_left3 = mat.values();
            double[] $org_scalatest_assert_macro_right3 = values;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "eq", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"should not copy data", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("dense matrix construction with wrong dimension", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (RuntimeException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Matrices$.MODULE$.dense(3, 2, new double[]{0.0, 1.0, 2.0}), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71)), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("sparse matrix construction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int m = 3;
            int n = 4;
            double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
            int[] colPtrs = new int[]{0, 2, 2, 4, 4};
            int[] rowIndices = new int[]{1, 2, 1, 2};
            SparseMatrix mat = (SparseMatrix)Matrices$.MODULE$.sparse(m, n, colPtrs, rowIndices, values);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = m;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = n;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            double[] $org_scalatest_assert_macro_left3 = mat.values();
            double[] $org_scalatest_assert_macro_right3 = values;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "eq", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"should not copy data", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            int[] $org_scalatest_assert_macro_left4 = mat.colPtrs();
            int[] $org_scalatest_assert_macro_right4 = colPtrs;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "eq", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"should not copy data", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            int[] $org_scalatest_assert_macro_left5 = mat.rowIndices();
            int[] $org_scalatest_assert_macro_right5 = rowIndices;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "eq", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"should not copy data", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            Tuple3[] entries = (Tuple3[])((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)3.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)0.0))});
            SparseMatrix mat2 = SparseMatrix$.MODULE$.fromCOO(m, n, (Iterable)Predef$.MODULE$.wrapRefArray((Object[])entries));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(mat.asBreeze());
            breeze.linalg.Matrix $org_scalatest_assert_macro_right6 = mat2.asBreeze();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            double[] $org_scalatest_assert_macro_left7 = mat2.values();
            int $org_scalatest_assert_macro_right7 = 4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("sparse matrix construction with wrong number of elements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Matrices$.MODULE$.sparse(3, 2, new int[]{0, 1}, new int[]{1, 2, 1}, new double[]{0.0, 1.0, 2.0}), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Matrices$.MODULE$.sparse(3, 2, new int[]{0, 1, 2}, new int[]{1, 2}, new double[]{0.0, 1.0, 2.0}), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("index in matrices incorrect input", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Matrix sm = Matrices$.MODULE$.sparse(3, 2, new int[]{0, 2, 3}, new int[]{1, 2, 1}, new double[]{0.0, 1.0, 2.0});
            Matrix dm = Matrices$.MODULE$.dense(3, 2, new double[]{0.0, 2.3, 1.4, 3.2, 1.0, 9.1});
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Matrix[]{sm, dm})).foreach((Function1 & Serializable & scala.Serializable)mat -> {
                this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> mat.index(4, 1), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
                this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> mat.index(1, 4), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
                this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> mat.index(-1, 2), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
                return (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> mat.index(1, -2), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            });
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("equals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Matrix dm1 = Matrices$.MODULE$.dense(2, 2, new double[]{0.0, 1.0, 2.0, 3.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dm1);
            Matrix $org_scalatest_assert_macro_right = dm1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(dm1);
            Matrix $org_scalatest_assert_macro_right2 = dm1.transpose();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!==", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$bang$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            Matrix dm2 = Matrices$.MODULE$.dense(2, 2, new double[]{0.0, 2.0, 1.0, 3.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(dm1);
            Matrix $org_scalatest_assert_macro_right3 = dm2.transpose();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            SparseMatrix sm1 = ((DenseMatrix)dm1).toSparse();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(sm1);
            SparseMatrix $org_scalatest_assert_macro_right4 = sm1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(sm1);
            Matrix $org_scalatest_assert_macro_right5 = dm1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(sm1);
            SparseMatrix $org_scalatest_assert_macro_right6 = sm1.transpose();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "!==", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$bang$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            SparseMatrix sm2 = ((DenseMatrix)dm2).toSparse();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(sm1);
            SparseMatrix $org_scalatest_assert_macro_right7 = sm2.transpose();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(sm1);
            Matrix $org_scalatest_assert_macro_right8 = dm2.transpose();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("matrix copies are deep copies", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] $org_scalatest_assert_macro_right;
            double[] $org_scalatest_assert_macro_left;
            int m = 3;
            int n = 2;
            Matrix denseMat = Matrices$.MODULE$.dense(m, n, new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0});
            Matrix denseCopy = denseMat.copy();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "eq", (Object)$org_scalatest_assert_macro_right, ($org_scalatest_assert_macro_left = denseMat.toArray()) == ($org_scalatest_assert_macro_right = denseCopy.toArray()), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
            int[] colPtrs = new int[]{0, 2, 4};
            int[] rowIndices = new int[]{1, 2, 1, 2};
            Matrix sparseMat = Matrices$.MODULE$.sparse(m, n, colPtrs, rowIndices, values);
            Matrix sparseCopy = sparseMat.copy();
            double[] $org_scalatest_assert_macro_left2 = sparseMat.toArray();
            double[] $org_scalatest_assert_macro_right2 = sparseCopy.toArray();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("matrix indexing and updating", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int m = 3;
            int n = 2;
            double[] allValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 0.0};
            DenseMatrix denseMat = new DenseMatrix(m, n, allValues);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.apply(0, 1)));
            double $org_scalatest_assert_macro_right = 3.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.apply(0, 1)));
            double $org_scalatest_assert_macro_right2 = denseMat.values()[3];
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.apply(0, 1)));
            double $org_scalatest_assert_macro_right3 = denseMat.apply(3);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.apply(0, 0)));
            double $org_scalatest_assert_macro_right4 = 0.0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            denseMat.update(0, 0, 10.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.apply(0, 0)));
            double $org_scalatest_assert_macro_right5 = 10.0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.values()[0]));
            double $org_scalatest_assert_macro_right6 = 10.0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            double[] sparseValues = new double[]{1.0, 2.0, 3.0, 4.0};
            int[] colPtrs = new int[]{0, 2, 4};
            int[] rowIndices = new int[]{1, 2, 0, 1};
            SparseMatrix sparseMat = new SparseMatrix(m, n, colPtrs, rowIndices, sparseValues);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sparseMat.apply(0, 1)));
            double $org_scalatest_assert_macro_right7 = 3.0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sparseMat.apply(0, 1)));
            double $org_scalatest_assert_macro_right8 = sparseMat.values()[2];
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sparseMat.apply(0, 0)));
            double $org_scalatest_assert_macro_right9 = 0.0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> sparseMat.update(0, 0, 10.0), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> sparseMat.update(2, 1, 10.0), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            sparseMat.update(0, 1, 10.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sparseMat.apply(0, 1)));
            double $org_scalatest_assert_macro_right10 = 10.0;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sparseMat.values()[2]));
            double $org_scalatest_assert_macro_right11 = 10.0;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.test("toSparse, toDense", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int m = 3;
            int n = 2;
            double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
            double[] allValues = new double[]{1.0, 2.0, 0.0, 0.0, 4.0, 5.0};
            int[] colPtrs = new int[]{0, 2, 4};
            int[] rowIndices = new int[]{0, 1, 1, 2};
            SparseMatrix spMat1 = new SparseMatrix(m, n, colPtrs, rowIndices, values);
            DenseMatrix deMat1 = new DenseMatrix(m, n, allValues);
            SparseMatrix spMat2 = deMat1.toSparse();
            DenseMatrix deMat2 = spMat1.toDense();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(spMat1.asBreeze());
            breeze.linalg.Matrix $org_scalatest_assert_macro_right = spMat2.asBreeze();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(deMat1.asBreeze());
            breeze.linalg.Matrix $org_scalatest_assert_macro_right2 = deMat2.asBreeze();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        this.test("map, update", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int m = 3;
            int n = 2;
            double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
            double[] allValues = new double[]{1.0, 2.0, 0.0, 0.0, 4.0, 5.0};
            int[] colPtrs = new int[]{0, 2, 4};
            int[] rowIndices = new int[]{0, 1, 1, 2};
            SparseMatrix spMat1 = new SparseMatrix(m, n, colPtrs, rowIndices, values);
            DenseMatrix deMat1 = new DenseMatrix(m, n, allValues);
            DenseMatrix deMat2 = deMat1.map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$1 -> x$1 * (double)2);
            SparseMatrix spMat2 = spMat1.map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$2 -> x$2 * (double)2);
            deMat1.update((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$3 -> x$3 * (double)2);
            spMat1.update((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> x$4 * (double)2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(spMat1.toArray());
            double[] $org_scalatest_assert_macro_right = spMat2.toArray();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(deMat1.toArray());
            double[] $org_scalatest_assert_macro_right2 = deMat2.toArray();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        this.test("transpose", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseMatrix dA = new DenseMatrix(4, 3, new double[]{0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 3.0});
            SparseMatrix sA = new SparseMatrix(4, 3, new int[]{0, 1, 3, 4}, new int[]{1, 0, 2, 3}, new double[]{1.0, 2.0, 1.0, 3.0});
            DenseMatrix dAT = dA.transpose();
            SparseMatrix sAT = sA.transpose();
            DenseMatrix dATexpected = new DenseMatrix(3, 4, new double[]{0.0, 2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 3.0});
            SparseMatrix sATexpected = new SparseMatrix(3, 4, new int[]{0, 1, 2, 3, 4}, new int[]{1, 0, 1, 2}, new double[]{2.0, 1.0, 1.0, 3.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dAT.asBreeze());
            breeze.linalg.Matrix $org_scalatest_assert_macro_right = dATexpected.asBreeze();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(sAT.asBreeze());
            breeze.linalg.Matrix $org_scalatest_assert_macro_right2 = sATexpected.asBreeze();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)dA.apply(1, 0)));
            double $org_scalatest_assert_macro_right3 = dAT.apply(0, 1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)dA.apply(2, 1)));
            double $org_scalatest_assert_macro_right4 = dAT.apply(1, 2);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sA.apply(1, 0)));
            double $org_scalatest_assert_macro_right5 = sAT.apply(0, 1);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sA.apply(2, 1)));
            double $org_scalatest_assert_macro_right6 = sAT.apply(1, 2);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            double[] $org_scalatest_assert_macro_left7 = dA.toArray();
            double[] $org_scalatest_assert_macro_right7 = dAT.toArray();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "eq", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"has to have a new array", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
            double[] $org_scalatest_assert_macro_left8 = dA.values();
            double[] $org_scalatest_assert_macro_right8 = dAT.transpose().values();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "eq", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"should not copy array", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(dAT.toSparse().asBreeze());
            breeze.linalg.Matrix $org_scalatest_assert_macro_right9 = sATexpected.asBreeze();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(sAT.toDense().asBreeze());
            breeze.linalg.Matrix $org_scalatest_assert_macro_right10 = dATexpected.asBreeze();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        this.test("foreachActive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int m = 3;
            int n = 2;
            double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
            double[] allValues = new double[]{1.0, 2.0, 0.0, 0.0, 4.0, 5.0};
            int[] colPtrs = new int[]{0, 2, 4};
            int[] rowIndices = new int[]{0, 1, 1, 2};
            SparseMatrix sp2 = new SparseMatrix(m, n, colPtrs, rowIndices, values);
            DenseMatrix dn = new DenseMatrix(m, n, allValues);
            Map dnMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            dn.foreachActive((Function3 & Serializable & scala.Serializable)(i, j, value) -> {
                dnMap.put((Object)new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j)), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)value)));
                return BoxedUnit.UNIT;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)dnMap.size()));
            int $org_scalatest_assert_macro_right = 6;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(0, 0)));
            double $org_scalatest_assert_macro_right2 = 1.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(1, 0)));
            double $org_scalatest_assert_macro_right3 = 2.0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(2, 0)));
            double $org_scalatest_assert_macro_right4 = 0.0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(0, 1)));
            double $org_scalatest_assert_macro_right5 = 0.0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(1, 1)));
            double $org_scalatest_assert_macro_right6 = 4.0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(2, 1)));
            double $org_scalatest_assert_macro_right7 = 5.0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            Map spMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            sp2.foreachActive((Function3 & Serializable & scala.Serializable)(i, j, value) -> {
                spMap.put((Object)new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j)), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)value)));
                return BoxedUnit.UNIT;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spMap.size()));
            int $org_scalatest_assert_macro_right8 = 4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(spMap.apply((Object)new Tuple2.mcII.sp(0, 0)));
            double $org_scalatest_assert_macro_right9 = 1.0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(spMap.apply((Object)new Tuple2.mcII.sp(1, 0)));
            double $org_scalatest_assert_macro_right10 = 2.0;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(spMap.apply((Object)new Tuple2.mcII.sp(1, 1)));
            double $org_scalatest_assert_macro_right11 = 4.0;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(spMap.apply((Object)new Tuple2.mcII.sp(2, 1)));
            double $org_scalatest_assert_macro_right12 = 5.0;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        this.test("horzcat, vertcat, eye, speye", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int m = 3;
            int n = 2;
            double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
            double[] allValues = new double[]{1.0, 2.0, 0.0, 0.0, 4.0, 5.0};
            int[] colPtrs = new int[]{0, 2, 4};
            int[] rowIndices = new int[]{0, 1, 1, 2};
            double[] allValuesT = new double[]{1.0, 0.0, 2.0, 4.0, 0.0, 5.0};
            int[] colPtrsT = new int[]{0, 1, 3, 4};
            int[] rowIndicesT = new int[]{0, 0, 1, 1};
            SparseMatrix spMat1 = new SparseMatrix(m, n, colPtrs, rowIndices, values);
            DenseMatrix deMat1 = new DenseMatrix(m, n, allValues);
            SparseMatrix spMat1T = new SparseMatrix(n, m, colPtrsT, rowIndicesT, values);
            DenseMatrix deMat1T = new DenseMatrix(n, m, allValuesT);
            SparseMatrix spMat1TT = spMat1T.transpose();
            DenseMatrix deMat1TT = deMat1T.transpose();
            Matrix deMat2 = Matrices$.MODULE$.eye(3);
            Matrix spMat2 = Matrices$.MODULE$.speye(3);
            Matrix deMat3 = Matrices$.MODULE$.eye(2);
            Matrix spMat3 = Matrices$.MODULE$.speye(2);
            Matrix spHorz = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{spMat1, spMat2}));
            Matrix spHorz2 = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{spMat1, deMat2}));
            Matrix spHorz3 = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{deMat1, spMat2}));
            Matrix deHorz1 = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{deMat1, deMat2}));
            Matrix deHorz2 = Matrices$.MODULE$.horzcat((Matrix[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Matrix.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deHorz1.numRows()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz2.numRows()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz3.numRows()));
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz.numRows()));
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deHorz1.numCols()));
            int $org_scalatest_assert_macro_right5 = 5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz2.numCols()));
            int $org_scalatest_assert_macro_right6 = 5;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz3.numCols()));
            int $org_scalatest_assert_macro_right7 = 5;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz.numCols()));
            int $org_scalatest_assert_macro_right8 = 5;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deHorz2.numRows()));
            int $org_scalatest_assert_macro_right9 = 0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deHorz2.numCols()));
            int $org_scalatest_assert_macro_right10 = 0;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deHorz2.toArray().length));
            int $org_scalatest_assert_macro_right11 = 0;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deHorz1).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)((SparseMatrix)spHorz2).toDense()).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(deHorz1).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz2.asInstanceOf[org.apache.spark.mllib.linalg.SparseMatrix].toDense).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz2).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz3).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz2).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz3).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(0, 0)));
            double $org_scalatest_assert_macro_right12 = 1.0;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(2, 1)));
            double $org_scalatest_assert_macro_right13 = 5.0;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(0, 2)));
            double $org_scalatest_assert_macro_right14 = 1.0;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(1, 2)));
            double $org_scalatest_assert_macro_right15 = 0.0;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right15), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(1, 3)));
            double $org_scalatest_assert_macro_right16 = 1.0;
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right16), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(2, 4)));
            double $org_scalatest_assert_macro_right17 = 1.0;
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right17), $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right17), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(1, 4)));
            double $org_scalatest_assert_macro_right18 = 0.0;
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right18), $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right18), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left19 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(0, 0)));
            double $org_scalatest_assert_macro_right19 = 1.0;
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right19), $org_scalatest_assert_macro_left19.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right19), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left20 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(2, 1)));
            double $org_scalatest_assert_macro_right20 = 5.0;
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left20, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right20), $org_scalatest_assert_macro_left20.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right20), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left21 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(0, 2)));
            double $org_scalatest_assert_macro_right21 = 1.0;
            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right21), $org_scalatest_assert_macro_left21.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right21), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
            double $org_scalatest_assert_macro_left22 = deHorz1.apply(1, 2);
            double $org_scalatest_assert_macro_right22 = 0.0;
            Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left22), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right22), $org_scalatest_assert_macro_left22 == $org_scalatest_assert_macro_right22, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left23 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(1, 3)));
            double $org_scalatest_assert_macro_right23 = 1.0;
            Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left23, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right23), $org_scalatest_assert_macro_left23.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right23), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left24 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(2, 4)));
            double $org_scalatest_assert_macro_right24 = 1.0;
            Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left24, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right24), $org_scalatest_assert_macro_left24.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right24), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left25 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(1, 4)));
            double $org_scalatest_assert_macro_right25 = 0.0;
            Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left25, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right25), $org_scalatest_assert_macro_left25.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right25), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
            Matrix spHorzT = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{spMat1TT, spMat2}));
            Matrix spHorz2T = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{spMat1TT, deMat2}));
            Matrix spHorz3T = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{deMat1TT, spMat2}));
            Matrix deHorz1T = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{deMat1TT, deMat2}));
            Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deHorz1T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deHorz1).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(deHorz1T).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(deHorz1).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
            Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorzT).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorzT).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
            Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz2T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz2).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz2T).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz2).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
            Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz3T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz3).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz3T).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz3).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{spMat1, spMat3})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{deMat1, spMat3})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
            Matrix spVert = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{spMat1, spMat3}));
            Matrix deVert1 = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{deMat1, deMat3}));
            Matrix spVert2 = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{spMat1, deMat3}));
            Matrix spVert3 = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{deMat1, spMat3}));
            Matrix deVert2 = Matrices$.MODULE$.vertcat((Matrix[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Matrix.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left26 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deVert1.numRows()));
            int $org_scalatest_assert_macro_right26 = 5;
            Bool $org_scalatest_assert_macro_expr32 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left26, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right26), $org_scalatest_assert_macro_left26.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right26), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr32, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left27 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert2.numRows()));
            int $org_scalatest_assert_macro_right27 = 5;
            Bool $org_scalatest_assert_macro_expr33 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left27, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right27), $org_scalatest_assert_macro_left27.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right27), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr33, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left28 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert3.numRows()));
            int $org_scalatest_assert_macro_right28 = 5;
            Bool $org_scalatest_assert_macro_expr34 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left28, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right28), $org_scalatest_assert_macro_left28.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right28), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr34, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left29 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert.numRows()));
            int $org_scalatest_assert_macro_right29 = 5;
            Bool $org_scalatest_assert_macro_expr35 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left29, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right29), $org_scalatest_assert_macro_left29.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right29), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr35, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left30 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deVert1.numCols()));
            int $org_scalatest_assert_macro_right30 = 2;
            Bool $org_scalatest_assert_macro_expr36 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left30, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right30), $org_scalatest_assert_macro_left30.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right30), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr36, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left31 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert2.numCols()));
            int $org_scalatest_assert_macro_right31 = 2;
            Bool $org_scalatest_assert_macro_expr37 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left31, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right31), $org_scalatest_assert_macro_left31.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right31), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr37, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left32 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert3.numCols()));
            int $org_scalatest_assert_macro_right32 = 2;
            Bool $org_scalatest_assert_macro_expr38 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left32, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right32), $org_scalatest_assert_macro_left32.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right32), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr38, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left33 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert.numCols()));
            int $org_scalatest_assert_macro_right33 = 2;
            Bool $org_scalatest_assert_macro_expr39 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left33, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right33), $org_scalatest_assert_macro_left33.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right33), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr39, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left34 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deVert2.numRows()));
            int $org_scalatest_assert_macro_right34 = 0;
            Bool $org_scalatest_assert_macro_expr40 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left34, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right34), $org_scalatest_assert_macro_left34.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right34), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr40, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left35 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deVert2.numCols()));
            int $org_scalatest_assert_macro_right35 = 0;
            Bool $org_scalatest_assert_macro_expr41 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left35, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right35), $org_scalatest_assert_macro_left35.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right35), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr41, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left36 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deVert2.toArray().length));
            int $org_scalatest_assert_macro_right36 = 0;
            Bool $org_scalatest_assert_macro_expr42 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left36, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right36), $org_scalatest_assert_macro_left36.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right36), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr42, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
            Bool $org_scalatest_assert_macro_expr43 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deVert1).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)((SparseMatrix)spVert2).toDense()).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(deVert1).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert2.asInstanceOf[org.apache.spark.mllib.linalg.SparseMatrix].toDense).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr43, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
            Bool $org_scalatest_assert_macro_expr44 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert2).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert3).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert2).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert3).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr44, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left37 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spVert.apply(0, 0)));
            double $org_scalatest_assert_macro_right37 = 1.0;
            Bool $org_scalatest_assert_macro_expr45 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left37, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right37), $org_scalatest_assert_macro_left37.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right37), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr45, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left38 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spVert.apply(2, 1)));
            double $org_scalatest_assert_macro_right38 = 5.0;
            Bool $org_scalatest_assert_macro_expr46 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left38, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right38), $org_scalatest_assert_macro_left38.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right38), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr46, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left39 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spVert.apply(3, 0)));
            double $org_scalatest_assert_macro_right39 = 1.0;
            Bool $org_scalatest_assert_macro_expr47 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left39, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right39), $org_scalatest_assert_macro_left39.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right39), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr47, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left40 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spVert.apply(3, 1)));
            double $org_scalatest_assert_macro_right40 = 0.0;
            Bool $org_scalatest_assert_macro_expr48 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left40, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right40), $org_scalatest_assert_macro_left40.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right40), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr48, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left41 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spVert.apply(4, 1)));
            double $org_scalatest_assert_macro_right41 = 1.0;
            Bool $org_scalatest_assert_macro_expr49 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left41, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right41), $org_scalatest_assert_macro_left41.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right41), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr49, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left42 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deVert1.apply(0, 0)));
            double $org_scalatest_assert_macro_right42 = 1.0;
            Bool $org_scalatest_assert_macro_expr50 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left42, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right42), $org_scalatest_assert_macro_left42.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right42), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr50, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left43 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deVert1.apply(2, 1)));
            double $org_scalatest_assert_macro_right43 = 5.0;
            Bool $org_scalatest_assert_macro_expr51 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left43, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right43), $org_scalatest_assert_macro_left43.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right43), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr51, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left44 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deVert1.apply(3, 0)));
            double $org_scalatest_assert_macro_right44 = 1.0;
            Bool $org_scalatest_assert_macro_expr52 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left44, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right44), $org_scalatest_assert_macro_left44.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right44), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr52, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left45 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deVert1.apply(3, 1)));
            double $org_scalatest_assert_macro_right45 = 0.0;
            Bool $org_scalatest_assert_macro_expr53 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left45, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right45), $org_scalatest_assert_macro_left45.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right45), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr53, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left46 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deVert1.apply(4, 1)));
            double $org_scalatest_assert_macro_right46 = 1.0;
            Bool $org_scalatest_assert_macro_expr54 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left46, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right46), $org_scalatest_assert_macro_left46.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right46), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr54, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
            Matrix spVertT = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{spMat1TT, spMat3}));
            Matrix deVert1T = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{deMat1TT, deMat3}));
            Matrix spVert2T = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{spMat1TT, deMat3}));
            Matrix spVert3T = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{deMat1TT, spMat3}));
            Bool $org_scalatest_assert_macro_expr55 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deVert1T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deVert1).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(deVert1T).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(deVert1).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr55, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
            Bool $org_scalatest_assert_macro_expr56 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVertT).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVertT).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr56, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
            Bool $org_scalatest_assert_macro_expr57 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert2T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert2).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert2T).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert2).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr57, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
            Bool $org_scalatest_assert_macro_expr58 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert3T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert3).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert3T).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert3).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr58, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{spMat1, spMat2})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{deMat1, spMat2})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        this.test("zeros", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.zeros(2, 3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$5 -> x$5 == 0.0), "scala.Predef.doubleArrayOps(mat.values).forall(((x$5: Double) => x$5.==(0.0)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        this.test("ones", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.ones(2, 3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$6 -> x$6 == 1.0), "scala.Predef.doubleArrayOps(mat.values).forall(((x$6: Double) => x$6.==(1.0)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
        this.test("eye", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.eye(2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).toSeq());
            Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 0.0, 1.0}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
        this.test("rand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = (Random)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Random.class));
            Mockito.when((Object)BoxesRunTime.boxToDouble((double)rng.nextDouble())).thenReturn((Object)BoxesRunTime.boxToDouble((double)1.0), ScalaRunTime$.MODULE$.toObjectArray((Object)new double[]{2.0, 3.0, 4.0}));
            DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.rand(2, 2, rng);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).toSeq());
            Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0, 4.0}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
        this.test("randn", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = (Random)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Random.class));
            Mockito.when((Object)BoxesRunTime.boxToDouble((double)rng.nextGaussian())).thenReturn((Object)BoxesRunTime.boxToDouble((double)1.0), ScalaRunTime$.MODULE$.toObjectArray((Object)new double[]{2.0, 3.0, 4.0}));
            DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.randn(2, 2, rng);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).toSeq());
            Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0, 4.0}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
        this.test("diag", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.diag(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0})));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).toSeq());
            Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 0.0, 2.0}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
        this.test("sprand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = (Random)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Random.class));
            Mockito.when((Object)BoxesRunTime.boxToInteger((int)rng.nextInt(4))).thenReturn((Object)BoxesRunTime.boxToInteger((int)0), ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{1, 1, 3, 2, 2, 0, 1, 3, 0}));
            Mockito.when((Object)BoxesRunTime.boxToDouble((double)rng.nextDouble())).thenReturn((Object)BoxesRunTime.boxToDouble((double)1.0), ScalaRunTime$.MODULE$.toObjectArray((Object)new double[]{2.0, 3.0, 4.0, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}));
            SparseMatrix mat = SparseMatrix$.MODULE$.sprand(4, 4, 0.25, rng);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mat.rowIndices())).toSeq());
            Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 2, 1}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).toSeq());
            Seq $org_scalatest_assert_macro_right4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0, 4.0}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
            SparseMatrix mat2 = SparseMatrix$.MODULE$.sprand(2, 3, 1.0, rng);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mat2.rowIndices())).toSeq());
            Seq $org_scalatest_assert_macro_right5 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0, 1, 0, 1}));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 476));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mat2.colPtrs())).toSeq());
            Seq $org_scalatest_assert_macro_right6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 6}));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466));
        this.test("sprandn", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = (Random)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Random.class));
            Mockito.when((Object)BoxesRunTime.boxToInteger((int)rng.nextInt(4))).thenReturn((Object)BoxesRunTime.boxToInteger((int)0), ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{1, 1, 3, 2, 2, 0, 1, 3, 0}));
            Mockito.when((Object)BoxesRunTime.boxToDouble((double)rng.nextGaussian())).thenReturn((Object)BoxesRunTime.boxToDouble((double)1.0), ScalaRunTime$.MODULE$.toObjectArray((Object)new double[]{2.0, 3.0, 4.0}));
            SparseMatrix mat = SparseMatrix$.MODULE$.sprandn(4, 4, 0.25, rng);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mat.rowIndices())).toSeq());
            Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 2, 1}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).toSeq());
            Seq $org_scalatest_assert_macro_right4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0, 4.0}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
        this.test("MatrixUDT", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseMatrix dm1 = new DenseMatrix(2, 2, new double[]{0.9, 1.2, 2.3, 9.8});
            DenseMatrix dm2 = new DenseMatrix(3, 2, new double[]{0.0, 1.21, 2.3, 9.8, 9.0, 0.0});
            DenseMatrix dm3 = new DenseMatrix(0, 0, (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double()));
            SparseMatrix sm1 = dm1.toSparse();
            SparseMatrix sm2 = dm2.toSparse();
            SparseMatrix sm3 = dm3.toSparse();
            MatrixUDT mUDT = new MatrixUDT();
            ((IterableLike)new .colon.colon((Object)dm1, (List)new .colon.colon((Object)dm2, (List)new .colon.colon((Object)dm3, (List)new .colon.colon((Object)sm1, (List)new .colon.colon((Object)sm2, (List)new .colon.colon((Object)sm3, (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable & scala.Serializable)mat -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mat.toArray());
                double[] $org_scalatest_assert_macro_right = mUDT.deserialize((Object)mUDT.serialize(mat)).toArray();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500));
            });
            String $org_scalatest_assert_macro_left = mUDT.typeName();
            String $org_scalatest_assert_macro_right = "matrix";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
            String $org_scalatest_assert_macro_left2 = mUDT.simpleString();
            String $org_scalatest_assert_macro_right2 = "matrix";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
        this.test("toString", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Matrix empty = Matrices$.MODULE$.ones(0, 0);
            empty.toString(0, 0);
            Matrix mat = Matrices$.MODULE$.rand(5, 10, new Random());
            mat.toString(-1, -5);
            mat.toString(0, 0);
            mat.toString(Integer.MIN_VALUE, Integer.MIN_VALUE);
            mat.toString(Integer.MAX_VALUE, Integer.MAX_VALUE);
            String[] lines = new StringOps(Predef$.MODULE$.augmentString(mat.toString(6, 50))).split('\n');
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])lines);
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_right2 = $org_scalatest_assert_macro_left2.value() ? Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MatricesSuite.$anonfun$new$48(x$7))), "scala.Predef.refArrayOps[String](lines).forall(((x$7: String) => scala.Predef.augmentString(x$7).size.<=(50)))", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
            lines = new StringOps(Predef$.MODULE$.augmentString(mat.toString(5, 100))).split('\n');
            Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])lines);
            int $org_scalatest_assert_macro_right3 = 5;
            Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left3).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_right4 = $org_scalatest_assert_macro_left4.value() ? Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MatricesSuite.$anonfun$new$50(x$8))), "scala.Predef.refArrayOps[String](lines).forall(((x$8: String) => scala.Predef.augmentString(x$8).size.<=(100)))", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
        this.test("numNonzeros and numActives", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Matrix dm1 = Matrices$.MODULE$.dense(3, 2, new double[]{0.0, 0.0, -1.0, 1.0, 0.0, 1.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)dm1.numNonzeros()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 524));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)dm1.numActives()));
            int $org_scalatest_assert_macro_right2 = 6;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
            Matrix sm1 = Matrices$.MODULE$.sparse(3, 2, new int[]{0, 2, 3}, new int[]{0, 2, 1}, new double[]{0.0, -1.2, 0.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sm1.numNonzeros()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sm1.numActives()));
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
        this.test("fromBreeze with sparse matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CSCMatrix.mcD.sp bm1 = new CSCMatrix.mcD.sp(new double[]{1.0, 1.0, 1.0}, 3, 3, new int[]{0, 1, 2, 3}, new int[]{0, 1, 2}, Zero$.MODULE$.DoubleZero());
            CSCMatrix.mcD.sp bm2 = new CSCMatrix.mcD.sp(new double[]{1.0, 2.0, 2.0, 4.0}, 3, 3, new int[]{0, 0, 2, 4}, new int[]{1, 2, 1, 2}, Zero$.MODULE$.DoubleZero());
            breeze.linalg.Matrix sum = (breeze.linalg.Matrix)bm1.$plus((Object)bm2, (UFunc.UImpl2)HasOps$.MODULE$.op_M_DM_Double_OpAdd());
            return Matrices$.MODULE$.fromBreeze(sum);
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
        this.test("Test FromBreeze when Breeze.CSCMatrix.rowIndices has trailing zeros. - SPARK-20687", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            breeze.linalg.Matrix mat1Brz = Matrices$.MODULE$.sparse(2, 3, new int[]{0, 2, 2, 2}, new int[]{0, 1}, new double[]{2.0, 2.0}).asBreeze();
            breeze.linalg.Matrix mat2Brz = Matrices$.MODULE$.sparse(2, 3, new int[]{0, 2, 4, 6}, new int[]{0, 0, 0, 1, 1, 1}, new double[]{2.0, 1.0E-15, 1.0E-15, 2.0, 1.0E-15, 1.0E-15}).asBreeze();
            breeze.linalg.Matrix t1Brz = (breeze.linalg.Matrix)mat1Brz.$minus((Object)mat2Brz, (UFunc.UImpl2)HasOps$.MODULE$.op_M_DM_Double_OpSub());
            breeze.linalg.Matrix t2Brz = (breeze.linalg.Matrix)mat2Brz.$minus((Object)mat1Brz, (UFunc.UImpl2)HasOps$.MODULE$.op_M_DM_Double_OpSub());
            Matrix t1 = Matrices$.MODULE$.fromBreeze(t1Brz);
            Matrix t2 = Matrices$.MODULE$.fromBreeze(t2Brz);
            double $org_scalatest_assert_macro_left = BoxesRunTime.unboxToDouble((Object)((breeze.linalg.Matrix)t1.asBreeze().$minus((Object)t1Brz, (UFunc.UImpl2)HasOps$.MODULE$.op_M_DM_Double_OpSub())).iterator().map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)package$.MODULE$.abs(x._2$mcD$sp()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double $org_scalatest_assert_macro_right = 1.0E-15;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 559));
            double $org_scalatest_assert_macro_left2 = BoxesRunTime.unboxToDouble((Object)((breeze.linalg.Matrix)t2.asBreeze().$minus((Object)t2Brz, (UFunc.UImpl2)HasOps$.MODULE$.op_M_DM_Double_OpSub())).iterator().map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)package$.MODULE$.abs(x._2$mcD$sp()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double $org_scalatest_assert_macro_right2 = 1.0E-15;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543));
        this.test("row/col iterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DenseMatrix dm = new DenseMatrix(3, 2, new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 0.0});
            SparseMatrix sm = dm.toSparse();
            Seq rows = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), (List)Nil$.MODULE$)));
            Seq cols = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 0.0})), (List)Nil$.MODULE$));
            ((IterableLike)new .colon.colon((Object)dm, (List)new .colon.colon((Object)sm, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)m -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(m.rowIter().toSeq());
                Seq $org_scalatest_assert_macro_right = rows;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(m.colIter().toSeq());
                Seq $org_scalatest_assert_macro_right2 = cols;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 570));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(m.transpose().rowIter().toSeq());
                Seq $org_scalatest_assert_macro_right3 = cols;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(m.transpose().colIter().toSeq());
                Seq $org_scalatest_assert_macro_right4 = rows;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
            });
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 563));
        this.test("conversions between new local linalg and mllib linalg", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparseMatrix sm;
            DenseMatrix dm = new DenseMatrix(3, 2, new double[]{0.0, 0.0, 1.0, 0.0, 2.0, 3.5});
            SparseMatrix sm0 = sm = dm.toSparse();
            DenseMatrix dm0 = dm;
            org.apache.spark.ml.linalg.SparseMatrix newSM = sm.asML();
            org.apache.spark.ml.linalg.DenseMatrix newDM = dm.asML();
            org.apache.spark.ml.linalg.Matrix newSM0 = sm0.asML();
            org.apache.spark.ml.linalg.Matrix newDM0 = dm0.asML();
            org.apache.spark.ml.linalg.Matrix $org_scalatest_assert_macro_left = newSM0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.ml.linalg.SparseMatrix", $org_scalatest_assert_macro_left instanceof org.apache.spark.ml.linalg.SparseMatrix, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 592));
            org.apache.spark.ml.linalg.Matrix $org_scalatest_assert_macro_left2 = newDM0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.ml.linalg.DenseMatrix", $org_scalatest_assert_macro_left2 instanceof org.apache.spark.ml.linalg.DenseMatrix, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
            this.compare$1((Matrix)sm, (org.apache.spark.ml.linalg.Matrix)newSM);
            this.compare$1((Matrix)dm, (org.apache.spark.ml.linalg.Matrix)newDM);
            this.compare$1((Matrix)sm0, newSM0);
            this.compare$1((Matrix)dm0, newDM0);
            SparseMatrix oldSM = SparseMatrix$.MODULE$.fromML(newSM);
            DenseMatrix oldDM = DenseMatrix$.MODULE$.fromML(newDM);
            Matrix oldSM0 = Matrices$.MODULE$.fromML(newSM0);
            Matrix oldDM0 = Matrices$.MODULE$.fromML(newDM0);
            Matrix $org_scalatest_assert_macro_left3 = oldSM0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.mllib.linalg.SparseMatrix", $org_scalatest_assert_macro_left3 instanceof SparseMatrix, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
            Matrix $org_scalatest_assert_macro_left4 = oldDM0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.mllib.linalg.DenseMatrix", $org_scalatest_assert_macro_left4 instanceof DenseMatrix, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 604));
            this.compare$1((Matrix)oldSM, (org.apache.spark.ml.linalg.Matrix)newSM);
            this.compare$1((Matrix)oldDM, (org.apache.spark.ml.linalg.Matrix)newDM);
            this.compare$1(oldSM0, newSM0);
            this.compare$1(oldDM0, newDM0);
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
        this.test("implicit conversions between new local linalg and mllib linalg", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparseMatrix sm;
            DenseMatrix dm = new DenseMatrix(3, 2, new double[]{0.0, 0.0, 1.0, 0.0, 2.0, 3.5});
            SparseMatrix sm0 = sm = dm.toSparse();
            DenseMatrix dm0 = dm;
            org.apache.spark.ml.linalg.SparseMatrix newSM = sm.asML();
            org.apache.spark.ml.linalg.DenseMatrix newDM = dm.asML();
            org.apache.spark.ml.linalg.Matrix newSM0 = sm0.asML();
            org.apache.spark.ml.linalg.Matrix newDM0 = dm0.asML();
            this.compare$2(MatricesSuite.mllibMatrixToTriple$1((Matrix)dm0), MatricesSuite.mllibMatrixToTriple$1(MatrixImplicits$.MODULE$.mlMatrixToMLlibMatrix(newDM0)));
            this.compare$2(MatricesSuite.mllibMatrixToTriple$1((Matrix)sm0), MatricesSuite.mllibMatrixToTriple$1(MatrixImplicits$.MODULE$.mlMatrixToMLlibMatrix(newSM0)));
            this.compare$2(MatricesSuite.mllibDenseMatrixToTriple$1(dm), MatricesSuite.mllibDenseMatrixToTriple$1(MatrixImplicits$.MODULE$.mlDenseMatrixToMLlibDenseMatrix(newDM)));
            this.compare$2(MatricesSuite.mllibSparseMatrixToTriple$1(sm), MatricesSuite.mllibSparseMatrixToTriple$1(MatrixImplicits$.MODULE$.mlSparseMatrixToMLlibSparseMatrix(newSM)));
            this.compare$2(MatricesSuite.mlMatrixToTriple$1(MatrixImplicits$.MODULE$.mllibMatrixToMLMatrix((Matrix)dm0)), MatricesSuite.mlMatrixToTriple$1((org.apache.spark.ml.linalg.Matrix)newDM));
            this.compare$2(MatricesSuite.mlMatrixToTriple$1(MatrixImplicits$.MODULE$.mllibMatrixToMLMatrix((Matrix)sm0)), MatricesSuite.mlMatrixToTriple$1(newSM0));
            this.compare$2(MatricesSuite.mlDenseMatrixToTriple$1(MatrixImplicits$.MODULE$.mllibDenseMatrixToMLDenseMatrix(dm)), MatricesSuite.mlDenseMatrixToTriple$1(newDM));
            this.compare$2(MatricesSuite.mlSparseMatrixToTriple$1(MatrixImplicits$.MODULE$.mllibSparseMatrixToMLSparseMatrix(sm)), MatricesSuite.mlSparseMatrixToTriple$1(newSM));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 611));
    }
}

