/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.mllib.util.LocalClusterSparkContext;
import org.apache.spark.rdd.RDD;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001U2AAB\u0004\u0001)!)q\u0004\u0001C\u0001A!I1\u0005\u0001a\u0001\u0002\u0004%\t\u0001\n\u0005\nQ\u0001\u0001\r\u00111A\u0005\u0002%B\u0011B\r\u0001A\u0002\u0003\u0005\u000b\u0015B\u0013\t\u000bM\u0002A\u0011\t\u001b\u0003+I{w/T1ue&D8\t\\;ti\u0016\u00148+^5uK*\u0011\u0001\"C\u0001\fI&\u001cHO]5ckR,GM\u0003\u0002\u000b\u0017\u00051A.\u001b8bY\u001eT!\u0001D\u0007\u0002\u000b5dG.\u001b2\u000b\u00059y\u0011!B:qCJ\\'B\u0001\t\u0012\u0003\u0019\t\u0007/Y2iK*\t!#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001+e\u0001\"AF\f\u000e\u00035I!\u0001G\u0007\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tQR$D\u0001\u001c\u0015\ta2\"\u0001\u0003vi&d\u0017B\u0001\u0010\u001c\u0005aaunY1m\u00072,8\u000f^3s'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"A\t\u0001\u000e\u0003\u001d\t1!\\1u+\u0005)\u0003C\u0001\u0012'\u0013\t9sAA\u0005S_^l\u0015\r\u001e:jq\u00069Q.\u0019;`I\u0015\fHC\u0001\u00161!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;\t\u000fE\u001a\u0011\u0011!a\u0001K\u0005\u0019\u0001\u0010J\u0019\u0002\t5\fG\u000fI\u0001\nE\u00164wN]3BY2$\u0012A\u000b")
public class RowMatrixClusterSuite
extends SparkFunSuite
implements LocalClusterSparkContext {
    private RowMatrix mat;
    private transient SparkContext sc;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$LocalClusterSparkContext$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$LocalClusterSparkContext$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void afterAll() {
        LocalClusterSparkContext.afterAll$(this);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public RowMatrix mat() {
        return this.mat;
    }

    public void mat_$eq(RowMatrix x$1) {
        this.mat = x$1;
    }

    @Override
    public void beforeAll() {
        LocalClusterSparkContext.beforeAll$(this);
        int m = 4;
        int n = 200000;
        RDD qual$1 = this.sc().parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), m), 2, ClassTag$.MODULE$.Int());
        Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(idx, iter) -> RowMatrixClusterSuite.$anonfun$beforeAll$1(n, BoxesRunTime.unboxToInt((Object)idx), iter);
        boolean x$2 = qual$1.mapPartitionsWithIndex$default$2();
        RDD rows = qual$1.mapPartitionsWithIndex((Function2)x$1, x$2, ClassTag$.MODULE$.apply(Vector.class));
        this.mat_$eq(new RowMatrix(rows));
    }

    public static final /* synthetic */ Iterator $anonfun$beforeAll$1(int n$1, int idx, Iterator iter) {
        Random random = new Random(idx);
        return iter.map((Function1 & Serializable & scala.Serializable)i -> Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(n$1, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> random$1.nextDouble(), ClassTag$.MODULE$.Double())));
    }

    public RowMatrixClusterSuite() {
        LocalClusterSparkContext.$init$(this);
        this.test("task size should be small in svd", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            RowMatrix qual$1 = this.mat();
            int x$1 = 1;
            boolean x$2 = true;
            double x$3 = qual$1.computeSVD$default$3();
            SingularValueDecomposition svd2 = qual$1.computeSVD(x$1, x$2, x$3);
        }, new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
        this.test("task size should be small in summarize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MultivariateStatisticalSummary summary = this.mat().computeColumnSummaryStatistics();
        }, new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
    }
}

