/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.operators.HasOps$;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.recommendation.ALS;
import org.apache.spark.mllib.recommendation.ALS$;
import org.apache.spark.mllib.recommendation.ALSSuite$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%t!\u0002\n\u0014\u0011\u0003qb!\u0002\u0011\u0014\u0011\u0003\t\u0003\"B\u0016\u0002\t\u0003a\u0003\"B\u0017\u0002\t\u0003q\u0003\"B+\u0002\t\u00031\u0006b\u0002;\u0002#\u0003%\t!\u001e\u0005\t\u0003\u0003\t\u0011\u0013!C\u0001k\"A\u00111A\u0001\u0012\u0002\u0013\u0005Q\u000fC\u0005\u0002\u0006\u0005\t\t\u0011\"\u0003\u0002\b\u0019)\u0001e\u0005\u0001\u0002\u0016!11&\u0003C\u0001\u0003SAq!!\f\n\t\u0003\ty\u0003\u0003\u0005\u0002Z%\t\n\u0011\"\u0001v\u0011!\tY&CI\u0001\n\u0003)\b\u0002CA/\u0013E\u0005I\u0011A;\t\u0013\u0005}\u0013\"%A\u0005\u0002\u0005\u0005\u0004\"CA3\u0013E\u0005I\u0011AA1\u0011!\t9'CI\u0001\n\u0003)\u0018\u0001C!M'N+\u0018\u000e^3\u000b\u0005Q)\u0012A\u0004:fG>lW.\u001a8eCRLwN\u001c\u0006\u0003-]\tQ!\u001c7mS\nT!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001!\ty\u0012!D\u0001\u0014\u0005!\tEjU*vSR,7cA\u0001#QA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"aI\u0015\n\u0005)\"#\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u0001\u001f\u0003U9WM\\3sCR,'+\u0019;j]\u001e\u001c\u0018i\u001d&bm\u0006$raL\"I\u00152s5\u000bE\u0003$aIjT(\u0003\u00022I\t1A+\u001e9mKN\u00022a\r\u001d;\u001b\u0005!$BA\u001b7\u0003\u0011)H/\u001b7\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002 w%\u0011Ah\u0005\u0002\u0007%\u0006$\u0018N\\4\u0011\u0007\rr\u0004)\u0003\u0002@I\t)\u0011I\u001d:bsB\u00111%Q\u0005\u0003\u0005\u0012\u0012a\u0001R8vE2,\u0007\"\u0002#\u0004\u0001\u0004)\u0015!B;tKJ\u001c\bCA\u0012G\u0013\t9EEA\u0002J]RDQ!S\u0002A\u0002\u0015\u000b\u0001\u0002\u001d:pIV\u001cGo\u001d\u0005\u0006\u0017\u000e\u0001\r!R\u0001\tM\u0016\fG/\u001e:fg\")Qj\u0001a\u0001\u0001\u0006a1/Y7qY&twMU1uK\")qj\u0001a\u0001!\u0006i\u0011.\u001c9mS\u000eLG\u000f\u0015:fMN\u0004\"aI)\n\u0005I##a\u0002\"p_2,\u0017M\u001c\u0005\u0006)\u000e\u0001\r\u0001U\u0001\u0010]\u0016<\u0017\r^5wK^+\u0017n\u001a5ug\u0006yq-\u001a8fe\u0006$XMU1uS:<7\u000f\u0006\u0005XY6tw\u000e]9s!\u0015\u0019\u0003\u0007\u00173e!\rI\u0016M\u000f\b\u00035~s!a\u00170\u000e\u0003qS!!X\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0013B\u00011%\u0003\u001d\u0001\u0018mY6bO\u0016L!AY2\u0003\u0007M+\u0017O\u0003\u0002aIA\u0019QM\u001b!\u000e\u0003\u0019T!a\u001a5\u0002\r1Lg.\u00197h\u0015\u0005I\u0017A\u00022sK\u0016TX-\u0003\u0002lM\nYA)\u001a8tK6\u000bGO]5y\u0011\u0015!E\u00011\u0001F\u0011\u0015IE\u00011\u0001F\u0011\u0015YE\u00011\u0001F\u0011\u0015iE\u00011\u0001A\u0011\u001dyE\u0001%AA\u0002ACq\u0001\u0016\u0003\u0011\u0002\u0003\u0007\u0001\u000bC\u0004t\tA\u0005\t\u0019\u0001)\u0002\u001f9,w-\u0019;jm\u00164\u0015m\u0019;peN\f\u0011dZ3oKJ\fG/\u001a*bi&twm\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\taO\u000b\u0002Qo.\n\u0001\u0010\u0005\u0002z}6\t!P\u0003\u0002|y\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003{\u0012\n!\"\u00198o_R\fG/[8o\u0013\ty(PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011dZ3oKJ\fG/\u001a*bi&twm\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u0005Ir-\u001a8fe\u0006$XMU1uS:<7\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005%\u0001\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=a'\u0001\u0003mC:<\u0017\u0002BA\n\u0003\u001b\u0011aa\u00142kK\u000e$8#B\u0005\u0002\u0018\u0005}\u0001\u0003BA\r\u00037i\u0011aF\u0005\u0004\u0003;9\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0003\u0002\"\u0005\u0015RBAA\u0012\u0015\t)T#\u0003\u0003\u0002(\u0005\r\"!F'MY&\u0014G+Z:u'B\f'o[\"p]R,\u0007\u0010\u001e\u000b\u0003\u0003W\u0001\"aH\u0005\u0002\u000fQ,7\u000f^!M'RQ\u0012\u0011GA\u001c\u0003s\tY$!\u0010\u0002B\u0005\r\u0013qIA%\u0003\u001b\ny%a\u0015\u0002XA\u00191%a\r\n\u0007\u0005UBE\u0001\u0003V]&$\b\"\u0002#\f\u0001\u0004)\u0005\"B%\f\u0001\u0004)\u0005\"B&\f\u0001\u0004)\u0005BBA \u0017\u0001\u0007Q)\u0001\u0006ji\u0016\u0014\u0018\r^5p]NDQ!T\u0006A\u0002\u0001Ca!!\u0012\f\u0001\u0004\u0001\u0015AD7bi\u000eDG\u000b\u001b:fg\"|G\u000e\u001a\u0005\b\u001f.\u0001\n\u00111\u0001Q\u0011!\tYe\u0003I\u0001\u0002\u0004\u0001\u0016a\u00032vY.\u0004&/\u001a3jGRDq\u0001V\u0006\u0011\u0002\u0003\u0007\u0001\u000b\u0003\u0005\u0002R-\u0001\n\u00111\u0001F\u00035qW/\\+tKJ\u0014En\\2lg\"A\u0011QK\u0006\u0011\u0002\u0003\u0007Q)\u0001\tok6\u0004&o\u001c3vGR\u0014En\\2lg\"91o\u0003I\u0001\u0002\u0004\u0001\u0016!\u0005;fgR\fEj\u0015\u0013eK\u001a\fW\u000f\u001c;%o\u0005\tB/Z:u\u00032\u001bF\u0005Z3gCVdG\u000f\n\u001d\u0002#Q,7\u000f^!M'\u0012\"WMZ1vYR$\u0013(\u0001\nuKN$\u0018\tT*%I\u00164\u0017-\u001e7uIE\u0002TCAA2U\t)u/\u0001\nuKN$\u0018\tT*%I\u00164\u0017-\u001e7uIE\n\u0014A\u0005;fgR\fEj\u0015\u0013eK\u001a\fW\u000f\u001c;%cI\u0002")
public class ALSSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static boolean generateRatings$default$7() {
        return ALSSuite$.MODULE$.generateRatings$default$7();
    }

    public static boolean generateRatings$default$6() {
        return ALSSuite$.MODULE$.generateRatings$default$6();
    }

    public static boolean generateRatings$default$5() {
        return ALSSuite$.MODULE$.generateRatings$default$5();
    }

    public static Tuple3<Seq<Rating>, DenseMatrix<Object>, DenseMatrix<Object>> generateRatings(int n, int n2, int n3, double d, boolean bl, boolean bl2, boolean bl3) {
        return ALSSuite$.MODULE$.generateRatings(n, n2, n3, d, bl, bl2, bl3);
    }

    public static Tuple3<java.util.List<Rating>, double[], double[]> generateRatingsAsJava(int n, int n2, int n3, double d, boolean bl, boolean bl2) {
        return ALSSuite$.MODULE$.generateRatingsAsJava(n, n2, n3, d, bl, bl2);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public void testALS(int users, int products, int features, int iterations, double samplingRate, double matchThreshold, boolean implicitPrefs, boolean bulkPredict, boolean negativeWeights, int numUserBlocks, int numProductBlocks, boolean negativeFactors) {
        DenseMatrix predictedRatings;
        DenseMatrix denseMatrix;
        Tuple3<Seq<Rating>, DenseMatrix<Object>, DenseMatrix<Object>> tuple3 = ALSSuite$.MODULE$.generateRatings(users, products, features, samplingRate, implicitPrefs, negativeWeights, negativeFactors);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Seq sampledRatings = (Seq)tuple3._1();
        DenseMatrix trueRatings = (DenseMatrix)tuple3._2();
        DenseMatrix truePrefs = (DenseMatrix)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)sampledRatings, (Object)trueRatings, (Object)truePrefs);
        Seq sampledRatings2 = (Seq)tuple32._1();
        DenseMatrix trueRatings2 = (DenseMatrix)tuple32._2();
        DenseMatrix truePrefs2 = (DenseMatrix)tuple32._3();
        SparkContext qual$1 = this.sc();
        Seq x$1 = sampledRatings2;
        int x$2 = qual$1.parallelize$default$2();
        MatrixFactorizationModel model = new ALS().setUserBlocks(numUserBlocks).setProductBlocks(numProductBlocks).setRank(features).setIterations(iterations).setAlpha(1.0).setImplicitPrefs(implicitPrefs).setLambda(0.01).setSeed(0L).setNonnegative(!negativeFactors).run(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Rating.class)));
        DenseMatrix.mcD.sp predictedU = new DenseMatrix.mcD.sp(users, features, ClassTag$.MODULE$.Double());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.userFeatures().collect())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ALSSuite.$anonfun$testALS$1(check$ifrefutable$1))).foreach(arg_0 -> ALSSuite.$anonfun$testALS$2$adapted(features, (DenseMatrix)predictedU, arg_0));
        DenseMatrix.mcD.sp predictedP = new DenseMatrix.mcD.sp(products, features, ClassTag$.MODULE$.Double());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.productFeatures().collect())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ALSSuite.$anonfun$testALS$4(check$ifrefutable$2))).foreach(arg_0 -> ALSSuite.$anonfun$testALS$5$adapted(features, (DenseMatrix)predictedP, arg_0));
        if (bulkPredict) {
            DenseMatrix.mcD.sp allRatings = new DenseMatrix.mcD.sp(users, products, ClassTag$.MODULE$.Double());
            IndexedSeq usersProducts = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), users).flatMap((Function1 & Serializable & scala.Serializable)u -> ALSSuite.$anonfun$testALS$7(products, BoxesRunTime.unboxToInt((Object)u)), IndexedSeq$.MODULE$.canBuildFrom());
            SparkContext qual$2 = this.sc();
            IndexedSeq x$3 = usersProducts;
            int x$4 = qual$2.parallelize$default$2();
            RDD userProductsRDD = qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.apply(Tuple2.class));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.predict(userProductsRDD).collect())).foreach(arg_0 -> ALSSuite.$anonfun$testALS$9$adapted((DenseMatrix)allRatings, arg_0));
            denseMatrix = allRatings;
        } else {
            denseMatrix = predictedRatings = (DenseMatrix)predictedU.$times(predictedP.t(HasOps$.MODULE$.canTranspose_DM()), (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD());
        }
        if (!implicitPrefs) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), users).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> ALSSuite.$anonfun$testALS$10(this, products, predictedRatings, trueRatings2, matchThreshold, (DenseMatrix)predictedU, (DenseMatrix)predictedP, arg_0)));
            return;
        }
        DoubleRef sqErr = DoubleRef.create((double)0.0);
        DoubleRef denom = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), users).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)u -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), products).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)p -> {
            double prediction = predictedRatings.apply$mcD$sp(u, p);
            double truePref = truePrefs2.apply$mcD$sp(u, p);
            double confidence = 1.0 + package$.MODULE$.abs(trueRatings2.apply$mcD$sp(u, p));
            double err = confidence * (truePref - prediction) * (truePref - prediction);
            sqErr$1.elem += err;
            denom$1.elem += confidence;
        }));
        double rmse = package$.MODULE$.sqrt(sqErr.elem / denom.elem);
        if (rmse > matchThreshold) {
            throw this.fail(new StringOps(Predef$.MODULE$.augmentString("Model failed to predict RMSE: %f\ncorr: %s\npred: %s\nU: %s\n P: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)rmse), truePrefs2, predictedRatings, predictedU, predictedP})), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        }
    }

    public boolean testALS$default$7() {
        return false;
    }

    public boolean testALS$default$8() {
        return false;
    }

    public boolean testALS$default$9() {
        return false;
    }

    public int testALS$default$10() {
        return -1;
    }

    public int testALS$default$11() {
        return -1;
    }

    public boolean testALS$default$12() {
        return true;
    }

    private final void testImplicits$lzycompute$1() {
        ALSSuite aLSSuite = this;
        synchronized (aLSSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$18(int u, int p) {
        return new Tuple2.mcII.sp(u - 25, p - 25);
    }

    public static final /* synthetic */ boolean $anonfun$testALS$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$testALS$2(int features$1, DenseMatrix predictedU$1, Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 != null) {
            int u = tuple2._1$mcI$sp();
            double[] vec = (double[])tuple2._2();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), features$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> predictedU$1.update$mcD$sp(u, i, vec[i]));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$testALS$4(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$testALS$5(int features$1, DenseMatrix predictedP$1, Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 != null) {
            int p = tuple2._1$mcI$sp();
            double[] vec = (double[])tuple2._2();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), features$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> predictedP$1.update$mcD$sp(p, i, vec[i]));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Tuple2 $anonfun$testALS$8(int u$3, int p) {
        return new Tuple2.mcII.sp(u$3, p);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$testALS$7(int products$2, int u) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), products$2).map((Function1 & Serializable & scala.Serializable)p -> ALSSuite.$anonfun$testALS$8(u, BoxesRunTime.unboxToInt((Object)p)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$testALS$10(ALSSuite $this, int products$2, DenseMatrix predictedRatings$1, DenseMatrix trueRatings$2, double matchThreshold$1, DenseMatrix predictedU$1, DenseMatrix predictedP$1, int u) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), products$2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)p -> {
            double correct;
            double prediction = predictedRatings$1.apply$mcD$sp(u, p);
            if (package$.MODULE$.abs(prediction - (correct = trueRatings$2.apply$mcD$sp(u, p))) > matchThreshold$1) {
                throw $this.fail(new StringOps(Predef$.MODULE$.augmentString("Model failed to predict (%d, %d): %f vs %f\ncorr: %s\npred: %s\nU: %s\n P: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)u), BoxesRunTime.boxToInteger((int)p), BoxesRunTime.boxToDouble((double)correct), BoxesRunTime.boxToDouble((double)prediction), trueRatings$2, predictedRatings$1, predictedU$1, predictedP$1})), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            }
        });
    }

    public ALSSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("rank-1 matrices", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testALS(50, 100, 1, 15, 0.7, 0.3, this.testALS$default$7(), this.testALS$default$8(), this.testALS$default$9(), this.testALS$default$10(), this.testALS$default$11(), this.testALS$default$12()), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("rank-1 matrices bulk", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testALS(50, 100, 1, 15, 0.7, 0.3, false, true, this.testALS$default$9(), this.testALS$default$10(), this.testALS$default$11(), this.testALS$default$12()), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("rank-2 matrices", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testALS(100, 200, 2, 15, 0.7, 0.3, this.testALS$default$7(), this.testALS$default$8(), this.testALS$default$9(), this.testALS$default$10(), this.testALS$default$11(), this.testALS$default$12()), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("rank-2 matrices bulk", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testALS(100, 200, 2, 15, 0.7, 0.3, false, true, this.testALS$default$9(), this.testALS$default$10(), this.testALS$default$11(), this.testALS$default$12()), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("rank-1 matrices implicit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testALS(80, 160, 1, 15, 0.7, 0.4, true, this.testALS$default$8(), this.testALS$default$9(), this.testALS$default$10(), this.testALS$default$11(), this.testALS$default$12()), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("rank-1 matrices implicit bulk", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testALS(80, 160, 1, 15, 0.7, 0.4, true, true, this.testALS$default$9(), this.testALS$default$10(), this.testALS$default$11(), this.testALS$default$12()), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("rank-2 matrices implicit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testALS(100, 200, 2, 15, 0.7, 0.4, true, this.testALS$default$8(), this.testALS$default$9(), this.testALS$default$10(), this.testALS$default$11(), this.testALS$default$12()), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("rank-2 matrices implicit bulk", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testALS(100, 200, 2, 15, 0.7, 0.4, true, true, this.testALS$default$9(), this.testALS$default$10(), this.testALS$default$11(), this.testALS$default$12()), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("rank-2 matrices implicit negative", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testALS(100, 200, 2, 15, 0.7, 0.4, true, false, true, this.testALS$default$10(), this.testALS$default$11(), this.testALS$default$12()), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("rank-2 matrices with different user and product blocks", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$1 = 100;
            int x$2 = 200;
            int x$3 = 2;
            int x$4 = 15;
            double x$5 = 0.7;
            double x$6 = 0.4;
            int x$7 = 4;
            int x$8 = 2;
            boolean x$9 = this.testALS$default$7();
            boolean x$10 = this.testALS$default$8();
            boolean x$11 = this.testALS$default$9();
            boolean x$12 = this.testALS$default$12();
            this.testALS(x$1, x$2, x$3, x$4, x$5, x$6, x$9, x$10, x$11, x$7, x$8, x$12);
        }, new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        this.test("pseudorandomness", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD ratings = this.sc().parallelize((Seq)ALSSuite$.MODULE$.generateRatings(10, 20, 5, 0.5, false, false, ALSSuite$.MODULE$.generateRatings$default$7())._1(), 2, ClassTag$.MODULE$.apply(Rating.class));
            MatrixFactorizationModel model11 = ALS$.MODULE$.train(ratings, 5, 1, 1.0, 2, 1L);
            MatrixFactorizationModel model12 = ALS$.MODULE$.train(ratings, 5, 1, 1.0, 2, 1L);
            List u11 = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])RDD$.MODULE$.rddToPairRDDFunctions(model11.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).values().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$3)).toList(), ClassTag$.MODULE$.Double()).collect())).toList();
            List u12 = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])RDD$.MODULE$.rddToPairRDDFunctions(model12.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).values().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$4)).toList(), ClassTag$.MODULE$.Double()).collect())).toList();
            MatrixFactorizationModel model2 = ALS$.MODULE$.train(ratings, 5, 1, 1.0, 2, 2L);
            List u2 = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])RDD$.MODULE$.rddToPairRDDFunctions(model2.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).values().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$5)).toList(), ClassTag$.MODULE$.Double()).collect())).toList();
            List $org_scalatest_assert_macro_left = u11;
            List $org_scalatest_assert_macro_right = u12;
            List list = $org_scalatest_assert_macro_left;
            List list2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(list != null ? !list.equals(list2) : list2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            List $org_scalatest_assert_macro_left2 = u11;
            List $org_scalatest_assert_macro_right2 = u2;
            List list3 = $org_scalatest_assert_macro_left2;
            List list4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", (Object)$org_scalatest_assert_macro_right2, list3 == null ? list4 != null : !list3.equals(list4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        }, new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("Storage Level for RDDs in model", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD ratings = this.sc().parallelize((Seq)ALSSuite$.MODULE$.generateRatings(10, 20, 5, 0.5, false, false, ALSSuite$.MODULE$.generateRatings$default$7())._1(), 2, ClassTag$.MODULE$.apply(Rating.class));
            StorageLevel storageLevel = StorageLevel$.MODULE$.MEMORY_ONLY();
            MatrixFactorizationModel model = new ALS().setRank(5).setIterations(1).setLambda(1.0).setBlocks(2).setSeed(1L).setFinalRDDStorageLevel(storageLevel).run(ratings);
            StorageLevel $org_scalatest_assert_macro_left = model.productFeatures().getStorageLevel();
            StorageLevel $org_scalatest_assert_macro_right = storageLevel;
            StorageLevel storageLevel2 = $org_scalatest_assert_macro_left;
            StorageLevel storageLevel3 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(storageLevel2 != null ? !storageLevel2.equals(storageLevel3) : storageLevel3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            StorageLevel $org_scalatest_assert_macro_left2 = model.userFeatures().getStorageLevel();
            StorageLevel $org_scalatest_assert_macro_right2 = storageLevel;
            StorageLevel storageLevel4 = $org_scalatest_assert_macro_left2;
            StorageLevel storageLevel5 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(storageLevel4 != null ? !storageLevel4.equals(storageLevel5) : storageLevel5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            storageLevel = StorageLevel$.MODULE$.DISK_ONLY();
            model = new ALS().setRank(5).setIterations(1).setLambda(1.0).setBlocks(2).setSeed(1L).setFinalRDDStorageLevel(storageLevel).run(ratings);
            StorageLevel $org_scalatest_assert_macro_left3 = model.productFeatures().getStorageLevel();
            StorageLevel $org_scalatest_assert_macro_right3 = storageLevel;
            StorageLevel storageLevel6 = $org_scalatest_assert_macro_left3;
            StorageLevel storageLevel7 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(storageLevel6 != null ? !storageLevel6.equals(storageLevel7) : storageLevel7 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            StorageLevel $org_scalatest_assert_macro_left4 = model.userFeatures().getStorageLevel();
            StorageLevel $org_scalatest_assert_macro_right4 = storageLevel;
            StorageLevel storageLevel8 = $org_scalatest_assert_macro_left4;
            StorageLevel storageLevel9 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(storageLevel8 != null ? !storageLevel8.equals(storageLevel9) : storageLevel9 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        }, new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("negative ids", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple3<Seq<Rating>, DenseMatrix<Object>, DenseMatrix<Object>> data = ALSSuite$.MODULE$.generateRatings(50, 50, 2, 0.7, false, false, ALSSuite$.MODULE$.generateRatings$default$7());
            SparkContext qual$1 = this.sc();
            Seq x$13 = (Seq)((TraversableLike)data._1()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Rating rating = x0$1;
                if (rating != null) {
                    int u = rating.user();
                    int p = rating.product();
                    double r = rating.rating();
                    return new Rating(u - 25, p - 25, r);
                }
                throw new MatchError((Object)rating);
            }, Seq$.MODULE$.canBuildFrom());
            int x$14 = qual$1.parallelize$default$2();
            RDD ratings = qual$1.parallelize(x$13, x$14, ClassTag$.MODULE$.apply(Rating.class));
            DenseMatrix correct = (DenseMatrix)data._2();
            MatrixFactorizationModel model = ALS$.MODULE$.train(ratings, 5, 15);
            Tuple2[] pairs = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(Array$.MODULE$.tabulate(50, 50, (Function2 & Serializable & scala.Serializable)(u, p) -> ALSSuite.$anonfun$new$18(BoxesRunTime.unboxToInt((Object)u), BoxesRunTime.unboxToInt((Object)p)), ClassTag$.MODULE$.apply(Tuple2.class)))).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(Tuple2.class));
            SparkContext qual$2 = this.sc();
            WrappedArray x$15 = Predef$.MODULE$.wrapRefArray((Object[])pairs);
            int x$16 = qual$2.parallelize$default$2();
            Rating[] ans = (Rating[])model.predict(qual$2.parallelize((Seq)x$15, x$16, ClassTag$.MODULE$.apply(Tuple2.class))).collect();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ans)).foreach((Function1 & Serializable & scala.Serializable)r -> {
                int u = r.user() + 25;
                int p = r.product() + 25;
                double v = r.rating();
                double error = v - correct.apply$mcD$sp(u, p);
                double $org_scalatest_assert_macro_left = package$.MODULE$.abs(error);
                double $org_scalatest_assert_macro_right = 0.4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            });
        }, new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("NNALS, rank 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testALS(100, 200, 2, 15, 0.7, 0.4, false, false, false, -1, -1, false), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("SPARK-18268: ALS with empty RDD should fail with better message", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkContext qual$3 = this.sc();
            WrappedArray x$17 = Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Rating.class)));
            int x$18 = qual$3.parallelize$default$2();
            RDD ratings = qual$3.parallelize((Seq)x$17, x$18, ClassTag$.MODULE$.apply(Rating.class));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> new ALS().run(ratings), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        }, new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
    }

    public static final /* synthetic */ Object $anonfun$testALS$2$adapted(int features$1, DenseMatrix predictedU$1, Tuple2 x$7) {
        ALSSuite.$anonfun$testALS$2(features$1, predictedU$1, x$7);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testALS$5$adapted(int features$1, DenseMatrix predictedP$1, Tuple2 x$8) {
        ALSSuite.$anonfun$testALS$5(features$1, predictedP$1, x$8);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testALS$9$adapted(DenseMatrix allRatings$1, Rating elem) {
        allRatings$1.update$mcD$sp(elem.user(), elem.product(), elem.rating());
        return BoxedUnit.UNIT;
    }
}

