/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import com.google.common.io.Files;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.mllib.util.MLUtilsSuite$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001i1AAA\u0002\u0001\u001d!)q\u0003\u0001C\u00011\taQ\nT+uS2\u001c8+^5uK*\u0011A!B\u0001\u0005kRLGN\u0003\u0002\u0007\u000f\u0005)Q\u000e\u001c7jE*\u0011\u0001\"C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0015-\ta!\u00199bG\",'\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001y1\u0003\u0005\u0002\u0011#5\tq!\u0003\u0002\u0013\u000f\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"\u0001F\u000b\u000e\u0003\rI!AF\u0002\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"\u0012!\u0007\t\u0003)\u0001\u0001")
public class MLUtilsSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        MLUtilsSuite mLUtilsSuite = this;
        synchronized (mLUtilsSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ double $anonfun$new$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double a = tuple2._1$mcD$sp();
            double b = tuple2._2$mcD$sp();
            return (a - b) * (a - b);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final double squaredDistance$1(Vector v1, Vector v2) {
        return BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(v1.toArray())).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(v2.toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)MLUtilsSuite.$anonfun$new$4(x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final /* synthetic */ Object $anonfun$new$5(double[] a$1, int n$1, Vector v1$1, double norm1$1, double precision$1, int m) {
        int[] indices = (int[])RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), m).toArray(ClassTag$.MODULE$.Int());
        double[] values = (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> a$1[i], Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Vector v2 = Vectors$.MODULE$.sparse(n$1, indices, values);
        double norm2 = Vectors$.MODULE$.norm(v2, 2.0);
        Vector v3 = Vectors$.MODULE$.sparse(n$1, indices, (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> a$1[i] + 0.5, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        double norm3 = Vectors$.MODULE$.norm(v3, 2.0);
        double squaredDist = MLUtilsSuite.squaredDistance$1(v1$1, v2);
        double fastSquaredDist1 = MLUtils$.MODULE$.fastSquaredDistance(v1$1, norm1$1, v2, norm2, precision$1);
        double $org_scalatest_assert_macro_left = fastSquaredDist1 - squaredDist;
        double $org_scalatest_assert_macro_right = precision$1 * squaredDist;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(16).append("failed with m = ").append(m).toString(), Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        double fastSquaredDist2 = MLUtils$.MODULE$.fastSquaredDistance(v1$1, norm1$1, Vectors$.MODULE$.dense(v2.toArray()), norm2, precision$1);
        double $org_scalatest_assert_macro_left2 = fastSquaredDist2 - squaredDist;
        double $org_scalatest_assert_macro_right2 = precision$1 * squaredDist;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(16).append("failed with m = ").append(m).toString(), Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        double squaredDist2 = MLUtilsSuite.squaredDistance$1(v2, v3);
        double fastSquaredDist3 = MLUtils$.MODULE$.fastSquaredDistance(v2, norm2, v3, norm3, precision$1);
        double $org_scalatest_assert_macro_left3 = fastSquaredDist3 - squaredDist2;
        double $org_scalatest_assert_macro_right3 = precision$1 * squaredDist2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 <= $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder(16).append("failed with m = ").append(m).toString(), Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        if (m > 10) {
            Vector v4 = Vectors$.MODULE$.sparse(n$1, (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).slice(0, m - 10), (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> a$1[i] + 0.5, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).slice(0, m - 10));
            double norm4 = Vectors$.MODULE$.norm(v4, 2.0);
            double squaredDist3 = MLUtilsSuite.squaredDistance$1(v2, v4);
            double fastSquaredDist = MLUtils$.MODULE$.fastSquaredDistance(v2, norm2, v4, norm4, precision$1);
            double $org_scalatest_assert_macro_left4 = fastSquaredDist - squaredDist3;
            double $org_scalatest_assert_macro_right4 = precision$1 * squaredDist3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 <= $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)new StringBuilder(16).append("failed with m = ").append(m).toString(), Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$16(File x$2) {
        return x$2.getName().startsWith("part-");
    }

    public static final /* synthetic */ Assertion $anonfun$new$25(MLUtilsSuite $this, RDD data$1, int folds$1, int[] collectedData$1, int seed) {
        Tuple2[] foldedRdds = MLUtils$.MODULE$.kFold(data$1, folds$1, seed, ClassTag$.MODULE$.Int());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)foldedRdds.length));
        int $org_scalatest_assert_macro_right = folds$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])foldedRdds)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                float validationSize;
                RDD training = (RDD)tuple2._1();
                RDD validation = (RDD)tuple2._2();
                int[] result = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])validation.union(training).collect())).sorted((Ordering)Ordering.Int$.MODULE$);
                float $org_scalatest_assert_macro_left = validationSize = (float)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])validation.collect())).size();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (float)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"empty validation data", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
                float p = 1.0f / (float)folds$1;
                double range = (double)3 * scala.math.package$.MODULE$.sqrt((double)((float)100 * p * (1.0f - p)));
                float expected = (float)100 * p;
                double lowerBound = (double)expected - range;
                double upperBound = (double)expected + range;
                float $org_scalatest_assert_macro_left2 = validationSize;
                double $org_scalatest_assert_macro_right2 = lowerBound;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), (double)$org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(43).append("Validation data (").append(validationSize).append(") smaller than expected (").append(lowerBound).append(")").toString(), Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
                float $org_scalatest_assert_macro_left3 = validationSize;
                double $org_scalatest_assert_macro_right3 = upperBound;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), (double)$org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder(42).append("Validation data (").append(validationSize).append(") larger than expected (").append(upperBound).append(")").toString(), Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
                int $org_scalatest_assert_macro_left4 = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])training.collect())).size();
                int $org_scalatest_assert_macro_right4 = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"empty training data", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(result);
                int[] $org_scalatest_assert_macro_right5 = collectedData$1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"Each training+validation set combined should contain all of the data.", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            }
            throw new MatchError((Object)tuple2);
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])((RDD)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])foldedRdds)).map((Function1 & Serializable & scala.Serializable)x$5 -> (RDD)x$5._2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RDD.class))))).reduce((Function2 & Serializable & scala.Serializable)(x, y) -> x.union(y))).collect())).sorted((Ordering)Ordering.Int$.MODULE$));
        int[] $org_scalatest_assert_macro_right2 = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])data$1.collect())).sorted((Ordering)Ordering.Int$.MODULE$);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$45(int x) {
        return new Tuple2.mcII.sp(x, x <= 50 ? 0 : 1);
    }

    public MLUtilsSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("epsilon computation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double $org_scalatest_assert_macro_left = 1.0 + MLUtils$.MODULE$.EPSILON();
            double $org_scalatest_assert_macro_right = 1.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(23).append("EPSILON is too small: ").append(MLUtils$.MODULE$.EPSILON()).append(".").toString(), Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)(1.0 + MLUtils$.MODULE$.EPSILON() / 2.0)));
            double $org_scalatest_assert_macro_right2 = 1.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(21).append("EPSILON is too big: ").append(MLUtils$.MODULE$.EPSILON()).append(".").toString(), Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("fast squared distance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            double[] a = (double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(30), 0).by(-1).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$1 -> scala.math.package$.MODULE$.pow(2.0, (double)x$1), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            int n = a.length;
            Vector v1 = Vectors$.MODULE$.dense(a);
            double norm1 = Vectors$.MODULE$.norm(v1, 2.0);
            double precision = 1.0E-6;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach((Function1 & Serializable & scala.Serializable)m -> MLUtilsSuite.$anonfun$new$5(a, n, v1, norm1, precision, BoxesRunTime.unboxToInt((Object)m)));
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("loadLibSVMFile", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String lines = new StringOps(Predef$.MODULE$.augmentString("\n        |1 1:1.0 3:2.0 5:3.0\n        |0\n        |0 2:4.0 4:5.0 6:6.0\n      ")).stripMargin();
            File tempDir = Utils$.MODULE$.createTempDir();
            File file = new File(tempDir.getPath(), "part-00000");
            Files.write((CharSequence)lines, (File)file, (Charset)StandardCharsets.UTF_8);
            String path = tempDir.toURI().toString();
            LabeledPoint[] pointsWithNumFeatures = (LabeledPoint[])MLUtils$.MODULE$.loadLibSVMFile(this.sc(), path, 6).collect();
            LabeledPoint[] pointsWithoutNumFeatures = (LabeledPoint[])MLUtils$.MODULE$.loadLibSVMFile(this.sc(), path).collect();
            ((IterableLike)new .colon.colon((Object)pointsWithNumFeatures, (List)new .colon.colon((Object)pointsWithoutNumFeatures, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)points -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((LabeledPoint[])points).length));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)points[0].label()));
                double $org_scalatest_assert_macro_right2 = 1.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(points[0].features());
                Vector $org_scalatest_assert_macro_right3 = Vectors$.MODULE$.sparse(6, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 1.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 2.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(4, 3.0), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
                double $org_scalatest_assert_macro_left4 = points[1].label();
                double $org_scalatest_assert_macro_right4 = 0.0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
                Vector $org_scalatest_assert_macro_left5 = points[1].features();
                Vector $org_scalatest_assert_macro_right5 = Vectors$.MODULE$.sparse(6, (Seq)Nil$.MODULE$);
                Vector vector = $org_scalatest_assert_macro_left5;
                Vector vector2 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(vector != null ? !vector.equals(vector2) : vector2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)points[2].label()));
                double $org_scalatest_assert_macro_right6 = 0.0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(points[2].features());
                Vector $org_scalatest_assert_macro_right7 = Vectors$.MODULE$.sparse(6, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(1, 4.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(3, 5.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(5, 6.0), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            });
            LabeledPoint[] multiclassPoints = (LabeledPoint[])MLUtils$.MODULE$.loadLibSVMFile(this.sc(), path).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)multiclassPoints.length));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)multiclassPoints[0].label()));
            double $org_scalatest_assert_macro_right2 = 1.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)multiclassPoints[1].label()));
            double $org_scalatest_assert_macro_right3 = 0.0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)multiclassPoints[2].label()));
            double $org_scalatest_assert_macro_right4 = 0.0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            Utils$.MODULE$.deleteRecursively(tempDir);
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("loadLibSVMFile throws IllegalArgumentException when indices is zero-based", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String lines = new StringOps(Predef$.MODULE$.augmentString("\n        |0\n        |0 0:4.0 4:5.0 6:6.0\n      ")).stripMargin();
            File tempDir = Utils$.MODULE$.createTempDir();
            File file = new File(tempDir.getPath(), "part-00000");
            Files.write((CharSequence)lines, (File)file, (Charset)StandardCharsets.UTF_8);
            String path = tempDir.toURI().toString();
            this.intercept((Function0 & Serializable & scala.Serializable)() -> (LabeledPoint[])MLUtils$.MODULE$.loadLibSVMFile(this.sc(), path).collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            Utils$.MODULE$.deleteRecursively(tempDir);
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("loadLibSVMFile throws IllegalArgumentException when indices is not in ascending order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String lines = new StringOps(Predef$.MODULE$.augmentString("\n        |0\n        |0 3:4.0 2:5.0 6:6.0\n      ")).stripMargin();
            File tempDir = Utils$.MODULE$.createTempDir();
            File file = new File(tempDir.getPath(), "part-00000");
            Files.write((CharSequence)lines, (File)file, (Charset)StandardCharsets.UTF_8);
            String path = tempDir.toURI().toString();
            this.intercept((Function0 & Serializable & scala.Serializable)() -> (LabeledPoint[])MLUtils$.MODULE$.loadLibSVMFile(this.sc(), path).collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            Utils$.MODULE$.deleteRecursively(tempDir);
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        this.test("saveAsLibSVMFile", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD examples = this.sc().parallelize((Seq)new .colon.colon((Object)new LabeledPoint(1.1, Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 1.23), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 4.56), (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.01, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.02, 3.03}))), (List)Nil$.MODULE$)), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            File tempDir = Utils$.MODULE$.createTempDir();
            File outputDir = new File(tempDir, "output");
            MLUtils$.MODULE$.saveAsLibSVMFile(examples, outputDir.toURI().toString());
            BufferedSource[] sources = (BufferedSource[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputDir.listFiles())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MLUtilsSuite.$anonfun$new$16(x$2))))).map((Function1 & Serializable & scala.Serializable)file -> Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BufferedSource.class)));
            return (Assertion)Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> {
                Set lines = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sources)).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getLines(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
                Set expected = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1.1 1:1.23 3:4.56", "0.0 1:1.01 2:2.02 3:3.03"}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(lines);
                Set $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sources)).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.close();
                    return BoxedUnit.UNIT;
                });
                Utils$.MODULE$.deleteRecursively(tempDir);
            });
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("appendBias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector sv = Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 1.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 3.0), (List)Nil$.MODULE$)));
            SparseVector sv1 = (SparseVector)MLUtils$.MODULE$.appendBias(sv);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv1.size()));
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(sv1.indices());
            int[] $org_scalatest_assert_macro_right2 = new int[]{0, 2, 3};
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(sv1.values());
            double[] $org_scalatest_assert_macro_right3 = new double[]{1.0, 3.0, 1.0};
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            Vector dv = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 3.0}));
            DenseVector dv1 = (DenseVector)MLUtils$.MODULE$.appendBias(dv);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv1.size()));
            int $org_scalatest_assert_macro_right4 = 4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(dv1.values());
            double[] $org_scalatest_assert_macro_right5 = new double[]{1.0, 0.0, 3.0, 1.0};
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test("kFold", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            RDD data = this.sc().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100), 2, ClassTag$.MODULE$.Int());
            int[] collectedData = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])data.collect())).sorted((Ordering)Ordering.Int$.MODULE$);
            Tuple2[] twoFoldedRdd = MLUtils$.MODULE$.kFold(data, 2, 1, ClassTag$.MODULE$.Int());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])((RDD)twoFoldedRdd[0]._1()).collect())).sorted((Ordering)Ordering.Int$.MODULE$));
            int[] $org_scalatest_assert_macro_right = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])((RDD)twoFoldedRdd[1]._2()).collect())).sorted((Ordering)Ordering.Int$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])((RDD)twoFoldedRdd[0]._2()).collect())).sorted((Ordering)Ordering.Int$.MODULE$));
            int[] $org_scalatest_assert_macro_right2 = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])((RDD)twoFoldedRdd[1]._1()).collect())).sorted((Ordering)Ordering.Int$.MODULE$);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)folds -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach((Function1 & Serializable & scala.Serializable)seed -> MLUtilsSuite.$anonfun$new$25(this, data, folds, collectedData, BoxesRunTime.unboxToInt((Object)seed))));
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.test("loadVectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            RDD vectors = this.sc().parallelize((Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.sparse(2, new int[]{1}, new double[]{-1.0}), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})), (List)Nil$.MODULE$))), 2, ClassTag$.MODULE$.apply(Vector.class));
            File tempDir = Utils$.MODULE$.createTempDir();
            File outputDir = new File(tempDir, "vectors");
            String path = outputDir.toURI().toString();
            vectors.saveAsTextFile(path);
            RDD loaded = MLUtils$.MODULE$.loadVectors(this.sc(), path);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])vectors.collect())).toSet());
            Set $org_scalatest_assert_macro_right = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])loaded.collect())).toSet();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
            Utils$.MODULE$.deleteRecursively(tempDir);
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("loadLabeledPoints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            RDD points = this.sc().parallelize((Seq)new .colon.colon((Object)new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), (List)new .colon.colon((Object)new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, new int[]{1}, new double[]{-1.0})), (List)new .colon.colon((Object)new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), (List)Nil$.MODULE$))), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            File tempDir = Utils$.MODULE$.createTempDir();
            File outputDir = new File(tempDir, "points");
            String path = outputDir.toURI().toString();
            points.saveAsTextFile(path);
            RDD loaded = MLUtils$.MODULE$.loadLabeledPoints(this.sc(), path);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])points.collect())).toSet());
            Set $org_scalatest_assert_macro_right = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])loaded.collect())).toSet();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            Utils$.MODULE$.deleteRecursively(tempDir);
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        this.test("log1pExp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(MLUtils$.MODULE$.log1pExp(76.3)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scala.math.package$.MODULE$.log1p(scala.math.package$.MODULE$.exp(76.3))).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.mllib.util.MLUtils.log1pExp(76.3)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.log1p(scala.math.`package`.exp(76.3))).relTol(1.0E-10))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(MLUtils$.MODULE$.log1pExp(8.7296763234E7)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(8.7296763234E7).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.mllib.util.MLUtils.log1pExp(8.7296763234E7)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(8.7296763234E7).relTol(1.0E-10))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(MLUtils$.MODULE$.log1pExp(-13.8)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scala.math.package$.MODULE$.log1p(scala.math.package$.MODULE$.exp(-13.8))).absTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.mllib.util.MLUtils.log1pExp(-13.8)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.log1p(scala.math.`package`.exp(-13.8))).absTol(1.0E-10))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(MLUtils$.MODULE$.log1pExp(-2.38423789865E8)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scala.math.package$.MODULE$.log1p(scala.math.package$.MODULE$.exp(-2.38423789865E8))).absTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.mllib.util.MLUtils.log1pExp(-2.38423789865E8)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.log1p(scala.math.`package`.exp(-2.38423789865E8))).absTol(1.0E-10))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.test("convertVectorColumnsToML", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector x = Vectors$.MODULE$.sparse(2, new int[]{1}, new double[]{1.0});
            Metadata metadata = new MetadataBuilder().putLong("numFeatures", 2L).build();
            Vector y = Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0}));
            Vector z = Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
            Tuple2 p = new Tuple2((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)z);
            org.apache.spark.ml.linalg.Vector w = Vectors$.MODULE$.dense(6.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])).asML();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MLUtilsSuite.class.getClassLoader());
            public final class Org_apache_spark_mllib_util_MLUtilsSuite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
                }

                public Org_apache_spark_mllib_util_MLUtilsSuite$$typecreator6$1(MLUtilsSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)0), (Object)x, (Object)y, (Object)p, (Object)w), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtilsSuite$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "x", "y", "p", "w"})).withColumn("x", functions$.MODULE$.col("x"), metadata);
            Dataset newDF1 = MLUtils$.MODULE$.convertVectorColumnsToML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(newDF1.schema().apply("x").metadata());
            Metadata $org_scalatest_assert_macro_right = metadata;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Metadata should be preserved.", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
            Row new1 = (Row)newDF1.first();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new1);
            Row $org_scalatest_assert_macro_right2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), x.asML(), y.asML(), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)5.0), z})), w}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
            Row new2 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x", "y"})).first();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new2);
            Row $org_scalatest_assert_macro_right3 = new1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            Row new3 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y", "w"})).first();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new3);
            Row $org_scalatest_assert_macro_right4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), x, y.asML(), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)5.0), z})), w}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> MLUtils$.MODULE$.convertVectorColumnsToML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p"})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> MLUtils$.MODULE$.convertVectorColumnsToML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p._2"})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        this.test("convertVectorColumnsFromML", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.ml.linalg.Vector x = Vectors$.MODULE$.sparse(2, new int[]{1}, new double[]{1.0}).asML();
            Metadata metadata = new MetadataBuilder().putLong("numFeatures", 2L).build();
            org.apache.spark.ml.linalg.Vector y = Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0})).asML();
            org.apache.spark.ml.linalg.Vector z = Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])).asML();
            Tuple2 p = new Tuple2((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)z);
            Vector w = Vectors$.MODULE$.dense(6.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MLUtilsSuite.class.getClassLoader());
            public final class Org_apache_spark_mllib_util_MLUtilsSuite$$typecreator16$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
                }

                public Org_apache_spark_mllib_util_MLUtilsSuite$$typecreator16$1(MLUtilsSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)0), (Object)x, (Object)y, (Object)p, (Object)w), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtilsSuite$$typecreator16$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "x", "y", "p", "w"})).withColumn("x", functions$.MODULE$.col("x"), metadata);
            Dataset newDF1 = MLUtils$.MODULE$.convertVectorColumnsFromML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(newDF1.schema().apply("x").metadata());
            Metadata $org_scalatest_assert_macro_right = metadata;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Metadata should be preserved.", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
            Row new1 = (Row)newDF1.first();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new1);
            Row $org_scalatest_assert_macro_right2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), Vectors$.MODULE$.fromML(x), Vectors$.MODULE$.fromML(y), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)5.0), z})), w}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
            Row new2 = (Row)MLUtils$.MODULE$.convertVectorColumnsFromML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x", "y"})).first();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new2);
            Row $org_scalatest_assert_macro_right3 = new1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            Row new3 = (Row)MLUtils$.MODULE$.convertVectorColumnsFromML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y", "w"})).first();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new3);
            Row $org_scalatest_assert_macro_right4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), x, Vectors$.MODULE$.fromML(y), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)5.0), z})), w}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> MLUtils$.MODULE$.convertVectorColumnsFromML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p"})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> MLUtils$.MODULE$.convertVectorColumnsFromML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p._2"})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        this.test("convertMatrixColumnsToML", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Matrix x = Matrices$.MODULE$.sparse(3, 2, new int[]{0, 2, 3}, new int[]{0, 2, 1}, new double[]{0.0, -1.2, 0.0});
            Metadata metadata = new MetadataBuilder().putLong("numFeatures", 2L).build();
            Matrix y = Matrices$.MODULE$.dense(2, 1, new double[]{0.2, 1.3});
            Matrix z = Matrices$.MODULE$.ones(1, 1);
            Tuple2 p = new Tuple2((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)z);
            org.apache.spark.ml.linalg.Matrix w = Matrices$.MODULE$.dense(1, 1, new double[]{4.5}).asML();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MLUtilsSuite.class.getClassLoader());
            public final class Org_apache_spark_mllib_util_MLUtilsSuite$$typecreator26$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Matrix").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
                }

                public Org_apache_spark_mllib_util_MLUtilsSuite$$typecreator26$1(MLUtilsSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)0), (Object)x, (Object)y, (Object)p, (Object)w), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtilsSuite$$typecreator26$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "x", "y", "p", "w"})).withColumn("x", functions$.MODULE$.col("x"), metadata);
            Dataset newDF1 = MLUtils$.MODULE$.convertMatrixColumnsToML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(newDF1.schema().apply("x").metadata());
            Metadata $org_scalatest_assert_macro_right = metadata;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Metadata should be preserved.", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
            Row new1 = (Row)newDF1.first();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new1);
            Row $org_scalatest_assert_macro_right2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), x.asML(), y.asML(), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)5.0), z})), w}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
            Row new2 = (Row)MLUtils$.MODULE$.convertMatrixColumnsToML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x", "y"})).first();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new2);
            Row $org_scalatest_assert_macro_right3 = new1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
            Row new3 = (Row)MLUtils$.MODULE$.convertMatrixColumnsToML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y", "w"})).first();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new3);
            Row $org_scalatest_assert_macro_right4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), x, y.asML(), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)5.0), z})), w}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> MLUtils$.MODULE$.convertMatrixColumnsToML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p"})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> MLUtils$.MODULE$.convertMatrixColumnsToML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p._2"})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        this.test("convertMatrixColumnsFromML", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.ml.linalg.Matrix x = Matrices$.MODULE$.sparse(3, 2, new int[]{0, 2, 3}, new int[]{0, 2, 1}, new double[]{0.0, -1.2, 0.0}).asML();
            Metadata metadata = new MetadataBuilder().putLong("numFeatures", 2L).build();
            org.apache.spark.ml.linalg.Matrix y = Matrices$.MODULE$.dense(2, 1, new double[]{0.2, 1.3}).asML();
            org.apache.spark.ml.linalg.Matrix z = Matrices$.MODULE$.ones(1, 1).asML();
            Tuple2 p = new Tuple2((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)z);
            Matrix w = Matrices$.MODULE$.dense(1, 1, new double[]{4.5});
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MLUtilsSuite.class.getClassLoader());
            public final class Org_apache_spark_mllib_util_MLUtilsSuite$$typecreator36$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Matrix").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Matrix").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Matrix").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
                }

                public Org_apache_spark_mllib_util_MLUtilsSuite$$typecreator36$1(MLUtilsSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)0), (Object)x, (Object)y, (Object)p, (Object)w), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtilsSuite$$typecreator36$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "x", "y", "p", "w"})).withColumn("x", functions$.MODULE$.col("x"), metadata);
            Dataset newDF1 = MLUtils$.MODULE$.convertMatrixColumnsFromML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(newDF1.schema().apply("x").metadata());
            Metadata $org_scalatest_assert_macro_right = metadata;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Metadata should be preserved.", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            Row new1 = (Row)newDF1.first();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new1);
            Row $org_scalatest_assert_macro_right2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), Matrices$.MODULE$.fromML(x), Matrices$.MODULE$.fromML(y), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)5.0), z})), w}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
            Row new2 = (Row)MLUtils$.MODULE$.convertMatrixColumnsFromML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x", "y"})).first();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new2);
            Row $org_scalatest_assert_macro_right3 = new1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
            Row new3 = (Row)MLUtils$.MODULE$.convertMatrixColumnsFromML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y", "w"})).first();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new3);
            Row $org_scalatest_assert_macro_right4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), x, Matrices$.MODULE$.fromML(y), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)5.0), z})), w}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> MLUtils$.MODULE$.convertMatrixColumnsFromML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p"})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> MLUtils$.MODULE$.convertMatrixColumnsFromML(df, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p._2"})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        this.test("kFold with fold column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MLUtilsSuite.class.getClassLoader());
            public final class Org_apache_spark_mllib_util_MLUtilsSuite$$typecreator46$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_mllib_util_MLUtilsSuite$$typecreator46$1(MLUtilsSuite $outer) {
                }
            }
            Dataset data = this.testImplicits().rddToDatasetHolder(this.sc().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100), 2, ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)x -> MLUtilsSuite.$anonfun$new$45(BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Tuple2.class)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtilsSuite$$typecreator46$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "fold"}));
            int[] collectedData = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.collect())).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.getInt(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sorted((Ordering)Ordering.Int$.MODULE$);
            Tuple2[] twoFoldedRdd = MLUtils$.MODULE$.kFold(data, 2, "fold");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((RDD)twoFoldedRdd[0]._1()).collect())).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.getInt(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sorted((Ordering)Ordering.Int$.MODULE$));
            int[] $org_scalatest_assert_macro_right = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((RDD)twoFoldedRdd[1]._2()).collect())).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.getInt(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sorted((Ordering)Ordering.Int$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((RDD)twoFoldedRdd[0]._2()).collect())).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.getInt(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sorted((Ordering)Ordering.Int$.MODULE$));
            int[] $org_scalatest_assert_macro_right2 = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((RDD)twoFoldedRdd[1]._1()).collect())).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.getInt(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sorted((Ordering)Ordering.Int$.MODULE$);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
            int[] result1 = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((RDD)twoFoldedRdd[0]._1()).union((RDD)twoFoldedRdd[0]._2()).collect())).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.getInt(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sorted((Ordering)Ordering.Int$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(result1);
            int[] $org_scalatest_assert_macro_right3 = collectedData;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Each training+validation set combined should contain all of the data.", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
            int[] result2 = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((RDD)twoFoldedRdd[1]._1()).union((RDD)twoFoldedRdd[1]._2()).collect())).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.getInt(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sorted((Ordering)Ordering.Int$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(result2);
            int[] $org_scalatest_assert_macro_right4 = collectedData;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"Each training+validation set combined should contain all of the data.", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
        this.test("kFold with fold column: invalid fold numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset data = this.testImplicits().rddToDatasetHolder(this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), 2, ClassTag$.MODULE$.Int()), this.testImplicits().newIntEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fold"}));
            SparkException err1 = (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((RDD)MLUtils$.MODULE$.kFold(data, 2, "fold")[0]._1()).collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            String $org_scalatest_assert_macro_left = err1.getMessage();
            String $org_scalatest_assert_macro_right = "Fold number must be in range [0, 2), but got 2.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
            SparkException err2 = (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((RDD)MLUtils$.MODULE$.kFold(data, 4, "fold")[0]._1()).collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
            String $org_scalatest_assert_macro_left2 = err2.getMessage();
            String $org_scalatest_assert_macro_right2 = "The validation data at fold 3 is empty.";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        }, new Position("MLUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
    }
}

