/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.util.TestingUtils;
import org.scalatest.exceptions.TestFailedException;
import scala.math.package$;

public final class TestingUtils$ {
    public static TestingUtils$ MODULE$;
    private final String ABS_TOL_MSG;
    private final String REL_TOL_MSG;

    static {
        new TestingUtils$();
    }

    public String ABS_TOL_MSG() {
        return this.ABS_TOL_MSG;
    }

    public String REL_TOL_MSG() {
        return this.REL_TOL_MSG;
    }

    public boolean org$apache$spark$mllib$util$TestingUtils$$RelativeErrorComparison(double x, double y, double eps) {
        double absX = package$.MODULE$.abs(x);
        double absY = package$.MODULE$.abs(y);
        double diff = package$.MODULE$.abs(x - y);
        if (x == y) {
            return true;
        }
        if (absX < Double.MIN_VALUE || absY < Double.MIN_VALUE) {
            throw new TestFailedException(new StringBuilder(74).append(x).append(" or ").append(y).append(" is extremely close to zero, so the relative tolerance is meaningless.").toString(), 0);
        }
        return diff < eps * package$.MODULE$.min(absX, absY);
    }

    public boolean org$apache$spark$mllib$util$TestingUtils$$AbsoluteErrorComparison(double x, double y, double eps) {
        return package$.MODULE$.abs(x - y) < eps;
    }

    public TestingUtils.DoubleWithAlmostEquals DoubleWithAlmostEquals(double x) {
        return new TestingUtils.DoubleWithAlmostEquals(x);
    }

    public TestingUtils.VectorWithAlmostEquals VectorWithAlmostEquals(Vector x) {
        return new TestingUtils.VectorWithAlmostEquals(x);
    }

    public TestingUtils.MatrixWithAlmostEquals MatrixWithAlmostEquals(Matrix x) {
        return new TestingUtils.MatrixWithAlmostEquals(x);
    }

    private TestingUtils$() {
        MODULE$ = this;
        this.ABS_TOL_MSG = " using absolute tolerance";
        this.REL_TOL_MSG = " using relative tolerance";
    }
}

