/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.RandomForestClassificationModel;
import org.apache.spark.ml.classification.RandomForestClassificationModel$;
import org.apache.spark.ml.classification.RandomForestClassifier;
import org.apache.spark.ml.tree.impl.TreeTests$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LabeledPoint$;
import org.apache.spark.mllib.tree.RandomForest$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RandomForestClassifierSuite$
extends SparkFunSuite {
    public static RandomForestClassifierSuite$ MODULE$;

    static {
        new RandomForestClassifierSuite$();
    }

    public void compareAPIs(RDD<org.apache.spark.ml.feature.LabeledPoint> data, RandomForestClassifier rf, Map<Object, Object> categoricalFeatures, int numClasses) {
        int numFeatures = ((org.apache.spark.ml.feature.LabeledPoint)data.first()).features().size();
        Strategy oldStrategy = rf.getOldStrategy(categoricalFeatures, numClasses, Algo$.MODULE$.Classification(), rf.getOldImpurity());
        oldStrategy.bootstrap_$eq(rf.getBootstrap());
        RandomForestModel oldModel = RandomForest$.MODULE$.trainClassifier(data.map((Function1 & Serializable & scala.Serializable)point -> LabeledPoint$.MODULE$.fromML(point), ClassTag$.MODULE$.apply(LabeledPoint.class)), oldStrategy, rf.getNumTrees(), rf.getFeatureSubsetStrategy(), (int)rf.getSeed());
        Dataset<Row> newData = TreeTests$.MODULE$.setMetadata(data, categoricalFeatures, numClasses);
        RandomForestClassificationModel newModel = (RandomForestClassificationModel)rf.fit(newData);
        RandomForestClassificationModel oldModelAsNew = RandomForestClassificationModel$.MODULE$.fromOld(oldModel, (RandomForestClassifier)newModel.parent(), categoricalFeatures, numClasses, RandomForestClassificationModel$.MODULE$.fromOld$default$5());
        TreeTests$.MODULE$.checkEqual(oldModelAsNew, newModel);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(newModel.hasParent(), "newModel.hasParent", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((Model)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newModel.trees())).head()).hasParent(), "scala.Predef.refArrayOps[org.apache.spark.ml.classification.DecisionTreeClassificationModel](newModel.trees).head.hasParent", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)newModel.numClasses()));
        int $org_scalatest_assert_macro_right = numClasses;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)newModel.numFeatures()));
        int $org_scalatest_assert_macro_right2 = numFeatures;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RandomForestClassifierSuite$() {
        MODULE$ = this;
    }
}

