/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.tree.impl.BaggedPoint;
import org.apache.spark.ml.tree.impl.BaggedPoint$;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00052AAA\u0002\u0001!!)Q\u0004\u0001C\u0001=\t\u0001\")Y4hK\u0012\u0004v.\u001b8u'VLG/\u001a\u0006\u0003\t\u0015\tA![7qY*\u0011aaB\u0001\u0005iJ,WM\u0003\u0002\t\u0013\u0005\u0011Q\u000e\u001c\u0006\u0003\u0015-\tQa\u001d9be.T!\u0001D\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0011aA8sO\u000e\u00011c\u0001\u0001\u0012+A\u0011!cE\u0007\u0002\u0013%\u0011A#\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005YYR\"A\f\u000b\u0005aI\u0012\u0001B;uS2T!AG\u0005\u0002\u000b5dG.\u001b2\n\u0005q9\"!F'MY&\u0014G+Z:u'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\r\u0001")
public class BaggedPointSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        BaggedPointSuite baggedPointSuite = this;
        synchronized (baggedPointSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ double $anonfun$new$3(Instance instance) {
        return instance.weight() * 4.0;
    }

    public static final /* synthetic */ double $anonfun$new$9(LabeledPoint x$3) {
        return 2.0;
    }

    public static final /* synthetic */ boolean $anonfun$new$12(BaggedPointSuite $this, BaggedPoint x$6) {
        return $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)x$6.sampleWeight())).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)2.0), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ Assertion $anonfun$new$8(BaggedPointSuite $this, RDD rdd$1, int numSubsamples$1, double expectedMean$1, double expectedStddev$1, int seed) {
        RDD baggedRDD = BaggedPoint$.MODULE$.convertToBaggedRDD(rdd$1, 1.0, numSubsamples$1, true, (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)BaggedPointSuite.$anonfun$new$9(x$3)), (long)seed);
        double[][] subsampleCounts = (double[][])baggedRDD.map((Function1 & Serializable & scala.Serializable)x$4 -> (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x$4.subsampleCounts())).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$5 -> x$5, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))).collect();
        EnsembleTestHelper$.MODULE$.testRandomArrays(subsampleCounts, numSubsamples$1, expectedMean$1, expectedStddev$1, 0.01);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])baggedRDD.collect())).forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)BaggedPointSuite.$anonfun$new$12($this, x$6))), "scala.Predef.refArrayOps[org.apache.spark.ml.tree.impl.BaggedPoint[org.apache.spark.ml.feature.LabeledPoint]](baggedRDD.collect()).forall(((x$6: org.apache.spark.ml.tree.impl.BaggedPoint[org.apache.spark.ml.feature.LabeledPoint]) => BaggedPointSuite.this.convertToEqualizer[Double](x$6.sampleWeight).===(2.0)(scalactic.this.Equality.default[Double])))", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BaggedPointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
    }

    public static final /* synthetic */ double $anonfun$new$20(LabeledPoint x$12) {
        return 2.0;
    }

    public static final /* synthetic */ boolean $anonfun$new$23(BaggedPointSuite $this, BaggedPoint x$15) {
        return $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)x$15.sampleWeight())).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)2.0), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ Assertion $anonfun$new$19(BaggedPointSuite $this, RDD rdd$3, int numSubsamples$3, double expectedMean$3, int expectedStddev$3, int seed) {
        RDD baggedRDD = BaggedPoint$.MODULE$.convertToBaggedRDD(rdd$3, 1.0, numSubsamples$3, false, (Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)BaggedPointSuite.$anonfun$new$20(x$12)), (long)seed);
        double[][] subsampleCounts = (double[][])baggedRDD.map((Function1 & Serializable & scala.Serializable)x$13 -> (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x$13.subsampleCounts())).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$14 -> x$14, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))).collect();
        EnsembleTestHelper$.MODULE$.testRandomArrays(subsampleCounts, numSubsamples$3, expectedMean$3, expectedStddev$3, 0.01);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])baggedRDD.collect())).forall((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)BaggedPointSuite.$anonfun$new$23($this, x$15))), "scala.Predef.refArrayOps[org.apache.spark.ml.tree.impl.BaggedPoint[org.apache.spark.ml.feature.LabeledPoint]](baggedRDD.collect()).forall(((x$15: org.apache.spark.ml.tree.impl.BaggedPoint[org.apache.spark.ml.feature.LabeledPoint]) => BaggedPointSuite.this.convertToEqualizer[Double](x$15.sampleWeight).===(2.0)(scalactic.this.Equality.default[Double])))", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BaggedPointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
    }

    public BaggedPointSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("BaggedPoint RDD: without subsampling with weights", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Instance[] arr = (Instance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(1, 1000))).map((Function1 & Serializable & scala.Serializable)lp -> new Instance(lp.label(), 0.5, lp.features().asML()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class)));
            SparkContext qual$1 = this.sc();
            WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$2 = qual$1.parallelize$default$2();
            RDD rdd = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Instance.class));
            RDD baggedRDD = BaggedPoint$.MODULE$.convertToBaggedRDD(rdd, 1.0, 1, false, (Function1 & Serializable & scala.Serializable)instance -> BoxesRunTime.boxToDouble((double)BaggedPointSuite.$anonfun$new$3(instance)), 42L);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])baggedRDD.collect())).foreach((Function1 & Serializable & scala.Serializable)baggedPoint -> {
                Bool bool;
                int $org_scalatest_assert_macro_right;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(baggedPoint.subsampleCounts())).size()));
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)($org_scalatest_assert_macro_right = 1)), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)baggedPoint.subsampleCounts()[0]));
                    int $org_scalatest_assert_macro_right2 = 1;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BaggedPointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)baggedPoint.sampleWeight()));
                double $org_scalatest_assert_macro_right4 = 2.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BaggedPointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            });
        }, new Position("BaggedPointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("BaggedPoint RDD: with subsampling with replacement (fraction = 1.0)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int numSubsamples = 100;
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(1.0, 1.0);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            double expectedMean = sp2._1$mcD$sp();
            double expectedStddev = sp2._2$mcD$sp();
            Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(expectedMean, expectedStddev);
            double expectedMean2 = sp3._1$mcD$sp();
            double expectedStddev2 = sp3._2$mcD$sp();
            int[] seeds = new int[]{123, 5354, 230, 349867, 23987};
            LabeledPoint[] arr = (LabeledPoint[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(1, 1000))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.asML(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledPoint.class)));
            SparkContext qual$2 = this.sc();
            WrappedArray x$3 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$4 = qual$2.parallelize$default$2();
            RDD rdd = qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.apply(LabeledPoint.class));
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(seeds)).foreach((Function1 & Serializable & scala.Serializable)seed -> BaggedPointSuite.$anonfun$new$8(this, rdd, numSubsamples, expectedMean2, expectedStddev2, BoxesRunTime.unboxToInt((Object)seed)));
        }, new Position("BaggedPointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("BaggedPoint RDD: with subsampling with replacement (fraction = 0.5)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int numSubsamples = 100;
            double subsample = 0.5;
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(subsample, package$.MODULE$.sqrt(subsample));
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            double expectedMean = sp2._1$mcD$sp();
            double expectedStddev = sp2._2$mcD$sp();
            Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(expectedMean, expectedStddev);
            double expectedMean2 = sp3._1$mcD$sp();
            double expectedStddev2 = sp3._2$mcD$sp();
            int[] seeds = new int[]{123, 5354, 230, 349867, 23987};
            org.apache.spark.mllib.regression.LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(1, 1000);
            SparkContext qual$3 = this.sc();
            WrappedArray x$5 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$6 = qual$3.parallelize$default$2();
            RDD rdd = qual$3.parallelize((Seq)x$5, x$6, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(seeds)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)seed -> {
                RDD x$7 = rdd;
                double x$82 = subsample;
                int x$9 = numSubsamples;
                boolean x$10 = true;
                long x$11 = seed;
                Function1 x$12 = BaggedPoint$.MODULE$.convertToBaggedRDD$default$5();
                RDD baggedRDD = BaggedPoint$.MODULE$.convertToBaggedRDD(x$7, x$82, x$9, x$10, x$12, x$11);
                double[][] subsampleCounts = (double[][])baggedRDD.map((Function1 & Serializable & scala.Serializable)x$8 -> (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x$8.subsampleCounts())).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$9 -> x$9, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))).collect();
                EnsembleTestHelper$.MODULE$.testRandomArrays(subsampleCounts, numSubsamples, expectedMean2, expectedStddev2, 0.01);
            });
        }, new Position("BaggedPointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("BaggedPoint RDD: with subsampling without replacement (fraction = 1.0)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int numSubsamples = 100;
            Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(1.0, 0);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            double expectedMean = sp2._1$mcD$sp();
            int expectedStddev = sp2._2$mcI$sp();
            Tuple2.mcDI.sp sp3 = new Tuple2.mcDI.sp(expectedMean, expectedStddev);
            double expectedMean2 = sp3._1$mcD$sp();
            int expectedStddev2 = sp3._2$mcI$sp();
            int[] seeds = new int[]{123, 5354, 230, 349867, 23987};
            LabeledPoint[] arr = (LabeledPoint[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(1, 1000))).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.asML(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledPoint.class)));
            SparkContext qual$4 = this.sc();
            WrappedArray x$13 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$14 = qual$4.parallelize$default$2();
            RDD rdd = qual$4.parallelize((Seq)x$13, x$14, ClassTag$.MODULE$.apply(LabeledPoint.class));
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(seeds)).foreach((Function1 & Serializable & scala.Serializable)seed -> BaggedPointSuite.$anonfun$new$19(this, rdd, numSubsamples, expectedMean2, expectedStddev2, BoxesRunTime.unboxToInt((Object)seed)));
        }, new Position("BaggedPointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("BaggedPoint RDD: with subsampling without replacement (fraction = 0.5)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int numSubsamples = 100;
            double subsample = 0.5;
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(subsample, package$.MODULE$.sqrt(subsample * (1.0 - subsample)));
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            double expectedMean = sp2._1$mcD$sp();
            double expectedStddev = sp2._2$mcD$sp();
            Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(expectedMean, expectedStddev);
            double expectedMean2 = sp3._1$mcD$sp();
            double expectedStddev2 = sp3._2$mcD$sp();
            int[] seeds = new int[]{123, 5354, 230, 349867, 23987};
            org.apache.spark.mllib.regression.LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(1, 1000);
            SparkContext qual$5 = this.sc();
            WrappedArray x$15 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$16 = qual$5.parallelize$default$2();
            RDD rdd = qual$5.parallelize((Seq)x$15, x$16, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(seeds)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)seed -> {
                RDD x$172 = rdd;
                double x$18 = subsample;
                int x$19 = numSubsamples;
                boolean x$20 = false;
                long x$21 = seed;
                Function1 x$22 = BaggedPoint$.MODULE$.convertToBaggedRDD$default$5();
                RDD baggedRDD = BaggedPoint$.MODULE$.convertToBaggedRDD(x$172, x$18, x$19, x$20, x$22, x$21);
                double[][] subsampleCounts = (double[][])baggedRDD.map((Function1 & Serializable & scala.Serializable)x$17 -> (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x$17.subsampleCounts())).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$18 -> x$18, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))).collect();
                EnsembleTestHelper$.MODULE$.testRandomArrays(subsampleCounts, numSubsamples, expectedMean2, expectedStddev2, 0.01);
            });
        }, new Position("BaggedPointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
    }
}

