/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import breeze.linalg.norm$;
import breeze.linalg.operators.HasOps$;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.feature.Normalizer;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.Tuple3Zipped;
import scala.runtime.Tuple3Zipped$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0002\u0004\u0001#!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0003\t\u0003B\u0002\u0018\u0001A\u0003%!\u0005\u0003\u00050\u0001!\u0015\r\u0011\"\u00011\u0005=quN]7bY&TXM]*vSR,'BA\u0004\t\u0003\u001d1W-\u0019;ve\u0016T!!\u0003\u0006\u0002\u000b5dG.\u001b2\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003)I!!\u0006\u0006\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t9\"$D\u0001\u0019\u0015\tI\u0002\"\u0001\u0003vi&d\u0017BA\u000e\u0019\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\fa\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0004\u0002\t\u0011\fG/Y\u000b\u0002EA\u00191E\n\u0015\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012Q!\u0011:sCf\u0004\"!\u000b\u0017\u000e\u0003)R!a\u000b\u0005\u0002\r1Lg.\u00197h\u0013\ti#F\u0001\u0004WK\u000e$xN]\u0001\u0006I\u0006$\u0018\rI\u0001\bI\u0006$\u0018M\u0015#E+\u0005\t\u0004c\u0001\u001a6Q5\t1G\u0003\u00025\u0015\u0005\u0019!\u000f\u001a3\n\u0005Y\u001a$a\u0001*E\t\u0002")
public class NormalizerSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private RDD<Vector> dataRDD;
    private final Vector[] data;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Vector[] data() {
        return this.data;
    }

    private RDD<Vector> dataRDD$lzycompute() {
        NormalizerSuite normalizerSuite = this;
        synchronized (normalizerSuite) {
            if (!this.bitmap$0) {
                this.dataRDD = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.data()), 3, ClassTag$.MODULE$.apply(Vector.class));
                this.bitmap$0 = true;
            }
        }
        return this.dataRDD;
    }

    public RDD<Vector> dataRDD() {
        if (!this.bitmap$0) {
            return this.dataRDD$lzycompute();
        }
        return this.dataRDD;
    }

    private final void testImplicits$lzycompute$1() {
        NormalizerSuite normalizerSuite = this;
        synchronized (normalizerSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$6(Vector x0$1, Vector x1$1, Vector x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)x0$1, (Object)x1$1, (Object)x2$1);
        if (tuple3 != null) {
            Vector v1 = (Vector)tuple3._1();
            Vector v2 = (Vector)tuple3._2();
            Vector v3 = (Vector)tuple3._3();
            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                return true;
            }
        }
        if (tuple3 != null) {
            Vector v1 = (Vector)tuple3._1();
            Vector v2 = (Vector)tuple3._2();
            Vector v3 = (Vector)tuple3._3();
            if (v1 instanceof SparseVector && v2 instanceof SparseVector && v3 instanceof SparseVector) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$9(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    public static final /* synthetic */ boolean $anonfun$new$15(Vector x0$2, Vector x1$2, Vector x2$2) {
        Tuple3 tuple3 = new Tuple3((Object)x0$2, (Object)x1$2, (Object)x2$2);
        if (tuple3 != null) {
            Vector v1 = (Vector)tuple3._1();
            Vector v2 = (Vector)tuple3._2();
            Vector v3 = (Vector)tuple3._3();
            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                return true;
            }
        }
        if (tuple3 != null) {
            Vector v1 = (Vector)tuple3._1();
            Vector v2 = (Vector)tuple3._2();
            Vector v3 = (Vector)tuple3._3();
            if (v1 instanceof SparseVector && v2 instanceof SparseVector && v3 instanceof SparseVector) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$18(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    public static final /* synthetic */ boolean $anonfun$new$24(Vector x0$3, Vector x1$3, Vector x2$3) {
        Tuple3 tuple3 = new Tuple3((Object)x0$3, (Object)x1$3, (Object)x2$3);
        if (tuple3 != null) {
            Vector v1 = (Vector)tuple3._1();
            Vector v2 = (Vector)tuple3._2();
            Vector v3 = (Vector)tuple3._3();
            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                return true;
            }
        }
        if (tuple3 != null) {
            Vector v1 = (Vector)tuple3._1();
            Vector v2 = (Vector)tuple3._2();
            Vector v3 = (Vector)tuple3._3();
            if (v1 instanceof SparseVector && v2 instanceof SparseVector && v3 instanceof SparseVector) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$27(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    public NormalizerSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.data = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, -2.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 2.3), (List)Nil$.MODULE$))), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0})), Vectors$.MODULE$.dense(0.6, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-1.1, -3.0})), Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(1, 0.91), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 3.2), (List)Nil$.MODULE$))), Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 5.7), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 0.72), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 2.7), (List)Nil$.MODULE$)))), Vectors$.MODULE$.sparse(3, (Seq)Nil$.MODULE$)});
        this.test("Normalization using L1 distance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Normalizer l1Normalizer = new Normalizer(1.0);
            Vector[] data1 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.data())).map((Function1 & Serializable & scala.Serializable)vector -> l1Normalizer.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            RDD data1RDD = l1Normalizer.transform(this.dataRDD());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.data(), (Object)data1, data1RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function3 & Serializable & scala.Serializable)(x0$1, x1$1, x2$1) -> BoxesRunTime.boxToBoolean((boolean)NormalizerSuite.$anonfun$new$6(x0$1, x1$1, x2$1))), "scala.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](NormalizerSuite.this.data, data1, data1RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$1: org.apache.spark.mllib.linalg.Vector, x1$1: org.apache.spark.mllib.linalg.Vector, x2$1: org.apache.spark.mllib.linalg.Vector) => scala.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$1, x1$1, x2$1) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The vector type should be preserved after normalization.", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data1, data1RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)NormalizerSuite.$anonfun$new$9(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data1, data1RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data1[0].asBreeze(), (Object)BoxesRunTime.boxToInteger((int)1), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.canIterateValues_V(), norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data1.apply(0).asBreeze, 1)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.norm.canNorm[breeze.linalg.Vector[Double], Double](operators.this.HasOps.canIterateValues_V[Double], linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data1[2].asBreeze(), (Object)BoxesRunTime.boxToInteger((int)1), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.canIterateValues_V(), norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data1.apply(2).asBreeze, 1)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.norm.canNorm[breeze.linalg.Vector[Double], Double](operators.this.HasOps.canIterateValues_V[Double], linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data1[3].asBreeze(), (Object)BoxesRunTime.boxToInteger((int)1), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.canIterateValues_V(), norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data1.apply(3).asBreeze, 1)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.norm.canNorm[breeze.linalg.Vector[Double], Double](operators.this.HasOps.canIterateValues_V[Double], linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data1[4].asBreeze(), (Object)BoxesRunTime.boxToInteger((int)1), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.canIterateValues_V(), norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data1.apply(4).asBreeze, 1)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.norm.canNorm[breeze.linalg.Vector[Double], Double](operators.this.HasOps.canIterateValues_V[Double], linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, -0.465116279), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 0.53488372), (List)Nil$.MODULE$)))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, scala.collection.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](0, -0.465116279), scala.Tuple2.apply[Int, Double](1, 0.53488372)))).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[1]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[2]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.12765957, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.23404255, -0.63829787}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(2)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.12765957, -0.23404255, -0.63829787)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[3]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(1, 0.22141119), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 0.7785888), (List)Nil$.MODULE$)))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(3)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, scala.collection.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](1, 0.22141119), scala.Tuple2.apply[Int, Double](2, 0.7785888)))).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.625, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.07894737, 0.29605263}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.625, 0.07894737, 0.29605263)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Nil$.MODULE$)).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, scala.collection.Seq.apply[Nothing]())).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        }, new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        this.test("Normalization using L2 distance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Normalizer l2Normalizer = new Normalizer();
            Vector[] data2 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.data())).map((Function1 & Serializable & scala.Serializable)vector -> l2Normalizer.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            RDD data2RDD = l2Normalizer.transform(this.dataRDD());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.data(), (Object)data2, data2RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function3 & Serializable & scala.Serializable)(x0$2, x1$2, x2$2) -> BoxesRunTime.boxToBoolean((boolean)NormalizerSuite.$anonfun$new$15(x0$2, x1$2, x2$2))), "scala.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](NormalizerSuite.this.data, data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$2: org.apache.spark.mllib.linalg.Vector, x1$2: org.apache.spark.mllib.linalg.Vector, x2$2: org.apache.spark.mllib.linalg.Vector) => scala.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$2, x1$2, x2$2) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The vector type should be preserved after normalization.", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data2, data2RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)NormalizerSuite.$anonfun$new$18(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data2[0].asBreeze(), (Object)BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.canIterateValues_V(), norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data2.apply(0).asBreeze, 2)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.norm.canNorm[breeze.linalg.Vector[Double], Double](operators.this.HasOps.canIterateValues_V[Double], linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data2[2].asBreeze(), (Object)BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.canIterateValues_V(), norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data2.apply(2).asBreeze, 2)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.norm.canNorm[breeze.linalg.Vector[Double], Double](operators.this.HasOps.canIterateValues_V[Double], linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data2[3].asBreeze(), (Object)BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.canIterateValues_V(), norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data2.apply(3).asBreeze, 2)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.norm.canNorm[breeze.linalg.Vector[Double], Double](operators.this.HasOps.canIterateValues_V[Double], linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data2[4].asBreeze(), (Object)BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.canIterateValues_V(), norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data2.apply(4).asBreeze, 2)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.norm.canNorm[breeze.linalg.Vector[Double], Double](operators.this.HasOps.canIterateValues_V[Double], linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, -0.65617871), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 0.75460552), (List)Nil$.MODULE$)))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, scala.collection.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](0, -0.65617871), scala.Tuple2.apply[Int, Double](1, 0.75460552)))).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[1]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[2]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.184549876, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.3383414, -0.922749378}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(2)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.184549876, -0.3383414, -0.922749378)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[3]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(1, 0.27352993), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 0.96186349), (List)Nil$.MODULE$)))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(3)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, scala.collection.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](1, 0.27352993), scala.Tuple2.apply[Int, Double](2, 0.96186349)))).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.897906166, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.113419726, 0.42532397}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.897906166, 0.113419726, 0.42532397)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Nil$.MODULE$)).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, scala.collection.Seq.apply[Nothing]())).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        }, new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("Normalization using L^Inf distance.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Normalizer lInfNormalizer = new Normalizer(Double.POSITIVE_INFINITY);
            Vector[] dataInf = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.data())).map((Function1 & Serializable & scala.Serializable)vector -> lInfNormalizer.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            RDD dataInfRDD = lInfNormalizer.transform(this.dataRDD());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.data(), (Object)dataInf, dataInfRDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function3 & Serializable & scala.Serializable)(x0$3, x1$3, x2$3) -> BoxesRunTime.boxToBoolean((boolean)NormalizerSuite.$anonfun$new$24(x0$3, x1$3, x2$3))), "scala.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](NormalizerSuite.this.data, dataInf, dataInfRDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$3: org.apache.spark.mllib.linalg.Vector, x1$3: org.apache.spark.mllib.linalg.Vector, x2$3: org.apache.spark.mllib.linalg.Vector) => scala.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$3, x1$3, x2$3) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The vector type should be preserved after normalization.", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)dataInf, dataInfRDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)NormalizerSuite.$anonfun$new$27(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](dataInf, dataInfRDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(dataInf[0].toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.abs(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).max((Ordering)Ordering.Double$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(scala.Predef.doubleArrayOps(dataInf.apply(0).toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.abs(x))\n})(scala.this.Array.canBuildFrom[Double]((ClassTag.Double: scala.reflect.ClassTag[Double])))).max[Double](math.this.Ordering.Double)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(dataInf[2].toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.abs(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).max((Ordering)Ordering.Double$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(scala.Predef.doubleArrayOps(dataInf.apply(2).toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.abs(x))\n})(scala.this.Array.canBuildFrom[Double]((ClassTag.Double: scala.reflect.ClassTag[Double])))).max[Double](math.this.Ordering.Double)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(dataInf[3].toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.abs(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).max((Ordering)Ordering.Double$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(scala.Predef.doubleArrayOps(dataInf.apply(3).toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.abs(x))\n})(scala.this.Array.canBuildFrom[Double]((ClassTag.Double: scala.reflect.ClassTag[Double])))).max[Double](math.this.Ordering.Double)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(dataInf[4].toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.abs(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).max((Ordering)Ordering.Double$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(scala.Predef.doubleArrayOps(dataInf.apply(4).toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.abs(x))\n})(scala.this.Array.canBuildFrom[Double]((ClassTag.Double: scala.reflect.ClassTag[Double])))).max[Double](math.this.Ordering.Double)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dataInf[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, -0.86956522), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 1.0), (List)Nil$.MODULE$)))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(dataInf.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, scala.collection.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](0, -0.86956522), scala.Tuple2.apply[Int, Double](1, 1.0)))).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dataInf[1]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(dataInf.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dataInf[2]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.2, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.36666667, -1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(dataInf.apply(2)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.2, -0.36666667, -1.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dataInf[3]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(1, 0.284375), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 1.0), (List)Nil$.MODULE$)))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(dataInf.apply(3)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, scala.collection.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](1, 0.284375), scala.Tuple2.apply[Int, Double](2, 1.0)))).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dataInf[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.12631579, 0.473684211}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(dataInf.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 0.12631579, 0.473684211)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dataInf[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Nil$.MODULE$)).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(dataInf.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, scala.collection.Seq.apply[Nothing]())).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        }, new Position("NormalizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
    }
}

