/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import java.io.File;
import java.io.Serializable;
import java.util.Random;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.mllib.stat.test.ChiSqTest;
import org.apache.spark.mllib.stat.test.ChiSqTest$;
import org.apache.spark.mllib.stat.test.ChiSqTestResult;
import org.apache.spark.mllib.stat.test.KolmogorovSmirnovTestResult;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001u1AAA\u0002\u0001\u001d!)\u0011\u0004\u0001C\u00015\t\u0019\u0002*\u001f9pi\",7/[:UKN$8+^5uK*\u0011A!B\u0001\u0005gR\fGO\u0003\u0002\u0007\u000f\u0005)Q\u000e\u001c7jE*\u0011\u0001\"C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0015-\ta!\u00199bG\",'\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001y1\u0003\u0005\u0002\u0011#5\tq!\u0003\u0002\u0013\u000f\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"\u0001F\f\u000e\u0003UQ!AF\u0003\u0002\tU$\u0018\u000e\\\u0005\u00031U\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0007\u0001")
public class HypothesisTestSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        HypothesisTestSuite hypothesisTestSuite = this;
        synchronized (hypothesisTestSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ Assertion $anonfun$new$10(HypothesisTestSuite $this, Seq data$1, int numParts) {
        ChiSqTestResult[] chi = Statistics$.MODULE$.chiSqTest($this.sc().parallelize(data$1, numParts, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        ChiSqTestResult feature1 = chi[0];
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)feature1.statistic()));
        double $org_scalatest_assert_macro_right = 0.75;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)feature1.degreesOfFreedom()));
        int $org_scalatest_assert_macro_right2 = 2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(feature1.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6873).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(feature1.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.6873).relTol(1.0E-4))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(feature1.method());
        String $org_scalatest_assert_macro_right3 = ChiSqTest$.MODULE$.PEARSON().name();
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(feature1.nullHypothesis());
        String $org_scalatest_assert_macro_right4 = ChiSqTest.NullHypothesis$.MODULE$.independence().toString();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        ChiSqTestResult feature2 = chi[1];
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)feature2.statistic()));
        double $org_scalatest_assert_macro_right5 = 1.5;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)feature2.degreesOfFreedom()));
        int $org_scalatest_assert_macro_right6 = 3;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(feature2.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6823).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(feature2.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.6823).relTol(1.0E-4))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(feature2.method());
        String $org_scalatest_assert_macro_right7 = ChiSqTest$.MODULE$.PEARSON().name();
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(feature2.nullHypothesis());
        String $org_scalatest_assert_macro_right8 = ChiSqTest.NullHypothesis$.MODULE$.independence().toString();
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
    }

    public HypothesisTestSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("chi squared pearson goodness of fit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseVector observed = new DenseVector((double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 6.0, 5.0}), ClassTag$.MODULE$.Double()));
            ChiSqTestResult pearson = Statistics$.MODULE$.chiSqTest((Vector)observed);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)pearson.statistic()));
            double $org_scalatest_assert_macro_right = 0.4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)pearson.degreesOfFreedom()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(pearson.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.8187).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(pearson.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.8187).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(pearson.method());
            String $org_scalatest_assert_macro_right3 = ChiSqTest$.MODULE$.PEARSON().name();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(pearson.nullHypothesis());
            String $org_scalatest_assert_macro_right4 = ChiSqTest.NullHypothesis$.MODULE$.goodnessOfFit().toString();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            DenseVector observed1 = new DenseVector((double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{21.0, 38.0, 43.0, 80.0}), ClassTag$.MODULE$.Double()));
            DenseVector expected1 = new DenseVector((double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 5.0, 7.0, 20.0}), ClassTag$.MODULE$.Double()));
            ChiSqTestResult pearson1 = Statistics$.MODULE$.chiSqTest((Vector)observed1, (Vector)expected1);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(pearson1.statistic()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(14.1429).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(pearson1.statistic).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(14.1429).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)pearson1.degreesOfFreedom()));
            int $org_scalatest_assert_macro_right5 = 3;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(pearson1.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.002717).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(pearson1.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.002717).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(pearson1.method());
            String $org_scalatest_assert_macro_right6 = ChiSqTest$.MODULE$.PEARSON().name();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(pearson1.nullHypothesis());
            String $org_scalatest_assert_macro_right7 = ChiSqTest.NullHypothesis$.MODULE$.goodnessOfFit().toString();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            DenseVector observed3 = new DenseVector(new double[]{1.0, 2.0, 3.0});
            DenseVector expected3 = new DenseVector(new double[]{1.0, 2.0, 3.0, 4.0});
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Statistics$.MODULE$.chiSqTest((Vector)observed3, (Vector)expected3), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            DenseVector negObs = new DenseVector(new double[]{1.0, 2.0, 3.0, -4.0});
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Statistics$.MODULE$.chiSqTest((Vector)negObs, (Vector)expected1), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            DenseVector zeroExpected = new DenseVector(new double[]{1.0, 0.0, 3.0});
            ChiSqTestResult inf = Statistics$.MODULE$.chiSqTest((Vector)observed, (Vector)zeroExpected);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)inf.statistic()));
            double $org_scalatest_assert_macro_right8 = Double.POSITIVE_INFINITY;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)inf.degreesOfFreedom()));
            int $org_scalatest_assert_macro_right9 = 2;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)inf.pValue()));
            double $org_scalatest_assert_macro_right10 = 0.0;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(inf.method());
            String $org_scalatest_assert_macro_right11 = ChiSqTest$.MODULE$.PEARSON().name();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(inf.nullHypothesis());
            String $org_scalatest_assert_macro_right12 = ChiSqTest.NullHypothesis$.MODULE$.goodnessOfFit().toString();
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            DenseVector zeroObserved = new DenseVector(new double[]{2.0, 0.0, 1.0});
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Statistics$.MODULE$.chiSqTest((Vector)zeroObserved, (Vector)zeroExpected), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        }, new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("chi squared pearson matrix independence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] data = new double[]{40.0, 24.0, 29.0, 56.0, 32.0, 42.0, 31.0, 10.0, 0.0, 30.0, 15.0, 12.0};
            ChiSqTestResult chi = Statistics$.MODULE$.chiSqTest(Matrices$.MODULE$.dense(3, 4, data));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(chi.statistic()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(21.9958).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(chi.statistic).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(21.9958).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)chi.degreesOfFreedom()));
            int $org_scalatest_assert_macro_right = 6;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(chi.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.001213).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(chi.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.001213).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(chi.method());
            String $org_scalatest_assert_macro_right2 = ChiSqTest$.MODULE$.PEARSON().name();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(chi.nullHypothesis());
            String $org_scalatest_assert_macro_right3 = ChiSqTest.NullHypothesis$.MODULE$.independence().toString();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            double[] negCounts = new double[]{4.0, 5.0, 3.0, -3.0};
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Statistics$.MODULE$.chiSqTest(Matrices$.MODULE$.dense(2, 2, negCounts)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            double[] rowZero = new double[]{0.0, 1.0, 0.0, 2.0};
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Statistics$.MODULE$.chiSqTest(Matrices$.MODULE$.dense(2, 2, rowZero)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            double[] colZero = new double[]{0.0, 0.0, 2.0, 2.0};
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Statistics$.MODULE$.chiSqTest(Matrices$.MODULE$.dense(2, 2, colZero)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        }, new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("chi squared pearson RDD[LabeledPoint]", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int tooManyCategories;
            Seq data = (Seq)new .colon.colon((Object)new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.0}))), (List)new .colon.colon((Object)new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{20.0}))), (List)new .colon.colon((Object)new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{30.0}))), (List)new .colon.colon((Object)new LabeledPoint(0.0, Vectors$.MODULE$.dense(3.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{30.0}))), (List)new .colon.colon((Object)new LabeledPoint(0.0, Vectors$.MODULE$.dense(3.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{40.0}))), (List)new .colon.colon((Object)new LabeledPoint(1.0, Vectors$.MODULE$.dense(3.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{40.0}))), (List)Nil$.MODULE$))))));
            List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 6, 8})).foreach((Function1 & Serializable & scala.Serializable)numParts -> HypothesisTestSuite.$anonfun$new$10(this, data, BoxesRunTime.unboxToInt((Object)numParts)));
            int numCols = 1001;
            LabeledPoint[] sparseData = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.sparse(numCols, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(100, 2.0), (List)Nil$.MODULE$))), new LabeledPoint(0.1, Vectors$.MODULE$.sparse(numCols, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(200, 1.0), (List)Nil$.MODULE$)))});
            SparkContext qual$1 = this.sc();
            WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])sparseData);
            int x$2 = qual$1.parallelize$default$2();
            ChiSqTestResult[] chi = Statistics$.MODULE$.chiSqTest(qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chi)).size()));
            int $org_scalatest_assert_macro_right = numCols;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            ChiSqTestResult $org_scalatest_assert_macro_left2 = chi[1000];
            Object $org_scalatest_assert_macro_right2 = null;
            ChiSqTestResult chiSqTestResult = $org_scalatest_assert_macro_left2;
            Object var14_13 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", null, chiSqTestResult == null ? var14_13 != null : !chiSqTestResult.equals(var14_13), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            int $org_scalatest_assert_macro_left3 = tooManyCategories = 100000;
            int $org_scalatest_assert_macro_right3 = ChiSqTest$.MODULE$.maxCategories();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"This unit test requires that tooManyCategories be large enough to cause ChiSqTest to throw an exception.", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            Random random = new Random(11L);
            Seq continuousLabel = (Seq)Seq$.MODULE$.fill(tooManyCategories, (Function0 & Serializable & scala.Serializable)() -> new LabeledPoint(random.nextDouble(), Vectors$.MODULE$.dense((double)random.nextInt(2), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Statistics$.MODULE$.chiSqTest(this.sc().parallelize(continuousLabel, 2, ClassTag$.MODULE$.apply(LabeledPoint.class))), ClassTag$.MODULE$.apply(SparkException.class), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            Seq continuousFeature = (Seq)Seq$.MODULE$.fill(tooManyCategories, (Function0 & Serializable & scala.Serializable)() -> new LabeledPoint((double)random.nextInt(2), Vectors$.MODULE$.dense(random.nextDouble(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))));
            return (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Statistics$.MODULE$.chiSqTest(this.sc().parallelize(continuousFeature, 2, ClassTag$.MODULE$.apply(LabeledPoint.class))), ClassTag$.MODULE$.apply(SparkException.class), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        }, new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("1 sample Kolmogorov-Smirnov test: apache commons math3 implementation equivalence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            NormalDistribution stdNormalDist = new NormalDistribution(0.0, 1.0);
            ExponentialDistribution expDist = new ExponentialDistribution(0.6);
            UniformRealDistribution unifDist = new UniformRealDistribution();
            long seed = 10L;
            stdNormalDist.reseedRandomGenerator(seed);
            expDist.reseedRandomGenerator(seed);
            unifDist.reseedRandomGenerator(seed);
            int n = 100000;
            RDD sampledNorm = this.sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray(stdNormalDist.sample(n)), 10, ClassTag$.MODULE$.Double());
            RDD sampledExp = this.sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray(expDist.sample(n)), 10, ClassTag$.MODULE$.Double());
            RDD sampledUnif = this.sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray(unifDist.sample(n)), 10, ClassTag$.MODULE$.Double());
            KolmogorovSmirnovTest ksTest = new KolmogorovSmirnovTest();
            double pThreshold = 0.05;
            KolmogorovSmirnovTestResult result1 = Statistics$.MODULE$.kolmogorovSmirnovTest(sampledNorm, "norm", (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0}));
            double referenceStat1 = ksTest.kolmogorovSmirnovStatistic((RealDistribution)stdNormalDist, (double[])sampledNorm.collect());
            double referencePVal1 = 1.0 - ksTest.cdf(referenceStat1, n);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(result1.statistic()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(referenceStat1).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(result1.statistic).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(referenceStat1).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(result1.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(referencePVal1).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(result1.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(referencePVal1).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            double $org_scalatest_assert_macro_left = result1.pValue();
            double $org_scalatest_assert_macro_right = pThreshold;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            KolmogorovSmirnovTestResult result2 = Statistics$.MODULE$.kolmogorovSmirnovTest(sampledExp, "norm", (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0}));
            double referenceStat2 = ksTest.kolmogorovSmirnovStatistic((RealDistribution)stdNormalDist, (double[])sampledExp.collect());
            double referencePVal2 = 1.0 - ksTest.cdf(referenceStat2, n);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(result2.statistic()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(referenceStat2).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(result2.statistic).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(referenceStat2).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(result2.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(referencePVal2).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(result2.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(referencePVal2).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            double $org_scalatest_assert_macro_left2 = result2.pValue();
            double $org_scalatest_assert_macro_right2 = pThreshold;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
            JFunction1.mcDD.sp & Serializable & scala.Serializable expCDF = (JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> new ExponentialDistribution(0.2).cumulativeProbability(x);
            KolmogorovSmirnovTestResult result3 = Statistics$.MODULE$.kolmogorovSmirnovTest(sampledExp, (Function1)expCDF);
            double referenceStat3 = ksTest.kolmogorovSmirnovStatistic((RealDistribution)new ExponentialDistribution(0.2), (double[])sampledExp.collect());
            double referencePVal3 = 1.0 - ksTest.cdf(referenceStat3, (int)sampledNorm.count());
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(result3.statistic()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(referenceStat3).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(result3.statistic).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(referenceStat3).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(result3.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(referencePVal3).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(result3.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(referencePVal3).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            double $org_scalatest_assert_macro_left3 = result3.pValue();
            double $org_scalatest_assert_macro_right3 = pThreshold;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        }, new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("1 sample Kolmogorov-Smirnov test: R implementation equivalence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double rKSStat = 0.18874;
            double rKSPVal = 0.4223;
            SparkContext qual$2 = this.sc();
            WrappedArray x$3 = Predef$.MODULE$.wrapDoubleArray(new double[]{1.1626852897838, -0.585924465893051, 1.78546500331661, -1.33259371048501, -0.446566766553219, 0.569606122374976, -2.88971761441412, -0.869018343326555, -0.461702683149641, -0.555540910137444, -0.0201353678515895, -0.150382224136063, -0.628126755843964, 1.32322085193283, -1.52135057001199, -0.437427868856691, 0.970577579543399, 0.0282226444247749, -0.0857821886527593, 0.389214404984942});
            int x$4 = qual$2.parallelize$default$2();
            RDD rData = qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.Double());
            KolmogorovSmirnovTestResult rCompResult = Statistics$.MODULE$.kolmogorovSmirnovTest(rData, "norm", (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(rCompResult.statistic()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(rKSStat).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(rCompResult.statistic).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(rKSStat).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(rCompResult.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(rKSPVal).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(rCompResult.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(rKSPVal).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        }, new Position("HypothesisTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
    }
}

