/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Enumeration;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TestUtils;
import org.apache.spark.TestUtils$;
import org.apache.spark.repl.ExecutorClassLoader;
import org.apache.spark.repl.RemoteClassLoaderError;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcEnv$;
import org.apache.spark.util.Utils$;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatestplus.mockito.MockitoSugar;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001\u0002\f\u0018\u0001\u0001BQ!\u000f\u0001\u0005\u0002iBq!\u0010\u0001C\u0002\u0013\u0005a\b\u0003\u0004R\u0001\u0001\u0006Ia\u0010\u0005\b%\u0002\u0011\r\u0011\"\u0001?\u0011\u0019\u0019\u0006\u0001)A\u0005\u007f!9A\u000b\u0001b\u0001\n\u0003q\u0004BB+\u0001A\u0003%q\bC\u0005W\u0001\u0001\u0007\t\u0019!C\u0001/\"Ia\f\u0001a\u0001\u0002\u0004%\ta\u0018\u0005\nM\u0002\u0001\r\u0011!Q!\naC\u0011b\u001a\u0001A\u0002\u0003\u0007I\u0011A,\t\u0013!\u0004\u0001\u0019!a\u0001\n\u0003I\u0007\"C6\u0001\u0001\u0004\u0005\t\u0015)\u0003Y\u0011%a\u0007\u00011AA\u0002\u0013\u0005Q\u000eC\u0005y\u0001\u0001\u0007\t\u0019!C\u0001s\"I1\u0010\u0001a\u0001\u0002\u0003\u0006KA\u001c\u0005\ny\u0002\u0001\r\u00111A\u0005\u0002uD1\"a\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0012!Q\u0011Q\u0003\u0001A\u0002\u0003\u0005\u000b\u0015\u0002@\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a!9\u00111\u0004\u0001\u0005B\u0005e!\u0001G#yK\u000e,Ho\u001c:DY\u0006\u001c8\u000fT8bI\u0016\u00148+^5uK*\u0011\u0001$G\u0001\u0005e\u0016\u0004HN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0019R\u0001A\u0011&WM\u0002\"AI\u0012\u000e\u0003eI!\u0001J\r\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t1\u0013&D\u0001(\u0015\tAS$A\u0005tG\u0006d\u0017\r^3ti&\u0011!f\n\u0002\u0012\u0005\u00164wN]3B]\u0012\fe\r^3s\u00032d\u0007C\u0001\u00172\u001b\u0005i#B\u0001\u00180\u0003\u001diwnY6ji>T!\u0001M\u000f\u0002\u001bM\u001c\u0017\r\\1uKN$\b\u000f\\;t\u0013\t\u0011TF\u0001\u0007N_\u000e\\\u0017\u000e^8Tk\u001e\f'\u000f\u0005\u00025o5\tQG\u0003\u000273\u0005A\u0011N\u001c;fe:\fG.\u0003\u00029k\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001<!\ta\u0004!D\u0001\u0018\u0003=\u0019\u0007.\u001b7e\u00072\f7o\u001d(b[\u0016\u001cX#A \u0011\u0007\u0001;\u0015*D\u0001B\u0015\t\u00115)A\u0005j[6,H/\u00192mK*\u0011A)R\u0001\u000bG>dG.Z2uS>t'\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!\u000b%\u0001\u0002'jgR\u0004\"AS(\u000e\u0003-S!\u0001T'\u0002\t1\fgn\u001a\u0006\u0002\u001d\u0006!!.\u0019<b\u0013\t\u00016J\u0001\u0004TiJLgnZ\u0001\u0011G\"LG\u000eZ\"mCN\u001ch*Y7fg\u0002\n\u0001\u0003]1sK:$8\t\\1tg:\u000bW.Z:\u0002#A\f'/\u001a8u\u00072\f7o\u001d(b[\u0016\u001c\b%A\nqCJ,g\u000e\u001e*fg>,(oY3OC6,7/\u0001\u000bqCJ,g\u000e\u001e*fg>,(oY3OC6,7\u000fI\u0001\ti\u0016l\u0007\u000fR5scU\t\u0001\f\u0005\u0002Z96\t!L\u0003\u0002\\\u001b\u0006\u0011\u0011n\\\u0005\u0003;j\u0013AAR5mK\u0006aA/Z7q\t&\u0014\u0018g\u0018\u0013fcR\u0011\u0001\r\u001a\t\u0003C\nl\u0011!R\u0005\u0003G\u0016\u0013A!\u00168ji\"9Q-CA\u0001\u0002\u0004A\u0016a\u0001=%c\u0005IA/Z7q\t&\u0014\u0018\u0007I\u0001\ti\u0016l\u0007\u000fR5se\u0005aA/Z7q\t&\u0014(g\u0018\u0013fcR\u0011\u0001M\u001b\u0005\bK2\t\t\u00111\u0001Y\u0003%!X-\u001c9ESJ\u0014\u0004%\u0001\u0003ve2\fT#\u00018\u0011\u0005=4hB\u00019u!\t\tX)D\u0001s\u0015\t\u0019x$\u0001\u0004=e>|GOP\u0005\u0003k\u0016\u000ba\u0001\u0015:fI\u00164\u0017B\u0001)x\u0015\t)X)\u0001\u0005ve2\ft\fJ3r)\t\u0001'\u0010C\u0004f\u001f\u0005\u0005\t\u0019\u00018\u0002\u000bU\u0014H.\r\u0011\u0002\u000bU\u0014Hn\u001d\u001a\u0016\u0003y\u0004B!Y@\u0002\u0004%\u0019\u0011\u0011A#\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003N\u0003\rqW\r^\u0005\u0005\u0003\u001b\t9AA\u0002V%2\u000b\u0011\"\u001e:mgJzF%Z9\u0015\u0007\u0001\f\u0019\u0002C\u0004f%\u0005\u0005\t\u0019\u0001@\u0002\rU\u0014Hn\u001d\u001a!\u0003%\u0011WMZ8sK\u0006cG\u000eF\u0001a\u0003!\tg\r^3s\u00032d\u0007")
public class ExecutorClassLoaderSuite
extends SparkFunSuite
implements MockitoSugar {
    private final List<String> childClassNames;
    private final List<String> parentClassNames;
    private final List<String> parentResourceNames;
    private File tempDir1;
    private File tempDir2;
    private String url1;
    private URL[] urls2;

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    public List<String> childClassNames() {
        return this.childClassNames;
    }

    public List<String> parentClassNames() {
        return this.parentClassNames;
    }

    public List<String> parentResourceNames() {
        return this.parentResourceNames;
    }

    public File tempDir1() {
        return this.tempDir1;
    }

    public void tempDir1_$eq(File x$1) {
        this.tempDir1 = x$1;
    }

    public File tempDir2() {
        return this.tempDir2;
    }

    public void tempDir2_$eq(File x$1) {
        this.tempDir2 = x$1;
    }

    public String url1() {
        return this.url1;
    }

    public void url1_$eq(String x$1) {
        this.url1 = x$1;
    }

    public URL[] urls2() {
        return this.urls2;
    }

    public void urls2_$eq(URL[] x$1) {
        this.urls2 = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.tempDir1_$eq(Utils$.MODULE$.createTempDir());
        this.tempDir2_$eq(Utils$.MODULE$.createTempDir());
        this.url1_$eq(this.tempDir1().toURI().toURL().toString());
        this.urls2_$eq((URL[])new .colon.colon((Object)this.tempDir2().toURI().toURL(), (List)Nil$.MODULE$).toArray(ClassTag$.MODULE$.apply(URL.class)));
        this.childClassNames().foreach((Function1 & Serializable & scala.Serializable)x$1 -> TestUtils$.MODULE$.createCompiledClass(x$1, this.tempDir1(), "1", TestUtils$.MODULE$.createCompiledClass$default$4(), TestUtils$.MODULE$.createCompiledClass$default$5(), TestUtils$.MODULE$.createCompiledClass$default$6(), TestUtils$.MODULE$.createCompiledClass$default$7()));
        this.parentResourceNames().foreach((Function1 & Serializable & scala.Serializable)x -> {
            ExecutorClassLoaderSuite.$anonfun$beforeAll$2(this, x);
            return BoxedUnit.UNIT;
        });
        this.parentClassNames().foreach((Function1 & Serializable & scala.Serializable)x$2 -> TestUtils$.MODULE$.createCompiledClass(x$2, this.tempDir2(), "2", TestUtils$.MODULE$.createCompiledClass$default$4(), TestUtils$.MODULE$.createCompiledClass$default$5(), TestUtils$.MODULE$.createCompiledClass$default$6(), TestUtils$.MODULE$.createCompiledClass$default$7()));
    }

    public void afterAll() {
        try {
            Utils$.MODULE$.deleteRecursively(this.tempDir1());
            Utils$.MODULE$.deleteRecursively(this.tempDir2());
            SparkEnv$.MODULE$.set(null);
        }
        finally {
            super.afterAll();
        }
    }

    public static final /* synthetic */ void $anonfun$beforeAll$2(ExecutorClassLoaderSuite $this, String x) {
        Files.write((byte[])"resource".getBytes(StandardCharsets.UTF_8), (File)new File($this.tempDir2(), x));
    }

    private final String callClassBFoo$1(ExecutorClassLoader classLoader$4) {
        Class<?> classB = Class.forName("TestClassB", true, (ClassLoader)classLoader$4);
        Object instanceOfTestClassB = classB.newInstance();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(instanceOfTestClassB.toString());
        String $org_scalatest_assert_macro_right = "TestClassB";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        return (String)classB.getMethod("foo", new Class[0]).invoke(instanceOfTestClassB, new Object[0]);
    }

    public ExecutorClassLoaderSuite() {
        MockitoSugar.$init$((MockitoSugar)this);
        this.childClassNames = new .colon.colon((Object)"ReplFakeClass1", (List)new .colon.colon((Object)"ReplFakeClass2", (List)Nil$.MODULE$));
        this.parentClassNames = new .colon.colon((Object)"ReplFakeClass1", (List)new .colon.colon((Object)"ReplFakeClass2", (List)new .colon.colon((Object)"ReplFakeClass3", (List)Nil$.MODULE$)));
        this.parentResourceNames = new .colon.colon((Object)"fake-resource.txt", (List)Nil$.MODULE$);
        this.test("child over system classloader", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SimpleJavaFileObject scalaOptionFile = new SimpleJavaFileObject(null){

                public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                    return "package scala; class Option {}";
                }
            };
            ToolProvider.getSystemJavaCompiler().getTask(null, null, null, null, null, Collections.singletonList(scalaOptionFile)).call();
            File scalaDir = new File(this.tempDir1(), "scala");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(scalaDir.mkdir(), "scalaDir.mkdir()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(38).append("Failed to create 'scala' directory in ").append(this.tempDir1()).toString(), Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            String filename = "Option.class";
            File result = new File(filename);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(result.exists(), "result.exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(25).append("Compiled file not found: ").append(result.getAbsolutePath()).toString(), Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            File out = new File(scalaDir, filename);
            Files.move((File)result, (File)out);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(out.exists(), "out.exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder(28).append("Destination file not moved: ").append(out.getAbsolutePath()).toString(), Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            URLClassLoader parentLoader = new URLClassLoader(this.urls2(), null);
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.url1(), (ClassLoader)parentLoader, true);
            Class<?> optionClass = Class.forName("scala.Option", false, (ClassLoader)classLoader);
            ClassLoader $org_scalatest_assert_macro_left = optionClass.getClassLoader();
            ExecutorClassLoader $org_scalatest_assert_macro_right = classLoader;
            ClassLoader classLoader2 = $org_scalatest_assert_macro_left;
            ExecutorClassLoader executorClassLoader = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(classLoader2 != null ? !classLoader2.equals(executorClassLoader) : executorClassLoader != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"scala.Option didn't come from ExecutorClassLoader", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("child first", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            URLClassLoader parentLoader = new URLClassLoader(this.urls2(), null);
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.url1(), (ClassLoader)parentLoader, true);
            Object fakeClass = classLoader.loadClass("ReplFakeClass2").getConstructor(new Class[0]).newInstance(new Object[0]);
            String fakeClassVersion = fakeClass.toString();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(fakeClassVersion);
            String $org_scalatest_assert_macro_right = "1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        this.test("parent first", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            URLClassLoader parentLoader = new URLClassLoader(this.urls2(), null);
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.url1(), (ClassLoader)parentLoader, false);
            Object fakeClass = classLoader.loadClass("ReplFakeClass1").getConstructor(new Class[0]).newInstance(new Object[0]);
            String fakeClassVersion = fakeClass.toString();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(fakeClassVersion);
            String $org_scalatest_assert_macro_right = "2";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("child first can fall back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            URLClassLoader parentLoader = new URLClassLoader(this.urls2(), null);
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.url1(), (ClassLoader)parentLoader, true);
            Object fakeClass = classLoader.loadClass("ReplFakeClass3").getConstructor(new Class[0]).newInstance(new Object[0]);
            String fakeClassVersion = fakeClass.toString();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(fakeClassVersion);
            String $org_scalatest_assert_macro_right = "2";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("child first can fail", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            URLClassLoader parentLoader = new URLClassLoader(this.urls2(), null);
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.url1(), (ClassLoader)parentLoader, true);
            return (ClassNotFoundException)this.intercept((Function0 & Serializable & scala.Serializable)() -> classLoader.loadClass("ReplFakeClassDoesNotExist").getConstructor(new Class[0]).newInstance(new Object[0]), ClassTag$.MODULE$.apply(ClassNotFoundException.class), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.test("resource from parent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InputStream is;
            URLClassLoader parentLoader = new URLClassLoader(this.urls2(), null);
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.url1(), (ClassLoader)parentLoader, true);
            String resourceName = (String)this.parentResourceNames().head();
            InputStream $org_scalatest_assert_macro_left = is = classLoader.getResourceAsStream(resourceName);
            Object $org_scalatest_assert_macro_right = null;
            InputStream inputStream = $org_scalatest_assert_macro_left;
            Object var8_7 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, inputStream == null ? var8_7 != null : !inputStream.equals(var8_7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append("Resource ").append(resourceName).append(" not found").toString(), Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            BufferedSource bufferedSource = Source$.MODULE$.fromInputStream(is, StandardCharsets.UTF_8.name());
            return (Assertion)Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> {
                String content;
                String $org_scalatest_assert_macro_left = content = (String)bufferedSource.getLines().next();
                String $org_scalatest_assert_macro_right = "resource";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"File doesn't contain 'resource'", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> bufferedSource.close());
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("resources from parent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            URLClassLoader parentLoader = new URLClassLoader(this.urls2(), null);
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.url1(), (ClassLoader)parentLoader, true);
            String resourceName = (String)this.parentResourceNames().head();
            Enumeration resources = classLoader.getResources(resourceName);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(resources.hasMoreElements(), "resources.hasMoreElements()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append("Resource ").append(resourceName).append(" not found").toString(), Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            BufferedSource bufferedSource = Source$.MODULE$.fromInputStream(((URL)resources.nextElement()).openStream(), Codec$.MODULE$.fallbackSystemCodec());
            return (Assertion)Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> {
                BufferedReader fileReader = bufferedSource.bufferedReader();
                String $org_scalatest_assert_macro_left = fileReader.readLine();
                String $org_scalatest_assert_macro_right = "resource";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"File doesn't contain 'resource'", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> bufferedSource.close());
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("fetch classes using Spark's RpcEnv", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            SparkEnv env = (SparkEnv)this.mock(ClassTag$.MODULE$.apply(SparkEnv.class));
            RpcEnv rpcEnv = (RpcEnv)this.mock(ClassTag$.MODULE$.apply(RpcEnv.class));
            Mockito.when((Object)env.rpcEnv()).thenReturn((Object)rpcEnv);
            Mockito.when((Object)rpcEnv.openChannel(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
                URI uri = new URI((String)invocation.getArguments()[0]);
                Path path = Paths.get(this.tempDir1().getAbsolutePath(), new StringOps(Predef$.MODULE$.augmentString(uri.getPath())).stripPrefix("/"));
                if (path.toFile().exists()) {
                    return FileChannel.open(path, StandardOpenOption.READ);
                }
                ReadableByteChannel channel = (ReadableByteChannel)this.mock(ClassTag$.MODULE$.apply(ReadableByteChannel.class));
                Mockito.when((Object)BoxesRunTime.boxToInteger((int)channel.read((ByteBuffer)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new RuntimeException(new StringBuilder(24).append("Stream '").append(uri.getPath()).append("' was not found.").toString())});
                return channel;
            });
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), env, "spark://localhost:1234", this.getClass().getClassLoader(), false);
            Object fakeClass = classLoader.loadClass("ReplFakeClass2").getConstructor(new Class[0]).newInstance(new Object[0]);
            String fakeClassVersion = fakeClass.toString();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(fakeClassVersion);
            String $org_scalatest_assert_macro_right = "1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> classLoader.loadClass("ReplFakeClassDoesNotExist").getConstructor(new Class[0]).newInstance(new Object[0]), ClassTag$.MODULE$.apply(ClassNotFoundException.class), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            try (InputStream fakeClassInputStream = classLoader.getResourceAsStream("ReplFakeClass2.class");){
                byte[] magic = new byte[4];
                fakeClassInputStream.read(magic);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(magic);
                byte[] $org_scalatest_assert_macro_right2 = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)202, (byte)254, (byte)186, (byte)190}), ClassTag$.MODULE$.Byte());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            }
            return assertion;
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        this.test("nonexistent class and transient errors should cause different errors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            SparkConf conf = new SparkConf().setMaster("local").setAppName("executor-class-loader-test").set("spark.network.timeout", "11s").set("spark.network.timeoutInterval", "11s").set("spark.repl.class.outputDir", this.tempDir1().getAbsolutePath());
            SparkContext sc = new SparkContext(conf);
            try {
                String replClassUri = sc.conf().get("spark.repl.class.uri");
                RpcEnv rpcEnv = RpcEnv$.MODULE$.create(SparkEnv$.MODULE$.executorSystemName(), "localhost", "localhost", 0, sc.conf(), new SecurityManager(conf, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), 0, true);
                try {
                    SparkEnv env = (SparkEnv)this.mock(ClassTag$.MODULE$.apply(SparkEnv.class));
                    Mockito.when((Object)env.rpcEnv()).thenReturn((Object)rpcEnv);
                    ExecutorClassLoader classLoader = new ExecutorClassLoader(conf, env, replClassUri, this.getClass().getClassLoader(), false);
                    this.intercept((Function0 & Serializable & scala.Serializable)() -> classLoader.loadClass("NonexistentClass"), ClassTag$.MODULE$.apply(ClassNotFoundException.class), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
                    sc.stop();
                    RemoteClassLoaderError e = (RemoteClassLoaderError)this.intercept((Function0 & Serializable & scala.Serializable)() -> classLoader.loadClass("ThisIsAClassName"), ClassTag$.MODULE$.apply(RemoteClassLoaderError.class), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
                    String $org_scalatest_assert_macro_left = e.getMessage();
                    String $org_scalatest_assert_macro_right = "ThisIsAClassName";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(LinkageError.class.isAssignableFrom(e.getClass()), "classOf[java.lang.LinkageError].isAssignableFrom(e.getClass())", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ClassNotFoundException.class.isAssignableFrom(e.getClass()), "classOf[java.lang.ClassNotFoundException].isAssignableFrom(e.getClass())", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
                }
                finally {
                    rpcEnv.shutdown();
                    rpcEnv.awaitTermination();
                }
            }
            finally {
                sc.stop();
            }
            return assertion;
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        this.test("SPARK-20547 ExecutorClassLoader should not throw ClassNotFoundException without acknowledgment from driver", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            File tempDir = Utils$.MODULE$.createTempDir();
            try {
                String sourceCodeOfClassA = new StringOps(Predef$.MODULE$.augmentString("public class TestClassA implements java.io.Serializable {\n          |  @Override public String toString() { return \"TestClassA\"; }\n          |}")).stripMargin();
                TestUtils.JavaSourceFromString sourceFileA = new TestUtils.JavaSourceFromString("TestClassA", sourceCodeOfClassA);
                TestUtils$.MODULE$.createCompiledClass(sourceFileA.name(), tempDir, sourceFileA, (Seq)new .colon.colon((Object)tempDir.toURI().toURL(), (List)Nil$.MODULE$));
                String sourceCodeOfClassB = new StringOps(Predef$.MODULE$.augmentString("public class TestClassB implements java.io.Serializable {\n        |  public String foo() { return new TestClassA().toString(); }\n        |  @Override public String toString() { return \"TestClassB\"; }\n        |}")).stripMargin();
                TestUtils.JavaSourceFromString sourceFileB = new TestUtils.JavaSourceFromString("TestClassB", sourceCodeOfClassB);
                TestUtils$.MODULE$.createCompiledClass(sourceFileB.name(), tempDir, sourceFileB, (Seq)new .colon.colon((Object)tempDir.toURI().toURL(), (List)Nil$.MODULE$));
                SparkEnv env = (SparkEnv)this.mock(ClassTag$.MODULE$.apply(SparkEnv.class));
                RpcEnv rpcEnv = (RpcEnv)this.mock(ClassTag$.MODULE$.apply(RpcEnv.class));
                Mockito.when((Object)env.rpcEnv()).thenReturn((Object)rpcEnv);
                Mockito.when((Object)rpcEnv.openChannel(ArgumentMatchers.anyString())).thenAnswer((Answer)new Answer<ReadableByteChannel>(this, tempDir){
                    private int count;
                    private final /* synthetic */ ExecutorClassLoaderSuite $outer;
                    private final File tempDir$1;

                    private int count() {
                        return this.count;
                    }

                    private void count_$eq(int x$1) {
                        this.count = x$1;
                    }

                    public ReadableByteChannel answer(InvocationOnMock invocation) {
                        URI uri = new URI((String)invocation.getArguments()[0]);
                        String classFileName = new StringOps(Predef$.MODULE$.augmentString(uri.getPath())).stripPrefix("/");
                        if (this.count() == 0) {
                            String string = classFileName;
                            String string2 = "TestClassA.class";
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                this.count_$eq(this.count() + 1);
                                ReadableByteChannel channel = (ReadableByteChannel)this.$outer.mock(ClassTag$.MODULE$.apply(ReadableByteChannel.class));
                                Mockito.when((Object)BoxesRunTime.boxToInteger((int)channel.read((ByteBuffer)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new IOException("broken pipe")});
                                return channel;
                            }
                        }
                        Path path = Paths.get(this.tempDir$1.getAbsolutePath(), classFileName);
                        return FileChannel.open(path, StandardOpenOption.READ);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tempDir$1 = tempDir$1;
                        this.count = 0;
                    }
                });
                ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), env, "spark://localhost:1234", this.getClass().getClassLoader(), false);
                InvocationTargetException e = (InvocationTargetException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.callClassBFoo$1(classLoader), ClassTag$.MODULE$.apply(InvocationTargetException.class), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
                Throwable $org_scalatest_assert_macro_left = e.getCause();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.repl.RemoteClassLoaderError", $org_scalatest_assert_macro_left instanceof RemoteClassLoaderError, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
                Throwable $org_scalatest_assert_macro_left2 = e.getCause().getCause();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "java.io.IOException", $org_scalatest_assert_macro_left2 instanceof IOException, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
                String $org_scalatest_assert_macro_left3 = e.getCause().getMessage();
                String $org_scalatest_assert_macro_right = "TestClassA";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.callClassBFoo$1(classLoader));
                String $org_scalatest_assert_macro_right2 = "TestClassA";
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return assertion;
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
    }
}

