/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeCalculator$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001y4Q\u0001D\u0007\u0001\u001b]A\u0001B\b\u0001\u0003\u0006\u0004%\t\u0001\t\u0005\tO\u0001\u0011\t\u0011)A\u0005C!)\u0001\u0006\u0001C\u0001S!)Q\u0006\u0001C\u0001]!91\nAI\u0001\n\u0003a\u0005\"B,\u0001\t\u0013A\u0006\"\u00022\u0001\t\u0013\u0019wA\u00029\u000e\u0011\u0003i\u0011O\u0002\u0004\r\u001b!\u0005QB\u001d\u0005\u0006Q%!\ta\u001d\u0005\u0006i&!\t!\u001e\u0002\u001b\u0017\u000647.Y(gMN,GOU1oO\u0016\u001c\u0015\r\\2vY\u0006$xN\u001d\u0006\u0003\u001d=\t\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003!E\t1a]9m\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7C\u0001\u0001\u0019!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fM\u0006iQ.\u001b8QCJ$\u0018\u000e^5p]N\u001c\u0001!F\u0001\"!\rI\"\u0005J\u0005\u0003Gi\u0011aa\u00149uS>t\u0007CA\r&\u0013\t1#DA\u0002J]R\fa\"\\5o!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003U1\u0002\"a\u000b\u0001\u000e\u00035AQAH\u0002A\u0002\u0005\n\u0011bZ3u%\u0006tw-Z:\u0015\u0007=r\u0004\tE\u00021qmr!!\r\u001c\u000f\u0005I*T\"A\u001a\u000b\u0005Qz\u0012A\u0002\u001fs_>$h(C\u0001\u001c\u0013\t9$$A\u0004qC\u000e\\\u0017mZ3\n\u0005eR$aA*fc*\u0011qG\u0007\t\u0003WqJ!!P\u0007\u0003!-\u000bgm[1PM\u001a\u001cX\r\u001e*b]\u001e,\u0007\"B \u0005\u0001\u0004y\u0013A\u0002:b]\u001e,7\u000fC\u0004B\tA\u0005\t\u0019\u0001\"\u0002#\u0015DXmY;u_JdunY1uS>t7\u000fE\u00021q\r\u0003\"\u0001\u0012%\u000f\u0005\u00153\u0005C\u0001\u001a\u001b\u0013\t9%$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0013*\u0013aa\u0015;sS:<'BA$\u001b\u0003M9W\r\u001e*b]\u001e,7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005i%F\u0001\"OW\u0005y\u0005C\u0001)V\u001b\u0005\t&B\u0001*T\u0003%)hn\u00195fG.,GM\u0003\u0002U5\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\u000b&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006aq-\u001a;QCJ$8i\\;oiR!A%\u00170a\u0011\u0015Qf\u00011\u0001\\\u0003\u0011\u0019\u0018N_3\u0011\u0005ea\u0016BA/\u001b\u0005\u0011auN\\4\t\u000b}3\u0001\u0019A.\u0002\u0013Q|G/\u00197TSj,\u0007\"B1\u0007\u0001\u0004!\u0013\u0001C7j]B\u000b'\u000f^:\u0002\u0017\u001d,G\u000fT8dCRLwN\u001c\u000b\u0004I\u0016|\u0007cA\r#\u0007\")am\u0002a\u0001O\u0006\u0011A\u000f\u001d\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\faaY8n[>t'B\u00017\u0014\u0003\u0015Y\u0017MZ6b\u0013\tq\u0017N\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000b\u0005;\u0001\u0019\u0001\"\u00025-\u000bgm[1PM\u001a\u001cX\r\u001e*b]\u001e,7)\u00197dk2\fGo\u001c:\u0011\u0005-J1CA\u0005\u0019)\u0005\t\u0018!B1qa2LHC\u0001\u0016w\u0011\u001598\u00021\u0001y\u0003\u001dy\u0007\u000f^5p]N\u0004\"!\u001f?\u000e\u0003iT!a_\b\u0002\tU$\u0018\u000e\\\u0005\u0003{j\u0014\u0001dQ1tK&s7/\u001a8tSRLg/Z*ue&tw-T1q\u0001")
public class KafkaOffsetRangeCalculator {
    private final Option<Object> minPartitions;

    public static KafkaOffsetRangeCalculator apply(CaseInsensitiveStringMap caseInsensitiveStringMap) {
        return KafkaOffsetRangeCalculator$.MODULE$.apply(caseInsensitiveStringMap);
    }

    public Option<Object> minPartitions() {
        return this.minPartitions;
    }

    public Seq<KafkaOffsetRange> getRanges(Seq<KafkaOffsetRange> ranges, Seq<String> executorLocations) {
        Seq offsetRanges = (Seq)ranges.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetRangeCalculator.$anonfun$getRanges$1(x$1)));
        if (this.minPartitions().isEmpty() || offsetRanges.size() >= BoxesRunTime.unboxToInt((Object)this.minPartitions().get())) {
            return (Seq)offsetRanges.map((Function1 & Serializable & scala.Serializable)range -> {
                Option<String> x$1 = this.getLocation(range.topicPartition(), executorLocations);
                TopicPartition x$2 = range.copy$default$1();
                long x$3 = range.copy$default$2();
                long x$4 = range.copy$default$3();
                return range.copy(x$2, x$3, x$4, x$1);
            }, Seq$.MODULE$.canBuildFrom());
        }
        long totalSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)offsetRanges.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Seq unsplitRanges = (Seq)offsetRanges.filter((Function1 & Serializable & scala.Serializable)range -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetRangeCalculator.$anonfun$getRanges$4(this, totalSize, range)));
        long unsplitRangeTotalSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)unsplitRanges.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long splitRangeTotalSize = totalSize - unsplitRangeTotalSize;
        Set unsplitRangeTopicPartitions = ((TraversableOnce)unsplitRanges.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.topicPartition(), Seq$.MODULE$.canBuildFrom())).toSet();
        int splitRangeMinPartitions = package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)this.minPartitions().get()) - unsplitRanges.size(), 1);
        return (Seq)((TraversableLike)offsetRanges.flatMap((Function1 & Serializable & scala.Serializable)range -> {
            TopicPartition tp = range.topicPartition();
            long size = range.size();
            int parts = unsplitRangeTopicPartitions.contains((Object)tp) ? 1 : this.getPartCount(size, splitRangeTotalSize, splitRangeMinPartitions);
            LongRef remaining = LongRef.create((long)size);
            LongRef startOffset = LongRef.create((long)range.fromOffset());
            return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), parts).map((Function1 & Serializable & scala.Serializable)part -> KafkaOffsetRangeCalculator.$anonfun$getRanges$8(remaining, parts, startOffset, range, tp, BoxesRunTime.unboxToInt((Object)part)), IndexedSeq$.MODULE$.canBuildFrom());
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetRangeCalculator.$anonfun$getRanges$9(x$5)));
    }

    public Seq<String> getRanges$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    private int getPartCount(long size, long totalSize, int minParts) {
        return (int)package$.MODULE$.max(package$.MODULE$.round((double)size / (double)totalSize * (double)minParts), 1L);
    }

    private Option<String> getLocation(TopicPartition tp, Seq<String> executorLocations) {
        int numExecutors = executorLocations.length();
        if (numExecutors > 0) {
            return new Some(executorLocations.apply(KafkaOffsetRangeCalculator.floorMod$1(tp.hashCode(), numExecutors)));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getRanges$1(KafkaOffsetRange x$1) {
        return x$1.size() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$getRanges$4(KafkaOffsetRangeCalculator $this, long totalSize$1, KafkaOffsetRange range) {
        return $this.getPartCount(range.size(), totalSize$1, BoxesRunTime.unboxToInt((Object)$this.minPartitions().get())) == 1;
    }

    public static final /* synthetic */ KafkaOffsetRange $anonfun$getRanges$8(LongRef remaining$1, int parts$1, LongRef startOffset$1, KafkaOffsetRange range$1, TopicPartition tp$1, int part) {
        long thisPartition = remaining$1.elem / (long)(parts$1 - part);
        remaining$1.elem -= thisPartition;
        long endOffset = package$.MODULE$.min(startOffset$1.elem + thisPartition, range$1.untilOffset());
        KafkaOffsetRange offsetRange = new KafkaOffsetRange(tp$1, startOffset$1.elem, endOffset, (Option<String>)None$.MODULE$);
        startOffset$1.elem = endOffset;
        return offsetRange;
    }

    public static final /* synthetic */ boolean $anonfun$getRanges$9(KafkaOffsetRange x$5) {
        return x$5.size() > 0L;
    }

    private static final int floorMod$1(long a, int b) {
        return ((int)(a % (long)b) + b) % b;
    }

    public KafkaOffsetRangeCalculator(Option<Object> minPartitions) {
        this.minPartitions = minPartitions;
        Predef$.MODULE$.require(minPartitions.isEmpty() || BoxesRunTime.unboxToInt((Object)minPartitions.get()) > 0);
    }
}

