/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010.consumer;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager$;
import org.apache.spark.internal.Logging;
import org.apache.spark.kafka010.KafkaTokenUtil$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.consumer.FetchedData;
import org.apache.spark.sql.kafka010.consumer.FetchedDataPool;
import org.apache.spark.sql.kafka010.consumer.FetchedRecord;
import org.apache.spark.sql.kafka010.consumer.InternalKafkaConsumer;
import org.apache.spark.sql.kafka010.consumer.InternalKafkaConsumerPool;
import org.apache.spark.sql.kafka010.consumer.KafkaDataConsumer$;
import org.apache.spark.util.UninterruptibleThread;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\rMh!\u00026l\u00015<\bBCA\u0005\u0001\t\u0005\t\u0015!\u0003\u0002\u000e!Q\u0011Q\u0004\u0001\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005E\u0003A!A!\u0002\u0013\t\u0019\u0006\u0003\u0006\u0002\\\u0001\u0011\t\u0011)A\u0005\u0003;Bq!a\u0019\u0001\t\u0003\t)\u0007C\u0005\u0002r\u0001\u0001\r\u0011\"\u0003\u0002t!I\u00111\u0010\u0001A\u0002\u0013%\u0011Q\u0010\u0005\t\u0003\u0013\u0003\u0001\u0015)\u0003\u0002v!I\u00111\u0012\u0001A\u0002\u0013%\u00111\u000f\u0005\n\u0003\u001b\u0003\u0001\u0019!C\u0005\u0003\u001fC\u0001\"a%\u0001A\u0003&\u0011Q\u000f\u0005\n\u0003+\u0003!\u0019!C\u0005\u0003/C\u0001\"a(\u0001A\u0003%\u0011\u0011\u0014\u0005\u000b\u0003C\u0003\u0001\u0019!C\u0001W\u0006\r\u0006BCAY\u0001\u0001\u0007I\u0011A6\u00024\"A\u0011q\u0017\u0001!B\u0013\t)\u000bC\u0005\u0002B\u0002\u0001\r\u0011\"\u0003\u0002D\"I\u0011Q\u001a\u0001A\u0002\u0013%\u0011q\u001a\u0005\t\u0003'\u0004\u0001\u0015)\u0003\u0002F\"I\u0011q\u001b\u0001C\u0002\u0013%\u0011\u0011\u001c\u0005\t\u00037\u0004\u0001\u0015!\u0003\u00020!I\u0011Q\u001c\u0001C\u0002\u0013%\u0011q\u001c\u0005\t\u0007k\u0001\u0001\u0015!\u0003\u0002b\"I1q\u0007\u0001C\u0002\u0013%1\u0011\b\u0005\t\u0007\u0003\u0002\u0001\u0015!\u0003\u0004<!911\t\u0001\u0005\u0002\r\u0015\u0003bBB8\u0001\u0011\u00051\u0011\u000f\u0005\b\u0007k\u0002A\u0011AB<\u0011\u001d\u0019I\b\u0001C\u0001\u0007oBqaa\u001f\u0001\t\u0003\u0019i\bC\u0004\u0004\u0000\u0001!Ia! \t\u000f\r\u0005\u0005\u0001\"\u0003\u0004~!911\u0011\u0001\u0005\n\r\u0015\u0005bBBG\u0001\u0011%1q\u0012\u0005\b\u0007?\u0003A\u0011BBQ\u0011!\u0019Y\u000b\u0001C\u0001[\u000e5\u0006bBBX\u0001\u0011%1Q\u0010\u0005\b\u0007c\u0003A\u0011BBZ\u0011\u001d\u00199\f\u0001C\u0005\u0007sCqa!1\u0001\t\u0013\u0019\u0019\rC\u0005\u0004R\u0002\t\n\u0011\"\u0003\u00042!911\u001b\u0001\u0005\n\rUw\u0001CAsW\"\u0005Q.a:\u0007\u000f)\\\u0007\u0012A7\u0002j\"9\u00111\r\u0017\u0005\u0002\u0005-\b\"CAwY\t\u0007I\u0011AA:\u0011!\ty\u000f\fQ\u0001\n\u0005UdABAyY\u0001\u000b\u0019\u0010\u0003\u0006\u0003\u0002A\u0012)\u001a!C\u0001\u0003gB!Ba\u00011\u0005#\u0005\u000b\u0011BA;\u0011)\u0011)\u0001\rBK\u0002\u0013\u0005\u00111\u000f\u0005\u000b\u0005\u000f\u0001$\u0011#Q\u0001\n\u0005U\u0004bBA2a\u0011\u0005!\u0011\u0002\u0005\n\u0005'\u0001\u0014\u0011!C\u0001\u0005+A\u0011Ba\u00071#\u0003%\tA!\b\t\u0013\tM\u0002'%A\u0005\u0002\tu\u0001\"\u0003B\u001ba\u0005\u0005I\u0011\tB\u001c\u0011%\u0011i\u0004MA\u0001\n\u0003\u0011y\u0004C\u0005\u0003HA\n\t\u0011\"\u0001\u0003J!I!1\u000b\u0019\u0002\u0002\u0013\u0005#Q\u000b\u0005\n\u0005G\u0002\u0014\u0011!C\u0001\u0005KB\u0011B!\u001b1\u0003\u0003%\tEa\u001b\t\u0013\t5\u0004'!A\u0005B\t=\u0004\"\u0003B9a\u0005\u0005I\u0011\tB:\u000f%\u00119\bLA\u0001\u0012\u0003\u0011IHB\u0005\u0002r2\n\t\u0011#\u0001\u0003|!9\u00111\r\"\u0005\u0002\t%\u0005\"\u0003B7\u0005\u0006\u0005IQ\tB8\u0011%\u0011YIQA\u0001\n\u0003\u0013i\tC\u0005\u0003\u0014\n\u000b\t\u0011\"!\u0003\u0016\"I!1\u0015\"\u0002\u0002\u0013%!Q\u0015\u0004\u0007\u0005Oc\u0003I!+\t\u0015\u0005]\u0007J!f\u0001\n\u0003\tI\u000e\u0003\u0006\u0002\\\"\u0013\t\u0012)A\u0005\u0003_A!\"!\u0003I\u0005+\u0007I\u0011\u0001BV\u0011)\u0011i\u000b\u0013B\tB\u0003%\u0011Q\u0002\u0005\b\u0003GBE\u0011\u0001BX\u0011\u001d\t\u0019\u0007\u0013C\u0001\u0005oC\u0011Ba\u0005I\u0003\u0003%\tA!0\t\u0013\tm\u0001*%A\u0005\u0002\t\r\u0007\"\u0003B\u001a\u0011F\u0005I\u0011\u0001Bd\u0011%\u0011)\u0004SA\u0001\n\u0003\u00129\u0004C\u0005\u0003>!\u000b\t\u0011\"\u0001\u0003@!I!q\t%\u0002\u0002\u0013\u0005!1\u001a\u0005\n\u0005'B\u0015\u0011!C!\u0005+B\u0011Ba\u0019I\u0003\u0003%\tAa4\t\u0013\t%\u0004*!A\u0005B\t-\u0004\"\u0003B7\u0011\u0006\u0005I\u0011\tB8\u0011%\u0011\t\bSA\u0001\n\u0003\u0012\u0019nB\u0005\u0003X2\n\t\u0011#\u0001\u0003Z\u001aI!q\u0015\u0017\u0002\u0002#\u0005!1\u001c\u0005\b\u0003GZF\u0011\u0001Bp\u0011%\u0011igWA\u0001\n\u000b\u0012y\u0007C\u0005\u0003\fn\u000b\t\u0011\"!\u0003b\"I!1S.\u0002\u0002\u0013\u0005%q\u001d\u0005\n\u0005G[\u0016\u0011!C\u0005\u0005KC\u0011Ba<-\u0005\u0004%IA!=\t\u0011\tmH\u0006)A\u0005\u0005gD\u0011\"!\u0015-\u0005\u0004%IA!@\t\u0011\t}H\u0006)A\u0005\u0003'B\u0011\"a\u0017-\u0005\u0004%Ia!\u0001\t\u0011\r\rA\u0006)A\u0005\u0003;Bqa!\u0002-\t\u0003\u00199\u0001C\u0004\u0004\u000e1\"Iaa\u0004\t\u0013\r=B&%A\u0005\n\rE\"!E&bM.\fG)\u0019;b\u0007>t7/^7fe*\u0011A.\\\u0001\tG>t7/^7fe*\u0011an\\\u0001\tW\u000647.\u0019\u00192a)\u0011\u0001/]\u0001\u0004gFd'B\u0001:t\u0003\u0015\u0019\b/\u0019:l\u0015\t!X/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0006\u0019qN]4\u0014\u0007\u0001Ah\u0010\u0005\u0002zy6\t!PC\u0001|\u0003\u0015\u00198-\u00197b\u0013\ti(P\u0001\u0004B]f\u0014VM\u001a\t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019!]\u0001\tS:$XM\u001d8bY&!\u0011qAA\u0001\u0005\u001daunZ4j]\u001e\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u0001\u0001\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u000511m\\7n_:T1!a\u0006t\u0003\u0015Y\u0017MZ6b\u0013\u0011\tY\"!\u0005\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006Y1.\u00194lCB\u000b'/Y7t!!\t\t#a\u000b\u00020\u0005\u0015SBAA\u0012\u0015\u0011\t)#a\n\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003S\tAA[1wC&!\u0011QFA\u0012\u0005\ri\u0015\r\u001d\t\u0005\u0003c\tyD\u0004\u0003\u00024\u0005m\u0002cAA\u001bu6\u0011\u0011q\u0007\u0006\u0005\u0003s\tY!\u0001\u0004=e>|GOP\u0005\u0004\u0003{Q\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002B\u0005\r#AB*ue&twMC\u0002\u0002>i\u0004B!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\n9#\u0001\u0003mC:<\u0017\u0002BA(\u0003\u0013\u0012aa\u00142kK\u000e$\u0018\u0001D2p]N,X.\u001a:Q_>d\u0007\u0003BA+\u0003/j\u0011a[\u0005\u0004\u00033Z'!G%oi\u0016\u0014h.\u00197LC\u001a\\\u0017mQ8ogVlWM\u001d)p_2\fqBZ3uG\",G\rR1uCB{w\u000e\u001c\t\u0005\u0003+\ny&C\u0002\u0002b-\u0014qBR3uG\",G\rR1uCB{w\u000e\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005\u001d\u0014\u0011NA6\u0003[\ny\u0007E\u0002\u0002V\u0001Aq!!\u0003\u0006\u0001\u0004\ti\u0001C\u0004\u0002\u001e\u0015\u0001\r!a\b\t\u000f\u0005ES\u00011\u0001\u0002T!9\u00111L\u0003A\u0002\u0005u\u0013\u0001E8gMN,GoT;u\u001f\u001a\u0014\u0016M\\4f+\t\t)\bE\u0002z\u0003oJ1!!\u001f{\u0005\u0011auN\\4\u0002)=4gm]3u\u001fV$xJ\u001a*b]\u001e,w\fJ3r)\u0011\ty(!\"\u0011\u0007e\f\t)C\u0002\u0002\u0004j\u0014A!\u00168ji\"I\u0011qQ\u0004\u0002\u0002\u0003\u0007\u0011QO\u0001\u0004q\u0012\n\u0014!E8gMN,GoT;u\u001f\u001a\u0014\u0016M\\4fA\u0005AA-\u0019;b\u0019>\u001c8/\u0001\u0007eCR\fGj\\:t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0000\u0005E\u0005\"CAD\u0015\u0005\u0005\t\u0019AA;\u0003%!\u0017\r^1M_N\u001c\b%\u0001\fjgR{7.\u001a8Qe>4\u0018\u000eZ3s\u000b:\f'\r\\3e+\t\tI\nE\u0002z\u00037K1!!({\u0005\u001d\u0011un\u001c7fC:\fq#[:U_.,g\u000e\u0015:pm&$WM]#oC\ndW\r\u001a\u0011\u0002\u0013}\u001bwN\\:v[\u0016\u0014XCAAS!\u0015I\u0018qUAV\u0013\r\tIK\u001f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005U\u0013QV\u0005\u0004\u0003_['!F%oi\u0016\u0014h.\u00197LC\u001a\\\u0017mQ8ogVlWM]\u0001\u000e?\u000e|gn];nKJ|F%Z9\u0015\t\u0005}\u0014Q\u0017\u0005\n\u0003\u000f{\u0011\u0011!a\u0001\u0003K\u000b!bX2p]N,X.\u001a:!Q\r\u0001\u00121\u0018\t\u0004s\u0006u\u0016bAA`u\nAao\u001c7bi&dW-\u0001\u0007`M\u0016$8\r[3e\t\u0006$\u0018-\u0006\u0002\u0002FB)\u00110a*\u0002HB!\u0011QKAe\u0013\r\tYm\u001b\u0002\f\r\u0016$8\r[3e\t\u0006$\u0018-\u0001\t`M\u0016$8\r[3e\t\u0006$\u0018m\u0018\u0013fcR!\u0011qPAi\u0011%\t9IEA\u0001\u0002\u0004\t)-A\u0007`M\u0016$8\r[3e\t\u0006$\u0018\r\t\u0015\u0004'\u0005m\u0016aB4s_V\u0004\u0018\nZ\u000b\u0003\u0003_\t\u0001b\u001a:pkBLE\rI\u0001\tG\u0006\u001c\u0007.Z&fsV\u0011\u0011\u0011\u001d\t\u0004\u0003GDebAA+W\u0005\t2*\u00194lC\u0012\u000bG/Y\"p]N,X.\u001a:\u0011\u0007\u0005UCfE\u0002-qz$\"!a:\u0002\u001dUs5JT(X\u001d~{eIR*F)\u0006yQKT&O\u001f^sul\u0014$G'\u0016#\u0006E\u0001\u000bBm\u0006LG.\u00192mK>3gm]3u%\u0006tw-Z\n\u0007aa\f)0a?\u0011\u0007e\f90C\u0002\u0002zj\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002z\u0003{L1!a@{\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003!)\u0017M\u001d7jKN$\u0018!C3be2LWm\u001d;!\u0003\u0019a\u0017\r^3ti\u00069A.\u0019;fgR\u0004CC\u0002B\u0006\u0005\u001f\u0011\t\u0002E\u0002\u0003\u000eAj\u0011\u0001\f\u0005\b\u0005\u0003)\u0004\u0019AA;\u0011\u001d\u0011)!\u000ea\u0001\u0003k\nAaY8qsR1!1\u0002B\f\u00053A\u0011B!\u00017!\u0003\u0005\r!!\u001e\t\u0013\t\u0015a\u0007%AA\u0002\u0005U\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005?QC!!\u001e\u0003\"-\u0012!1\u0005\t\u0005\u0005K\u0011y#\u0004\u0002\u0003()!!\u0011\u0006B\u0016\u0003%)hn\u00195fG.,GMC\u0002\u0003.i\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tDa\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011I\u0004\u0005\u0003\u0002H\tm\u0012\u0002BA!\u0003\u0013\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!\u0011\u0011\u0007e\u0014\u0019%C\u0002\u0003Fi\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u0013\u0003RA\u0019\u0011P!\u0014\n\u0007\t=#PA\u0002B]fD\u0011\"a\"<\u0003\u0003\u0005\rA!\u0011\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0016\u0011\r\te#q\fB&\u001b\t\u0011YFC\u0002\u0003^i\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\tGa\u0017\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u00033\u00139\u0007C\u0005\u0002\bv\n\t\u00111\u0001\u0003L\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003B\u0005AAo\\*ue&tw\r\u0006\u0002\u0003:\u00051Q-];bYN$B!!'\u0003v!I\u0011q\u0011!\u0002\u0002\u0003\u0007!1J\u0001\u0015\u0003Z\f\u0017\u000e\\1cY\u0016|eMZ:fiJ\u000bgnZ3\u0011\u0007\t5!iE\u0003C\u0005{\nY\u0010\u0005\u0006\u0003\u0000\t\u0015\u0015QOA;\u0005\u0017i!A!!\u000b\u0007\t\r%0A\u0004sk:$\u0018.\\3\n\t\t\u001d%\u0011\u0011\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DC\u0001B=\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0011YAa$\u0003\u0012\"9!\u0011A#A\u0002\u0005U\u0004b\u0002B\u0003\u000b\u0002\u0007\u0011QO\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u00119Ja(\u0011\u000be\f9K!'\u0011\u000fe\u0014Y*!\u001e\u0002v%\u0019!Q\u0014>\u0003\rQ+\b\u000f\\33\u0011%\u0011\tKRA\u0001\u0002\u0004\u0011Y!A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\t\u0002\t\u0007\u0006\u001c\u0007.Z&fsN1\u0001\n_A{\u0003w,\"!!\u0004\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\"bA!-\u00034\nU\u0006c\u0001B\u0007\u0011\"9\u0011q['A\u0002\u0005=\u0002bBA\u0005\u001b\u0002\u0007\u0011Q\u0002\u000b\u0007\u0005c\u0013ILa/\t\u000f\u0005%a\n1\u0001\u0002\u000e!9\u0011Q\u0004(A\u0002\u0005}AC\u0002BY\u0005\u007f\u0013\t\rC\u0005\u0002X>\u0003\n\u00111\u0001\u00020!I\u0011\u0011B(\u0011\u0002\u0003\u0007\u0011QB\u000b\u0003\u0005\u000bTC!a\f\u0003\"U\u0011!\u0011\u001a\u0016\u0005\u0003\u001b\u0011\t\u0003\u0006\u0003\u0003L\t5\u0007\"CAD)\u0006\u0005\t\u0019\u0001B!)\u0011\tIJ!5\t\u0013\u0005\u001de+!AA\u0002\t-C\u0003BAM\u0005+D\u0011\"a\"Z\u0003\u0003\u0005\rAa\u0013\u0002\u0011\r\u000b7\r[3LKf\u00042A!\u0004\\'\u0015Y&Q\\A~!)\u0011yH!\"\u00020\u00055!\u0011\u0017\u000b\u0003\u00053$bA!-\u0003d\n\u0015\bbBAl=\u0002\u0007\u0011q\u0006\u0005\b\u0003\u0013q\u0006\u0019AA\u0007)\u0011\u0011IO!<\u0011\u000be\f9Ka;\u0011\u000fe\u0014Y*a\f\u0002\u000e!I!\u0011U0\u0002\u0002\u0003\u0007!\u0011W\u0001\ngB\f'o[\"p]\u001a,\"Aa=\u0011\t\tU(q_\u0007\u0002c&\u0019!\u0011`9\u0003\u0013M\u0003\u0018M]6D_:4\u0017AC:qCJ\\7i\u001c8gAU\u0011\u00111K\u0001\u000eG>t7/^7feB{w\u000e\u001c\u0011\u0016\u0005\u0005u\u0013\u0001\u00054fi\u000eDW\r\u001a#bi\u0006\u0004vn\u001c7!\u0003\u001d\t7-];je\u0016$b!a\u001a\u0004\n\r-\u0001bBA\u0005O\u0002\u0007\u0011Q\u0002\u0005\b\u0003;9\u0007\u0019AA\u0010\u0003=\u0011X\r]8si\u0012\u000bG/\u0019'pgN\u0004D\u0003CA@\u0007#\u0019)b!\u0007\t\u000f\rM\u0001\u000e1\u0001\u0002\u001a\u0006qa-Y5m\u001f:$\u0015\r^1M_N\u001c\bbBB\fQ\u0002\u0007\u0011qF\u0001\rM&t\u0017\r\\'fgN\fw-\u001a\u0005\n\u00077A\u0007\u0013!a\u0001\u0007;\tQaY1vg\u0016\u0004Baa\b\u0004*9!1\u0011EB\u0013\u001d\u0011\t)da\t\n\u0003mL1aa\n{\u0003\u001d\u0001\u0018mY6bO\u0016LAaa\u000b\u0004.\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0007OQ\u0018!\u0007:fa>\u0014H\u000fR1uC2{7o\u001d\u0019%I\u00164\u0017-\u001e7uIM*\"aa\r+\t\ru!\u0011E\u0001\nG\u0006\u001c\u0007.Z&fs\u0002\nQBZ3uG\",GMU3d_J$WCAB\u001e!\u0011\t)f!\u0010\n\u0007\r}2NA\u0007GKR\u001c\u0007.\u001a3SK\u000e|'\u000fZ\u0001\u000fM\u0016$8\r[3e%\u0016\u001cwN\u001d3!\u0003\r9W\r\u001e\u000b\u000b\u0007\u000f\u001a\tg!\u001a\u0004j\r5\u0004\u0003CB%\u0007#\u001a)f!\u0016\u000e\u0005\r-#b\u00017\u0004N)!1qJA\u000b\u0003\u001d\u0019G.[3oiNLAaa\u0015\u0004L\tq1i\u001c8tk6,'OU3d_J$\u0007#B=\u0004X\rm\u0013bAB-u\n)\u0011I\u001d:bsB\u0019\u0011p!\u0018\n\u0007\r}#P\u0001\u0003CsR,\u0007bBB25\u0001\u0007\u0011QO\u0001\u0007_\u001a47/\u001a;\t\u000f\r\u001d$\u00041\u0001\u0002v\u0005YQO\u001c;jY>3gm]3u\u0011\u001d\u0019YG\u0007a\u0001\u0003k\nQ\u0002]8mYRKW.Z8vi6\u001b\bbBB\n5\u0001\u0007\u0011\u0011T\u0001\u0018O\u0016$\u0018I^1jY\u0006\u0014G.Z(gMN,GOU1oO\u0016$\"aa\u001d\u0011\u0007\u0005\r\b'\u0001\fhKRtU/\\(gMN,GoT;u\u001f\u001a\u0014\u0016M\\4f)\t\t)(\u0001\bhKRtU/\u001c#bi\u0006dun]:\u0002\u000fI,G.Z1tKR\u0011\u0011qP\u0001\u0010e\u0016dW-Y:f\u0007>t7/^7fe\u0006\u0011\"/\u001a7fCN,g)\u001a;dQ\u0016$G)\u0019;b\u0003\u0005:W\r^#be2LWm\u001d;Bm\u0006LG.\u00192mK>3gm]3u\u0005\u0016$x/Z3o)!\t)ha\"\u0004\n\u000e-\u0005B\u00027\"\u0001\u0004\tY\u000bC\u0004\u0004d\u0005\u0002\r!!\u001e\t\u000f\r\u001d\u0014\u00051\u0001\u0002v\u0005Ya-\u001a;dQJ+7m\u001c:e)9\u0019Yd!%\u0004\u0014\u000e]5\u0011TBN\u0007;Ca\u0001\u001c\u0012A\u0002\u0005-\u0006bBBKE\u0001\u0007\u0011qY\u0001\fM\u0016$8\r[3e\t\u0006$\u0018\rC\u0004\u0004d\t\u0002\r!!\u001e\t\u000f\r\u001d$\u00051\u0001\u0002v!911\u000e\u0012A\u0002\u0005U\u0004bBB\nE\u0001\u0007\u0011\u0011T\u0001\nM\u0016$8\r\u001b#bi\u0006$\"\"a \u0004$\u000e\u00156qUBU\u0011\u0019a7\u00051\u0001\u0002,\"91QS\u0012A\u0002\u0005\u001d\u0007bBB2G\u0001\u0007\u0011Q\u000f\u0005\b\u0007W\u001a\u0003\u0019AA;\u0003U9W\r^(s%\u0016$(/[3wK\u000e{gn];nKJ$\"!a+\u0002!I,GO]5fm\u0016\u001cuN\\:v[\u0016\u0014\u0018\u0001G4fi>\u0013(+\u001a;sS\u00164XMR3uG\",G\rR1uCR!\u0011qYB[\u0011\u001d\u0019\u0019G\na\u0001\u0003k\n\u0011#\u00193eSRLwN\\1m\u001b\u0016\u001c8/Y4f)!\tyca/\u0004>\u000e}\u0006bBA\u0005O\u0001\u0007\u0011Q\u0002\u0005\b\u0003/<\u0003\u0019AA\u0018\u0011\u001d\u0019\u0019b\na\u0001\u00033\u000baB]3q_J$H)\u0019;b\u0019>\u001c8\u000f\u0006\u0007\u0002\u0000\r\u00157qYBe\u0007\u0017\u001cy\rC\u0004\u0002\n!\u0002\r!!\u0004\t\u000f\u0005]\u0007\u00061\u0001\u00020!911\u0003\u0015A\u0002\u0005e\u0005bBBgQ\u0001\u0007\u0011qF\u0001\b[\u0016\u001c8/Y4f\u0011%\u0019Y\u0002\u000bI\u0001\u0002\u0004\u0019i\"\u0001\rsKB|'\u000f\u001e#bi\u0006dun]:%I\u00164\u0017-\u001e7uIU\nAD];o+:Lg\u000e^3seV\u0004H/\u001b2ms&3\u0007k\\:tS\ndW-\u0006\u0003\u0004X\u000euG\u0003BBm\u0007S\u0004Baa7\u0004^2\u0001AaBBpU\t\u00071\u0011\u001d\u0002\u0002)F!11\u001dB&!\rI8Q]\u0005\u0004\u0007OT(a\u0002(pi\"Lgn\u001a\u0005\t\u0007WTC\u00111\u0001\u0004n\u0006!!m\u001c3z!\u0015I8q^Bm\u0013\r\u0019\tP\u001f\u0002\ty\tLh.Y7f}\u0001")
public class KafkaDataConsumer
implements Logging {
    private final TopicPartition topicPartition;
    private final Map<String, Object> kafkaParams;
    private final InternalKafkaConsumerPool consumerPool;
    private final FetchedDataPool fetchedDataPool;
    private long offsetOutOfRange;
    private long dataLoss;
    private final boolean isTokenProviderEnabled;
    private volatile Option<InternalKafkaConsumer> _consumer;
    private volatile Option<FetchedData> _fetchedData;
    private final String groupId;
    private final CacheKey cacheKey;
    private final FetchedRecord fetchedRecord;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KafkaDataConsumer acquire(TopicPartition topicPartition, Map<String, Object> map) {
        return KafkaDataConsumer$.MODULE$.acquire(topicPartition, map);
    }

    public static long UNKNOWN_OFFSET() {
        return KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long offsetOutOfRange() {
        return this.offsetOutOfRange;
    }

    private void offsetOutOfRange_$eq(long x$1) {
        this.offsetOutOfRange = x$1;
    }

    private long dataLoss() {
        return this.dataLoss;
    }

    private void dataLoss_$eq(long x$1) {
        this.dataLoss = x$1;
    }

    private boolean isTokenProviderEnabled() {
        return this.isTokenProviderEnabled;
    }

    public Option<InternalKafkaConsumer> _consumer() {
        return this._consumer;
    }

    public void _consumer_$eq(Option<InternalKafkaConsumer> x$1) {
        this._consumer = x$1;
    }

    private Option<FetchedData> _fetchedData() {
        return this._fetchedData;
    }

    private void _fetchedData_$eq(Option<FetchedData> x$1) {
        this._fetchedData = x$1;
    }

    private String groupId() {
        return this.groupId;
    }

    private CacheKey cacheKey() {
        return this.cacheKey;
    }

    private FetchedRecord fetchedRecord() {
        return this.fetchedRecord;
    }

    public ConsumerRecord<byte[], byte[]> get(long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        return (ConsumerRecord)this.runUninterruptiblyIfPossible((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(offset < untilOffset, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("offset must always be less than untilOffset [offset: ").append(offset).append(", untilOffset: ").append(untilOffset).append("]").toString());
            InternalKafkaConsumer consumer = this.getOrRetrieveConsumer();
            FetchedData fetchedData = this.getOrRetrieveFetchedData(offset);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Get ").append(this.groupId()).append(" ").append($this.topicPartition).append(" nextOffset ").append(fetchedData.nextOffsetInFetchedData()).append(" ").append("requested ").append(offset).toString());
            LongRef toFetchOffset = LongRef.create((long)offset);
            FetchedRecord fetchedRecord = null;
            boolean isFetchComplete = false;
            while (toFetchOffset.elem != KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET() && !isFetchComplete) {
                try {
                    fetchedRecord = this.fetchRecord(consumer, fetchedData, toFetchOffset.elem, untilOffset, pollTimeoutMs, failOnDataLoss);
                    if (fetchedRecord.record() != null) {
                        isFetchComplete = true;
                        continue;
                    }
                    toFetchOffset.elem = fetchedRecord.nextOffsetToFetch();
                    if (toFetchOffset.elem >= untilOffset) {
                        fetchedData.reset();
                        toFetchOffset.elem = KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
                        continue;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Skipped offsets [").append(offset).append(", ").append(toFetchOffset$1.elem).append("]").toString());
                }
                catch (OffsetOutOfRangeException e) {
                    this.releaseConsumer();
                    fetchedData.reset();
                    this.reportDataLoss($this.topicPartition, this.groupId(), failOnDataLoss, new StringBuilder(20).append("Cannot fetch offset ").append(toFetchOffset.elem).toString(), e);
                    long oldToFetchOffsetd = toFetchOffset.elem;
                    toFetchOffset.elem = this.getEarliestAvailableOffsetBetween(consumer, toFetchOffset.elem, untilOffset);
                    if (toFetchOffset.elem == KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET()) {
                        this.offsetOutOfRange_$eq(this.offsetOutOfRange() + (untilOffset - oldToFetchOffsetd));
                        continue;
                    }
                    this.offsetOutOfRange_$eq(this.offsetOutOfRange() + (toFetchOffset.elem - oldToFetchOffsetd));
                }
            }
            if (isFetchComplete) {
                return fetchedRecord.record();
            }
            fetchedData.reset();
            return null;
        });
    }

    public AvailableOffsetRange getAvailableOffsetRange() {
        return (AvailableOffsetRange)this.runUninterruptiblyIfPossible((Function0 & Serializable & scala.Serializable)() -> {
            InternalKafkaConsumer consumer = this.getOrRetrieveConsumer();
            return consumer.getAvailableOffsetRange();
        });
    }

    public long getNumOffsetOutOfRange() {
        return this.offsetOutOfRange();
    }

    public long getNumDataLoss() {
        return this.dataLoss();
    }

    public void release() {
        this.releaseConsumer();
        this.releaseFetchedData();
    }

    private void releaseConsumer() {
        if (this._consumer().isDefined()) {
            this.consumerPool.returnObject((InternalKafkaConsumer)this._consumer().get());
            this._consumer_$eq((Option<InternalKafkaConsumer>)None$.MODULE$);
            return;
        }
    }

    private void releaseFetchedData() {
        if (this._fetchedData().isDefined()) {
            this.fetchedDataPool.release(this.cacheKey(), (FetchedData)this._fetchedData().get());
            this._fetchedData_$eq((Option<FetchedData>)None$.MODULE$);
            return;
        }
    }

    private long getEarliestAvailableOffsetBetween(InternalKafkaConsumer consumer, long offset, long untilOffset) {
        AvailableOffsetRange range = consumer.getAvailableOffsetRange();
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Some data may be lost. Recovering from the earliest offset: ").append(range.earliest()).toString());
        TopicPartition topicPartition = consumer.topicPartition();
        String groupId = consumer.groupId();
        if (offset >= range.latest() || range.earliest() >= untilOffset) {
            String warningMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n         |The current available offset range is ").append(range).append(".\n         | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(untilOffset).append(") will be\n         | skipped ").append(this.additionalMessage(topicPartition, groupId, false)).append("\n        ").toString())).stripMargin();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
            return KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
        }
        if (offset >= range.earliest()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Found a disappeared offset ").append(offset).append(". Some data may be lost ").append(this.additionalMessage(topicPartition, groupId, false)).toString());
            return offset;
        }
        String warningMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n         |The current available offset range is ").append(range).append(".\n         | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(range.earliest()).append(") will be\n         | skipped ").append(this.additionalMessage(topicPartition, groupId, false)).append("\n        ").toString())).stripMargin();
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
        return range.earliest();
    }

    private FetchedRecord fetchRecord(InternalKafkaConsumer consumer, FetchedData fetchedData, long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        if (offset != fetchedData.nextOffsetInFetchedData()) {
            this.fetchData(consumer, fetchedData, offset, pollTimeoutMs);
        } else if (!fetchedData.hasNext()) {
            if (offset < fetchedData.offsetAfterPoll()) {
                long nextOffsetToFetch = fetchedData.offsetAfterPoll();
                fetchedData.reset();
                return this.fetchedRecord().withRecord(null, nextOffsetToFetch);
            }
            this.fetchData(consumer, fetchedData, offset, pollTimeoutMs);
        }
        if (!fetchedData.hasNext()) {
            Predef$.MODULE$.assert(offset <= fetchedData.offsetAfterPoll(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("seek to ").append(offset).append(" and poll but the offset was reset to ").append(fetchedData.offsetAfterPoll()).toString());
            return this.fetchedRecord().withRecord(null, fetchedData.offsetAfterPoll());
        }
        ConsumerRecord<byte[], byte[]> record = fetchedData.next();
        if (record.offset() > offset) {
            Tuple2<Object, Object> tuple2 = fetchedData.availableOffsetRange();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long earliestOffset = tuple2._1$mcJ$sp();
            long earliestOffset2 = earliestOffset;
            if (earliestOffset2 <= offset) {
                fetchedData.previous();
                return this.fetchedRecord().withRecord(null, record.offset());
            }
            if (failOnDataLoss) {
                this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), true, new StringBuilder(28).append("Cannot fetch records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$5());
                throw new IllegalStateException("reportDataLoss didn't throw an exception when 'failOnDataLoss' is true");
            }
            if (record.offset() >= untilOffset) {
                this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(untilOffset).append(")").toString(), this.reportDataLoss$default$5());
                return this.fetchedRecord().withRecord(null, untilOffset);
            }
            this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$5());
            return this.fetchedRecord().withRecord(record, fetchedData.nextOffsetInFetchedData());
        }
        if (record.offset() < offset) {
            throw new IllegalStateException(new StringBuilder(51).append("Tried to fetch ").append(offset).append(" but the returned record offset was ").append(record.offset()).toString());
        }
        return this.fetchedRecord().withRecord(record, fetchedData.nextOffsetInFetchedData());
    }

    private void fetchData(InternalKafkaConsumer consumer, FetchedData fetchedData, long offset, long pollTimeoutMs) {
        Tuple3<List<ConsumerRecord<byte[], byte[]>>, Object, AvailableOffsetRange> tuple3 = consumer.fetch(offset, pollTimeoutMs);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        List records = (List)tuple3._1();
        long offsetAfterPoll = BoxesRunTime.unboxToLong((Object)tuple3._2());
        AvailableOffsetRange range = (AvailableOffsetRange)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)records, (Object)BoxesRunTime.boxToLong((long)offsetAfterPoll), (Object)range);
        List records2 = (List)tuple32._1();
        long offsetAfterPoll2 = BoxesRunTime.unboxToLong((Object)tuple32._2());
        AvailableOffsetRange range2 = (AvailableOffsetRange)tuple32._3();
        fetchedData.withNewPoll(records2.listIterator(), offsetAfterPoll2, range2);
    }

    public InternalKafkaConsumer getOrRetrieveConsumer() {
        block1: {
            if (!this._consumer().isDefined()) {
                this.retrieveConsumer();
            }
            Predef$.MODULE$.require(this._consumer().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Consumer must be defined");
            if (!this.isTokenProviderEnabled() || !KafkaTokenUtil$.MODULE$.needTokenUpdate(((InternalKafkaConsumer)this._consumer().get()).kafkaParamsWithSecurity(), ((InternalKafkaConsumer)this._consumer().get()).clusterConfig())) break block1;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cached consumer uses an old delegation token, invalidating.");
            this.releaseConsumer();
            this.consumerPool.invalidateKey(this.cacheKey());
            this.fetchedDataPool.invalidate(this.cacheKey());
            this.retrieveConsumer();
        }
        return (InternalKafkaConsumer)this._consumer().get();
    }

    private void retrieveConsumer() {
        this._consumer_$eq((Option<InternalKafkaConsumer>)Option$.MODULE$.apply((Object)this.consumerPool.borrowObject(this.cacheKey(), this.kafkaParams)));
        Predef$.MODULE$.require(this._consumer().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "borrowing consumer from pool must always succeed.");
    }

    private FetchedData getOrRetrieveFetchedData(long offset) {
        Option<FetchedData> option = this._fetchedData();
        if (None$.MODULE$.equals(option)) {
            this._fetchedData_$eq((Option<FetchedData>)Option$.MODULE$.apply((Object)this.fetchedDataPool.acquire(this.cacheKey(), offset)));
            Predef$.MODULE$.require(this._fetchedData().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "acquiring fetched data from cache must always succeed.");
            return (FetchedData)this._fetchedData().get();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            FetchedData fetchedData = (FetchedData)some.value();
            return fetchedData;
        }
        throw new MatchError(option);
    }

    private String additionalMessage(TopicPartition topicPartition, String groupId, boolean failOnDataLoss) {
        if (failOnDataLoss) {
            return new StringBuilder(31).append("(GroupId: ").append(groupId).append(", TopicPartition: ").append(topicPartition).append("). ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString();
        }
        return new StringBuilder(31).append("(GroupId: ").append(groupId).append(", TopicPartition: ").append(topicPartition).append("). ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString();
    }

    private void reportDataLoss(TopicPartition topicPartition, String groupId, boolean failOnDataLoss, String message, Throwable cause) {
        String finalMessage = new StringBuilder(1).append(message).append(" ").append(this.additionalMessage(topicPartition, groupId, failOnDataLoss)).toString();
        this.dataLoss_$eq(this.dataLoss() + 1L);
        KafkaDataConsumer$.MODULE$.org$apache$spark$sql$kafka010$consumer$KafkaDataConsumer$$reportDataLoss0(failOnDataLoss, finalMessage, cause);
    }

    private Throwable reportDataLoss$default$5() {
        return null;
    }

    private <T> T runUninterruptiblyIfPossible(Function0<T> body) {
        Thread thread = Thread.currentThread();
        if (thread instanceof UninterruptibleThread) {
            UninterruptibleThread uninterruptibleThread = (UninterruptibleThread)thread;
            return (T)uninterruptibleThread.runUninterruptibly(body);
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "KafkaDataConsumer is not running in UninterruptibleThread. It may hang when KafkaDataConsumer's methods are interrupted because of KAFKA-1894");
        return (T)body.apply();
    }

    public KafkaDataConsumer(TopicPartition topicPartition, Map<String, Object> kafkaParams, InternalKafkaConsumerPool consumerPool, FetchedDataPool fetchedDataPool) {
        this.topicPartition = topicPartition;
        this.kafkaParams = kafkaParams;
        this.consumerPool = consumerPool;
        this.fetchedDataPool = fetchedDataPool;
        Logging.$init$((Logging)this);
        this.offsetOutOfRange = 0L;
        this.dataLoss = 0L;
        this.isTokenProviderEnabled = HadoopDelegationTokenManager$.MODULE$.isServiceEnabled(SparkEnv$.MODULE$.get().conf(), "kafka");
        this._consumer = None$.MODULE$;
        this._fetchedData = None$.MODULE$;
        this.groupId = (String)kafkaParams.get("group.id");
        this.cacheKey = new CacheKey(this.groupId(), topicPartition);
        this.fetchedRecord = new FetchedRecord(null, KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET());
    }

    public static class AvailableOffsetRange
    implements Product,
    scala.Serializable {
        private final long earliest;
        private final long latest;

        public long earliest() {
            return this.earliest;
        }

        public long latest() {
            return this.latest;
        }

        public AvailableOffsetRange copy(long earliest, long latest) {
            return new AvailableOffsetRange(earliest, latest);
        }

        public long copy$default$1() {
            return this.earliest();
        }

        public long copy$default$2() {
            return this.latest();
        }

        public String productPrefix() {
            return "AvailableOffsetRange";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.earliest());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.latest());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AvailableOffsetRange;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.earliest()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.latest()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AvailableOffsetRange)) return false;
            boolean bl = true;
            if (!bl) return false;
            AvailableOffsetRange availableOffsetRange = (AvailableOffsetRange)x$1;
            if (this.earliest() != availableOffsetRange.earliest()) return false;
            if (this.latest() != availableOffsetRange.latest()) return false;
            if (!availableOffsetRange.canEqual(this)) return false;
            return true;
        }

        public AvailableOffsetRange(long earliest, long latest) {
            this.earliest = earliest;
            this.latest = latest;
            Product.$init$((Product)this);
        }
    }

    public static class CacheKey
    implements Product,
    scala.Serializable {
        private final String groupId;
        private final TopicPartition topicPartition;

        public String groupId() {
            return this.groupId;
        }

        public TopicPartition topicPartition() {
            return this.topicPartition;
        }

        public CacheKey copy(String groupId, TopicPartition topicPartition) {
            return new CacheKey(groupId, topicPartition);
        }

        public String copy$default$1() {
            return this.groupId();
        }

        public TopicPartition copy$default$2() {
            return this.topicPartition();
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.groupId();
                }
                case 1: {
                    return this.topicPartition();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheKey;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheKey cacheKey = (CacheKey)x$1;
            String string = this.groupId();
            String string2 = cacheKey.groupId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            TopicPartition topicPartition = this.topicPartition();
            TopicPartition topicPartition2 = cacheKey.topicPartition();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            if (!cacheKey.canEqual(this)) return false;
            return true;
        }

        public CacheKey(String groupId, TopicPartition topicPartition) {
            this.groupId = groupId;
            this.topicPartition = topicPartition;
            Product.$init$((Product)this);
        }

        public CacheKey(TopicPartition topicPartition, Map<String, Object> kafkaParams) {
            this((String)kafkaParams.get("group.id"), topicPartition);
        }
    }
}

