/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkThrowable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.StatisticsCollectionSuite$;
import org.apache.spark.sql.StatisticsCollectionTestBase;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogColumnStat;
import org.apache.spark.sql.catalyst.catalog.CatalogColumnStat$;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.Statistics$;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product14;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u2A\u0001B\u0003\u0001\u001d!)\u0011\u0004\u0001C\u00015!)A\u0004\u0001C\u0005;!)q\u0007\u0001C\u0005q\tI2\u000b^1uSN$\u0018nY:D_2dWm\u0019;j_:\u001cV/\u001b;f\u0015\t1q!A\u0002tc2T!\u0001C\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Y\u0011AB1qC\u000eDWMC\u0001\r\u0003\ry'oZ\u0002\u0001'\r\u0001qb\u0005\t\u0003!Ei\u0011!B\u0005\u0003%\u0015\u0011Ad\u0015;bi&\u001cH/[2t\u0007>dG.Z2uS>tG+Z:u\u0005\u0006\u001cX\r\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\u000b\u0005!A/Z:u\u0013\tARC\u0001\nTQ\u0006\u0014X\rZ*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\bF\u0001\u001c!\t\u0001\u0002!\u0001\u000edQ\u0016\u001c7\u000eR3tGRKW.Z:uC6\u00048i\u001c7Ti\u0006$8\u000fF\u0003\u001fIE\u001aT\u0007\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0003V]&$\b\"B\u0013\u0003\u0001\u00041\u0013!\u0003;bE2,g*Y7f!\t9cF\u0004\u0002)YA\u0011\u0011\u0006I\u0007\u0002U)\u00111&D\u0001\u0007yI|w\u000e\u001e \n\u00055\u0002\u0013A\u0002)sK\u0012,g-\u0003\u00020a\t11\u000b\u001e:j]\u001eT!!\f\u0011\t\u000bI\u0012\u0001\u0019\u0001\u0014\u0002\u001fQLW.Z:uC6\u00048i\u001c7v[:DQ\u0001\u000e\u0002A\u0002\u0019\nA#\u001a=qK\u000e$X\rZ'j]RKW.Z:uC6\u0004\b\"\u0002\u001c\u0003\u0001\u00041\u0013\u0001F3ya\u0016\u001cG/\u001a3NCb$\u0016.\\3ti\u0006l\u0007/\u0001\thKR\u001cF/\u0019;BiR\u0014h*Y7fgR\u0011\u0011\b\u0010\t\u0004Oi2\u0013BA\u001e1\u0005\r\u0019V\r\u001e\u0005\u0006K\r\u0001\rA\n")
public class StatisticsCollectionSuite
extends StatisticsCollectionTestBase
implements SharedSparkSession {
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    private void checkDescTimestampColStats(String tableName, String timestampColumn, String expectedMinTimestamp, String expectedMaxTimestamp) {
        Row[] descTsCol = (Row[])((Dataset)this.sql().apply((Object)new StringBuilder(16).append("DESC FORMATTED ").append(tableName).append(" ").append(timestampColumn).toString())).collect();
        String $org_scalatest_assert_macro_left = StatisticsCollectionSuite.extractColumnStatsFromDesc$1("min", descTsCol);
        String $org_scalatest_assert_macro_right = expectedMinTimestamp;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
        String $org_scalatest_assert_macro_left2 = StatisticsCollectionSuite.extractColumnStatsFromDesc$1("max", descTsCol);
        String $org_scalatest_assert_macro_right2 = expectedMaxTimestamp;
        String string3 = $org_scalatest_assert_macro_left2;
        String string4 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
    }

    private Set<String> getStatAttrNames(String tableName) {
        AttributeMap queryStats = this.spark().table(tableName).queryExecution().optimizedPlan().stats().attributeStats();
        return ((TraversableOnce)queryStats.map((Function1 & Serializable & scala.Serializable)x$3 -> ((NamedExpression)x$3._1()).name(), Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    public static final /* synthetic */ void $anonfun$new$24(StatisticsCollectionSuite $this, Dataset df$2, LinkedHashMap s) {
        ((LinkedHashMap)s.zip((GenIterable)df$2.schema(), LinkedHashMap$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                StructField field = (StructField)tuple2._2();
                if (tuple22 != null) {
                    String k = (String)tuple22._1();
                    CatalogColumnStat v = (CatalogColumnStat)tuple22._2();
                    return (Assertion)$this.withClue(new StringBuilder(18).append("column ").append(k).append(" with type ").append(field.dataType()).toString(), (Function0 & Serializable & scala.Serializable)() -> {
                        Option roundtrip;
                        Option $org_scalatest_assert_macro_left = roundtrip = CatalogColumnStat$.MODULE$.fromMap("table_is_foo", field.name(), v.toMap(k));
                        Some $org_scalatest_assert_macro_right = new Some((Object)v);
                        Option option = $org_scalatest_assert_macro_left;
                        Some some = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
                    });
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ void $anonfun$new$46(StatisticsCollectionSuite $this, String table$3, boolean autoUpdate$1, String initLocation$1, Option fetched1$1, File tableLoc$1, File newLocation) {
        $this.sql().apply((Object)new StringBuilder(28).append("ALTER TABLE ").append(table$3).append(" SET LOCATION '").append(newLocation.toURI().toString()).append("'").toString());
        if (autoUpdate$1) {
            Option<CatalogStatistics> fetched2 = $this.checkTableStats(table$3, true, (Option<Object>)None$.MODULE$);
            BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched2.get()).sizeInBytes();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
            Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched2.get()).colStats();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            $this.sql().apply((Object)new StringBuilder(28).append("ALTER TABLE ").append(table$3).append(" SET LOCATION '").append(initLocation$1).append("'").toString());
            Option<CatalogStatistics> fetched3 = $this.checkTableStats(table$3, true, (Option<Object>)None$.MODULE$);
            BigInt $org_scalatest_assert_macro_left3 = ((CatalogStatistics)fetched3.get()).sizeInBytes();
            BigInt $org_scalatest_assert_macro_right2 = ((CatalogStatistics)fetched1$1.get()).sizeInBytes();
            BigInt bigInt = $org_scalatest_assert_macro_left3;
            BigInt bigInt2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
            return;
        }
        $this.checkTableStats(table$3, false, (Option<Object>)None$.MODULE$);
        $this.waitForTasksToFinish();
        Utils$.MODULE$.deleteRecursively(tableLoc$1);
    }

    private final void checkTimestampStats$1(DataType t, TimeZone srcTimeZone, TimeZone dstTimeZone, Function1 checker, int start$1, long end$1) {
        String table = "time_table";
        String column = "T";
        TimeZone original = TimeZone.getDefault();
        try {
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                TimeZone.setDefault(srcTimeZone);
                this.spark().range((long)start$1, end$1).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.timestamp_seconds((Column)this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)).cast(t).as(column)})).write().saveAsTable(table);
                this.sql().apply((Object)new StringBuilder(46).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS FOR COLUMNS ").append(column).toString());
                TimeZone.setDefault(dstTimeZone);
                ColumnStat stats = ((CatalogColumnStat)((CatalogStatistics)this.getCatalogTable(table).stats().get()).colStats().apply((Object)column)).toPlanStat(column, t);
                checker.apply((Object)stats);
            });
        }
        finally {
            TimeZone.setDefault(original);
        }
    }

    public static final /* synthetic */ void $anonfun$new$71(int start$1, long end$1, ColumnStat stats) {
        int $org_scalatest_assert_macro_left = BoxesRunTime.unboxToInt((Object)stats.min().get());
        long $org_scalatest_assert_macro_right = TimeUnit.SECONDS.toDays(start$1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), (long)$org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        int $org_scalatest_assert_macro_left2 = BoxesRunTime.unboxToInt((Object)stats.max().get());
        long $org_scalatest_assert_macro_right2 = TimeUnit.SECONDS.toDays(end$1 - 1L);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), (long)$org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
    }

    public static final /* synthetic */ void $anonfun$new$72(int start$1, long end$1, ColumnStat stats) {
        long $org_scalatest_assert_macro_left = BoxesRunTime.unboxToLong((Object)stats.min().get());
        long $org_scalatest_assert_macro_right = TimeUnit.SECONDS.toMicros(start$1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
        long $org_scalatest_assert_macro_left2 = BoxesRunTime.unboxToLong((Object)stats.max().get());
        long $org_scalatest_assert_macro_right2 = TimeUnit.SECONDS.toMicros(end$1 - 1L);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
    }

    public static final /* synthetic */ void $anonfun$new$70(StatisticsCollectionSuite $this, int start$1, long end$1, ZoneId zid) {
        TimeZone timeZone = TimeZone.getTimeZone(zid);
        $this.checkTimestampStats$1((DataType)DateType$.MODULE$, DateTimeUtils$.MODULE$.TimeZoneUTC(), timeZone, (Function1 & Serializable & scala.Serializable)stats -> {
            StatisticsCollectionSuite.$anonfun$new$71(start$1, end$1, stats);
            return BoxedUnit.UNIT;
        }, start$1, end$1);
        $this.checkTimestampStats$1((DataType)TimestampType$.MODULE$, DateTimeUtils$.MODULE$.TimeZoneUTC(), timeZone, (Function1 & Serializable & scala.Serializable)stats -> {
            StatisticsCollectionSuite.$anonfun$new$72(start$1, end$1, stats);
            return BoxedUnit.UNIT;
        }, start$1, end$1);
    }

    private static final String extractColumnStatsFromDesc$1(String statsName, Row[] rows) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).collect((PartialFunction)new scala.Serializable(null, statsName){
            public static final long serialVersionUID = 0L;
            private final String statsName$1;

            public final <A1 extends Row, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    String string = A12.getString(0);
                    String string2 = this.statsName$1;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return (B1)A12.getString(1);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Row x1) {
                Row row = x1;
                if (row != null) {
                    Row row2 = row;
                    String string = row2.getString(0);
                    String string2 = this.statsName$1;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.statsName$1 = statsName$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).head();
    }

    public static final /* synthetic */ void $anonfun$new$74(StatisticsCollectionSuite $this, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            ZoneId zoneId = (ZoneId)tuple2._1();
            String offset = (String)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)DateTimeTestUtils$.MODULE$.withDefaultTimeZone(zoneId, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String table = "insert_desc_same_time_zone";
                String tsCol = "timestamp_typed_col";
                $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String minTimestamp = "make_timestamp(2022, 1, 1, 0, 0, 1.123456)";
                    String maxTimestamp = "make_timestamp(2022, 1, 3, 0, 0, 2.987654)";
                    $this.sql().apply((Object)new StringBuilder(40).append("CREATE TABLE ").append(table).append(" (").append(tsCol).append(" Timestamp) USING parquet").toString());
                    $this.sql().apply((Object)new StringBuilder(22).append("INSERT INTO ").append(table).append(" VALUES ").append(minTimestamp).append(", ").append(maxTimestamp).toString());
                    $this.sql().apply((Object)new StringBuilder(49).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS FOR ALL COLUMNS").toString());
                    $this.checkDescTimestampColStats(table, tsCol, new StringBuilder(27).append("2022-01-01 00:00:01.123456 ").append(offset).toString(), new StringBuilder(27).append("2022-01-03 00:00:02.987654 ").append(offset).toString());
                });
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$92(StatisticsCollectionSuite $this, String database) {
        $this.sql().apply((Object)new StringBuilder(28).append("CREATE VIEW ").append(database).append(".v AS SELECT 1 c").toString());
        $this.sql().apply((Object)new StringBuilder(14).append("CACHE TABLE ").append(database).append(".v").toString());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getStatAttrNames(new StringBuilder(2).append(database).append(".v").toString()));
        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!==", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bang$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
        $this.sql().apply((Object)new StringBuilder(49).append("ANALYZE TABLE ").append(database).append(".v COMPUTE STATISTICS FOR COLUMNS c").toString());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.getStatAttrNames(new StringBuilder(2).append(database).append(".v").toString()));
        Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 674));
    }

    private final Statistics getTableStats$1(String tableName) {
        return this.spark().table(tableName).queryExecution().optimizedPlan().stats();
    }

    public static final /* synthetic */ void $anonfun$new$94(StatisticsCollectionSuite $this, String database) {
        $this.sql().apply((Object)new StringBuilder(28).append("CREATE VIEW ").append(database).append(".v AS SELECT 1 c").toString());
        $this.sql().apply((Object)new StringBuilder(14).append("CACHE TABLE ").append(database).append(".v").toString());
        Statistics stats1 = $this.getTableStats$1(new StringBuilder(2).append(database).append(".v").toString());
        BigInt $org_scalatest_assert_macro_left = stats1.sizeInBytes();
        BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(stats1.rowCount());
        Some $org_scalatest_assert_macro_right2 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
        $this.sql().apply((Object)new StringBuilder(16).append("UNCACHE TABLE ").append(database).append(".v").toString());
        $this.sql().apply((Object)new StringBuilder(19).append("CACHE LAZY TABLE ").append(database).append(".v").toString());
        Statistics stats2 = $this.getTableStats$1(new StringBuilder(2).append(database).append(".v").toString());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(stats2.sizeInBytes());
        BigInt $org_scalatest_assert_macro_right3 = new OneRowRelation().computeStats().sizeInBytes();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(stats2.rowCount());
        None$ $org_scalatest_assert_macro_right4 = None$.MODULE$;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696));
        $this.sql().apply((Object)new StringBuilder(42).append("ANALYZE TABLE ").append(database).append(".v COMPUTE STATISTICS NOSCAN").toString());
        Statistics stats3 = $this.getTableStats$1(new StringBuilder(2).append(database).append(".v").toString());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(stats3.sizeInBytes());
        BigInt $org_scalatest_assert_macro_right5 = new OneRowRelation().computeStats().sizeInBytes();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 700));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(stats3.rowCount());
        None$ $org_scalatest_assert_macro_right6 = None$.MODULE$;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 701));
        $this.sql().apply((Object)new StringBuilder(35).append("ANALYZE TABLE ").append(database).append(".v COMPUTE STATISTICS").toString());
        Statistics stats4 = $this.getTableStats$1(new StringBuilder(2).append(database).append(".v").toString());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(stats4.sizeInBytes());
        BigInt $org_scalatest_assert_macro_right7 = stats1.sizeInBytes();
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(stats4.rowCount());
        Some $org_scalatest_assert_macro_right8 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
    }

    public static final /* synthetic */ void $anonfun$new$100(StatisticsCollectionSuite $this, File tempDir) {
        String tableName = "t1";
        String stagingDirName = ".test-staging-dir";
        String tableLocation = new StringBuilder(1).append(tempDir.toURI()).append("/").append(tableName).toString();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.exec.stagingdir"), (Object)stagingDirName)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(50).append("CREATE TABLE ").append(tableName).append("(c1 BIGINT) USING PARQUET LOCATION '").append(tableLocation).append("'").toString());
            $this.sql().apply((Object)new StringBuilder(28).append("INSERT INTO TABLE ").append(tableName).append(" VALUES(1)").toString());
            File staging = new File(new URI(new StringBuilder(1).append(tableLocation).append("/").append(stagingDirName).toString()));
            Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new PrintWriter(staging), (Function1 & Serializable & scala.Serializable)stagingWriter -> {
                stagingWriter.write("12");
                return BoxedUnit.UNIT;
            });
            File metadata = new File(new URI(new StringBuilder(10).append(tableLocation).append("/_metadata").toString()));
            Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new PrintWriter(metadata), (Function1 & Serializable & scala.Serializable)metadataWriter -> {
                metadataWriter.write("1234");
                return BoxedUnit.UNIT;
            });
            $this.sql().apply((Object)new StringBuilder(28).append("INSERT INTO TABLE ").append(tableName).append(" VALUES(1)").toString());
            long stagingFileSize = staging.length();
            long metadataFileSize = metadata.length();
            long tableLocationSize = $this.getDataSize(new File(new URI(tableLocation)));
            Option<CatalogStatistics> stats = $this.checkTableStats(tableName, true, (Option<Object>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(((CatalogStatistics)stats.get()).sizeInBytes());
            long $org_scalatest_assert_macro_right = tableLocationSize - stagingFileSize - metadataFileSize;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 757));
        }));
    }

    public static final /* synthetic */ void $anonfun$new$116(StatisticsCollectionSuite $this, String database) {
        $this.spark().catalog().setCurrentDatabase(database);
        $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().range(10L).write().saveAsTable("t1");
                $this.sql().apply((Object)new StringBuilder(77).append("CREATE EXTERNAL TABLE t2 USING parquet LOCATION '").append(dir.toURI()).append("' ").append("AS SELECT * FROM range(20)").toString());
                $this.withView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v1", "v2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)"CREATE VIEW v1 AS SELECT 1 c1");
                    $this.sql().apply((Object)"CREATE VIEW v2 AS SELECT 2 c2");
                    $this.sql().apply((Object)"CACHE TABLE v1");
                    $this.sql().apply((Object)"CACHE LAZY TABLE v2");
                    $this.sql().apply((Object)new StringBuilder(44).append("ANALYZE TABLES IN ").append(database$1).append(" COMPUTE STATISTICS NOSCAN").toString());
                    $this.checkTableStats("t1", true, (Option<Object>)None$.MODULE$);
                    $this.checkTableStats("t2", true, (Option<Object>)None$.MODULE$);
                    Option $org_scalatest_assert_macro_left = $this.getCatalogTable("v1").stats();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 831));
                    $this.checkOptimizedPlanStats((Dataset<Row>)$this.spark().table("v1"), BigInt$.MODULE$.int2bigInt(4), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Seq<ColumnStat>)((Seq)Nil$.MODULE$));
                    $this.checkOptimizedPlanStats((Dataset<Row>)$this.spark().table("v2"), BigInt$.MODULE$.int2bigInt(1), (Option<BigInt>)None$.MODULE$, (Seq<ColumnStat>)((Seq)Nil$.MODULE$));
                    $this.sql().apply((Object)"ANALYZE TABLES COMPUTE STATISTICS");
                    $this.checkTableStats("t1", true, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)10)));
                    $this.checkTableStats("t2", true, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)20)));
                    $this.checkOptimizedPlanStats((Dataset<Row>)$this.spark().table("v1"), BigInt$.MODULE$.int2bigInt(4), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Seq<ColumnStat>)((Seq)Nil$.MODULE$));
                    $this.checkOptimizedPlanStats((Dataset<Row>)$this.spark().table("v2"), BigInt$.MODULE$.int2bigInt(4), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Seq<ColumnStat>)((Seq)Nil$.MODULE$));
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public StatisticsCollectionSuite() {
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.test("estimates the size of a limit 0 on outer join", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsCollectionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator6$1(StatisticsCollectionSuite $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)"one", (Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)new Tuple2((Object)"two", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple2((Object)"three", (Object)BoxesRunTime.boxToInteger((int)3)), (List)new .colon.colon((Object)new Tuple2((Object)"four", (Object)BoxesRunTime.boxToInteger((int)4)), (List)Nil$.MODULE$)))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})).createOrReplaceTempView("test");
            Dataset df1 = this.spark().table("test");
            Dataset df2 = this.spark().table("test").limit(0);
            Dataset df = df1.join(df2, (Seq)new .colon.colon((Object)"k", (List)Nil$.MODULE$), "left");
            Seq sizes = df.queryExecution().analyzed().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Join) {
                        Join join = (Join)A1;
                        return (B1)join.stats().sizeInBytes();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    return logicalPlan instanceof Join;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sizes.size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(32).append("number of Join nodes is wrong:\n ").append(df.queryExecution()).toString(), Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(sizes.head());
            BigInt $org_scalatest_assert_macro_right2 = scala.package$.MODULE$.BigInt().apply(128);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(46).append("expected exact size 96 for table 'test', got: ").append(sizes.head()).toString(), Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("analyzing views is not supported", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().range(10L).write().saveAsTable(tableName);
                String viewName = "view";
                this.withView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{viewName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    this.sql().apply((Object)new StringBuilder(30).append("CREATE VIEW ").append(viewName).append(" AS SELECT * FROM ").append(tableName).toString());
                    AnalysisException x$1 = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(viewName).append(" COMPUTE STATISTICS").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
                    String x$2 = "UNSUPPORTED_FEATURE.ANALYZE_VIEW";
                    Map x$3 = Predef$.MODULE$.Map().empty();
                    Option x$4 = this.checkError$default$3();
                    boolean x$5 = this.checkError$default$5();
                    QueryContext[] x$6 = this.checkError$default$6();
                    this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
                    AnalysisException x$7 = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(48).append("ANALYZE TABLE ").append(viewName).append(" COMPUTE STATISTICS FOR COLUMNS id").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
                    String x$8 = "UNSUPPORTED_FEATURE.ANALYZE_VIEW";
                    Map x$9 = Predef$.MODULE$.Map().empty();
                    Option x$10 = this.checkError$default$3();
                    boolean x$11 = this.checkError$default$5();
                    QueryContext[] x$12 = this.checkError$default$6();
                    this.checkError((SparkThrowable)x$7, x$8, x$10, x$9, x$11, x$12);
                });
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("statistics collection of a table with zero column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table_no_cols = "table_no_cols";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table_no_cols}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SparkContext qual$1 = this.sparkContext();
                Range.Inclusive x$13 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
                int x$14 = qual$1.parallelize$default$2();
                RDD rddNoCols = qual$1.parallelize((Seq)x$13, x$14, ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)x$1 -> Row$.MODULE$.empty(), ClassTag$.MODULE$.apply(Row.class));
                Dataset dfNoCols = this.spark().createDataFrame(rddNoCols, StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
                dfNoCols.write().format("json").saveAsTable(table_no_cols);
                this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(table_no_cols).append(" COMPUTE STATISTICS").toString());
                this.checkTableStats(table_no_cols, true, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)10)));
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("analyze empty table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "emptyTable";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)Nil$.MODULE$, this.testImplicits().newIntEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}));
                df.write().format("json").saveAsTable(table);
                this.sql().apply((Object)new StringBuilder(40).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS noscan").toString());
                Option<CatalogStatistics> fetchedStats1 = this.checkTableStats(table, true, (Option<Object>)None$.MODULE$);
                BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetchedStats1.get()).sizeInBytes();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
                this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS").toString());
                Option<CatalogStatistics> fetchedStats2 = this.checkTableStats(table, true, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
                BigInt $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetchedStats2.get()).sizeInBytes();
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left2, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
                Tuple2 expectedColStat = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)IntegerType$.MODULE$.defaultSize())), (Option)new Some((Object)BoxesRunTime.boxToLong((long)IntegerType$.MODULE$.defaultSize())), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()));
                ((IterableLike)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)histogramEnabled -> {
                    this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()), (Object)histogramEnabled)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkColStats((Dataset<Row>)df, (LinkedHashMap<String, CatalogColumnStat>)((LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{expectedColStat})))));
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        this.test("analyze column command - unsupported types and invalid columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "column_stats_test1";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsCollectionSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator16$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.apache")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.sql")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.sql.test")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.sql.test.SQLTestData")), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.sql.test.SQLTestData.ArrayData"), (List)Nil$.MODULE$);
                    }

                    public Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator16$1(StatisticsCollectionSuite $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new SQLTestData.ArrayData((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (Seq<Seq<Object>>)((Seq)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (List)Nil$.MODULE$))), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator16$1(null)))).toDF().write().saveAsTable(tableName);
                AnalysisException x$15 = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(50).append("ANALYZE TABLE ").append(tableName).append(" COMPUTE STATISTICS FOR COLUMNS data").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
                String x$16 = "UNSUPPORTED_FEATURE.ANALYZE_UNSUPPORTED_COLUMN_TYPE";
                Map x$17 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnType"), (Object)"\"ARRAY<INT>\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`data`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`spark_catalog`.`default`.`column_stats_test1`")}));
                Option x$18 = this.checkError$default$3();
                boolean x$19 = this.checkError$default$5();
                QueryContext[] x$20 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$15, x$16, x$18, x$17, x$19, x$20);
                AnalysisException x$21 = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(64).append("ANALYZE TABLE ").append(tableName).append(" COMPUTE STATISTICS FOR COLUMNS some_random_column").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
                String x$22 = "COLUMN_NOT_FOUND";
                Map x$23 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"`some_random_column`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"caseSensitiveConfig"), (Object)"\"spark.sql.caseSensitive\"")}));
                Option x$24 = this.checkError$default$3();
                boolean x$25 = this.checkError$default$5();
                QueryContext[] x$26 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$21, x$22, x$24, x$23, x$25, x$26);
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        this.test("test table-level statistics for data source table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(44).append("CREATE TABLE ").append(tableName).append("(i INT, j STRING) USING parquet").toString());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsCollectionSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator26$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator26$1(StatisticsCollectionSuite $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"b"), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator26$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().mode("overwrite").insertInto(tableName);
                this.sql().apply((Object)new StringBuilder(40).append("ANALYZE TABLE ").append(tableName).append(" COMPUTE STATISTICS noscan").toString());
                this.checkTableStats(tableName, true, (Option<Object>)None$.MODULE$);
                this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(tableName).append(" COMPUTE STATISTICS").toString());
                this.checkTableStats(tableName, true, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("SPARK-15392: DataFrame created from RDD should not be broadcasted", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            SparkContext qual$2 = this.sparkContext();
            long x$27 = 1L;
            long x$28 = 100L;
            long x$29 = qual$2.range$default$3();
            int x$30 = qual$2.range$default$4();
            RDD rdd = qual$2.range(x$27, x$28, x$29, x$30).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)i)), BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)i))})), ClassTag$.MODULE$.apply(Row.class));
            Dataset df = this.spark().createDataFrame(rdd, new StructType().add("a", (DataType)LongType$.MODULE$).add("b", (DataType)LongType$.MODULE$));
            BigInt $org_scalatest_assert_macro_left = df.queryExecution().analyzed().stats().sizeInBytes();
            BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.long2bigInt(this.spark().sessionState().conf().autoBroadcastJoinThreshold());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            BigInt $org_scalatest_assert_macro_left2 = df.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).queryExecution().analyzed().stats().sizeInBytes();
            BigInt $org_scalatest_assert_macro_right2 = BigInt$.MODULE$.long2bigInt(this.spark().sessionState().conf().autoBroadcastJoinThreshold());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, ">", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$greater((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("column stats round trip serialization", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsCollectionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator36$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple14"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.Boolean").asType().toTypeConstructor(), $m.staticClass("java.lang.Byte").asType().toTypeConstructor(), $m.staticClass("java.lang.Short").asType().toTypeConstructor(), $m.staticClass("java.lang.Integer").asType().toTypeConstructor(), $m.staticClass("java.lang.Long").asType().toTypeConstructor(), $m.staticClass("java.lang.Double").asType().toTypeConstructor(), $m.staticClass("java.lang.Float").asType().toTypeConstructor(), $m.staticClass("java.math.BigDecimal").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), $m.staticClass("java.sql.Date").asType().toTypeConstructor(), $m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), $m.staticClass("java.time.LocalDateTime").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))})));
                }

                public Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator36$1(StatisticsCollectionSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder(this.data(), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator36$1(null)))).toDF((Seq)this.stats().keys().toSeq().$colon$plus((Object)"carray", Seq$.MODULE$.canBuildFrom()));
            ((IterableLike)new .colon.colon(this.stats(), (List)new .colon.colon(this.statsWithHgms(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)s -> {
                StatisticsCollectionSuite.$anonfun$new$24(this, df, s);
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test("SPARK-33812: column stats round trip serialization with splitting histogram property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HIVE_TABLE_PROPERTY_LENGTH_THRESHOLD().key()), (Object)"10")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.statsWithHgms().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Option roundtrip;
                String k = (String)tuple2._1();
                CatalogColumnStat v = (CatalogColumnStat)tuple2._2();
                Option $org_scalatest_assert_macro_left = roundtrip = CatalogColumnStat$.MODULE$.fromMap("t", k, v.toMap(k));
                Some $org_scalatest_assert_macro_right = new Some((Object)v);
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            }
            throw new MatchError((Object)tuple2);
        })), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.test("analyze column command - result verification", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LinkedHashMap<String, CatalogColumnStat> $org_scalatest_assert_macro_left = this.stats();
            int $org_scalatest_assert_macro_right = ((Product14)this.data().head()).productArity() - 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsCollectionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator46$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple14"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.Boolean").asType().toTypeConstructor(), $m.staticClass("java.lang.Byte").asType().toTypeConstructor(), $m.staticClass("java.lang.Short").asType().toTypeConstructor(), $m.staticClass("java.lang.Integer").asType().toTypeConstructor(), $m.staticClass("java.lang.Long").asType().toTypeConstructor(), $m.staticClass("java.lang.Double").asType().toTypeConstructor(), $m.staticClass("java.lang.Float").asType().toTypeConstructor(), $m.staticClass("java.math.BigDecimal").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), $m.staticClass("java.sql.Date").asType().toTypeConstructor(), $m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), $m.staticClass("java.time.LocalDateTime").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))})));
                }

                public Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator46$1(StatisticsCollectionSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder(this.data(), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator46$1(null)))).toDF((Seq)this.stats().keys().toSeq().$colon$plus((Object)"carray", Seq$.MODULE$.canBuildFrom()));
            this.checkColStats((Dataset<Row>)df, this.stats());
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_NUM_BINS().key()), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkColStats((Dataset<Row>)df, this.statsWithHgms()));
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        this.test("column stats collection for null columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq dataTypes = (Seq)((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{BooleanType$.MODULE$, ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, DoubleType$.MODULE$, FloatType$.MODULE$, DecimalType$.MODULE$.SYSTEM_DEFAULT(), StringType$.MODULE$, BinaryType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$}))).zipWithIndex(Seq$.MODULE$.canBuildFrom());
            Dataset df = (Dataset)this.sql().apply((Object)new StringBuilder(7).append("select ").append(((TraversableOnce)dataTypes.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    DataType tpe = (DataType)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    return new StringBuilder(21).append("cast(null as ").append(tpe.sql()).append(") as col").append(idx).toString();
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
            Seq expectedColStats = (Seq)dataTypes.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    DataType tpe = (DataType)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    return new Tuple2((Object)new StringBuilder(3).append("col").append(idx).toString(), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)tpe.defaultSize())), (Option)new Some((Object)BoxesRunTime.boxToLong((long)tpe.defaultSize())), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()));
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom());
            ((IterableLike)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)histogramEnabled -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()), (Object)histogramEnabled)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkColStats((Dataset<Row>)df, (LinkedHashMap<String, CatalogColumnStat>)((LinkedHashMap)LinkedHashMap$.MODULE$.apply(expectedColStats))));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        this.test("SPARK-25028: column stats collection for null partitioning columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "analyze_partition_with_null";
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(146).append("\n             |CREATE TABLE ").append(table$2).append(" (value string, name string)\n             |USING PARQUET\n             |PARTITIONED BY (name)\n             |LOCATION '").append(dir.toURI()).append("'").toString())).stripMargin());
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsCollectionSuite.class.getClassLoader());
                    public final class $typecreator56$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Null").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                        }

                        public $typecreator56$1(StatisticsCollectionSuite $outer) {
                        }
                    }
                    Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)"a", null), (List)new .colon.colon((Object)new Tuple2((Object)"b", null), (List)Nil$.MODULE$)), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new $typecreator56$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "name"}));
                    df.write().mode("overwrite").insertInto(table$2);
                    $this.sql().apply((Object)new StringBuilder(50).append("ANALYZE TABLE ").append(table$2).append(" PARTITION (name) COMPUTE STATISTICS").toString());
                    SessionCatalog qual$3 = $this.spark().sessionState().catalog();
                    TableIdentifier x$31 = TableIdentifier$.MODULE$.apply(table$2);
                    Option x$32 = qual$3.listPartitions$default$2();
                    Seq partitions = qual$3.listPartitions(x$31, x$32);
                    BigInt $org_scalatest_assert_macro_left = (BigInt)((CatalogStatistics)((CatalogTablePartition)partitions.head()).stats().get()).rowCount().get();
                    int $org_scalatest_assert_macro_right = 2;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        this.test("number format in statistics", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq numbers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(0)), (Object)new Tuple2((Object)"0.0 B", (Object)"0")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(100)), (Object)new Tuple2((Object)"100.0 B", (Object)"100")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(2047)), (Object)new Tuple2((Object)"2047.0 B", (Object)"2.05E+3")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(2048)), (Object)new Tuple2((Object)"2.0 KiB", (Object)"2.05E+3")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(3333333)), (Object)new Tuple2((Object)"3.2 MiB", (Object)"3.33E+6")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(4444444444L)), (Object)new Tuple2((Object)"4.1 GiB", (Object)"4.44E+9")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(5555555555555L)), (Object)new Tuple2((Object)"5.1 TiB", (Object)"5.56E+12")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(6666666666666666L)), (Object)new Tuple2((Object)"5.9 PiB", (Object)"6.67E+15")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(1024L).$times(BigInt$.MODULE$.long2bigInt(0x1000000000000000L))), (Object)new Tuple2((Object)"1024.0 EiB", (Object)"1.18E+21")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(2048L).$times(BigInt$.MODULE$.long2bigInt(0x1000000000000000L))), (Object)new Tuple2((Object)"2.36E+21 B", (Object)"2.36E+21"))}));
            numbers.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 != null) {
                    BigInt input = (BigInt)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        String expectedSize = (String)tuple22._1();
                        String expectedRows = (String)tuple22._2();
                        Statistics stats = new Statistics(input, (Option)new Some((Object)input), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
                        String expectedString = new StringBuilder(23).append("sizeInBytes=").append(expectedSize).append(", rowCount=").append(expectedRows).toString();
                        String $org_scalatest_assert_macro_left = stats.simpleString();
                        String $org_scalatest_assert_macro_right = expectedString;
                        String string = $org_scalatest_assert_macro_left;
                        String string2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
                    }
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("change stats after set location command", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "change_stats_set_location_table";
            File tableLoc = new File(this.spark().sessionState().catalog().defaultTablePath(TableIdentifier$.MODULE$.apply(table)));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)autoUpdate -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.spark().range(100L).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), $this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$percent((Object)BoxesRunTime.boxToInteger((int)5)).as("value")})).write().saveAsTable(table$3);
                    $this.sql().apply((Object)new StringBuilder(55).append("ANALYZE TABLE ").append(table$3).append(" COMPUTE STATISTICS FOR COLUMNS id, value").toString());
                    Option<CatalogStatistics> fetched1 = $this.checkTableStats(table$3, true, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)100)));
                    BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched1.get()).sizeInBytes();
                    BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
                    Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched1.get()).colStats();
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
                    String initLocation = ((URI)$this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(table$3)).storage().locationUri().get()).toString();
                    $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)newLocation -> {
                        StatisticsCollectionSuite.$anonfun$new$46($this, table$3, autoUpdate, initLocation, fetched1, tableLoc$1, newLocation);
                        return BoxedUnit.UNIT;
                    });
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
        this.test("change stats after insert command for datasource table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "change_stats_insert_datasource_table";
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)autoUpdate -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Assertion assertion;
                    $this.sql().apply((Object)new StringBuilder(45).append("CREATE TABLE ").append(table$4).append(" (i int, j string) USING PARQUET").toString());
                    $this.sql().apply((Object)new StringBuilder(50).append("ANALYZE TABLE ").append(table$4).append(" COMPUTE STATISTICS FOR COLUMNS i, j").toString());
                    Option<CatalogStatistics> fetched1 = $this.checkTableStats(table$4, true, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
                    BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched1.get()).sizeInBytes();
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
                    Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched1.get()).colStats();
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
                    $this.spark().table(table$4);
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool($this.isTableInCatalogCache(table$4), "StatisticsCollectionSuite.this.isTableInCatalogCache(table)", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
                    $this.sql().apply((Object)new StringBuilder(34).append("INSERT INTO TABLE ").append(table$4).append(" SELECT 1, 'abc'").toString());
                    if (autoUpdate) {
                        Option<CatalogStatistics> fetched2 = $this.checkTableStats(table$4, true, (Option<Object>)None$.MODULE$);
                        BigInt $org_scalatest_assert_macro_left3 = ((CatalogStatistics)fetched2.get()).sizeInBytes();
                        BigInt $org_scalatest_assert_macro_right3 = BigInt$.MODULE$.int2bigInt(0);
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, ">", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$greater((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
                        Map $org_scalatest_assert_macro_left4 = ((CatalogStatistics)fetched2.get()).colStats();
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                        assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
                    } else {
                        assertion = $this.checkTableStats(table$4, false, (Option<Object>)None$.MODULE$);
                    }
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.isTableInCatalogCache(table$4), "StatisticsCollectionSuite.this.isTableInCatalogCache(table)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        this.test("auto gather stats after insert command", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "change_stats_insert_datasource_table";
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)autoUpdate -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)new StringBuilder(45).append("CREATE TABLE ").append(table$5).append(" (i int, j string) USING PARQUET").toString());
                    $this.sql().apply((Object)new StringBuilder(34).append("INSERT INTO TABLE ").append(table$5).append(" SELECT 1, 'abc'").toString());
                    Option stats = $this.getCatalogTable(table$5).stats();
                    if (autoUpdate) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(stats.isDefined(), "stats.isDefined", Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
                        BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)stats.get()).sizeInBytes();
                        BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">=", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater$eq((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
                        return;
                    }
                    Option $org_scalatest_assert_macro_left = stats;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        this.test("invalidation of tableRelationCache after inserts", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "invalidate_catalog_cache_table";
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)autoUpdate -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.spark().range(100L).write().saveAsTable(table$6);
                    $this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(table$6).append(" COMPUTE STATISTICS").toString());
                    $this.spark().table(table$6);
                    BigInt initialSizeInBytes = $this.getTableFromCatalogCache(table$6).stats().sizeInBytes();
                    $this.spark().range(100L).write().mode(SaveMode.Append).saveAsTable(table$6);
                    $this.spark().table(table$6);
                    BigInt $org_scalatest_assert_macro_left = $this.getTableFromCatalogCache(table$6).stats().sizeInBytes();
                    BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(2).$times(initialSizeInBytes);
                    BigInt bigInt = $org_scalatest_assert_macro_left;
                    BigInt bigInt2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        this.test("invalidation of tableRelationCache after alter table add partition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "invalidate_catalog_cache_table";
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)autoUpdate -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                    $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table$7}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        String path = dir.getCanonicalPath();
                        $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n              |CREATE TABLE ").append(table$7).append(" (col1 int, col2 int)\n              |USING PARQUET\n              |PARTITIONED BY (col2)\n              |LOCATION '").append(dir.toURI()).append("'").toString())).stripMargin());
                        $this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(table$7).append(" COMPUTE STATISTICS").toString());
                        $this.spark().table(table$7);
                        BigInt $org_scalatest_assert_macro_left = $this.getTableFromCatalogCache(table$7).stats().sizeInBytes();
                        int $org_scalatest_assert_macro_right = 0;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
                        $this.spark().catalog().recoverPartitions(table$7);
                        JavaUniverse $u = package$.MODULE$.universe();
                        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsCollectionSuite.class.getClassLoader());
                        public final class $typecreator66$1
                        extends TypeCreator {
                            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                Universe $u = $m$untyped.universe();
                                Mirror<U> $m = $m$untyped;
                                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                            }

                            public $typecreator66$1(StatisticsCollectionSuite $outer) {
                            }
                        }
                        Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2.mcII.sp(1, 2), (List)new .colon.colon((Object)new Tuple2.mcII.sp(1, 2), (List)Nil$.MODULE$)), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new $typecreator66$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col2", "col1"}));
                        df.write().parquet(new StringBuilder(7).append(path).append("/col2=1").toString());
                        $this.sql().apply((Object)new StringBuilder(47).append("ALTER TABLE ").append(table$7).append(" ADD PARTITION (col2=1) LOCATION '").append(dir.toURI()).append("'").toString());
                        $this.spark().table(table$7);
                        LogicalPlan cachedTable = $this.getTableFromCatalogCache(table$7);
                        BigInt cachedTableSizeInBytes = cachedTable.stats().sizeInBytes();
                        long defaultSizeInBytes = $this.conf().defaultSizeInBytes();
                        if (autoUpdate$4) {
                            Bool bool;
                            BigInt $org_scalatest_assert_macro_left2 = cachedTableSizeInBytes;
                            long $org_scalatest_assert_macro_right2 = defaultSizeInBytes;
                            Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), !BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left2, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                            if ($org_scalatest_assert_macro_left3.value()) {
                                BigInt $org_scalatest_assert_macro_left4 = cachedTableSizeInBytes;
                                BigInt $org_scalatest_assert_macro_right3 = BigInt$.MODULE$.int2bigInt(0);
                                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, ">", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$greater((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                            } else {
                                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                            }
                            Bool $org_scalatest_assert_macro_right4 = bool;
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
                            return;
                        }
                        BigInt $org_scalatest_assert_macro_left5 = cachedTableSizeInBytes;
                        long $org_scalatest_assert_macro_right5 = defaultSizeInBytes;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left5, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5)), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
                    });
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        this.test("Simple queries must be working, if CBO is turned on", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TBL1", "TBL"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().range(1000L).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$times((Object)BoxesRunTime.boxToInteger((int)2)).as("FLD1"), this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$times((Object)BoxesRunTime.boxToInteger((int)12)).as("FLD2"), functions$.MODULE$.lit(null).cast((DataType)DoubleType$.MODULE$).$plus((Object)this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)).as("fld3")}));
            df.write().mode(SaveMode.Overwrite).bucketBy(10, "id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FLD1", "FLD2"})).sortBy("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FLD1", "FLD2"})).saveAsTable("TBL");
            this.sql().apply((Object)"ANALYZE TABLE TBL COMPUTE STATISTICS ");
            this.sql().apply((Object)"ANALYZE TABLE TBL COMPUTE STATISTICS FOR COLUMNS ID, FLD1, FLD2, FLD3");
            Dataset df2 = this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n             |SELECT t1.id, t1.fld1, t1.fld2, t1.fld3\n             |FROM tbl t1\n             |JOIN tbl t2 on t1.id=t2.id\n             |WHERE  t1.fld3 IN (-123.23,321.23)\n          ")).stripMargin());
            df2.createTempView("TBL2");
            ((Dataset)this.sql().apply((Object)"SELECT * FROM tbl2 WHERE fld3 IN (0,1)  ")).queryExecution().executedPlan();
        })), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
        this.test("store and retrieve column stats in different time zones", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(0, TimeUnit.DAYS.toSeconds(2L));
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int start = sp2._1$mcI$sp();
            long end = sp2._2$mcJ$sp();
            Tuple2.mcIJ.sp sp3 = new Tuple2.mcIJ.sp(start, end);
            int start2 = sp3._1$mcI$sp();
            long end2 = sp3._2$mcJ$sp();
            DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
                StatisticsCollectionSuite.$anonfun$new$70(this, start2, end2, zid);
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        this.test("SPARK-38140: describe column stats (min, max) for timestamp column: desc results should be consistent with the written value if writing and desc happen in the same time zone", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq zoneIdAndOffsets = (Seq)new .colon.colon((Object)new Tuple2((Object)DateTimeTestUtils$.MODULE$.UTC(), (Object)"+0000"), (List)new .colon.colon((Object)new Tuple2((Object)DateTimeTestUtils$.MODULE$.PST(), (Object)"-0800"), (List)new .colon.colon((Object)new Tuple2((Object)DateTimeUtils$.MODULE$.getZoneId("Asia/Hong_Kong"), (Object)"+0800"), (List)Nil$.MODULE$)));
            zoneIdAndOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
                StatisticsCollectionSuite.$anonfun$new$74(this, x0$6);
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
        this.test("SPARK-38140: describe column stats (min, max) for timestamp column: desc should show different results if writing in UTC and desc in other time zones", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "insert_desc_diff_time_zones";
            String tsCol = "timestamp_typed_col";
            DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.UTC(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String minTimestamp = "make_timestamp(2022, 1, 1, 0, 0, 1.123456)";
                String maxTimestamp = "make_timestamp(2022, 1, 3, 0, 0, 2.987654)";
                this.sql().apply((Object)new StringBuilder(40).append("CREATE TABLE ").append(table).append(" (").append(tsCol).append(" Timestamp) USING parquet").toString());
                this.sql().apply((Object)new StringBuilder(22).append("INSERT INTO ").append(table).append(" VALUES ").append(minTimestamp).append(", ").append(maxTimestamp).toString());
                this.sql().apply((Object)new StringBuilder(49).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS FOR ALL COLUMNS").toString());
                this.checkDescTimestampColStats(table, tsCol, "2022-01-01 00:00:01.123456 +0000", "2022-01-03 00:00:02.987654 +0000");
                TimeZone.setDefault(DateTimeUtils$.MODULE$.getTimeZone("PST"));
                this.checkDescTimestampColStats(table, tsCol, "2021-12-31 16:00:01.123456 -0800", "2022-01-02 16:00:02.987654 -0800");
                TimeZone.setDefault(DateTimeUtils$.MODULE$.getTimeZone("Asia/Hong_Kong"));
                this.checkDescTimestampColStats(table, tsCol, "2022-01-01 08:00:01.123456 +0800", "2022-01-03 08:00:02.987654 +0800");
            }));
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
        this.test("SPARK-42777: describe column stats (min, max) for timestamp_ntz column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "insert_desc_same_time_zone";
            String tsCol = "timestamp_ntz_typed_col";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String minTimestamp = "make_timestamp_ntz(2022, 1, 1, 0, 0, 1.123456)";
                String maxTimestamp = "make_timestamp_ntz(2022, 1, 3, 0, 0, 2.987654)";
                this.sql().apply((Object)new StringBuilder(44).append("CREATE TABLE ").append(table).append(" (").append(tsCol).append(" timestamp_ntz) USING parquet").toString());
                this.sql().apply((Object)new StringBuilder(22).append("INSERT INTO ").append(table).append(" VALUES ").append(minTimestamp).append(", ").append(maxTimestamp).toString());
                this.sql().apply((Object)new StringBuilder(49).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS FOR ALL COLUMNS").toString());
                this.checkDescTimestampColStats(table, tsCol, "2022-01-01 00:00:01.123456", "2022-01-03 00:00:02.987654");
                ColumnStat columnStat = ((CatalogColumnStat)((CatalogStatistics)this.getCatalogTable(table).stats().get()).colStats().apply((Object)tsCol)).toPlanStat(tsCol, (DataType)TimestampNTZType$.MODULE$);
                Option $org_scalatest_assert_macro_left = columnStat.min();
                long $org_scalatest_assert_macro_right = 1640995201123456L;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
                Option $org_scalatest_assert_macro_left2 = columnStat.max();
                long $org_scalatest_assert_macro_right2 = 1641168002987654L;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 574));
        this.test("analyzes column statistics in cached query", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cachedQuery"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("CACHE TABLE cachedQuery AS\n          |  SELECT c0, avg(c1) AS v1, avg(c2) AS v2\n          |  FROM (SELECT id % 3 AS c0, id % 5 AS c1, 2 AS c2 FROM range(1, 30))\n          |  GROUP BY c0\n        ")).stripMargin());
            this.sql().apply((Object)"ANALYZE TABLE cachedQuery COMPUTE STATISTICS FOR COLUMNS v1");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getStatAttrNames("cachedQuery"));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v1"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
            this.sql().apply((Object)"ANALYZE TABLE cachedQuery COMPUTE STATISTICS FOR COLUMNS c0, v2");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getStatAttrNames("cachedQuery"));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c0", "v1", "v2"}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 618));
        }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
        this.test("analyzes column statistics in cached local temporary view", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tempView"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TEMPORARY VIEW tempView AS SELECT 1 id");
            AnalysisException x$33 = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"ANALYZE TABLE tempView COMPUTE STATISTICS FOR COLUMNS id"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 627));
            String x$34 = "UNSUPPORTED_FEATURE.ANALYZE_UNCACHED_TEMP_VIEW";
            Map x$35 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)"`tempView`")}));
            Option x$36 = this.checkError$default$3();
            boolean x$37 = this.checkError$default$5();
            QueryContext[] x$38 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$33, x$34, x$36, x$35, x$37, x$38);
            this.sql().apply((Object)"CACHE TABLE tempView");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getStatAttrNames("tempView"));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!==", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bang$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
            this.sql().apply((Object)"ANALYZE TABLE tempView COMPUTE STATISTICS FOR COLUMNS id");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getStatAttrNames("tempView"));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
        }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 622));
        this.test("analyzes column statistics in cached global temporary view", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withGlobalTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gTempView"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String globalTempDB = this.spark().sharedState().globalTempViewManager().database();
            AnalysisException e1 = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(58).append("ANALYZE TABLE ").append(globalTempDB).append(".gTempView COMPUTE STATISTICS FOR COLUMNS id").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
            this.checkErrorTableNotFound((SparkThrowable)e1, new StringBuilder(14).append("`").append(globalTempDB).append("`.`gTempView`").toString(), this.ExpectedContext().apply(new StringBuilder(10).append(globalTempDB).append(".gTempView").toString(), 14, 13 + new StringBuilder(10).append(globalTempDB).append(".gTempView").toString().length()));
            this.sql().apply((Object)"CREATE GLOBAL TEMP VIEW gTempView AS SELECT 1 id");
            AnalysisException x$39 = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(58).append("ANALYZE TABLE ").append(globalTempDB).append(".gTempView COMPUTE STATISTICS FOR COLUMNS id").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
            String x$40 = "UNSUPPORTED_FEATURE.ANALYZE_UNCACHED_TEMP_VIEW";
            Map x$41 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)"`global_temp`.`gTempView`")}));
            Option x$42 = this.checkError$default$3();
            boolean x$43 = this.checkError$default$5();
            QueryContext[] x$44 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$39, x$40, x$42, x$41, x$43, x$44);
            this.sql().apply((Object)new StringBuilder(22).append("CACHE TABLE ").append(globalTempDB).append(".gTempView").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getStatAttrNames(new StringBuilder(10).append(globalTempDB).append(".gTempView").toString()));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!==", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bang$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 662));
            this.sql().apply((Object)new StringBuilder(58).append("ANALYZE TABLE ").append(globalTempDB).append(".gTempView COMPUTE STATISTICS FOR COLUMNS id").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getStatAttrNames(new StringBuilder(10).append(globalTempDB).append(".gTempView").toString()));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
        }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
        this.test("analyzes column statistics in cached catalog view", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)database -> {
            StatisticsCollectionSuite.$anonfun$new$92(this, database);
            return BoxedUnit.UNIT;
        }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
        this.test("analyzes table statistics in cached catalog view", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)database -> {
            StatisticsCollectionSuite.$anonfun$new$94(this, database);
            return BoxedUnit.UNIT;
        }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
        this.test(new StringBuilder(44).append("CTAS should update statistics if ").append(SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()).append(" is enabled").toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "spark_27694";
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)updateEnabled -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)updateEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)new StringBuilder(46).append("CREATE TABLE ").append(tableName$4).append(" USING parquet AS SELECT 'a', 'b'").toString());
                    CatalogTable catalogTable = $this.getCatalogTable(tableName$4);
                    if (updateEnabled) {
                        Option $org_scalatest_assert_macro_left = catalogTable.stats();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 719));
                        return;
                    }
                    Option $org_scalatest_assert_macro_left = catalogTable.stats();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 721));
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 710));
        this.test("Metadata files and temporary files should not be counted as data files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tempDir -> {
            StatisticsCollectionSuite.$anonfun$new$100(this, tempDir);
            return BoxedUnit.UNIT;
        }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)caseSensitive -> {
            this.test(new StringBuilder(81).append("SPARK-30903: Fail fast on duplicate columns when analyze columns ").append("- caseSensitive=").append(BoxesRunTime.unboxToBoolean((Object)caseSensitive)).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)caseSensitive)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String table = "test_table";
                $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)new StringBuilder(55).append("CREATE TABLE ").append(table).append(" (value string, name string) USING PARQUET").toString());
                    String dupCol = caseSensitive ? "value" : "VaLuE";
                    AnalysisException x$45 = (AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(59).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS FOR COLUMNS value, name, ").append(dupCol).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 772));
                    String x$46 = "COLUMN_ALREADY_EXISTS";
                    Map x$47 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`value`")}));
                    Option x$48 = $this.checkError$default$3();
                    boolean x$49 = $this.checkError$default$5();
                    QueryContext[] x$50 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$45, x$46, x$48, x$47, x$49, x$50);
                });
            }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-34119: Keep necessary stats after PruneFileSourcePartitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SPARK_34119"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringBuilder(116).append("CREATE TABLE SPARK_34119 using parquet PARTITIONED BY (p) AS ").append("(SELECT id, CAST(id % 5 AS STRING) AS p FROM range(10))").toString());
            this.sql().apply((Object)"ANALYZE TABLE SPARK_34119 COMPUTE STATISTICS FOR ALL COLUMNS");
            this.checkOptimizedPlanStats((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT id FROM SPARK_34119")), BigInt$.MODULE$.long2bigInt(160L), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(10)), (Seq<ColumnStat>)((Seq)new .colon.colon((Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(10)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)9)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()), (List)Nil$.MODULE$)));
            this.checkOptimizedPlanStats((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT id FROM SPARK_34119 WHERE p = '2'")), BigInt$.MODULE$.long2bigInt(32L), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Seq<ColumnStat>)((Seq)new .colon.colon((Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)9)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()), (List)Nil$.MODULE$)));
        })), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
        this.test("SPARK-33687: analyze all tables in a specific database", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException e;
            this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)database -> {
                StatisticsCollectionSuite.$anonfun$new$116(this, database);
                return BoxedUnit.UNIT;
            });
            AnalysisException x$51 = e = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"ANALYZE TABLES IN db_not_exists COMPUTE STATISTICS"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            String x$52 = "SCHEMA_NOT_FOUND";
            Map x$53 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)"`db_not_exists`")}));
            Option x$54 = this.checkError$default$3();
            boolean x$55 = this.checkError$default$5();
            QueryContext[] x$56 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$51, x$52, x$54, x$53, x$55, x$56);
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 814));
    }
}

