/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.orc.OrcFile;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat;
import org.apache.spark.sql.execution.datasources.orc.OrcQuerySuite$;
import org.apache.spark.sql.execution.datasources.orc.OrcQueryTest;
import org.apache.spark.sql.execution.datasources.orc.OrcTest;
import org.apache.spark.sql.execution.datasources.v2.BatchScanExec;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00012QAA\u0002\u0002\u0002IAQ!\b\u0001\u0005\u0002y\u0011Qb\u0014:d#V,'/_*vSR,'B\u0001\u0003\u0006\u0003\ry'o\u0019\u0006\u0003\r\u001d\t1\u0002Z1uCN|WO]2fg*\u0011\u0001\"C\u0001\nKb,7-\u001e;j_:T!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u00192\u0001A\n\u0018!\t!R#D\u0001\u0004\u0013\t12A\u0001\u0007Pe\u000e\fV/\u001a:z)\u0016\u001cH\u000f\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u0013\u0005!A/Z:u\u0013\ta\u0012D\u0001\nTQ\u0006\u0014X\rZ*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\bF\u0001 !\t!\u0002\u0001")
public abstract class OrcQuerySuite
extends OrcQueryTest
implements SharedSparkSession {
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        OrcTest.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        OrcTest.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$new$173(File x$35) {
        return x$35.getName().endsWith(".lzo.orc");
    }

    public static final /* synthetic */ void $anonfun$new$172(OrcQuerySuite $this, File file) {
        $this.spark().range(0L, 10L).write().option("compression", "LZO").orc(file.getCanonicalPath());
        Option maybeOrcFile = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).find((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)OrcQuerySuite.$anonfun$new$173(x$35)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(maybeOrcFile.isDefined(), "maybeOrcFile.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 654));
        Path orcFilePath = new Path(((File)maybeOrcFile.get()).getAbsolutePath());
        OrcFile.ReaderOptions conf = OrcFile.readerOptions((Configuration)new Configuration());
        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)conf), (Function1 & Serializable & scala.Serializable)reader -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("LZO");
            String $org_scalatest_assert_macro_right = reader.getCompressionKind().name();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 659));
        });
    }

    public static final /* synthetic */ void $anonfun$new$177(OrcQuerySuite $this, File dir) {
        String path = dir.getCanonicalPath();
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"empty_orc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"empty", "single"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(113).append("CREATE TABLE empty_orc(key INT, value STRING)\n               |USING ORC\n               |LOCATION '").append(dir.toURI()).append("'\n             ").toString())).stripMargin());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator6$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator6$2(OrcQuerySuite $outer) {
                }
            }
            Dataset emptyDF = $this.testImplicits().localSeqToDatasetHolder((Seq)Nil$.MODULE$, $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator6$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"})).coalesce(1);
            emptyDF.createOrReplaceTempView("empty");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("INSERT INTO TABLE empty_orc\n               |SELECT key, value FROM empty\n             ")).stripMargin());
            Dataset df = $this.spark().read().orc(path);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(df.schema());
            StructType $org_scalatest_assert_macro_right = emptyDF.schema().asNullable();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Dataset<Row>)emptyDF);
        }));
    }

    public static final /* synthetic */ void $anonfun$new$182(OrcQuerySuite $this, File dir) {
        String path = new File(dir, "orc").getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator16$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator16$1(OrcQuerySuite $outer) {
            }
        }
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$)), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator16$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col.dots"})).write().orc(path);
        Row[] $org_scalatest_assert_macro_left = (Row[])$this.spark().read().orc(path).collect();
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$193(Long x$40, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(x$40) + (long)i)), (Object)new StringOps(Predef$.MODULE$.augmentString(String.valueOf(x$40))).$times(5));
    }

    public static final /* synthetic */ boolean $anonfun$new$195(SparkPlan x0$1) {
        SparkPlan sparkPlan2 = x0$1;
        if (sparkPlan2 instanceof FileSourceScanExec ? true : sparkPlan2 instanceof BatchScanExec) {
            return sparkPlan2.supportsColumnar();
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$new$191(OrcQuerySuite $this, File dir) {
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator21$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("java.lang.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.IndexedSeq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Long").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)}))), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Double").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.Long").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)})))}))), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))))));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator21$1(OrcQuerySuite $outer) {
            }
        }
        String path = dir.getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
        Dataset df = $this.spark().range(10L).map((Function1 & Serializable & scala.Serializable)x -> {
            String stringColumn = new StringOps(Predef$.MODULE$.augmentString(String.valueOf(x))).$times(10);
            Tuple2 structColumn = new Tuple2(x, (Object)new StringOps(Predef$.MODULE$.augmentString(String.valueOf(x))).$times(100));
            IndexedSeq arrayColumn = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)i -> OrcQuerySuite.$anonfun$new$193(x, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            Map mapColumn = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(x)), (Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)Predef$.MODULE$.Long2long(x) * 0.1)), (Object)new Tuple2(x, (Object)new StringOps(Predef$.MODULE$.augmentString(String.valueOf(x))).$times(100)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString(String.valueOf(x))).$times(2)), (Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)Predef$.MODULE$.Long2long(x) * 0.2)), (Object)new Tuple2(x, (Object)new StringOps(Predef$.MODULE$.augmentString(String.valueOf(x))).$times(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString(String.valueOf(x))).$times(3)), (Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)Predef$.MODULE$.Long2long(x) * 0.3)), (Object)new Tuple2(x, (Object)new StringOps(Predef$.MODULE$.augmentString(String.valueOf(x))).$times(300))))}));
            return new Tuple5(x, (Object)stringColumn, (Object)structColumn, (Object)arrayColumn, (Object)mapColumn);
        }, $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator21$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"int_col", "string_col", "struct_col", "array_col", "map_col"}));
        df.write().format("orc").save(path);
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset readDf = $this.spark().read().orc(path);
            boolean vectorizationEnabled = readDf.queryExecution().executedPlan().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)OrcQuerySuite.$anonfun$new$195(x0$1)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(vectorizationEnabled, "vectorizationEnabled", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 749));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> readDf, (Dataset<Row>)df);
        });
    }

    public static final /* synthetic */ String $anonfun$new$201(int k) {
        return Integer.toString(k);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$new$200(int x$37) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1 & Serializable & scala.Serializable)k -> OrcQuerySuite.$anonfun$new$201(BoxesRunTime.unboxToInt((Object)k)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$new$203(SparkPlan x0$2) {
        SparkPlan sparkPlan2 = x0$2;
        if (sparkPlan2 instanceof FileSourceScanExec ? true : sparkPlan2 instanceof BatchScanExec) {
            return sparkPlan2.supportsColumnar();
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$new$198(OrcQuerySuite $this, File dir) {
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator29$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.IndexedSeq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.IndexedSeq"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator29$2(OrcQuerySuite $outer) {
            }
        }
        String path = dir.getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
        Dataset df = $this.spark().range(100L).map((Function1 & Serializable & scala.Serializable)x$36 -> {
            IndexedSeq arrayColumn = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)x$37 -> OrcQuerySuite.$anonfun$new$200(BoxesRunTime.unboxToInt((Object)x$37)), IndexedSeq$.MODULE$.canBuildFrom());
            return arrayColumn;
        }, $this.testImplicits().newSequenceEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator29$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"record"})).repartition(1);
        df.write().format("orc").save(path);
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset readDf = $this.spark().read().orc(path);
            boolean vectorizationEnabled = readDf.queryExecution().executedPlan().exists((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)OrcQuerySuite.$anonfun$new$203(x0$2)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(vectorizationEnabled, "vectorizationEnabled", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 771));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> readDf, (Dataset<Row>)df);
        });
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$208(Long x$41, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(x$41) + (long)i)), (Object)new StringOps(Predef$.MODULE$.augmentString(String.valueOf(x$41))).$times(5));
    }

    public static final /* synthetic */ boolean $anonfun$new$211(SparkPlan x0$4) {
        SparkPlan sparkPlan2 = x0$4;
        if (sparkPlan2 instanceof FileSourceScanExec ? true : sparkPlan2 instanceof BatchScanExec) {
            return sparkPlan2.supportsColumnar();
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$new$209(OrcQuerySuite $this, String path$5, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            String maxNumFields = (String)tuple2._1();
            boolean vectorizedEnabled = tuple2._2$mcZ$sp();
            $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_MAX_NUM_FIELDS().key()), (Object)maxNumFields)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SparkPlan scanPlan = $this.spark().read().orc(path$5).queryExecution().executedPlan();
                boolean $org_scalatest_assert_macro_left = scanPlan.exists((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)OrcQuerySuite.$anonfun$new$211(x0$4)));
                boolean $org_scalatest_assert_macro_right = vectorizedEnabled;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 794));
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$206(OrcQuerySuite $this, File dir) {
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator31$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("java.lang.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.IndexedSeq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Long").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)}))), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Double").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.Long").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)})))}))), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))))));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator31$1(OrcQuerySuite $outer) {
            }
        }
        String path = dir.getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
        Dataset df = $this.spark().range(10L).map((Function1 & Serializable & scala.Serializable)x -> {
            String stringColumn = new StringOps(Predef$.MODULE$.augmentString(String.valueOf(x))).$times(10);
            Tuple2 structColumn = new Tuple2(x, (Object)new StringOps(Predef$.MODULE$.augmentString(String.valueOf(x))).$times(100));
            IndexedSeq arrayColumn = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)i -> OrcQuerySuite.$anonfun$new$208(x, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            Map mapColumn = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(x)), (Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)Predef$.MODULE$.Long2long(x) * 0.1)), (Object)new Tuple2(x, (Object)new StringOps(Predef$.MODULE$.augmentString(String.valueOf(x))).$times(100))))}));
            return new Tuple5(x, (Object)stringColumn, (Object)structColumn, (Object)arrayColumn, (Object)mapColumn);
        }, $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator31$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"int_col", "string_col", "struct_col", "array_col", "map_col"}));
        df.write().format("orc").save(path);
        ((IterableLike)new .colon.colon((Object)new Tuple2((Object)"5", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"10", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            OrcQuerySuite.$anonfun$new$209($this, path, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$213(int i) {
        return new Tuple2((Object)new Timestamp(i), (Object)LocalDateTime.of(2019, 3, 21, 0, 2, 3, 456000000 + i));
    }

    public static final /* synthetic */ void $anonfun$new$219(OrcQuerySuite $this, String sqlText$1, File dir) {
        String path = dir.getCanonicalPath();
        Dataset df = (Dataset)$this.sql().apply((Object)sqlText$1);
        df.write().mode("overwrite").orc(path);
        String query = new StringBuilder(22).append("select * from `orc`.`").append(path).append("`").toString();
        DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zoneId -> {
            DateTimeTestUtils$.MODULE$.withDefaultTimeZone(zoneId, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withAllNativeOrcReaders((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)query$1), (Dataset<Row>)df)));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$228(byte[] byteData$1, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)byteData$1);
    }

    public static final /* synthetic */ void $anonfun$new$225(OrcQuerySuite $this, File dir) {
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator48$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.IndexedSeq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator48$1(OrcQuerySuite $outer) {
            }
        }
        String path = dir.getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
        Dataset df = $this.spark().range(1L, 22L, 1L, 1).map((Function1 & Serializable & scala.Serializable)x$38 -> {
            byte[] byteData = (byte[])Array$.MODULE$.fill(0x100000, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 88, ClassTag$.MODULE$.Byte());
            IndexedSeq mapData = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).map((Function1 & Serializable & scala.Serializable)i -> OrcQuerySuite.$anonfun$new$228(byteData, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            return mapData;
        }, $this.testImplicits().newSequenceEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator48$1(null)))).toDF();
        df.write().format("orc").save(path);
    }

    public static final /* synthetic */ void $anonfun$new$232(OrcQuerySuite $this, File dir) {
        String path = dir.getCanonicalPath();
        Dataset df = $this.spark().range(1L, 1024L, 1L, 1).map((Function1 & Serializable & scala.Serializable)x$39 -> {
            byte[] byteData = (byte[])Array$.MODULE$.fill(0x500000, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 88, ClassTag$.MODULE$.Byte());
            return byteData;
        }, $this.testImplicits().newByteArrayEncoder()).toDF();
        df.write().format("orc").save(path);
    }

    public static final /* synthetic */ void $anonfun$new$237(OrcQuerySuite $this, File dir) {
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator57$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator57$2(OrcQuerySuite $outer) {
            }
        }
        String path = dir.getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
        Dataset df = $this.spark().range(1L, 513L, 1L, 1).map((Function1 & Serializable & scala.Serializable)i -> {
            if (BoxesRunTime.equalsNumObject((Number)i, (Object)BoxesRunTime.boxToInteger((int)1))) {
                return new Tuple2(i, Array$.MODULE$.fill(0x500000, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 88, ClassTag$.MODULE$.Byte()));
            }
            return new Tuple2(i, Array$.MODULE$.fill(1, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 88, ClassTag$.MODULE$.Byte()));
        }, $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator57$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2"}));
        df.write().format("orc").save(path);
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.spark().sql(new StringBuilder(59).append("create table t1 (c1 string,c2 binary) using orc location '").append(path).append("'").toString());
            $this.spark().sql("select * from t1").collect();
        });
    }

    public OrcQuerySuite() {
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.test("LZO compression options for writing to an ORC file", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            OrcQuerySuite.$anonfun$new$172(this, file);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 647));
        this.test("Schema discovery on empty ORC files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$177(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
        this.test("SPARK-21791 ORC should support column names with dot", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$182(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
        this.test("SPARK-25579 ORC PPD should support column names with dot", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkPredicatePushDown((Dataset<Row>)this.spark().range(10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col.dot"})), 10, "`col.dot` == 2")), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
        this.test("SPARK-20728 Make ORCFileFormat configurable between sql/hive and sql/core", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)"hive")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AnalysisException e = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"CREATE TABLE spark_20728(a INT) USING ORC"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711)))));
                String $org_scalatest_assert_macro_left = e.message();
                String $org_scalatest_assert_macro_right = "Hive built-in ORC data source must be used with Hive support";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 714));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)"native")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_20728"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Option fileFormat;
                this.sql().apply((Object)"CREATE TABLE spark_20728(a INT) USING ORC");
                Option $org_scalatest_assert_macro_left = fileFormat = ((Dataset)this.sql().apply((Object)"SELECT * FROM spark_20728")).queryExecution().analyzed().collectFirst((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof LogicalRelation) {
                            LogicalRelation logicalRelation = (LogicalRelation)A1;
                            return (B1)((HadoopFsRelation)logicalRelation.relation()).fileFormat().getClass();
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalPlan logicalPlan = x1;
                        return logicalPlan instanceof LogicalRelation;
                    }
                });
                Some $org_scalatest_assert_macro_right = new Some(OrcFileFormat.class);
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
            }));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
        this.test("SPARK-34862: Support ORC vectorized reader for nested column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$191(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
        this.test("SPARK-37728: Reading nested columns with ORC vectorized reader should not cause ArrayIndexOutOfBoundsException", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$198(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 756));
        this.test("SPARK-36594: ORC vectorized reader should properly check maximal number of fields", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$206(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 777));
        this.test("Read/write all timestamp types", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator46$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.time.LocalDateTime").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator46$1(OrcQuerySuite $outer) {
                }
            }
            IndexedSeq data = (IndexedSeq)((SeqLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 255).map((Function1 & Serializable & scala.Serializable)i -> OrcQuerySuite.$anonfun$new$213(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).$colon$plus((Object)new Tuple2(null, null), IndexedSeq$.MODULE$.canBuildFrom());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
            this.withOrcFile(data, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
                this.withAllNativeOrcReaders((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
                    public final class $typecreator41$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.time.LocalDateTime").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                        }

                        public $typecreator41$1(OrcQuerySuite $outer) {
                        }
                    }
                    $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().orc(file), (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])$this.testImplicits().localSeqToDatasetHolder((Seq)data$9, $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new $typecreator41$1(null)))).toDF().collect()));
                });
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator46$1(null)));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 803));
        this.test("SPARK-37463: read/write Timestamp ntz to Orc with different time zone", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.LA(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sqlText = new StringOps(Predef$.MODULE$.augmentString("\n                      |select\n                      | timestamp_ntz '2021-06-01 00:00:00' ts_ntz1,\n                      | timestamp_ntz '1883-11-16 00:00:00.0' as ts_ntz2,\n                      | timestamp_ntz '2021-03-14 02:15:00.0' as ts_ntz3\n                      |")).stripMargin();
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                OrcQuerySuite.$anonfun$new$219(this, sqlText, dir);
                return BoxedUnit.UNIT;
            });
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 815));
        this.ignore("SPARK-39387: BytesColumnVector should not throw RuntimeException due to overflow", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$225(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
        this.test("SPARK-39381: Make vectorized orc columar writer batch size configurable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 100}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)batchSize -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_WRITER_BATCH_SIZE().key()), (Object)Integer.toString(batchSize))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$232(this, dir);
            return BoxedUnit.UNIT;
        }))), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 857));
        this.test("SPARK-39830: Reading ORC table that requires type promotion may throw AIOOBE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_WRITER_BATCH_SIZE().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"orc.stripe.size"), (Object)"10240"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"orc.rows.between.memory.checks"), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$237(this, dir);
            return BoxedUnit.UNIT;
        })), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 872));
    }
}

