/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.column.values.Utils;
import org.apache.parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesWriter;
import org.apache.parquet.io.api.Binary;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.parquet.ParquetCompatibilityTest;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedDeltaBinaryPackedReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedDeltaLengthByteArrayReader;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\t\u0013\u0001\u0005BQ\u0001\f\u0001\u0005\u00025Bqa\f\u0001C\u0002\u0013\u0005\u0001\u0007\u0003\u0004C\u0001\u0001\u0006I!\r\u0005\n\u0007\u0002\u0001\r\u00111A\u0005\u0002\u0011C\u0011b\u0014\u0001A\u0002\u0003\u0007I\u0011\u0001)\t\u0013Y\u0003\u0001\u0019!A!B\u0013)\u0005\"C,\u0001\u0001\u0004\u0005\r\u0011\"\u0001Y\u0011%a\u0006\u00011AA\u0002\u0013\u0005Q\fC\u0005`\u0001\u0001\u0007\t\u0011)Q\u00053\"I\u0001\r\u0001a\u0001\u0002\u0004%I!\u0019\u0005\nQ\u0002\u0001\r\u00111A\u0005\n%D\u0011b\u001b\u0001A\u0002\u0003\u0005\u000b\u0015\u00022\t\u000b1\u0004A\u0011K7\t\u000b9\u0004A\u0011B8\t\u000bI\u0004A\u0011B:\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f\tA\u0003+\u0019:rk\u0016$H)\u001a7uC2+gn\u001a;i\u0005f$X-\u0011:sCf,enY8eS:<7+^5uK*\u00111\u0003F\u0001\ba\u0006\u0014\u0018/^3u\u0015\t)b#A\u0006eCR\f7o\\;sG\u0016\u001c(BA\f\u0019\u0003%)\u00070Z2vi&|gN\u0003\u0002\u001a5\u0005\u00191/\u001d7\u000b\u0005ma\u0012!B:qCJ\\'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001E\u0019\u0002\"a\t\u0013\u000e\u0003II!!\n\n\u00031A\u000b'/];fi\u000e{W\u000e]1uS\nLG.\u001b;z)\u0016\u001cH\u000f\u0005\u0002(U5\t\u0001F\u0003\u0002*1\u0005!A/Z:u\u0013\tY\u0003F\u0001\nTQ\u0006\u0014X\rZ*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\bF\u0001/!\t\u0019\u0003!\u0001\u0004wC2,Xm]\u000b\u0002cA\u0019!'N\u001c\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012Q!\u0011:sCf\u0004\"\u0001O \u000f\u0005ej\u0004C\u0001\u001e4\u001b\u0005Y$B\u0001\u001f!\u0003\u0019a$o\\8u}%\u0011ahM\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?g\u00059a/\u00197vKN\u0004\u0013AB<sSR,'/F\u0001F!\t1U*D\u0001H\u0015\tA\u0015*\u0001\u000beK2$\u0018\r\\3oORD'-\u001f;fCJ\u0014\u0018-\u001f\u0006\u0003_)S!a\u0013'\u0002\r\r|G.^7o\u0015\t\u0019B$\u0003\u0002O\u000f\n\u0001C)\u001a7uC2+gn\u001a;i\u0005f$X-\u0011:sCf4\u0016\r\\;fg^\u0013\u0018\u000e^3s\u0003)9(/\u001b;fe~#S-\u001d\u000b\u0003#R\u0003\"A\r*\n\u0005M\u001b$\u0001B+oSRDq!V\u0003\u0002\u0002\u0003\u0007Q)A\u0002yIE\nqa\u001e:ji\u0016\u0014\b%\u0001\u0004sK\u0006$WM]\u000b\u00023B\u00111EW\u0005\u00037J\u0011AEV3di>\u0014\u0018N_3e\t\u0016dG/\u0019'f]\u001e$\bNQ=uK\u0006\u0013(/Y=SK\u0006$WM]\u0001\u000be\u0016\fG-\u001a:`I\u0015\fHCA)_\u0011\u001d)\u0006\"!AA\u0002e\u000bqA]3bI\u0016\u0014\b%\u0001\u000bxe&$\u0018M\u00197f\u0007>dW/\u001c8WK\u000e$xN]\u000b\u0002EB\u00111MZ\u0007\u0002I*\u0011QMF\u0001\u000bm\u0016\u001cGo\u001c:ju\u0016$\u0017BA4e\u0005Q9&/\u001b;bE2,7i\u001c7v[:4Vm\u0019;pe\u0006ArO]5uC\ndWmQ8mk6tg+Z2u_J|F%Z9\u0015\u0005ES\u0007bB+\f\u0003\u0003\u0005\rAY\u0001\u0016oJLG/\u00192mK\u000e{G.^7o-\u0016\u001cGo\u001c:!\u0003)\u0011WMZ8sK\u0016\u000b7\r\u001b\u000b\u0002#\u0006IqO]5uK\u0012\u000bG/\u0019\u000b\u0004#B\f\b\"B\"\u000f\u0001\u0004)\u0005\"B\u0018\u000f\u0001\u0004\t\u0014a\u0004:fC\u0012\fe\u000e\u001a,bY&$\u0017\r^3\u0015\rE#X/`A\u0003\u0011\u00159v\u00021\u0001Z\u0011\u00151x\u00021\u0001x\u0003\tI7\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{\u0019\u0006)!-\u001f;fg&\u0011A0\u001f\u0002\u0016\u0005f$XMQ;gM\u0016\u0014\u0018J\u001c9viN#(/Z1n\u0011\u0015qx\u00021\u0001\u0000\u0003\u0019aWM\\4uQB\u0019!'!\u0001\n\u0007\u0005\r1GA\u0002J]RDa!a\u0002\u0010\u0001\u0004\t\u0014AD3ya\u0016\u001cG/\u001a3WC2,Xm]\u0001'O\u0016$(+\u00198e_6\u001cFO]5oON\u000bW\u000e\u001d7fg^KG\u000f[#naRL8\u000b\u001e:j]\u001e\u001cH#B\u0019\u0002\u000e\u0005E\u0001BBA\b!\u0001\u0007q0\u0001\u0006ok6\u001c\u0016-\u001c9mKNDa!a\u0005\u0011\u0001\u0004y\u0018!C7bq2+gn\u001a;i\u0001")
public class ParquetDeltaLengthByteArrayEncodingSuite
extends ParquetCompatibilityTest
implements SharedSparkSession {
    private final String[] values;
    private DeltaLengthByteArrayValuesWriter writer;
    private VectorizedDeltaLengthByteArrayReader reader;
    private WritableColumnVector writableColumnVector;
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    public String[] values() {
        return this.values;
    }

    public DeltaLengthByteArrayValuesWriter writer() {
        return this.writer;
    }

    public void writer_$eq(DeltaLengthByteArrayValuesWriter x$1) {
        this.writer = x$1;
    }

    public VectorizedDeltaLengthByteArrayReader reader() {
        return this.reader;
    }

    public void reader_$eq(VectorizedDeltaLengthByteArrayReader x$1) {
        this.reader = x$1;
    }

    private WritableColumnVector writableColumnVector() {
        return this.writableColumnVector;
    }

    private void writableColumnVector_$eq(WritableColumnVector x$1) {
        this.writableColumnVector = x$1;
    }

    @Override
    public void beforeEach() {
        this.writer_$eq(new DeltaLengthByteArrayValuesWriter(65536, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator()));
        this.reader_$eq(new VectorizedDeltaLengthByteArrayReader());
        SharedSparkSession.beforeAll$(this);
    }

    private void writeData(DeltaLengthByteArrayValuesWriter writer, String[] values) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> writer.writeBytes(Binary.fromString((String)values[i])));
    }

    private void readAndValidate(VectorizedDeltaLengthByteArrayReader reader, ByteBufferInputStream is, int length, String[] expectedValues) {
        this.writableColumnVector_$eq((WritableColumnVector)new OnHeapColumnVector(length, (DataType)StringType$.MODULE$));
        reader.initFromPage(length, is);
        reader.readBinary(length, this.writableColumnVector(), 0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), length).foreach((Function1 & Serializable & scala.Serializable)i -> ParquetDeltaLengthByteArrayEncodingSuite.$anonfun$readAndValidate$1(this, expectedValues, BoxesRunTime.unboxToInt((Object)i)));
    }

    public String[] getRandomStringSamplesWithEmptyStrings(int numSamples, int maxLength) {
        Random randomLen = new Random();
        Random randomEmpty = new Random();
        String[] samples = new String[numSamples];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSamples).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int maxLen = randomLen.nextInt(maxLength);
            if (randomEmpty.nextInt() % 11 != 0) {
                maxLen = 0;
            }
            samples$1[i] = RandomStringUtils.randomAlphanumeric((int)0, (int)maxLen);
        });
        return samples;
    }

    public static final /* synthetic */ Assertion $anonfun$new$6(ParquetDeltaLengthByteArrayEncodingSuite $this, int i) {
        String $org_scalatest_assert_macro_left = $this.values()[i];
        int $org_scalatest_assert_macro_right = $this.writableColumnVector().getInt(i);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaLengthByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
    }

    public static final /* synthetic */ Assertion $anonfun$readAndValidate$1(ParquetDeltaLengthByteArrayEncodingSuite $this, String[] expectedValues$1, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(expectedValues$1[i].getBytes())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray($this.writableColumnVector().getBinary(i))), "scala.Predef.byteArrayOps(expectedValues.apply(i).getBytes()).sameElements[Byte](scala.Predef.wrapByteArray(ParquetDeltaLengthByteArrayEncodingSuite.this.writableColumnVector.getBinary(i)))", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaLengthByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
    }

    public ParquetDeltaLengthByteArrayEncodingSuite() {
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.values = (String[])((Object[])new String[]{"parquet", "hadoop", "mapreduce"});
        this.test("test serialization", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.writeData(this.writer(), this.values());
            this.readAndValidate(this.reader(), this.writer().getBytes().toInputStream(), this.values().length, this.values());
        }, new Position("ParquetDeltaLengthByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("random strings", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String[] values = Utils.getRandomStringSamples((int)1000, (int)32);
            this.writeData(this.writer(), values);
            this.readAndValidate(this.reader(), this.writer().getBytes().toInputStream(), values.length, values);
        }, new Position("ParquetDeltaLengthByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("random strings with empty strings", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String[] values = this.getRandomStringSamplesWithEmptyStrings(1000, 32);
            this.writeData(this.writer(), values);
            this.readAndValidate(this.reader(), this.writer().getBytes().toInputStream(), values.length, values);
        }, new Position("ParquetDeltaLengthByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("skip with random strings", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int i;
            String[] values = Utils.getRandomStringSamples((int)1000, (int)32);
            this.writeData(this.writer(), values);
            this.reader().initFromPage(values.length, this.writer().getBytes().toInputStream());
            this.writableColumnVector_$eq((WritableColumnVector)new OnHeapColumnVector(values.length, (DataType)StringType$.MODULE$));
            for (i = 0; i < values.length; i += 2) {
                this.reader().readBinary(1, this.writableColumnVector(), i);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(values[i].getBytes())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.writableColumnVector().getBinary(i))), "scala.Predef.byteArrayOps(values.apply(i).getBytes()).sameElements[Byte](scala.Predef.wrapByteArray(ParquetDeltaLengthByteArrayEncodingSuite.this.writableColumnVector.getBinary(i)))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaLengthByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
                this.reader().skipBinary(1);
            }
            this.reader_$eq(new VectorizedDeltaLengthByteArrayReader());
            this.reader().initFromPage(values.length, this.writer().getBytes().toInputStream());
            this.writableColumnVector_$eq((WritableColumnVector)new OnHeapColumnVector(values.length, (DataType)StringType$.MODULE$));
            int skipCount = 0;
            for (i = 0; i < values.length; i += skipCount + 1) {
                skipCount = (values.length - i) / 2;
                this.reader().readBinary(1, this.writableColumnVector(), i);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(values[i].getBytes())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.writableColumnVector().getBinary(i))), "scala.Predef.byteArrayOps(values.apply(i).getBytes()).sameElements[Byte](scala.Predef.wrapByteArray(ParquetDeltaLengthByteArrayEncodingSuite.this.writableColumnVector.getBinary(i)))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaLengthByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
                this.reader().skipBinary(skipCount);
            }
        }, new Position("ParquetDeltaLengthByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("test lengths", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            VectorizedDeltaBinaryPackedReader reader = new VectorizedDeltaBinaryPackedReader();
            this.writeData(this.writer(), this.values());
            int length = this.values().length;
            this.writableColumnVector_$eq((WritableColumnVector)new OnHeapColumnVector(length, (DataType)IntegerType$.MODULE$));
            reader.initFromPage(length, this.writer().getBytes().toInputStream());
            reader.readIntegers(length, this.writableColumnVector(), 0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), length).foreach((Function1 & Serializable & scala.Serializable)i -> ParquetDeltaLengthByteArrayEncodingSuite.$anonfun$new$6(this, BoxesRunTime.unboxToInt((Object)i)));
        }, new Position("ParquetDeltaLengthByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
    }
}

