/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VarcharType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005UbaB\u0006\r!\u0003\r\t!\u0006\u0005\u0006A\u0001!\t!\t\u0005\u0006Q\u00011\t!\u000b\u0005\u0006k\u0001!\tA\u000e\u0005\u0006\t\u0002!\t!\u0012\u0005\u0006%\u0002!Ia\u0015\u0005\u00061\u0002!I!\u0017\u0005\u0006W\u0002!I\u0001\u001c\u0005\fa\u0002\u0001\n1!A\u0001\n\u0013\tX\u000f\u0003\u0007z\u0001A\u0005\u0019\u0011!A\u0005\ni\f)\u0001\u0003\b\u0002\n\u0001\u0001\n1!A\u0001\n\u0013\tY!!\r\u0003)\rC\u0017M\u001d,be\u000eD\u0017M\u001d+fgR\u001cV/\u001b;f\u0015\tia\"A\u0002tc2T!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\r\u0001aC\u0007\t\u0003/ai\u0011\u0001D\u0005\u000331\u0011\u0011\"U;fef$Vm\u001d;\u0011\u0005mqR\"\u0001\u000f\u000b\u0005ua\u0011\u0001\u0002;fgRL!a\b\u000f\u0003\u0019M\u000bF\nV3tiV#\u0018\u000e\\:\u0002\r\u0011Jg.\u001b;%)\u0005\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#\u0001B+oSR\faAZ8s[\u0006$X#\u0001\u0016\u0011\u0005-\u0012dB\u0001\u00171!\tiC%D\u0001/\u0015\tyC#\u0001\u0004=e>|GOP\u0005\u0003c\u0011\na\u0001\u0015:fI\u00164\u0017BA\u001a5\u0005\u0019\u0019FO]5oO*\u0011\u0011\u0007J\u0001\rG\",7m[\"pYRK\b/\u001a\u000b\u0004E]z\u0004\"\u0002\u001d\u0004\u0001\u0004I\u0014!\u00014\u0011\u0005ijT\"A\u001e\u000b\u0005qb\u0011!\u0002;za\u0016\u001c\u0018B\u0001 <\u0005-\u0019FO];di\u001aKW\r\u001c3\t\u000b\u0001\u001b\u0001\u0019A!\u0002\u0005\u0011$\bC\u0001\u001eC\u0013\t\u00195H\u0001\u0005ECR\fG+\u001f9f\u0003A\u0019\u0007.Z2l!2\f\u0017N\u001c*fgVdG\u000f\u0006\u0003#\r>\u0003\u0006\"B$\u0005\u0001\u0004A\u0015A\u00013g!\tIEJ\u0004\u0002\u0018\u0015&\u00111\nD\u0001\ba\u0006\u001c7.Y4f\u0013\tieJA\u0005ECR\fgI]1nK*\u00111\n\u0004\u0005\u0006\u0001\u0012\u0001\rA\u000b\u0005\u0006#\u0012\u0001\rAK\u0001\nS:\u001cXM\u001d;WC2\fa\u0002^3tiR\u000b'\r\\3Xe&$X\r\u0006\u0002#)\")\u0001(\u0002a\u0001+B!1E\u0016\u0016#\u0013\t9FEA\u0005Gk:\u001cG/[8oc\u0005qA/Z:u\u0007>tG-\u001b;j_:\u001cHc\u0001\u0012[7\")qI\u0002a\u0001\u0011\")AL\u0002a\u0001;\u0006Q1m\u001c8eSRLwN\\:\u0011\u0007y\u0013WM\u0004\u0002`C:\u0011Q\u0006Y\u0005\u0002K%\u00111\nJ\u0005\u0003G\u0012\u00141aU3r\u0015\tYE\u0005\u0005\u0003$M*B\u0017BA4%\u0005\u0019!V\u000f\u001d7feA\u00111%[\u0005\u0003U\u0012\u0012qAQ8pY\u0016\fg.\u0001\nuKN$h*\u001e7m\u0007>tG-\u001b;j_:\u001cHc\u0001\u0012n]\")qi\u0002a\u0001\u0011\")Al\u0002a\u0001_B\u0019aL\u0019\u0016\u00025M,\b/\u001a:%G\",7m[#se>\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003I\u00042aI:+\u0013\t!HE\u0001\u0004PaRLwN\\\u0005\u0003m^\fAc\u00195fG.,%O]8sI\u0011,g-Y;mi\u0012\u001a\u0014B\u0001=\u000f\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u0006Q2/\u001e9fe\u0012\u001a\u0007.Z2l\u000bJ\u0014xN\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\t1\u0010E\u0002$yzL!! \u0013\u0003\u000b\u0005\u0013(/Y=\u0011\u0007}\f\t!D\u0001\u000f\u0013\r\t\u0019A\u0004\u0002\r#V,'/_\"p]R,\u0007\u0010^\u0005\u0004\u0003\u000f9\u0018\u0001F2iK\u000e\\WI\u001d:pe\u0012\"WMZ1vYR$c'\u0001\ttkB,'\u000fJ2iK\u000e\\WI\u001d:peRi!%!\u0004\u0002\u0018\u0005m\u0011qDA\u0015\u0003[Aq!a\u0004\u000b\u0001\u0004\t\t\"A\u0005fq\u000e,\u0007\u000f^5p]B\u0019q0a\u0005\n\u0007\u0005UaB\u0001\bTa\u0006\u00148\u000e\u00165s_^\f'\r\\3\t\r\u0005e!\u00021\u0001+\u0003))'O]8s\u00072\f7o\u001d\u0005\t\u0003;Q\u0001\u0013!a\u0001e\u0006A1/\u001d7Ti\u0006$X\rC\u0005\u0002\")\u0001\n\u00111\u0001\u0002$\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0011\u000b-\n)C\u000b\u0016\n\u0007\u0005\u001dBGA\u0002NCBD\u0001\"a\u000b\u000b!\u0003\u0005\r\u0001[\u0001\u000b[\u0006$8\r\u001b)WC2\u001c\b\u0002CA\u0018\u0015A\u0005\t\u0019A>\u0002\u0019E,XM]=D_:$X\r\u001f;\n\u0007\u0005Mr/\u0001\u0006dQ\u0016\u001c7.\u0012:s_J\u0004")
public interface CharVarcharTestSuite
extends SQLTestUtils {
    public /* synthetic */ Option org$apache$spark$sql$CharVarcharTestSuite$$super$checkError$default$3();

    public /* synthetic */ QueryContext[] org$apache$spark$sql$CharVarcharTestSuite$$super$checkError$default$6();

    public /* synthetic */ void org$apache$spark$sql$CharVarcharTestSuite$$super$checkError(SparkThrowable var1, String var2, Option var3, Map var4, boolean var5, QueryContext[] var6);

    public String format();

    public static /* synthetic */ void checkColType$(CharVarcharTestSuite $this, StructField f, DataType dt) {
        $this.checkColType(f, dt);
    }

    default public void checkColType(StructField f, DataType dt) {
        DataType $org_scalatest_assert_macro_left = f.dataType();
        DataType $org_scalatest_assert_macro_right = CharVarcharUtils$.MODULE$.replaceCharVarcharWithString(dt);
        DataType dataType = $org_scalatest_assert_macro_left;
        DataType dataType2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        Option $org_scalatest_assert_macro_left2 = CharVarcharUtils$.MODULE$.getRawType(f.metadata());
        Some $org_scalatest_assert_macro_right2 = new Some((Object)dt);
        Option option = $org_scalatest_assert_macro_left2;
        Some some = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
    }

    public static /* synthetic */ void checkPlainResult$(CharVarcharTestSuite $this, Dataset df, String dt, String insertVal) {
        $this.checkPlainResult((Dataset<Row>)df, dt, insertVal);
    }

    default public void checkPlainResult(Dataset<Row> df, String dt, String insertVal) {
        DataType dataType = CatalystSqlParser$.MODULE$.parseDataType(dt);
        this.checkColType(df.schema().apply(1), dataType);
        DataType dataType2 = dataType;
        if (dataType2 instanceof CharType) {
            CharType charType = (CharType)dataType2;
            int len = charType.length();
            String fixLenStr = insertVal != null ? ((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(insertVal)).take(len))).padTo(len, (Object)" ", Predef$.MODULE$.fallbackStringCanBuildFrom())).mkString() : null;
            ((QueryTest)((Object)this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", fixLenStr})));
            return;
        }
        if (dataType2 instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType2;
            int len = varcharType.length();
            String varLenStrWithUpperBound = insertVal != null ? (String)new StringOps(Predef$.MODULE$.augmentString(insertVal)).take(len) : null;
            ((QueryTest)((Object)this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", varLenStrWithUpperBound})));
            return;
        }
        throw new MatchError((Object)dataType2);
    }

    private void testTableWrite(Function1<String, BoxedUnit> f) {
        this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> f.apply((Object)"char"));
        this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> f.apply((Object)"varchar"));
    }

    private void testConditions(Dataset<Row> df, Seq<Tuple2<String, Object>> conditions) {
        ((QueryTest)((Object)this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df.selectExpr((Seq)conditions.map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Seq$.MODULE$.canBuildFrom())), Row$.MODULE$.fromSeq((Seq)conditions.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2._2$mcZ$sp()), Seq$.MODULE$.canBuildFrom())));
    }

    private void testNullConditions(Dataset<Row> df, Seq<String> conditions) {
        conditions.foreach((Function1 & Serializable & scala.Serializable)cond -> {
            CharVarcharTestSuite.$anonfun$testNullConditions$1(this, df, cond);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ String $anonfun$$init$$4(int n) {
        return new StringBuilder(1).append("a").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(n)).toString();
    }

    public static /* synthetic */ void $anonfun$$init$$5(CharVarcharTestSuite $this, String typ$1, String v) {
        $this.sql().apply((Object)new StringBuilder(35).append("INSERT OVERWRITE t VALUES ('1', '").append(v).append("')").toString());
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ$1, v);
    }

    public static /* synthetic */ String $anonfun$$init$$8(int n) {
        return new StringBuilder(1).append("a").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(n)).toString();
    }

    public static /* synthetic */ void $anonfun$$init$$9(CharVarcharTestSuite $this, String v) {
        $this.sql().apply((Object)new StringBuilder(35).append("INSERT OVERWRITE t VALUES ('1', '").append(v).append("')").toString());
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "CHAR(5)", v);
    }

    public static /* synthetic */ String $anonfun$$init$$11(int n) {
        return new StringBuilder(1).append("a").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(n)).toString();
    }

    public static /* synthetic */ void $anonfun$$init$$12(CharVarcharTestSuite $this, String v) {
        $this.sql().apply((Object)new StringBuilder(30).append("INSERT INTO t VALUES ('1', '").append(v).append("')").toString());
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "CHAR(5)", v);
        $this.sql().apply((Object)"ALTER TABLE t DROP PARTITION(c='a')");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), (Seq<Row>)Nil$.MODULE$);
        $this.sql().apply((Object)new StringBuilder(44).append("INSERT INTO t PARTITION (c ='").append(v).append("') VALUES ('1')").toString());
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "CHAR(5)", v);
        $this.sql().apply((Object)"ALTER TABLE t DROP PARTITION(c='a')");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), (Seq<Row>)Nil$.MODULE$);
    }

    public static /* synthetic */ void $anonfun$$init$$80(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(28).append("CREATE TABLE t(c ").append(typeName).append("(5)) USING ").append($this.format()).toString());
        $this.sql().apply((Object)"INSERT INTO t VALUES (null)");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES ('123456')"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307)));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
    }

    public static /* synthetic */ void $anonfun$$init$$84(CharVarcharTestSuite $this, String tableName$1, String typeName) {
        $this.sql().apply((Object)new StringBuilder(53).append("CREATE TABLE ").append(tableName$1).append("(i INT, c ").append(typeName).append("(5)) USING ").append($this.format()).append(" PARTITIONED BY (c)").toString());
        $this.sql().apply((Object)new StringBuilder(29).append("INSERT INTO ").append(tableName$1).append(" VALUES (1, null)").toString());
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table(tableName$1), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(33).append("INSERT INTO ").append(tableName$1).append(" VALUES (1, '123456')").toString()), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320)));
        SparkException x$1 = (SparkException)e.getCause();
        String x$2 = "TASK_WRITE_FAILED";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)new StringBuilder(4).append(".*").append(tableName$1).append(".*").toString())}));
        boolean x$4 = true;
        Option x$5 = $this.org$apache$spark$sql$CharVarcharTestSuite$$super$checkError$default$3();
        QueryContext[] x$6 = $this.org$apache$spark$sql$CharVarcharTestSuite$$super$checkError$default$6();
        $this.org$apache$spark$sql$CharVarcharTestSuite$$super$checkError((SparkThrowable)x$1, x$2, x$5, x$3, x$4, x$6);
    }

    public static /* synthetic */ void $anonfun$$init$$88(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(39).append("CREATE TABLE t(c STRUCT<c: ").append(typeName).append("(5)>) USING ").append($this.format()).toString());
        $this.sql().apply((Object)"INSERT INTO t SELECT struct(null)");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null}))})));
        RuntimeException e = (RuntimeException)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t SELECT struct('123456')"), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
    }

    public static /* synthetic */ void $anonfun$$init$$92(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(35).append("CREATE TABLE t(c ARRAY<").append(typeName).append("(5)>) USING ").append($this.format()).toString());
        $this.sql().apply((Object)"INSERT INTO t VALUES (array(null))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (array('a', '123456'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346)));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
    }

    public static /* synthetic */ void $anonfun$$init$$96(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(41).append("CREATE TABLE t(c MAP<").append(typeName).append("(5), STRING>) USING ").append($this.format()).toString());
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (map('123456', 'a'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354)));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
    }

    public static /* synthetic */ void $anonfun$$init$$99(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(41).append("CREATE TABLE t(c MAP<STRING, ").append(typeName).append("(5)>) USING ").append($this.format()).toString());
        $this.sql().apply((Object)"INSERT INTO t VALUES (map('a', null))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null)}))})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (map('a', '123456'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364)));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
    }

    public static /* synthetic */ void $anonfun$$init$$103(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(38).append("CREATE TABLE t(c MAP<").append(typeName).append("(5), ").append(typeName).append("(5)>) USING ").append($this.format()).toString());
        SparkException e1 = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (map('123456', 'a'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372)));
        String $org_scalatest_assert_macro_left = e1.getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        SparkException e2 = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (map('a', '123456'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374)));
        String $org_scalatest_assert_macro_left2 = e2.getMessage();
        String $org_scalatest_assert_macro_right2 = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
    }

    public static /* synthetic */ void $anonfun$$init$$107(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(46).append("CREATE TABLE t(c STRUCT<c: ARRAY<").append(typeName).append("(5)>>) USING ").append($this.format()).toString());
        $this.sql().apply((Object)"INSERT INTO t SELECT struct(array(null))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}))}))})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t SELECT struct(array('123456'))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384)));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
    }

    public static /* synthetic */ void $anonfun$$init$$111(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(46).append("CREATE TABLE t(c ARRAY<STRUCT<c: ").append(typeName).append("(5)>>) USING ").append($this.format()).toString());
        $this.sql().apply((Object)"INSERT INTO t VALUES (array(struct(null)))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$)})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (array(struct('123456')))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394)));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
    }

    public static /* synthetic */ void $anonfun$$init$$115(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE t(c ARRAY<ARRAY<").append(typeName).append("(5)>>) USING ").append($this.format()).toString());
        $this.sql().apply((Object)"INSERT INTO t VALUES (array(array(null)))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}))), (List)Nil$.MODULE$)})));
        SparkException e = (SparkException)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (array(array('123456')))"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404)));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
    }

    public static /* synthetic */ void $anonfun$testNullConditions$1(CharVarcharTestSuite $this, Dataset df$3, String cond) {
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df$3.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{cond})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})));
    }

    public static /* synthetic */ void $anonfun$$init$$135(CharVarcharTestSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String con = (String)tuple2._1();
            boolean res = tuple2._2$mcZ$sp();
            Dataset df = $this.spark().table("t");
            BoxedUnit cfr_ignored_0 = (BoxedUnit)((Assertions)$this).withClue((Object)con, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df.where(con), (Dataset<Row>)df.where(Boolean.toString(res))));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ void $anonfun$$init$$169(CharVarcharTestSuite $this, String predicate) {
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n             |SELECT v FROM t1\n             |WHERE 'a' IN (SELECT v FROM t2 WHERE ").append(predicate).append(")\n           ").toString())).stripMargin()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"c"})));
    }

    public static /* synthetic */ void $anonfun$$init$$173(CharVarcharTestSuite $this, String predicate) {
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(184).append("\n             |SELECT c0 FROM t t1\n             |WHERE (\n             |  SELECT count(*) AS c\n             |  FROM t\n             |  WHERE c0 = t1.c0 AND ").append(predicate).append("\n             |) > 0\n         ").toString())).stripMargin()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
    }

    public static void $init$(CharVarcharTestSuite $this) {
        $this.test("apply char padding/trimming and varchar trimming: top-level columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"CHAR(5)", (List)new .colon.colon((Object)"VARCHAR(5)", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)typ -> {
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(35).append("CREATE TABLE t(i STRING, c ").append(typ).append(") USING ").append($this.format()).toString());
                ((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)n -> CharVarcharTestSuite.$anonfun$$init$$4(BoxesRunTime.unboxToInt((Object)n)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)v -> {
                    CharVarcharTestSuite.$anonfun$$init$$5($this, typ, v);
                    return BoxedUnit.UNIT;
                });
                $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
            });
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        $this.test("char type values should be padded or trimmed: partitioned columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(61).append("CREATE TABLE t(i STRING, c CHAR(5)) USING ").append($this.format()).append(" PARTITIONED BY (c)").toString());
                ((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)n -> CharVarcharTestSuite.$anonfun$$init$$8(BoxesRunTime.unboxToInt((Object)n)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)v -> {
                    CharVarcharTestSuite.$anonfun$$init$$9($this, v);
                    return BoxedUnit.UNIT;
                });
            });
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(61).append("CREATE TABLE t(i STRING, c CHAR(5)) USING ").append($this.format()).append(" PARTITIONED BY (c)").toString());
                ((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)n -> CharVarcharTestSuite.$anonfun$$init$$11(BoxesRunTime.unboxToInt((Object)n)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)v -> {
                    CharVarcharTestSuite.$anonfun$$init$$12($this, v);
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        $this.test("char type values should not be padded when charVarcharAsString is true", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_CHAR_VARCHAR_AS_STRING().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(72).append("CREATE TABLE t(a STRING, b CHAR(5), c CHAR(5)) USING ").append($this.format()).append(" partitioned by (c)").toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('abc', 'abc', 'abc')");
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT b FROM t WHERE b='abc'"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT b FROM t WHERE b in ('abc')"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT c FROM t WHERE c='abc'"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT c FROM t WHERE c in ('abc')"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
        })), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        $this.test("varchar type values length check and trim: partitioned columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)n -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(64).append("CREATE TABLE t(i STRING, c VARCHAR(5)) USING ").append($this.format()).append(" PARTITIONED BY (c)").toString());
            String v = new StringBuilder(1).append("a").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(n)).toString();
            $this.sql().apply((Object)new StringBuilder(30).append("INSERT INTO t VALUES ('1', '").append(v).append("')").toString());
            $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "VARCHAR(5)", v);
            $this.sql().apply((Object)new StringBuilder(34).append("ALTER TABLE t DROP PARTITION(c='").append(v).append("')").toString());
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), (Seq<Row>)Nil$.MODULE$);
            $this.sql().apply((Object)new StringBuilder(43).append("INSERT INTO t PARTITION (c='").append(v).append("') VALUES ('1')").toString());
            $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "VARCHAR(5)", v);
            $this.sql().apply((Object)new StringBuilder(34).append("ALTER TABLE t DROP PARTITION(c='").append(v).append("')").toString());
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), (Seq<Row>)Nil$.MODULE$);
        })), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        $this.test("oversize char/varchar values for alter table partition operations", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"CHAR(5)", (List)new .colon.colon((Object)"VARCHAR(5)", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)typ -> {
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE t(i STRING, c ").append(typ).append(") USING ").append($this.format()).append(" PARTITIONED BY (c)").toString());
                ((IterableLike)new .colon.colon((Object)"ADD", (List)new .colon.colon((Object)"DROP", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)op -> {
                    RuntimeException e = (RuntimeException)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(36).append("ALTER TABLE t ").append((String)op).append(" PARTITION(c='abcdef')").toString()), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
                    String $org_scalatest_assert_macro_left = e.getMessage();
                    String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
                });
                RuntimeException e1 = (RuntimeException)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"ALTER TABLE t PARTITION (c='abcdef') RENAME TO PARTITION (c='2')"), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
                String $org_scalatest_assert_macro_left = e1.getMessage();
                String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
                RuntimeException e2 = (RuntimeException)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"ALTER TABLE t PARTITION (c='1') RENAME TO PARTITION (c='abcdef')"), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                String $org_scalatest_assert_macro_left2 = e2.getMessage();
                String $org_scalatest_assert_macro_right2 = "Exceeds char/varchar type length limitation: 5";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            });
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        $this.test("SPARK-34233: char/varchar with null value for partitioned columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"CHAR(5)", (List)new .colon.colon((Object)"VARCHAR(5)", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)typ -> {
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE t(i STRING, c ").append(typ).append(") USING ").append($this.format()).append(" PARTITIONED BY (c)").toString());
                $this.sql().apply((Object)"INSERT INTO t VALUES ('1', null)");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
                $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
                $this.sql().apply((Object)"INSERT OVERWRITE t PARTITION (c=null) VALUES ('1')");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
                $this.sql().apply((Object)"ALTER TABLE t DROP PARTITION(c=null)");
                ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), (Seq<Row>)Nil$.MODULE$);
            });
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        $this.test("char type values should be padded: nested in struct", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(53).append("CREATE TABLE t(i STRING, c STRUCT<c: CHAR(5)>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', struct('a'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(1).append("a").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(4)).toString()}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)new StructType().add("c", (DataType)new CharType(5)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', struct(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        $this.test("char type values should be padded: nested in array", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(49).append("CREATE TABLE t(i STRING, c ARRAY<CHAR(5)>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', array('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", new .colon.colon((Object)new StringBuilder(1).append("a").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(4)).toString(), (List)new .colon.colon((Object)new StringBuilder(2).append("ab").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(3)).toString(), (List)Nil$.MODULE$))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        $this.test("char type values should be padded: nested in map key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(55).append("CREATE TABLE t(i STRING, c MAP<CHAR(5), STRING>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', map('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new StringBuilder(1).append("a").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(4)).toString(), (Object)"ab")}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)MapType$.MODULE$.apply((DataType)new CharType(5), (DataType)StringType$.MODULE$));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        $this.test("char type values should be padded: nested in map value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(55).append("CREATE TABLE t(i STRING, c MAP<STRING, CHAR(5)>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', map('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)new StringBuilder(2).append("ab").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(3)).toString())}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)new CharType(5)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', map('a', null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null)}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        $this.test("char type values should be padded: nested in both map key and value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(57).append("CREATE TABLE t(i STRING, c MAP<CHAR(5), CHAR(10)>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', map('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new StringBuilder(1).append("a").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(4)).toString(), (Object)new StringBuilder(2).append("ab").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(8)).toString())}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)MapType$.MODULE$.apply((DataType)new CharType(5), (DataType)new CharType(10)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        $this.test("char type values should be padded: nested in struct of array", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(60).append("CREATE TABLE t(i STRING, c STRUCT<c: ARRAY<CHAR(5)>>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', struct(array('a', 'ab')))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)new StringBuilder(1).append("a").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(4)).toString(), (List)new .colon.colon((Object)new StringBuilder(2).append("ab").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(3)).toString(), (List)Nil$.MODULE$))}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)new StructType().add("c", (DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5))));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', struct(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null}))})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', struct(array(null)))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}))}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        $this.test("char type values should be padded: nested in array of struct", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(60).append("CREATE TABLE t(i STRING, c ARRAY<STRUCT<c: CHAR(5)>>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', array(struct('a'), struct('ab')))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(1).append("a").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(4)).toString()})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(2).append("ab").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(3)).toString()})), (List)Nil$.MODULE$))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)ArrayType$.MODULE$.apply((DataType)new StructType().add("c", (DataType)new CharType(5))));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(struct(null)))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$)})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        $this.test("char type values should be padded: nested in array of array", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(56).append("CREATE TABLE t(i STRING, c ARRAY<ARRAY<CHAR(5)>>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', array(array('a', 'ab')))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", new .colon.colon((Object)((Seq)new .colon.colon((Object)new StringBuilder(1).append("a").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(4)).toString(), (List)new .colon.colon((Object)new StringBuilder(2).append("ab").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(3)).toString(), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5))));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(array(null)))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}))), (List)Nil$.MODULE$)})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        $this.test("length check for input string values: top-level columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$80($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
        $this.test("length check for input string values: partitioned columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            if (!$this.conf().contains(SQLConf$.MODULE$.DEFAULT_CATALOG().key())) {
                String tableName = "t";
                $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)typeName -> {
                    CharVarcharTestSuite.$anonfun$$init$$84($this, tableName, typeName);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }, new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        $this.test("length check for input string values: nested in struct", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$88($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        $this.test("length check for input string values: nested in array", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$92($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        $this.test("length check for input string values: nested in map key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$96($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        $this.test("length check for input string values: nested in map value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$99($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        $this.test("length check for input string values: nested in both map key and value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$103($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
        $this.test("length check for input string values: nested in struct of array", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$107($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
        $this.test("length check for input string values: nested in array of struct", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$111($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        $this.test("length check for input string values: nested in array of array", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$115($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
        $this.test("length check for input string values: with trailing spaces", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE t(c1 CHAR(5), c2 VARCHAR(5)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('12 ', '12 ')");
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1234  ', '1234  ')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(2).append("12").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(3)).toString(), "12 "})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1234 ", "1234 "})), (List)Nil$.MODULE$))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        $this.test("length check for input string values: with implicit cast", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE t(c1 CHAR(5), c2 VARCHAR(5)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (1234, 1234)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1234 ", "1234"})));
            SparkException e1 = (SparkException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (123456, 1)"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425)))));
            String $org_scalatest_assert_macro_left = e1.getMessage();
            String $org_scalatest_assert_macro_right = "Exceeds char/varchar type length limitation: 5";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
            SparkException e2 = (SparkException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t VALUES (1, 123456)"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427)))));
            String $org_scalatest_assert_macro_left2 = e2.getMessage();
            String $org_scalatest_assert_macro_right2 = "Exceeds char/varchar type length limitation: 5";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        $this.test("char type comparison: top-level columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(45).append("CREATE TABLE t(c1 CHAR(2), c2 CHAR(5)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('a', 'a')");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"'a' = c1", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 > 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 <=> null", (Object)BoxesRunTime.boxToBoolean((boolean)false))}))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        $this.test("char type comparison: partitioned columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(76).append("CREATE TABLE t(i INT, c1 CHAR(2), c2 CHAR(5)) USING ").append($this.format()).append(" PARTITIONED BY (c1, c2)").toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'a', 'a')");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"'a' = c1", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 > 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 <=> null", (Object)BoxesRunTime.boxToBoolean((boolean)false))}))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
        $this.test("SPARK-34233: char type comparison with null values", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq conditions = (Seq)new .colon.colon((Object)"c = null", (List)new .colon.colon((Object)"c IN ('e', null)", (List)new .colon.colon((Object)"c IN (null)", (List)Nil$.MODULE$)));
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(32).append("CREATE TABLE t(c CHAR(2)) USING ").append($this.format()).toString());
                $this.sql().apply((Object)"INSERT INTO t VALUES ('a')");
                $this.testNullConditions((Dataset<Row>)$this.spark().table("t"), (Seq<String>)conditions);
            });
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(58).append("CREATE TABLE t(i INT, c CHAR(2)) USING ").append($this.format()).append(" PARTITIONED BY (c)").toString());
                $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'a')");
                $this.testNullConditions((Dataset<Row>)$this.spark().table("t"), (Seq<String>)conditions);
            });
        }, new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 476));
        $this.test("char type comparison: partition pruning", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(79).append("CREATE TABLE t(i INT, c1 CHAR(2), c2 VARCHAR(5)) USING ").append($this.format()).append(" PARTITIONED BY (c1, c2)").toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'a', 'a')");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"'a' = c1", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 > 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c2 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c2 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c2 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true))}))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                CharVarcharTestSuite.$anonfun$$init$$135($this, x0$1);
                return BoxedUnit.UNIT;
            });
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
        $this.test("char type comparison: join", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(33).append("CREATE TABLE t1(c CHAR(2)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)new StringBuilder(33).append("CREATE TABLE t2(c CHAR(5)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t1 VALUES ('a')");
            $this.sql().apply((Object)"INSERT INTO t2 VALUES ('a')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT t1.c FROM t1 JOIN t2 ON t1.c = t2.c"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a "})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
        $this.test("char type comparison: nested in struct", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(67).append("CREATE TABLE t(c1 STRUCT<c: CHAR(2)>, c2 STRUCT<c: CHAR(5)>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (struct('a'), struct('a'))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
        $this.test("char type comparison: nested in array", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(59).append("CREATE TABLE t(c1 ARRAY<CHAR(2)>, c2 ARRAY<CHAR(5)>) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (array('a', 'b'), array('a', 'b'))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
        $this.test("char type comparison: nested in struct of array", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(81).append("CREATE TABLE t(c1 STRUCT<a: ARRAY<CHAR(2)>>, c2 STRUCT<a: ARRAY<CHAR(5)>>) ").append("USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (struct(array('a', 'b')), struct(array('a', 'b')))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543));
        $this.test("char type comparison: nested in array of struct", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(81).append("CREATE TABLE t(c1 ARRAY<STRUCT<c: CHAR(2)>>, c2 ARRAY<STRUCT<c: CHAR(5)>>) ").append("USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (array(struct('a')), array(struct('a')))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 555));
        $this.test("char type comparison: nested in array of array", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(73).append("CREATE TABLE t(c1 ARRAY<ARRAY<CHAR(2)>>, c2 ARRAY<ARRAY<CHAR(5)>>) ").append("USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (array(array('a')), array(array('a')))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
        $this.test("SPARK-33892: DESCRIBE TABLE w/ char/varchar", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(46).append("CREATE TABLE t(v VARCHAR(3), c CHAR(5)) USING ").append($this.format()).toString());
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> ((Dataset)$this.sql().apply((Object)"desc t")).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data_type"})).where("data_type like '%char%'"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"char(5)"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"varchar(3)"})), (List)Nil$.MODULE$))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
        $this.test("SPARK-34003: fix char/varchar fails w/ both group by and order by ", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE t(v VARCHAR(3), i INT) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c', 1)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT v, sum(i) FROM t GROUP BY v ORDER BY v"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"c", BoxesRunTime.boxToInteger((int)1)})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
        $this.test("SPARK-34003: fix char/varchar fails w/ order by functions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE t(v VARCHAR(3), i INT) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c', 1)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT substr(v, 1, 2), sum(i) FROM t GROUP BY v ORDER BY substr(v, 1, 2)"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"c", BoxesRunTime.boxToInteger((int)1)})));
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT sum(i) FROM t GROUP BY v ORDER BY substr(v, 1, 2)"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
        $this.test("SPARK-34114: varchar type will strip tailing spaces to certain length at write time", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(35).append("CREATE TABLE t(v VARCHAR(3)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c      ')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"c  "})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
        $this.test("SPARK-34114: varchar type will remain the value length with spaces at read time", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(35).append("CREATE TABLE t(v VARCHAR(3)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c ')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"c "})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
        $this.test("SPARK-34833: right-padding applied correctly for correlated subqueries - join keys", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(47).append("CREATE TABLE t1(v VARCHAR(3), c CHAR(5)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)new StringBuilder(47).append("CREATE TABLE t2(v VARCHAR(5), c CHAR(8)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t1 VALUES ('c', 'b')");
            $this.sql().apply((Object)"INSERT INTO t2 VALUES ('a', 'b')");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1.c = t2.c", "t2.c = t1.c", "t1.c = 'b'", "'b' = t1.c", "t1.c = 'b    '", "'b    ' = t1.c", "t1.c = 'b      '", "'b      ' = t1.c"}))).foreach((Function1 & Serializable & scala.Serializable)predicate -> {
                CharVarcharTestSuite.$anonfun$$init$$169($this, predicate);
                return BoxedUnit.UNIT;
            });
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 622));
        $this.test("SPARK-34833: right-padding applied correctly for correlated subqueries - other preds", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(53).append("CREATE TABLE t(c0 INT, c1 CHAR(5), c2 CHAR(7)) USING ").append($this.format()).toString());
            $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'abc', 'abc')");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1 = 'abc'", "'abc' = c1", "c1 = 'abc  '", "'abc  ' = c1", "c1 = 'abc    '", "'abc    ' = c1", "c1 = c2", "c2 = c1", "c1 IN ('xxx', 'abc', 'xxxxx')", "c1 IN ('xxx', 'abc  ', 'xxxxx')", "c1 IN ('xxx', 'abc    ', 'xxxxx')", "c1 IN (c2)", "c2 IN (c1)"}))).foreach((Function1 & Serializable & scala.Serializable)predicate -> {
                CharVarcharTestSuite.$anonfun$$init$$173($this, predicate);
                return BoxedUnit.UNIT;
            });
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
        $this.test("SPARK-35359: create table and insert data over length values", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"char", (List)new .colon.colon((Object)"varchar", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)typ -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_CHAR_VARCHAR_AS_STRING().key(), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(31).append("CREATE TABLE t (col ").append(typ).append("(2)) using ").append($this.format()).toString());
                $this.sql().apply((Object)"INSERT INTO t SELECT 'aaa'");
                ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"select * from t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"aaa"})));
            }));
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
    }
}

