/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%aaB\u0006\r!\u0003\r\ta\u0006\u0005\u0006Q\u0001!\t!\u000b\u0005\u0006a\u00011\t\"\r\u0005\b\u000b\u0002\u0011\rQ\"\u0005G\u0011\u001d9\u0005A1A\u0007\u0012\u0019CQ\u0001\u0013\u0001\u0005\n%C1b\u0013\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003M3\"Y1\f\u0001I\u0001\u0004\u0003\u0005I\u0011\u0002/a\u0011-\u0011\u0007\u0001%A\u0002\u0002\u0003%IaY4\t\u0017%\u0004\u0001\u0013aA\u0001\u0002\u0013%!.\u001d\u0005\rg\u0002\u0001\n1!A\u0001\n\u0013!\u0018Q\u0001\u0002\u0010\u00032$XM\u001d+bE2,G+Z:ug*\u0011QBD\u0001\nG>tg.Z2u_JT!a\u0004\t\u0002\u0007M\fHN\u0003\u0002\u0012%\u0005)1\u000f]1sW*\u00111\u0003F\u0001\u0007CB\f7\r[3\u000b\u0003U\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\r\u001dEA\u0011\u0011DG\u0007\u0002!%\u00111\u0004\u0005\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}q\u0011\u0001\u0002;fgRL!!\t\u0010\u0003%MC\u0017M]3e'B\f'o[*fgNLwN\u001c\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003K9\ta!\u001a:s_J\u001c\u0018BA\u0014%\u0005=\tV/\u001a:z\u000bJ\u0014xN]:CCN,\u0017A\u0002\u0013j]&$H\u0005F\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;\u0002!\u001d,G\u000fV1cY\u0016lU\r^1eCR\fGC\u0001\u001a9!\t\u0019d'D\u00015\u0015\t)D\"A\u0004dCR\fGn\\4\n\u0005]\"$!\u0002+bE2,\u0007\"B\u001d\u0003\u0001\u0004Q\u0014!\u0003;bE2,g*Y7f!\tY$I\u0004\u0002=\u0001B\u0011Q\bL\u0007\u0002})\u0011qHF\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005c\u0013A\u0002)sK\u0012,g-\u0003\u0002D\t\n11\u000b\u001e:j]\u001eT!!\u0011\u0017\u0002'\r\fG/\u00197pO\u0006sGMT1nKN\u0004\u0018mY3\u0016\u0003i\n\u0001B\u001e\u001aG_Jl\u0017\r^\u0001\u000eMVdG\u000eV1cY\u0016t\u0015-\\3\u0015\u0005iR\u0005\"B\u001d\u0006\u0001\u0004Q\u0014!H:va\u0016\u0014He\u00195fG.,%O]8s)\u0006\u0014G.\u001a(pi\u001a{WO\u001c3\u0015\t)j%k\u0015\u0005\u0006\u001d\u001a\u0001\raT\u0001\nKb\u001cW\r\u001d;j_:\u0004\"!\u0007)\n\u0005E\u0003\"AD*qCJ\\G\u000b\u001b:po\u0006\u0014G.\u001a\u0005\u0006s\u0019\u0001\rA\u000f\u0005\u0006)\u001a\u0001\r!V\u0001\rcV,'/_\"p]R,\u0007\u0010\u001e\t\u0003-^k\u0011\u0001A\u0005\u00031j\u0011q\"\u0012=qK\u000e$X\rZ\"p]R,\u0007\u0010^\u0005\u00035j\tqc\u00195fG.,%O]8s)\u0006\u0014G.\u001a(pi\u001a{WO\u001c3\u00025M,\b/\u001a:%G\",7m[#se>\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003u\u00032a\u000b0;\u0013\tyFF\u0001\u0004PaRLwN\\\u0005\u0003Cj\tAc\u00195fG.,%O]8sI\u0011,g-Y;mi\u0012\u001a\u0014AG:va\u0016\u0014He\u00195fG.,%O]8sI\u0011,g-Y;mi\u0012*T#\u00013\u0011\u0005-*\u0017B\u00014-\u0005\u001d\u0011un\u001c7fC:L!\u0001\u001b\u000e\u0002)\rDWmY6FeJ|'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003i\u0019X\u000f]3sI\rDWmY6FeJ|'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\u0005Y\u0007cA\u0016m]&\u0011Q\u000e\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00033=L!\u0001\u001d\t\u0003\u0019E+XM]=D_:$X\r\u001f;\n\u0005IT\u0012\u0001F2iK\u000e\\WI\u001d:pe\u0012\"WMZ1vYR$c'\u0001\ttkB,'\u000fJ2iK\u000e\\WI\u001d:peRA!&\u001e<yu~\f\u0019\u0001C\u0003O\u0015\u0001\u0007q\nC\u0003x\u0015\u0001\u0007!(\u0001\u0006feJ|'o\u00117bgNDq!\u001f\u0006\u0011\u0002\u0003\u0007Q,\u0001\u0005tc2\u001cF/\u0019;f\u0011\u001dY(\u0002%AA\u0002q\f!\u0002]1sC6,G/\u001a:t!\u0011YTP\u000f\u001e\n\u0005y$%aA'ba\"A\u0011\u0011\u0001\u0006\u0011\u0002\u0003\u0007A-\u0001\u0006nCR\u001c\u0007\u000e\u0015,bYNDq\u0001\u0016\u0006\u0011\u0002\u0003\u00071.C\u0002\u0002\bi\t!b\u00195fG.,%O]8s\u0001")
public interface AlterTableTests
extends SharedSparkSession,
QueryErrorsBase {
    public /* synthetic */ void org$apache$spark$sql$connector$AlterTableTests$$super$checkErrorTableNotFound(SparkThrowable var1, String var2, SparkFunSuite.ExpectedContext var3);

    public /* synthetic */ Option org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$3();

    public /* synthetic */ boolean org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$5();

    public /* synthetic */ QueryContext[] org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$6();

    public /* synthetic */ void org$apache$spark$sql$connector$AlterTableTests$$super$checkError(SparkThrowable var1, String var2, Option var3, scala.collection.immutable.Map var4, boolean var5, QueryContext[] var6);

    public Table getTableMetadata(String var1);

    public String catalogAndNamespace();

    public String v2Format();

    private String fullTableName(String tableName) {
        if (this.catalogAndNamespace().isEmpty()) {
            return new StringBuilder(8).append("default.").append(tableName).toString();
        }
        return new StringBuilder(10).append(this.catalogAndNamespace()).append("table_name").toString();
    }

    public static void $init$(AlterTableTests $this) {
        $this.test("AlterTable: table does not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t2 = new StringBuilder(10).append($this.catalogAndNamespace()).append("fake_table").toString();
            String quoted = ((TraversableOnce)UnresolvedAttribute$.MODULE$.parseAttributeName(new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString()).map((Function1 & Serializable & scala.Serializable)part -> package$.MODULE$.quoteIdentifier(part), Seq$.MODULE$.canBuildFrom())).mkString(".");
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t2).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(37).append("ALTER TABLE ").append($this.catalogAndNamespace()).append("table_name DROP COLUMN id").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55)))));
                $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkErrorTableNotFound((SparkThrowable)exc, quoted, ((SparkFunSuite)$this).ExpectedContext().apply(new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString(), 12, 11 + new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString().length()));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        $this.test("AlterTable: change rejected by implementation", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                SparkException exc = (SparkException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(27).append("ALTER TABLE ").append(t).append(" DROP COLUMN id").toString()), ClassTag$.MODULE$.apply(SparkException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Unsupported table change";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "Cannot drop all fields";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right3 = tableName;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("id", (DataType)IntegerType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        $this.test("AlterTable: add top-level column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(35).append("ALTER TABLE ").append(t).append(" ADD COLUMN data string").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        $this.test("AlterTable: add column with NOT NULL", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(44).append("ALTER TABLE ").append(t).append(" ADD COLUMN data string NOT NULL").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("data", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        $this.test("AlterTable: add column with comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(49).append("ALTER TABLE ").append(t).append(" ADD COLUMN data string COMMENT 'doc'").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("data", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)Nil$.MODULE$)));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        $this.test("AlterTable: add column with interval type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(65).append("CREATE TABLE ").append(t).append(" (id int, point struct<x: double, y: double>) USING ").append($this.v2Format()).toString());
                AnalysisException e1 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(37).append("ALTER TABLE ").append(t).append(" ADD COLUMN data interval").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136)))));
                String $org_scalatest_assert_macro_left = e1.getMessage();
                String $org_scalatest_assert_macro_right = "Cannot use interval type in the table schema.";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
                AnalysisException e2 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(40).append("ALTER TABLE ").append(t).append(" ADD COLUMN point.z interval").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139)))));
                String $org_scalatest_assert_macro_left2 = e2.getMessage();
                String $org_scalatest_assert_macro_right2 = "Cannot use interval type in the table schema.";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        $this.test("AlterTable: add column with position", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AnalysisException e2;
                AnalysisException e1;
                $this.sql().apply((Object)new StringBuilder(43).append("CREATE TABLE ").append(t).append(" (point struct<x: int>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(38).append("ALTER TABLE ").append(t).append(" ADD COLUMN a string FIRST").toString());
                String tableName = $this.fullTableName(t);
                StructType $org_scalatest_assert_macro_left = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right = new StructType().add("a", (DataType)StringType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$));
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
                $this.sql().apply((Object)new StringBuilder(44).append("ALTER TABLE ").append(t).append(" ADD COLUMN b string AFTER point").toString());
                StructType $org_scalatest_assert_macro_left2 = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("a", (DataType)StringType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$)).add("b", (DataType)StringType$.MODULE$);
                StructType structType3 = $org_scalatest_assert_macro_left2;
                StructType structType4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
                AnalysisException x$1 = e1 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(48).append("ALTER TABLE ").append(t).append(" ADD COLUMN c string AFTER non_exist").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161)))));
                String x$2 = "FIELD_NOT_FOUND";
                scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`c`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)"a, point, b")}));
                Option x$4 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$3();
                boolean x$5 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$5();
                QueryContext[] x$6 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$6();
                $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
                $this.sql().apply((Object)new StringBuilder(41).append("ALTER TABLE ").append(t).append(" ADD COLUMN point.y int FIRST").toString());
                StructType $org_scalatest_assert_macro_left3 = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right3 = new StructType().add("a", (DataType)StringType$.MODULE$).add("point", (DataType)new StructType().add("y", (DataType)IntegerType$.MODULE$).add("x", (DataType)IntegerType$.MODULE$)).add("b", (DataType)StringType$.MODULE$);
                StructType structType5 = $org_scalatest_assert_macro_left3;
                StructType structType6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(structType5 != null ? !structType5.equals(structType6) : structType6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
                $this.sql().apply((Object)new StringBuilder(43).append("ALTER TABLE ").append(t).append(" ADD COLUMN point.z int AFTER x").toString());
                StructType $org_scalatest_assert_macro_left4 = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("a", (DataType)StringType$.MODULE$).add("point", (DataType)new StructType().add("y", (DataType)IntegerType$.MODULE$).add("x", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$)).add("b", (DataType)StringType$.MODULE$);
                StructType structType7 = $org_scalatest_assert_macro_left4;
                StructType structType8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structType7 != null ? !structType7.equals(structType8) : structType8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
                AnalysisException x$7 = e2 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(52).append("ALTER TABLE ").append(t).append(" ADD COLUMN point.x2 int AFTER non_exist").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186)))));
                String x$8 = "FIELD_NOT_FOUND";
                scala.collection.immutable.Map x$9 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`x2`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)"y, x, z")}));
                Option x$10 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$3();
                boolean x$11 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$5();
                QueryContext[] x$12 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$6();
                $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError((SparkThrowable)x$7, x$8, x$10, x$9, x$11, x$12);
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        $this.test("SPARK-30814: add column with position referencing new columns being added", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AnalysisException e;
                $this.sql().apply((Object)new StringBuilder(74).append("CREATE TABLE ").append(t).append(" (a string, b int, point struct<x: double, y: double>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(70).append("ALTER TABLE ").append(t).append(" ADD COLUMNS (x int AFTER a, y int AFTER x, z int AFTER y)").toString());
                String tableName = $this.fullTableName(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)$this.getTableMetadata(tableName).schema());
                StructType $org_scalatest_assert_macro_right = new StructType().add("a", (DataType)StringType$.MODULE$).add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$).add("b", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
                $this.sql().apply((Object)new StringBuilder(74).append("ALTER TABLE ").append(t).append(" ADD COLUMNS (point.z double AFTER x, point.zz double AFTER z)").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)$this.getTableMetadata(tableName).schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("a", (DataType)StringType$.MODULE$).add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$).add("b", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)DoubleType$.MODULE$).add("z", (DataType)DoubleType$.MODULE$).add("zz", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
                AnalysisException x$13 = e = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(50).append("ALTER TABLE ").append(t).append(" ADD COLUMNS (yy int AFTER xx, xx int)").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227)))));
                String x$14 = "FIELD_NOT_FOUND";
                scala.collection.immutable.Map x$15 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`yy`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)"a, x, y, z, b, point")}));
                Option x$16 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$3();
                boolean x$17 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$5();
                QueryContext[] x$18 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$6();
                $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError((SparkThrowable)x$13, x$14, x$16, x$15, x$17, x$18);
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        $this.test("AlterTable: add multiple columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(64).append("ALTER TABLE ").append(t).append(" ADD COLUMNS data string COMMENT 'doc', ts timestamp").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("data", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)new .colon.colon((Object)new StructField("ts", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        $this.test("AlterTable: add nested column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(65).append("CREATE TABLE ").append(t).append(" (id int, point struct<x: double, y: double>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(38).append("ALTER TABLE ").append(t).append(" ADD COLUMN point.z double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("z", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        $this.test("AlterTable: add nested column to map key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(79).append("CREATE TABLE ").append(t).append(" (id int, points map<struct<x: double, y: double>, bigint>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(43).append("ALTER TABLE ").append(t).append(" ADD COLUMN points.key.z double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("z", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        $this.test("AlterTable: add nested column to map value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(79).append("CREATE TABLE ").append(t).append(" (id int, points map<string, struct<x: double, y: double>>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(45).append("ALTER TABLE ").append(t).append(" ADD COLUMN points.value.z double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("z", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
        $this.test("AlterTable: add nested column to array element", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(73).append("CREATE TABLE ").append(t).append(" (id int, points array<struct<x: double, y: double>>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(47).append("ALTER TABLE ").append(t).append(" ADD COLUMN points.element.z double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("z", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        $this.test("SPARK-39383 DEFAULT columns on V2 data sources with ALTER TABLE ADD/ALTER COLUMN", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DEFAULT_COLUMN_ALLOWED_PROVIDERS().key()), (Object)new StringBuilder(2).append($this.v2Format()).append(", ").toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(31).append("create table ").append(t).append(" (a string) using ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(45).append("alter table ").append(t).append(" add column (b int default 2 + 3)").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("a", (DataType)StringType$.MODULE$).add(new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withCurrentDefaultValue("2 + 3").withExistenceDefaultValue("5"));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
                $this.sql().apply((Object)new StringBuilder(45).append("alter table ").append(t).append(" alter column b set default 2 + 3").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)$this.getTableMetadata(tableName).schema());
                StructType $org_scalatest_assert_macro_right3 = new StructType().add("a", (DataType)StringType$.MODULE$).add(new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withCurrentDefaultValue("2 + 3").withExistenceDefaultValue("5"));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
                $this.sql().apply((Object)new StringBuilder(40).append("alter table ").append(t).append(" alter column b drop default").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = ((TripleEquals)$this).convertToEqualizer((Object)$this.getTableMetadata(tableName).schema());
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("a", (DataType)StringType$.MODULE$).add(new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withExistenceDefaultValue("5"));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
            });
        }), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
        $this.test("SPARK-45075: ALTER COLUMN with invalid default value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DEFAULT_COLUMN_ALLOWED_PROVIDERS().key()), (Object)new StringBuilder(2).append($this.v2Format()).append(", ").toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(32).append("create table t(i boolean) using ").append($this.v2Format()).toString());
            String $org_scalatest_assert_macro_left = ((AnalysisException)((Object)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"alter table t add column s bigint default badvalue"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374))))))).getMessage();
            String $org_scalatest_assert_macro_right = "Failed to execute ALTER TABLE command because the destination table column s has a DEFAULT value of badvalue which fails to resolve as a valid expression: [UNRESOLVED_COLUMN.WITHOUT_SUGGESTION] A column or function parameter with name `badvalue` cannot be resolved. ;";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
            $this.sql().apply((Object)"alter table t add column s bigint default 3L");
            String $org_scalatest_assert_macro_left2 = ((AnalysisException)((Object)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"alter table t alter column s set default badvalue"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382))))))).getMessage();
            String $org_scalatest_assert_macro_right2 = "Failed to execute ALTER TABLE ALTER COLUMN command because the destination table column s has a DEFAULT value of badvalue which fails to resolve as a valid expression: [UNRESOLVED_COLUMN.WITHOUT_SUGGESTION] A column or function parameter with name `badvalue` cannot be resolved. ;";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
        })), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
        $this.test("AlterTable: add complex column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(66).append("ALTER TABLE ").append(t).append(" ADD COLUMN points array<struct<x: double, y: double>>").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
        $this.test("AlterTable: add nested column with comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(73).append("CREATE TABLE ").append(t).append(" (id int, points array<struct<x: double, y: double>>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(61).append("ALTER TABLE ").append(t).append(" ADD COLUMN points.element.z double COMMENT 'doc'").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("z", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)Nil$.MODULE$))))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
        $this.test("AlterTable: add nested column parent must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(38).append("ALTER TABLE ").append(t).append(" ADD COLUMN point.z double").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field point";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
        $this.test("AlterTable: add column - new column should not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(284).append("CREATE TABLE ").append(t).append(" (\n           |id int,\n           |point struct<x: double, y: double>,\n           |arr array<struct<x: double, y: double>>,\n           |mk map<struct<x: double, y: double>, string>,\n           |mv map<string, struct<x: double, y: double>>\n           |)\n           |USING ").append($this.v2Format()).toString())).stripMargin());
                ((IterableLike)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"point.x", (List)new .colon.colon((Object)"arr.element.x", (List)new .colon.colon((Object)"mk.key.x", (List)new .colon.colon((Object)"mv.value.x", (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable & scala.Serializable)field -> {
                    AnalysisException e = (AnalysisException)((Object)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(32).append("ALTER TABLE ").append(t).append(" ADD COLUMNS ").append((String)field).append(" double").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457))))));
                    String $org_scalatest_assert_macro_left = e.getMessage();
                    String $org_scalatest_assert_macro_right = "add";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
                    String $org_scalatest_assert_macro_left2 = e.getMessage();
                    String $org_scalatest_assert_macro_right2 = new StringBuilder(15).append((String)field).append(" already exists").toString();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
                });
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
        $this.test("SPARK-36372: Adding duplicate columns should not be allowed", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException x$19 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(65).append("ALTER TABLE ").append(t).append(" ADD COLUMNS (data string, data1 string, data string)").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471)))));
                String x$20 = "COLUMN_ALREADY_EXISTS";
                scala.collection.immutable.Map x$21 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`data`")}));
                Option x$22 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$3();
                boolean x$23 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$5();
                QueryContext[] x$24 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$6();
                $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError((SparkThrowable)x$19, x$20, x$22, x$21, x$23, x$24);
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466));
        $this.test("SPARK-36372: Adding duplicate nested columns should not be allowed", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(65).append("CREATE TABLE ").append(t).append(" (id int, point struct<x: double, y: double>) USING ").append($this.v2Format()).toString());
                AnalysisException x$25 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(74).append("ALTER TABLE ").append(t).append(" ADD COLUMNS (point.z double, point.z double, point.xx double)").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484)))));
                String x$26 = "COLUMN_ALREADY_EXISTS";
                scala.collection.immutable.Map x$27 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)$this.toSQLId("point.z"))}));
                Option x$28 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$3();
                boolean x$29 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$5();
                QueryContext[] x$30 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$6();
                $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError((SparkThrowable)x$25, x$26, x$28, x$27, x$29, x$30);
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
        $this.test("AlterTable: update column type int -> long", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(40).append("ALTER TABLE ").append(t).append(" ALTER COLUMN id TYPE bigint").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)LongType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
        $this.test("AlterTable: update column type to interval", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                ((IterableLike)DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().$plus$plus((GenTraversableOnce)DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    AnsiIntervalType ansiIntervalType = x0$1;
                    if (ansiIntervalType != null) {
                        AnsiIntervalType ansiIntervalType2 = ansiIntervalType;
                        ansiIntervalType2.typeName();
                        AnalysisException e = (AnalysisException)((Object)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(34).append("ALTER TABLE ").append(t).append(" ALTER COLUMN id TYPE ").append(ansiIntervalType2.typeName()).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513))))));
                        String $org_scalatest_assert_macro_left = e.getMessage();
                        String $org_scalatest_assert_macro_right = "id to interval type";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
                    }
                    throw new MatchError((Object)ansiIntervalType);
                });
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
        $this.test("AlterTable: SET/DROP NOT NULL", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(41).append("CREATE TABLE ").append(t).append(" (id bigint NOT NULL) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(41).append("ALTER TABLE ").append(t).append(" ALTER COLUMN id SET NOT NULL").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)LongType$.MODULE$, false);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
                $this.sql().apply((Object)new StringBuilder(42).append("ALTER TABLE ").append(t).append(" ALTER COLUMN id DROP NOT NULL").toString());
                Table table2 = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)table2.name());
                String $org_scalatest_assert_macro_right3 = tableName;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = ((TripleEquals)$this).convertToEqualizer((Object)table2.schema());
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("id", (DataType)LongType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
                AnalysisException e = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(41).append("ALTER TABLE ").append(t).append(" ALTER COLUMN id SET NOT NULL").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536)))));
                String $org_scalatest_assert_macro_left5 = e.message();
                String $org_scalatest_assert_macro_right5 = "Cannot change nullable column to non-nullable";
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
        $this.test("AlterTable: update nested type float -> double", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(64).append("CREATE TABLE ").append(t).append(" (id int, point struct<x: float, y: double>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(45).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point.x TYPE double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543));
        $this.test("AlterTable: update column with struct type fails", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(65).append("CREATE TABLE ").append(t).append(" (id int, point struct<x: double, y: double>) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(76).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point TYPE struct<x: double, y: double, z: double>").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "point";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "update a struct by updating its fields";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 570));
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right3 = tableName;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 575));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
        $this.test("AlterTable: update column with array type fails", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id int, points array<int>) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(49).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points TYPE array<long>").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "update the element by updating points.element";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right2 = tableName;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 598));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
        $this.test("AlterTable: update column array element type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id int, points array<int>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(50).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points.element TYPE long").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 605));
        $this.test("AlterTable: update column with map type fails", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(49).append("CREATE TABLE ").append(t).append(" (id int, m map<string, int>) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(50).append("ALTER TABLE ").append(t).append(" ALTER COLUMN m TYPE map<string, long>").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "update a map by updating m.key or m.value";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right2 = tableName;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("m", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 621));
        $this.test("AlterTable: update column map value type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(49).append("CREATE TABLE ").append(t).append(" (id int, m map<string, int>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(43).append("ALTER TABLE ").append(t).append(" ALTER COLUMN m.value TYPE long").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 651));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("m", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
        $this.test("AlterTable: update nested type in map key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id int, points map<struct<x: float, y: double>, bigint>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(50).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points.key.x TYPE double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 658));
        $this.test("AlterTable: update nested type in map value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id int, points map<string, struct<x: float, y: double>>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(52).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points.value.x TYPE double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 687));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677));
        $this.test("AlterTable: update nested type in array", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(72).append("CREATE TABLE ").append(t).append(" (id int, points array<struct<x: float, y: double>>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(54).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points.element.x TYPE double").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696));
        $this.test("AlterTable: update column must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(42).append("ALTER TABLE ").append(t).append(" ALTER COLUMN data TYPE string").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 719)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field data";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 714));
        $this.test("AlterTable: nested update column must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(45).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point.x TYPE double").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 732)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field point.x";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 736));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
        $this.test("AlterTable: update column type must be compatible", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(41).append("ALTER TABLE ").append(t).append(" ALTER COLUMN id TYPE boolean").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 745)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "id";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 749));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "int cannot be cast to boolean";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 750));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 740));
        $this.test("AlterTable: update column comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(42).append("ALTER TABLE ").append(t).append(" ALTER COLUMN id COMMENT 'doc'").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 763));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)Nil$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 764));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
        $this.test("AlterTable: update column position", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(73).append("CREATE TABLE ").append(t).append(" (a int, b int, point struct<x: int, y: int, z: int>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(33).append("ALTER TABLE ").append(t).append(" ALTER COLUMN b FIRST").toString());
                String tableName = $this.fullTableName(t);
                StructType $org_scalatest_assert_macro_left = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right = new StructType().add("b", (DataType)IntegerType$.MODULE$).add("a", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$));
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
                $this.sql().apply((Object)new StringBuilder(39).append("ALTER TABLE ").append(t).append(" ALTER COLUMN b AFTER point").toString());
                StructType $org_scalatest_assert_macro_left2 = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("a", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$)).add("b", (DataType)IntegerType$.MODULE$);
                StructType structType3 = $org_scalatest_assert_macro_left2;
                StructType structType4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 784));
                AnalysisException e1 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(43).append("ALTER TABLE ").append(t).append(" ALTER COLUMN b AFTER non_exist").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 792)))));
                String $org_scalatest_assert_macro_left3 = e1.getMessage();
                String $org_scalatest_assert_macro_right3 = "Missing field non_exist";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 794));
                $this.sql().apply((Object)new StringBuilder(39).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point.y FIRST").toString());
                StructType $org_scalatest_assert_macro_left4 = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("a", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("y", (DataType)IntegerType$.MODULE$).add("x", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$)).add("b", (DataType)IntegerType$.MODULE$);
                StructType structType5 = $org_scalatest_assert_macro_left4;
                StructType structType6 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structType5 != null ? !structType5.equals(structType6) : structType6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 797));
                $this.sql().apply((Object)new StringBuilder(41).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point.y AFTER z").toString());
                StructType $org_scalatest_assert_macro_left5 = $this.getTableMetadata(tableName).schema();
                StructType $org_scalatest_assert_macro_right5 = new StructType().add("a", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$)).add("b", (DataType)IntegerType$.MODULE$);
                StructType structType7 = $org_scalatest_assert_macro_left5;
                StructType structType8 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(structType7 != null ? !structType7.equals(structType8) : structType8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 806));
                AnalysisException e2 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(49).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point.y AFTER non_exist").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 814)))));
                String $org_scalatest_assert_macro_left6 = e2.getMessage();
                String $org_scalatest_assert_macro_right6 = "Missing field point.non_exist";
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
                ((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(37).append("ALTER TABLE ").append(t).append(" ALTER COLUMN a.y AFTER x").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 819));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 768));
        $this.test("AlterTable: update nested column comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(65).append("CREATE TABLE ").append(t).append(" (id int, point struct<x: double, y: double>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(47).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point.y COMMENT 'doc'").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 833));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 834));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824));
        $this.test("AlterTable: update nested column comment in map key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(79).append("CREATE TABLE ").append(t).append(" (id int, points map<struct<x: double, y: double>, bigint>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(52).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points.key.y COMMENT 'doc'").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 852));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)Nil$.MODULE$))), (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 853));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
        $this.test("AlterTable: update nested column comment in map value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(79).append("CREATE TABLE ").append(t).append(" (id int, points map<string, struct<x: double, y: double>>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(54).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points.value.y COMMENT 'doc'").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 871));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 872));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 861));
        $this.test("AlterTable: update nested column comment in array", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(73).append("CREATE TABLE ").append(t).append(" (id int, points array<struct<x: double, y: double>>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(56).append("ALTER TABLE ").append(t).append(" ALTER COLUMN points.element.y COMMENT 'doc'").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 889));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 890));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 880));
        $this.test("AlterTable: comment update column must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(44).append("ALTER TABLE ").append(t).append(" ALTER COLUMN data COMMENT 'doc'").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 903)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field data";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 907));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 898));
        $this.test("AlterTable: nested comment update column must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(47).append("ALTER TABLE ").append(t).append(" ALTER COLUMN point.x COMMENT 'doc'").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 916)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field point.x";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 920));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 911));
        $this.test("AlterTable: rename column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(40).append("ALTER TABLE ").append(t).append(" RENAME COLUMN id TO user_id").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 933));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("user_id", (DataType)IntegerType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 934));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 924));
        $this.test("AlterTable: rename nested column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(65).append("CREATE TABLE ").append(t).append(" (id int, point struct<x: double, y: double>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(39).append("ALTER TABLE ").append(t).append(" RENAME COLUMN point.y TO t").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 947));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("t", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 948));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 938));
        $this.test("AlterTable: rename nested column in map key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id int, point map<struct<x: double, y: double>, bigint>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(43).append("ALTER TABLE ").append(t).append(" RENAME COLUMN point.key.y TO t").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 966));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("t", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 967));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 956));
        $this.test("AlterTable: rename nested column in map value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(79).append("CREATE TABLE ").append(t).append(" (id int, points map<string, struct<x: double, y: double>>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(46).append("ALTER TABLE ").append(t).append(" RENAME COLUMN points.value.y TO t").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 985));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("t", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 986));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 975));
        $this.test("AlterTable: rename nested column in array element", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(73).append("CREATE TABLE ").append(t).append(" (id int, points array<struct<x: double, y: double>>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(48).append("ALTER TABLE ").append(t).append(" RENAME COLUMN points.element.y TO t").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1003));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("t", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1004));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 994));
        $this.test("AlterTable: rename column must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(46).append("ALTER TABLE ").append(t).append(" RENAME COLUMN data TO some_string").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1017)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field data";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1021));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1012));
        $this.test("AlterTable: nested rename column must exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(39).append("ALTER TABLE ").append(t).append(" RENAME COLUMN point.x TO z").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1030)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field point.x";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1034));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1025));
        $this.test("AlterTable: rename column - new name should not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(309).append("CREATE TABLE ").append(t).append(" (\n           |id int,\n           |user_id int,\n           |point struct<x: double, y: double>,\n           |arr array<struct<x: double, y: double>>,\n           |mk map<struct<x: double, y: double>, string>,\n           |mv map<string, struct<x: double, y: double>>\n           |)\n           |USING ").append($this.v2Format()).toString())).stripMargin());
                ((IterableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"user_id"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"point.x"), (Object)"y"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"arr.element.x"), (Object)"y"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mk.key.x"), (Object)"y"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mv.value.x"), (Object)"y"), (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String field = (String)tuple2._1();
                        String newName = (String)tuple2._2();
                        AnalysisException e = (AnalysisException)((Object)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(31).append("ALTER TABLE ").append(t).append(" RENAME COLUMN ").append(field).append(" TO ").append(newName).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1059))))));
                        String $org_scalatest_assert_macro_left = e.getMessage();
                        String $org_scalatest_assert_macro_right = "rename";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1062));
                        String $org_scalatest_assert_macro_left2 = e.getMessage();
                        String $org_scalatest_assert_macro_right2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])field.split("\\."))).init())).$colon$plus((Object)newName, ClassTag$.MODULE$.apply(String.class)))).mkString(".");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1063));
                        String $org_scalatest_assert_macro_left3 = e.getMessage();
                        String $org_scalatest_assert_macro_right3 = "already exists";
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1064));
                    }
                    throw new MatchError((Object)tuple2);
                });
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1038));
        $this.test("AlterTable: drop column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE ").append(t).append(" (id int, data string) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(29).append("ALTER TABLE ").append(t).append(" DROP COLUMN data").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1078));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1079));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1069));
        $this.test("AlterTable: drop nested column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(76).append("CREATE TABLE ").append(t).append(" (id int, point struct<x: double, y: double, t: double>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(32).append("ALTER TABLE ").append(t).append(" DROP COLUMN point.t").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1093));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1094));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1083));
        $this.test("AlterTable: drop nested column in map key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id int, point map<struct<x: double, y: double>, bigint>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(36).append("ALTER TABLE ").append(t).append(" DROP COLUMN point.key.y").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1112));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1113));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1102));
        $this.test("AlterTable: drop nested column in map value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(79).append("CREATE TABLE ").append(t).append(" (id int, points map<string, struct<x: double, y: double>>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(39).append("ALTER TABLE ").append(t).append(" DROP COLUMN points.value.y").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1130));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1131));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1120));
        $this.test("AlterTable: drop nested column in array element", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(73).append("CREATE TABLE ").append(t).append(" (id int, points array<struct<x: double, y: double>>) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(41).append("ALTER TABLE ").append(t).append(" DROP COLUMN points.element.y").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1147));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1148));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1138));
        $this.test("AlterTable: drop column must exist if required", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(29).append("ALTER TABLE ").append(t).append(" DROP COLUMN data").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1160)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field data";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1164));
                $this.sql().apply((Object)new StringBuilder(39).append("ALTER TABLE ").append(t).append(" DROP COLUMN IF EXISTS data").toString());
                Table table = $this.getTableMetadata($this.fullTableName(t));
                StructType $org_scalatest_assert_macro_left2 = table.schema();
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$);
                StructType structType = $org_scalatest_assert_macro_left2;
                StructType structType2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1169));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1155));
        $this.test("AlterTable: nested drop column must exist if required", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(32).append("ALTER TABLE ").append(t).append(" DROP COLUMN point.x").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1178)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field point.x";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1182));
                $this.sql().apply((Object)new StringBuilder(42).append("ALTER TABLE ").append(t).append(" DROP COLUMN IF EXISTS point.x").toString());
                Table table = $this.getTableMetadata($this.fullTableName(t));
                StructType $org_scalatest_assert_macro_left2 = table.schema();
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$);
                StructType structType = $org_scalatest_assert_macro_left2;
                StructType structType2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1187));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1173));
        $this.test("AlterTable: drop mixed existing/non-existing columns using IF EXISTS", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(86).append("CREATE TABLE ").append(t).append(" (id int, name string, points array<struct<x: double, y: double>>) ").append("USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(87).append("ALTER TABLE ").append(t).append(" DROP COLUMNS IF EXISTS ").append("names, name, points.element.z, id, points.element.x").toString());
                Table table = $this.getTableMetadata($this.fullTableName(t));
                StructType $org_scalatest_assert_macro_left = table.schema();
                StructType $org_scalatest_assert_macro_right = new StructType().add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1202));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1192));
        $this.test("AlterTable: set table property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(44).append("ALTER TABLE ").append(t).append(" SET TBLPROPERTIES ('test'='34')").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1216));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.properties());
                java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)$this.v2Format()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test"), (Object)"34")})))).asJava();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1217));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1207));
        $this.test("AlterTable: remove table property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(58).append("CREATE TABLE ").append(t).append(" (id int) USING ").append($this.v2Format()).append(" TBLPROPERTIES('test' = '34')").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1230));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.properties());
                java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)$this.v2Format()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test"), (Object)"34")})))).asJava();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1231));
                $this.sql().apply((Object)new StringBuilder(41).append("ALTER TABLE ").append(t).append(" UNSET TBLPROPERTIES ('test')").toString());
                Table updated = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)updated.name());
                String $org_scalatest_assert_macro_right3 = tableName;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1238));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = ((TripleEquals)$this).convertToEqualizer((Object)updated.properties());
                java.util.Map $org_scalatest_assert_macro_right4 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)$this.v2Format())})))).asJava();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1239));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1222));
        $this.test("AlterTable: replace columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t).append(" (col1 int, col2 int COMMENT 'c2') USING ").append($this.v2Format()).toString());
                $this.sql().apply((Object)new StringBuilder(65).append("ALTER TABLE ").append(t).append(" REPLACE COLUMNS (col2 string, col3 int COMMENT 'c3')").toString());
                String tableName = $this.fullTableName(t);
                Table table = $this.getTableMetadata(tableName);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = tableName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1252));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("col2", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("col3", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("c3"), (List)Nil$.MODULE$)));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1253));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1243));
        $this.test("SPARK-36449: Replacing columns with duplicate name should not be allowed", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(10).append($this.catalogAndNamespace()).append("table_name").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(34).append("CREATE TABLE ").append(t).append(" (data string) USING ").append($this.v2Format()).toString());
                AnalysisException x$31 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(69).append("ALTER TABLE ").append(t).append(" REPLACE COLUMNS (data string, data1 string, data string)").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1264)))));
                String x$32 = "COLUMN_ALREADY_EXISTS";
                scala.collection.immutable.Map x$33 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`data`")}));
                Option x$34 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$3();
                boolean x$35 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$5();
                QueryContext[] x$36 = $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$6();
                $this.org$apache$spark$sql$connector$AlterTableTests$$super$checkError((SparkThrowable)x$31, x$32, x$34, x$33, x$35, x$36);
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1259));
    }
}

