/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.math3.distribution.LogNormalDistribution;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.compression.AllCompressionSchemes;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.Decoder;
import org.apache.spark.sql.execution.columnar.compression.Encoder;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class CompressionSchemeBenchmark$
extends BenchmarkBase
implements AllCompressionSchemes {
    public static CompressionSchemeBenchmark$ MODULE$;
    private final Seq<CompressionScheme> schemes;

    static {
        new CompressionSchemeBenchmark$();
    }

    public Seq<CompressionScheme> schemes() {
        return this.schemes;
    }

    public void org$apache$spark$sql$execution$columnar$compression$AllCompressionSchemes$_setter_$schemes_$eq(Seq<CompressionScheme> x$1) {
        this.schemes = x$1;
    }

    private ByteBuffer allocateLocal(int size) {
        return ByteBuffer.allocate(size).order(ByteOrder.nativeOrder());
    }

    private Function0<Object> genLowerSkewData() {
        LogNormalDistribution rng = new LogNormalDistribution(0.0, 0.01);
        return (JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.sample();
    }

    private Function0<Object> genHigherSkewData() {
        LogNormalDistribution rng = new LogNormalDistribution(0.0, 1.0);
        return (JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.sample();
    }

    private <T extends AtomicType> Tuple3<Function2<ByteBuffer, ByteBuffer, ByteBuffer>, Object, ByteBuffer> prepareEncodeInternal(int count, NativeColumnType<T> tpe, CompressionScheme supportedScheme, ByteBuffer input) {
        Predef$.MODULE$.assert(supportedScheme.supports(tpe));
        Encoder encoder = supportedScheme.encoder(tpe);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> encoder.gatherCompressibilityStats((InternalRow)CompressionSchemeBenchmark$.toRow$1(tpe.extract(input)), 0));
        input.rewind();
        int compressedSize = encoder.compressedSize() == 0 ? input.remaining() : encoder.compressedSize();
        return new Tuple3((Function2 & Serializable & scala.Serializable)(from, to) -> encoder.compress(from, to), (Object)BoxesRunTime.boxToDouble((double)encoder.compressionRatio()), (Object)this.allocateLocal(4 + compressedSize));
    }

    private <T extends AtomicType> void runEncodeBenchmark(String name, int iters, int count, NativeColumnType<T> tpe, ByteBuffer input) {
        String x$12 = name;
        long x$2 = (long)iters * (long)count;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$12, x$2, x$4, x$5, x$6, x$7, x$3);
        ((IterableLike)this.schemes().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.supports((ColumnType)tpe)))).foreach((Function1 & Serializable & scala.Serializable)scheme -> {
            CompressionSchemeBenchmark$.$anonfun$runEncodeBenchmark$2(count, tpe, input, benchmark, iters, scheme);
            return BoxedUnit.UNIT;
        });
        benchmark.run();
    }

    private <T extends AtomicType> void runDecodeBenchmark(String name, int iters, int count, NativeColumnType<T> tpe, ByteBuffer input) {
        String x$1 = name;
        long x$2 = (long)iters * (long)count;
        Option x$32 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$32);
        ((IterableLike)this.schemes().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.supports((ColumnType)tpe)))).foreach((Function1 & Serializable & scala.Serializable)scheme -> {
            CompressionSchemeBenchmark$.$anonfun$runDecodeBenchmark$2(count, tpe, input, benchmark, iters, scheme);
            return BoxedUnit.UNIT;
        });
        benchmark.run();
    }

    public void bitEncodingBenchmark(int iters) {
        int count = 65536;
        ByteBuffer testData = this.allocateLocal(count * BOOLEAN$.MODULE$.defaultSize());
        Function0<Object> rng = this.genLowerSkewData();
        JFunction0.mcB.sp & Serializable & scala.Serializable g = (JFunction0.mcB.sp & Serializable & scala.Serializable)() -> (byte)((int)rng.apply$mcD$sp() % 2);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach(arg_0 -> CompressionSchemeBenchmark$.$anonfun$bitEncodingBenchmark$2$adapted(testData, (Function0)g, arg_0));
        this.runEncodeBenchmark("BOOLEAN Encode", iters, count, (NativeColumnType)BOOLEAN$.MODULE$, testData);
        this.runDecodeBenchmark("BOOLEAN Decode", iters, count, (NativeColumnType)BOOLEAN$.MODULE$, testData);
    }

    public void shortEncodingBenchmark(int iters) {
        int count = 65536;
        ByteBuffer testData = this.allocateLocal(count * SHORT$.MODULE$.defaultSize());
        Function0<Object> g1 = this.genLowerSkewData();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1 & Serializable & scala.Serializable)i -> testData.putShort(BoxesRunTime.unboxToInt((Object)i) * SHORT$.MODULE$.defaultSize(), (short)g1.apply$mcD$sp()));
        this.runEncodeBenchmark("SHORT Encode (Lower Skew)", iters, count, (NativeColumnType)SHORT$.MODULE$, testData);
        this.runDecodeBenchmark("SHORT Decode (Lower Skew)", iters, count, (NativeColumnType)SHORT$.MODULE$, testData);
        Function0<Object> g2 = this.genHigherSkewData();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1 & Serializable & scala.Serializable)i -> testData.putShort(BoxesRunTime.unboxToInt((Object)i) * SHORT$.MODULE$.defaultSize(), (short)g2.apply$mcD$sp()));
        this.runEncodeBenchmark("SHORT Encode (Higher Skew)", iters, count, (NativeColumnType)SHORT$.MODULE$, testData);
        this.runDecodeBenchmark("SHORT Decode (Higher Skew)", iters, count, (NativeColumnType)SHORT$.MODULE$, testData);
    }

    public void intEncodingBenchmark(int iters) {
        int count = 65536;
        ByteBuffer testData = this.allocateLocal(count * INT$.MODULE$.defaultSize());
        Function0<Object> g1 = this.genLowerSkewData();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1 & Serializable & scala.Serializable)i -> testData.putInt(BoxesRunTime.unboxToInt((Object)i) * INT$.MODULE$.defaultSize(), (int)g1.apply$mcD$sp()));
        this.runEncodeBenchmark("INT Encode (Lower Skew)", iters, count, (NativeColumnType)INT$.MODULE$, testData);
        this.runDecodeBenchmark("INT Decode (Lower Skew)", iters, count, (NativeColumnType)INT$.MODULE$, testData);
        Function0<Object> g2 = this.genHigherSkewData();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1 & Serializable & scala.Serializable)i -> testData.putInt(BoxesRunTime.unboxToInt((Object)i) * INT$.MODULE$.defaultSize(), (int)g2.apply$mcD$sp()));
        this.runEncodeBenchmark("INT Encode (Higher Skew)", iters, count, (NativeColumnType)INT$.MODULE$, testData);
        this.runDecodeBenchmark("INT Decode (Higher Skew)", iters, count, (NativeColumnType)INT$.MODULE$, testData);
    }

    public void longEncodingBenchmark(int iters) {
        int count = 65536;
        ByteBuffer testData = this.allocateLocal(count * LONG$.MODULE$.defaultSize());
        Function0<Object> g1 = this.genLowerSkewData();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1 & Serializable & scala.Serializable)i -> testData.putLong(BoxesRunTime.unboxToInt((Object)i) * LONG$.MODULE$.defaultSize(), (long)g1.apply$mcD$sp()));
        this.runEncodeBenchmark("LONG Encode (Lower Skew)", iters, count, (NativeColumnType)LONG$.MODULE$, testData);
        this.runDecodeBenchmark("LONG Decode (Lower Skew)", iters, count, (NativeColumnType)LONG$.MODULE$, testData);
        Function0<Object> g2 = this.genHigherSkewData();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1 & Serializable & scala.Serializable)i -> testData.putLong(BoxesRunTime.unboxToInt((Object)i) * LONG$.MODULE$.defaultSize(), (long)g2.apply$mcD$sp()));
        this.runEncodeBenchmark("LONG Encode (Higher Skew)", iters, count, (NativeColumnType)LONG$.MODULE$, testData);
        this.runDecodeBenchmark("LONG Decode (Higher Skew)", iters, count, (NativeColumnType)LONG$.MODULE$, testData);
    }

    public void stringEncodingBenchmark(int iters) {
        int count = 65536;
        int strLen = 8;
        int tableSize = 16;
        ByteBuffer testData = this.allocateLocal(count * (4 + strLen));
        IndexedSeq dataTable = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tableSize).map((Function1 & Serializable & scala.Serializable)x$5 -> CompressionSchemeBenchmark$.$anonfun$stringEncodingBenchmark$1(strLen, BoxesRunTime.unboxToInt((Object)x$5)), IndexedSeq$.MODULE$.canBuildFrom());
        Function0<Object> rng = this.genHigherSkewData();
        Function0 & Serializable & scala.Serializable g = (Function0 & Serializable & scala.Serializable)() -> (String)dataTable.apply((int)rng.apply$mcD$sp() % tableSize);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1 & Serializable & scala.Serializable)i -> CompressionSchemeBenchmark$.$anonfun$stringEncodingBenchmark$3(testData, strLen, g, BoxesRunTime.unboxToInt((Object)i)));
        testData.rewind();
        this.runEncodeBenchmark("STRING Encode", iters, count, (NativeColumnType)STRING$.MODULE$, testData);
        this.runDecodeBenchmark("STRING Decode", iters, count, (NativeColumnType)STRING$.MODULE$, testData);
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("Compression Scheme Benchmark", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.bitEncodingBenchmark(1024);
            MODULE$.shortEncodingBenchmark(1024);
            MODULE$.intEncodingBenchmark(1024);
            MODULE$.longEncodingBenchmark(1024);
            MODULE$.stringEncodingBenchmark(1024);
        });
    }

    private static final GenericInternalRow toRow$1(Object d) {
        return new GenericInternalRow(new Object[]{d});
    }

    public static final /* synthetic */ Buffer $anonfun$runEncodeBenchmark$4(Function2 compressFunc$1, ByteBuffer input$2, ByteBuffer buf$1, long n) {
        compressFunc$1.apply((Object)input$2, (Object)buf$1);
        input$2.rewind();
        return buf$1.rewind();
    }

    public static final /* synthetic */ void $anonfun$runEncodeBenchmark$2(int count$1, NativeColumnType tpe$2, ByteBuffer input$2, Benchmark benchmark$1, int iters$1, CompressionScheme scheme) {
        Tuple3<Function2<ByteBuffer, ByteBuffer, ByteBuffer>, Object, ByteBuffer> tuple3 = MODULE$.prepareEncodeInternal(count$1, tpe$2, scheme, input$2);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Function2 compressFunc = (Function2)tuple3._1();
        double compressionRatio = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        ByteBuffer buf = (ByteBuffer)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)compressFunc, (Object)BoxesRunTime.boxToDouble((double)compressionRatio), (Object)buf);
        Function2 compressFunc2 = (Function2)tuple32._1();
        double compressionRatio2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
        ByteBuffer buf2 = (ByteBuffer)tuple32._3();
        String label = new StringBuilder(2).append(Utils$.MODULE$.getFormattedClassName((Object)scheme)).append("(").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)compressionRatio2)), "%.3f")).append(")").toString();
        benchmark$1.addCase(label, benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters$1)).foreach((Function1 & Serializable & scala.Serializable)n -> CompressionSchemeBenchmark$.$anonfun$runEncodeBenchmark$4(compressFunc2, input$2, buf2, BoxesRunTime.unboxToLong((Object)n))));
    }

    public static final /* synthetic */ void $anonfun$runDecodeBenchmark$2(int count$2, NativeColumnType tpe$3, ByteBuffer input$3, Benchmark benchmark$2, int iters$2, CompressionScheme scheme) {
        Tuple3<Function2<ByteBuffer, ByteBuffer, ByteBuffer>, Object, ByteBuffer> tuple3 = MODULE$.prepareEncodeInternal(count$2, tpe$3, scheme, input$3);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Function2 compressFunc = (Function2)tuple3._1();
        ByteBuffer buf = (ByteBuffer)tuple3._3();
        Tuple2 tuple2 = new Tuple2((Object)compressFunc, (Object)buf);
        Function2 compressFunc2 = (Function2)tuple2._1();
        ByteBuffer buf2 = (ByteBuffer)tuple2._2();
        ByteBuffer compressedBuf = (ByteBuffer)compressFunc2.apply((Object)input$3, (Object)buf2);
        String label = String.valueOf(Utils$.MODULE$.getFormattedClassName((Object)scheme));
        input$3.rewind();
        benchmark$2.addCase(label, benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            GenericInternalRow rowBuf = new GenericInternalRow(1);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters$2)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)n -> {
                compressedBuf.rewind().position(4);
                Decoder decoder = scheme.decoder(compressedBuf, tpe$3);
                while (decoder.hasNext()) {
                    decoder.next((InternalRow)rowBuf, 0);
                }
            });
        });
    }

    public static final /* synthetic */ String $anonfun$stringEncodingBenchmark$1(int strLen$1, int x$5) {
        return RandomStringUtils.randomAlphabetic((int)strLen$1);
    }

    public static final /* synthetic */ ByteBuffer $anonfun$stringEncodingBenchmark$3(ByteBuffer testData$5, int strLen$1, Function0 g$2, int i) {
        testData$5.putInt(strLen$1);
        return testData$5.put(((String)g$2.apply()).getBytes(StandardCharsets.UTF_8));
    }

    private CompressionSchemeBenchmark$() {
        MODULE$ = this;
        AllCompressionSchemes.$init$((AllCompressionSchemes)this);
    }

    public static final /* synthetic */ ByteBuffer $anonfun$bitEncodingBenchmark$2$adapted(ByteBuffer testData$1, Function0 g$1, Object i) {
        return testData$1.put(BoxesRunTime.unboxToInt((Object)i) * BOOLEAN$.MODULE$.defaultSize(), g$1.apply$mcB$sp());
    }
}

