/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAAdmin;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.DecommissionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.RMHAServiceTarget;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.sparkproject.guava.collect.ImmutableMap;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMAdminCLI
extends HAAdmin {
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private boolean directlyAccessNodeLabelStore = false;
    static CommonNodeLabelsManager localNodeLabelsManager = null;
    private static final String INVALID_TIMEOUT_ERR_MSG = "Invalid timeout specified : ";
    protected static final Map<String, HAAdmin.UsageInfo> ADMIN_USAGE = ImmutableMap.builder().put((Object)"-refreshQueues", (Object)new HAAdmin.UsageInfo("", "Reload the queues' acls, states and scheduler specific properties. \n\t\tResourceManager will reload the mapred-queues configuration file.")).put((Object)"-refreshNodes", (Object)new HAAdmin.UsageInfo("[-g [timeout in seconds] -client|server]", "Refresh the hosts information at the ResourceManager. Here [-g [timeout in seconds] -client|server] is optional, if we specify the timeout then ResourceManager will wait for timeout before marking the NodeManager as decommissioned. The -client|server indicates if the timeout tracking should be handled by the client or the ResourceManager. The client-side tracking is blocking, while the server-side tracking is not. Omitting the timeout, or a timeout of -1, indicates an infinite timeout.")).put((Object)"-refreshSuperUserGroupsConfiguration", (Object)new HAAdmin.UsageInfo("", "Refresh superuser proxy groups mappings")).put((Object)"-refreshUserToGroupsMappings", (Object)new HAAdmin.UsageInfo("", "Refresh user-to-groups mappings")).put((Object)"-refreshAdminAcls", (Object)new HAAdmin.UsageInfo("", "Refresh acls for administration of ResourceManager")).put((Object)"-refreshServiceAcl", (Object)new HAAdmin.UsageInfo("", "Reload the service-level authorization policy file. \n\t\tResoureceManager will reload the authorization policy file.")).put((Object)"-getGroups", (Object)new HAAdmin.UsageInfo("[username]", "Get the groups which given user belongs to.")).put((Object)"-help", (Object)new HAAdmin.UsageInfo("[cmd]", "Displays help for the given command or all commands if none is specified.")).put((Object)"-addToClusterNodeLabels", (Object)new HAAdmin.UsageInfo("[label1,label2,label3] (label splitted by \",\")", "add to cluster node labels ")).put((Object)"-removeFromClusterNodeLabels", (Object)new HAAdmin.UsageInfo("[label1,label2,label3] (label splitted by \",\")", "remove from cluster node labels")).put((Object)"-replaceLabelsOnNode", (Object)new HAAdmin.UsageInfo("[node1:port,label1,label2 node2:port,label1,label2]", "replace labels on nodes")).put((Object)"-directlyAccessNodeLabelStore", (Object)new HAAdmin.UsageInfo("", "Directly access node label store, with this option, all node label related operations will not connect RM. Instead, they will access/modify stored node labels directly. By default, it is false (access via RM). AND PLEASE NOTE: if you configured yarn.node-labels.fs-store.root-dir to a local directory (instead of NFS or HDFS), this option will only work when the command run on the machine where RM is running.")).build();

    public RMAdminCLI() {
    }

    public RMAdminCLI(Configuration conf) {
        super(conf);
    }

    private static void appendHAUsage(StringBuilder usageBuilder) {
        for (String cmdKey : USAGE.keySet()) {
            if (cmdKey.equals("-help")) continue;
            HAAdmin.UsageInfo usageInfo = (HAAdmin.UsageInfo)USAGE.get(cmdKey);
            usageBuilder.append(" [" + cmdKey + " " + usageInfo.args + "]");
        }
    }

    private static void buildHelpMsg(String cmd, StringBuilder builder) {
        HAAdmin.UsageInfo usageInfo = ADMIN_USAGE.get(cmd);
        if (usageInfo == null && (usageInfo = (HAAdmin.UsageInfo)USAGE.get(cmd)) == null) {
            return;
        }
        String space = usageInfo.args == "" ? "" : " ";
        builder.append("   " + cmd + space + usageInfo.args + ": " + usageInfo.help);
    }

    private static void buildIndividualUsageMsg(String cmd, StringBuilder builder) {
        boolean isHACommand = false;
        HAAdmin.UsageInfo usageInfo = ADMIN_USAGE.get(cmd);
        if (usageInfo == null) {
            usageInfo = (HAAdmin.UsageInfo)USAGE.get(cmd);
            if (usageInfo == null) {
                return;
            }
            isHACommand = true;
        }
        String space = usageInfo.args == "" ? "" : " ";
        builder.append("Usage: yarn rmadmin [" + cmd + space + usageInfo.args + "]\n");
        if (isHACommand) {
            builder.append(cmd + " can only be used when RM HA is enabled");
        }
    }

    private static void buildUsageMsg(StringBuilder builder, boolean isHAEnabled) {
        HAAdmin.UsageInfo usageInfo;
        builder.append("Usage: yarn rmadmin\n");
        for (String cmdKey : ADMIN_USAGE.keySet()) {
            usageInfo = ADMIN_USAGE.get(cmdKey);
            builder.append("   " + cmdKey + " " + usageInfo.args + "\n");
        }
        if (isHAEnabled) {
            for (String cmdKey : USAGE.keySet()) {
                if (cmdKey.equals("-help")) continue;
                usageInfo = (HAAdmin.UsageInfo)USAGE.get(cmdKey);
                builder.append("   " + cmdKey + " " + usageInfo.args + "\n");
            }
        }
    }

    private static void printHelp(String cmd, boolean isHAEnabled) {
        StringBuilder summary = new StringBuilder();
        summary.append("rmadmin is the command to execute YARN administrative commands.\n");
        summary.append("The full syntax is: \n\nyarn rmadmin [-refreshQueues] [-refreshNodes [-g [timeout in seconds] -client|server]] [-refreshSuperUserGroupsConfiguration] [-refreshUserToGroupsMappings] [-refreshAdminAcls] [-refreshServiceAcl] [-getGroup [username]] [-help [cmd]]");
        if (isHAEnabled) {
            RMAdminCLI.appendHAUsage(summary);
        }
        summary.append("\n");
        StringBuilder helpBuilder = new StringBuilder();
        System.out.println(summary);
        for (String cmdKey : ADMIN_USAGE.keySet()) {
            RMAdminCLI.buildHelpMsg(cmdKey, helpBuilder);
            helpBuilder.append("\n");
        }
        if (isHAEnabled) {
            for (String cmdKey : USAGE.keySet()) {
                if (cmdKey.equals("-help")) continue;
                RMAdminCLI.buildHelpMsg(cmdKey, helpBuilder);
                helpBuilder.append("\n");
            }
        }
        System.out.println(helpBuilder);
        System.out.println();
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
    }

    private static void printUsage(String cmd, boolean isHAEnabled) {
        StringBuilder usageBuilder = new StringBuilder();
        if (ADMIN_USAGE.containsKey(cmd) || USAGE.containsKey(cmd)) {
            RMAdminCLI.buildIndividualUsageMsg(cmd, usageBuilder);
        } else {
            RMAdminCLI.buildUsageMsg(usageBuilder, isHAEnabled);
        }
        System.err.println(usageBuilder);
        ToolRunner.printGenericCommandUsage((PrintStream)System.err);
    }

    protected ResourceManagerAdministrationProtocol createAdminProtocol() throws IOException {
        YarnConfiguration conf = new YarnConfiguration(this.getConf());
        return ClientRMProxy.createRMProxy(conf, ResourceManagerAdministrationProtocol.class);
    }

    private int refreshQueues() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshQueuesRequest request = this.recordFactory.newRecordInstance(RefreshQueuesRequest.class);
        adminProtocol.refreshQueues(request);
        return 0;
    }

    private int refreshNodes() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshNodesRequest request = RefreshNodesRequest.newInstance(DecommissionType.NORMAL);
        adminProtocol.refreshNodes(request);
        return 0;
    }

    private int refreshNodes(long timeout, String trackingMode) throws IOException, YarnException {
        long waitingTime;
        if (!"client".equals(trackingMode)) {
            throw new UnsupportedOperationException("Only client tracking mode is currently supported.");
        }
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshNodesRequest gracefulRequest = RefreshNodesRequest.newInstance(DecommissionType.GRACEFUL);
        adminProtocol.refreshNodes(gracefulRequest);
        CheckForDecommissioningNodesRequest checkForDecommissioningNodesRequest = this.recordFactory.newRecordInstance(CheckForDecommissioningNodesRequest.class);
        boolean nodesDecommissioning = true;
        for (waitingTime = 0L; waitingTime < timeout || timeout == -1L; ++waitingTime) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            CheckForDecommissioningNodesResponse checkForDecommissioningNodes = adminProtocol.checkForDecommissioningNodes(checkForDecommissioningNodesRequest);
            Set<NodeId> decommissioningNodes = checkForDecommissioningNodes.getDecommissioningNodes();
            if (decommissioningNodes.isEmpty()) {
                nodesDecommissioning = false;
                break;
            }
            StringBuilder nodes = new StringBuilder();
            for (NodeId nodeId : decommissioningNodes) {
                nodes.append(nodeId).append(",");
            }
            nodes.deleteCharAt(nodes.length() - 1);
            System.out.println("Nodes '" + nodes + "' are still decommissioning.");
        }
        if (nodesDecommissioning) {
            System.out.println("Graceful decommissioning not completed in " + timeout + " seconds, issueing forceful decommissioning command.");
            RefreshNodesRequest forcefulRequest = RefreshNodesRequest.newInstance(DecommissionType.FORCEFUL);
            adminProtocol.refreshNodes(forcefulRequest);
        } else {
            System.out.println("Graceful decommissioning completed in " + waitingTime + " seconds.");
        }
        return 0;
    }

    private int refreshUserToGroupsMappings() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshUserToGroupsMappingsRequest request = this.recordFactory.newRecordInstance(RefreshUserToGroupsMappingsRequest.class);
        adminProtocol.refreshUserToGroupsMappings(request);
        return 0;
    }

    private int refreshSuperUserGroupsConfiguration() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshSuperUserGroupsConfigurationRequest request = this.recordFactory.newRecordInstance(RefreshSuperUserGroupsConfigurationRequest.class);
        adminProtocol.refreshSuperUserGroupsConfiguration(request);
        return 0;
    }

    private int refreshAdminAcls() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshAdminAclsRequest request = this.recordFactory.newRecordInstance(RefreshAdminAclsRequest.class);
        adminProtocol.refreshAdminAcls(request);
        return 0;
    }

    private int refreshServiceAcls() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshServiceAclsRequest request = this.recordFactory.newRecordInstance(RefreshServiceAclsRequest.class);
        adminProtocol.refreshServiceAcls(request);
        return 0;
    }

    private int getGroups(String[] usernames) throws IOException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        if (usernames.length == 0) {
            usernames = new String[]{UserGroupInformation.getCurrentUser().getUserName()};
        }
        for (String username : usernames) {
            StringBuilder sb = new StringBuilder();
            sb.append(username + " :");
            for (String group : adminProtocol.getGroupsForUser(username)) {
                sb.append(" ");
                sb.append(group);
            }
            System.out.println(sb);
        }
        return 0;
    }

    protected static synchronized CommonNodeLabelsManager getNodeLabelManagerInstance(Configuration conf) {
        if (localNodeLabelsManager == null) {
            localNodeLabelsManager = new CommonNodeLabelsManager();
            localNodeLabelsManager.init(conf);
            localNodeLabelsManager.start();
        }
        return localNodeLabelsManager;
    }

    private int addToClusterNodeLabels(String args) throws IOException, YarnException {
        HashSet<String> labels = new HashSet<String>();
        for (String p : args.split(",")) {
            labels.add(p);
        }
        return this.addToClusterNodeLabels(labels);
    }

    private int addToClusterNodeLabels(Set<String> labels) throws IOException, YarnException {
        if (this.directlyAccessNodeLabelStore) {
            RMAdminCLI.getNodeLabelManagerInstance(this.getConf()).addToCluserNodeLabels(labels);
        } else {
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            AddToClusterNodeLabelsRequest request = AddToClusterNodeLabelsRequest.newInstance(labels);
            adminProtocol.addToClusterNodeLabels(request);
        }
        return 0;
    }

    private int removeFromClusterNodeLabels(String args) throws IOException, YarnException {
        HashSet<String> labels = new HashSet<String>();
        for (String p : args.split(",")) {
            labels.add(p);
        }
        if (this.directlyAccessNodeLabelStore) {
            RMAdminCLI.getNodeLabelManagerInstance(this.getConf()).removeFromClusterNodeLabels(labels);
        } else {
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            RemoveFromClusterNodeLabelsRequest request = RemoveFromClusterNodeLabelsRequest.newInstance(labels);
            adminProtocol.removeFromClusterNodeLabels(request);
        }
        return 0;
    }

    private Map<NodeId, Set<String>> buildNodeLabelsFromStr(String args) throws IOException {
        HashMap<NodeId, Set<String>> map = new HashMap<NodeId, Set<String>>();
        for (String nodeToLabels : args.split("[ \n]")) {
            if ((nodeToLabels = nodeToLabels.trim()).isEmpty() || nodeToLabels.startsWith("#")) continue;
            String[] splits = nodeToLabels.split(",");
            String nodeIdStr = splits[0];
            if (nodeIdStr.trim().isEmpty()) {
                throw new IOException("node name cannot be empty");
            }
            NodeId nodeId = ConverterUtils.toNodeIdWithDefaultPort(nodeIdStr);
            map.put(nodeId, new HashSet());
            for (int i = 1; i < splits.length; ++i) {
                if (splits[i].trim().isEmpty()) continue;
                ((Set)map.get(nodeId)).add(splits[i].trim().toLowerCase());
            }
        }
        return map;
    }

    private int replaceLabelsOnNodes(String args) throws IOException, YarnException {
        Map<NodeId, Set<String>> map = this.buildNodeLabelsFromStr(args);
        return this.replaceLabelsOnNodes(map);
    }

    private int replaceLabelsOnNodes(Map<NodeId, Set<String>> map) throws IOException, YarnException {
        if (this.directlyAccessNodeLabelStore) {
            RMAdminCLI.getNodeLabelManagerInstance(this.getConf()).replaceLabelsOnNode(map);
        } else {
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            ReplaceLabelsOnNodeRequest request = ReplaceLabelsOnNodeRequest.newInstance(map);
            adminProtocol.replaceLabelsOnNode(request);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(String[] args) throws Exception {
        int exitCode;
        block36: {
            ArrayList<String> argsList = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-directlyAccessNodeLabelStore")) {
                    this.directlyAccessNodeLabelStore = true;
                    continue;
                }
                argsList.add(args[i]);
            }
            args = argsList.toArray(new String[0]);
            YarnConfiguration yarnConf = this.getConf() == null ? new YarnConfiguration() : new YarnConfiguration(this.getConf());
            boolean isHAEnabled = yarnConf.getBoolean("yarn.resourcemanager.ha.enabled", false);
            if (args.length < 1) {
                RMAdminCLI.printUsage("", isHAEnabled);
                return -1;
            }
            exitCode = -1;
            int i = 0;
            String cmd = args[i++];
            exitCode = 0;
            if ("-help".equals(cmd)) {
                if (i < args.length) {
                    RMAdminCLI.printUsage(args[i], isHAEnabled);
                    return exitCode;
                }
                RMAdminCLI.printHelp("", isHAEnabled);
                return exitCode;
            }
            if (USAGE.containsKey(cmd)) {
                if (isHAEnabled) {
                    return super.run(args);
                }
                System.out.println("Cannot run " + cmd + " when ResourceManager HA is not enabled");
                return -1;
            }
            if (("-refreshAdminAcls".equals(cmd) || "-refreshQueues".equals(cmd) || "-refreshServiceAcl".equals(cmd) || "-refreshUserToGroupsMappings".equals(cmd) || "-refreshSuperUserGroupsConfiguration".equals(cmd)) && args.length != 1) {
                RMAdminCLI.printUsage(cmd, isHAEnabled);
                return exitCode;
            }
            try {
                if ("-refreshQueues".equals(cmd)) {
                    exitCode = this.refreshQueues();
                    break block36;
                }
                if ("-refreshNodes".equals(cmd)) {
                    if (args.length == 1) {
                        exitCode = this.refreshNodes();
                        break block36;
                    } else {
                        String trackingMode;
                        if (args.length != 3 && args.length != 4) {
                            RMAdminCLI.printUsage(cmd, isHAEnabled);
                            return -1;
                        }
                        if (!"-g".equals(args[1])) {
                            RMAdminCLI.printUsage(cmd, isHAEnabled);
                            return -1;
                        }
                        long timeout = -1L;
                        if (args.length == 4) {
                            timeout = this.validateTimeout(args[2]);
                            trackingMode = this.validateTrackingMode(args[3]);
                        } else {
                            trackingMode = this.validateTrackingMode(args[2]);
                        }
                        exitCode = this.refreshNodes(timeout, trackingMode);
                    }
                    break block36;
                }
                if ("-refreshUserToGroupsMappings".equals(cmd)) {
                    exitCode = this.refreshUserToGroupsMappings();
                    break block36;
                }
                if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
                    exitCode = this.refreshSuperUserGroupsConfiguration();
                    break block36;
                }
                if ("-refreshAdminAcls".equals(cmd)) {
                    exitCode = this.refreshAdminAcls();
                    break block36;
                }
                if ("-refreshServiceAcl".equals(cmd)) {
                    exitCode = this.refreshServiceAcls();
                    break block36;
                }
                if ("-getGroups".equals(cmd)) {
                    String[] usernames = Arrays.copyOfRange(args, i, args.length);
                    exitCode = this.getGroups(usernames);
                    break block36;
                }
                if ("-addToClusterNodeLabels".equals(cmd)) {
                    if (i >= args.length) {
                        System.err.println("No cluster node-labels are specified");
                        exitCode = -1;
                        break block36;
                    } else {
                        exitCode = this.addToClusterNodeLabels(args[i]);
                    }
                    break block36;
                }
                if ("-removeFromClusterNodeLabels".equals(cmd)) {
                    if (i >= args.length) {
                        System.err.println("No cluster node-labels are specified");
                        exitCode = -1;
                        break block36;
                    } else {
                        exitCode = this.removeFromClusterNodeLabels(args[i]);
                    }
                    break block36;
                }
                if ("-replaceLabelsOnNode".equals(cmd)) {
                    if (i >= args.length) {
                        System.err.println("No cluster node-labels are specified");
                        exitCode = -1;
                        break block36;
                    } else {
                        exitCode = this.replaceLabelsOnNodes(args[i]);
                    }
                    break block36;
                }
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": Unknown command");
                RMAdminCLI.printUsage("", isHAEnabled);
            }
            catch (IllegalArgumentException arge) {
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
                RMAdminCLI.printUsage(cmd, isHAEnabled);
            }
            catch (RemoteException e) {
                exitCode = -1;
                try {
                    String[] content = e.getLocalizedMessage().split("\n");
                    System.err.println(cmd.substring(1) + ": " + content[0]);
                }
                catch (Exception ex) {
                    System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
                }
            }
            catch (Exception e) {
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
            }
        }
        if (null == localNodeLabelsManager) return exitCode;
        localNodeLabelsManager.stop();
        return exitCode;
    }

    private long validateTimeout(String strTimeout) {
        long timeout;
        try {
            timeout = Long.parseLong(strTimeout);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(INVALID_TIMEOUT_ERR_MSG + strTimeout);
        }
        if (timeout < -1L) {
            throw new IllegalArgumentException(INVALID_TIMEOUT_ERR_MSG + timeout);
        }
        return timeout;
    }

    private String validateTrackingMode(String mode) {
        if ("-client".equals(mode)) {
            return "client";
        }
        if ("-server".equals(mode)) {
            return "server";
        }
        throw new IllegalArgumentException("Invalid mode specified: " + mode);
    }

    public void setConf(Configuration conf) {
        if (conf != null) {
            conf = RMAdminCLI.addSecurityConfiguration(conf);
        }
        super.setConf(conf);
    }

    private static Configuration addSecurityConfiguration(Configuration conf) {
        conf = new YarnConfiguration(conf);
        conf.set("hadoop.security.service.user.name.key", conf.get("yarn.resourcemanager.principal", ""));
        return conf;
    }

    protected HAServiceTarget resolveTarget(String rmId) {
        Collection<String> rmIds = HAUtil.getRMHAIds(this.getConf());
        if (!rmIds.contains(rmId)) {
            StringBuilder msg = new StringBuilder();
            msg.append(rmId + " is not a valid serviceId. It should be one of ");
            for (String id : rmIds) {
                msg.append(id + " ");
            }
            throw new IllegalArgumentException(msg.toString());
        }
        try {
            YarnConfiguration conf = new YarnConfiguration(this.getConf());
            conf.set("yarn.resourcemanager.ha.id", rmId);
            return new RMHAServiceTarget(conf);
        }
        catch (IllegalArgumentException iae) {
            throw new YarnRuntimeException("Could not connect to " + rmId + "; the configuration for it might be missing");
        }
        catch (IOException ioe) {
            throw new YarnRuntimeException("Could not connect to RM HA Admin for node " + rmId);
        }
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new RMAdminCLI(), (String[])args);
        System.exit(result);
    }
}

