/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.sparkproject.guava.annotations.VisibleForTesting;

public abstract class YarnClientUtils {
    public static String getRmPrincipal(Configuration conf) throws IOException {
        String principal = conf.get("yarn.resourcemanager.principal");
        String prepared = null;
        if (principal != null) {
            prepared = YarnClientUtils.getRmPrincipal(principal, conf);
        }
        return prepared;
    }

    public static String getRmPrincipal(String rmPrincipal, Configuration conf) throws IOException {
        if (rmPrincipal == null) {
            throw new IllegalArgumentException("RM principal string is null");
        }
        if (HAUtil.isHAEnabled(conf)) {
            conf = YarnClientUtils.getYarnConfWithRmHaId(conf);
        }
        String hostname = conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032).getHostName();
        return SecurityUtil.getServerPrincipal((String)rmPrincipal, (String)hostname);
    }

    @VisibleForTesting
    static YarnConfiguration getYarnConfWithRmHaId(Configuration conf) throws IOException {
        YarnConfiguration yarnConf = new YarnConfiguration(conf);
        if (yarnConf.get("yarn.resourcemanager.ha.id") == null) {
            String[] rmIds = yarnConf.getStrings("yarn.resourcemanager.ha.rm-ids");
            if (rmIds != null && rmIds.length > 0) {
                yarnConf.set("yarn.resourcemanager.ha.id", rmIds[0]);
            } else {
                throw new IOException("RM_HA_IDS property is not set for HA resource manager");
            }
        }
        return yarnConf;
    }
}

