/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.timeline;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TimelineUtils {
    private static ObjectMapper mapper = new ObjectMapper();

    public static String dumpTimelineRecordtoJSON(Object o) throws JsonGenerationException, JsonMappingException, IOException {
        return TimelineUtils.dumpTimelineRecordtoJSON(o, false);
    }

    public static String dumpTimelineRecordtoJSON(Object o, boolean pretty) throws JsonGenerationException, JsonMappingException, IOException {
        if (pretty) {
            return mapper.defaultPrettyPrintingWriter().writeValueAsString(o);
        }
        return mapper.writeValueAsString(o);
    }

    public static InetSocketAddress getTimelineTokenServiceAddress(Configuration conf) {
        InetSocketAddress timelineServiceAddr = null;
        timelineServiceAddr = YarnConfiguration.useHttps(conf) ? conf.getSocketAddr("yarn.timeline-service.webapp.https.address", "0.0.0.0:8190", 8190) : conf.getSocketAddr("yarn.timeline-service.webapp.address", "0.0.0.0:8188", 8188);
        return timelineServiceAddr;
    }

    public static Text buildTimelineTokenService(Configuration conf) {
        InetSocketAddress timelineServiceAddr = TimelineUtils.getTimelineTokenServiceAddress(conf);
        return SecurityUtil.buildTokenService((InetSocketAddress)timelineServiceAddr);
    }

    static {
        YarnJacksonJaxbJsonProvider.configObjectMapper(mapper);
    }
}

