/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogCleaner;
import kafka.log.LogCleaner$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Time;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.streaming.kafka010.HasOffsetRanges;
import org.apache.spark.streaming.kafka010.KafkaRDD;
import org.apache.spark.streaming.kafka010.KafkaTestUtils;
import org.apache.spark.streaming.kafka010.KafkaUtils$;
import org.apache.spark.streaming.kafka010.LocationStrategies$;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.apache.spark.streaming.kafka010.OffsetRange$;
import org.apache.spark.streaming.kafka010.mocks.MockTime;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001e4A\u0001E\t\u00019!)\u0011\u0005\u0001C\u0001E!IQ\u0005\u0001a\u0001\u0002\u0004%IA\n\u0005\nU\u0001\u0001\r\u00111A\u0005\n-B\u0011\u0002\u000e\u0001A\u0002\u0003\u0005\u000b\u0015B\u0014\t\u000fU\u0002!\u0019!C\u0005m!1!\b\u0001Q\u0001\n]B\u0011b\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001f\t\u0013\u0001\u0003\u0001\u0019!a\u0001\n\u0013\t\u0005\"C\"\u0001\u0001\u0004\u0005\t\u0015)\u0003>\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u00151\u0005\u0001\"\u0011F\u0011\u00159\u0005\u0001\"\u0003I\u0011\u001d\u0011\u0007A1A\u0005\n\rDaa\u001a\u0001!\u0002\u0013!\u0007\"\u00025\u0001\t\u0013I'!D&bM.\f'\u000b\u0012#Tk&$XM\u0003\u0002\u0013'\u0005A1.\u00194lCB\n\u0004G\u0003\u0002\u0015+\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003-]\tQa\u001d9be.T!\u0001G\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0012aA8sO\u000e\u00011C\u0001\u0001\u001e!\tqr$D\u0001\u0016\u0013\t\u0001SCA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0002\"\u0001\n\u0001\u000e\u0003E\tab[1gW\u0006$Vm\u001d;Vi&d7/F\u0001(!\t!\u0003&\u0003\u0002*#\tq1*\u00194lCR+7\u000f^+uS2\u001c\u0018AE6bM.\fG+Z:u+RLGn]0%KF$\"\u0001\f\u001a\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\tUs\u0017\u000e\u001e\u0005\bg\r\t\t\u00111\u0001(\u0003\rAH%M\u0001\u0010W\u000647.\u0019+fgR,F/\u001b7tA\u0005I1\u000f]1sW\u000e{gNZ\u000b\u0002oA\u0011a\u0004O\u0005\u0003sU\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\u0015M\u0004\u0018M]6D_:4\u0007%\u0001\u0002tGV\tQ\b\u0005\u0002\u001f}%\u0011q(\u0006\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007g\u000e|F%Z9\u0015\u00051\u0012\u0005bB\u001a\t\u0003\u0003\u0005\r!P\u0001\u0004g\u000e\u0004\u0013!\u00032fM>\u0014X-\u00117m)\u0005a\u0013\u0001C1gi\u0016\u0014\u0018\t\u001c7\u0002\u001d\u001d,GoS1gW\u0006\u0004\u0016M]1ngR\t\u0011\n\u0005\u0003K\u001fFcV\"A&\u000b\u00051k\u0015\u0001B;uS2T\u0011AT\u0001\u0005U\u00064\u0018-\u0003\u0002Q\u0017\n\u0019Q*\u00199\u0011\u0005IKfBA*X!\t!f&D\u0001V\u0015\t16$\u0001\u0004=e>|GOP\u0005\u00031:\na\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001L\f\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?6\u000bA\u0001\\1oO&\u0011\u0011M\u0018\u0002\u0007\u001f\nTWm\u0019;\u0002\u001dA\u0014XMZ3se\u0016$\u0007j\\:ugV\tA\r\u0005\u0002%K&\u0011a-\u0005\u0002\u0011\u0019>\u001c\u0017\r^5p]N#(/\u0019;fOf\fq\u0002\u001d:fM\u0016\u0014(/\u001a3I_N$8\u000fI\u0001\fG>l\u0007/Y2u\u0019><7\u000f\u0006\u0003-U2\f\b\"B6\u0010\u0001\u0004\t\u0016!\u0002;pa&\u001c\u0007\"B7\u0010\u0001\u0004q\u0017!\u00039beRLG/[8o!\tis.\u0003\u0002q]\t\u0019\u0011J\u001c;\t\u000bI|\u0001\u0019A:\u0002\u00115,7o]1hKN\u00042!\f;w\u0013\t)hFA\u0003BeJ\f\u0017\u0010\u0005\u0003.oF\u000b\u0016B\u0001=/\u0005\u0019!V\u000f\u001d7fe\u0001")
public class KafkaRDDSuite
extends SparkFunSuite {
    private KafkaTestUtils kafkaTestUtils;
    private final SparkConf sparkConf = new SparkConf().setMaster("local[4]").setAppName(this.getClass().getSimpleName()).set("spark.streaming.kafka.consumer.poll.ms", "10000");
    private SparkContext sc;
    private final LocationStrategy preferredHosts = LocationStrategies$.MODULE$.PreferConsistent();

    private KafkaTestUtils kafkaTestUtils() {
        return this.kafkaTestUtils;
    }

    private void kafkaTestUtils_$eq(KafkaTestUtils x$1) {
        this.kafkaTestUtils = x$1;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.sc_$eq(new SparkContext(this.sparkConf()));
        this.kafkaTestUtils_$eq(new KafkaTestUtils());
        this.kafkaTestUtils().setup();
    }

    public void afterAll() {
        try {
            try {
                if (this.sc() != null) {
                    this.sc().stop();
                    this.sc_$eq(null);
                }
            }
            finally {
                if (this.kafkaTestUtils() != null) {
                    this.kafkaTestUtils().teardown();
                    this.kafkaTestUtils_$eq(null);
                }
            }
        }
        finally {
            super.afterAll();
        }
    }

    private java.util.Map<String, Object> getKafkaParams() {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.kafkaTestUtils().brokerAddress()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key.deserializer"), StringDeserializer.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value.deserializer"), StringDeserializer.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.id"), (Object)new StringBuilder(15).append("test-consumer-").append(Random$.MODULE$.nextInt()).append("-").append(System.currentTimeMillis()).toString())}))).asJava();
    }

    private LocationStrategy preferredHosts() {
        return this.preferredHosts;
    }

    private void compactLogs(String topic, int partition, Tuple2<String, String>[] messages) {
        MockTime mockTime = new MockTime();
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        String logDir = this.kafkaTestUtils().brokerLogDir();
        File dir = new File(logDir, new StringBuilder(1).append(topic).append("-").append(partition).toString());
        dir.mkdirs();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Float.valueOf(0.1f));
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        UnifiedLog log = UnifiedLog$.MODULE$.apply(dir, new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()), 0L, 0L, (Scheduler)mockTime.scheduler(), new BrokerTopicStats(), (Time)mockTime, 300000, Integer.MAX_VALUE, Integer.MAX_VALUE, logDirFailureChannel, false, (Option)None$.MODULE$, false, UnifiedLog$.MODULE$.apply$default$15());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                SimpleRecord record = new SimpleRecord(k.getBytes(), v.getBytes());
                return log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{record}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            }
            throw new MatchError((Object)tuple2);
        });
        log.roll(log.roll$default$1());
        logs.put((Object)topicPartition, (Object)log);
        LogCleaner cleaner = new LogCleaner(new CleanerConfig(CleanerConfig$.MODULE$.apply$default$1(), CleanerConfig$.MODULE$.apply$default$2(), CleanerConfig$.MODULE$.apply$default$3(), CleanerConfig$.MODULE$.apply$default$4(), CleanerConfig$.MODULE$.apply$default$5(), CleanerConfig$.MODULE$.apply$default$6(), CleanerConfig$.MODULE$.apply$default$7(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{dir}), logs, logDirFailureChannel, LogCleaner$.MODULE$.$lessinit$greater$default$5());
        cleaner.startup();
        cleaner.awaitCleaned(new TopicPartition(topic, partition), log.activeSegment().baseOffset(), 1000L);
        cleaner.shutdown();
        mockTime.scheduler().shutdown();
    }

    public static final /* synthetic */ boolean $anonfun$new$8(File x$3) {
        return x$3.getName().endsWith(".deleted");
    }

    public static final /* synthetic */ long $anonfun$new$12(OffsetRange o) {
        return o.untilOffset() - o.fromOffset();
    }

    public KafkaRDDSuite() {
        this.test("basic usage", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD emptyRdd;
            String topic = new StringBuilder(12).append("topicbasic-").append(Random$.MODULE$.nextInt()).append("-").append(System.currentTimeMillis()).toString();
            this.kafkaTestUtils().createTopic(topic);
            String[] messages = (String[])((Object[])new String[]{"the", "quick", "brown", "fox"});
            this.kafkaTestUtils().sendMessages(topic, messages);
            java.util.Map<String, Object> kafkaParams = this.getKafkaParams();
            OffsetRange[] offsetRanges = (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply(topic, 0, 0L, (long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).size())});
            RDD rdd = KafkaUtils$.MODULE$.createRDD(this.sc(), kafkaParams, offsetRanges, this.preferredHosts()).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1.value(), ClassTag$.MODULE$.apply(String.class));
            Set received = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.collect())).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(received);
            Set $org_scalatest_assert_macro_right = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).toSet();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count()));
            int $org_scalatest_assert_macro_right2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).size();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((BoundedDouble)rdd.countApprox(0L, rdd.countApprox$default$2()).getFinalValue()).mean()));
            int $org_scalatest_assert_macro_right3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).size();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            RDD $org_scalatest_assert_macro_left4 = rdd;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.take(1))).size()));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.take(1))).head());
            String $org_scalatest_assert_macro_right5 = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.take(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).size() + 10))).size()));
            int $org_scalatest_assert_macro_right6 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).size();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            RDD $org_scalatest_assert_macro_left8 = emptyRdd = KafkaUtils$.MODULE$.createRDD(this.sc(), kafkaParams, (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply(topic, 0, 0L, 0L)}), this.preferredHosts());
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            OffsetRange[] badRanges = (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply(topic, 0, 0L, (long)(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).size() + 1))});
            return (SparkException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String[] result = (String[])KafkaUtils$.MODULE$.createRDD(this.sc(), kafkaParams, badRanges, this.preferredHosts()).map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.value(), ClassTag$.MODULE$.apply(String.class)).collect();
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        }, new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        this.test("compacted topic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD emptyRdd;
            SparkConf compactConf = this.sparkConf().clone();
            compactConf.set("spark.streaming.kafka.allowNonConsecutiveOffsets", "true");
            this.sc().stop();
            this.sc_$eq(new SparkContext(compactConf));
            String topic = new StringBuilder(16).append("topiccompacted-").append(Random$.MODULE$.nextInt()).append("-").append(System.currentTimeMillis()).toString();
            Tuple2[] messages = (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)"1"), new Tuple2((Object)"a", (Object)"2"), new Tuple2((Object)"b", (Object)"1"), new Tuple2((Object)"c", (Object)"1"), new Tuple2((Object)"c", (Object)"2"), new Tuple2((Object)"b", (Object)"2"), new Tuple2((Object)"b", (Object)"3")});
            Tuple2[] compactedMessages = (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)"2"), new Tuple2((Object)"b", (Object)"3"), new Tuple2((Object)"c", (Object)"2")});
            this.compactLogs(topic, 0, messages);
            Properties props = new Properties();
            props.put("cleanup.policy", "compact");
            props.put("flush.messages", "1");
            props.put("segment.ms", "1");
            props.put("segment.bytes", "256");
            this.kafkaTestUtils().createTopic(topic, 1, props);
            java.util.Map<String, Object> kafkaParams = this.getKafkaParams();
            OffsetRange[] offsetRanges = (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply(topic, 0, 0L, (long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).size())});
            RDD rdd = KafkaUtils$.MODULE$.createRDD(this.sc(), kafkaParams, offsetRanges, this.preferredHosts()).map((Function1 & Serializable & scala.Serializable)m -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(m.key()), m.value()), ClassTag$.MODULE$.apply(Tuple2.class));
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(20)).second())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds())), (Function0 & Serializable & scala.Serializable)() -> {
                File dir = new File(this.kafkaTestUtils().brokerLogDir(), new StringBuilder(2).append(topic).append("-0").toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaRDDSuite.$anonfun$new$8(x$3))), "scala.Predef.refArrayOps[java.io.File](dir.listFiles()).exists(((x$3: java.io.File) => x$3.getName().endsWith(\".deleted\")))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            Set received = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.collect())).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(received);
            Set $org_scalatest_assert_macro_right = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compactedMessages)).toSet();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count()));
            int $org_scalatest_assert_macro_right2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compactedMessages)).size();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((BoundedDouble)rdd.countApprox(0L, rdd.countApprox$default$2()).getFinalValue()).mean()));
            int $org_scalatest_assert_macro_right3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compactedMessages)).size();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            RDD $org_scalatest_assert_macro_left4 = rdd;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.take(1))).size()));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.take(1))).head());
            Tuple2 $org_scalatest_assert_macro_right5 = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compactedMessages)).head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.take(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).size() + 10))).size()));
            int $org_scalatest_assert_macro_right6 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compactedMessages)).size();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            RDD $org_scalatest_assert_macro_left8 = emptyRdd = KafkaUtils$.MODULE$.createRDD(this.sc(), kafkaParams, (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply(topic, 0, 0L, 0L)}), this.preferredHosts());
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
            OffsetRange[] badRanges = (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply(topic, 0, 0L, (long)(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).size() + 1))});
            return (SparkException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String[] result = (String[])KafkaUtils$.MODULE$.createRDD(this.sc(), kafkaParams, badRanges, this.preferredHosts()).map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4.value(), ClassTag$.MODULE$.apply(String.class)).collect();
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        }, new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("iterator boundary conditions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String topic = new StringBuilder(15).append("topicboundary-").append(Random$.MODULE$.nextInt()).append("-").append(System.currentTimeMillis()).toString();
            scala.collection.immutable.Map sent = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)10))}));
            this.kafkaTestUtils().createTopic(topic);
            java.util.Map<String, Object> kafkaParams = this.getKafkaParams();
            this.kafkaTestUtils().sendMessages(topic, (scala.collection.immutable.Map<String, Object>)sent);
            int sentCount = BoxesRunTime.unboxToInt((Object)sent.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            RDD rdd = KafkaUtils$.MODULE$.createRDD(this.sc(), kafkaParams, (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply(topic, 0, 0L, (long)sentCount)}), this.preferredHosts());
            OffsetRange[] ranges = ((HasOffsetRanges)rdd).offsetRanges();
            long rangeCount = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ranges)).map((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToLong((long)KafkaRDDSuite.$anonfun$new$12(o)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)rangeCount));
            int $org_scalatest_assert_macro_right = sentCount;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"offset range didn't include all sent messages", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])rdd.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.offset()), ClassTag$.MODULE$.Long()).collect())).sorted((Ordering)Ordering.Long$.MODULE$));
            int[] $org_scalatest_assert_macro_right2 = (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), sentCount).toArray(ClassTag$.MODULE$.Int());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"didn't get all sent messages", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
            RDD rdd2 = KafkaUtils$.MODULE$.createRDD(this.sc(), kafkaParams, (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply(topic, 0, (long)sentCount, (long)sentCount)}), this.preferredHosts());
            scala.collection.immutable.Map sentOnlyOne = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            this.kafkaTestUtils().sendMessages(topic, (scala.collection.immutable.Map<String, Object>)sentOnlyOne);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd2.map((Function1 & Serializable & scala.Serializable)x$6 -> (String)x$6.value(), ClassTag$.MODULE$.apply(String.class)).collect())).size()));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"got messages when there shouldn't be any", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
            RDD rdd3 = KafkaUtils$.MODULE$.createRDD(this.sc(), kafkaParams, (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply(topic, 0, (long)sentCount, (long)(sentCount + 1))}), this.preferredHosts());
            this.kafkaTestUtils().sendMessages(topic, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"extra"), (Object)BoxesRunTime.boxToInteger((int)22))}))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd3.map((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7.value(), ClassTag$.MODULE$.apply(String.class)).collect())).head());
            String $org_scalatest_assert_macro_right4 = (String)sentOnlyOne.keys().head();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"didn't get exactly one message", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        }, new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        this.test("executor sorting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            HashMap<String, Object> kafkaParams = new HashMap<String, Object>(this.getKafkaParams());
            kafkaParams.put("auto.offset.reset", "none");
            KafkaRDD rdd = new KafkaRDD(this.sc(), kafkaParams, (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply("unused", 0, 1L, 2L)}), Collections.emptyMap(), true);
            ExecutorCacheTaskLocation a3 = new ExecutorCacheTaskLocation("a", "3");
            ExecutorCacheTaskLocation a4 = new ExecutorCacheTaskLocation("a", "4");
            ExecutorCacheTaskLocation b1 = new ExecutorCacheTaskLocation("b", "1");
            ExecutorCacheTaskLocation b2 = new ExecutorCacheTaskLocation("b", "2");
            ExecutorCacheTaskLocation[] correct = (ExecutorCacheTaskLocation[])((Object[])new ExecutorCacheTaskLocation[]{b2, b1, a4, a3});
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])correct)).permutations().foreach((Function1 & Serializable & scala.Serializable)p -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p)).sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)rdd.compareExecutors(a, b))));
                ExecutorCacheTaskLocation[] $org_scalatest_assert_macro_right = correct;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
            });
        }, new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
    }
}

