/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.File;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.metrics.source.Source;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.streaming.BatchCounter;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.Checkpoint$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.LocalStreamingContext;
import org.apache.spark.streaming.Milliseconds$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.SlowTestReceiver;
import org.apache.spark.streaming.SlowTestReceiver$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.StreamingContextState;
import org.apache.spark.streaming.StreamingContextSuite$;
import org.apache.spark.streaming.StreamingSource;
import org.apache.spark.streaming.TestException;
import org.apache.spark.streaming.TestInputStream;
import org.apache.spark.streaming.TestOutputStream;
import org.apache.spark.streaming.TestOutputStream$;
import org.apache.spark.streaming.TestReceiver;
import org.apache.spark.streaming.TestReceiver$;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.testPackage$;
import org.apache.spark.streaming.ui.StreamingJobProgressListener;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$PrivateMethod$;
import org.scalatest.Tag;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.Signaler;
import org.scalatest.concurrent.ThreadSignaler$;
import org.scalatest.concurrent.TimeLimits;
import org.scalatest.enablers.Retrying$;
import org.scalatest.enablers.Timed;
import org.scalatest.enablers.Timed$;
import org.scalatest.exceptions.TestFailedDueToTimeoutException;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileIntRef;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u000f\u001f\u0001\u001dBQA\u0010\u0001\u0005\u0002}Bq!\u0011\u0001C\u0002\u0013\r!\t\u0003\u0004G\u0001\u0001\u0006Ia\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019\t\u0006\u0001)A\u0005\u0013\"9!\u000b\u0001b\u0001\n\u0003A\u0005BB*\u0001A\u0003%\u0011\nC\u0004U\u0001\t\u0007I\u0011A+\t\re\u0003\u0001\u0015!\u0003W\u0011\u001dQ\u0006A1A\u0005\u0002!Caa\u0017\u0001!\u0002\u0013I\u0005b\u0002/\u0001\u0005\u0004%\t!\u0018\u0005\u0007I\u0002\u0001\u000b\u0011\u00020\t\u000f\u0015\u0004!\u0019!C\u0001M\"1!\u000e\u0001Q\u0001\n\u001dDQa\u001b\u0001\u0005\u00021DQa\u001f\u0001\u0005\u0002qDa!a\u0004\u0001\t\u0003axaBA\t=!%\u00111\u0003\u0004\u0007;yAI!!\u0006\t\ry\"B\u0011AA\u0016\u0011%\ti\u0003\u0006b\u0001\n\u0013\ty\u0003\u0003\u0005\u0002ZQ\u0001\u000b\u0011BA\u0019\u0011\u001d\tY\u0006\u0006C\u0005\u0003;B\u0011\"a\u001b\u0015\u0005\u0004%I!!\u001c\t\u0011\u0005]D\u0003)A\u0005\u0003_Bq!!\u001f\u0015\t\u0013\tY\bC\u0005\u0002\u0002R\t\t\u0011\"\u0003\u0002\u0004\n)2\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010^*vSR,'BA\u0010!\u0003%\u0019HO]3b[&twM\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u0015-aa\u0002\"!\u000b\u0016\u000e\u0003\u0001J!a\u000b\u0011\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tic&D\u0001\u001f\u0013\tycDA\u000bM_\u000e\fGn\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014AC2p]\u000e,(O]3oi*\u0011Q\u0007J\u0001\ng\u000e\fG.\u0019;fgRL!a\u000e\u001a\u0003\u0015QKW.\u001a'j[&$8\u000f\u0005\u0002:y5\t!H\u0003\u0002<A\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002>u\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001A!\ti\u0003!\u0001\u0005tS\u001et\u0017\r\\3s+\u0005\u0019\u0005CA\u0019E\u0013\t)%G\u0001\u0005TS\u001et\u0017\r\\3s\u0003%\u0019\u0018n\u001a8bY\u0016\u0014\b%\u0001\u0004nCN$XM]\u000b\u0002\u0013B\u0011!jT\u0007\u0002\u0017*\u0011A*T\u0001\u0005Y\u0006twMC\u0001O\u0003\u0011Q\u0017M^1\n\u0005A[%AB*ue&tw-A\u0004nCN$XM\u001d\u0011\u0002\u000f\u0005\u0004\bOT1nK\u0006A\u0011\r\u001d9OC6,\u0007%A\u0007cCR\u001c\u0007\u000eR;sCRLwN\\\u000b\u0002-B\u0011QfV\u0005\u00031z\u0011\u0001\u0002R;sCRLwN\\\u0001\u000fE\u0006$8\r\u001b#ve\u0006$\u0018n\u001c8!\u0003%\u0019\b/\u0019:l\u0011>lW-\u0001\u0006ta\u0006\u00148\u000eS8nK\u0002\nq!\u001a8w!\u0006L'/F\u0001_!\u0011y&-S%\u000e\u0003\u0001T\u0011!Y\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0002\u0014a\u0001V;qY\u0016\u0014\u0014\u0001C3omB\u000b\u0017N\u001d\u0011\u0002\t\r|gNZ\u000b\u0002OB\u0011\u0011\u0006[\u0005\u0003S\u0002\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u000b\r|gN\u001a\u0011\u0002\u001d\u0005$G-\u00138qkR\u001cFO]3b[R\u0011QN\u001e\t\u0004]F\u001cX\"A8\u000b\u0005At\u0012a\u00023tiJ,\u0017-\\\u0005\u0003e>\u0014q\u0001R*ue\u0016\fW\u000e\u0005\u0002`i&\u0011Q\u000f\u0019\u0002\u0004\u0013:$\b\"B<\u0011\u0001\u0004A\u0018!A:\u0011\u00055J\u0018B\u0001>\u001f\u0005A\u0019FO]3b[&twmQ8oi\u0016DH/A\u000bde\u0016\fG/\u001a,bY&$7\t[3dWB|\u0017N\u001c;\u0015\u0003u\u00042A`A\u0006\u001d\ry\u0018q\u0001\t\u0004\u0003\u0003\u0001WBAA\u0002\u0015\r\t)AJ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%\u0001-\u0001\u0004Qe\u0016$WMZ\u0005\u0004!\u00065!bAA\u0005A\u0006I2M]3bi\u0016\u001cuN\u001d:vaR,Gm\u00115fG.\u0004x.\u001b8u\u0003U\u0019FO]3b[&twmQ8oi\u0016DHoU;ji\u0016\u0004\"!\f\u000b\u0014\u000fQ\t9\"!\b\u0002&A\u0019q,!\u0007\n\u0007\u0005m\u0001M\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003?\t\t#D\u00015\u0013\r\t\u0019\u0003\u000e\u0002\u0014!JLg/\u0019;f\u001b\u0016$\bn\u001c3UKN$XM\u001d\t\u0004?\u0006\u001d\u0012bAA\u0015A\na1+\u001a:jC2L'0\u00192mKR\u0011\u00111C\u0001\t?N|WO]2fgV\u0011\u0011\u0011\u0007\t\u0007\u0003g\t)$!\u000f\u000e\u0003QIA!a\u000e\u0002\"\ti\u0001K]5wCR,W*\u001a;i_\u0012\u0004b!a\u000f\u0002F\u0005%SBAA\u001f\u0015\u0011\ty$!\u0011\u0002\u000f5,H/\u00192mK*\u0019\u00111\t1\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002H\u0005u\"aC!se\u0006L()\u001e4gKJ\u0004B!a\u0013\u0002V5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&\u0001\u0004t_V\u00148-\u001a\u0006\u0004\u0003'\u0002\u0013aB7fiJL7m]\u0005\u0005\u0003/\niE\u0001\u0004T_V\u00148-Z\u0001\n?N|WO]2fg\u0002\n!bZ3u'>,(oY3t)\u0011\tI$a\u0018\t\u000f\u0005\u0005\u0004\u00041\u0001\u0002d\u0005iQ.\u001a;sS\u000e\u001c8+_:uK6\u0004B!!\u001a\u0002h5\u0011\u0011\u0011K\u0005\u0005\u0003S\n\tFA\u0007NKR\u0014\u0018nY:TsN$X-\\\u0001\u0011?N$(/Z1nS:<7k\\;sG\u0016,\"!a\u001c\u0011\r\u0005M\u0012QGA9!\ri\u00131O\u0005\u0004\u0003kr\"aD*ue\u0016\fW.\u001b8h'>,(oY3\u0002#}\u001bHO]3b[&twmU8ve\u000e,\u0007%\u0001\nhKR\u001cFO]3b[&twmU8ve\u000e,G\u0003BA9\u0003{Ba!a \u001c\u0001\u0004A\u0018\u0001E:ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0015\u0005c\u0001&\u0002\b&\u0019\u0011\u0011R&\u0003\r=\u0013'.Z2u\u0001")
public class StreamingContextSuite
extends SparkFunSuite
implements LocalStreamingContext,
TimeLimits {
    private final Signaler signaler;
    private final String master;
    private final String appName;
    private final Duration batchDuration;
    private final String sparkHome;
    private final Tuple2<String, String> envPair;
    private final SparkConf conf;
    private transient StreamingContext ssc;
    private final transient boolean stopSparkContext;

    public static PrivateMethodTester.Invoker anyRefToInvoker(Object object) {
        return StreamingContextSuite$.MODULE$.anyRefToInvoker(object);
    }

    public static PrivateMethodTester$PrivateMethod$ PrivateMethod() {
        return StreamingContextSuite$.MODULE$.PrivateMethod();
    }

    public <T> T failAfter(Span timeout, Function0<T> fun, Signaler signaler, Prettifier prettifier, Position pos, Timed<T> timed) {
        return (T)TimeLimits.failAfter$((TimeLimits)this, (Span)timeout, fun, (Signaler)signaler, (Prettifier)prettifier, (Position)pos, timed);
    }

    public <T> Prettifier failAfter$default$4(Span timeout, Function0<T> fun) {
        return TimeLimits.failAfter$default$4$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Position failAfter$default$5(Span timeout, Function0<T> fun) {
        return TimeLimits.failAfter$default$5$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Timed<T> failAfter$default$6(Span timeout, Function0<T> fun) {
        return TimeLimits.failAfter$default$6$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> T cancelAfter(Span timeout, Function0<T> fun, Signaler signaler, Prettifier prettifier, Position pos, Timed<T> timed) {
        return (T)TimeLimits.cancelAfter$((TimeLimits)this, (Span)timeout, fun, (Signaler)signaler, (Prettifier)prettifier, (Position)pos, timed);
    }

    public <T> Prettifier cancelAfter$default$4(Span timeout, Function0<T> fun) {
        return TimeLimits.cancelAfter$default$4$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Position cancelAfter$default$5(Span timeout, Function0<T> fun) {
        return TimeLimits.cancelAfter$default$5$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Timed<T> cancelAfter$default$6(Span timeout, Function0<T> fun) {
        return TimeLimits.cancelAfter$default$6$((TimeLimits)this, (Span)timeout, fun);
    }

    @Override
    public /* synthetic */ void org$apache$spark$streaming$LocalStreamingContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void afterEach() {
        LocalStreamingContext.afterEach$(this);
    }

    @Override
    public void resetStreamingContext() {
        LocalStreamingContext.resetStreamingContext$(this);
    }

    @Override
    public StreamingContext ssc() {
        return this.ssc;
    }

    @Override
    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    @Override
    public boolean stopSparkContext() {
        return this.stopSparkContext;
    }

    @Override
    public void org$apache$spark$streaming$LocalStreamingContext$_setter_$stopSparkContext_$eq(boolean x$1) {
        this.stopSparkContext = x$1;
    }

    public Signaler signaler() {
        return this.signaler;
    }

    public String master() {
        return this.master;
    }

    public String appName() {
        return this.appName;
    }

    public Duration batchDuration() {
        return this.batchDuration;
    }

    public String sparkHome() {
        return this.sparkHome;
    }

    public Tuple2<String, String> envPair() {
        return this.envPair;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public DStream<Object> addInputStream(StreamingContext s) {
        IndexedSeq input = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).map((Function1 & Serializable & scala.Serializable)i -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        TestInputStream inputStream = new TestInputStream(s, input, 1, ClassTag$.MODULE$.Int());
        return inputStream;
    }

    public String createValidCheckpoint() {
        String testDirectory = Utils$.MODULE$.createTempDir().getAbsolutePath();
        String checkpointDirectory = Utils$.MODULE$.createTempDir().getAbsolutePath();
        this.ssc_$eq(new StreamingContext(this.conf().clone().set("someKey", "someValue"), this.batchDuration()));
        this.ssc().checkpoint(checkpointDirectory);
        this.ssc().textFileStream(testDirectory).foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
            rdd.count();
            return BoxedUnit.UNIT;
        });
        this.ssc().start();
        try {
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable & scala.Serializable)() -> {
                int $org_scalatest_assert_macro_left = Checkpoint$.MODULE$.getCheckpointFiles(checkpointDirectory, Checkpoint$.MODULE$.getCheckpointFiles$default$2()).size();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 902));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 901));
        }
        finally {
            StreamingContext qual$1 = this.ssc();
            boolean x$1 = qual$1.stop$default$1();
            qual$1.stop(x$1);
        }
        return checkpointDirectory;
    }

    public String createCorruptedCheckpoint() {
        String checkpointDirectory = Utils$.MODULE$.createTempDir().getAbsolutePath();
        Path fakeCheckpointFile = Checkpoint$.MODULE$.checkpointFile(checkpointDirectory, new Time(1000L));
        FileUtils.write((File)new File(fakeCheckpointFile.toString()), (CharSequence)"blablabla", (Charset)StandardCharsets.UTF_8);
        Seq $org_scalatest_assert_macro_left = Checkpoint$.MODULE$.getCheckpointFiles(checkpointDirectory, Checkpoint$.MODULE$.getCheckpointFiles$default$2());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 914));
        return checkpointDirectory;
    }

    public static final /* synthetic */ void $anonfun$new$14(StreamingContextSuite $this, RDD rdd) {
        new StringBuilder(0).append(rdd.count()).append($this.appName()).toString();
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$19(int x) {
        return new Tuple2.mcII.sp(x, 1);
    }

    public static final /* synthetic */ void $anonfun$new$22(VolatileObjectRef jobGroupFound$1, SparkContext sc$1, VolatileObjectRef jobDescFound$1, VolatileObjectRef jobInterruptFound$1, VolatileObjectRef customPropFound$1, VolatileBooleanRef allFound$1, RDD rdd) {
        jobGroupFound$1.elem = sc$1.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_GROUP_ID());
        jobDescFound$1.elem = sc$1.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION());
        jobInterruptFound$1.elem = sc$1.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_INTERRUPT_ON_CANCEL());
        customPropFound$1.elem = sc$1.getLocalProperty("customPropKey");
        allFound$1.elem = true;
    }

    public static final /* synthetic */ void $anonfun$new$35(StreamingContextSuite $this, VolatileIntRef runningCount$1, RDD rdd) {
        long count = BoxesRunTime.unboxToLong((Object)rdd.first());
        runningCount$1.elem += (int)count;
        $this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Count = ").append(count).append(", Running count = ").append(runningCount$1.elem).toString());
    }

    public static final /* synthetic */ void $anonfun$new$41(RDD x$1) {
    }

    public static final /* synthetic */ void $anonfun$new$45(StreamingContextSuite $this, IntRef runningCount$2, RDD rdd) {
        long count = BoxesRunTime.unboxToLong((Object)rdd.first());
        runningCount$2.elem += (int)count;
        $this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Count = ").append(count).append(", Running count = ").append(runningCount$2.elem).toString());
    }

    private final StreamingContext creatingFunction$1(BooleanRef newContextCreated$1, SparkConf conf$1) {
        newContextCreated$1.elem = true;
        return new StreamingContext(conf$1, this.batchDuration());
    }

    private final void testGetOrCreate$1(Function0 body, BooleanRef newContextCreated$1) {
        newContextCreated$1.elem = false;
        try {
            body.apply$mcV$sp();
        }
        finally {
            if (this.ssc() != null) {
                StreamingContext qual$1 = this.ssc();
                boolean x$1 = qual$1.stop$default$1();
                qual$1.stop(x$1);
            }
            this.ssc_$eq(null);
        }
    }

    private final StreamingContext creatingFunc$1(SparkContext sc, BooleanRef newContextCreated$2) {
        newContextCreated$2.elem = true;
        StreamingContext newSsc = new StreamingContext(sc, this.batchDuration());
        DStream<Object> input = this.addInputStream(newSsc);
        input.foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
            rdd.count();
            return BoxedUnit.UNIT;
        });
        return newSsc;
    }

    private final void testGetActiveOrCreate$1(Function0 body, BooleanRef newContextCreated$2) {
        newContextCreated$2.elem = false;
        try {
            body.apply$mcV$sp();
        }
        finally {
            if (this.ssc() != null) {
                this.ssc().stop(false);
            }
            this.ssc_$eq(null);
        }
    }

    private final StreamingContext creatingFunction$2(BooleanRef newContextCreated$3) {
        newContextCreated$3.elem = true;
        return new StreamingContext(this.conf(), this.batchDuration());
    }

    private final void testGetActiveOrCreate$2(Function0 body, BooleanRef newContextCreated$3) {
        Predef$.MODULE$.require(StreamingContext$.MODULE$.getActive().isEmpty());
        newContextCreated$3.elem = false;
        try {
            body.apply$mcV$sp();
        }
        finally {
            if (this.ssc() != null) {
                StreamingContext qual$1 = this.ssc();
                boolean x$1 = qual$1.stop$default$1();
                qual$1.stop(x$1);
            }
            this.ssc_$eq(null);
        }
    }

    private final void testForException$1(String clue, String expectedErrorMsg, Function0 body) {
        this.withClue(clue, (Function0 & Serializable & scala.Serializable)() -> {
            IllegalStateException ex = (IllegalStateException)this.intercept(body, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 767));
            String $org_scalatest_assert_macro_left = ex.getMessage().toLowerCase(Locale.ROOT);
            String $org_scalatest_assert_macro_right = expectedErrorMsg;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 770));
        });
    }

    private final StreamingContext creatingFunction$3(String checkpointDirectory$1) {
        StreamingContext _ssc = new StreamingContext(this.conf(), this.batchDuration());
        SparkContext qual$1 = _ssc.sparkContext();
        Range.Inclusive x$1 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int x$2 = qual$1.parallelize$default$2();
        RDD rdd = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.Int());
        _ssc.checkpoint(checkpointDirectory$1);
        _ssc.queueStream((Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[]{rdd})), _ssc.queueStream$default$2(), ClassTag$.MODULE$.Int()).register();
        return _ssc;
    }

    public static final /* synthetic */ void $anonfun$new$133(StreamingContextSuite $this, VolatileBooleanRef stopping$1, CountDownLatch latch$1, RDD rdd) {
        if (BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])rdd.collect())).headOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) > 0L && !stopping$1.elem) {
            stopping$1.elem = true;
            new Thread($this, latch$1){
                private final /* synthetic */ StreamingContextSuite $outer;
                private final CountDownLatch latch$1;

                public void run() {
                    this.$outer.ssc().stop(true, false);
                    this.latch$1.countDown();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.latch$1 = latch$1;
                    this.setDaemon(true);
                }
            }.start();
            return;
        }
    }

    public StreamingContextSuite() {
        LocalStreamingContext.$init$(this);
        TimeLimits.$init$((TimeLimits)this);
        this.signaler = ThreadSignaler$.MODULE$;
        this.master = "local[2]";
        this.appName = this.getClass().getSimpleName();
        this.batchDuration = Milliseconds$.MODULE$.apply(500L);
        this.sparkHome = "someDir";
        this.envPair = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)"value");
        this.conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
        this.test("from no conf constructor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().sparkContext().conf().get("spark.master"));
            String $org_scalatest_assert_macro_right = this.master();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.ssc().sparkContext().conf().get("spark.app.name"));
            String $org_scalatest_assert_macro_right2 = this.appName();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("from no conf + spark home", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), this.sparkHome(), (Seq)Nil$.MODULE$, StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().conf().get("spark.home"));
            String $org_scalatest_assert_macro_right = this.sparkHome();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("from no conf + spark home + env", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), this.sparkHome(), (Seq)Nil$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.envPair()}))));
            Seq $org_scalatest_assert_macro_left = this.ssc().conf().getExecutorEnv();
            Tuple2<String, String> $org_scalatest_assert_macro_right = this.envPair();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("from conf with settings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf myConf = SparkContext$.MODULE$.updatedConf(new SparkConf(false), this.master(), this.appName(), SparkContext$.MODULE$.updatedConf$default$4(), SparkContext$.MODULE$.updatedConf$default$5(), SparkContext$.MODULE$.updatedConf$default$6());
            myConf.set("spark.dummyTimeConfig", "10s");
            this.ssc_$eq(new StreamingContext(myConf, this.batchDuration()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.ssc().conf().getTimeAsSeconds("spark.dummyTimeConfig", "-1")));
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("from existing SparkContext", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkContext sc = new SparkContext(this.master(), this.appName());
            this.ssc_$eq(new StreamingContext(sc, this.batchDuration()));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("from existing SparkContext with settings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf myConf = SparkContext$.MODULE$.updatedConf(new SparkConf(false), this.master(), this.appName(), SparkContext$.MODULE$.updatedConf$default$4(), SparkContext$.MODULE$.updatedConf$default$5(), SparkContext$.MODULE$.updatedConf$default$6());
            myConf.set("spark.dummyTimeConfig", "10s");
            this.ssc_$eq(new StreamingContext(myConf, this.batchDuration()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.ssc().conf().getTimeAsSeconds("spark.dummyTimeConfig", "-1")));
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("from checkpoint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf myConf = SparkContext$.MODULE$.updatedConf(new SparkConf(false), this.master(), this.appName(), SparkContext$.MODULE$.updatedConf$default$4(), SparkContext$.MODULE$.updatedConf$default$5(), SparkContext$.MODULE$.updatedConf$default$6());
            myConf.set("spark.dummyTimeConfig", "10s");
            StreamingContext ssc1 = new StreamingContext(myConf, this.batchDuration());
            this.addInputStream(ssc1).register();
            ssc1.start();
            Checkpoint cp = new Checkpoint(ssc1, new Time(1000L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)Utils$.MODULE$.timeStringAsSeconds((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cp.sparkConfPairs())).toMap(Predef$.MODULE$.$conforms()).getOrElse((Object)"spark.dummyTimeConfig", (Function0 & Serializable & scala.Serializable)() -> "-1"))));
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            ssc1.stop(ssc1.stop$default$1());
            Checkpoint newCp = (Checkpoint)Utils$.MODULE$.deserialize(Utils$.MODULE$.serialize((Object)cp));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)newCp.createSparkConf().getTimeAsSeconds("spark.dummyTimeConfig", "-1")));
            int $org_scalatest_assert_macro_right2 = 10;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            this.ssc_$eq(new StreamingContext(null, newCp, null));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.ssc().conf().getTimeAsSeconds("spark.dummyTimeConfig", "-1")));
            int $org_scalatest_assert_macro_right3 = 10;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("checkPoint from conf", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String checkpointDirectory = Utils$.MODULE$.createTempDir().getAbsolutePath();
            SparkConf myConf = SparkContext$.MODULE$.updatedConf(new SparkConf(false), this.master(), this.appName(), SparkContext$.MODULE$.updatedConf$default$4(), SparkContext$.MODULE$.updatedConf$default$5(), SparkContext$.MODULE$.updatedConf$default$6());
            myConf.set("spark.streaming.checkpoint.directory", checkpointDirectory);
            this.ssc_$eq(new StreamingContext(myConf, this.batchDuration()));
            String $org_scalatest_assert_macro_left = this.ssc().checkpointDir();
            Object $org_scalatest_assert_macro_right = null;
            String string = $org_scalatest_assert_macro_left;
            Object var6_5 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, string == null ? var6_5 != null : !string.equals(var6_5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("state matching", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(StreamingContextState.INITIALIZED);
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.INITIALIZED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            StreamingContextState $org_scalatest_assert_macro_left2 = StreamingContextState.INITIALIZED;
            StreamingContextState $org_scalatest_assert_macro_right2 = StreamingContextState.ACTIVE;
            StreamingContextState streamingContextState = $org_scalatest_assert_macro_left2;
            StreamingContextState streamingContextState2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", (Object)$org_scalatest_assert_macro_right2, streamingContextState == null ? streamingContextState2 != null : !streamingContextState.equals(streamingContextState2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("start and stop state check", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            this.addInputStream(this.ssc()).register();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.INITIALIZED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            this.ssc().start();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right2 = StreamingContextState.ACTIVE;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            StreamingContext qual$1 = this.ssc();
            boolean x$1 = qual$1.stop$default$1();
            qual$1.stop(x$1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right3 = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            return (Exception)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                SparkContext qual$2 = this.ssc().sparkContext();
                Range.Inclusive x$2 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
                int x$3 = qual$2.makeRDD$default$2();
                return qual$2.makeRDD((Seq)x$2, x$3, ClassTag$.MODULE$.Int());
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("start with non-serializable DStream checkpoints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            File checkpointDir = Utils$.MODULE$.createTempDir();
            this.ssc_$eq(new StreamingContext(this.conf(), this.batchDuration()));
            this.ssc().checkpoint(checkpointDir.getAbsolutePath());
            this.addInputStream(this.ssc()).foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
                StreamingContextSuite.$anonfun$new$14(this, rdd);
                return BoxedUnit.UNIT;
            });
            NotSerializableException exception = (NotSerializableException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.ssc().start(), ClassTag$.MODULE$.apply(NotSerializableException.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "DStreams with their functions are not serializable";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right2 = StreamingContextState.ACTIVE;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!==", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$bang$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            Option $org_scalatest_assert_macro_left3 = StreamingContext$.MODULE$.getActive();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("start failure should stop internal components", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.conf(), this.batchDuration()));
            DStream<Object> inputStream = this.addInputStream(this.ssc());
            Function2 & Serializable & scala.Serializable updateFunc = (Function2 & Serializable & scala.Serializable)(values, state) -> new Some((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)values.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + BoxesRunTime.unboxToInt((Object)state.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)))));
            DStream$.MODULE$.toPairDStreamFunctions(inputStream.map((Function1 & Serializable & scala.Serializable)x -> StreamingContextSuite.$anonfun$new$19(BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey((Function2)updateFunc, ClassTag$.MODULE$.Int());
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.ssc().start(), ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.ssc().scheduler().isStarted()));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("start should set local properties of streaming jobs correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.conf(), this.batchDuration()));
            this.ssc().sc().setJobGroup("non-streaming", "non-streaming", true);
            SparkContext sc = this.ssc().sc();
            VolatileObjectRef jobGroupFound = VolatileObjectRef.create((Object)"");
            VolatileObjectRef jobDescFound = VolatileObjectRef.create((Object)"");
            VolatileObjectRef jobInterruptFound = VolatileObjectRef.create((Object)"");
            VolatileObjectRef customPropFound = VolatileObjectRef.create((Object)"");
            VolatileBooleanRef allFound = VolatileBooleanRef.create((boolean)false);
            this.addInputStream(this.ssc()).foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
                StreamingContextSuite.$anonfun$new$22(jobGroupFound, sc, jobDescFound, jobInterruptFound, customPropFound, allFound, rdd);
                return BoxedUnit.UNIT;
            });
            this.ssc().sc().setLocalProperty("customPropKey", "value1");
            this.ssc().start();
            this.ssc().sc().setLocalProperty("customPropKey", "value2");
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(allFound$1.elem, "allFound", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer((String)jobGroupFound.elem);
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            String $org_scalatest_assert_macro_left2 = (String)jobDescFound.elem;
            String $org_scalatest_assert_macro_right2 = "Streaming job from";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer((String)jobInterruptFound.elem);
            String $org_scalatest_assert_macro_right3 = "false";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer((String)customPropFound.elem);
            String $org_scalatest_assert_macro_right4 = "value1";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(sc.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_GROUP_ID()));
            String $org_scalatest_assert_macro_right5 = "non-streaming";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(sc.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION()));
            String $org_scalatest_assert_macro_right6 = "non-streaming";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(sc.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_INTERRUPT_ON_CANCEL()));
            String $org_scalatest_assert_macro_right7 = "true";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(sc.getLocalProperty("customPropKey"));
            String $org_scalatest_assert_macro_right8 = "value2";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test("start multiple times", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            this.addInputStream(this.ssc()).register();
            this.ssc().start();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.ACTIVE;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
            this.ssc().start();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right2 = StreamingContextState.ACTIVE;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("stop multiple times", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            this.addInputStream(this.ssc()).register();
            this.ssc().start();
            StreamingContext qual$3 = this.ssc();
            boolean x$4 = qual$3.stop$default$1();
            qual$3.stop(x$4);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            StreamingContext qual$4 = this.ssc();
            boolean x$5 = qual$4.stop$default$1();
            qual$4.stop(x$5);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right2 = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("stop before start", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            this.addInputStream(this.ssc()).register();
            StreamingContext qual$5 = this.ssc();
            boolean x$6 = qual$5.stop$default$1();
            qual$5.stop(x$6);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        this.test("start after stop", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            this.addInputStream(this.ssc()).register();
            StreamingContext qual$6 = this.ssc();
            boolean x$7 = qual$6.stop$default$1();
            qual$6.stop(x$7);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.ssc().start(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        this.test("stop only streaming context", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            this.ssc_$eq(new StreamingContext(conf, this.batchDuration()));
            SparkContext sc = this.ssc().sparkContext();
            this.addInputStream(this.ssc()).register();
            this.ssc().start();
            this.ssc().stop(false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            SparkContext qual$7 = sc;
            Range.Inclusive x$8 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100);
            int x$9 = qual$7.makeRDD$default$2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])qual$7.makeRDD((Seq)x$8, x$9, ClassTag$.MODULE$.Int()).collect())).size()));
            int $org_scalatest_assert_macro_right2 = 100;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            sc.stop();
            conf.set("spark.streaming.stopSparkContextByDefault", "false");
            this.ssc_$eq(new StreamingContext(conf, this.batchDuration()));
            sc = this.ssc().sparkContext();
            this.addInputStream(this.ssc()).register();
            this.ssc().start();
            StreamingContext qual$8 = this.ssc();
            boolean x$10 = qual$8.stop$default$1();
            qual$8.stop(x$10);
            SparkContext qual$9 = sc;
            Range.Inclusive x$11 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100);
            int x$12 = qual$9.makeRDD$default$2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])qual$9.makeRDD((Seq)x$11, x$12, ClassTag$.MODULE$.Int()).collect())).size()));
            int $org_scalatest_assert_macro_right3 = 100;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            sc.stop();
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        this.test("stop(stopSparkContext=true) after stop(stopSparkContext=false)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            this.addInputStream(this.ssc()).register();
            this.ssc().stop(false);
            SparkContext qual$10 = this.ssc().sc();
            Range.Inclusive x$13 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100);
            int x$14 = qual$10.makeRDD$default$2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])qual$10.makeRDD((Seq)x$13, x$14, ClassTag$.MODULE$.Int()).collect())).size()));
            int $org_scalatest_assert_macro_right = 100;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
            this.ssc().stop(true);
            return (Exception)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                SparkContext qual$11 = this.ssc().sc();
                Range.Inclusive x$15 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100);
                int x$16 = qual$11.makeRDD$default$2();
                return (int[])qual$11.makeRDD((Seq)x$15, x$16, ClassTag$.MODULE$.Int()).collect();
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
        this.test("stop gracefully", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            conf.set("spark.dummyTimeConfig", "3600s");
            SparkContext sc = new SparkContext(conf);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> "==================================\n\n\n");
                this.ssc_$eq(new StreamingContext(sc, Milliseconds$.MODULE$.apply(100L)));
                VolatileIntRef runningCount = VolatileIntRef.create((int)0);
                TestReceiver$.MODULE$.counter().set(1);
                ReceiverInputDStream input = this.ssc().receiverStream((Receiver)new TestReceiver(), ClassTag$.MODULE$.Int());
                input.count().foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
                    StreamingContextSuite.$anonfun$new$35(this, runningCount, rdd);
                    return BoxedUnit.UNIT;
                });
                this.ssc().start();
                Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).millis()), (Function0 & Serializable & scala.Serializable)() -> {
                    int $org_scalatest_assert_macro_left = runningCount$1.elem;
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
                }, Retrying$.MODULE$.retryingNatureOfT(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
                this.ssc().stop(false, true);
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Running count = ").append(runningCount$1.elem).toString());
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("TestReceiver.counter = ").append(TestReceiver$.MODULE$.counter().get()).toString());
                int $org_scalatest_assert_macro_left = TestReceiver$.MODULE$.counter().get();
                int $org_scalatest_assert_macro_right = runningCount.elem + 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(41).append("Received records = ").append(TestReceiver$.MODULE$.counter().get()).append(", ").append("processed records = ").append(runningCount.elem).toString(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
                Thread.sleep(100L);
            });
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        this.test("stop gracefully even if a receiver misses StopReceiver", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            SparkContext sc = new SparkContext(conf);
            this.ssc_$eq(new StreamingContext(sc, Milliseconds$.MODULE$.apply(100L)));
            ReceiverInputDStream input = this.ssc().receiverStream((Receiver)new TestReceiver(), ClassTag$.MODULE$.Int());
            input.foreachRDD((Function1 & Serializable & scala.Serializable)x$1 -> {
                StreamingContextSuite.$anonfun$new$41(x$1);
                return BoxedUnit.UNIT;
            });
            this.ssc().start();
            this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.ssc().stop(true, true), this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338), (Timed)Timed$.MODULE$.timed());
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        this.test("stop slow receiver gracefully", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            conf.set("spark.streaming.gracefulStopTimeout", "20000s");
            SparkContext sc = new SparkContext(conf);
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> "==================================\n\n\n");
            this.ssc_$eq(new StreamingContext(sc, Milliseconds$.MODULE$.apply(100L)));
            IntRef runningCount = IntRef.create((int)0);
            int totalNumRecords = 15;
            int recordsPerSecond = 1;
            ReceiverInputDStream input = this.ssc().receiverStream((Receiver)new SlowTestReceiver(totalNumRecords, recordsPerSecond), ClassTag$.MODULE$.Int());
            input.count().foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
                StreamingContextSuite.$anonfun$new$45(this, runningCount, rdd);
                return BoxedUnit.UNIT;
            });
            this.ssc().start();
            this.ssc().awaitTerminationOrTimeout(500L);
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).millis()), (Function0 & Serializable & scala.Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(SlowTestReceiver$.MODULE$.initialized(), "SlowTestReceiver.initialized", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            this.ssc().stop(false, true);
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Running count = ").append(runningCount$2.elem).toString());
            int $org_scalatest_assert_macro_left = runningCount.elem;
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            int $org_scalatest_assert_macro_left2 = runningCount.elem;
            int $org_scalatest_assert_macro_right2 = totalNumRecords;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
            Thread.sleep(100L);
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
        this.test("registering and de-registering of streamingSource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            this.ssc_$eq(new StreamingContext(conf, this.batchDuration()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.INITIALIZED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
            this.addInputStream(this.ssc()).register();
            this.ssc().start();
            ArrayBuffer<Source> sources = StreamingContextSuite$.MODULE$.org$apache$spark$streaming$StreamingContextSuite$$getSources(this.ssc().env().metricsSystem());
            StreamingSource streamingSource = StreamingContextSuite$.MODULE$.org$apache$spark$streaming$StreamingContextSuite$$getStreamingSource(this.ssc());
            ArrayBuffer<Source> $org_scalatest_assert_macro_left2 = sources;
            StreamingSource $org_scalatest_assert_macro_right2 = streamingSource;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right3 = StreamingContextState.ACTIVE;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            StreamingContext qual$12 = this.ssc();
            boolean x$17 = qual$12.stop$default$1();
            qual$12.stop(x$17);
            ArrayBuffer<Source> sourcesAfterStop = StreamingContextSuite$.MODULE$.org$apache$spark$streaming$StreamingContextSuite$$getSources(this.ssc().env().metricsSystem());
            StreamingSource streamingSourceAfterStop = StreamingContextSuite$.MODULE$.org$apache$spark$streaming$StreamingContextSuite$$getStreamingSource(this.ssc());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right4 = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
            ArrayBuffer<Source> $org_scalatest_assert_macro_left5 = sourcesAfterStop;
            StreamingSource $org_scalatest_assert_macro_right5 = streamingSourceAfterStop;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        this.test("SPARK-28709 registering and de-registering of progressListener", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            conf.set(UI$.MODULE$.UI_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.ssc_$eq(new StreamingContext(conf, this.batchDuration()));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.ssc().sc().ui().isDefined(), "StreamingContextSuite.this.ssc.sc.ui.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Spark UI is not started!", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
            SparkUI sparkUI = (SparkUI)this.ssc().sc().ui().get();
            this.addInputStream(this.ssc()).register();
            this.ssc().start();
            List $org_scalatest_assert_macro_left = this.ssc().scheduler().listenerBus().listeners();
            StreamingJobProgressListener $org_scalatest_assert_macro_right = this.ssc().progressListener();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
            List $org_scalatest_assert_macro_left2 = this.ssc().sc().listenerBus().listeners();
            StreamingJobProgressListener $org_scalatest_assert_macro_right2 = this.ssc().progressListener();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
            SparkListener $org_scalatest_assert_macro_left3 = (SparkListener)sparkUI.getStreamingJobProgressListener().get();
            StreamingJobProgressListener $org_scalatest_assert_macro_right3 = this.ssc().progressListener();
            SparkListener sparkListener = $org_scalatest_assert_macro_left3;
            StreamingJobProgressListener streamingJobProgressListener = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(sparkListener != null ? !sparkListener.equals(streamingJobProgressListener) : streamingJobProgressListener != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
            StreamingContext qual$13 = this.ssc();
            boolean x$18 = qual$13.stop$default$1();
            qual$13.stop(x$18);
            List $org_scalatest_assert_macro_left4 = this.ssc().scheduler().listenerBus().listeners();
            StreamingJobProgressListener $org_scalatest_assert_macro_right4 = this.ssc().progressListener();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
            List $org_scalatest_assert_macro_left5 = this.ssc().sc().listenerBus().listeners();
            StreamingJobProgressListener $org_scalatest_assert_macro_right5 = this.ssc().progressListener();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            Option $org_scalatest_assert_macro_left6 = sparkUI.getStreamingJobProgressListener();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
        this.test("awaitTermination", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Exception exception;
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            DStream<Object> inputStream = this.addInputStream(this.ssc());
            inputStream.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x, ClassTag$.MODULE$.Int()).register();
            this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(2).seconds(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.ssc().start(), this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419), (Timed)Timed$.MODULE$.timed());
            this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).second(), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.ssc().awaitTerminationOrTimeout(500L), this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424), (Timed)Timed$.MODULE$.timed());
            Exception $org_scalatest_assert_macro_left = exception = (Exception)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Nothing$)this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).second(), (Function0 & Serializable & scala.Serializable)() -> {
                this.ssc().awaitTermination();
                throw new Exception("Did not wait for stop");
            }, this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430), Timed$.MODULE$.timed()), ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.scalatest.exceptions.TestFailedDueToTimeoutException", $org_scalatest_assert_macro_left instanceof TestFailedDueToTimeoutException, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Did not wait for stop", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
            ObjectRef t = ObjectRef.create(null);
            this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                t$1.elem = new Thread(this){
                    private final /* synthetic */ StreamingContextSuite $outer;

                    public void run() {
                        Thread.sleep(500L);
                        StreamingContext qual$1 = this.$outer.ssc();
                        boolean x$1 = qual$1.stop$default$1();
                        qual$1.stop(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                ((Thread)t$1.elem).start();
                this.ssc().awaitTermination();
            }, this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439), (Timed)Timed$.MODULE$.timed());
            ((Thread)t.elem).join();
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
        this.test("awaitTermination after stop", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            DStream<Object> inputStream = this.addInputStream(this.ssc());
            inputStream.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x, ClassTag$.MODULE$.Int()).register();
            this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.ssc().start();
                StreamingContext qual$14 = this.ssc();
                boolean x$19 = qual$14.stop$default$1();
                qual$14.stop(x$19);
                this.ssc().awaitTermination();
            }, this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460), (Timed)Timed$.MODULE$.timed());
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455));
        this.test("awaitTermination with error in task", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            DStream<Object> inputStream = this.addInputStream(this.ssc());
            inputStream.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> {
                throw new TestException("error in map task");
            }, ClassTag$.MODULE$.Int()).foreachRDD((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.count();
                return BoxedUnit.UNIT;
            });
            Exception exception = (Exception)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                this.ssc().start();
                return this.ssc().awaitTerminationOrTimeout(5000L);
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "map task";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Expected exception not thrown", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 467));
        this.test("awaitTermination with error in job generation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            DStream<Object> inputStream = this.addInputStream(this.ssc());
            inputStream.transform((Function1 & Serializable & scala.Serializable)rdd -> {
                throw new TestException("error in transform");
            }, ClassTag$.MODULE$.Int()).register();
            TestException exception = (TestException)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                this.ssc().start();
                return this.ssc().awaitTerminationOrTimeout(5000L);
            }, ClassTag$.MODULE$.apply(TestException.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "transform";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Expected exception not thrown", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
        this.test("awaitTerminationOrTimeout", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            DStream<Object> inputStream = this.addInputStream(this.ssc());
            inputStream.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x, ClassTag$.MODULE$.Int()).register();
            this.ssc().start();
            this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).second(), (Function0 & Serializable & scala.Serializable)() -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.ssc().awaitTerminationOrTimeout(500L)));
                boolean $org_scalatest_assert_macro_right = false;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
            }, this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500), Timed$.MODULE$.timed());
            ObjectRef t = ObjectRef.create(null);
            this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds(), (Function0 & Serializable & scala.Serializable)() -> {
                t$2.elem = new Thread(this){
                    private final /* synthetic */ StreamingContextSuite $outer;

                    public void run() {
                        Thread.sleep(500L);
                        StreamingContext qual$1 = this.$outer.ssc();
                        boolean x$1 = qual$1.stop$default$1();
                        qual$1.stop(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                ((Thread)t$2.elem).start();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.ssc().awaitTerminationOrTimeout(10000L), "StreamingContextSuite.this.ssc.awaitTerminationOrTimeout(10000L)", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
            }, this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506), Timed$.MODULE$.timed());
            ((Thread)t.elem).join();
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
        this.test("getOrCreate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            BooleanRef newContextCreated = BooleanRef.create((boolean)false);
            String emptyPath = Utils$.MODULE$.createTempDir().getAbsolutePath();
            this.testGetOrCreate$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(emptyPath, (Function0 & Serializable & scala.Serializable)() -> this.creatingFunction$1(newContextCreated, conf), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4()));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var7_6 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var7_6 != null : !streamingContext.equals(var7_6), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(newContextCreated$1.elem, "newContextCreated", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"new context not created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
            }, newContextCreated);
            String corruptedCheckpointPath = this.createCorruptedCheckpoint();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(corruptedCheckpointPath, (Function0 & Serializable & scala.Serializable)() -> this.creatingFunction$1(newContextCreated, conf), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4())), ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String x$20 = corruptedCheckpointPath;
                Function0 & Serializable & scala.Serializable x$21 = (Function0 & Serializable & scala.Serializable)() -> this.creatingFunction$1(newContextCreated, conf);
                boolean x$22 = false;
                Configuration x$23 = StreamingContext$.MODULE$.getOrCreate$default$3();
                this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(x$20, (Function0)x$21, x$23, x$22));
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
            this.testGetOrCreate$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String x$24 = corruptedCheckpointPath;
                Function0 & Serializable & scala.Serializable x$25 = (Function0 & Serializable & scala.Serializable)() -> this.creatingFunction$1(newContextCreated, conf);
                boolean x$26 = true;
                Configuration x$27 = StreamingContext$.MODULE$.getOrCreate$default$3();
                this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(x$24, (Function0)x$25, x$27, x$26));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var11_10 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var11_10 != null : !streamingContext.equals(var11_10), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(newContextCreated$1.elem, "newContextCreated", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"new context not created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
            }, newContextCreated);
            String checkpointPath = this.createValidCheckpoint();
            this.testGetOrCreate$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(checkpointPath, (Function0 & Serializable & scala.Serializable)() -> this.creatingFunction$1(newContextCreated, conf), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4()));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var7_6 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var7_6 != null : !streamingContext.equals(var7_6), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(newContextCreated$1.elem, "newContextCreated", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"old context not recovered", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 581));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.ssc().conf().get("someKey"));
                String $org_scalatest_assert_macro_right2 = "someValue";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"checkpointed config not recovered", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 582));
            }, newContextCreated);
            this.testGetOrCreate$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SparkContext sc = new SparkContext(conf);
                this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(checkpointPath, (Function0 & Serializable & scala.Serializable)() -> this.creatingFunction$1(newContextCreated, conf), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4()));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var8_7 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var8_7 != null : !streamingContext.equals(var8_7), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(newContextCreated$1.elem, "newContextCreated", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"old context not recovered", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
                SparkConf $org_scalatest_assert_macro_left2 = this.ssc().conf();
                String $org_scalatest_assert_macro_right2 = "someKey";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"checkpointed config unexpectedly recovered", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
            }, newContextCreated);
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
        this.test("getActive and getActiveOrCreate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(StreamingContext$.MODULE$.getActive().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "context exists from before");
            BooleanRef newContextCreated = BooleanRef.create((boolean)false);
            this.testGetActiveOrCreate$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SparkContext sc = new SparkContext(this.conf());
                this.ssc_$eq(StreamingContext$.MODULE$.getActiveOrCreate((Function0 & Serializable & scala.Serializable)() -> this.creatingFunc$1(sc, newContextCreated)));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var6_5 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var6_5 != null : !streamingContext.equals(var6_5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(newContextCreated$2.elem, "newContextCreated", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"new context not created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626));
                Option $org_scalatest_assert_macro_left2 = StreamingContext$.MODULE$.getActive();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"new initialized context returned before starting", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 627));
                this.ssc().start();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(StreamingContext$.MODULE$.getActive());
                Some $org_scalatest_assert_macro_right2 = new Some((Object)this.ssc());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"active context not returned", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(StreamingContext$.MODULE$.getActiveOrCreate((Function0 & Serializable & scala.Serializable)() -> this.creatingFunc$1(sc, newContextCreated)));
                StreamingContext $org_scalatest_assert_macro_right3 = this.ssc();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"active context not returned", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
                StreamingContext qual$15 = this.ssc();
                boolean x$28 = qual$15.stop$default$1();
                qual$15.stop(x$28);
                Option $org_scalatest_assert_macro_left5 = StreamingContext$.MODULE$.getActive();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"inactive context returned", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(StreamingContext$.MODULE$.getActiveOrCreate((Function0 & Serializable & scala.Serializable)() -> this.creatingFunc$1(sc, newContextCreated)));
                StreamingContext $org_scalatest_assert_macro_right4 = this.ssc();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "!==", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left6.$bang$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"inactive context returned", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
            }, newContextCreated);
            this.testGetActiveOrCreate$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SparkContext sc = new SparkContext(this.conf());
                this.ssc_$eq(this.creatingFunc$1(sc, newContextCreated));
                Option $org_scalatest_assert_macro_left = StreamingContext$.MODULE$.getActive();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"new initialized context returned before starting", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
                this.ssc().start();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(StreamingContext$.MODULE$.getActive());
                Some $org_scalatest_assert_macro_right = new Some((Object)this.ssc());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"active context not returned", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(StreamingContext$.MODULE$.getActiveOrCreate((Function0 & Serializable & scala.Serializable)() -> this.creatingFunc$1(sc, newContextCreated)));
                StreamingContext $org_scalatest_assert_macro_right2 = this.ssc();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"active context not returned", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
                StreamingContext qual$16 = this.ssc();
                boolean x$29 = qual$16.stop$default$1();
                qual$16.stop(x$29);
                Option $org_scalatest_assert_macro_left4 = StreamingContext$.MODULE$.getActive();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"inactive context returned", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
            }, newContextCreated);
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
        this.test("getActiveOrCreate with checkpoint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BooleanRef newContextCreated = BooleanRef.create((boolean)false);
            String emptyPath = Utils$.MODULE$.createTempDir().getAbsolutePath();
            String corruptedCheckpointPath = this.createCorruptedCheckpoint();
            String checkpointPath = this.createValidCheckpoint();
            this.testGetActiveOrCreate$2((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.ssc_$eq(new StreamingContext(this.conf().clone().set("spark.streaming.clock", "org.apache.spark.util.ManualClock"), this.batchDuration()));
                this.addInputStream(this.ssc()).register();
                this.ssc().start();
                StreamingContext returnedSsc = StreamingContext$.MODULE$.getActiveOrCreate(checkpointPath, (Function0 & Serializable & scala.Serializable)() -> this.creatingFunction$2(newContextCreated), StreamingContext$.MODULE$.getActiveOrCreate$default$3(), StreamingContext$.MODULE$.getActiveOrCreate$default$4());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(newContextCreated$3.elem, "newContextCreated", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"new context created instead of returning", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
                StreamingContext $org_scalatest_assert_macro_left = returnedSsc;
                StreamingContext $org_scalatest_assert_macro_right = this.ssc();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "eq", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"returned context is not the activated context", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
            }, newContextCreated);
            this.testGetActiveOrCreate$2((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.ssc_$eq(StreamingContext$.MODULE$.getActiveOrCreate(emptyPath, (Function0 & Serializable & scala.Serializable)() -> this.creatingFunction$2(newContextCreated), StreamingContext$.MODULE$.getActiveOrCreate$default$3(), StreamingContext$.MODULE$.getActiveOrCreate$default$4()));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var6_5 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var6_5 != null : !streamingContext.equals(var6_5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 698));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(newContextCreated$3.elem, "newContextCreated", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"new context not created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
            }, newContextCreated);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(corruptedCheckpointPath, (Function0 & Serializable & scala.Serializable)() -> this.creatingFunction$2(newContextCreated), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4())), ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String x$30 = corruptedCheckpointPath;
                Function0 & Serializable & scala.Serializable x$31 = (Function0 & Serializable & scala.Serializable)() -> this.creatingFunction$2(newContextCreated);
                boolean x$32 = false;
                Configuration x$33 = StreamingContext$.MODULE$.getActiveOrCreate$default$3();
                this.ssc_$eq(StreamingContext$.MODULE$.getActiveOrCreate(x$30, (Function0)x$31, x$33, x$32));
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708));
            this.testGetActiveOrCreate$2((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String x$34 = corruptedCheckpointPath;
                Function0 & Serializable & scala.Serializable x$35 = (Function0 & Serializable & scala.Serializable)() -> this.creatingFunction$2(newContextCreated);
                boolean x$36 = true;
                Configuration x$37 = StreamingContext$.MODULE$.getActiveOrCreate$default$3();
                this.ssc_$eq(StreamingContext$.MODULE$.getActiveOrCreate(x$34, (Function0)x$35, x$37, x$36));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var10_9 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var10_9 != null : !streamingContext.equals(var10_9), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 718));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(newContextCreated$3.elem, "newContextCreated", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"new context not created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 719));
            }, newContextCreated);
            this.testGetActiveOrCreate$2((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.ssc_$eq(StreamingContext$.MODULE$.getActiveOrCreate(checkpointPath, (Function0 & Serializable & scala.Serializable)() -> this.creatingFunction$2(newContextCreated), StreamingContext$.MODULE$.getActiveOrCreate$default$3(), StreamingContext$.MODULE$.getActiveOrCreate$default$4()));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var6_5 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var6_5 != null : !streamingContext.equals(var6_5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(newContextCreated$3.elem, "newContextCreated", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"old context not recovered", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.ssc().conf().get("someKey"));
                String $org_scalatest_assert_macro_right2 = "someValue";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
            }, newContextCreated);
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 658));
        this.test("multiple streaming contexts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkContext sc = new SparkContext(this.conf().clone().set("spark.streaming.clock", "org.apache.spark.util.ManualClock"));
            this.ssc_$eq(new StreamingContext(sc, Seconds$.MODULE$.apply(1L)));
            DStream<Object> input = this.addInputStream(this.ssc());
            input.foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
                rdd.count();
                return BoxedUnit.UNIT;
            });
            this.ssc().start();
            StreamingContext anotherSsc = new StreamingContext(sc, Seconds$.MODULE$.apply(10L));
            DStream<Object> anotherInput = this.addInputStream(anotherSsc);
            anotherInput.foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
                rdd.count();
                return BoxedUnit.UNIT;
            });
            IllegalStateException exception = (IllegalStateException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> anotherSsc.start(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "StreamingContext";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Did not get the right exception", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
        this.test("DStream and generated RDD creation sites", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> testPackage$.MODULE$.test(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 750));
        this.test("throw exception on using active or stopped context", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName()).set("spark.streaming.clock", "org.apache.spark.util.ManualClock");
            this.ssc_$eq(new StreamingContext(conf, this.batchDuration()));
            Predef$.MODULE$.require(this.convertToEqualizer(this.ssc().getState()).$eq$eq$eq((Object)StreamingContextState.INITIALIZED, Equality$.MODULE$.default()));
            DStream<Object> input = this.addInputStream(this.ssc());
            DStream transformed = input.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x, ClassTag$.MODULE$.Int());
            transformed.foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
                rdd.count();
                return BoxedUnit.UNIT;
            });
            this.ssc().start();
            Predef$.MODULE$.require(this.convertToEqualizer(this.ssc().getState()).$eq$eq$eq((Object)StreamingContextState.ACTIVE, Equality$.MODULE$.default()));
            this.testForException$1("no error on adding input after start", "start", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.addInputStream(this.ssc()));
            this.testForException$1("no error on adding transformation after start", "start", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> input.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x * 2, ClassTag$.MODULE$.Int()));
            this.testForException$1("no error on adding output operation after start", "start", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> transformed.foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
                rdd.collect();
                return BoxedUnit.UNIT;
            }));
            StreamingContext qual$17 = this.ssc();
            boolean x$38 = qual$17.stop$default$1();
            qual$17.stop(x$38);
            Predef$.MODULE$.require(this.convertToEqualizer(this.ssc().getState()).$eq$eq$eq((Object)StreamingContextState.STOPPED, Equality$.MODULE$.default()));
            this.testForException$1("no error on adding input after stop", "stop", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.addInputStream(this.ssc()));
            this.testForException$1("no error on adding transformation after stop", "stop", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> input.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x * 2, ClassTag$.MODULE$.Int()));
            this.testForException$1("no error on adding output operation after stop", "stop", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> transformed.foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
                rdd.collect();
                return BoxedUnit.UNIT;
            }));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
        this.test("queueStream doesn't support checkpointing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String checkpointDirectory = Utils$.MODULE$.createTempDir().getAbsolutePath();
            this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(checkpointDirectory, (Function0 & Serializable & scala.Serializable)() -> this.creatingFunction$3(checkpointDirectory), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4()));
            this.ssc().start();
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), (Function0 & Serializable & scala.Serializable)() -> {
                int $org_scalatest_assert_macro_left = Checkpoint$.MODULE$.getCheckpointFiles(checkpointDirectory, Checkpoint$.MODULE$.getCheckpointFiles$default$2()).size();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 805));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 804));
            StreamingContext qual$18 = this.ssc();
            boolean x$39 = qual$18.stop$default$1();
            qual$18.stop(x$39);
            SparkException e = (SparkException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(checkpointDirectory, (Function0 & Serializable & scala.Serializable)() -> this.creatingFunction$3(checkpointDirectory), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4())), ClassTag$.MODULE$.apply(SparkException.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 808));
            String $org_scalatest_assert_macro_left = e.getCause().getMessage();
            String $org_scalatest_assert_macro_right = "queueStream doesn't support checkpointing. Please don't use queueStream when checkpointing is enabled.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 793));
        this.test("Creating an InputDStream but not using it should not crash", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            DStream<Object> input1 = this.addInputStream(this.ssc());
            DStream<Object> input2 = this.addInputStream(this.ssc());
            TestOutputStream<Object> output = new TestOutputStream<Object>(input2, TestOutputStream$.MODULE$.$lessinit$greater$default$2(), ClassTag$.MODULE$.Int());
            output.register();
            BatchCounter batchCount = new BatchCounter(this.ssc());
            this.ssc().start();
            batchCount.waitUntilBatchesCompleted(2, 10000L);
            this.ssc().awaitTerminationOrTimeout(1L);
            StreamingContext qual$19 = this.ssc();
            boolean x$40 = qual$19.stop$default$1();
            qual$19.stop(x$40);
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
        this.test("SPARK-18560 Receiver data should be deserialized properly.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local-cluster[2,1,1024]").setAppName(this.appName());
            this.ssc_$eq(new StreamingContext(conf, Milliseconds$.MODULE$.apply(100L)));
            ReceiverInputDStream input = this.ssc().receiverStream((Receiver)new TestReceiver(), ClassTag$.MODULE$.Int());
            CountDownLatch latch = new CountDownLatch(1);
            VolatileBooleanRef stopping = VolatileBooleanRef.create((boolean)false);
            input.count().foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
                StreamingContextSuite.$anonfun$new$133(this, stopping, latch, rdd);
                return BoxedUnit.UNIT;
            });
            this.ssc().start();
            this.ssc().awaitTerminationOrTimeout(60000L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(latch.await(60L, TimeUnit.SECONDS), "latch.await(60L, SECONDS)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 859));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 832));
        this.test("SPARK-22955 graceful shutdown shouldn't lead to job generation error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            conf.set("spark.streaming.clock", ManualClock.class.getName());
            conf.set("spark.streaming.gracefulStopTimeout", "60s");
            this.ssc_$eq(new StreamingContext(conf, Milliseconds$.MODULE$.apply(100L)));
            new InputDStream<Object>(this){
                private volatile boolean stopped;

                private boolean stopped() {
                    return this.stopped;
                }

                private void stopped_$eq(boolean x$1) {
                    this.stopped = x$1;
                }

                public void start() {
                }

                public void stop() {
                    this.stopped_$eq(true);
                }

                public Option<RDD<Object>> compute(Time validTime) {
                    if (this.stopped()) {
                        throw new IllegalStateException("Already stopped");
                    }
                    return new Some((Object)this.ssc().sc().emptyRDD(ClassTag$.MODULE$.Int()));
                }
                {
                    this.stopped = false;
                }
            }.register();
            this.ssc().start();
            ((ManualClock)this.ssc().scheduler().clock()).setTime(Long.MAX_VALUE);
            this.ssc().stop(true, true);
            this.ssc().awaitTermination();
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 862));
    }
}

