/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.streaming.util.BatchedWriteAheadLog;
import org.apache.spark.streaming.util.FileBasedWriteAheadLog;
import org.apache.spark.streaming.util.WriteAheadLog;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u000f\u001f\u0001%BQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013%1\u0007\u0003\u0004=\u0001\u0001\u0006I\u0001\u000e\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u00199\u0005\u0001)A\u0005\u007f!)\u0001\n\u0001C\u0001\u0013\"91\u000eAI\u0001\n\u0003a\u0007\"B=\u0001\t\u0003QxaBA\u0004=!\u0005\u0011\u0011\u0002\u0004\u0007;yA\t!a\u0003\t\r9RA\u0011AA\r\r\u0019\tYB\u0003\u0001\u0002\u001e!1a\u0006\u0004C\u0001\u0003?Aq!!\n\r\t\u0003\n9\u0003C\u0004\u0002J1!\t%a\u0013\t\u000f\u0005EC\u0002\"\u0011\u0002T!9\u0011q\f\u0007\u0005B\u0005\u0005\u0004bBA9\u0019\u0011\u0005\u00131\u000f\u0004\u0007\u0003kR\u0001!a\u001e\t\u0013\t\u001b\"Q1A\u0005\u0002\u0005e\u0004\"CA>'\t\u0005\t\u0015!\u0003d\u0011\u0019q3\u0003\"\u0001\u0002~\u00191\u00111\u0011\u0006\u0001\u0003\u000bC\u0011BQ\f\u0003\u0006\u0004%\t!!\u001f\t\u0013\u0005mtC!A!\u0002\u0013\u0019\u0007BCAD/\t\u0005\t\u0015!\u0003\u0002\n\"1af\u0006C\u0001\u0003\u001fC\u0011\"a&\u000b\u0003\u0003%I!!'\u0003/]\u0013\u0018\u000e^3BQ\u0016\fG\rT8h+RLGn]*vSR,'BA\u0010!\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u0012\u0013!C:ue\u0016\fW.\u001b8h\u0015\t\u0019C%A\u0003ta\u0006\u00148N\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<7\u0001A\n\u0003\u0001)\u0002\"a\u000b\u0017\u000e\u0003\tJ!!\f\u0012\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0007\u0005\u00022\u00015\ta$\u0001\u0004m_\u001e$\u0015N]\u000b\u0002iA\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0005Y\u0006twMC\u0001:\u0003\u0011Q\u0017M^1\n\u0005m2$AB*ue&tw-A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u0015!\fGm\\8q\u0007>tg-F\u0001@!\t\u0001U)D\u0001B\u0015\t\u00115)\u0001\u0003d_:4'B\u0001#%\u0003\u0019A\u0017\rZ8pa&\u0011a)\u0011\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0017!\fGm\\8q\u0007>tg\rI\u0001\u0015CN\u001cXM\u001d;Ee&4XM\u001d'pO\u000ec\u0017m]:\u0016\u0005)[FcA&cMR\u0011Aj\u0014\t\u0003c5K!A\u0014\u0010\u0003\u001b]\u0013\u0018\u000e^3BQ\u0016\fG\rT8h\u0011\u001d\u0001f!!AA\u0004E\u000b!\"\u001a<jI\u0016t7-\u001a\u00132!\r\u0011v+W\u0007\u0002'*\u0011A+V\u0001\be\u00164G.Z2u\u0015\u00051\u0016!B:dC2\f\u0017B\u0001-T\u0005!\u0019E.Y:t)\u0006<\u0007C\u0001.\\\u0019\u0001!Q\u0001\u0018\u0004C\u0002u\u0013\u0011\u0001V\t\u0003=2\u0003\"a\u00181\u000e\u0003UK!!Y+\u0003\u000f9{G\u000f[5oO\")!I\u0002a\u0001GB\u00111\u0006Z\u0005\u0003K\n\u0012\u0011b\u00159be.\u001cuN\u001c4\t\u000f\u001d4\u0001\u0013!a\u0001Q\u0006I\u0011n\u001d\"bi\u000eDW\r\u001a\t\u0003?&L!A[+\u0003\u000f\t{w\u000e\\3b]\u0006q\u0012m]:feR$%/\u001b<fe2{wm\u00117bgN$C-\u001a4bk2$HEM\u000b\u0003[b,\u0012A\u001c\u0016\u0003Q>\\\u0013\u0001\u001d\t\u0003cZl\u0011A\u001d\u0006\u0003gR\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005U,\u0016AC1o]>$\u0018\r^5p]&\u0011qO\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!\u0002/\b\u0005\u0004i\u0016AF1tg\u0016\u0014HOU3dK&4XM\u001d'pO\u000ec\u0017m]:\u0016\u0007m\f\u0019\u0001F\u0002}\u0003\u000b!\"\u0001T?\t\u000fyD\u0011\u0011!a\u0002\u007f\u0006QQM^5eK:\u001cW\r\n\u001a\u0011\tI;\u0016\u0011\u0001\t\u00045\u0006\rA!\u0002/\t\u0005\u0004i\u0006\"\u0002\"\t\u0001\u0004\u0019\u0017aF,sSR,\u0017\t[3bI2{w-\u0016;jYN\u001cV/\u001b;f!\t\t$bE\u0003\u000b\u0003\u001b\t\u0019\u0002E\u0002`\u0003\u001fI1!!\u0005V\u0005\u0019\te.\u001f*fMB\u0019q,!\u0006\n\u0007\u0005]QK\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002\n\t\u0011Rj\\2l/JLG/Z!iK\u0006$Gj\\41'\taA\n\u0006\u0002\u0002\"A\u0019\u00111\u0005\u0007\u000e\u0003)\tQa\u001e:ji\u0016$b!!\u000b\u00020\u0005}\u0002cA\u0019\u0002,%\u0019\u0011Q\u0006\u0010\u00033]\u0013\u0018\u000e^3BQ\u0016\fG\rT8h%\u0016\u001cwN\u001d3IC:$G.\u001a\u0005\b\u0003cq\u0001\u0019AA\u001a\u0003\u0019\u0011XmY8sIB!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:a\n1A\\5p\u0013\u0011\ti$a\u000e\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0004\u0002B9\u0001\r!a\u0011\u0002\tQLW.\u001a\t\u0004?\u0006\u0015\u0013bAA$+\n!Aj\u001c8h\u0003\u0011\u0011X-\u00193\u0015\t\u0005M\u0012Q\n\u0005\b\u0003\u001fz\u0001\u0019AA\u0015\u0003\u0019A\u0017M\u001c3mK\u00069!/Z1e\u00032dGCAA+!\u0019\t9&a\u0017\u000245\u0011\u0011\u0011\f\u0006\u0003?aJA!!\u0018\u0002Z\tA\u0011\n^3sCR|'/A\u0003dY\u0016\fg\u000e\u0006\u0004\u0002d\u0005%\u0014Q\u000e\t\u0004?\u0006\u0015\u0014bAA4+\n!QK\\5u\u0011\u001d\tY'\u0005a\u0001\u0003\u0007\n!\u0002\u001e5sKNDG+[7f\u0011\u0019\ty'\u0005a\u0001Q\u0006\tr/Y5u\r>\u00148i\\7qY\u0016$\u0018n\u001c8\u0002\u000b\rdwn]3\u0015\u0005\u0005\r$AE'pG.<&/\u001b;f\u0003\",\u0017\r\u001a'pOF\u001a2aEA\u0011+\u0005\u0019\u0017!B2p]\u001a\u0004C\u0003BA@\u0003\u0003\u00032!a\t\u0014\u0011\u0015\u0011e\u00031\u0001d\u0005IiunY6Xe&$X-\u00115fC\u0012dun\u001a\u001a\u0014\u0007]\t\t#A\u0001y!\ry\u00161R\u0005\u0004\u0003\u001b+&aA%oiR1\u0011\u0011SAJ\u0003+\u00032!a\t\u0018\u0011\u0015\u00115\u00041\u0001d\u0011\u001d\t9i\u0007a\u0001\u0003\u0013\u000b1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0014\t\u0004k\u0005u\u0015bAAPm\t1qJ\u00196fGR\u0004")
public class WriteAheadLogUtilsSuite
extends SparkFunSuite {
    private final String logDir = Utils$.MODULE$.createTempDir().getAbsolutePath();
    private final Configuration hadoopConf = new Configuration();

    private String logDir() {
        return this.logDir;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public <T extends WriteAheadLog> WriteAheadLog assertDriverLogClass(SparkConf conf, boolean isBatched, ClassTag<T> evidence$1) {
        Assertion assertion;
        WriteAheadLog log = WriteAheadLogUtils$.MODULE$.createLogForDriver(conf, this.logDir(), this.hadoopConf());
        if (isBatched) {
            WriteAheadLog $org_scalatest_assert_macro_left = log;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.streaming.util.BatchedWriteAheadLog", $org_scalatest_assert_macro_left instanceof BatchedWriteAheadLog, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            WriteAheadLog parentLog = ((BatchedWriteAheadLog)log).wrappedLog();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(parentLog.getClass());
            Class $org_scalatest_assert_macro_right = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        } else {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(log.getClass());
            Class $org_scalatest_assert_macro_right = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        }
        return log;
    }

    public <T extends WriteAheadLog> boolean assertDriverLogClass$default$2() {
        return false;
    }

    public <T extends WriteAheadLog> WriteAheadLog assertReceiverLogClass(SparkConf conf, ClassTag<T> evidence$2) {
        WriteAheadLog log = WriteAheadLogUtils$.MODULE$.createLogForReceiver(conf, this.logDir(), this.hadoopConf());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(log.getClass());
        Class $org_scalatest_assert_macro_right = ((ClassTag)Predef$.MODULE$.implicitly(evidence$2)).runtimeClass();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        return log;
    }

    private static final SparkConf getBatchedSparkConf$1() {
        return new SparkConf().set("spark.streaming.driver.writeAheadLog.allowBatching", "true");
    }

    public WriteAheadLogUtilsSuite() {
        this.test("log selection and creation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf emptyConf = new SparkConf();
            this.assertDriverLogClass(emptyConf, true, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
            this.assertReceiverLogClass(emptyConf, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
            SparkConf driverWALConf = new SparkConf().set("spark.streaming.driver.writeAheadLog.class", MockWriteAheadLog0.class.getName());
            this.assertDriverLogClass(driverWALConf, true, ClassTag$.MODULE$.apply(MockWriteAheadLog0.class));
            this.assertReceiverLogClass(driverWALConf, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
            SparkConf receiverWALConf = new SparkConf().set("spark.streaming.receiver.writeAheadLog.class", MockWriteAheadLog0.class.getName());
            this.assertDriverLogClass(receiverWALConf, true, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
            this.assertReceiverLogClass(receiverWALConf, ClassTag$.MODULE$.apply(MockWriteAheadLog0.class));
            SparkConf receiverWALConf2 = new SparkConf().set("spark.streaming.receiver.writeAheadLog.class", MockWriteAheadLog1.class.getName());
            this.assertReceiverLogClass(receiverWALConf2, ClassTag$.MODULE$.apply(MockWriteAheadLog1.class));
            return (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                SparkConf receiverWALConf3 = new SparkConf().set("spark.streaming.receiver.writeAheadLog.class", MockWriteAheadLog2.class.getName());
                return this.assertReceiverLogClass(receiverWALConf3, ClassTag$.MODULE$.apply(MockWriteAheadLog1.class));
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("WriteAheadLogUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        }, new Position("WriteAheadLogUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("wrap WriteAheadLog in BatchedWriteAheadLog when batching is enabled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf justBatchingConf = WriteAheadLogUtilsSuite.getBatchedSparkConf$1();
            this.assertDriverLogClass(justBatchingConf, true, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
            this.assertReceiverLogClass(justBatchingConf, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
            SparkConf driverWALConf = WriteAheadLogUtilsSuite.getBatchedSparkConf$1().set("spark.streaming.driver.writeAheadLog.class", MockWriteAheadLog0.class.getName());
            this.assertDriverLogClass(driverWALConf, true, ClassTag$.MODULE$.apply(MockWriteAheadLog0.class));
            this.assertReceiverLogClass(driverWALConf, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
            SparkConf receiverWALConf = WriteAheadLogUtilsSuite.getBatchedSparkConf$1().set("spark.streaming.receiver.writeAheadLog.class", MockWriteAheadLog0.class.getName());
            this.assertDriverLogClass(receiverWALConf, true, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
            return this.assertReceiverLogClass(receiverWALConf, ClassTag$.MODULE$.apply(MockWriteAheadLog0.class));
        }, new Position("WriteAheadLogUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("batching is enabled by default in WriteAheadLog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(WriteAheadLogUtils$.MODULE$.isBatchingEnabled(conf, true), "WriteAheadLogUtils.isBatchingEnabled(conf, true)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(WriteAheadLogUtils$.MODULE$.isBatchingEnabled(conf, false), "WriteAheadLogUtils.isBatchingEnabled(conf, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        }, new Position("WriteAheadLogUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test("closeFileAfterWrite is disabled by default in WriteAheadLog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(WriteAheadLogUtils$.MODULE$.shouldCloseFileAfterWrite(conf, true), "WriteAheadLogUtils.shouldCloseFileAfterWrite(conf, true)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(WriteAheadLogUtils$.MODULE$.shouldCloseFileAfterWrite(conf, false), "WriteAheadLogUtils.shouldCloseFileAfterWrite(conf, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        }, new Position("WriteAheadLogUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
    }

    public static class MockWriteAheadLog0
    extends WriteAheadLog {
        public WriteAheadLogRecordHandle write(ByteBuffer record, long time) {
            return null;
        }

        public ByteBuffer read(WriteAheadLogRecordHandle handle) {
            return null;
        }

        public Iterator<ByteBuffer> readAll() {
            return null;
        }

        public void clean(long threshTime, boolean waitForCompletion) {
        }

        public void close() {
        }
    }

    public static class MockWriteAheadLog1
    extends MockWriteAheadLog0 {
        private final SparkConf conf;

        public SparkConf conf() {
            return this.conf;
        }

        public MockWriteAheadLog1(SparkConf conf) {
            this.conf = conf;
        }
    }

    public static class MockWriteAheadLog2
    extends MockWriteAheadLog0 {
        private final SparkConf conf;

        public SparkConf conf() {
            return this.conf;
        }

        public MockWriteAheadLog2(SparkConf conf, int x) {
            this.conf = conf;
        }
    }
}

