/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.array;

import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.ByteArray;
import org.junit.Assert;
import org.junit.Test;

public class ByteArraySuite {
    private long getPrefixByByte(byte[] bytes) {
        int minLen = Math.min(bytes.length, 8);
        long p = 0L;
        for (int i = 0; i < minLen; ++i) {
            p |= ((long)Platform.getByte((Object)bytes, (long)(Platform.BYTE_ARRAY_OFFSET + i)) & 0xFFL) << 56 - 8 * i;
        }
        return p;
    }

    @Test
    public void testGetPrefix() {
        for (int i = 0; i <= 9; ++i) {
            byte[] bytes = new byte[i];
            for (int prefix = i - 1; prefix >= 0; --prefix) {
                bytes[prefix] = (byte)prefix;
            }
            long result = ByteArray.getPrefix((byte[])bytes);
            long expected = this.getPrefixByByte(bytes);
            Assert.assertEquals((long)result, (long)expected);
        }
    }

    @Test
    public void testCompareBinary() {
        byte[] x1 = new byte[]{};
        byte[] y1 = new byte[]{1, 2, 3};
        Assert.assertTrue((ByteArray.compareBinary((byte[])x1, (byte[])y1) < 0 ? 1 : 0) != 0);
        byte[] x2 = new byte[]{-56, 100};
        byte[] y2 = new byte[]{100, 100};
        Assert.assertTrue((ByteArray.compareBinary((byte[])x2, (byte[])y2) > 0 ? 1 : 0) != 0);
        byte[] x3 = new byte[]{100, -56, 12};
        byte[] y3 = new byte[]{100, -56};
        Assert.assertTrue((ByteArray.compareBinary((byte[])x3, (byte[])y3) > 0 ? 1 : 0) != 0);
        byte[] x4 = new byte[]{100, -56};
        byte[] y4 = new byte[]{100, -56};
        Assert.assertEquals((long)0L, (long)ByteArray.compareBinary((byte[])x4, (byte[])y4));
    }
}

