/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.spark.network.shuffle.ExternalBlockHandler;
import org.apache.spark.network.shuffle.ExternalShuffleBlockResolver;
import org.apache.spark.network.shuffle.MergedShuffleFileManager;
import org.apache.spark.network.shuffle.RemoteBlockPushResolver;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.shuffle.protocol.FinalizeShuffleMerge;
import org.apache.spark.network.shuffledb.DB;
import org.apache.spark.network.shuffledb.DBBackend;
import org.apache.spark.network.util.DBProvider;
import org.apache.spark.network.util.TransportConf;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Tuple3;

public final class ShuffleTestAccessor$ {
    public static ShuffleTestAccessor$ MODULE$;

    static {
        new ShuffleTestAccessor$();
    }

    public ExternalShuffleBlockResolver getBlockResolver(ExternalBlockHandler handler) {
        return handler.blockManager;
    }

    public Option<ExecutorShuffleInfo> getExecutorInfo(ApplicationId appId, String execId, ExternalShuffleBlockResolver resolver) {
        ExternalShuffleBlockResolver.AppExecId id = new ExternalShuffleBlockResolver.AppExecId(appId.toString(), execId);
        return Option$.MODULE$.apply(resolver.executors.get(id));
    }

    public Option<RemoteBlockPushResolver.AppPathsInfo> getAppPathsInfo(String appId, RemoteBlockPushResolver mergeManager) {
        return Option$.MODULE$.apply(mergeManager.appsShuffleInfo.get(appId)).flatMap((Function1 & Serializable & scala.Serializable)v -> Option$.MODULE$.apply((Object)v.getAppPathsInfo()));
    }

    public ConcurrentMap<String, RemoteBlockPushResolver.AppShuffleInfo> getAppsShuffleInfo(RemoteBlockPushResolver mergeManager) {
        return mergeManager.appsShuffleInfo;
    }

    public File registeredExecutorFile(ExternalShuffleBlockResolver resolver) {
        return resolver.registeredExecutorFile;
    }

    public File recoveryFile(RemoteBlockPushResolver mergeManager) {
        return mergeManager.recoveryFile;
    }

    public DB shuffleServiceDB(ExternalShuffleBlockResolver resolver) {
        return resolver.db;
    }

    public DB mergeManagerLevelDB(RemoteBlockPushResolver mergeManager) {
        return mergeManager.db;
    }

    public boolean isMergedShuffleCleanerShutdown(RemoteBlockPushResolver mergeManager) {
        return mergeManager.isCleanerShutdown();
    }

    public MergedShuffleFileManager createMergeManagerWithSynchronizedCleanup(TransportConf transportConf, File file) {
        return new RemoteBlockPushResolver(transportConf, file){

            public void submitCleanupTask(Runnable task) {
                task.run();
            }
        };
    }

    public MergedShuffleFileManager createMergeManagerWithNoOpAppShuffleDBCleanup(TransportConf transportConf, File file) {
        return new RemoteBlockPushResolver(transportConf, file){

            public void removeAppShuffleInfoFromDB(RemoteBlockPushResolver.AppShuffleInfo appShuffleInfo) {
            }

            public void submitCleanupTask(Runnable task) {
                task.run();
            }
        };
    }

    public MergedShuffleFileManager createMergeManagerWithNoDBCleanup(TransportConf transportConf, File file) {
        return new RemoteBlockPushResolver(transportConf, file){

            public void removeAppAttemptPathInfoFromDB(String appId, int attemptId) {
            }

            public void removeAppShuffleInfoFromDB(RemoteBlockPushResolver.AppShuffleInfo appShuffleInfo) {
            }

            public void submitCleanupTask(Runnable task) {
                task.run();
            }
        };
    }

    public MergedShuffleFileManager createMergeManagerWithNoCleanupAfterReload(TransportConf transportConf, File file) {
        return new RemoteBlockPushResolver(transportConf, file){

            public void removeOutdatedKeyValuesInDB(List<byte[]> dbKeysToBeRemoved) {
            }
        };
    }

    public RemoteBlockPushResolver.AppShufflePartitionInfo getOrCreateAppShufflePartitionInfo(RemoteBlockPushResolver mergeManager, RemoteBlockPushResolver.AppAttemptShuffleMergeId appShufflePartitionId, int reduceId, String blockId) {
        return mergeManager.getOrCreateAppShufflePartitionInfo((RemoteBlockPushResolver.AppShuffleInfo)mergeManager.appsShuffleInfo.get(appShufflePartitionId.appId), appShufflePartitionId.shuffleId, appShufflePartitionId.shuffleMergeId, reduceId, blockId);
    }

    public void finalizeShuffleMerge(RemoteBlockPushResolver mergeManager, RemoteBlockPushResolver.AppAttemptShuffleMergeId appAttemptShuffleMergeId) {
        mergeManager.finalizeShuffleMerge(new FinalizeShuffleMerge(appAttemptShuffleMergeId.appId, appAttemptShuffleMergeId.attemptId, appAttemptShuffleMergeId.shuffleId, appAttemptShuffleMergeId.shuffleMergeId));
    }

    public File getMergedShuffleDataFile(RemoteBlockPushResolver mergeManager, RemoteBlockPushResolver.AppAttemptShuffleMergeId appShufflePartitionId, int reduceId) {
        return ((RemoteBlockPushResolver.AppShuffleInfo)mergeManager.appsShuffleInfo.get(appShufflePartitionId.appId)).getMergedShuffleDataFile(appShufflePartitionId.shuffleId, appShufflePartitionId.shuffleMergeId, reduceId);
    }

    public File getMergedShuffleIndexFile(RemoteBlockPushResolver mergeManager, RemoteBlockPushResolver.AppAttemptShuffleMergeId appShufflePartitionId, int reduceId) {
        return new File(((RemoteBlockPushResolver.AppShuffleInfo)mergeManager.appsShuffleInfo.get(appShufflePartitionId.appId)).getMergedShuffleIndexFilePath(appShufflePartitionId.shuffleId, appShufflePartitionId.shuffleMergeId, reduceId));
    }

    public File getMergedShuffleMetaFile(RemoteBlockPushResolver mergeManager, RemoteBlockPushResolver.AppAttemptShuffleMergeId appShufflePartitionId, int reduceId) {
        return ((RemoteBlockPushResolver.AppShuffleInfo)mergeManager.appsShuffleInfo.get(appShufflePartitionId.appId)).getMergedShuffleMetaFile(appShufflePartitionId.shuffleId, appShufflePartitionId.shuffleMergeId, reduceId);
    }

    public Tuple3<FileChannel, RemoteBlockPushResolver.MergeShuffleFile, RemoteBlockPushResolver.MergeShuffleFile> getPartitionFileHandlers(RemoteBlockPushResolver.AppShufflePartitionInfo partitionInfo) {
        return new Tuple3((Object)partitionInfo.getDataChannel(), (Object)partitionInfo.getMetaFile(), (Object)partitionInfo.getIndexFile());
    }

    public void closePartitionFiles(RemoteBlockPushResolver.AppShufflePartitionInfo partitionInfo) {
        partitionInfo.closeAllFilesAndDeleteIfNeeded(false);
    }

    public void clearAppShuffleInfo(RemoteBlockPushResolver mergeMgr) {
        mergeMgr.appsShuffleInfo.clear();
    }

    public ConcurrentMap<String, RemoteBlockPushResolver.AppShuffleInfo> reloadAppShuffleInfo(RemoteBlockPushResolver mergeMgr, DB db) {
        mergeMgr.appsShuffleInfo.clear();
        mergeMgr.reloadAndCleanUpAppShuffleInfo(db);
        return mergeMgr.appsShuffleInfo;
    }

    public int getOutdatedAppPathInfoCountDuringDBReload(RemoteBlockPushResolver mergeMgr, DB db) {
        return mergeMgr.reloadActiveAppAttemptsPathInfo(db).size();
    }

    public int getOutdatedFinalizedShuffleCountDuringDBReload(RemoteBlockPushResolver mergeMgr, DB db) {
        return mergeMgr.reloadFinalizedAppAttemptsShuffleMergeInfo(db).size();
    }

    public ConcurrentMap<ExternalShuffleBlockResolver.AppExecId, ExecutorShuffleInfo> reloadRegisteredExecutors(DBBackend dbBackend, File file) {
        DB db = DBProvider.initDB((DBBackend)dbBackend, (File)file);
        ConcurrentMap result = ExternalShuffleBlockResolver.reloadRegisteredExecutors((DB)db);
        db.close();
        return result;
    }

    public ConcurrentMap<ExternalShuffleBlockResolver.AppExecId, ExecutorShuffleInfo> reloadRegisteredExecutors(DB db) {
        return ExternalShuffleBlockResolver.reloadRegisteredExecutors((DB)db);
    }

    private ShuffleTestAccessor$() {
        MODULE$ = this;
    }
}

