/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.LedgerDescriptor;
import org.apache.bookkeeper.proto.WriteCallback;
import org.apache.log4j.Logger;

public class Bookie
extends Thread {
    HashMap<Long, LedgerDescriptor> ledgers = new HashMap();
    static Logger LOG = Logger.getLogger(Bookie.class);
    private static byte[] ledgerHeader = new byte[]{66, 111, 111, 107, 0, 0, 0, 0};
    final File journalDirectory;
    final File[] ledgerDirectories;
    private static final Random rand = new Random();
    LinkedBlockingQueue<QueueEntry> queue = new LinkedBlockingQueue();
    public static final long preAllocSize = 0x400000L;
    public static final ByteBuffer zeros = ByteBuffer.allocate(512);

    public Bookie(File journalDirectory, File[] ledgerDirectories) {
        this.journalDirectory = journalDirectory;
        this.ledgerDirectories = ledgerDirectories;
        this.setDaemon(true);
        LOG.debug((Object)("I'm starting a bookie with journal directory " + journalDirectory.getName()));
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putHandle(LedgerDescriptor handle) {
        HashMap<Long, LedgerDescriptor> hashMap = this.ledgers;
        synchronized (hashMap) {
            handle.decRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LedgerDescriptor getHandle(long ledgerId, boolean readonly, byte[] masterKey) throws IOException {
        LedgerDescriptor handle = null;
        HashMap<Long, LedgerDescriptor> hashMap = this.ledgers;
        synchronized (hashMap) {
            handle = this.ledgers.get(ledgerId);
            if (handle == null) {
                handle = this.createHandle(ledgerId, readonly);
                this.ledgers.put(ledgerId, handle);
                handle.setMasterKey(ByteBuffer.wrap(masterKey));
            }
            handle.incRef();
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LedgerDescriptor getHandle(long ledgerId, boolean readonly) throws IOException {
        LedgerDescriptor handle = null;
        HashMap<Long, LedgerDescriptor> hashMap = this.ledgers;
        synchronized (hashMap) {
            handle = this.ledgers.get(ledgerId);
            if (handle == null) {
                handle = this.createHandle(ledgerId, readonly);
                this.ledgers.put(ledgerId, handle);
            }
            handle.incRef();
        }
        return handle;
    }

    private LedgerDescriptor createHandle(long ledgerId, boolean readOnly) throws IOException {
        RandomAccessFile ledgerFile = null;
        RandomAccessFile ledgerIndexFile = null;
        String ledgerName = Bookie.getLedgerName(ledgerId, false);
        String ledgerIndexName = Bookie.getLedgerName(ledgerId, true);
        for (File d : this.ledgerDirectories) {
            File lf = new File(d, ledgerName);
            File lif = new File(d, ledgerIndexName);
            if (lf.exists()) {
                if (ledgerFile != null) {
                    throw new IOException("Duplicate ledger file found for " + ledgerId);
                }
                ledgerFile = new RandomAccessFile(lf, "rw");
            }
            if (!lif.exists()) continue;
            if (ledgerIndexFile != null) {
                throw new IOException("Duplicate ledger index file found for " + ledgerId);
            }
            ledgerIndexFile = new RandomAccessFile(lif, "rw");
        }
        if (ledgerFile == null && ledgerIndexFile == null) {
            if (readOnly) {
                throw new NoLedgerException(ledgerId);
            }
            File[] dirs = Bookie.pickDirs(this.ledgerDirectories);
            File lf = new File(dirs[0], ledgerName);
            Bookie.checkParents(lf);
            ledgerFile = new RandomAccessFile(lf, "rw");
            ledgerFile.write(ledgerHeader);
            File lif = new File(dirs[1], ledgerIndexName);
            Bookie.checkParents(lif);
            ledgerIndexFile = new RandomAccessFile(lif, "rw");
        }
        if (ledgerFile != null && ledgerIndexFile != null) {
            return new LedgerDescriptor(ledgerId, ledgerFile.getChannel(), ledgerIndexFile.getChannel());
        }
        if (ledgerFile == null) {
            throw new IOException("Found index but no data for " + ledgerId);
        }
        throw new IOException("Found data but no index for " + ledgerId);
    }

    private static final void checkParents(File f) throws IOException {
        File parent = f.getParentFile();
        if (parent.exists()) {
            return;
        }
        if (!parent.mkdirs()) {
            throw new IOException("Counldn't mkdirs for " + parent);
        }
    }

    private static final File[] pickDirs(File[] dirs) {
        File[] rc = new File[]{dirs[rand.nextInt(dirs.length)], dirs[rand.nextInt(dirs.length)]};
        return rc;
    }

    private static final String getLedgerName(long ledgerId, boolean isIndex) {
        int parent = (int)(ledgerId & 0xFFL);
        int grandParent = (int)((ledgerId & 0xFF00L) >> 8);
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(grandParent));
        sb.append('/');
        sb.append(Integer.toHexString(parent));
        sb.append('/');
        sb.append(Long.toHexString(ledgerId));
        if (isIndex) {
            sb.append(".idx");
        }
        return sb.toString();
    }

    @Override
    public void run() {
        LinkedList<QueueEntry> toFlush = new LinkedList<QueueEntry>();
        ByteBuffer lenBuff = ByteBuffer.allocate(4);
        try {
            FileChannel logFile = new RandomAccessFile(new File(this.journalDirectory, Long.toHexString(System.currentTimeMillis()) + ".txn"), "rw").getChannel();
            zeros.clear();
            long nextPrealloc = 0x400000L;
            logFile.write(zeros, nextPrealloc);
            while (true) {
                QueueEntry qe = null;
                if (toFlush.isEmpty()) {
                    qe = this.queue.take();
                } else {
                    qe = this.queue.poll();
                    if (qe == null || toFlush.size() > 100) {
                        logFile.force(false);
                        for (QueueEntry e : toFlush) {
                            e.cb.writeComplete(0, e.ledgerId, e.entryId, e.ctx);
                        }
                        toFlush.clear();
                    }
                }
                if (qe == null) continue;
                lenBuff.clear();
                lenBuff.putInt(qe.entry.remaining());
                lenBuff.flip();
                logFile.write(new ByteBuffer[]{lenBuff, qe.entry});
                if (logFile.position() > nextPrealloc) {
                    nextPrealloc = (logFile.size() / 0x400000L + 1L) * 0x400000L;
                    zeros.clear();
                    logFile.write(zeros, nextPrealloc);
                }
                toFlush.add(qe);
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)"Bookie thread exiting", (Throwable)e);
            return;
        }
    }

    public void shutdown() throws InterruptedException {
        this.interrupt();
        this.join();
        for (LedgerDescriptor d : this.ledgers.values()) {
            d.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(ByteBuffer entry, WriteCallback cb, Object ctx, byte[] masterKey) throws IOException, BookieException {
        long ledgerId = entry.getLong();
        LedgerDescriptor handle = this.getHandle(ledgerId, false, masterKey);
        if (!handle.cmpMasterKey(ByteBuffer.wrap(masterKey))) {
            throw BookieException.create(-1);
        }
        try {
            entry.rewind();
            long entryId = handle.addEntry(entry);
            entry.rewind();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Adding " + entryId + "@" + ledgerId));
            }
            this.queue.add(new QueueEntry(entry, ledgerId, entryId, cb, ctx));
        }
        finally {
            this.putHandle(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer readEntry(long ledgerId, long entryId) throws IOException {
        LedgerDescriptor handle = this.getHandle(ledgerId, true);
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Reading " + entryId + "@" + ledgerId));
            }
            ByteBuffer byteBuffer = handle.readEntry(entryId);
            return byteBuffer;
        }
        finally {
            this.putHandle(handle);
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException, BookieException {
        Bookie b = new Bookie(new File("/tmp"), new File[]{new File("/tmp")});
        CounterCallback cb = new CounterCallback();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            ByteBuffer buff = ByteBuffer.allocate(1024);
            buff.putLong(1L);
            buff.putLong(i);
            buff.limit(1024);
            buff.position(0);
            cb.incCount();
            b.addEntry(buff, cb, null, new byte[0]);
        }
        cb.waitZero();
        long end = System.currentTimeMillis();
        System.out.println("Took " + (end - start) + "ms");
    }

    static class CounterCallback
    implements WriteCallback {
        int count;

        CounterCallback() {
        }

        @Override
        public synchronized void writeComplete(int rc, long l, long e, Object ctx) {
            --this.count;
            if (this.count == 0) {
                this.notifyAll();
            }
        }

        public synchronized void incCount() {
            ++this.count;
        }

        public synchronized void waitZero() throws InterruptedException {
            while (this.count > 0) {
                this.wait();
            }
        }
    }

    static class QueueEntry {
        ByteBuffer entry;
        long ledgerId;
        long entryId;
        WriteCallback cb;
        Object ctx;

        QueueEntry(ByteBuffer entry, long ledgerId, long entryId, WriteCallback cb, Object ctx) {
            this.entry = entry.duplicate();
            this.cb = cb;
            this.ctx = ctx;
            this.ledgerId = ledgerId;
            this.entryId = entryId;
        }
    }

    public static class NoEntryException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private long ledgerId;
        private long entryId;

        public NoEntryException(long ledgerId, long entryId) {
            this.ledgerId = ledgerId;
            this.entryId = entryId;
        }

        public long getLedger() {
            return this.ledgerId;
        }

        public long getEntry() {
            return this.entryId;
        }
    }

    public static class NoLedgerException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private long ledgerId;

        public NoLedgerException(long ledgerId) {
            this.ledgerId = ledgerId;
        }

        public long getLedgerId() {
            return this.ledgerId;
        }
    }
}

