/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.log4j.Logger;

public class LedgerDescriptor {
    Logger LOG = Logger.getLogger(LedgerDescriptor.class);
    private ByteBuffer masterKey = null;
    private long ledgerId;
    private FileChannel ledger;
    private FileChannel ledgerIndex;
    private int refCnt;

    LedgerDescriptor(long ledgerId, FileChannel ledger, FileChannel ledgerIndex) {
        this.ledgerId = ledgerId;
        this.ledger = ledger;
        this.ledgerIndex = ledgerIndex;
    }

    void setMasterKey(ByteBuffer masterKey) {
        this.masterKey = masterKey;
    }

    boolean cmpMasterKey(ByteBuffer masterKey) {
        return this.masterKey.equals(masterKey);
    }

    public synchronized void incRef() {
        ++this.refCnt;
    }

    public synchronized void decRef() {
        --this.refCnt;
    }

    public synchronized int getRefCnt() {
        return this.refCnt;
    }

    private static final long calcEntryOffset(long entryId) {
        return 8L * entryId;
    }

    long addEntry(ByteBuffer entry) throws IOException {
        ByteBuffer offsetBuffer = ByteBuffer.wrap(new byte[8]);
        long ledgerId = entry.getLong();
        if (ledgerId != this.ledgerId) {
            throw new IOException("Entry for ledger " + ledgerId + " was sent to " + this.ledgerId);
        }
        long entryId = entry.getLong();
        entry.rewind();
        offsetBuffer.rewind();
        offsetBuffer.putLong(this.ledger.position());
        offsetBuffer.flip();
        this.ledgerIndex.write(offsetBuffer, LedgerDescriptor.calcEntryOffset(entryId));
        ByteBuffer lenBuffer = ByteBuffer.allocate(4);
        lenBuffer.putInt(entry.remaining());
        lenBuffer.flip();
        this.ledger.write(lenBuffer);
        this.ledger.write(entry);
        return entryId;
    }

    ByteBuffer readEntry(long entryId) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[8]);
        long offset = entryId == -1L ? this.ledgerIndex.size() - 8L : LedgerDescriptor.calcEntryOffset(entryId);
        int len = this.ledgerIndex.read(buffer, offset);
        buffer.flip();
        if (len != buffer.limit()) {
            throw new Bookie.NoEntryException(this.ledgerId, entryId);
        }
        offset = buffer.getLong();
        if (offset == 0L) {
            throw new Bookie.NoEntryException(this.ledgerId, entryId);
        }
        this.LOG.debug((Object)("Offset: " + offset));
        buffer.limit(4);
        buffer.rewind();
        this.ledger.read(buffer, offset);
        buffer.flip();
        len = buffer.getInt();
        this.LOG.debug((Object)("Length of buffer: " + len));
        buffer = ByteBuffer.allocate(len);
        this.ledger.read(buffer, offset + 4L);
        buffer.flip();
        return buffer;
    }

    void close() {
        try {
            this.ledger.close();
        }
        catch (IOException e) {
            this.LOG.warn((Object)("Error closing ledger " + this.ledgerId), (Throwable)e);
        }
        try {
            this.ledgerIndex.close();
        }
        catch (IOException e) {
            this.LOG.warn((Object)("Error closing index for ledger " + this.ledgerId), (Throwable)e);
        }
    }
}

