/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

public abstract class BKException
extends Exception {
    private int code;

    public BKException(int code) {
        this.code = code;
    }

    public static BKException create(int code) {
        switch (code) {
            case -1: {
                return new BKReadException();
            }
            case -2: {
                return new BKQuorumException();
            }
            case -3: {
                return new BKBookieException();
            }
            case -4: {
                return new BKDigestNotInitializedException();
            }
            case -5: {
                return new BKDigestMatchException();
            }
            case -6: {
                return new BKNotEnoughBookiesException();
            }
            case -7: {
                return new BKNoSuchLedgerExistsException();
            }
            case -8: {
                return new BKBookieHandleNotAvailableException();
            }
        }
        return new BKIllegalOpException();
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage(int code) {
        switch (code) {
            case 0: {
                return "No problem";
            }
            case -1: {
                return "Error while reading ledger";
            }
            case -2: {
                return "Invalid quorum size on ensemble size";
            }
            case -3: {
                return "Invalid quorum size on ensemble size";
            }
            case -4: {
                return "Digest engine not initialized";
            }
            case -5: {
                return "Entry digest does not match";
            }
            case -6: {
                return "Not enough non-faulty bookies available";
            }
            case -7: {
                return "No such ledger exists";
            }
            case -8: {
                return "Bookie handle is not available";
            }
        }
        return "Invalid operation";
    }

    public static class BKBookieHandleNotAvailableException
    extends BKException {
        public BKBookieHandleNotAvailableException() {
            super(-8);
        }
    }

    public static class BKNoSuchLedgerExistsException
    extends BKException {
        public BKNoSuchLedgerExistsException() {
            super(-7);
        }
    }

    public static class BKNotEnoughBookiesException
    extends BKException {
        public BKNotEnoughBookiesException() {
            super(-6);
        }
    }

    public static class BKIllegalOpException
    extends BKException {
        public BKIllegalOpException() {
            super(-100);
        }
    }

    public static class BKDigestMatchException
    extends BKException {
        public BKDigestMatchException() {
            super(-5);
        }
    }

    public static class BKDigestNotInitializedException
    extends BKException {
        public BKDigestNotInitializedException() {
            super(-4);
        }
    }

    public static class BKBookieException
    extends BKException {
        public BKBookieException() {
            super(-3);
        }
    }

    public static class BKQuorumException
    extends BKException {
        public BKQuorumException() {
            super(-2);
        }
    }

    public static class BKReadException
    extends BKException {
        public BKReadException() {
            super(-1);
        }
    }

    public static interface Code {
        public static final int OK = 0;
        public static final int ReadException = -1;
        public static final int QuorumException = -2;
        public static final int NoBookieAvailableException = -3;
        public static final int DigestNotInitializedException = -4;
        public static final int DigestMatchException = -5;
        public static final int NotEnoughBookiesException = -6;
        public static final int NoSuchLedgerExistsException = -7;
        public static final int BookieHandleNotAvailableException = -8;
        public static final int IllegalOpException = -100;
    }
}

