/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookieHandle;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerManagementProcessor;
import org.apache.bookkeeper.client.LedgerRecoveryMonitor;
import org.apache.bookkeeper.client.LedgerSequence;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class BookKeeper
implements Watcher {
    Logger LOG = Logger.getLogger(BookKeeper.class);
    ZooKeeper zk = null;
    private static LedgerManagementProcessor ledgerMngProcessor;
    HashSet<InetSocketAddress> bookieBlackList;
    LedgerSequence responseRead;
    Long responseLong;
    HashMap<InetSocketAddress, BookieHandle> bhMap = new HashMap();

    public BookKeeper(String servers) throws KeeperException, IOException {
        this.LOG.debug((Object)("Creating BookKeeper for servers " + servers));
        this.zk = new ZooKeeper(servers, 10000, (Watcher)this);
        this.bookieBlackList = new HashSet();
    }

    public synchronized void process(WatchedEvent event) {
        this.LOG.debug((Object)("Process: " + event.getType() + " " + event.getPath()));
    }

    String getZKStringId(long id) {
        return String.format("%010d", id);
    }

    ZooKeeper getZooKeeper() {
        return this.zk;
    }

    LedgerManagementProcessor getMngProcessor() {
        if (ledgerMngProcessor == null) {
            ledgerMngProcessor = new LedgerManagementProcessor(this);
            ledgerMngProcessor.start();
        }
        return ledgerMngProcessor;
    }

    public LedgerHandle createLedger(int ensSize, int qSize, LedgerHandle.QMode mode, byte[] passwd) throws KeeperException, InterruptedException, IOException, BKException {
        LedgerHandle lh = null;
        switch (mode) {
            case VERIFIABLE: {
                long t = Math.round(Math.floor((ensSize - 1) / 2));
                if (t != 0L) break;
                this.LOG.error((Object)"Tolerates 0 bookie failures");
                throw BKException.create(-2);
            }
            case GENERIC: {
                long t = Math.round(Math.floor((ensSize - 1) / 3));
                if (t != 0L) break;
                this.LOG.error((Object)"Tolerates 0 bookie failures");
                throw BKException.create(-2);
            }
        }
        String path = this.zk.create("/ledgers/L", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        String[] parts = path.split("/");
        String[] subparts = parts[2].split("L");
        try {
            long lId = Long.parseLong(subparts[1]);
            List list = this.zk.getChildren("/ledgers/available", false);
            ArrayList lBookies = new ArrayList();
            path = this.zk.create("/ledgers/L" + this.getZKStringId(lId) + "/ensemble", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(qSize);
            this.zk.create("/ledgers/L" + this.getZKStringId(lId) + "/quorum", bb.array(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            bb = ByteBuffer.allocate(4);
            bb.putInt(mode.ordinal());
            this.zk.create("/ledgers/L" + this.getZKStringId(lId) + "/mode", bb.array(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            lh = new LedgerHandle(this, lId, 0L, qSize, mode, passwd);
            Random r = new Random();
            for (int i = 0; i < ensSize; ++i) {
                int index = 0;
                if (list.size() > 1) {
                    index = r.nextInt(list.size() - 1);
                } else if (list.size() == 1) {
                    index = 0;
                } else {
                    this.LOG.error((Object)"Not enough bookies available");
                    return null;
                }
                try {
                    String bookie = (String)list.remove(index);
                    this.LOG.info((Object)("Bookie: " + bookie));
                    InetSocketAddress tAddr = this.parseAddr(bookie);
                    int bindex = lh.addBookieForWriting(tAddr);
                    ByteBuffer bindexBuf = ByteBuffer.allocate(4);
                    bindexBuf.putInt(bindex);
                    String pBookie = "/" + bookie;
                    this.zk.create("/ledgers/L" + this.getZKStringId(lId) + "/ensemble" + pBookie, bindexBuf.array(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    continue;
                }
                catch (IOException e) {
                    this.LOG.error((Object)e);
                    --i;
                }
            }
            this.LOG.debug((Object)"Created new ledger");
        }
        catch (NumberFormatException e) {
            this.LOG.error((Object)"Error when parsing the ledger identifier", (Throwable)e);
        }
        return lh;
    }

    public LedgerHandle createLedger(byte[] passwd) throws KeeperException, BKException, InterruptedException, IOException {
        return this.createLedger(3, 2, LedgerHandle.QMode.VERIFIABLE, passwd);
    }

    public void asyncCreateLedger(int ensSize, int qSize, LedgerHandle.QMode mode, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx) throws KeeperException, InterruptedException, IOException, BKException {
        LedgerManagementProcessor.CreateLedgerOp op = new LedgerManagementProcessor.CreateLedgerOp(ensSize, qSize, mode, passwd, cb, ctx);
        LedgerManagementProcessor lmp = this.getMngProcessor();
        lmp.addOp(op);
    }

    public LedgerHandle openLedger(long lId, byte[] passwd) throws KeeperException, InterruptedException, IOException, BKException {
        LedgerHandle.QMode qMode;
        Stat stat = null;
        if (this.zk.exists("/ledgers/L" + this.getZKStringId(lId), false) == null) {
            this.LOG.error((Object)("Ledger " + this.getZKStringId(lId) + " doesn't exist."));
            throw BKException.create(-7);
        }
        ByteBuffer bb = ByteBuffer.wrap(this.zk.getData("/ledgers/L" + this.getZKStringId(lId) + "/quorum", false, stat));
        int qSize = bb.getInt();
        long last = 0L;
        this.LOG.debug((Object)("Close path: /ledgers/L" + this.getZKStringId(lId) + "/close"));
        if (this.zk.exists("/ledgers/L" + this.getZKStringId(lId) + "/close", false) == null) {
            this.recoverLedger(lId, passwd);
        }
        stat = null;
        byte[] data = this.zk.getData("/ledgers/L" + this.getZKStringId(lId) + "/close", false, stat);
        ByteBuffer buf = ByteBuffer.wrap(data);
        last = buf.getLong();
        data = this.zk.getData("/ledgers/L" + this.getZKStringId(lId) + "/mode", false, stat);
        buf = ByteBuffer.wrap(data);
        switch (buf.getInt()) {
            case 1: {
                qMode = LedgerHandle.QMode.GENERIC;
                this.LOG.info((Object)"Generic ledger");
                break;
            }
            case 2: {
                qMode = LedgerHandle.QMode.FREEFORM;
                break;
            }
            default: {
                qMode = LedgerHandle.QMode.VERIFIABLE;
                this.LOG.info((Object)"Verifiable ledger");
            }
        }
        LedgerHandle lh = new LedgerHandle(this, lId, last, qSize, qMode, passwd);
        List list = this.zk.getChildren("/ledgers/L" + this.getZKStringId(lId) + "/ensemble", false);
        this.LOG.debug((Object)("Length of list of bookies: " + list.size()));
        for (int i = 0; i < list.size(); ++i) {
            for (String s : list) {
                this.LOG.debug((Object)("Extracting bookie: " + s));
                byte[] bindex = this.zk.getData("/ledgers/L" + this.getZKStringId(lId) + "/ensemble" + "/" + s, false, stat);
                ByteBuffer bindexBuf = ByteBuffer.wrap(bindex);
                if (bindexBuf.getInt() != i) continue;
                try {
                    lh.addBookieForReading(this.parseAddr(s));
                }
                catch (IOException e) {
                    this.LOG.error((Object)e);
                }
            }
        }
        if (this.zk.exists("/ledgers/L" + this.getZKStringId(lh.getId()) + "/quorum_evolution", false) != null) {
            String path = "/ledgers/L" + this.getZKStringId(lh.getId()) + "/quorum_evolution";
            List faultList = this.zk.getChildren(path, false);
            try {
                for (String s : faultList) {
                    this.LOG.debug((Object)("Faulty list child: " + s));
                    long entry = Long.parseLong(s);
                    String addresses = new String(this.zk.getData(path + "/" + s, false, stat));
                    String[] parts = addresses.split(" ");
                    ArrayList<BookieHandle> newBookieSet = new ArrayList<BookieHandle>();
                    for (int i = 0; i < parts.length; ++i) {
                        this.LOG.debug((Object)("Address: " + parts[i]));
                        InetSocketAddress faultyBookie = this.parseAddr(parts[i].substring(1));
                        newBookieSet.add(lh.getBookieHandleDup(faultyBookie));
                    }
                    lh.setNewBookieConfig(entry, newBookieSet);
                    this.LOG.debug((Object)("NewBookieSet size: " + newBookieSet.size()));
                }
                lh.prepareEntryChange();
            }
            catch (NumberFormatException e) {
                this.LOG.error((Object)"Error when parsing the ledger identifier", (Throwable)e);
            }
        }
        return lh;
    }

    public void asyncOpenLedger(long lId, byte[] passwd, AsyncCallback.OpenCallback cb, Object ctx) throws InterruptedException {
        LedgerManagementProcessor.OpenLedgerOp op = new LedgerManagementProcessor.OpenLedgerOp(lId, passwd, cb, ctx);
        LedgerManagementProcessor lmp = this.getMngProcessor();
        lmp.addOp(op);
    }

    InetSocketAddress parseAddr(String s) {
        String[] parts = s.split(":");
        if (parts.length != 2) {
            System.out.println(s + " does not have the form host:port");
        }
        InetSocketAddress addr = new InetSocketAddress(parts[0], Integer.parseInt(parts[1]));
        return addr;
    }

    public boolean hasClosed(long ledgerId) throws KeeperException, InterruptedException {
        String closePath = "/ledgers/L" + this.getZKStringId(ledgerId) + "/close";
        return this.zk.exists(closePath, false) != null;
    }

    boolean recoverLedger(long lId, byte[] passwd) throws KeeperException, InterruptedException, IOException, BKException {
        Stat stat = null;
        this.LOG.info((Object)"Recovering ledger");
        ByteBuffer bb = ByteBuffer.wrap(this.zk.getData("/ledgers/L" + this.getZKStringId(lId) + "/quorum", false, stat));
        int qSize = bb.getInt();
        List list = this.zk.getChildren("/ledgers/L" + this.getZKStringId(lId) + "/ensemble", false);
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (String s : list) {
            addresses.add(this.parseAddr(s));
        }
        byte[] data = this.zk.getData("/ledgers/L" + this.getZKStringId(lId) + "/mode", false, stat);
        ByteBuffer buf = ByteBuffer.wrap(data);
        LedgerHandle.QMode qMode = LedgerHandle.QMode.VERIFIABLE;
        switch (buf.getInt()) {
            case 0: {
                qMode = LedgerHandle.QMode.VERIFIABLE;
                break;
            }
            case 1: {
                qMode = LedgerHandle.QMode.GENERIC;
                break;
            }
            case 2: {
                qMode = LedgerHandle.QMode.FREEFORM;
            }
        }
        LedgerRecoveryMonitor lrm = new LedgerRecoveryMonitor(this, lId, qSize, addresses, qMode);
        return lrm.recover(passwd);
    }

    InetSocketAddress getNewBookie(ArrayList<InetSocketAddress> addrList) throws InterruptedException {
        try {
            List list = this.zk.getChildren("/ledgers/available", false);
            ArrayList lBookies = new ArrayList();
            for (String addr : list) {
                InetSocketAddress nAddr = this.parseAddr(addr);
                if (addrList.contains(nAddr) || this.bookieBlackList.contains(nAddr)) continue;
                return nAddr;
            }
        }
        catch (KeeperException e) {
            this.LOG.error((Object)("Problem accessing ZooKeeper: " + (Object)((Object)e)));
        }
        return null;
    }

    synchronized BookieHandle getBookieHandle(LedgerHandle lh, InetSocketAddress a) throws ConnectException, IOException {
        if (!this.bhMap.containsKey(a)) {
            BookieHandle bh = new BookieHandle(a, true);
            this.bhMap.put(a, bh);
            bh.start();
        }
        this.bhMap.get(a).incRefCount(lh);
        return this.bhMap.get(a);
    }

    synchronized void haltBookieHandles(LedgerHandle lh, ArrayList<BookieHandle> bookies) {
        while (bookies.size() > 0) {
            BookieHandle bh = bookies.remove(0);
            if (bh.halt(lh) > 0) continue;
            this.bhMap.remove(bh.addr);
        }
    }

    void blackListBookie(InetSocketAddress addr) {
        this.bookieBlackList.add(addr);
    }

    public void halt() throws InterruptedException {
        for (BookieHandle bh : this.bhMap.values()) {
            bh.shutdown();
        }
        this.zk.close();
    }
}

