/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.LedgerSequence;
import org.apache.bookkeeper.client.QuorumEngine;
import org.apache.bookkeeper.client.QuorumOpMonitor;
import org.apache.log4j.Logger;

class ClientCBWorker
extends Thread {
    static Logger LOG = Logger.getLogger(ClientCBWorker.class);
    static ClientCBWorker instance = null;
    private volatile boolean stop = false;
    private static int instanceCounter = 0;
    ArrayBlockingQueue<QuorumEngine.Operation> pendingOps = new ArrayBlockingQueue(6000);
    QuorumOpMonitor monitor;

    static ClientCBWorker getInstance() {
        if (instance == null) {
            instance = new ClientCBWorker();
        }
        ++instanceCounter;
        return instance;
    }

    ClientCBWorker() {
        this.start();
        LOG.info((Object)"Have started cbWorker");
    }

    void addOperation(QuorumEngine.Operation op) throws InterruptedException {
        this.pendingOps.put(op);
    }

    void shutdown() {
        if (--instanceCounter == 0) {
            this.stop = true;
            instance = null;
            LOG.info((Object)"Shutting down CBWorker");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.stop) {
                QuorumEngine.Operation op = this.pendingOps.poll(1000L, TimeUnit.MILLISECONDS);
                if (op == null) continue;
                QuorumEngine.Operation operation = op;
                synchronized (operation) {
                    while (!op.isReady()) {
                        op.wait(1000L);
                    }
                }
                switch (op.type) {
                    case 1: {
                        QuorumEngine.Operation.AddOp aOp = (QuorumEngine.Operation.AddOp)op;
                        aOp.getLedger().setAddConfirmed(aOp.entry);
                        aOp.cb.addComplete(aOp.getErrorCode(), aOp.getLedger(), aOp.entry, aOp.ctx);
                        break;
                    }
                    case 0: {
                        QuorumEngine.Operation.ReadOp rOp = (QuorumEngine.Operation.ReadOp)op;
                        rOp.cb.readComplete(rOp.getErrorCode(), rOp.getLedger(), new LedgerSequence(rOp.seq), rOp.ctx);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Exception while waiting on queue or operation");
        }
    }
}

