/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookieHandle;
import org.apache.bookkeeper.client.LedgerManagementProcessor;
import org.apache.bookkeeper.client.LedgerSequence;
import org.apache.bookkeeper.client.QuorumEngine;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;

public class LedgerHandle
implements AsyncCallback.ReadCallback,
AsyncCallback.AddCallback {
    static Logger LOG = Logger.getLogger(LedgerHandle.class);
    private long ledger;
    private volatile long last;
    private volatile long lastAddConfirmed = 0L;
    private HashMap<Integer, Long> lastRecvCorrectly;
    private volatile ArrayList<BookieHandle> bookies;
    private ArrayList<InetSocketAddress> bookieAddrList;
    private TreeMap<Long, ArrayList<BookieHandle>> bookieConfigMap;
    private long[] entryChange;
    private BookKeeper bk;
    private QuorumEngine qe;
    private int qSize;
    private QMode qMode = QMode.VERIFIABLE;
    private int lMode;
    private int threshold;
    private String digestAlg = "SHA1";
    private byte[] macKey;
    private byte[] ledgerKey;
    private byte[] passwd;

    LedgerHandle(BookKeeper bk, long ledger, long last, byte[] passwd) throws InterruptedException {
        this.bk = bk;
        this.ledger = ledger;
        this.last = last;
        this.bookies = new ArrayList();
        this.lastRecvCorrectly = new HashMap();
        this.passwd = passwd;
        this.genLedgerKey(passwd);
        this.genMacKey(passwd);
        this.qSize = (this.bookies.size() + 1) / 2;
        this.qe = new QuorumEngine(this);
    }

    LedgerHandle(BookKeeper bk, long ledger, long last, int qSize, QMode mode, byte[] passwd) throws InterruptedException {
        this.bk = bk;
        this.ledger = ledger;
        this.last = last;
        this.bookies = new ArrayList();
        this.lastRecvCorrectly = new HashMap();
        this.qSize = qSize;
        this.qMode = mode;
        this.passwd = passwd;
        this.genLedgerKey(passwd);
        this.genMacKey(passwd);
        this.qe = new QuorumEngine(this);
    }

    LedgerHandle(BookKeeper bk, long ledger, long last, int qSize, byte[] passwd) throws InterruptedException {
        this.bk = bk;
        this.ledger = ledger;
        this.last = last;
        this.bookies = new ArrayList();
        this.lastRecvCorrectly = new HashMap();
        this.qSize = qSize;
        this.passwd = passwd;
        this.genLedgerKey(passwd);
        this.genMacKey(passwd);
        this.qe = new QuorumEngine(this);
    }

    private void setBookies(ArrayList<InetSocketAddress> bookies) throws InterruptedException {
        try {
            for (InetSocketAddress a : bookies) {
                LOG.debug((Object)("Opening bookieHandle: " + a));
                this.bookies.add(this.bk.getBookieHandle(this, a));
            }
        }
        catch (ConnectException e) {
            LOG.error((Object)e);
            InetSocketAddress addr = this.bk.getNewBookie(bookies);
            if (addr != null) {
                bookies.add(addr);
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    void setQuorumEngine(QuorumEngine qe) {
        this.qe = qe;
    }

    QuorumEngine getQuorumEngine() {
        return this.qe;
    }

    int addBookieForWriting(InetSocketAddress addr) throws IOException {
        LOG.debug((Object)("Bookie address: " + addr));
        this.lMode = 0;
        this.bookies.add(this.bk.getBookieHandle(this, addr));
        if (this.bookies.size() > this.qSize) {
            this.setThreshold();
        }
        return this.bookies.size() - 1;
    }

    int addBookieForReading(InetSocketAddress addr) throws IOException {
        LOG.debug((Object)("Bookie address: " + addr));
        this.lMode = 1;
        try {
            this.bookies.add(this.bk.getBookieHandle(this, addr));
        }
        catch (IOException e) {
            LOG.info((Object)"Inserting a decoy bookie handle");
            this.bookies.add(new BookieHandle(addr, false));
        }
        if (this.bookies.size() > this.qSize) {
            this.setThreshold();
        }
        return this.bookies.size() - 1;
    }

    private void setThreshold() {
        switch (this.qMode) {
            case GENERIC: {
                this.threshold = this.bookies.size() - this.qSize / 2;
                break;
            }
            case VERIFIABLE: {
                this.threshold = this.bookies.size() - this.qSize + 1;
                break;
            }
            default: {
                this.threshold = this.bookies.size();
            }
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    void changeEnsemble(long entry) {
        String path = "/ledgers/L" + this.bk.getZKStringId(this.getId()) + "/quorum_evolution" + "/" + String.format("%010d", entry);
        LOG.info((Object)("Report failure: " + String.format("%010d", entry)));
        try {
            if (this.bk.getZooKeeper().exists("/ledgers/L" + this.bk.getZKStringId(this.getId()) + "/quorum_evolution", false) == null) {
                this.bk.getZooKeeper().create("/ledgers/L" + this.bk.getZKStringId(this.getId()) + "/quorum_evolution", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            boolean first = true;
            String addresses = "";
            for (BookieHandle bh : this.bookies) {
                if (first) {
                    addresses = bh.addr.toString();
                    first = false;
                    continue;
                }
                addresses = addresses + " " + bh.addr.toString();
            }
            this.bk.getZooKeeper().create(path, addresses.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (Exception e) {
            LOG.error((Object)("Could not write to ZooKeeper: " + path + ", " + e));
        }
    }

    void replaceBookie(int index) throws BKException {
        InetSocketAddress addr = null;
        try {
            addr = this.bk.getNewBookie(this.bookieAddrList);
        }
        catch (InterruptedException e) {
            LOG.error((Object)e);
        }
        if (addr == null) {
            throw BKException.create(-3);
        }
        try {
            this.bookies.set(index, this.bk.getBookieHandle(this, addr));
        }
        catch (ConnectException e) {
            this.bk.blackListBookie(addr);
            LOG.error((Object)e);
        }
        catch (IOException e) {
            this.bk.blackListBookie(addr);
            LOG.error((Object)e);
        }
    }

    synchronized void removeBookie(BookieHandle bh) {
        if (this.lMode == 0) {
            LOG.info((Object)("Removing bookie: " + bh.addr));
            int index = this.bookies.indexOf(bh);
            if (index >= 0) {
                Long tmpLastRecv = this.lastRecvCorrectly.get(index);
                this.bookies.remove(index);
                if (tmpLastRecv == null) {
                    this.changeEnsemble(0L);
                } else {
                    this.changeEnsemble(tmpLastRecv);
                }
            }
        }
    }

    public long getId() {
        return this.ledger;
    }

    public long getLast() {
        return this.last;
    }

    long incLast() {
        return this.last++;
    }

    long setLast(long last) {
        this.last = last;
        return this.last;
    }

    void setAddConfirmed(long entryId) {
        if (entryId > this.lastAddConfirmed) {
            this.lastAddConfirmed = entryId;
        }
    }

    long getAddConfirmed() {
        return this.lastAddConfirmed;
    }

    void setLastRecvCorrectly(int sId, long entry) {
        this.lastRecvCorrectly.put(sId, entry);
    }

    ArrayList<BookieHandle> getBookies() {
        return this.bookies;
    }

    ArrayList<BookieHandle> getBookies(long entry) {
        return this.getConfig(entry);
    }

    BookieHandle getBookieHandleDup(InetSocketAddress addr) {
        for (BookieHandle bh : this.bookies) {
            if (!bh.addr.equals(addr)) continue;
            return bh;
        }
        return null;
    }

    void setNewBookieConfig(long entry, ArrayList<BookieHandle> list) {
        if (this.bookieConfigMap == null) {
            this.bookieConfigMap = new TreeMap();
        }
        if (!this.bookieConfigMap.containsKey(new Long(0L))) {
            this.bookieConfigMap.put(new Long(0L), this.bookies);
        }
        LOG.info((Object)("Adding new entry: " + entry + ", " + this.bookies.size() + ", " + list.size()));
        this.bookieConfigMap.put(entry, list);
    }

    void prepareEntryChange() {
        this.entryChange = new long[this.bookieConfigMap.size()];
        int counter = 0;
        for (Long l : this.bookieConfigMap.keySet()) {
            this.entryChange[counter++] = l;
        }
    }

    int getQuorumSize() {
        return this.qSize;
    }

    private ArrayList<BookieHandle> getConfig(long entry) {
        int index;
        if (this.bookieConfigMap == null) {
            return this.bookies;
        }
        int before = index = Arrays.binarySearch(this.entryChange, entry);
        int n = index = index >= 0 ? index : -1 - index;
        if (index == 0) {
            if (entry % 10L == 0L) {
                LOG.info((Object)("Index: " + index + ", " + before + ", " + entry + ", " + this.bookieConfigMap.get(this.entryChange[index]).size()));
            }
            return this.bookieConfigMap.get(this.entryChange[index]);
        }
        return this.bookieConfigMap.get(this.entryChange[index - 1]);
    }

    QMode getQMode() {
        return this.qMode;
    }

    void setDigestAlg(String alg) {
        this.digestAlg = alg;
    }

    String getDigestAlg() {
        return this.digestAlg;
    }

    private void genLedgerKey(byte[] passwd) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            String pad = "ledger";
            byte[] toProcess = new byte[passwd.length + pad.length()];
            System.arraycopy(pad.getBytes(), 0, toProcess, 0, pad.length());
            System.arraycopy(passwd, 0, toProcess, pad.length(), passwd.length);
            digest.update(toProcess);
            this.ledgerKey = digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            this.passwd = passwd;
            LOG.error((Object)"Storing password as plain text because secure hash implementation does not exist");
        }
    }

    private void genMacKey(byte[] passwd) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            String pad = "mac";
            byte[] toProcess = new byte[passwd.length + pad.length()];
            System.arraycopy(pad.getBytes(), 0, toProcess, 0, pad.length());
            System.arraycopy(passwd, 0, toProcess, pad.length(), passwd.length);
            digest.update(toProcess);
            this.macKey = digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            this.passwd = passwd;
            LOG.error((Object)"Storing password as plain text because secure hash implementation does not exist");
        }
    }

    byte[] getPasswd() {
        return this.passwd;
    }

    byte[] getMacKey() {
        return this.macKey;
    }

    byte[] getLedgerKey() {
        return this.ledgerKey;
    }

    void closeUp() {
        this.ledger = -1L;
        this.last = -1L;
        this.bk.haltBookieHandles(this, this.bookies);
    }

    public void close() throws KeeperException, InterruptedException, BKException {
        ByteBuffer last = ByteBuffer.allocate(8);
        last.putLong(this.lastAddConfirmed);
        LOG.info((Object)("Last saved on ZK is: " + this.lastAddConfirmed));
        String closePath = "/ledgers/L" + this.bk.getZKStringId(this.getId()) + "/close";
        if (this.bk.getZooKeeper().exists(closePath, false) == null) {
            this.bk.getZooKeeper().create(closePath, last.array(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        this.closeUp();
        QuorumEngine.Operation.StopOp sOp = new QuorumEngine.Operation.StopOp();
        this.qe.sendOp(sOp);
        LOG.info((Object)("##### CB worker queue size: " + this.qe.cbWorker.pendingOps.size()));
    }

    public void asyncClose(AsyncCallback.CloseCallback cb, Object ctx) throws InterruptedException {
        LedgerManagementProcessor.CloseLedgerOp op = new LedgerManagementProcessor.CloseLedgerOp(this, cb, ctx);
        LedgerManagementProcessor lmp = this.bk.getMngProcessor();
        lmp.addOp(op);
    }

    public void asyncReadEntries(long firstEntry, long lastEntry, AsyncCallback.ReadCallback cb, Object ctx) throws BKException, InterruptedException {
        if (firstEntry > this.getLast() || firstEntry > lastEntry) {
            throw BKException.create(-1);
        }
        QuorumEngine.Operation.ReadOp r = new QuorumEngine.Operation.ReadOp(this, firstEntry, lastEntry, cb, ctx);
        this.qe.sendOp(r);
    }

    public LedgerSequence readEntries(long firstEntry, long lastEntry) throws InterruptedException, BKException {
        if (firstEntry > this.getLast() || firstEntry > lastEntry) {
            throw BKException.create(-1);
        }
        RetCounter counter = new RetCounter();
        counter.inc();
        QuorumEngine.Operation.ReadOp r = new QuorumEngine.Operation.ReadOp(this, firstEntry, lastEntry, this, counter);
        this.qe.sendOp(r);
        LOG.debug((Object)("Going to wait for read entries: " + counter.i));
        counter.block(0);
        LOG.debug((Object)("Done with waiting: " + counter.i + ", " + firstEntry));
        if (counter.getSequence() == null) {
            LOG.error((Object)("Failed to read entries: " + firstEntry + ", " + lastEntry));
            throw BKException.create(-1);
        }
        return counter.getSequence();
    }

    public void asyncAddEntry(byte[] data, AsyncCallback.AddCallback cb, Object ctx) throws InterruptedException, BKException {
        QuorumEngine.Operation.AddOp r = new QuorumEngine.Operation.AddOp(this, data, cb, ctx);
        this.qe.sendOp(r);
    }

    public long addEntry(byte[] data) throws InterruptedException, BKException {
        LOG.debug((Object)("Adding entry " + data));
        RetCounter counter = new RetCounter();
        counter.inc();
        QuorumEngine.Operation.AddOp r = new QuorumEngine.Operation.AddOp(this, data, this, counter);
        this.qe.sendOp(r);
        counter.block(0);
        return counter.getrc();
    }

    @Override
    public void readComplete(int rc, LedgerHandle lh, LedgerSequence seq, Object ctx) {
        RetCounter counter = (RetCounter)ctx;
        counter.setSequence(seq);
        LOG.debug((Object)("Read complete: " + seq.size() + ", " + counter.i));
        counter.dec();
    }

    @Override
    public void addComplete(int rc, LedgerHandle lh, long entry, Object ctx) {
        RetCounter counter = (RetCounter)ctx;
        counter.setrc(rc);
        counter.dec();
    }

    private static class RetCounter {
        int i;
        int rc;
        int total;
        LedgerSequence seq = null;

        private RetCounter() {
        }

        synchronized void inc() {
            ++this.i;
            ++this.total;
        }

        synchronized void dec() {
            --this.i;
            this.notifyAll();
        }

        synchronized void block(int limit) throws InterruptedException {
            while (this.i > limit) {
                int prev = this.i;
                this.wait(15000L);
                if (this.i != prev) continue;
                break;
            }
        }

        synchronized int total() {
            return this.total;
        }

        void setrc(int rc) {
            this.rc = rc;
        }

        int getrc() {
            return this.rc;
        }

        void setSequence(LedgerSequence seq) {
            this.seq = seq;
        }

        LedgerSequence getSequence() {
            return this.seq;
        }
    }

    public static enum QMode {
        VERIFIABLE,
        GENERIC,
        FREEFORM;

    }
}

