/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookieHandle;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.QuorumEngine;
import org.apache.log4j.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class LedgerManagementProcessor
extends Thread
implements AsyncCallback.StatCallback,
AsyncCallback.StringCallback,
AsyncCallback.ChildrenCallback,
AsyncCallback.DataCallback {
    Logger LOG = Logger.getLogger(LedgerManagementProcessor.class);
    static final int MAXATTEMPTS = 3;
    BookKeeper bk;
    ArrayBlockingQueue<LedgerOp> outstandingRequests = new ArrayBlockingQueue(200);

    void addOp(LedgerOp op) throws InterruptedException {
        this.LOG.info((Object)"Queuing new op");
        this.outstandingRequests.put(op);
    }

    LedgerManagementProcessor(BookKeeper bk) {
        this.bk = bk;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    LedgerOp op = this.outstandingRequests.take();
                    switch (op.getType()) {
                        case CREATE: {
                            this.processCreate((CreateLedgerOp)op);
                            break;
                        }
                        case OPEN: {
                            this.processOpen((OpenLedgerOp)op);
                            break;
                        }
                        case CLOSE: {
                            this.processClose((CloseLedgerOp)op);
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                this.LOG.warn((Object)"Interrupted while waiting in the queue of incoming requests");
                continue;
            }
            break;
        }
    }

    private void processCreate(CreateLedgerOp cop) throws InterruptedException {
        if (cop.getRC() != 0) {
            cop.getCb().createComplete(cop.getRC(), null, cop.getCtx());
        }
        switch (cop.getAction()) {
            case 0: {
                this.LOG.info((Object)"Action 0 of create");
                this.bk.getZooKeeper().create("/ledgers/L", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL, (AsyncCallback.StringCallback)this, (Object)cop);
                break;
            }
            case 1: {
                this.LOG.info((Object)"Action 1 of create");
                String[] parts = cop.getPath().split("/");
                String[] subparts = parts[2].split("L");
                long lId = Long.parseLong(subparts[1]);
                cop.setLid(lId);
                LedgerHandle lh = new LedgerHandle(this.bk, lId, 0L, cop.getQuorumSize(), cop.getMode(), cop.getPasswd());
                cop.setLh(lh);
                this.bk.getZooKeeper().getChildren("/ledgers/available", false, (AsyncCallback.ChildrenCallback)this, (Object)cop);
                this.bk.getZooKeeper().create("/ledgers/L" + this.bk.getZKStringId(lId) + "/ensemble", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, (AsyncCallback.StringCallback)this, (Object)cop);
                ByteBuffer bb = ByteBuffer.allocate(4);
                bb.putInt(cop.getQuorumSize());
                this.bk.getZooKeeper().create("/ledgers/L" + this.bk.getZKStringId(lId) + cop.getQuorumSize(), bb.array(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, (AsyncCallback.StringCallback)this, (Object)cop);
                bb = ByteBuffer.allocate(4);
                bb.putInt(cop.getMode().ordinal());
                this.bk.getZooKeeper().create("/ledgers/L" + this.bk.getZKStringId(lId) + (Object)((Object)cop.getMode()), bb.array(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, (AsyncCallback.StringCallback)this, (Object)cop);
                break;
            }
            case 2: {
                this.LOG.info((Object)"Action 2 of create");
                Random r = new Random();
                List<String> children = cop.getAvailable();
                for (int i = 0; i < cop.getEnsembleSize(); ++i) {
                    int index = 0;
                    if (children.size() > 1) {
                        index = r.nextInt(children.size() - 1);
                    } else if (children.size() == 1) {
                        index = 0;
                    } else {
                        this.LOG.error((Object)"Not enough bookies available");
                        cop.setRC(-1);
                    }
                    try {
                        String bookie = children.remove(index);
                        this.LOG.info((Object)("Bookie: " + bookie));
                        InetSocketAddress tAddr = this.bk.parseAddr(bookie);
                        int bindex = cop.getLh().addBookieForWriting(tAddr);
                        ByteBuffer bindexBuf = ByteBuffer.allocate(4);
                        bindexBuf.putInt(bindex);
                        String pBookie = "/" + bookie;
                        cop.zkOpCounter.getAndIncrement();
                        this.bk.getZooKeeper().create("/ledgers/L" + this.bk.getZKStringId(cop.getLid()) + "/ensemble" + pBookie, bindexBuf.array(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, (AsyncCallback.StringCallback)this, (Object)cop);
                        continue;
                    }
                    catch (IOException e) {
                        this.LOG.error((Object)e);
                        --i;
                    }
                }
                break;
            }
            case 3: {
                this.LOG.info((Object)"Action 3 of create");
                this.LOG.debug((Object)"Created new ledger");
                cop.getCb().createComplete(cop.getRC(), cop.getLh(), cop.getCtx());
                break;
            }
        }
    }

    private void processOpen(OpenLedgerOp oop) throws InterruptedException {
        if (oop.getRC() != 0) {
            oop.getCb().openComplete(oop.getRC(), null, oop.getCtx());
        }
        switch (oop.getAction()) {
            case 0: {
                this.bk.getZooKeeper().exists("/ledgers/L" + this.bk.getZKStringId(oop.getLid()), false, (AsyncCallback.StatCallback)this, (Object)oop);
                break;
            }
            case 1: {
                this.bk.getZooKeeper().getData("/ledgers/L" + this.bk.getZKStringId(oop.getLid()) + "/quorum", false, (AsyncCallback.DataCallback)this, (Object)oop);
                break;
            }
            case 2: {
                long last = 0L;
                this.LOG.debug((Object)("Close path: /ledgers/L" + this.bk.getZKStringId(oop.getLid()) + "/close"));
                this.bk.getZooKeeper().exists("/ledgers/L" + this.bk.getZKStringId(oop.getLid()) + "/close", false, (AsyncCallback.StatCallback)this, (Object)oop);
                break;
            }
            case 3: {
                try {
                    this.bk.recoverLedger(oop.getLid(), oop.getPasswd());
                }
                catch (Exception e) {
                    this.LOG.error((Object)"Cannot recover ledger", (Throwable)e);
                    oop.getCb().openComplete(-3, null, oop.getCtx());
                }
            }
            case 4: {
                this.bk.getZooKeeper().getData("/ledgers/L" + this.bk.getZKStringId(oop.getLid()) + "/close", false, (AsyncCallback.DataCallback)this, (Object)oop);
                break;
            }
            case 5: {
                this.bk.getZooKeeper().getData("/ledgers/L" + this.bk.getZKStringId(oop.getLid()) + "/mode", false, (AsyncCallback.DataCallback)this, (Object)oop);
            }
            case 6: {
                LedgerHandle lh = new LedgerHandle(this.bk, oop.getLid(), oop.getLast(), oop.getQSize(), oop.getQMode(), oop.getPasswd());
                this.bk.getZooKeeper().getChildren("/ledgers/L" + this.bk.getZKStringId(oop.getLid()) + "/ensemble", false, (AsyncCallback.ChildrenCallback)this, (Object)oop);
                break;
            }
            case 7: {
                List<String> list = oop.getChildren();
                this.LOG.info((Object)("Length of list of bookies: " + list.size()));
                try {
                    for (int i = 0; i < list.size(); ++i) {
                        for (String s : list) {
                            byte[] bindex = this.bk.getZooKeeper().getData("/ledgers/L" + this.bk.getZKStringId(oop.getLid()) + "/ensemble" + "/" + s, false, new Stat());
                            ByteBuffer bindexBuf = ByteBuffer.wrap(bindex);
                            if (bindexBuf.getInt() != i) continue;
                            oop.getLh().addBookieForReading(this.bk.parseAddr(s));
                        }
                    }
                    this.bk.getZooKeeper().exists("/ledgers/L" + this.bk.getZKStringId(oop.getLid()) + "/quorum_evolution", false, (AsyncCallback.StatCallback)this, (Object)oop);
                }
                catch (KeeperException e) {
                    this.LOG.error((Object)"Exception while adding bookies", (Throwable)e);
                    oop.setRC(-4);
                    oop.getCb().openComplete(oop.getRC(), oop.getLh(), oop.getCtx());
                }
                catch (IOException e) {
                    this.LOG.error((Object)"Exception while trying to connect to bookie");
                    oop.setRC(-5);
                    oop.getCb().openComplete(oop.getRC(), oop.getLh(), oop.getCtx());
                }
                break;
            }
            case 8: {
                String path = "/ledgers/L" + this.bk.getZKStringId(oop.getLid()) + "/quorum_evolution";
                this.bk.getZooKeeper().getChildren(path, false, (AsyncCallback.ChildrenCallback)this, (Object)oop);
            }
            case 9: {
                oop.getCb().openComplete(oop.getRC(), oop.getLh(), oop.getCtx());
                break;
            }
            case 10: {
                String path = "/ledgers/L" + this.bk.getZKStringId(oop.getLid()) + "/quorum_evolution";
                for (String s : oop.getChildren()) {
                    oop.setItem(s);
                    this.bk.getZooKeeper().getData(path + "/" + s, false, (AsyncCallback.DataCallback)this, (Object)oop);
                }
                break;
            }
            case 11: {
                LedgerHandle lh = oop.getLh();
                String[] parts = oop.getStringData().split(" ");
                ArrayList<BookieHandle> newBookieSet = new ArrayList<BookieHandle>();
                for (int i = 0; i < parts.length; ++i) {
                    this.LOG.info((Object)("Address: " + parts[i]));
                    InetSocketAddress faultyBookie = this.bk.parseAddr(parts[i].substring(1));
                    newBookieSet.add(lh.getBookieHandleDup(faultyBookie));
                }
                lh.setNewBookieConfig(Long.parseLong(oop.getItem()), newBookieSet);
                if (oop.counter.incrementAndGet() != oop.getListSize()) break;
                lh.prepareEntryChange();
                oop.getCb().openComplete(oop.getRC(), oop.getLh(), oop.getCtx());
            }
        }
    }

    private void processClose(CloseLedgerOp clop) throws InterruptedException {
        if (clop.getRC() != 0) {
            clop.getCb().closeComplete(clop.getRC(), clop.getLh(), clop.getCtx());
        }
        switch (clop.getAction()) {
            case 0: {
                this.LOG.info((Object)("Last saved on ZK is: " + clop.getLh().getLast()));
                clop.setClosePath("/ledgers/L" + this.bk.getZKStringId(this.getId()) + "/close");
                this.bk.getZooKeeper().exists(clop.getClosePath(), null, (AsyncCallback.StatCallback)this, (Object)clop);
                break;
            }
            case 1: {
                if (clop.getStat() == null) {
                    this.bk.getZooKeeper().create(clop.getClosePath(), clop.getLast().array(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, (AsyncCallback.StringCallback)this, (Object)clop);
                    break;
                }
                this.bk.getZooKeeper().setData(clop.getClosePath(), clop.getLast().array(), -1, (AsyncCallback.StatCallback)this, (Object)clop);
                break;
            }
            case 2: {
                LedgerHandle lh = clop.getLh();
                try {
                    lh.closeUp();
                    QuorumEngine.Operation.StopOp sOp = new QuorumEngine.Operation.StopOp();
                    lh.getQuorumEngine().sendOp(sOp);
                }
                catch (Exception e) {
                    this.LOG.warn((Object)("Exception while stopping quorum engine: " + lh.getId()));
                }
                clop.getCb().closeComplete(0, clop.getLh(), clop.getCtx());
            }
        }
    }

    public void processResult(int rc, String path, Object ctx, Stat stat) {
        LedgerOp op = (LedgerOp)ctx;
        if (rc != 0) {
            op.setRC(rc);
            while (true) {
                try {
                    this.addOp(op);
                    return;
                }
                catch (InterruptedException e) {
                    this.LOG.warn((Object)"Interrupted while trying to add operation to queue", (Throwable)e);
                    continue;
                }
                break;
            }
        }
        switch (op.getType()) {
            case CREATE: {
                break;
            }
            case OPEN: {
                switch (op.getAction()) {
                    case 0: {
                        if (stat != null) break;
                        op.setRC(-2);
                        break;
                    }
                    case 2: {
                        if (stat == null) {
                            op.setAction(3);
                            break;
                        }
                        op.setAction(4);
                        break;
                    }
                    case 8: {
                        if (stat == null) {
                            op.setAction(9);
                            break;
                        }
                        op.setAction(10);
                    }
                }
            }
            case CLOSE: {
                CloseLedgerOp clop = (CloseLedgerOp)op;
                clop.setStat(stat);
                clop.setAction(1);
            }
        }
        int counter = 0;
        boolean leave = false;
        while (!leave) {
            try {
                this.addOp(op);
                leave = true;
            }
            catch (InterruptedException e) {
                if (counter++ > 3) {
                    this.LOG.error((Object)"Exceed maximum number of attempts");
                    leave = true;
                    continue;
                }
                this.LOG.warn((Object)"Interrupted while trying to add operation to queue", (Throwable)e);
            }
        }
    }

    public void processResult(int rc, String path, Object ctx, String name) {
        LedgerOp op = (LedgerOp)ctx;
        if (rc != 0) {
            op.setRC(rc);
        } else {
            switch (op.getType()) {
                case CREATE: {
                    CreateLedgerOp cop = (CreateLedgerOp)op;
                    int counter = cop.zkOpCounter.decrementAndGet();
                    if (op.getAction() == 0) {
                        cop.setAction(1);
                        cop.setPath(name);
                        op.setRC(rc);
                    } else if (counter == 0) {
                        cop.setAction(3);
                    } else {
                        return;
                    }
                    op = cop;
                    break;
                }
                case OPEN: {
                    break;
                }
                case CLOSE: {
                    CloseLedgerOp clop = (CloseLedgerOp)op;
                    clop.setAction(1);
                }
            }
        }
        int counter = 0;
        boolean leave = false;
        while (!leave) {
            try {
                this.addOp(op);
                leave = true;
            }
            catch (InterruptedException e) {
                if (counter++ > 3) {
                    this.LOG.error((Object)"Exceed maximum number of attempts");
                    leave = true;
                    continue;
                }
                this.LOG.warn((Object)"Interrupted while trying to add operation to queue", (Throwable)e);
            }
        }
        this.LOG.info((Object)"Leaving loop");
    }

    public void processResult(int rc, String path, Object ctx, List<String> children) {
        LedgerOp op = (LedgerOp)ctx;
        this.LOG.info((Object)"Processing children callback");
        if (rc != 0) {
            op.setRC(rc);
        } else {
            switch (op.getType()) {
                case CREATE: {
                    CreateLedgerOp cop = (CreateLedgerOp)op;
                    cop.addAvailable(children);
                    int counter = cop.zkOpCounter.decrementAndGet();
                    this.LOG.info((Object)("ZK Op counter value: " + counter));
                    cop.setAction(2);
                    op = cop;
                    break;
                }
                case OPEN: {
                    OpenLedgerOp oop = (OpenLedgerOp)op;
                    oop.addChildren(children);
                }
            }
        }
        int counter = 0;
        boolean leave = false;
        while (!leave) {
            try {
                this.addOp(op);
                leave = true;
            }
            catch (InterruptedException e) {
                if (counter++ > 3) {
                    this.LOG.error((Object)"Exceed maximum number of attempts");
                    leave = true;
                    continue;
                }
                this.LOG.warn((Object)"Interrupted while trying to add operation to queue", (Throwable)e);
            }
        }
    }

    public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
        LedgerOp op = (LedgerOp)ctx;
        if (rc != 0) {
            op.setRC(rc);
        } else {
            switch (op.getType()) {
                case OPEN: {
                    OpenLedgerOp oop = (OpenLedgerOp)op;
                    block4 : switch (oop.getAction()) {
                        case 1: {
                            oop.setQSize(data);
                            break;
                        }
                        case 4: {
                            ByteBuffer bb = ByteBuffer.wrap(data);
                            oop.setLast(bb.getLong());
                            break;
                        }
                        case 5: {
                            ByteBuffer bb = ByteBuffer.wrap(data);
                            switch (bb.getInt()) {
                                case 1: {
                                    oop.setQMode(LedgerHandle.QMode.GENERIC);
                                    this.LOG.info((Object)"Generic ledger");
                                    break block4;
                                }
                                case 2: {
                                    oop.setQMode(LedgerHandle.QMode.FREEFORM);
                                    break block4;
                                }
                            }
                            oop.setQMode(LedgerHandle.QMode.VERIFIABLE);
                            this.LOG.info((Object)"Verifiable ledger");
                            break;
                        }
                        case 10: {
                            String addr = new String(data);
                            oop.setStringData(addr);
                            oop.setAction(11);
                        }
                    }
                    break;
                }
                default: {
                    this.LOG.warn((Object)"Wrong type");
                }
            }
        }
        int counter = 0;
        boolean leave = false;
        while (!leave) {
            try {
                this.addOp(op);
                leave = true;
            }
            catch (InterruptedException e) {
                if (counter++ > 3) {
                    this.LOG.error((Object)"Exceed maximum number of attempts");
                    leave = true;
                    continue;
                }
                this.LOG.warn((Object)"Interrupted while trying to add operation to queue", (Throwable)e);
            }
        }
    }

    static class CloseLedgerOp
    extends LedgerOp {
        private long lid;
        private ByteBuffer last;
        private String closePath;
        private AsyncCallback.CloseCallback cb;
        private Stat stat;

        CloseLedgerOp(LedgerHandle lh, AsyncCallback.CloseCallback cb, Object ctx) {
            super(OpType.CLOSE, ctx);
            this.setLh(lh);
            this.lid = lh.getId();
            this.last = ByteBuffer.allocate(8);
            this.last.putLong(lh.getAddConfirmed());
            this.cb = cb;
        }

        ByteBuffer getLast() {
            return this.last;
        }

        long getLid() {
            return this.lid;
        }

        void setClosePath(String path) {
            this.closePath = path;
        }

        String getClosePath() {
            return this.closePath;
        }

        AsyncCallback.CloseCallback getCb() {
            return this.cb;
        }

        void setStat(Stat stat) {
            this.stat = stat;
        }

        Stat getStat() {
            return this.stat;
        }
    }

    static class OpenLedgerOp
    extends LedgerOp {
        private long lId;
        private byte[] passwd;
        private AsyncCallback.OpenCallback cb;
        private int qSize;
        private long last;
        private LedgerHandle.QMode qMode;
        private List<String> children;
        private String dataString;
        private String item;
        private AtomicInteger counter;

        OpenLedgerOp(long lId, byte[] passwd, AsyncCallback.OpenCallback cb, Object ctx) {
            super(OpType.OPEN, ctx);
            this.lId = lId;
            this.passwd = passwd;
        }

        long getLid() {
            return this.lId;
        }

        byte[] getPasswd() {
            return this.passwd;
        }

        AsyncCallback.OpenCallback getCb() {
            return this.cb;
        }

        void setQSize(byte[] data) {
            ByteBuffer bb = ByteBuffer.wrap(data);
            this.qSize = bb.getInt();
        }

        int getQSize() {
            return this.qSize;
        }

        void setLast(long last) {
            this.last = last;
        }

        long getLast() {
            return this.last;
        }

        void setQMode(LedgerHandle.QMode mode) {
            this.qMode = mode;
        }

        LedgerHandle.QMode getQMode() {
            return this.qMode;
        }

        void addChildren(List<String> list) {
            this.children = list;
        }

        List<String> getChildren() {
            return this.children;
        }

        int getListSize() {
            return this.children.size();
        }

        void setItem(String item) {
            this.item = item;
        }

        String getItem() {
            return this.item;
        }

        void setStringData(String data) {
            this.dataString = data;
        }

        String getStringData() {
            return this.dataString;
        }
    }

    static class CreateLedgerOp
    extends LedgerOp {
        private long lId;
        private int ensSize;
        private int qSize;
        private LedgerHandle.QMode mode;
        private byte[] passwd;
        private AsyncCallback.CreateCallback cb;
        private List<String> available;
        private String path;
        AtomicInteger zkOpCounter;

        CreateLedgerOp(int ensSize, int qSize, LedgerHandle.QMode mode, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx) throws BKException {
            super(OpType.CREATE, ctx);
            this.ensSize = ensSize;
            this.qSize = qSize;
            this.mode = mode;
            this.passwd = passwd;
            this.cb = cb;
            this.zkOpCounter = new AtomicInteger(5);
            switch (mode) {
                case VERIFIABLE: {
                    long t = Math.round(Math.floor((ensSize - 1) / 2));
                    if (t != 0L) break;
                    throw BKException.create(-2);
                }
                case GENERIC: {
                    long t = Math.round(Math.floor((ensSize - 1) / 3));
                    if (t != 0L) break;
                    throw BKException.create(-2);
                }
            }
        }

        CreateLedgerOp(CreateLedgerOp op) {
            super(OpType.CREATE, op.getCtx());
            this.setRC(op.getRC());
            this.setAction(op.getAction());
            this.setLh(op.getLh());
            this.lId = op.getLid();
            this.ensSize = op.getEnsembleSize();
            this.qSize = op.getQuorumSize();
            this.mode = op.getMode();
            this.passwd = op.getPasswd();
            this.cb = op.getCb();
            this.available = op.getAvailable();
            this.path = op.getPath();
            this.zkOpCounter = op.zkOpCounter;
        }

        void setLid(long lId) {
            this.lId = lId;
        }

        long getLid() {
            return this.lId;
        }

        int getEnsembleSize() {
            return this.ensSize;
        }

        int getQuorumSize() {
            return this.qSize;
        }

        LedgerHandle.QMode getMode() {
            return this.mode;
        }

        byte[] getPasswd() {
            return this.passwd;
        }

        AsyncCallback.CreateCallback getCb() {
            return this.cb;
        }

        void addAvailable(List<String> available) {
            this.available = available;
        }

        List<String> getAvailable() {
            return this.available;
        }

        void setPath(String path) {
            this.path = path;
        }

        String getPath() {
            return this.path;
        }
    }

    static class LedgerOp {
        private OpType op;
        private int action;
        private int rc = 0;
        private Object ctx;
        private LedgerHandle lh;

        LedgerOp(OpType op, Object ctx) {
            this.op = op;
            this.ctx = ctx;
            this.action = 0;
        }

        OpType getType() {
            return this.op;
        }

        int setAction(int action) {
            this.action = action;
            return this.action;
        }

        int getAction() {
            return this.action;
        }

        void setRC(int rc) {
            this.rc = rc;
        }

        int getRC() {
            return this.rc;
        }

        Object getCtx() {
            return this.ctx;
        }

        void setLh(LedgerHandle lh) {
            this.lh = lh;
        }

        LedgerHandle getLh() {
            return this.lh;
        }
    }

    static enum OpType {
        CREATE,
        OPEN,
        CLOSE;

    }
}

