/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerSequence;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.ReadEntryCallback;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;

class LedgerRecoveryMonitor
implements ReadEntryCallback {
    Logger LOG = Logger.getLogger(LedgerRecoveryMonitor.class);
    BookKeeper self;
    long lId;
    int qSize;
    LedgerHandle.QMode qMode;
    ArrayList<InetSocketAddress> bookies;
    ArrayList<BookieClient> clients;
    HashMap<Long, ArrayList<ByteBuffer>> votes;
    TreeMap<Long, Integer> hints;
    AtomicInteger counter;
    private int minimum;

    LedgerRecoveryMonitor(BookKeeper self, long lId, int qSize, ArrayList<InetSocketAddress> bookies, LedgerHandle.QMode qMode) {
        this.self = self;
        this.lId = lId;
        this.qSize = qSize;
        this.qMode = qMode;
        this.bookies = bookies;
        this.clients = new ArrayList();
        this.votes = new HashMap();
        this.hints = new TreeMap();
        this.counter = new AtomicInteger(0);
        this.minimum = bookies.size();
        if (qMode == LedgerHandle.QMode.VERIFIABLE) {
            this.minimum += 1 - qSize;
        } else if (qMode == LedgerHandle.QMode.GENERIC) {
            this.minimum = (int)((double)this.minimum - Math.floor(qSize / 2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recover(byte[] passwd) throws IOException, InterruptedException, BKException, KeeperException {
        for (InetSocketAddress s : this.bookies) {
            this.LOG.info((Object)s);
            BookieClient client = new BookieClient(s, 3000);
            this.clients.add(client);
            client.readEntry(this.lId, -1L, this, null);
        }
        AtomicInteger i$ = this.counter;
        synchronized (i$) {
            this.LOG.info((Object)("Counter: " + this.counter.get() + ", " + this.minimum + ", " + (Object)((Object)this.qMode)));
            if (this.counter.get() < this.minimum) {
                this.LOG.info((Object)"Waiting...");
                this.counter.wait(5000L);
            }
        }
        LedgerHandle lh = new LedgerHandle(this.self, this.lId, 0L, this.qSize, this.qMode, passwd);
        for (InetSocketAddress addr : this.bookies) {
            lh.addBookieForReading(addr);
        }
        boolean notLegitimate = true;
        long readCounter = 0L;
        while (notLegitimate && (readCounter = this.getNextHint()) > -1L) {
            lh.setLast(readCounter);
            boolean hasMore = true;
            while (hasMore) {
                hasMore = false;
                this.LOG.debug((Object)("Recovering: " + lh.getLast()));
                LedgerSequence ls = lh.readEntries(lh.getLast(), lh.getLast());
                this.LOG.debug((Object)("Received entry for: " + lh.getLast()));
                byte[] le = ls.nextElement().getEntry();
                if (le == null) continue;
                if (notLegitimate) {
                    notLegitimate = false;
                }
                lh.addEntry(le);
                hasMore = true;
            }
        }
        if (!notLegitimate) {
            lh.setAddConfirmed(readCounter);
            lh.close();
            return true;
        }
        lh.setLast(0L);
        lh.close();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuffer bb, Object ctx) {
        if (rc == 0) {
            bb.rewind();
            if (!this.votes.containsKey(entryId)) {
                this.votes.put(entryId, new ArrayList());
            }
            this.votes.get(entryId).add(bb);
            bb.position(16);
            long hint = bb.getLong();
            this.LOG.info((Object)("Received a response: " + rc + ", " + entryId + ", " + hint));
            if (!this.hints.containsKey(hint)) {
                this.hints.put(hint, 0);
            }
            this.hints.put(hint, this.hints.get(hint) + 1);
            AtomicInteger atomicInteger = this.counter;
            synchronized (atomicInteger) {
                if (this.counter.incrementAndGet() >= this.minimum) {
                    // empty if block
                }
                this.counter.notify();
            }
        } else {
            this.LOG.debug((Object)"rc != 0");
        }
    }

    private long getNextHint() {
        if (this.hints.size() == 0) {
            return -1L;
        }
        long hint = this.hints.lastKey();
        this.hints.remove(hint);
        return hint;
    }
}

